# 2023-12-05 Triage Log

A small number of perf changes that unfortunately led to quite a few perf regressions. A large chunk of those regressions were in rustdoc and were considered acceptable since rustdoc is now doing strictly more work. Some other regressions have already been fixed and will hopefully soon be merged. The last of the regressions are still under investigation, but hopefully they will be resolved soon.

Triage done by **@rylev**.
Revision range: [df0295f0..9358642e](https://perf.rust-lang.org/?start=df0295f07175acc7325ce3ca4152eb05752af1f2&end=9358642e3b8560eee89e6f40aa996c8394a3db31&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.0%  | [0.2%, 12.3%]  | 53    |
| Regressions ❌ <br /> (secondary)  | 4.1%  | [0.2%, 11.6%]  | 102   |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.1%] | 65    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.2%, -0.2%] | 25    |
| All ❌✅ (primary)                 | 1.1%  | [-0.5%, 12.3%] | 118   |


4 Regressions, 1 Improvements, 1 Mixed; 1 of them in rollups
60 artifact comparisons made in total

#### Regressions

Rollup of 5 pull requests [#118473](https://github.com/rust-lang/rust/pull/118473) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c52b8763bf36027f24baabe1f97cab3d3571c9e5&end=1670ff64bf1ccb2ad71068254b53725631c55864&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.4% | [1.4%, 1.4%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.1% | [0.1%, 0.1%] | 3     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.4% | [1.4%, 1.4%] | 1     |
- Noise


Restore `#![no_builtins]` crates participation in LTO. [#113923](https://github.com/rust-lang/rust/pull/113923) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9cf18e98f82d85fa41141391d54485b8747da46f&end=8c2b57721728233e074db69d93517614de338055&stat=instructions:u)

| (instructions:u)                   | mean | range         | count |
|:----------------------------------:|:----:|:-------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 6.4% | [0.8%, 12.4%] | 17    |
| Regressions ❌ <br /> (secondary)  | 5.3% | [0.5%, 12.2%] | 72    |
| Improvements ✅ <br /> (primary)   | -    | -             | 0     |
| Improvements ✅ <br /> (secondary) | -    | -             | 0     |
| All ❌✅ (primary)                 | 6.4% | [0.8%, 12.4%] | 17    |
- Builtin function symbols that erroneously do not get GCed
- [#118568](https://github.com/rust-lang/rust/pull/118568) seems to reverse these perf regressions.


Portable SIMD subtree update [#118077](https://github.com/rust-lang/rust/pull/118077) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0908f173fd884ae90584e0b0bca83cb270c23936&end=3f1e30a0a595f1d29fb10d41d9a58811ffdefb6a&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.3%, 2.1%] | 14    |
| Regressions ❌ <br /> (secondary)  | 1.3% | [0.2%, 2.2%] | 23    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.3%, 2.1%] | 14    |
- All doc regressions due to more docs being generated and thus acceptable


Add an assume that the index is inbounds to slice::get_unchecked [#116915](https://github.com/rust-lang/rust/pull/116915) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c9808f87028e16d134438787cab3d4cc16d05fe2&end=85a4bd8f5873aa3ec5eb38baf63b89aa9bd21a7b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.5%  | [0.3%, 4.5%]   | 10    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.3%, 0.6%]   | 3     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.5%, -0.5%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 2.2%  | [-0.5%, 4.5%]  | 11    |
- Still under investigation and perhaps a revert is called for


#### Improvements

resolve: Feed the `def_kind` query immediately on `DefId` creation [#118188](https://github.com/rust-lang/rust/pull/118188) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=df0295f07175acc7325ce3ca4152eb05752af1f2&end=5facb422f8a5a61df515572fe79b02433639d565&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 58    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.0%, -0.1%] | 34    |
| All ❌✅ (primary)                 | -0.3% | [-0.5%, -0.2%] | 58    |


#### Mixed

add track_caller for arith ops [#114841](https://github.com/rust-lang/rust/pull/114841) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bbefc9837f4157cc09ed60e6d7b21e345d582dd9&end=b1e56deadaf4b08cd591feaa1a1283348298427d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.4%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.2%, 1.3%]   | 12    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.2%] | 3     |
| All ❌✅ (primary)                 | 0.3%  | [0.2%, 0.4%]   | 6     |
- Only really affecting rustdoc which is an acceptable tradeoff given the wins in diagnostics

