## Usage

```js
var parsePath = require('{%= name %}');
parsePath(filepath);
```

This can be used as a polyfill for the native node.js `path.parse()` method, and it also adds a few properties:

- `path`: the original filepath
- `isAbsolute`: (getter) true if the given path is absolute
- `absolute`: (getter) fully resolved, absolute filepath
- `dirname`: alias for `dir`
- `basename`: alias for `base`
- `extname`: alias for `ext`
- `stem`: alias for `name`

**Example**

```js
var parsePath = require('{%= name %}');
console.log(parsePath('foo/bar/baz/index.js'));
```

Returns:

```js
{ root: '',
  dir: 'foo/bar/baz',
  base: 'index.js',
  ext: '.js',
  name: 'index',

  // aliases
  extname: '.js',
  basename: 'index.js',
  dirname: 'foo/bar/baz',
  stem: 'index',

  // original path
  path: 'foo/bar/baz/index.js',

  // getters
  absolute: [Getter/Setter],
  isAbsolute: [Getter/Setter] }
```
