'\" t
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface, \fRO'Reilly and Associates, Sebastopol, 1991.
.ds xC Inter-Client Communication Conventions Manual
'\" t
.TH XAllocWMHints __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XAllocWMHints, XSetWMHints, XGetWMHints, XWMHints \- allocate window manager hints structure and set or read a window's WM_HINTS property
.SH SYNTAX
.HP
XWMHints *XAllocWMHints\^(void\^);
.HP
int XSetWMHints\^(\^Display *\fIdisplay\fP, Window \fIw\fP, XWMHints *\fIwmhints\fP\^);
.HP
XWMHints *XGetWMHints\^(\^Display *\fIdisplay\fP, Window \fIw\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIw\fP 1i
Specifies the window.
.IP \fIwmhints\fP 1i
Specifies the
.B XWMHints
structure to be used.
.SH DESCRIPTION
The
.B XAllocWMHints
function allocates and returns a pointer to a
.B XWMHints
structure.
Note that all fields in the
.B XWMHints
structure are initially set to zero.
If insufficient memory is available,
.B XAllocWMHints
returns NULL.
To free the memory allocated to this structure,
use
.BR XFree .
.LP
The
.B XSetWMHints
function sets the window manager hints that include icon information and location,
the initial state of the window, and whether the application relies on the
window manager to get keyboard input.
.LP
.B XSetWMHints
can generate
.B BadAlloc
and
.B BadWindow
errors.
.LP
The
.B XGetWMHints
function reads the window manager hints and
returns NULL if no WM_HINTS property was set on the window
or returns a pointer to a
.B XWMHints
structure if it succeeds.
When finished with the data,
free the space used for it by calling
.BR XFree .
.LP
.B XGetWMHints
can generate a
.B BadWindow
error.
.SH PROPERTIES
.TP 1i
\s-1WM_HINTS\s+1
Additional hints set by the client for use by the window manager.
The C type of this property is
.BR XWMHints .
.SH STRUCTURES
The
.B XWMHints
structure contains:
.LP
/\&* Window manager hints mask bits */
.TS
lw(.4i) lw(1.8i) lw(2.5i).
T{
\&#define
T}	T{
.B InputHint
T}	T{
(1L << 0)
T}
T{
\&#define
T}	T{
.B StateHint
T}	T{
(1L << 1)
T}
T{
\&#define
T}	T{
.B IconPixmapHint
T}	T{
(1L << 2)
T}
T{
\&#define
T}	T{
.B IconWindowHint
T}	T{
(1L << 3)
T}
T{
\&#define
T}	T{
.B IconPositionHint
T}	T{
(1L << 4)
T}
T{
\&#define
T}	T{
.B IconMaskHint
T}	T{
(1L << 5)
T}
T{
\&#define
T}	T{
.B WindowGroupHint
T}	T{
(1L << 6)
T}
T{
\&#define
T}	T{
.B XUrgencyHint
T}	T{
(1L << 8)
T}
T{
\&#define
T}	T{
.B AllHints
T}	T{
(InputHint|
.br
 StateHint|
.br
 IconPixmapHint|
.br
 IconWindowHint|
.br
 IconPositionHint|
.br
 IconMaskHint|
.br
 WindowGroupHint)
T}
.TE
.EX
/\&* Values */

typedef struct {
        long flags;     /\&* marks which fields in this structure are defined */
        Bool input;     /\&* does this application rely on the window manager to
                        get keyboard input? */
        int initial_state;      /\&* see below */
        Pixmap icon_pixmap;     /\&* pixmap to be used as icon */
        Window icon_window;     /\&* window to be used as icon */
        int icon_x, icon_y;     /\&* initial position of icon */
        Pixmap icon_mask;       /\&* pixmap to be used as mask for icon_pixmap */
        XID window_group;       /\&* id of related window group */
        /\&* this structure may be extended in the future */
} XWMHints;
.EE
.LP
The input member is used to communicate to the window manager the input focus
model used by the application.
Applications that expect input but never explicitly set focus to any
of their subwindows (that is, use the push model of focus management),
such as X Version 10 style applications that use real-estate
driven focus, should set this member to
.BR True .
Similarly, applications
that set input focus to their subwindows only when it is given to their
top-level window by a window manager should also set this member to
.BR True .
Applications that manage their own input focus by explicitly setting
focus to one of their subwindows whenever they want keyboard input
(that is, use the pull model of focus management) should set this member to
.BR False .
Applications that never expect any keyboard input also should set this member
to
.BR False .
.LP
Pull model window managers should make it possible for push model
applications to get input by setting input focus to the top-level windows of
applications whose input member is
.BR True .
Push model window managers should
make sure that pull model applications do not break them
by resetting input focus to
.B PointerRoot
when it is appropriate (for example, whenever an application whose
input member is
.B False
sets input focus to one of its subwindows).
.LP
The definitions for the initial_state flag are:
.TS
lw(.3i) lw(1.5i) lw(.1i) lw(3.9i).
T{
\&#define
T}	T{
.B WithdrawnState
T}	T{
0
T}	T{
T}
T{
\&#define
T}	T{
.B NormalState
T}	T{
1
T}	T{
/\&* most applications start this way */
T}
T{
\&#define
T}	T{
.B IconicState
T}	T{
3
T}	T{
/\&* application wants to start as an icon */
T}
.TE
The icon_mask specifies which pixels of the icon_pixmap should be used as the
icon.
This allows for nonrectangular icons.
Both icon_pixmap and icon_mask must be bitmaps.
The icon_window lets an application provide a window for use as an icon
for window managers that support such use.
The window_group lets you specify that this window belongs to a group
of other windows.
For example, if a single application manipulates multiple
top-level windows, this allows you to provide enough
information that a window manager can iconify all of the windows
rather than just the one window.
.LP
The
.B UrgencyHint
flag, if set in the flags field, indicates that the client deems the window
contents to be urgent, requiring the timely response of the user.
The
window manager will make some effort to draw the user's attention to this
window while this flag is set.
The client must provide some means by which the
user can cause the urgency flag to be cleared (either mitigating
the condition that made the window urgent or merely shutting off the alarm)
or the window to be withdrawn.
.SH DIAGNOSTICS
.TP 1i
.B BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
.BR XAllocClassHint (__libmansuffix__),
.BR XAllocIconSize (__libmansuffix__),
.BR XAllocSizeHints (__libmansuffix__),
.BR XFree (__libmansuffix__),
.BR XSetCommand (__libmansuffix__),
.BR XSetTransientForHint (__libmansuffix__),
.BR XSetTextProperty (__libmansuffix__),
.BR XSetWMClientMachine (__libmansuffix__),
.BR XSetWMColormapWindows (__libmansuffix__),
.BR XSetWMIconName (__libmansuffix__),
.BR XSetWMName (__libmansuffix__),
.BR XSetWMProperties (__libmansuffix__),
.BR XSetWMProtocols (__libmansuffix__),
.BR XStringListToTextProperty (__libmansuffix__)
.br
\fI\*(xL\fP
