package com.meterware.httpunit.parsing;
/********************************************************************************************************************
 * $Id: DocumentAdapter.java 778 2007-05-16 19:07:49Z russgold $
 *
 * Copyright (c) 2002-2007, Russell Gold
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated
 * documentation files (the "Software"), to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and
 * to permit persons to whom the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO
 * THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 *******************************************************************************************************************/
import com.meterware.httpunit.scripting.ScriptableDelegate;
import com.meterware.httpunit.scripting.ScriptingHandler;

import org.w3c.dom.Document;
import org.w3c.dom.html.HTMLDocument;

import java.io.IOException;


/**
 *
 * @author <a href="mailto:russgold@httpunit.org">Russell Gold</a>
 **/
public interface DocumentAdapter {


    /**
     * Records the root (Document) node.
     */
    public void setDocument( HTMLDocument document );


    /**
     * Returns the contents of an included script, given its src attribute.
     * @param srcAttribute the relative URL for the included script
     * @return the contents of the script.
     * @throws java.io.IOException if there is a problem retrieving the script
     */
    public String getIncludedScript( String srcAttribute ) throws IOException;


    /**
     * Returns the Scriptable object associated with the document
     */
    public ScriptingHandler getScriptingHandler();
}
