/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer.internals;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.TimeoutException;

public final class TransactionalRequestResult {
    private final CountDownLatch latch;
    private volatile RuntimeException error = null;
    private final String operation;
    private volatile boolean isAcked = false;

    public TransactionalRequestResult(String operation) {
        this(new CountDownLatch(1), operation);
    }

    private TransactionalRequestResult(CountDownLatch latch, String operation) {
        this.latch = latch;
        this.operation = operation;
    }

    public void fail(RuntimeException error) {
        this.error = error;
        this.latch.countDown();
    }

    public void done() {
        this.latch.countDown();
    }

    public void await() {
        this.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public void await(long timeout, TimeUnit unit) {
        try {
            boolean success = this.latch.await(timeout, unit);
            if (!success) {
                throw new TimeoutException("Timeout expired after " + unit.toMillis(timeout) + "ms while awaiting " + this.operation);
            }
            this.isAcked = true;
            if (this.error != null) {
                throw this.error;
            }
        }
        catch (InterruptedException e) {
            throw new InterruptException("Received interrupt while awaiting " + this.operation, e);
        }
    }

    public RuntimeException error() {
        return this.error;
    }

    public boolean isSuccessful() {
        return this.isCompleted() && this.error == null;
    }

    public boolean isCompleted() {
        return this.latch.getCount() == 0L;
    }

    public boolean isAcked() {
        return this.isAcked;
    }
}

