"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildConfig = void 0;
var _lodash = require("lodash");
var _operators = require("rxjs/operators");
var _createConfig = require("./createConfig");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const buildConfig = async (initContext, core, logger) => {
  const config$ = initContext.config.create();
  const serverInfo = core.http.getServerInfo();
  const osdConfig = {
    server: {
      basePath: core.http.basePath.serverBasePath,
      host: serverInfo.hostname,
      name: serverInfo.name,
      port: serverInfo.port,
      protocol: serverInfo.protocol
    }
  };
  const reportingConfig$ = (0, _createConfig.createConfig$)(core, config$, logger);
  const reportingConfig = await reportingConfig$.pipe((0, _operators.first)()).toPromise();
  return {
    get: (...keys) => (0, _lodash.get)(reportingConfig, keys.join('.'), null),
    osdConfig: {
      get: (...keys) => (0, _lodash.get)(osdConfig, keys.join('.'), null)
    }
  };
};
exports.buildConfig = buildConfig;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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