/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.test.svg;

import java.io.File;
import org.apache.batik.test.svg.SamplesRenderingTest;

public class ParametrizedRenderingAccuracyTest
extends SamplesRenderingTest {
    public static final char PARAMETER_SEPARATOR = '-';
    protected String parameter;

    public char getParameterSeparator() {
        return '-';
    }

    @Override
    public void setId(String id) {
        String[] variationURLs;
        this.id = id;
        String svgFile = id;
        int n = svgFile.lastIndexOf(this.getParameterSeparator());
        if (n == -1 || n + 1 >= svgFile.length()) {
            throw new IllegalArgumentException(id);
        }
        this.parameter = svgFile.substring(n + 1, svgFile.length());
        svgFile = svgFile.substring(0, n);
        String[] dirNfile = this.breakSVGFile(svgFile);
        this.setConfig(this.buildSVGURL(dirNfile[0], dirNfile[1], dirNfile[2]), this.buildRefImgURL(dirNfile[0], dirNfile[1]));
        for (String variationURL : variationURLs = this.buildVariationURLs(dirNfile[0], dirNfile[1])) {
            this.addVariationURL(variationURL);
        }
        this.setSaveVariation(new File(this.buildSaveVariationFile(dirNfile[0], dirNfile[1])));
        this.setCandidateReference(new File(this.buildCandidateReferenceFile(dirNfile[0], dirNfile[1])));
    }

    @Override
    protected String buildRefImgURL(String svgDir, String svgFile) {
        return this.getRefImagePrefix() + svgDir + this.getRefImageSuffix() + svgFile + this.parameter + ".png";
    }

    @Override
    public String[] buildVariationURLs(String svgDir, String svgFile) {
        String[] platforms = this.getVariationPlatforms();
        String[] urls = new String[platforms.length + 1];
        urls[0] = this.getVariationPrefix() + svgDir + this.getVariationSuffix() + svgFile + this.parameter + ".png";
        for (int i = 0; i < platforms.length; ++i) {
            urls[i + 1] = this.getVariationPrefix() + svgDir + this.getVariationSuffix() + svgFile + this.parameter + '_' + platforms[i] + ".png";
        }
        return urls;
    }

    @Override
    public String buildSaveVariationFile(String svgDir, String svgFile) {
        return this.getSaveVariationPrefix() + svgDir + this.getSaveVariationSuffix() + svgFile + this.parameter + ".png";
    }

    @Override
    public String buildCandidateReferenceFile(String svgDir, String svgFile) {
        return this.getCandidateReferencePrefix() + svgDir + this.getCandidateReferenceSuffix() + svgFile + this.parameter + ".png";
    }
}

