/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.broker;

import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.IntegrityChecker;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingFactory;
import org.eclipse.persistence.internal.sequencing.SequencingHome;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.SessionBrokerIdentityMapAccessor;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseLogin;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.SessionProfiler;
import org.eclipse.persistence.sessions.server.ClientSession;
import org.eclipse.persistence.sessions.server.ConnectionPolicy;
import org.eclipse.persistence.sessions.server.ServerSession;

public class SessionBroker
extends DatabaseSessionImpl {
    protected SessionBroker parent;
    protected Map<Class<?>, String> sessionNamesByClass;
    protected Map<String, AbstractSession> sessionsByName = new HashMap<String, AbstractSession>();
    protected Sequencing sequencing;
    protected boolean shouldUseDescriptorAliases;

    public SessionBroker() {
        super(new DatabaseLogin());
        this.sessionNamesByClass = new HashMap();
    }

    protected SessionBroker(Map sessionNames) {
        super(new DatabaseLogin());
        this.sessionNamesByClass = sessionNames;
    }

    public SessionBroker acquireClientSessionBroker() {
        return this.acquireClientSessionBroker(null, null);
    }

    public SessionBroker acquireClientSessionBroker(Map<String, ConnectionPolicy> connectionPolicies, Map mapOfProperties) {
        this.log(2, "connection", "acquire_client_session_broker");
        SessionBroker clientBroker = this.copySessionBroker();
        clientBroker.parent = this;
        clientBroker.getIdentityMapAccessorInstance().setIdentityMapManager(this.getIdentityMapAccessorInstance().getIdentityMapManager());
        clientBroker.commitManager = this.getCommitManager();
        clientBroker.commandManager = this.getCommandManager();
        clientBroker.externalTransactionController = this.getExternalTransactionController();
        clientBroker.setServerPlatform(this.getServerPlatform());
        for (String sessionName : this.getSessionsByName().keySet()) {
            AbstractSession session = this.getSessionForName(sessionName);
            if (session.isServerSession()) {
                ServerSession serverSession = (ServerSession)session;
                if (serverSession.getProject().hasIsolatedCacheClassWithoutUOWIsolation()) {
                    throw ValidationException.isolatedDataNotSupportedInSessionBroker(sessionName);
                }
                ConnectionPolicy connectionPolicy = null;
                if (connectionPolicies != null) {
                    connectionPolicy = connectionPolicies.get(sessionName);
                }
                if (connectionPolicy == null) {
                    connectionPolicy = serverSession.getDefaultConnectionPolicy();
                }
                Map properties = null;
                if (mapOfProperties != null) {
                    properties = (Map)mapOfProperties.get(sessionName);
                }
                clientBroker.registerSession(sessionName, serverSession.acquireClientSession(connectionPolicy, properties));
                continue;
            }
            throw ValidationException.cannotAcquireClientSessionFromSession();
        }
        clientBroker.initializeSequencing();
        return clientBroker;
    }

    @Override
    public Session acquireHistoricalSession(AsOfClause clause) throws ValidationException {
        if (this.isServerSessionBroker()) {
            throw ValidationException.cannotAcquireHistoricalSession();
        }
        SessionBroker historicalBroker = this.copySessionBroker();
        historicalBroker.parent = this;
        for (String sessionName : this.getSessionsByName().keySet()) {
            AbstractSession session = this.getSessionForName(sessionName);
            historicalBroker.registerSession(sessionName, (AbstractSession)session.acquireHistoricalSession(clause));
        }
        return historicalBroker;
    }

    @Override
    public void releaseJTSConnection() {
        RuntimeException exception = null;
        for (AbstractSession session : this.getSessionsByName().values()) {
            try {
                session.releaseJTSConnection();
            }
            catch (RuntimeException ex) {
                if (exception != null) continue;
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public UnitOfWorkImpl acquireUnitOfWork() {
        if (this.isServerSessionBroker()) {
            return this.acquireClientSessionBroker().acquireUnitOfWork();
        }
        return super.acquireUnitOfWork();
    }

    @Override
    public void addDescriptor(ClassDescriptor descriptor) {
        throw ValidationException.cannotAddDescriptorsToSessionBroker();
    }

    public void addDescriptors(Vector descriptors) throws ValidationException {
        throw ValidationException.cannotAddDescriptorsToSessionBroker();
    }

    @Override
    public void addDescriptors(Project project) throws ValidationException {
        throw ValidationException.cannotAddDescriptorsToSessionBroker();
    }

    @Override
    public void addSequence(Sequence sequence) {
        throw ValidationException.cannotAddSequencesToSessionBroker();
    }

    @Override
    protected void basicBeginTransaction() throws DatabaseException {
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.beginTransaction();
        }
    }

    @Override
    protected void basicCommitTransaction() throws DatabaseException {
        for (AbstractSession session : this.getSessionsByName().values()) {
            if (session.isConnected()) continue;
            throw DatabaseException.databaseAccessorNotConnected();
        }
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.commitTransaction();
        }
    }

    @Override
    protected void basicRollbackTransaction() throws DatabaseException {
        DatabaseException globalException = null;
        for (AbstractSession session : this.getSessionsByName().values()) {
            try {
                session.rollbackTransaction();
            }
            catch (DatabaseException exception) {
                globalException = exception;
            }
        }
        if (globalException != null) {
            throw globalException;
        }
    }

    @Override
    public boolean containsQuery(String queryName) {
        boolean containsQuery = this.getQueries().containsKey(queryName);
        if (this.isClientSessionBroker() && !containsQuery) {
            String sessionName2 = null;
            AbstractSession ssession = null;
            for (String sessionName2 : this.getSessionsByName().keySet()) {
                ssession = this.getSessionForName(sessionName2);
                if (!(ssession instanceof ClientSession) || !((ClientSession)ssession).getParent().getBroker().containsQuery(queryName)) continue;
                return true;
            }
        }
        return containsQuery;
    }

    protected SessionBroker copySessionBroker() {
        SessionBroker broker = new SessionBroker(this.getSessionNamesByClass());
        broker.accessors = this.getAccessors();
        broker.name = this.getName();
        broker.isLoggingOff = this.isLoggingOff();
        broker.sessionLog = this.getSessionLog();
        broker.profiler = this.getProfiler();
        broker.isInProfile = this.isInProfile();
        broker.project = this.project;
        if (this.hasEventManager()) {
            broker.eventManager = this.getEventManager().clone(broker);
        }
        broker.exceptionHandler = this.getExceptionHandler();
        broker.descriptors = this.getDescriptors();
        broker.shouldPropagateChanges = this.shouldPropagateChanges;
        return broker;
    }

    @Override
    public Collection<Accessor> getAccessors(Call call, AbstractRecord translationRow, DatabaseQuery query) {
        if (query.getSessionName() != null) {
            return this.getSessionForName(query.getSessionName()).getAccessors(call, translationRow, query);
        }
        if (query.getReferenceClass() == null) {
            throw QueryException.unnamedQueryOnSessionBroker(null);
        }
        return this.getSessionForClass(query.getReferenceClass()).getAccessors(call, translationRow, query);
    }

    @Override
    public AsOfClause getAsOfClause() {
        Iterator<AbstractSession> enumtr = this.getSessionsByName().values().iterator();
        if (enumtr.hasNext()) {
            return enumtr.next().getAsOfClause();
        }
        return null;
    }

    @Override
    public SessionBroker getParent() {
        return this.parent;
    }

    @Override
    public AbstractSession getExecutionSession(DatabaseQuery query) {
        AbstractSession sessionByQuery = this.getSessionForQuery(query);
        return sessionByQuery.getExecutionSession(query);
    }

    @Override
    public Platform getPlatform(Class<?> domainClass) {
        if (domainClass == null) {
            return super.getDatasourcePlatform();
        }
        return this.getSessionForClass(domainClass).getDatasourcePlatform();
    }

    @Override
    public DatabaseQuery getQuery(String name, Vector arguments, boolean shouldSearchParent) {
        SessionBroker parent;
        DatabaseQuery query = super.getQuery(name, arguments, shouldSearchParent);
        if (query != null) {
            return query;
        }
        Iterator<AbstractSession> it = this.sessionsByName.values().iterator();
        while (it.hasNext()) {
            query = it.next().getQuery(name, arguments, false);
            if (query == null) continue;
            return query;
        }
        if (shouldSearchParent && (parent = this.getParent()) != null) {
            return ((AbstractSession)parent).getQuery(name, arguments, true);
        }
        return null;
    }

    @Override
    public AbstractSession getSessionForClass(Class<?> domainClass) throws ValidationException {
        if (domainClass == null) {
            return this;
        }
        String sessionName = this.getSessionNamesByClass().get(domainClass);
        if (sessionName == null) {
            throw ValidationException.noSessionRegisteredForClass(domainClass);
        }
        return this.getSessionsByName().get(sessionName);
    }

    @Override
    public AbstractSession getSessionForName(String name) throws ValidationException {
        AbstractSession sessionByName = this.getSessionsByName().get(name);
        if (sessionByName == null) {
            throw ValidationException.noSessionRegisteredForName(name);
        }
        return sessionByName;
    }

    protected AbstractSession getSessionForQuery(DatabaseQuery query) {
        Class<Object> queryClass;
        if (query.hasSessionName()) {
            return this.getSessionForName(query.getSessionName());
        }
        if (query.getDescriptor() != null) {
            queryClass = query.getDescriptor().getJavaClass();
        } else {
            queryClass = query.getReferenceClass();
            if (queryClass == null) {
                throw QueryException.unnamedQueryOnSessionBroker(query);
            }
        }
        return this.getSessionForClass(queryClass);
    }

    protected Map<Class<?>, String> getSessionNamesByClass() {
        return this.sessionNamesByClass;
    }

    public Map<String, AbstractSession> getSessionsByName() {
        return this.sessionsByName;
    }

    @Override
    public void initializeDescriptors() {
        for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
            String sessionName = databaseSessionImpl.getName();
            for (PartitioningPolicy policy : databaseSessionImpl.getProject().getPartitioningPolicies().values()) {
                policy.initialize(this);
            }
            if (!databaseSessionImpl.isJPAQueriesProcessed()) {
                for (DatabaseQuery query : databaseSessionImpl.getJPAQueries()) {
                    query.setSessionName(sessionName);
                    this.getJPAQueries().add(query);
                }
                databaseSessionImpl.setJPAQueriesProcessed(true);
            }
            for (List<DatabaseQuery> queryList : databaseSessionImpl.getQueries().values()) {
                for (int i = 0; i < queryList.size(); ++i) {
                    queryList.get(i).setSessionName(sessionName);
                }
            }
            databaseSessionImpl.initializeSequencing();
        }
        if (this.hasExternalTransactionController()) {
            this.getExternalTransactionController().initializeSequencingListeners();
        }
        super.initializeDescriptors();
        for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
            if (databaseSessionImpl.getProject().hasGenericHistorySupport()) {
                this.getProject().setHasGenericHistorySupport(true);
            }
            if (databaseSessionImpl.getProject().hasIsolatedClasses()) {
                this.getProject().setHasIsolatedClasses(true);
            }
            if (databaseSessionImpl.getProject().hasMappingsPostCalculateChangesOnDeleted()) {
                this.getProject().setHasMappingsPostCalculateChangesOnDeleted(true);
            }
            if (databaseSessionImpl.getProject().hasNonIsolatedUOWClasses()) {
                this.getProject().setHasNonIsolatedUOWClasses(true);
            }
            if (databaseSessionImpl.getProject().hasProxyIndirection()) {
                this.getProject().setHasProxyIndirection(true);
            }
            this.getProject().getDefaultReadOnlyClasses().addAll(databaseSessionImpl.getProject().getDefaultReadOnlyClasses());
        }
        if (this.isServerSessionBroker()) {
            this.sequencing = null;
        }
    }

    @Override
    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new SessionBrokerIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    @Override
    public Object internalExecuteQuery(DatabaseQuery query, AbstractRecord row) throws DatabaseException, QueryException {
        AbstractSession sessionByQuery = this.getSessionForQuery(query);
        return sessionByQuery.internalExecuteQuery(query, row);
    }

    @Override
    public boolean isBroker() {
        return true;
    }

    public boolean isClientSessionBroker() {
        for (AbstractSession session : this.getSessionsByName().values()) {
            if (!session.isClientSession()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConnected() {
        if (this.getSessionsByName() == null || this.getSessionsByName().isEmpty()) {
            return false;
        }
        for (AbstractSession session : this.getSessionsByName().values()) {
            if (session.isConnected()) continue;
            return false;
        }
        return true;
    }

    public boolean isServerSessionBroker() {
        for (AbstractSession session : this.getSessionsByName().values()) {
            if (!session.isServerSession()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSessionBroker() {
        return true;
    }

    @Override
    public void login() throws DatabaseException {
        this.preConnectDatasource();
        for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
            if (databaseSessionImpl.isConnected()) continue;
            databaseSessionImpl.login();
        }
        this.postConnectDatasource();
    }

    @Override
    public void loginAndDetectDatasource() throws DatabaseException {
        this.preConnectDatasource();
        for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
            if (databaseSessionImpl.isConnected()) continue;
            if (databaseSessionImpl.getDatasourcePlatform().getClass().getName().equals("org.eclipse.persistence.platform.database.DatabasePlatform")) {
                databaseSessionImpl.loginAndDetectDatasource();
                continue;
            }
            databaseSessionImpl.login();
        }
        this.postConnectDatasource();
    }

    @Override
    public void login(String userName, String password) throws DatabaseException {
        this.preConnectDatasource();
        for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
            databaseSessionImpl.getDatasourceLogin().setUserName(userName);
            databaseSessionImpl.getDatasourceLogin().setPassword(password);
            if (databaseSessionImpl.isConnected()) continue;
            databaseSessionImpl.login();
        }
        this.postConnectDatasource();
    }

    @Override
    public void logout() throws DatabaseException {
        if (!this.isLoggedIn) {
            return;
        }
        if (this.eventManager != null) {
            this.eventManager.preLogout(this);
        }
        if (!this.isClientSessionBroker()) {
            for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
                databaseSessionImpl.logout();
            }
        }
        this.sequencing = null;
        this.isLoggedIn = false;
        if (this.eventManager != null) {
            this.eventManager.postLogout(this);
        }
    }

    @Override
    public void postLogin() {
        for (DatabaseSessionImpl databaseSessionImpl : this.getSessionsByName().values()) {
            databaseSessionImpl.postLogin();
        }
        super.postLogin();
    }

    public void registerSession(String name, AbstractSession session) {
        session.setIsInBroker(true);
        this.getSessionsByName().put(name, session);
        session.setBroker(this);
        session.setName(name);
        if (session.isDatabaseSession()) {
            if (this.hasEventManager()) {
                session.getEventManager().getListeners().addAll(this.getEventManager().getListeners());
            }
            Iterator<ClassDescriptor> descriptors = session.getDescriptors().values().iterator();
            Iterator<Class<?>> classes = session.getDescriptors().keySet().iterator();
            while (descriptors.hasNext()) {
                String alias;
                ClassDescriptor descriptor = descriptors.next();
                Class<?> descriptorClass = classes.next();
                this.getSessionNamesByClass().put(descriptorClass, name);
                if (this.shouldUseDescriptorAliases && (alias = descriptor.getAlias()) != null && alias.length() > 0) {
                    ClassDescriptor anotherDescriptor = this.getDescriptorForAlias(alias);
                    if (anotherDescriptor != null && anotherDescriptor.getJavaClass() != descriptor.getJavaClass()) {
                        throw ValidationException.sharedDescriptorAlias(alias, descriptor.getJavaClass().getName(), anotherDescriptor.getJavaClass().getName());
                    }
                    this.addAlias(alias, descriptor);
                }
                this.getDescriptors().put(descriptorClass, descriptor);
            }
        }
    }

    public void registerSession(String name, Session session) {
        this.registerSession(name, (AbstractSession)session);
    }

    @Override
    public void release() {
        if (this.isClientSessionBroker()) {
            this.log(2, "connection", "releasing_client_session_broker");
        }
        RuntimeException exception = null;
        for (AbstractSession session : this.getSessionsByName().values()) {
            try {
                session.release();
            }
            catch (RuntimeException ex) {
                if (exception != null) continue;
                exception = ex;
            }
        }
        super.release();
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public Object retryQuery(DatabaseQuery query, AbstractRecord row, DatabaseException databaseException, int retryCount, AbstractSession executionSession) {
        if (this.isClientSessionBroker()) {
            for (ClientSession clientSession : this.getSessionsByName().values()) {
                clientSession.getParent().releaseInvalidClientSession(clientSession);
            }
        }
        return super.retryQuery(query, row, databaseException, retryCount, executionSession);
    }

    @Override
    public void setExternalTransactionController(ExternalTransactionController externalTransactionController) {
        super.setExternalTransactionController(externalTransactionController);
        for (AbstractSession session : this.getSessionsByName().values()) {
            DatabaseSessionImpl dbSession = (DatabaseSessionImpl)session;
            dbSession.setExternalTransactionController(externalTransactionController);
        }
    }

    @Override
    public void setIntegrityChecker(IntegrityChecker integrityChecker) {
        super.setIntegrityChecker(integrityChecker);
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.setIntegrityChecker(integrityChecker);
        }
    }

    @Override
    public void setSessionLog(SessionLog log) {
        super.setSessionLog(log);
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.setSessionLog(log);
        }
    }

    @Override
    public void setLog(Writer log) {
        super.setLog(log);
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.setLog(log);
        }
    }

    @Override
    public void setProfiler(SessionProfiler profiler) {
        super.setProfiler(profiler);
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.setProfiler(profiler);
        }
    }

    protected void setSessionNameByClass(HashMap sessionNameByClass) {
        this.sessionNamesByClass = sessionNameByClass;
    }

    public void setSessionsByName(Map sessionsByName) {
        this.sessionsByName = sessionsByName;
    }

    @Override
    public void setSynchronized(boolean synched) {
        if (!this.isServerSessionBroker()) {
            super.setSynchronized(synched);
            Iterator<AbstractSession> itSessions = this.getSessionsByName().values().iterator();
            while (itSessions.hasNext()) {
                itSessions.next().setSynchronized(synched);
            }
        }
    }

    @Override
    public void writesCompleted() {
        for (AbstractSession session : this.getSessionsByName().values()) {
            if (session.isConnected()) continue;
            throw DatabaseException.databaseAccessorNotConnected();
        }
        for (AbstractSession session : this.getSessionsByName().values()) {
            session.writesCompleted();
        }
    }

    @Override
    public void initializeSequencing() {
        this.sequencing = SequencingFactory.createSequencing(this);
    }

    @Override
    protected SequencingHome getSequencingHome() {
        return null;
    }

    @Override
    public Sequencing getSequencing() {
        return this.sequencing;
    }

    public int howManySequencingCallbacks() {
        if (this.isClientSessionBroker()) {
            return this.getParent().howManySequencingCallbacks();
        }
        int nCallbacks = 0;
        Iterator<AbstractSession> itSessions = this.getSessionsByName().values().iterator();
        while (itSessions.hasNext()) {
            if (!((DatabaseSessionImpl)itSessions.next()).isSequencingCallbackRequired()) continue;
            ++nCallbacks;
        }
        return nCallbacks;
    }

    @Override
    public boolean isSequencingCallbackRequired() {
        return this.howManySequencingCallbacks() > 0;
    }

    public boolean shouldUseDescriptorAliases() {
        return this.shouldUseDescriptorAliases;
    }

    public void setShouldUseDescriptorAliases(boolean shouldUseDescriptorAliases) {
        this.shouldUseDescriptorAliases = shouldUseDescriptorAliases;
    }
}

