/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.concurrent.RunnableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.state.AsyncSnapshotCallable;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.SnapshotExecutionType;
import org.apache.flink.runtime.state.SnapshotResources;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.SnapshotStrategy;
import org.apache.flink.runtime.state.StateObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnapshotStrategyRunner<T extends StateObject, SR extends SnapshotResources> {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotStrategyRunner.class);
    private static final String LOG_SYNC_COMPLETED_TEMPLATE = "{} ({}, synchronous part) in thread {} took {} ms.";
    private static final String LOG_ASYNC_COMPLETED_TEMPLATE = "{} ({}, asynchronous part) in thread {} took {} ms.";
    @Nonnull
    private final String description;
    @Nonnull
    private final SnapshotStrategy<T, SR> snapshotStrategy;
    @Nonnull
    private final CloseableRegistry cancelStreamRegistry;
    @Nonnull
    private final SnapshotExecutionType executionType;

    public SnapshotStrategyRunner(@Nonnull String description, @Nonnull SnapshotStrategy<T, SR> snapshotStrategy, @Nonnull CloseableRegistry cancelStreamRegistry, @Nonnull SnapshotExecutionType executionType) {
        this.description = description;
        this.snapshotStrategy = snapshotStrategy;
        this.cancelStreamRegistry = cancelStreamRegistry;
        this.executionType = executionType;
    }

    @Nonnull
    public final RunnableFuture<SnapshotResult<T>> snapshot(long checkpointId, long timestamp, @Nonnull CheckpointStreamFactory streamFactory, @Nonnull CheckpointOptions checkpointOptions) throws Exception {
        long startTime = System.currentTimeMillis();
        SR snapshotResources = this.snapshotStrategy.syncPrepareResources(checkpointId);
        this.logCompletedInternal(LOG_SYNC_COMPLETED_TEMPLATE, streamFactory, startTime);
        final SnapshotStrategy.SnapshotResultSupplier<T> asyncSnapshot = this.snapshotStrategy.asyncSnapshot(snapshotResources, checkpointId, timestamp, streamFactory, checkpointOptions);
        AsyncSnapshotCallable.AsyncSnapshotTask asyncSnapshotTask = new AsyncSnapshotCallable<SnapshotResult<T>>((SnapshotResources)snapshotResources, streamFactory){
            final /* synthetic */ SnapshotResources val$snapshotResources;
            final /* synthetic */ CheckpointStreamFactory val$streamFactory;
            {
                this.val$snapshotResources = snapshotResources;
                this.val$streamFactory = checkpointStreamFactory;
            }

            @Override
            protected SnapshotResult<T> callInternal() throws Exception {
                return asyncSnapshot.get(this.snapshotCloseableRegistry);
            }

            @Override
            protected void cleanupProvidedResources() {
                if (this.val$snapshotResources != null) {
                    this.val$snapshotResources.release();
                }
            }

            @Override
            protected void logAsyncSnapshotComplete(long startTime) {
                SnapshotStrategyRunner.this.logCompletedInternal(SnapshotStrategyRunner.LOG_ASYNC_COMPLETED_TEMPLATE, this.val$streamFactory, startTime);
            }
        }.toAsyncSnapshotFutureTask(this.cancelStreamRegistry);
        if (this.executionType == SnapshotExecutionType.SYNCHRONOUS) {
            asyncSnapshotTask.run();
        }
        return asyncSnapshotTask;
    }

    private void logCompletedInternal(@Nonnull String template, @Nonnull Object checkpointOutDescription, long startTime) {
        long duration = System.currentTimeMillis() - startTime;
        LOG.debug(template, new Object[]{this.description, checkpointOutDescription, Thread.currentThread(), duration});
    }

    public String toString() {
        return "SnapshotStrategy {" + this.description + "}";
    }
}

