/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.controller;

import java.time.LocalDateTime;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.streampark.common.util.DateUtils;
import org.apache.streampark.console.base.domain.ResponseCode;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.core.enums.AuthenticationType;
import org.apache.streampark.console.system.authentication.JWTToken;
import org.apache.streampark.console.system.authentication.JWTUtil;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.security.Authenticator;
import org.apache.streampark.console.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"passport"})
public class PassportController {
    @Autowired
    private UserService userService;
    @Autowired
    private Authenticator authenticator;

    @PostMapping(value={"signin"})
    public RestResponse signin(User loginUser) throws Exception {
        if (StringUtils.isEmpty((CharSequence)loginUser.getUsername())) {
            return RestResponse.success().put("code", (Object)0);
        }
        User user = this.authenticator.authenticate(loginUser.getUsername(), loginUser.getPassword(), loginUser.getLoginType());
        if (user == null) {
            return RestResponse.success().put("code", (Object)0);
        }
        if ("0".equals(user.getStatus())) {
            return RestResponse.success().put("code", (Object)1);
        }
        if (user.getLastTeamId() == null) {
            return RestResponse.success().data(user.getUserId()).put("code", (Object)ResponseCode.CODE_FORBIDDEN);
        }
        this.userService.updateLoginTime(user.getUsername());
        String token = JWTUtil.sign(user, AuthenticationType.SIGN);
        LocalDateTime expireTime = LocalDateTime.now().plusSeconds(JWTUtil.getTTLOfSecond());
        String ttl = DateUtils.formatFullTime((LocalDateTime)expireTime);
        String userId = RandomStringUtils.randomAlphanumeric((int)20);
        user.setId(userId);
        JWTToken jwtToken = new JWTToken(token, ttl);
        Map<String, Object> userInfo = this.userService.generateFrontendUserInfo(user, jwtToken);
        return new RestResponse().data(userInfo);
    }

    @PostMapping(value={"signout"})
    public RestResponse signout() {
        SecurityUtils.getSubject().logout();
        return new RestResponse();
    }
}

