/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.util;

import java.io.File;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.conf.ConfigConst;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebUtils {
    private static final Logger log = LoggerFactory.getLogger(WebUtils.class);

    private WebUtils() {
    }

    public static String camelToUnderscore(String value) {
        if (StringUtils.isBlank((CharSequence)value) || value.contains("_")) {
            return value;
        }
        String[] arr = StringUtils.splitByCharacterTypeCamelCase((String)value);
        if (arr.length == 0) {
            return value;
        }
        StringBuilder result = new StringBuilder();
        IntStream.range(0, arr.length).forEach(i -> {
            if (i != arr.length - 1) {
                result.append(arr[i]).append("_");
            } else {
                result.append(arr[i]);
            }
        });
        return StringUtils.lowerCase((String)result.toString());
    }

    public static String getAppHome() {
        return System.getProperty(ConfigConst.KEY_APP_HOME());
    }

    public static File getAppDir(String dir) {
        return new File(WebUtils.getAppHome(), dir);
    }

    public static File getAppTempDir() {
        return WebUtils.getAppDir("temp");
    }

    public static File getAppLibDir() {
        return WebUtils.getAppDir("lib");
    }

    public static File getAppClientDir() {
        return WebUtils.getAppDir("client");
    }
}

