/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.chill.java;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.lang.reflect.Method;

public class ClosureSerializer
extends Serializer {
    private static Method readResolve;
    private static Class serializedLambda;

    public void write(Kryo kryo, Output output, Object object) {
        try {
            Class<?> clazz = object.getClass();
            Method method = clazz.getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(true);
            Object object2 = method.invoke(object, new Object[0]);
            if (!serializedLambda.isInstance(object2)) {
                throw new RuntimeException("Could not serialize lambda");
            }
            kryo.writeObject(output, object2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not serialize lambda", exception);
        }
    }

    public Object read(Kryo kryo, Input input, Class clazz) {
        try {
            Object object = kryo.readObject(input, serializedLambda);
            return readResolve.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not serialize lambda", exception);
        }
    }

    public Object copy(Kryo kryo, Object object) {
        try {
            Class<?> clazz = object.getClass();
            Method method = clazz.getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(true);
            Object object2 = method.invoke(object, new Object[0]);
            if (serializedLambda.isInstance(object2)) {
                return readResolve.invoke(object2, new Object[0]);
            }
            throw new RuntimeException("Could not serialize lambda");
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not serialize lambda", exception);
        }
    }

    static {
        try {
            serializedLambda = Class.forName("java.lang.invoke.SerializedLambda");
            readResolve = serializedLambda.getDeclaredMethod("readResolve", new Class[0]);
            readResolve.setAccessible(true);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not obtain SerializedLambda or its methods via reflection", exception);
        }
    }

    public static class Closure {
    }
}

