/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.function.Supplier;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ClassLoaderUtils$
implements Logger {
    public static ClassLoaderUtils$ MODULE$;
    private final ClassLoader originalClassLoader;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new ClassLoaderUtils$();
    }

    @Override
    public String logName() {
        return Logger.logName$(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger.logInfo$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger.logDebug$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger.logTrace$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger.logWarn$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public <R> R runAsClassLoader(ClassLoader targetClassLoader, Function0<R> func) {
        Object object;
        try {
            Thread.currentThread().setContextClassLoader(targetClassLoader);
            object = func.apply();
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }
        return (R)object;
    }

    public <R> R runAsClassLoader(ClassLoader targetClassLoader, Supplier<R> supplier) {
        R r;
        try {
            Thread.currentThread().setContextClassLoader(targetClassLoader);
            r = supplier.get();
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.originalClassLoader);
        }
        return r;
    }

    public void loadJar(String jarFilePath) {
        File jarFile = new File(jarFilePath);
        Predef$.MODULE$.require(jarFile.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("[StreamPark] ClassLoaderUtils.loadJar: jarFilePath ").append(jarFilePath).append(" is not exists").toString());
        Predef$.MODULE$.require(jarFile.isFile(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("[StreamPark] ClassLoaderUtils.loadJar: jarFilePath ").append(jarFilePath).append(" is not file").toString());
        this.loadPath(jarFile.getAbsolutePath(), this.loadPath$default$2());
    }

    public void loadJars(String path) {
        File jarDir = new File(path);
        Predef$.MODULE$.require(jarDir.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("[StreamPark] ClassLoaderUtils.loadJars: jarPath ").append(path).append(" is not exists").toString());
        Predef$.MODULE$.require(jarDir.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("[StreamPark] ClassLoaderUtils.loadJars: jarPath ").append(path).append(" is not directory").toString());
        Predef$.MODULE$.require(jarDir.listFiles().length > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("[StreamPark] ClassLoaderUtils.loadJars: have not jar in path:").append(path).toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jarDir.listFiles())).foreach((Function1 & Serializable & scala.Serializable)x -> {
            ClassLoaderUtils$.MODULE$.loadPath(x.getAbsolutePath(), ClassLoaderUtils$.MODULE$.loadPath$default$2());
            return BoxedUnit.UNIT;
        });
    }

    public void loadResource(String filepath) {
        File file = new File(filepath);
        this.addURL(file);
    }

    public void loadResourceDir(String filepath) {
        File file = new File(filepath);
        this.loopDirs(file);
    }

    private void loadPath(String filepath, List<String> ext) {
        File file = new File(filepath);
        this.loopFiles(file, ext);
    }

    private List<String> loadPath$default$2() {
        return new .colon.colon((Object)".jar", (List)new .colon.colon((Object)".zip", (List)Nil$.MODULE$));
    }

    private void loopDirs(File file2) {
        block0: {
            if (!file2.isDirectory()) break block0;
            this.addURL(file2);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file2.listFiles())).foreach((Function1 & Serializable & scala.Serializable)file -> {
                ClassLoaderUtils$.MODULE$.loopDirs(file);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void loopFiles(File file, List<String> ext) {
        block1: {
            block2: {
                block0: {
                    if (!file.isDirectory()) break block0;
                    new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])file.listFiles())).foreach((Function1 & Serializable & scala.Serializable)x -> {
                        ClassLoaderUtils$.MODULE$.loopFiles(x, (List<String>)ext);
                        return BoxedUnit.UNIT;
                    });
                    break block1;
                }
                if (!ext.isEmpty()) break block2;
                this.addURL(file);
                break block1;
            }
            if (!ext.exists((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ClassLoaderUtils$.$anonfun$loopFiles$2(file, x)))) break block1;
            Utils$.MODULE$.checkJarFile(file.toURI().toURL());
            this.addURL(file);
        }
    }

    private List<String> loopFiles$default$2() {
        return Nil$.MODULE$;
    }

    private void addURL(File file) throws Exception {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        ClassLoader classLoader2 = classLoader;
        if (classLoader2 instanceof URLClassLoader) {
            URLClassLoader uRLClassLoader = (URLClassLoader)classLoader2;
            Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", (Class[])((Object[])new Class[]{URL.class}));
            addURL.setAccessible(true);
            addURL.invoke((Object)uRLClassLoader, file.toURI().toURL());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit;
            try {
                Field field = classLoader.getClass().getDeclaredField("ucp");
                field.setAccessible(true);
                Object ucp = field.get(classLoader);
                Method addURL = ucp.getClass().getDeclaredMethod("addURL", (Class[])((Object[])new Class[]{URL.class}));
                addURL.setAccessible(true);
                addURL.invoke(ucp, file.toURI().toURL());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new UnsupportedOperationException(new StringBuilder(52).append("Add resource to classpath unsupported, jdk version: ").append(System.getProperty("java.version")).toString());
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        }
    }

    public static final /* synthetic */ boolean $anonfun$loopFiles$2(File file$1, String x) {
        return file$1.getName().endsWith(x);
    }

    private ClassLoaderUtils$() {
        MODULE$ = this;
        Logger.$init$(this);
        this.originalClassLoader = Thread.currentThread().getContextClassLoader();
    }
}

