/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.client.impl;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.client.program.MiniClusterClient;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.PipelineOptions;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.util.AbstractID;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.flink.client.bean.CancelRequest;
import org.apache.streampark.flink.client.bean.CancelResponse;
import org.apache.streampark.flink.client.bean.SavepointResponse;
import org.apache.streampark.flink.client.bean.SubmitRequest;
import org.apache.streampark.flink.client.bean.SubmitResponse;
import org.apache.streampark.flink.client.bean.TriggerSavepointRequest;
import org.apache.streampark.flink.client.impl.RemoteClient$;
import org.apache.streampark.flink.client.trait.FlinkClientTrait;
import scala.Function0;
import scala.Function3;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;

public final class LocalClient$
implements FlinkClientTrait {
    public static LocalClient$ MODULE$;
    private String PARAM_KEY_FLINK_CONF;
    private String PARAM_KEY_FLINK_SQL;
    private String PARAM_KEY_APP_CONF;
    private String PARAM_KEY_APP_NAME;
    private String PARAM_KEY_FLINK_PARALLELISM;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile byte bitmap$0;

    static {
        new LocalClient$();
    }

    @Override
    public SubmitResponse submit(SubmitRequest submitRequest) throws Exception {
        return FlinkClientTrait.submit$(this, submitRequest);
    }

    @Override
    public SavepointResponse triggerSavepoint(TriggerSavepointRequest savepointRequest) throws Exception {
        return FlinkClientTrait.triggerSavepoint$(this, savepointRequest);
    }

    @Override
    public CancelResponse cancel(CancelRequest cancelRequest) throws Exception {
        return FlinkClientTrait.cancel$(this, cancelRequest);
    }

    @Override
    public SubmitResponse trySubmit(SubmitRequest submitRequest, Configuration flinkConfig, File jarFile, Function3<SubmitRequest, Configuration, File, SubmitResponse> jobGraphFunc, Function3<SubmitRequest, Configuration, File, SubmitResponse> restApiFunc) {
        return FlinkClientTrait.trySubmit$(this, submitRequest, flinkConfig, jarFile, jobGraphFunc, restApiFunc);
    }

    @Override
    public Tuple2<PackagedProgram, JobGraph> getJobGraph(Configuration flinkConfig, SubmitRequest submitRequest, File jarFile) {
        return FlinkClientTrait.getJobGraph$(this, flinkConfig, submitRequest, jarFile);
    }

    @Override
    public JobID getJobID(String jobId) {
        return FlinkClientTrait.getJobID$(this, jobId);
    }

    @Override
    public CustomCommandLine validateAndGetActiveCommandLine(List<CustomCommandLine> customCommandLines, CommandLine commandLine) {
        return FlinkClientTrait.validateAndGetActiveCommandLine$(this, customCommandLines, commandLine);
    }

    @Override
    public Integer getParallelism(SubmitRequest submitRequest) {
        return FlinkClientTrait.getParallelism$(this, submitRequest);
    }

    @Override
    public Options getCommandLineOptions(String flinkHome) {
        return FlinkClientTrait.getCommandLineOptions$(this, flinkHome);
    }

    @Override
    public Configuration extractConfiguration(String flinkHome, Map<String, Object> properties) {
        return FlinkClientTrait.extractConfiguration$(this, flinkHome, properties);
    }

    @Override
    public FlinkClientTrait.EnhanceFlinkConfiguration EnhanceFlinkConfiguration(Configuration flinkConfig) {
        return FlinkClientTrait.EnhanceFlinkConfiguration$(this, flinkConfig);
    }

    @Override
    public String cancelJob(CancelRequest cancelRequest, JobID jobID, ClusterClient<?> client) {
        return FlinkClientTrait.cancelJob$(this, cancelRequest, jobID, client);
    }

    @Override
    public String triggerSavepoint(TriggerSavepointRequest savepointRequest, JobID jobID, ClusterClient<?> client) {
        return FlinkClientTrait.triggerSavepoint$(this, savepointRequest, jobID, client);
    }

    @Override
    public void closeSubmit(SubmitRequest submitRequest, Seq<AutoCloseable> close) {
        FlinkClientTrait.closeSubmit$(this, submitRequest, close);
    }

    public String logName() {
        return Logger.logName$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.logInfo$((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.logDebug$((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.logTrace$((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.logWarn$((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.logError$((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$((Logger)this);
    }

    private String PARAM_KEY_FLINK_CONF$lzycompute() {
        LocalClient$ localClient$ = this;
        synchronized (localClient$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.PARAM_KEY_FLINK_CONF = FlinkClientTrait.PARAM_KEY_FLINK_CONF$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.PARAM_KEY_FLINK_CONF;
    }

    @Override
    public String PARAM_KEY_FLINK_CONF() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.PARAM_KEY_FLINK_CONF$lzycompute() : this.PARAM_KEY_FLINK_CONF;
    }

    private String PARAM_KEY_FLINK_SQL$lzycompute() {
        LocalClient$ localClient$ = this;
        synchronized (localClient$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.PARAM_KEY_FLINK_SQL = FlinkClientTrait.PARAM_KEY_FLINK_SQL$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.PARAM_KEY_FLINK_SQL;
    }

    @Override
    public String PARAM_KEY_FLINK_SQL() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.PARAM_KEY_FLINK_SQL$lzycompute() : this.PARAM_KEY_FLINK_SQL;
    }

    private String PARAM_KEY_APP_CONF$lzycompute() {
        LocalClient$ localClient$ = this;
        synchronized (localClient$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.PARAM_KEY_APP_CONF = FlinkClientTrait.PARAM_KEY_APP_CONF$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.PARAM_KEY_APP_CONF;
    }

    @Override
    public String PARAM_KEY_APP_CONF() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.PARAM_KEY_APP_CONF$lzycompute() : this.PARAM_KEY_APP_CONF;
    }

    private String PARAM_KEY_APP_NAME$lzycompute() {
        LocalClient$ localClient$ = this;
        synchronized (localClient$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.PARAM_KEY_APP_NAME = FlinkClientTrait.PARAM_KEY_APP_NAME$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.PARAM_KEY_APP_NAME;
    }

    @Override
    public String PARAM_KEY_APP_NAME() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.PARAM_KEY_APP_NAME$lzycompute() : this.PARAM_KEY_APP_NAME;
    }

    private String PARAM_KEY_FLINK_PARALLELISM$lzycompute() {
        LocalClient$ localClient$ = this;
        synchronized (localClient$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.PARAM_KEY_FLINK_PARALLELISM = FlinkClientTrait.PARAM_KEY_FLINK_PARALLELISM$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.PARAM_KEY_FLINK_PARALLELISM;
    }

    @Override
    public String PARAM_KEY_FLINK_PARALLELISM() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.PARAM_KEY_FLINK_PARALLELISM$lzycompute() : this.PARAM_KEY_FLINK_PARALLELISM;
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    @Override
    public void setConfig(SubmitRequest submitRequest, Configuration flinkConfig) {
        this.EnhanceFlinkConfiguration(flinkConfig).safeSet(PipelineOptions.NAME, submitRequest.effectiveAppName());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(232).append("\n               |------------------------------------------------------------------\n               |Effective submit configuration: ").append(flinkConfig).append("\n               |------------------------------------------------------------------\n               |").toString())).stripMargin());
    }

    @Override
    public SubmitResponse doSubmit(SubmitRequest submitRequest, Configuration flinkConfig) {
        Tuple2 programJobGraph = FlinkClientTrait.getJobGraph$(this, flinkConfig, submitRequest, submitRequest.userJarFile());
        PackagedProgram packageProgram = (PackagedProgram)programJobGraph._1();
        JobGraph jobGraph = (JobGraph)programJobGraph._2();
        MiniClusterClient client = this.createLocalCluster(flinkConfig);
        String jobId = ((AbstractID)client.submitJob(jobGraph).get()).toString();
        SubmitResponse resp = new SubmitResponse(jobId, flinkConfig.toMap(), jobId, client.getWebInterfaceURL());
        this.closeSubmit(submitRequest, (Seq<AutoCloseable>)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{packageProgram, client}));
        return resp;
    }

    @Override
    public SavepointResponse doTriggerSavepoint(TriggerSavepointRequest request, Configuration flinkConfig) {
        return RemoteClient$.MODULE$.doTriggerSavepoint(request, flinkConfig);
    }

    @Override
    public CancelResponse doCancel(CancelRequest cancelRequest, Configuration flinkConfig) {
        return RemoteClient$.MODULE$.doCancel(cancelRequest, flinkConfig);
    }

    private MiniClusterClient createLocalCluster(Configuration flinkConfig) {
        this.EnhanceFlinkConfiguration(flinkConfig).safeSet(JobManagerOptions.PORT, Predef$.MODULE$.int2Integer(0));
        int numTaskManagers = flinkConfig.getInteger("local.number-taskmanager", 1);
        int numSlotsPerTaskManager = flinkConfig.getInteger(TaskManagerOptions.NUM_TASK_SLOTS);
        MiniClusterConfiguration miniClusterConfig = new MiniClusterConfiguration.Builder().setConfiguration(flinkConfig).setNumSlotsPerTaskManager(numSlotsPerTaskManager).setNumTaskManagers(numTaskManagers).build();
        MiniCluster cluster = new MiniCluster(miniClusterConfig);
        cluster.start();
        MiniCluster cluster2 = cluster;
        String host = "localhost";
        int port = ((URI)cluster2.getRestAddress().get()).getPort();
        this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(this.EnhanceFlinkConfiguration(flinkConfig).safeSet(JobManagerOptions.ADDRESS, host)).safeSet(JobManagerOptions.PORT, Predef$.MODULE$.int2Integer(port))).safeSet(RestOptions.ADDRESS, host)).safeSet(RestOptions.PORT, Predef$.MODULE$.int2Integer(port))).safeSet(DeploymentOptions.TARGET, "remote");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("\nStarting local Flink cluster (host: localhost, port: ").append(port).append(").\n").toString());
        return new MiniClusterClient(flinkConfig, cluster2);
    }

    private LocalClient$() {
        MODULE$ = this;
        Logger.$init$((Logger)this);
        FlinkClientTrait.$init$(this);
    }
}

