/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.plugins.inner;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.LateralSubSelect;
import net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubJoin;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.ValuesList;
import net.sf.jsqlparser.statement.select.WithItem;

public abstract class BaseMultiTableInnerInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    protected void processSelectBody(SelectBody selectBody, String whereSegment) {
        if (selectBody == null) {
            return;
        }
        if (selectBody instanceof PlainSelect) {
            this.processPlainSelect((PlainSelect)selectBody, whereSegment);
        } else if (selectBody instanceof WithItem) {
            WithItem withItem = (WithItem)selectBody;
            this.processSelectBody(withItem.getSubSelect().getSelectBody(), whereSegment);
        } else {
            SetOperationList operationList = (SetOperationList)selectBody;
            List selectBodyList = operationList.getSelects();
            if (CollectionUtils.isNotEmpty((Collection)selectBodyList)) {
                selectBodyList.forEach(body -> this.processSelectBody((SelectBody)body, whereSegment));
            }
        }
    }

    protected Expression andExpression(Table table, Expression where, String whereSegment) {
        Expression expression = this.buildTableExpression(table, where, whereSegment);
        if (expression == null) {
            return where;
        }
        if (where != null) {
            if (where instanceof OrExpression) {
                return new AndExpression((Expression)new Parenthesis(where), expression);
            }
            return new AndExpression(where, expression);
        }
        return expression;
    }

    protected void processPlainSelect(PlainSelect plainSelect, String whereSegment) {
        List selectItems = plainSelect.getSelectItems();
        if (CollectionUtils.isNotEmpty((Collection)selectItems)) {
            selectItems.forEach(selectItem -> this.processSelectItem((SelectItem)selectItem, whereSegment));
        }
        Expression where = plainSelect.getWhere();
        this.processWhereSubSelect(where, whereSegment);
        FromItem fromItem = plainSelect.getFromItem();
        List<Table> list = this.processFromItem(fromItem, whereSegment);
        List<Table> mainTables = new ArrayList<Table>(list);
        List joins = plainSelect.getJoins();
        if (CollectionUtils.isNotEmpty((Collection)joins)) {
            mainTables = this.processJoins(mainTables, joins, whereSegment);
        }
        if (CollectionUtils.isNotEmpty(mainTables)) {
            plainSelect.setWhere(this.builderExpression(where, mainTables, whereSegment));
        }
    }

    private List<Table> processFromItem(FromItem fromItem, String whereSegment) {
        while (fromItem instanceof ParenthesisFromItem) {
            fromItem = ((ParenthesisFromItem)fromItem).getFromItem();
        }
        ArrayList<Table> mainTables = new ArrayList<Table>();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            mainTables.add(fromTable);
        } else if (fromItem instanceof SubJoin) {
            List<Table> tables = this.processSubJoin((SubJoin)fromItem, whereSegment);
            mainTables.addAll(tables);
        } else {
            this.processOtherFromItem(fromItem, whereSegment);
        }
        return mainTables;
    }

    protected void processWhereSubSelect(Expression where, String whereSegment) {
        if (where == null) {
            return;
        }
        if (where instanceof FromItem) {
            this.processOtherFromItem((FromItem)where, whereSegment);
            return;
        }
        if (where.toString().indexOf("SELECT") > 0) {
            if (where instanceof BinaryExpression) {
                BinaryExpression expression = (BinaryExpression)where;
                this.processWhereSubSelect(expression.getLeftExpression(), whereSegment);
                this.processWhereSubSelect(expression.getRightExpression(), whereSegment);
            } else if (where instanceof InExpression) {
                InExpression expression = (InExpression)where;
                Expression inExpression = expression.getRightExpression();
                if (inExpression instanceof SubSelect) {
                    this.processSelectBody(((SubSelect)inExpression).getSelectBody(), whereSegment);
                }
            } else if (where instanceof ExistsExpression) {
                ExistsExpression expression = (ExistsExpression)where;
                this.processWhereSubSelect(expression.getRightExpression(), whereSegment);
            } else if (where instanceof NotExpression) {
                NotExpression expression = (NotExpression)where;
                this.processWhereSubSelect(expression.getExpression(), whereSegment);
            } else if (where instanceof Parenthesis) {
                Parenthesis expression = (Parenthesis)where;
                this.processWhereSubSelect(expression.getExpression(), whereSegment);
            }
        }
    }

    protected void processSelectItem(SelectItem selectItem, String whereSegment) {
        if (selectItem instanceof SelectExpressionItem) {
            SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
            Expression expression = selectExpressionItem.getExpression();
            if (expression instanceof SubSelect) {
                this.processSelectBody(((SubSelect)expression).getSelectBody(), whereSegment);
            } else if (expression instanceof Function) {
                this.processFunction((Function)expression, whereSegment);
            }
        }
    }

    protected void processFunction(Function function, String whereSegment) {
        ExpressionList parameters = function.getParameters();
        if (parameters != null) {
            parameters.getExpressions().forEach(expression -> {
                if (expression instanceof SubSelect) {
                    this.processSelectBody(((SubSelect)expression).getSelectBody(), whereSegment);
                } else if (expression instanceof Function) {
                    this.processFunction((Function)expression, whereSegment);
                }
            });
        }
    }

    protected void processOtherFromItem(FromItem fromItem, String whereSegment) {
        SubSelect subSelect;
        LateralSubSelect lateralSubSelect;
        while (fromItem instanceof ParenthesisFromItem) {
            fromItem = ((ParenthesisFromItem)fromItem).getFromItem();
        }
        if (fromItem instanceof SubSelect) {
            SubSelect subSelect2 = (SubSelect)fromItem;
            if (subSelect2.getSelectBody() != null) {
                this.processSelectBody(subSelect2.getSelectBody(), whereSegment);
            }
        } else if (fromItem instanceof ValuesList) {
            this.logger.debug("Perform a subQuery, if you do not give us feedback");
        } else if (fromItem instanceof LateralSubSelect && (lateralSubSelect = (LateralSubSelect)fromItem).getSubSelect() != null && (subSelect = lateralSubSelect.getSubSelect()).getSelectBody() != null) {
            this.processSelectBody(subSelect.getSelectBody(), whereSegment);
        }
    }

    private List<Table> processSubJoin(SubJoin subJoin, String whereSegment) {
        List<Table> mainTables = new ArrayList<Table>();
        if (subJoin.getJoinList() != null) {
            List<Table> list = this.processFromItem(subJoin.getLeft(), whereSegment);
            mainTables.addAll(list);
            mainTables = this.processJoins(mainTables, subJoin.getJoinList(), whereSegment);
        }
        return mainTables;
    }

    private List<Table> processJoins(List<Table> mainTables, List<Join> joins, String whereSegment) {
        Table mainTable = null;
        Table leftTable = null;
        if (mainTables == null) {
            mainTables = new ArrayList<Table>();
        } else if (mainTables.size() == 1) {
            leftTable = mainTable = mainTables.get(0);
        }
        LinkedList<List<Table>> onTableDeque = new LinkedList<List<Table>>();
        for (Join join : joins) {
            FromItem joinItem = join.getRightItem();
            List<Object> joinTables = null;
            if (joinItem instanceof Table) {
                joinTables = new ArrayList<Table>();
                joinTables.add((Table)joinItem);
            } else if (joinItem instanceof SubJoin) {
                joinTables = this.processSubJoin((SubJoin)joinItem, whereSegment);
            }
            if (joinTables != null) {
                LinkedList<Expression> onExpressions;
                Collection originOnExpressions;
                if (join.isSimple()) {
                    mainTables.addAll(joinTables);
                    continue;
                }
                Table joinTable = (Table)joinTables.get(0);
                List<Table> onTables = null;
                if (join.isRight()) {
                    mainTable = joinTable;
                    if (leftTable != null) {
                        onTables = Collections.singletonList(leftTable);
                    }
                } else if (join.isInner()) {
                    onTables = mainTable == null ? Collections.singletonList(joinTable) : Arrays.asList(mainTable, joinTable);
                    mainTable = null;
                } else {
                    onTables = Collections.singletonList(joinTable);
                }
                mainTables = new ArrayList<Table>();
                if (mainTable != null) {
                    mainTables.add(mainTable);
                }
                if ((originOnExpressions = join.getOnExpressions()).size() == 1 && onTables != null) {
                    onExpressions = new LinkedList<Expression>();
                    onExpressions.add(this.builderExpression((Expression)originOnExpressions.iterator().next(), onTables, whereSegment));
                    join.setOnExpressions(onExpressions);
                    leftTable = joinTable;
                    continue;
                }
                onTableDeque.push(onTables);
                if (originOnExpressions.size() > 1) {
                    onExpressions = new LinkedList();
                    for (Expression originOnExpression : originOnExpressions) {
                        List currentTableList = (List)onTableDeque.poll();
                        if (CollectionUtils.isEmpty((Collection)currentTableList)) {
                            onExpressions.add(originOnExpression);
                            continue;
                        }
                        onExpressions.add(this.builderExpression(originOnExpression, currentTableList, whereSegment));
                    }
                    join.setOnExpressions(onExpressions);
                }
                leftTable = joinTable;
                continue;
            }
            this.processOtherFromItem(joinItem, whereSegment);
            leftTable = null;
        }
        return mainTables;
    }

    protected Expression builderExpression(Expression currentExpression, List<Table> tables, String whereSegment) {
        if (CollectionUtils.isEmpty(tables)) {
            return currentExpression;
        }
        List expressions = tables.stream().map(item -> this.buildTableExpression((Table)item, currentExpression, whereSegment)).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(expressions)) {
            return currentExpression;
        }
        Expression injectExpression = (Expression)expressions.get(0);
        if (expressions.size() > 1) {
            for (int i = 1; i < expressions.size(); ++i) {
                injectExpression = new AndExpression(injectExpression, (Expression)expressions.get(i));
            }
        }
        if (currentExpression == null) {
            return injectExpression;
        }
        if (currentExpression instanceof OrExpression) {
            return new AndExpression((Expression)new Parenthesis(currentExpression), injectExpression);
        }
        return new AndExpression(currentExpression, injectExpression);
    }

    public abstract Expression buildTableExpression(Table var1, Expression var2, String var3);

    public String toString() {
        return "BaseMultiTableInnerInterceptor(super=" + super.toString() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseMultiTableInnerInterceptor)) {
            return false;
        }
        BaseMultiTableInnerInterceptor other = (BaseMultiTableInnerInterceptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseMultiTableInnerInterceptor;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

