/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.eventtime.Watermark;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.OperatorIOMetricGroup;
import org.apache.flink.metrics.groups.OperatorMetricGroup;
import org.apache.flink.metrics.groups.SourceReaderMetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.metrics.groups.ProxyMetricGroup;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;

@Internal
public class InternalSourceReaderMetricGroup
extends ProxyMetricGroup<MetricGroup>
implements SourceReaderMetricGroup {
    public static final long UNDEFINED = -1L;
    private static final long ACTIVE = Long.MAX_VALUE;
    private static final long MAX_WATERMARK_TIMESTAMP = Watermark.MAX_WATERMARK.getTimestamp();
    private final OperatorIOMetricGroup operatorIOMetricGroup;
    private final Counter numRecordsInErrors;
    private final Clock clock;
    private long lastWatermark;
    private long lastEventTime = Long.MIN_VALUE;
    private long idleStartTime = Long.MAX_VALUE;
    private boolean firstWatermark = true;

    private InternalSourceReaderMetricGroup(MetricGroup parentMetricGroup, OperatorIOMetricGroup operatorIOMetricGroup, Clock clock) {
        super(parentMetricGroup);
        this.numRecordsInErrors = parentMetricGroup.counter("numRecordsInErrors");
        this.operatorIOMetricGroup = operatorIOMetricGroup;
        this.clock = clock;
        parentMetricGroup.gauge("sourceIdleTime", this::getIdleTime);
        parentMetricGroup.gauge("currentEmitEventTimeLag", this::getEmitTimeLag);
    }

    public static InternalSourceReaderMetricGroup wrap(OperatorMetricGroup operatorMetricGroup) {
        return new InternalSourceReaderMetricGroup((MetricGroup)operatorMetricGroup, operatorMetricGroup.getIOMetricGroup(), (Clock)SystemClock.getInstance());
    }

    @VisibleForTesting
    public static InternalSourceReaderMetricGroup mock(MetricGroup metricGroup) {
        return new InternalSourceReaderMetricGroup(metricGroup, UnregisteredMetricsGroup.createOperatorIOMetricGroup(), (Clock)SystemClock.getInstance());
    }

    public Counter getNumRecordsInErrorsCounter() {
        return this.numRecordsInErrors;
    }

    public void setPendingBytesGauge(Gauge<Long> pendingBytesGauge) {
        this.gauge("pendingBytes", pendingBytesGauge);
    }

    public void setPendingRecordsGauge(Gauge<Long> pendingRecordsGauge) {
        this.gauge("pendingRecords", pendingRecordsGauge);
    }

    public OperatorIOMetricGroup getIOMetricGroup() {
        return this.operatorIOMetricGroup;
    }

    public void recordEmitted(long timestamp) {
        this.idleStartTime = Long.MAX_VALUE;
        this.lastEventTime = timestamp;
    }

    public void idlingStarted() {
        if (!this.isIdling()) {
            this.idleStartTime = this.clock.absoluteTimeMillis();
        }
    }

    public void watermarkEmitted(long watermark) {
        if (watermark == MAX_WATERMARK_TIMESTAMP) {
            return;
        }
        this.lastWatermark = watermark;
        if (this.firstWatermark) {
            this.parentMetricGroup.gauge("watermarkLag", this::getWatermarkLag);
            this.firstWatermark = false;
        }
    }

    boolean isIdling() {
        return this.idleStartTime != Long.MAX_VALUE;
    }

    long getIdleTime() {
        return this.isIdling() ? this.clock.absoluteTimeMillis() - this.idleStartTime : 0L;
    }

    private long getLastEmitTime() {
        return this.isIdling() ? this.idleStartTime : this.clock.absoluteTimeMillis();
    }

    long getEmitTimeLag() {
        return this.lastEventTime != Long.MIN_VALUE ? this.getLastEmitTime() - this.lastEventTime : -1L;
    }

    long getWatermarkLag() {
        return this.getLastEmitTime() - this.lastWatermark;
    }
}

