/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.alert.impl;

import freemarker.template.Template;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.streampark.console.base.exception.AlertException;
import org.apache.streampark.console.base.util.FreemarkerUtils;
import org.apache.streampark.console.core.bean.AlertConfigWithParams;
import org.apache.streampark.console.core.bean.AlertTemplate;
import org.apache.streampark.console.core.bean.AlertWeComParams;
import org.apache.streampark.console.core.bean.RobotResponse;
import org.apache.streampark.console.core.service.alert.AlertNotifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
@Lazy
public class WeComAlertNotifyServiceImpl
implements AlertNotifyService {
    private static final Logger log = LoggerFactory.getLogger(WeComAlertNotifyServiceImpl.class);
    private Template template;
    private final RestTemplate alertRestTemplate;

    public WeComAlertNotifyServiceImpl(RestTemplate alertRestTemplate) {
        this.alertRestTemplate = alertRestTemplate;
    }

    @PostConstruct
    public void loadTemplateFile() throws Exception {
        String template = "alert-weCom.ftl";
        this.template = FreemarkerUtils.loadTemplateFile(template);
    }

    @Override
    public boolean doAlert(AlertConfigWithParams alertConfig, AlertTemplate alertTemplate) throws AlertException {
        AlertWeComParams weComParams = alertConfig.getWeComParams();
        try {
            String markdown = FreemarkerUtils.format(this.template, alertTemplate);
            HashMap<String, String> content = new HashMap<String, String>();
            content.put("content", markdown);
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("msgtype", "markdown");
            body.put("markdown", content);
            this.sendMessage(weComParams, body);
            return true;
        }
        catch (AlertException alertException) {
            throw alertException;
        }
        catch (Exception e) {
            throw new AlertException("Failed send weCom alert", e);
        }
    }

    private void sendMessage(AlertWeComParams params, Map<String, Object> body) throws AlertException {
        RobotResponse robotResponse;
        String url = this.getWebhook(params);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            robotResponse = (RobotResponse)this.alertRestTemplate.postForObject(url, (Object)entity, RobotResponse.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("Failed to request DingTalk robot alarm,\nurl:{}", (Object)url, (Object)e);
            throw new AlertException(String.format("Failed to request WeCom robot alert,\nurl:%s", url), e);
        }
        if (robotResponse == null) {
            throw new AlertException(String.format("Failed to request WeCom robot alert,\nurl:%s", url));
        }
        if (robotResponse.getErrcode() != 0) {
            throw new AlertException(String.format("Failed to request DingTalk robot alert,\nurl:%s,\nerrorCode:%d,\nerrorMsg:%s", url, robotResponse.getErrcode(), robotResponse.getErrmsg()));
        }
    }

    private String getWebhook(AlertWeComParams params) {
        String url = String.format("https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=%s", params.getToken());
        if (log.isDebugEnabled()) {
            log.debug("The alert robot url of WeCom is {}", (Object)url);
        }
        return url;
    }
}

