/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.util.HostsUtils;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.flink.kubernetes.PodTemplateParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"flink/podtmpl"})
public class FlinkPodTemplateController {
    private static final Logger log = LoggerFactory.getLogger(FlinkPodTemplateController.class);

    @PostMapping(value={"sysHosts"})
    public RestResponse getHosts() {
        Map hostMap = HostsUtils.getSystemHostsAsJava((boolean)true);
        List friendlyHosts = hostMap.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.toList());
        return RestResponse.success(friendlyHosts);
    }

    @PostMapping(value={"init"})
    public RestResponse getInitContent() {
        return RestResponse.success(PodTemplateParser.getInitPodTemplateContent());
    }

    @PostMapping(value={"compHostAlias"})
    public RestResponse completeHostAlias(String hosts, String podTemplate) {
        Map<String, String> hostMap = this.covertHostsParamToMap(hosts);
        String completedPodTemplate = PodTemplateParser.completeHostAliasSpec(hostMap, (String)podTemplate);
        return RestResponse.success(completedPodTemplate);
    }

    private Map<String, String> covertHostsParamToMap(String hosts) {
        if (StringUtils.isEmpty((CharSequence)hosts)) {
            return new HashMap<String, String>(0);
        }
        return Arrays.stream(hosts.split(",")).filter(StringUtils::isNotBlank).map(String::trim).map(e -> e.split(":")).filter(arr -> ((String[])arr).length == 2 && StringUtils.isNotBlank((CharSequence)arr[0]) && StringUtils.isNotBlank((CharSequence)arr[1])).collect(Collectors.toMap(arr -> arr[0], arr -> arr[1]));
    }

    @PostMapping(value={"extractHostAlias"})
    public RestResponse extractHostAlias(String podTemplate) {
        Map hosts = PodTemplateParser.extractHostAliasMap((String)podTemplate);
        List friendlyHosts = hosts.entrySet().stream().map(e -> (String)e.getKey() + ":" + (String)e.getValue()).collect(Collectors.toList());
        return RestResponse.success(friendlyHosts);
    }

    @PostMapping(value={"previewHostAlias"})
    public RestResponse previewHostAlias(String hosts) {
        Map<String, String> hostMap = this.covertHostsParamToMap(hosts);
        String podTemplate = PodTemplateParser.previewHostAliasSpec(hostMap);
        return RestResponse.success(podTemplate);
    }
}

