/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.net.InetAddress;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalException;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalListener;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.net.ConnectionUtils;
import org.apache.flink.runtime.rpc.RpcSystemUtils;
import org.apache.flink.runtime.util.LeaderConnectionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderRetrievalUtils {
    private static final Logger LOG = LoggerFactory.getLogger(LeaderRetrievalUtils.class);

    public static LeaderConnectionInfo retrieveLeaderConnectionInfo(LeaderRetrievalService leaderRetrievalService, Duration timeout) throws LeaderRetrievalException {
        LeaderConnectionInfoListener listener = new LeaderConnectionInfoListener();
        try {
            leaderRetrievalService.start(listener);
            LeaderConnectionInfo leaderConnectionInfo = listener.getLeaderConnectionInfoFuture().get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            return leaderConnectionInfo;
        }
        catch (Exception e) {
            throw new LeaderRetrievalException("Could not retrieve the leader address and leader session ID.", e);
        }
        finally {
            try {
                leaderRetrievalService.stop();
            }
            catch (Exception fe) {
                LOG.warn("Could not stop the leader retrieval service.", (Throwable)fe);
            }
        }
    }

    public static InetAddress findConnectingAddress(LeaderRetrievalService leaderRetrievalService, Duration timeout, RpcSystemUtils rpcSystemUtils) throws LeaderRetrievalException {
        ConnectionUtils.LeaderConnectingAddressListener listener = new ConnectionUtils.LeaderConnectingAddressListener(rpcSystemUtils);
        try {
            leaderRetrievalService.start(listener);
            LOG.info("Trying to select the network interface and address to use by connecting to the leading JobManager.");
            LOG.info("TaskManager will try to connect for " + timeout + " before falling back to heuristics");
            InetAddress inetAddress = listener.findConnectingAddress(timeout);
            return inetAddress;
        }
        catch (Exception e) {
            throw new LeaderRetrievalException("Could not find the connecting address by connecting to the current leader.", e);
        }
        finally {
            try {
                leaderRetrievalService.stop();
            }
            catch (Exception fe) {
                LOG.warn("Could not stop the leader retrieval service.", (Throwable)fe);
            }
        }
    }

    private LeaderRetrievalUtils() {
        throw new RuntimeException();
    }

    public static class LeaderConnectionInfoListener
    implements LeaderRetrievalListener {
        private final CompletableFuture<LeaderConnectionInfo> connectionInfoFuture = new CompletableFuture();

        public CompletableFuture<LeaderConnectionInfo> getLeaderConnectionInfoFuture() {
            return this.connectionInfoFuture;
        }

        @Override
        public void notifyLeaderAddress(String leaderAddress, UUID leaderSessionID) {
            if (leaderAddress != null && !leaderAddress.equals("") && !this.connectionInfoFuture.isDone()) {
                LeaderConnectionInfo leaderConnectionInfo = new LeaderConnectionInfo(leaderSessionID, leaderAddress);
                this.connectionInfoFuture.complete(leaderConnectionInfo);
            }
        }

        @Override
        public void handleError(Exception exception) {
            this.connectionInfoFuture.completeExceptionally(exception);
        }
    }
}

