/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.translators;

import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.TransformationTranslator;
import org.apache.flink.streaming.api.transformations.TwoInputTransformation;
import org.apache.flink.streaming.runtime.translators.AbstractTwoInputTransformationTranslator;
import org.apache.flink.streaming.runtime.translators.BatchExecutionUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class TwoInputTransformationTranslator<IN1, IN2, OUT>
extends AbstractTwoInputTransformationTranslator<IN1, IN2, OUT, TwoInputTransformation<IN1, IN2, OUT>> {
    @Override
    protected Collection<Integer> translateForBatchInternal(TwoInputTransformation<IN1, IN2, OUT> transformation, TransformationTranslator.Context context) {
        StreamConfig.InputRequirement input2Requirement;
        Collection<Integer> ids = this.translateInternal(transformation, context);
        StreamConfig.InputRequirement input1Requirement = transformation.getStateKeySelector1() != null ? StreamConfig.InputRequirement.SORTED : StreamConfig.InputRequirement.PASS_THROUGH;
        StreamConfig.InputRequirement inputRequirement = input2Requirement = transformation.getStateKeySelector2() != null ? StreamConfig.InputRequirement.SORTED : StreamConfig.InputRequirement.PASS_THROUGH;
        if (input1Requirement == StreamConfig.InputRequirement.SORTED || input2Requirement == StreamConfig.InputRequirement.SORTED) {
            BatchExecutionUtils.applyBatchExecutionSettings(transformation.getId(), context, input1Requirement, input2Requirement);
        }
        return ids;
    }

    @Override
    protected Collection<Integer> translateForStreamingInternal(TwoInputTransformation<IN1, IN2, OUT> transformation, TransformationTranslator.Context context) {
        return this.translateInternal(transformation, context);
    }

    private Collection<Integer> translateInternal(TwoInputTransformation<IN1, IN2, OUT> transformation, TransformationTranslator.Context context) {
        Preconditions.checkNotNull(transformation);
        Preconditions.checkNotNull((Object)context);
        return this.translateInternal(transformation, transformation.getInput1(), transformation.getInput2(), transformation.getOperatorFactory(), transformation.getStateKeyType(), transformation.getStateKeySelector1(), transformation.getStateKeySelector2(), context);
    }
}

