/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.scala.typeutils;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.scala.typeutils.TraversableSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;
import scala.collection.TraversableOnce;

public class TraversableSerializerSnapshot<T extends TraversableOnce<E>, E>
extends CompositeTypeSerializerSnapshot<T, TraversableSerializer<T, E>> {
    private static final int VERSION = 2;
    private String cbfCode;

    public TraversableSerializerSnapshot() {
        super(TraversableSerializer.class);
    }

    public TraversableSerializerSnapshot(TraversableSerializer<T, E> serializerInstance) {
        super(serializerInstance);
        this.cbfCode = serializerInstance.cbfCode();
    }

    TraversableSerializerSnapshot(String cbfCode) {
        super(TraversableSerializer.class);
        Preconditions.checkArgument((cbfCode != null ? 1 : 0) != 0, (Object)"cbfCode cannot be null");
        this.cbfCode = cbfCode;
    }

    protected int getCurrentOuterSnapshotVersion() {
        return 2;
    }

    protected TypeSerializer<?>[] getNestedSerializers(TraversableSerializer<T, E> outerSerializer) {
        return new TypeSerializer[]{outerSerializer.elementSerializer()};
    }

    protected TraversableSerializer<T, E> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
        Preconditions.checkState((this.cbfCode != null ? 1 : 0) != 0, (Object)"cbfCode cannot be null");
        TypeSerializer<?> nestedSerializer = nestedSerializers[0];
        return new TraversableSerializer(nestedSerializer, this.cbfCode);
    }

    protected void writeOuterSnapshot(DataOutputView out) throws IOException {
        out.writeUTF(this.cbfCode);
    }

    protected void readOuterSnapshot(int readOuterSnapshotVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        this.cbfCode = in.readUTF();
    }

    protected CompositeTypeSerializerSnapshot.OuterSchemaCompatibility resolveOuterSchemaCompatibility(TraversableSerializer<T, E> newSerializer) {
        return this.cbfCode.equals(newSerializer.cbfCode()) ? CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.COMPATIBLE_AS_IS : CompositeTypeSerializerSnapshot.OuterSchemaCompatibility.INCOMPATIBLE;
    }
}

