/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.iterative.io;

import org.apache.flink.api.common.operators.util.JoinHashMap;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.util.Collector;

public class SolutionSetObjectsUpdateOutputCollector<T>
implements Collector<T> {
    private final Collector<T> delegate;
    private final JoinHashMap<T> hashMap;
    private final TypeSerializer<T> serializer;

    public SolutionSetObjectsUpdateOutputCollector(JoinHashMap<T> hashMap) {
        this(hashMap, null);
    }

    public SolutionSetObjectsUpdateOutputCollector(JoinHashMap<T> hashMap, Collector<T> delegate) {
        this.delegate = delegate;
        this.hashMap = hashMap;
        this.serializer = hashMap.getBuildSerializer();
    }

    public void collect(T record) {
        Object copy = this.serializer.copy(record);
        this.hashMap.insertOrReplace(copy);
        if (this.delegate != null) {
            this.delegate.collect(record);
        }
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }
}

