/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.handlers.coordination.v1;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.coordination.v1.LeaseBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.WritableOperation;
import io.fabric8.kubernetes.client.dsl.internal.coordination.v1.LeaseOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.apache.flink.kubernetes.shaded.okhttp3.OkHttpClient;

public class LeaseHandler
implements ResourceHandler<Lease, LeaseBuilder> {
    @Override
    public String getKind() {
        return Lease.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "coordination.k8s.io/v1";
    }

    @Override
    public Lease create(OkHttpClient client, Config config, String namespace, Lease item, boolean dryRun) {
        return (Lease)((WritableOperation)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new Lease[0]);
    }

    @Override
    public Lease replace(OkHttpClient client, Config config, String namespace, Lease item, boolean dryRun) {
        return ((WritableOperation)((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public Lease reload(OkHttpClient client, Config config, String namespace, Lease item) {
        return (Lease)((Gettable)((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public LeaseBuilder edit(Lease item) {
        return new LeaseBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Lease item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new LeaseOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Lease item, Watcher<Lease> watcher) {
        return ((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Lease item, String resourceVersion, Watcher<Lease> watcher) {
        return ((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Lease item, ListOptions options, Watcher<Lease> watcher) {
        return ((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Lease waitUntilReady(OkHttpClient client, Config config, String namespace, Lease item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Lease)((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Lease waitUntilCondition(OkHttpClient client, Config config, String namespace, Lease item, Predicate<Lease> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Lease)((Resource)new LeaseOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

