/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes.watcher;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.flink.kubernetes.ChangeEventBus;
import org.apache.streampark.flink.kubernetes.FlinkK8sWatchController;
import org.apache.streampark.flink.kubernetes.JobStatusWatcherConfig;
import org.apache.streampark.flink.kubernetes.KubernetesRetriever$;
import org.apache.streampark.flink.kubernetes.enums.FlinkJobState$;
import org.apache.streampark.flink.kubernetes.enums.FlinkK8sExecuteMode$;
import org.apache.streampark.flink.kubernetes.event.FlinkJobStatusChangeEvent;
import org.apache.streampark.flink.kubernetes.helper.KubernetesDeploymentHelper$;
import org.apache.streampark.flink.kubernetes.model.ClusterKey;
import org.apache.streampark.flink.kubernetes.model.ClusterKey$;
import org.apache.streampark.flink.kubernetes.model.JobStatusCV;
import org.apache.streampark.flink.kubernetes.model.JobStatusCV$;
import org.apache.streampark.flink.kubernetes.model.TrackId;
import org.apache.streampark.flink.kubernetes.watcher.FlinkHistoryArchives$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkJobStatusWatcher$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkWatcher;
import org.apache.streampark.flink.kubernetes.watcher.JobDetail;
import org.apache.streampark.flink.kubernetes.watcher.JobDetails;
import org.apache.streampark.flink.kubernetes.watcher.JobDetails$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.LazyLong;
import scala.runtime.NonLocalReturnControl;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001\u0002\u0012$\u0001AB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u0011\u0002\u0011)\u0019!C\u0002\u0013\"AQ\n\u0001B\u0001B\u0003%!\n\u0003\u0005O\u0001\t\u0015\r\u0011b\u0001P\u0011!\u0019\u0006A!A!\u0002\u0013\u0001\u0006\"\u0002+\u0001\t\u0003)\u0006bB.\u0001\u0005\u0004%I\u0001\u0018\u0005\u0007M\u0002\u0001\u000b\u0011B/\t\u000f\u001d\u0004!\u0019!C\u0006Q\"1a\u000e\u0001Q\u0001\n%Dqa\u001c\u0001C\u0002\u0013%\u0001\u000f\u0003\u0004u\u0001\u0001\u0006I!\u001d\u0005\nk\u0002\u0001\r\u00111A\u0005\nYD1\"a\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0012!Iq\u0010\u0001a\u0001\u0002\u0003\u0006Ka\u001e\u0005\b\u0003K\u0001A\u0011IA\u0014\u0011\u001d\tI\u0003\u0001C!\u0003OAq!a\u000b\u0001\t\u0003\n9\u0003C\u0004\u0002.\u0001!\t%a\n\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!9\u0011\u0011\r\u0001\u0005\n\u0005\r\u0004bBA?\u0001\u0011\u0005\u0011q\u0010\u0005\t\u0003\u000b\u0003\u0001\u0015\"\u0003\u0002\b\"A\u0011q\u0012\u0001!\n\u0013\t\t\nC\u0004\u0002\u0018\u0002!I!!'\t\u000f\u00055\u0006\u0001\"\u0003\u00020\"9\u00111\u0018\u0001\u0005\n\u0005u\u0006\u0002CAh\u0001\u0001&I!!5\b\u000f\u0005e8\u0005#\u0001\u0002|\u001a1!e\tE\u0001\u0003{Da\u0001\u0016\u0010\u0005\u0002\u0005}\bb\u0002B\u0001=\u0011\u0005!1\u0001\u0005\n\u0005\u001bq\u0012\u0013!C\u0001\u0005\u001f\u0011QC\u00127j].TuNY*uCR,8oV1uG\",'O\u0003\u0002%K\u00059q/\u0019;dQ\u0016\u0014(B\u0001\u0014(\u0003)YWOY3s]\u0016$Xm\u001d\u0006\u0003Q%\nQA\u001a7j].T!AK\u0016\u0002\u0015M$(/Z1na\u0006\u00148N\u0003\u0002-[\u00051\u0011\r]1dQ\u0016T\u0011AL\u0001\u0004_J<7\u0001A\n\u0005\u0001E:t\b\u0005\u00023k5\t1GC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14G\u0001\u0004B]f\u0014VM\u001a\t\u0003quj\u0011!\u000f\u0006\u0003um\nA!\u001e;jY*\u0011A(K\u0001\u0007G>lWn\u001c8\n\u0005yJ$A\u0002'pO\u001e,'\u000f\u0005\u0002A\u00036\t1%\u0003\u0002CG\taa\t\\5oW^\u000bGo\u00195fe\u0006!1m\u001c8g!\t)e)D\u0001&\u0013\t9UE\u0001\fK_\n\u001cF/\u0019;vg^\u000bGo\u00195fe\u000e{gNZ5h\u0003=9\u0018\r^2i\u0007>tGO]8mY\u0016\u0014X#\u0001&\u0011\u0005\u0015[\u0015B\u0001'&\u0005]1E.\u001b8l\u0017b\u001ax+\u0019;dQ\u000e{g\u000e\u001e:pY2,'/\u0001\txCR\u001c\u0007nQ8oiJ|G\u000e\\3sA\u0005AQM^3oi\n+8/F\u0001Q!\t)\u0015+\u0003\u0002SK\tq1\t[1oO\u0016,e/\u001a8u\u0005V\u001c\u0018!C3wK:$()^:!\u0003\u0019a\u0014N\\5u}Q\u0011aK\u0017\u000b\u0004/bK\u0006C\u0001!\u0001\u0011\u0015Ae\u0001q\u0001K\u0011\u0015qe\u0001q\u0001Q\u0011\u001d\u0019e\u0001%AA\u0002\u0011\u000b\u0011\u0003\u001e:bG.$\u0016m]6Fq\u0016\u001c\u0007k\\8m+\u0005i\u0006C\u00010e\u001b\u0005y&B\u00011b\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003u\tT\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002f?\nyQ\t_3dkR|'oU3sm&\u001cW-\u0001\nue\u0006\u001c7\u000eV1tW\u0016CXm\u0019)p_2\u0004\u0013!\u0005;sC\u000e\\G+Y:l\u000bb,7-\u001e;peV\t\u0011\u000e\u0005\u0002kY6\t1N\u0003\u0002ag%\u0011Qn\u001b\u0002 \u000bb,7-\u001e;j_:\u001cuN\u001c;fqR,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017A\u0005;sC\u000e\\G+Y:l\u000bb,7-\u001e;pe\u0002\n\u0011\u0002^5nKJ,\u00050Z2\u0016\u0003E\u0004\"A\u0018:\n\u0005M|&\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\u0006QA/[7fe\u0016CXm\u0019\u0011\u0002\u001bQLW.\u001a:TG\",G-\u001e7f+\u00059\bG\u0001=~!\rq\u0016p_\u0005\u0003u~\u0013qbU2iK\u0012,H.\u001a3GkR,(/\u001a\t\u0003yvd\u0001\u0001\u0002\u0006\u007f\u001f\u0005\u0005\t\u0011!B\u0001\u0003\u0003\u00111a\u0018\u00132\u00039!\u0018.\\3s'\u000eDW\rZ;mK\u0002\nB!a\u0001\u0002\nA\u0019!'!\u0002\n\u0007\u0005\u001d1GA\u0004O_RD\u0017N\\4\u0011\u0007I\nY!C\u0002\u0002\u000eM\u00121!\u00118z\u0003E!\u0018.\\3s'\u000eDW\rZ;mK~#S-\u001d\u000b\u0005\u0003'\tI\u0002E\u00023\u0003+I1!a\u00064\u0005\u0011)f.\u001b;\t\u0013\u0005ma\"!AA\u0002\u0005u\u0011a\u0001=%cA\"\u0011qDA\u0012!\u0011q\u00160!\t\u0011\u0007q\f\u0019\u0003B\u0006\u007f\u00033\t\t\u0011!A\u0003\u0002\u0005\u0005\u0011a\u00023p'R\f'\u000f\u001e\u000b\u0003\u0003'\ta\u0001Z8Ti>\u0004\u0018a\u00023p\u00072|7/Z\u0001\bI><\u0016\r^2i\u0003=!x.^2i'\u0016\u001c8/[8o\u0015>\u0014G\u0003BA\u001a\u0003\u000b\u0002RAMA\u001b\u0003sI1!a\u000e4\u0005\u0019y\u0005\u000f^5p]B!\u00111HA!\u001b\t\tiDC\u0002\u0002@\u0015\nQ!\\8eK2LA!a\u0011\u0002>\tY!j\u001c2Ti\u0006$Xo]\"W\u0011\u001d\t9\u0005\u0006a\u0001\u0003\u0013\nq\u0001\u001e:bG.LE\r\u0005\u0003\u0002<\u0005-\u0013\u0002BA'\u0003{\u0011q\u0001\u0016:bG.LE\r\u000b\u0003\u0002F\u0005E\u0003\u0003BA*\u0003;j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\u000bC:tw\u000e^1uS>t'BAA.\u0003\u0015Q\u0017M^1y\u0013\u0011\ty&!\u0016\u0003\u000f9{gN\\;mY\u0006\u0011Bo\\;dQN+7o]5p]\u0006cGNS8c)\u0011\t)'a\u001f\u0011\u0011\u0005\u001d\u0014QOA%\u0003sqA!!\u001b\u0002rA\u0019\u00111N\u001a\u000e\u0005\u00055$bAA8_\u00051AH]8pizJ1!a\u001d4\u0003\u0019\u0001&/\u001a3fM&!\u0011qOA=\u0005\ri\u0015\r\u001d\u0006\u0004\u0003g\u001a\u0004bBA$+\u0001\u0007\u0011\u0011J\u0001\u0014i>,8\r[!qa2L7-\u0019;j_:TuN\u0019\u000b\u0005\u0003g\t\t\tC\u0004\u0002HY\u0001\r!!\u0013)\t\u0005\u0005\u0015\u0011K\u0001\fkB$\u0017\r^3Ti\u0006$X\r\u0006\u0004\u0002\u0014\u0005%\u00151\u0012\u0005\b\u0003\u000f:\u0002\u0019AA%\u0011\u001d\tii\u0006a\u0001\u0003s\t\u0001B[8c'R\fG/Z\u0001\u000bS:4WM]*uCR,G\u0003BA\u001a\u0003'Cq!!&\u0019\u0001\u0004\tI%\u0001\u0002jI\u0006yA.[:u\u0015>\u00147\u000fR3uC&d7\u000f\u0006\u0003\u0002\u001c\u0006\r\u0006#\u0002\u001a\u00026\u0005u\u0005c\u0001!\u0002 &\u0019\u0011\u0011U\u0012\u0003\u0015){'\rR3uC&d7\u000fC\u0004\u0002&f\u0001\r!a*\u0002\u0015\rdWo\u001d;fe.+\u0017\u0010\u0005\u0003\u0002<\u0005%\u0016\u0002BAV\u0003{\u0011!b\u00117vgR,'oS3z\u0003Q\u0019\u0017\r\u001c7K_\n\u001cxJ^3sm&,wo]!qSR!\u00111TAY\u0011\u001d\t\u0019L\u0007a\u0001\u0003k\u000bqA]3tiV\u0013H\u000e\u0005\u0003\u0002h\u0005]\u0016\u0002BA]\u0003s\u0012aa\u0015;sS:<\u0017AF5oM\u0016\u00148\u000b^1uK\u001a\u0013x.\\&9g\u00163XM\u001c;\u0015\t\u0005}\u00161\u001a\u000b\u0005\u0003g\t\t\rC\u0004\u0002Dn\u0001\u001d!!2\u0002\u0019A|G\u000e\\#nSR$\u0016.\\3\u0011\u0007I\n9-C\u0002\u0002JN\u0012A\u0001T8oO\"9\u0011qI\u000eA\u0002\u0005%\u0003\u0006BAf\u0003#\n\u0011#\u001b8gKJ4%o\\7Qe\u0016\u001c\u0015m\u00195f)\u0011\t\u0019.!;\u0011\t\u0005U\u0017\u0011\u001d\b\u0005\u0003/\fi.\u0004\u0002\u0002Z*\u0019\u00111\\\u0013\u0002\u000b\u0015tW/\\:\n\t\u0005}\u0017\u0011\\\u0001\u000e\r2Lgn\u001b&pEN#\u0018\r^3\n\t\u0005\r\u0018Q\u001d\u0002\u0006-\u0006dW/Z\u0005\u0004\u0003O\u001c$aC#ok6,'/\u0019;j_:Dq!a;\u001d\u0001\u0004\tI$\u0001\u0005qe\u0016\u001c\u0015m\u00195fQ\r\u0001\u0011q\u001e\t\u0005\u0003c\f)0\u0004\u0002\u0002t*\u0019\u0001-!\u0016\n\t\u0005]\u00181\u001f\u0002\u000b)\"\u0014X-\u00193TC\u001a,\u0017!\u0006$mS:\\'j\u001c2Ti\u0006$Xo],bi\u000eDWM\u001d\t\u0003\u0001z\u0019\"AH\u0019\u0015\u0005\u0005m\u0018!H5oM\u0016\u0014h\t\\5oW*{'m\u0015;bi\u00164%o\\7QKJ\u001c\u0018n\u001d;\u0015\r\u0005M'Q\u0001B\u0005\u0011\u001d\u00119\u0001\ta\u0001\u0003'\fqaY;se\u0016tG\u000fC\u0004\u0003\f\u0001\u0002\r!a5\u0002\u0011A\u0014XM^5pkN\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nTC\u0001B\tU\r!%1C\u0016\u0003\u0005+\u0001BAa\u0006\u0003 5\u0011!\u0011\u0004\u0006\u0005\u00057\u0011i\"A\u0005v]\u000eDWmY6fI*\u0019\u0011qK\u001a\n\t\t\u0005\"\u0011\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
@ThreadSafe
public class FlinkJobStatusWatcher
implements Logger,
FlinkWatcher {
    private final JobStatusWatcherConfig conf;
    private final FlinkK8sWatchController watchController;
    private final ChangeEventBus eventBus;
    private final ExecutorService trackTaskExecPool;
    private final ExecutionContextExecutorService trackTaskExecutor;
    private final ScheduledExecutorService timerExec;
    private ScheduledFuture<?> timerSchedule;
    private final AtomicBoolean org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    public static JobStatusWatcherConfig $lessinit$greater$default$1() {
        return FlinkJobStatusWatcher$.MODULE$.$lessinit$greater$default$1();
    }

    public static Enumeration.Value inferFlinkJobStateFromPersist(Enumeration.Value value, Enumeration.Value value2) {
        return FlinkJobStatusWatcher$.MODULE$.inferFlinkJobStateFromPersist(value, value2);
    }

    @Override
    public void start() {
        FlinkWatcher.start$(this);
    }

    @Override
    public void stop() {
        FlinkWatcher.stop$(this);
    }

    @Override
    public void close() {
        FlinkWatcher.close$(this);
    }

    @Override
    public void restart() {
        FlinkWatcher.restart$(this);
    }

    @Override
    public Runnable funcToRunnable(Function0<BoxedUnit> fun) {
        return FlinkWatcher.funcToRunnable$(this, fun);
    }

    public String logName() {
        return Logger.logName$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.logInfo$((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.logDebug$((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.logTrace$((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.logWarn$((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.logError$((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$((Logger)this);
    }

    @Override
    public AtomicBoolean org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started() {
        return this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started;
    }

    @Override
    public final void org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$_setter_$org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started_$eq(AtomicBoolean x$1) {
        this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started = x$1;
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public FlinkK8sWatchController watchController() {
        return this.watchController;
    }

    public ChangeEventBus eventBus() {
        return this.eventBus;
    }

    private ExecutorService trackTaskExecPool() {
        return this.trackTaskExecPool;
    }

    private ExecutionContextExecutorService trackTaskExecutor() {
        return this.trackTaskExecutor;
    }

    private ScheduledExecutorService timerExec() {
        return this.timerExec;
    }

    private ScheduledFuture<?> timerSchedule() {
        return this.timerSchedule;
    }

    private void timerSchedule_$eq(ScheduledFuture<?> x$1) {
        this.timerSchedule = x$1;
    }

    @Override
    public void doStart() {
        this.timerSchedule_$eq(this.timerExec().scheduleAtFixedRate(() -> this.doWatch(), 0L, this.conf.requestIntervalSec(), TimeUnit.SECONDS));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkJobStatusWatcher started.");
    }

    @Override
    public void doStop() {
        this.timerSchedule().cancel(true);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkJobStatusWatcher stopped.");
    }

    @Override
    public void doClose() {
        this.timerExec().shutdownNow();
        this.trackTaskExecutor().shutdownNow();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkJobStatusWatcher closed.");
    }

    @Override
    public void doWatch() {
        Object object = new Object();
        try {
            FlinkJobStatusWatcher flinkJobStatusWatcher = this;
            synchronized (flinkJobStatusWatcher) {
                Set trackIds = (Set)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.watchController().getAllWatchingIds()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                });
                Set appFuture = (Set)((SetLike)trackIds.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FlinkJobStatusWatcher.$anonfun$doWatch$4(x$2)))).map((Function1 & Serializable & scala.Serializable)id -> {
                    void var2_2;
                    Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.touchApplicationJob((TrackId)id), (ExecutionContext)this.trackTaskExecutor());
                    future.onComplete((Function1 & Serializable & scala.Serializable)x$3 -> {
                        FlinkJobStatusWatcher.$anonfun$doWatch$7(this, id, x$3);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)this.trackTaskExecutor());
                    return var2_2;
                }, Set$.MODULE$.canBuildFrom());
                Set sessionIds = (Set)trackIds.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FlinkJobStatusWatcher.$anonfun$doWatch$9(x$4)));
                Set sessionCluster = ((TraversableOnce)sessionIds.groupBy((Function1 & Serializable & scala.Serializable)x$5 -> x$5.toClusterKey().toString()).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> (Set)x$6._2(), Iterable$.MODULE$.canBuildFrom())).toSet();
                Set sessionFuture = (Set)sessionCluster.map((Function1 & Serializable & scala.Serializable)id -> {
                    void var3_3;
                    Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.touchSessionAllJob((TrackId)id), (ExecutionContext)this.trackTaskExecutor());
                    future.onComplete((Function1 & Serializable & scala.Serializable)x$7 -> {
                        FlinkJobStatusWatcher.$anonfun$doWatch$14(this, sessionIds, x$7);
                        return BoxedUnit.UNIT;
                    }, (ExecutionContext)this.trackTaskExecutor());
                    return var3_3;
                }, Set$.MODULE$.canBuildFrom());
                Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Future)Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)appFuture, Set$.MODULE$.canBuildFrom(), (ExecutionContext)this.trackTaskExecutor()), (Duration)new package.DurationLong(package$.MODULE$.DurationLong($this.conf.requestTimeoutSec())).seconds())).failed().map((Function1 & Serializable & scala.Serializable)x$9 -> {
                    this.logWarn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("[FlinkJobStatusWatcher] tracking flink job status on kubernetes native application mode timeout,").append(new StringBuilder(15).append(" limitSeconds=").append($this.conf.requestTimeoutSec()).append(",").toString()).append(new StringBuilder(10).append(" trackIds=").append(trackIds$1.mkString(",")).toString()).toString());
                    return BoxedUnit.UNIT;
                });
                Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Future)Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)sessionFuture, Set$.MODULE$.canBuildFrom(), (ExecutionContext)this.trackTaskExecutor()), (Duration)new package.DurationLong(package$.MODULE$.DurationLong($this.conf.requestTimeoutSec())).seconds())).failed().map((Function1 & Serializable & scala.Serializable)x$10 -> {
                    this.logWarn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("[FlinkJobStatusWatcher] tracking flink job status on kubernetes native session mode timeout,").append(new StringBuilder(15).append(" limitSeconds=").append($this.conf.requestTimeoutSec()).append(",").toString()).append(new StringBuilder(10).append(" trackIds=").append(trackIds$1.mkString(",")).toString()).toString());
                    return BoxedUnit.UNIT;
                });
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public Option<JobStatusCV> touchSessionJob(@Nonnull TrackId trackId) {
        return this.touchSessionAllJob(trackId).find((Function1 & Serializable & scala.Serializable)id -> BoxesRunTime.boxToBoolean((boolean)FlinkJobStatusWatcher.$anonfun$touchSessionJob$1(trackId, id))).map((Function1 & Serializable & scala.Serializable)x$11 -> (JobStatusCV)x$11._2()).orElse((Function0 & Serializable & scala.Serializable)() -> this.inferState(trackId));
    }

    private Map<TrackId, JobStatusCV> touchSessionAllJob(TrackId trackId) {
        Map map;
        Some some;
        JobDetails details;
        long pollEmitTime = System.currentTimeMillis();
        Option<JobDetails> jobDetails = this.listJobsDetails(ClusterKey$.MODULE$.of(trackId));
        Option<JobDetails> option = jobDetails;
        if (option instanceof Some && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(details = (JobDetails)(some = (Some)option).value()).jobs())).nonEmpty()) {
            map = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])details.jobs())).map((Function1 & Serializable & scala.Serializable)d -> {
                JobStatusCV jobStatus = d.toJobStatusCV(pollEmitTime, System.currentTimeMillis());
                String x$1 = d.jid();
                Object x$2 = null;
                Enumeration.Value x$3 = trackId.copy$default$1();
                String x$4 = trackId.copy$default$2();
                String x$5 = trackId.copy$default$3();
                String x$6 = trackId.copy$default$6();
                TrackId trackItem = trackId.copy(x$3, x$4, x$5, null, x$1, x$6);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)trackItem), (Object)jobStatus);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        } else if (None$.MODULE$.equals(option)) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            throw new MatchError(option);
        }
        return map;
    }

    public Option<JobStatusCV> touchApplicationJob(@Nonnull TrackId trackId) {
        long pollEmitTime = System.currentTimeMillis();
        Option<JobDetails> jobDetails = this.listJobsDetails(ClusterKey$.MODULE$.of(trackId));
        return jobDetails.isEmpty() || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((JobDetails)jobDetails.get()).jobs())).isEmpty() ? this.inferStateFromK8sEvent(trackId, pollEmitTime) : new Some((Object)((JobDetail)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((JobDetails)jobDetails.get()).jobs())).head()).toJobStatusCV(pollEmitTime, System.currentTimeMillis()));
    }

    private void updateState(TrackId trackId, JobStatusCV jobState) {
        block2: {
            LazyBoolean deployExists$lzy = new LazyBoolean();
            JobStatusCV latest = this.watchController().jobStatuses().get(trackId);
            if (jobState.diff(latest)) {
                this.watchController().jobStatuses().put(trackId, jobState);
                this.watchController().trackIds().update(trackId);
                this.eventBus().postSync(new FlinkJobStatusChangeEvent(trackId, jobState));
            }
            if (!FlinkJobState$.MODULE$.isEndState(jobState.jobState()) || FlinkJobStatusWatcher.deployExists$1(deployExists$lzy, trackId)) break block2;
            this.watchController().unWatching(trackId);
            Enumeration.Value value = trackId.executeMode();
            Enumeration.Value value2 = FlinkK8sExecuteMode$.MODULE$.APPLICATION();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                this.watchController().endpoints().invalidate(trackId.toClusterKey());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private Option<JobStatusCV> inferState(TrackId id) {
        pollEmitTime$lzy = new LazyLong();
        preCache = this.watchController().jobStatuses().get(id);
        v0 = state = this.inferFromPreCache(preCache);
        var6_5 = FlinkJobState$.MODULE$.SILENT();
        if ((v0 != null ? v0.equals(var6_5) == false : var6_5 != null) || preCache == null) ** GOTO lbl-1000
        v1 = preCache.jobState();
        var7_6 = FlinkJobState$.MODULE$.SILENT();
        if (!(v1 != null ? v1.equals(var7_6) == false : var7_6 != null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = nonFirstSilent = false;
        }
        if (nonFirstSilent) {
            x$1 = state;
            x$2 = id.jobId();
            x$3 = preCache.pollEmitTime();
            x$4 = preCache.pollAckTime();
            x$5 = JobStatusCV$.MODULE$.apply$default$3();
            x$6 = JobStatusCV$.MODULE$.apply$default$4();
            x$7 = JobStatusCV$.MODULE$.apply$default$5();
            x$8 = JobStatusCV$.MODULE$.apply$default$6();
            x$9 = JobStatusCV$.MODULE$.apply$default$7();
            v3 = new JobStatusCV(x$1, x$2, x$5, x$6, x$7, x$8, x$9, x$3, x$4);
        } else {
            x$10 = state;
            x$11 = id.jobId();
            x$12 = FlinkJobStatusWatcher.pollEmitTime$2(pollEmitTime$lzy);
            x$13 = System.currentTimeMillis();
            x$14 = JobStatusCV$.MODULE$.apply$default$3();
            x$15 = JobStatusCV$.MODULE$.apply$default$4();
            x$16 = JobStatusCV$.MODULE$.apply$default$5();
            x$17 = JobStatusCV$.MODULE$.apply$default$6();
            x$18 = JobStatusCV$.MODULE$.apply$default$7();
            v3 = new JobStatusCV(x$10, x$11, x$14, x$15, x$16, x$17, x$18, x$12, x$13);
        }
        jobState = v3;
        return Option$.MODULE$.apply((Object)jobState);
    }

    private Option<JobDetails> listJobsDetails(ClusterKey clusterKey) {
        Option option;
        Object object = new Object();
        try {
            option = (Option)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String clusterRestUrl = (String)this.watchController().getClusterRestUrl(clusterKey).filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)FlinkJobStatusWatcher.$anonfun$listJobsDetails$2(x$12))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                });
                return this.callJobsOverviewsApi(clusterRestUrl);
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Option option;
                this.logger().warn("Failed to visit remote flink jobs on kubernetes-native-mode cluster, and the retry access logic is performed.");
                String clusterRestUrl = (String)this.watchController().refreshClusterRestUrl(clusterKey).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                });
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.callJobsOverviewsApi(clusterRestUrl));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Option s = (Option)success.value();
                    this.logger().info("The retry is successful.");
                    option = s;
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    this.logger().warn(new StringBuilder(57).append("The retry fetch failed, final status failed, errorStack=").append(e.getMessage()).append(".").toString());
                    option = None$.MODULE$;
                } else {
                    throw new MatchError((Object)try_);
                }
                return option;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private Option<JobDetails> callJobsOverviewsApi(String restUrl) {
        return JobDetails$.MODULE$.as(Request.get((String)new StringBuilder(14).append(restUrl).append("/jobs/overview").toString()).connectTimeout(KubernetesRetriever$.MODULE$.FLINK_REST_AWAIT_TIMEOUT_SEC()).responseTimeout(KubernetesRetriever$.MODULE$.FLINK_CLIENT_TIMEOUT_SEC()).execute().returnContent().asString(StandardCharsets.UTF_8));
    }

    /*
     * Enabled aggressive block sorting
     */
    private Option<JobStatusCV> inferStateFromK8sEvent(@Nonnull TrackId trackId, long pollEmitTime) {
        Some some;
        Enumeration.Value jobState;
        Enumeration.Value value;
        JobStatusCV latest;
        block10: {
            Enumeration.Value value2;
            block8: {
                boolean isConnection;
                block11: {
                    block9: {
                        latest = this.watchController().jobStatuses().get(trackId);
                        TrackId trackId2 = trackId;
                        if (!this.watchController().canceling().has(trackId2)) break block9;
                        this.logger().info(new StringBuilder(21).append("trackId ").append(trackId.toString()).append(" is canceling").toString());
                        value = FlinkJobState$.MODULE$.CANCELED();
                        break block10;
                    }
                    boolean deployExists = KubernetesRetriever$.MODULE$.isDeploymentExists(trackId.namespace(), trackId.clusterId());
                    isConnection = KubernetesDeploymentHelper$.MODULE$.checkConnection();
                    if (!deployExists) break block11;
                    boolean deployError = KubernetesDeploymentHelper$.MODULE$.isDeploymentError(trackId.namespace(), trackId.clusterId());
                    if (!deployError) {
                        this.logger().info("Task Enter the initialization process.");
                        value2 = FlinkJobState$.MODULE$.K8S_INITIALIZING();
                        break block8;
                    } else if (isConnection) {
                        this.logger().info("Enter the task failure deletion process.");
                        KubernetesDeploymentHelper$.MODULE$.watchPodTerminatedLog(trackId.namespace(), trackId.clusterId(), trackId.jobId());
                        value2 = FlinkJobState$.MODULE$.FAILED();
                        break block8;
                    } else {
                        value2 = this.inferFromPreCache(latest);
                    }
                    break block8;
                }
                if (isConnection) {
                    this.logger().info("The deployment is deleted and enters the task failure process.");
                    value2 = FlinkJobState$.MODULE$.of(FlinkHistoryArchives$.MODULE$.getJobStateFromArchiveFile(trackId.jobId()));
                } else {
                    value2 = this.inferFromPreCache(latest);
                }
            }
            value = value2;
        }
        Enumeration.Value x$1 = jobState = value;
        String x$2 = trackId.jobId();
        long x$3 = pollEmitTime;
        long x$4 = System.currentTimeMillis();
        String x$5 = JobStatusCV$.MODULE$.apply$default$3();
        long x$6 = JobStatusCV$.MODULE$.apply$default$4();
        long x$7 = JobStatusCV$.MODULE$.apply$default$5();
        long x$8 = JobStatusCV$.MODULE$.apply$default$6();
        int x$9 = JobStatusCV$.MODULE$.apply$default$7();
        JobStatusCV jobStatusCV = new JobStatusCV(x$1, x$2, x$5, x$6, x$7, x$8, x$9, x$3, x$4);
        Enumeration.Value value3 = jobState;
        Enumeration.Value value4 = FlinkJobState$.MODULE$.SILENT();
        if (!(value3 != null ? !value3.equals(value4) : value4 != null) && latest != null) {
            Enumeration.Value value5 = latest.jobState();
            Enumeration.Value value6 = FlinkJobState$.MODULE$.SILENT();
            if (!(value5 != null ? !value5.equals(value6) : value6 != null)) {
                long x$10 = latest.pollEmitTime();
                long x$11 = latest.pollAckTime();
                Enumeration.Value x$12 = jobStatusCV.copy$default$1();
                String x$13 = jobStatusCV.copy$default$2();
                String x$14 = jobStatusCV.copy$default$3();
                long x$15 = jobStatusCV.copy$default$4();
                long x$16 = jobStatusCV.copy$default$5();
                long x$17 = jobStatusCV.copy$default$6();
                int x$18 = jobStatusCV.copy$default$7();
                Some some2 = new Some((Object)jobStatusCV.copy(x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$10, x$11));
                some = some2;
                return some;
            }
        }
        some = new Some((Object)jobStatusCV);
        return some;
    }

    private Enumeration.Value inferFromPreCache(JobStatusCV preCache) {
        Enumeration.Value value;
        JobStatusCV jobStatusCV = preCache;
        if (jobStatusCV == null) {
            value = FlinkJobState$.MODULE$.SILENT();
        } else {
            Enumeration.Value value2 = jobStatusCV.jobState();
            Enumeration.Value value3 = FlinkJobState$.MODULE$.SILENT();
            value = !(value2 != null ? !value2.equals(value3) : value3 != null) && System.currentTimeMillis() - jobStatusCV.pollAckTime() >= (long)(this.conf.silentStateJobKeepTrackingSec() * 1000) ? FlinkJobState$.MODULE$.LOST() : FlinkJobState$.MODULE$.SILENT();
        }
        return value;
    }

    public static final /* synthetic */ boolean $anonfun$doWatch$4(TrackId x$2) {
        Enumeration.Value value = x$2.executeMode();
        Enumeration.Value value2 = FlinkK8sExecuteMode$.MODULE$.APPLICATION();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ void $anonfun$doWatch$7(FlinkJobStatusWatcher $this, TrackId id$1, Try x$3) {
        Option option = (Option)x$3.getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
        if (option instanceof Some) {
            Some some = (Some)option;
            JobStatusCV jobState = (JobStatusCV)some.value();
            String x$1 = jobState.jobId();
            Enumeration.Value x$2 = id$1.copy$default$1();
            String x$32 = id$1.copy$default$2();
            String x$4 = id$1.copy$default$3();
            Long x$5 = id$1.copy$default$4();
            String x$6 = id$1.copy$default$6();
            $this.updateState(id$1.copy(x$2, x$32, x$4, x$5, x$1, x$6), jobState);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$doWatch$9(TrackId x$4) {
        Enumeration.Value value = x$4.executeMode();
        Enumeration.Value value2 = FlinkK8sExecuteMode$.MODULE$.SESSION();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$doWatch$16(TrackId id$3, Tuple2 x$8) {
        String string = ((TrackId)x$8._1()).jobId();
        String string2 = id$3.jobId();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$doWatch$15(FlinkJobStatusWatcher $this, Map map$1, TrackId id) {
        Option option = map$1.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)FlinkJobStatusWatcher.$anonfun$doWatch$16(id, x$8)));
        if (option instanceof Some) {
            Some some = (Some)option;
            Tuple2 job = (Tuple2)some.value();
            Long x$7 = id.appId();
            Enumeration.Value x$82 = ((TrackId)job._1()).copy$default$1();
            String x$9 = ((TrackId)job._1()).copy$default$2();
            String x$10 = ((TrackId)job._1()).copy$default$3();
            String x$11 = ((TrackId)job._1()).copy$default$5();
            String x$12 = ((TrackId)job._1()).copy$default$6();
            $this.updateState(((TrackId)job._1()).copy(x$82, x$9, x$10, x$7, x$11, x$12), (JobStatusCV)job._2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            $this.watchController().unWatching(id);
            Enumeration.Value x$13 = FlinkJobState$.MODULE$.LOST();
            String x$14 = id.jobId();
            long x$15 = System.currentTimeMillis();
            long x$16 = System.currentTimeMillis();
            String x$17 = JobStatusCV$.MODULE$.apply$default$3();
            long x$18 = JobStatusCV$.MODULE$.apply$default$4();
            long x$19 = JobStatusCV$.MODULE$.apply$default$5();
            long x$20 = JobStatusCV$.MODULE$.apply$default$6();
            int x$21 = JobStatusCV$.MODULE$.apply$default$7();
            JobStatusCV lostState = new JobStatusCV(x$13, x$14, x$17, x$18, x$19, x$20, x$21, x$15, x$16);
            $this.eventBus().postSync(new FlinkJobStatusChangeEvent(id, lostState));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$doWatch$14(FlinkJobStatusWatcher $this, Set sessionIds$1, Try x$7) {
        Option option = x$7.toOption();
        if (option instanceof Some) {
            Some some = (Some)option;
            Map map = (Map)some.value();
            sessionIds$1.foreach((Function1 & Serializable & scala.Serializable)id -> {
                FlinkJobStatusWatcher.$anonfun$doWatch$15($this, map, id);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$touchSessionJob$1(TrackId trackId$1, Tuple2 id) {
        String string = ((TrackId)id._1()).jobId();
        String string2 = trackId$1.jobId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        Enumeration.Value value = ((JobStatusCV)id._2()).jobState();
        Enumeration.Value value2 = FlinkJobState$.MODULE$.SILENT();
        if (value == null) {
            if (value2 == null) return false;
            return true;
        } else if (value.equals(value2)) return false;
        return true;
    }

    private static final /* synthetic */ boolean deployExists$lzycompute$1(LazyBoolean deployExists$lzy$1, TrackId trackId$3) {
        boolean bl;
        LazyBoolean lazyBoolean = deployExists$lzy$1;
        synchronized (lazyBoolean) {
            bl = deployExists$lzy$1.initialized() ? deployExists$lzy$1.value() : deployExists$lzy$1.initialize(KubernetesRetriever$.MODULE$.isDeploymentExists(trackId$3.namespace(), trackId$3.clusterId()));
        }
        return bl;
    }

    private static final boolean deployExists$1(LazyBoolean deployExists$lzy$1, TrackId trackId$3) {
        return deployExists$lzy$1.initialized() ? deployExists$lzy$1.value() : FlinkJobStatusWatcher.deployExists$lzycompute$1(deployExists$lzy$1, trackId$3);
    }

    private static final /* synthetic */ long pollEmitTime$lzycompute$1(LazyLong pollEmitTime$lzy$1) {
        long l;
        LazyLong lazyLong = pollEmitTime$lzy$1;
        synchronized (lazyLong) {
            l = pollEmitTime$lzy$1.initialized() ? pollEmitTime$lzy$1.value() : pollEmitTime$lzy$1.initialize(System.currentTimeMillis());
        }
        return l;
    }

    private static final long pollEmitTime$2(LazyLong pollEmitTime$lzy$1) {
        return pollEmitTime$lzy$1.initialized() ? pollEmitTime$lzy$1.value() : FlinkJobStatusWatcher.pollEmitTime$lzycompute$1(pollEmitTime$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$listJobsDetails$2(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).nonEmpty();
    }

    public FlinkJobStatusWatcher(JobStatusWatcherConfig conf, FlinkK8sWatchController watchController, ChangeEventBus eventBus) {
        this.conf = conf;
        this.watchController = watchController;
        this.eventBus = eventBus;
        Logger.$init$((Logger)this);
        FlinkWatcher.$init$(this);
        this.trackTaskExecPool = Executors.newWorkStealingPool();
        this.trackTaskExecutor = ExecutionContext$.MODULE$.fromExecutorService(this.trackTaskExecPool());
        this.timerExec = Executors.newSingleThreadScheduledExecutor();
    }
}

