/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.writer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.writer.ChannelSelector;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.util.Preconditions;

public final class ChannelSelectorRecordWriter<T extends IOReadableWritable>
extends RecordWriter<T> {
    private final ChannelSelector<T> channelSelector;

    ChannelSelectorRecordWriter(ResultPartitionWriter writer, ChannelSelector<T> channelSelector, long timeout, String taskName) {
        super(writer, timeout, taskName);
        this.channelSelector = (ChannelSelector)Preconditions.checkNotNull(channelSelector);
        this.channelSelector.setup(this.numberOfChannels);
    }

    @Override
    public void emit(T record) throws IOException {
        this.emit(record, this.channelSelector.selectChannel(record));
    }

    @Override
    public void broadcastEmit(T record) throws IOException {
        this.checkErroneous();
        ByteBuffer serializedRecord = ChannelSelectorRecordWriter.serializeRecord(this.serializer, record);
        for (int channelIndex = 0; channelIndex < this.numberOfChannels; ++channelIndex) {
            serializedRecord.rewind();
            this.emit(record, channelIndex);
        }
        if (this.flushAlways) {
            this.flushAll();
        }
    }
}

