/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.conf;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.streampark.common.util.CommandUtils$;
import org.apache.streampark.common.util.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001\u0002\n\u0014\u0001yA\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005k!)\u0011\t\u0001C\u0001\u0005\"Aa\t\u0001ECB\u0013%q\t\u0003\u0005P\u0001!\u0015\r\u0015\"\u0003H\u0011!\u0001\u0006\u0001#b!\n\u00139\u0005\u0002C)\u0001\u0011\u000b\u0007I\u0011\u0001\u001b\t\u0011I\u0003\u0001R1A\u0005\u0002QB\u0001b\u0015\u0001\t\u0006\u0004%\t\u0001\u0016\u0005\t1\u0002A)\u0019!C\u00013\"A\u0011\u000e\u0001EC\u0002\u0013\u0005A\u0007\u0003\u0005k\u0001!\u0015\r\u0011\"\u00015\u0011!Y\u0007\u0001#b\u0001\n\u0003!\u0006\"\u00027\u0001\t\u0003i\u0007bB:\u0001#\u0003%\t\u0001\u001e\u0005\t\u007f\u0002A)\u0019!C\u0001i!9\u0011\u0011\u0001\u0001\u0005B\u0005\r!\u0001\u0004$mS:\\g+\u001a:tS>t'B\u0001\u000b\u0016\u0003\u0011\u0019wN\u001c4\u000b\u0005Y9\u0012AB2p[6|gN\u0003\u0002\u00193\u0005Q1\u000f\u001e:fC6\u0004\u0018M]6\u000b\u0005iY\u0012AB1qC\u000eDWMC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\u0011\u0001q$J\u0017\u0011\u0005\u0001\u001aS\"A\u0011\u000b\u0003\t\nQa]2bY\u0006L!\u0001J\u0011\u0003\r\u0005s\u0017PU3g!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0002j_*\t!&\u0001\u0003kCZ\f\u0017B\u0001\u0017(\u00051\u0019VM]5bY&T\u0018M\u00197f!\tq\u0013'D\u00010\u0015\t\u0001T#\u0001\u0003vi&d\u0017B\u0001\u001a0\u0005\u0019aunZ4fe\u0006Ia\r\\5oW\"{W.Z\u000b\u0002kA\u0011a'\u0010\b\u0003om\u0002\"\u0001O\u0011\u000e\u0003eR!AO\u000f\u0002\rq\u0012xn\u001c;?\u0013\ta\u0014%\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u0012aa\u0015;sS:<'B\u0001\u001f\"\u0003)1G.\u001b8l\u0011>lW\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\r+\u0005C\u0001#\u0001\u001b\u0005\u0019\u0002\"B\u001a\u0004\u0001\u0004)\u0014!\u0005$M\u0013:[uLV#S?B\u000bE\u000bV#S\u001dV\t\u0001\n\u0005\u0002J\u001b6\t!J\u0003\u0002L\u0019\u0006)!/Z4fq*\u0011\u0001'K\u0005\u0003\u001d*\u0013q\u0001U1ui\u0016\u0014h.A\u000bG\u0019&s5j\u0018,F%NKuJT0Q\u0003R#VI\u0015(\u00027\u0019c\u0015JT&`'\u000e\u000bE*Q0W\u000bJ\u001b\u0016j\u0014(`!\u0006#F+\u0012*O\u00031\u00198-\u00197b-\u0016\u00148/[8o\u0003-1W\u000f\u001c7WKJ\u001c\u0018n\u001c8\u0002\u0011\u0019d\u0017N\\6MS\n,\u0012!\u0016\t\u0003MYK!aV\u0014\u0003\t\u0019KG.Z\u0001\nM2Lgn\u001b'jEN,\u0012A\u0017\t\u00047\u0002\u001cgB\u0001/_\u001d\tAT,C\u0001#\u0013\ty\u0016%A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0005\u0014'\u0001\u0002'jgRT!aX\u0011\u0011\u0005\u0011<W\"A3\u000b\u0005\u0019L\u0013a\u00018fi&\u0011\u0001.\u001a\u0002\u0004+Jc\u0015a\u0002<feNLwN\\\u0001\r[\u0006TwN\u001d,feNLwN\\\u0001\rM2Lgn\u001b#jgRT\u0015M]\u0001\rG\",7m\u001b,feNLwN\u001c\u000b\u0003]F\u0004\"\u0001I8\n\u0005A\f#a\u0002\"p_2,\u0017M\u001c\u0005\be:\u0001\n\u00111\u0001o\u00039!\bN]8x\u000bb\u001cW\r\u001d;j_:\fac\u00195fG.4VM]:j_:$C-\u001a4bk2$H%M\u000b\u0002k*\u0012aN^\u0016\u0002oB\u0011\u00010`\u0007\u0002s*\u0011!p_\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001`\u0011\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002\u007fs\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0019MD\u0017.\\:WKJ\u001c\u0018n\u001c8\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u000e")
public class FlinkVersion
implements Serializable,
Logger {
    private Pattern FLINK_VER_PATTERN;
    private Pattern org$apache$streampark$common$conf$FlinkVersion$$FLINK_VERSION_PATTERN;
    private Pattern FLINK_SCALA_VERSION_PATTERN;
    private String scalaVersion;
    private String fullVersion;
    private File flinkLib;
    private List<URL> flinkLibs;
    private String version;
    private String majorVersion;
    private File flinkDistJar;
    private String shimsVersion;
    private final String flinkHome;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;
    private volatile int bitmap$0;

    @Override
    public String logName() {
        return Logger.logName$(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger.logInfo$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger.logDebug$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger.logTrace$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger.logWarn$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$(this);
    }

    @Override
    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public String flinkHome() {
        return this.flinkHome;
    }

    private Pattern FLINK_VER_PATTERN$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 1) == 0) {
                this.FLINK_VER_PATTERN = Pattern.compile("^(\\d+\\.\\d+)(\\.)?.*$");
                this.bitmap$0 |= 1;
            }
        }
        return this.FLINK_VER_PATTERN;
    }

    private Pattern FLINK_VER_PATTERN() {
        return (this.bitmap$0 & 1) == 0 ? this.FLINK_VER_PATTERN$lzycompute() : this.FLINK_VER_PATTERN;
    }

    private Pattern FLINK_VERSION_PATTERN$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 2) == 0) {
                this.org$apache$streampark$common$conf$FlinkVersion$$FLINK_VERSION_PATTERN = Pattern.compile("^Version: (\\d+\\.\\d+\\.\\d+).*, Commit ID: (.*)$");
                this.bitmap$0 |= 2;
            }
        }
        return this.org$apache$streampark$common$conf$FlinkVersion$$FLINK_VERSION_PATTERN;
    }

    public Pattern org$apache$streampark$common$conf$FlinkVersion$$FLINK_VERSION_PATTERN() {
        return (this.bitmap$0 & 2) == 0 ? this.FLINK_VERSION_PATTERN$lzycompute() : this.org$apache$streampark$common$conf$FlinkVersion$$FLINK_VERSION_PATTERN;
    }

    private Pattern FLINK_SCALA_VERSION_PATTERN$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 4) == 0) {
                this.FLINK_SCALA_VERSION_PATTERN = Pattern.compile("^flink-dist_(\\d\\.\\d+).*.jar$");
                this.bitmap$0 |= 4;
            }
        }
        return this.FLINK_SCALA_VERSION_PATTERN;
    }

    private Pattern FLINK_SCALA_VERSION_PATTERN() {
        return (this.bitmap$0 & 4) == 0 ? this.FLINK_SCALA_VERSION_PATTERN$lzycompute() : this.FLINK_SCALA_VERSION_PATTERN;
    }

    private String scalaVersion$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 8) == 0) {
                Matcher matcher = this.FLINK_SCALA_VERSION_PATTERN().matcher(this.flinkDistJar().getName());
                this.scalaVersion = matcher.matches() ? matcher.group(1) : "2.12";
                this.bitmap$0 |= 8;
            }
        }
        return this.scalaVersion;
    }

    public String scalaVersion() {
        return (this.bitmap$0 & 8) == 0 ? this.scalaVersion$lzycompute() : this.scalaVersion;
    }

    private String fullVersion$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.fullVersion = new StringBuilder(1).append(this.version()).append("_").append(this.scalaVersion()).toString();
                this.bitmap$0 |= 0x10;
            }
        }
        return this.fullVersion;
    }

    public String fullVersion() {
        return (this.bitmap$0 & 0x10) == 0 ? this.fullVersion$lzycompute() : this.fullVersion;
    }

    /*
     * WARNING - void declaration
     */
    private File flinkLib$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 0x20) == 0) {
                void var2_2;
                Predef$.MODULE$.require(this.flinkHome() != null, (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] flinkHome must not be null.");
                Predef$.MODULE$.require(new File(this.flinkHome()).exists(), (Function0 & Serializable & scala.Serializable)() -> "[StreamPark] flinkHome must be exists.");
                File lib = new File(new StringBuilder(4).append(this.flinkHome()).append("/lib").toString());
                Predef$.MODULE$.require(lib.exists() && lib.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("[StreamPark] ").append(this.flinkHome()).append("/lib must be exists and must be directory.").toString());
                this.flinkLib = var2_2;
                this.bitmap$0 |= 0x20;
            }
        }
        return this.flinkLib;
    }

    public File flinkLib() {
        return (this.bitmap$0 & 0x20) == 0 ? this.flinkLib$lzycompute() : this.flinkLib;
    }

    private List<URL> flinkLibs$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.flinkLibs = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.flinkLib().listFiles())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toURI().toURL(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class))))).toList();
                this.bitmap$0 |= 0x40;
            }
        }
        return this.flinkLibs;
    }

    public List<URL> flinkLibs() {
        return (this.bitmap$0 & 0x40) == 0 ? this.flinkLibs$lzycompute() : this.flinkLibs;
    }

    private String version$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 0x80) == 0) {
                AtomicReference flinkVersion2 = new AtomicReference();
                .colon.colon cmd = new .colon.colon((Object)new StringBuilder(66).append("java -classpath ").append(this.flinkDistJar().getAbsolutePath()).append(" org.apache.flink.client.cli.CliFrontend --version").toString(), (List)Nil$.MODULE$);
                AtomicBoolean success = new AtomicBoolean(false);
                scala.collection.mutable.StringBuilder buffer = new scala.collection.mutable.StringBuilder();
                CommandUtils$.MODULE$.execute(this.flinkLib().getAbsolutePath(), JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)cmd), new Consumer<String>(this, buffer, success, flinkVersion2){
                    private final /* synthetic */ FlinkVersion $outer;
                    private final scala.collection.mutable.StringBuilder buffer$1;
                    private final AtomicBoolean success$1;
                    private final AtomicReference flinkVersion$1;

                    public Consumer<String> andThen(Consumer<? super String> x$1) {
                        return Consumer.super.andThen(x$1);
                    }

                    public void accept(String out) {
                        block0: {
                            this.buffer$1.append(out).append("\n");
                            Matcher matcher = this.$outer.org$apache$streampark$common$conf$FlinkVersion$$FLINK_VERSION_PATTERN().matcher(out);
                            if (!matcher.find()) break block0;
                            this.success$1.set(true);
                            this.flinkVersion$1.set(matcher.group(1));
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.buffer$1 = buffer$1;
                        this.success$1 = success$1;
                        this.flinkVersion$1 = flinkVersion$1;
                    }
                });
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> buffer.toString());
                if (!success.get()) {
                    throw new IllegalStateException(new StringBuilder(41).append("[StreamPark] parse flink version failed. ").append((CharSequence)buffer).toString());
                }
                buffer.clear();
                this.version = (String)flinkVersion2.get();
                this.bitmap$0 |= 0x80;
            }
        }
        return this.version;
    }

    public String version() {
        return (this.bitmap$0 & 0x80) == 0 ? this.version$lzycompute() : this.version;
    }

    private String majorVersion$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 0x100) == 0) {
                String string;
                if (this.version() == null) {
                    string = null;
                } else {
                    Matcher matcher = this.FLINK_VER_PATTERN().matcher(this.version());
                    matcher.matches();
                    string = matcher.group(1);
                }
                this.majorVersion = string;
                this.bitmap$0 |= 0x100;
            }
        }
        return this.majorVersion;
    }

    public String majorVersion() {
        return (this.bitmap$0 & 0x100) == 0 ? this.majorVersion$lzycompute() : this.majorVersion;
    }

    private File flinkDistJar$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 0x200) == 0) {
                File[] distJar = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.flinkLib().listFiles())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FlinkVersion.$anonfun$flinkDistJar$1(x$2)));
                File[] fileArray = distJar;
                if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileArray)).isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder(44).append("[StreamPark] can no found flink-dist jar in ").append(this.flinkLib()).toString());
                }
                if (fileArray.length > 1) {
                    throw new IllegalArgumentException(new StringBuilder(46).append("[StreamPark] found multiple flink-dist jar in ").append(this.flinkLib()).toString());
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                this.flinkDistJar = (File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])distJar)).head();
                this.bitmap$0 |= 0x200;
            }
        }
        return this.flinkDistJar;
    }

    public File flinkDistJar() {
        return (this.bitmap$0 & 0x200) == 0 ? this.flinkDistJar$lzycompute() : this.flinkDistJar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkVersion(boolean throwException) {
        int[] nArray = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.version().split("\\."))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)FlinkVersion.$anonfun$checkVersion$1(x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        Option option = Array$.MODULE$.unapplySeq((Object)nArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(3) == 0) {
            int n = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(0));
            int v = BoxesRunTime.unboxToInt((Object)((SeqLike)option.get()).apply(1));
            if (1 == n && v >= 12 && v <= 18) {
                return true;
            }
        }
        if (!throwException) return false;
        throw new UnsupportedOperationException(new StringBuilder(27).append("Unsupported flink version: ").append(this.version()).toString());
    }

    public boolean checkVersion$default$1() {
        return true;
    }

    private String shimsVersion$lzycompute() {
        FlinkVersion flinkVersion = this;
        synchronized (flinkVersion) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.shimsVersion = new StringBuilder(29).append("streampark-flink-shims_flink-").append(this.majorVersion()).toString();
                this.bitmap$0 |= 0x400;
            }
        }
        return this.shimsVersion;
    }

    public String shimsVersion() {
        return (this.bitmap$0 & 0x400) == 0 ? this.shimsVersion$lzycompute() : this.shimsVersion;
    }

    public String toString() {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(383).append("\n       |----------------------------------------- flink version -----------------------------------\n       |     flinkHome    : ").append(this.flinkHome()).append("\n       |     distJarName  : ").append(this.flinkDistJar().getName()).append("\n       |     flinkVersion : ").append(this.version()).append("\n       |     majorVersion : ").append(this.majorVersion()).append("\n       |     scalaVersion : ").append(this.scalaVersion()).append("\n       |     shimsVersion : ").append(this.shimsVersion()).append("\n       |-------------------------------------------------------------------------------------------\n       |").toString())).stripMargin();
    }

    public static final /* synthetic */ boolean $anonfun$flinkDistJar$1(File x$2) {
        return x$2.getName().matches("flink-dist.*\\.jar");
    }

    public static final /* synthetic */ int $anonfun$checkVersion$1(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3.trim())).toInt();
    }

    public FlinkVersion(String flinkHome) {
        this.flinkHome = flinkHome;
        Logger.$init$(this);
    }
}

