/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.core.annotation.PermissionAction;
import org.apache.streampark.console.core.enums.PermissionType;
import org.apache.streampark.console.system.entity.Member;
import org.apache.streampark.console.system.entity.Team;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.service.MemberService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="MEMBER_TAG")
@Validated
@RestController
@RequestMapping(value={"member"})
public class MemberController {
    private static final Logger log = LoggerFactory.getLogger(MemberController.class);
    @Autowired
    private MemberService memberService;

    @Operation(summary="List members")
    @PostMapping(value={"list"})
    public RestResponse memberList(RestRequest restRequest, Member member) {
        IPage<Member> userList = this.memberService.findUsers(member, restRequest);
        return RestResponse.success(userList);
    }

    @Operation(summary="List candidate users")
    @PostMapping(value={"candidateUsers"})
    public RestResponse candidateUsers(Long teamId) {
        List<User> userList = this.memberService.findCandidateUsers(teamId);
        return RestResponse.success(userList);
    }

    @Operation(summary="List teams")
    @PostMapping(value={"teams"})
    public RestResponse listTeams(Long userId) {
        List<Team> teamList = this.memberService.findUserTeams(userId);
        return RestResponse.success(teamList);
    }

    @Operation(summary="Check the username")
    @PostMapping(value={"check/user"})
    public RestResponse check(@NotBlank(message="{required}") @NotBlank(message="{required}") Long teamId, String userName) {
        Member result = this.memberService.findByUserName(teamId, userName);
        return RestResponse.success(result == null);
    }

    @Operation(summary="Create member")
    @PermissionAction(id="#member.teamId", type=PermissionType.TEAM)
    @PostMapping(value={"post"})
    @RequiresPermissions(value={"member:add"})
    public RestResponse create(@Valid Member member) {
        this.memberService.createMember(member);
        return RestResponse.success();
    }

    @Operation(summary="Delete member")
    @PermissionAction(id="#member.teamId", type=PermissionType.TEAM)
    @DeleteMapping(value={"delete"})
    @RequiresPermissions(value={"member:delete"})
    public RestResponse delete(Member member) {
        this.memberService.deleteMember(member);
        return RestResponse.success();
    }

    @Operation(summary="Update member")
    @PermissionAction(id="#member.teamId", type=PermissionType.TEAM)
    @PutMapping(value={"update"})
    @RequiresPermissions(value={"member:update"})
    public RestResponse update(Member member) {
        this.memberService.updateMember(member);
        return RestResponse.success();
    }
}

