/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.core.fs.Path;

@PublicEvolving
public abstract class FilePathFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String HADOOP_COPYING = "_COPYING_";

    public abstract boolean filterPath(Path var1);

    public static FilePathFilter createDefaultFilter() {
        return DefaultFilter.INSTANCE;
    }

    public static class DefaultFilter
    extends FilePathFilter {
        private static final long serialVersionUID = 1L;
        static final DefaultFilter INSTANCE = new DefaultFilter();

        DefaultFilter() {
        }

        @Override
        public boolean filterPath(Path filePath) {
            return filePath == null || filePath.getName().startsWith(".") || filePath.getName().startsWith("_") || filePath.getName().contains(FilePathFilter.HADOOP_COPYING);
        }
    }
}

