/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.streampark.common.conf.FlinkVersion;
import org.apache.streampark.common.util.DeflaterUtils;
import org.apache.streampark.common.util.PropertiesUtils;
import org.apache.streampark.console.base.exception.ApiDetailException;
import scala.util.Properties;

@TableName(value="t_flink_env")
public class FlinkEnv
implements Serializable {
    @TableId(type=IdType.AUTO)
    private Long id;
    private String flinkName;
    private String flinkHome;
    private String flinkConf;
    private String description;
    private String scalaVersion;
    private String version;
    private Boolean isDefault;
    private Date createTime;
    private transient FlinkVersion flinkVersion;
    private transient String streamParkScalaVersion = Properties.versionNumberString();

    public void doSetFlinkConf() throws ApiDetailException {
        try {
            File yaml = new File(this.flinkHome.concat("/conf/flink-conf.yaml"));
            String flinkConf = FileUtils.readFileToString((File)yaml);
            this.flinkConf = DeflaterUtils.zipString((String)flinkConf);
        }
        catch (Exception e) {
            throw new ApiDetailException(e);
        }
    }

    public void doSetVersion() {
        this.setVersion(this.getFlinkVersion().version());
        this.setScalaVersion(this.getFlinkVersion().scalaVersion());
        if (!this.streamParkScalaVersion.startsWith(this.getFlinkVersion().scalaVersion())) {
            throw new UnsupportedOperationException(String.format("The current Scala version of StreamPark is %s, but the scala version of Flink to be added is %s, which does not match, Please check", this.streamParkScalaVersion, this.getFlinkVersion().scalaVersion()));
        }
    }

    public Map<String, String> convertFlinkYamlAsMap() {
        String flinkYamlString = DeflaterUtils.unzipString((String)this.flinkConf);
        return PropertiesUtils.loadFlinkConfYaml((String)flinkYamlString);
    }

    @JsonIgnore
    public FlinkVersion getFlinkVersion() {
        if (this.flinkVersion == null) {
            this.flinkVersion = new FlinkVersion(this.flinkHome);
        }
        return this.flinkVersion;
    }

    public void unzipFlinkConf() {
        this.flinkConf = DeflaterUtils.unzipString((String)this.flinkConf);
    }

    @JsonIgnore
    public String getLargeVersion() {
        return this.version.substring(0, this.version.lastIndexOf("."));
    }

    @JsonIgnore
    public String getVersionOfFirst() {
        return this.version.split("\\.")[0];
    }

    @JsonIgnore
    public String getVersionOfMiddle() {
        return this.version.split("\\.")[1];
    }

    @JsonIgnore
    public String getVersionOfLast() {
        return this.version.split("\\.")[2];
    }

    public Long getId() {
        return this.id;
    }

    public String getFlinkName() {
        return this.flinkName;
    }

    public String getFlinkHome() {
        return this.flinkHome;
    }

    public String getFlinkConf() {
        return this.flinkConf;
    }

    public String getDescription() {
        return this.description;
    }

    public String getScalaVersion() {
        return this.scalaVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getStreamParkScalaVersion() {
        return this.streamParkScalaVersion;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setFlinkName(String flinkName) {
        this.flinkName = flinkName;
    }

    public void setFlinkHome(String flinkHome) {
        this.flinkHome = flinkHome;
    }

    public void setFlinkConf(String flinkConf) {
        this.flinkConf = flinkConf;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setScalaVersion(String scalaVersion) {
        this.scalaVersion = scalaVersion;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setFlinkVersion(FlinkVersion flinkVersion) {
        this.flinkVersion = flinkVersion;
    }

    public void setStreamParkScalaVersion(String streamParkScalaVersion) {
        this.streamParkScalaVersion = streamParkScalaVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlinkEnv)) {
            return false;
        }
        FlinkEnv other = (FlinkEnv)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$isDefault = this.getIsDefault();
        Boolean other$isDefault = other.getIsDefault();
        if (this$isDefault == null ? other$isDefault != null : !((Object)this$isDefault).equals(other$isDefault)) {
            return false;
        }
        String this$flinkName = this.getFlinkName();
        String other$flinkName = other.getFlinkName();
        if (this$flinkName == null ? other$flinkName != null : !this$flinkName.equals(other$flinkName)) {
            return false;
        }
        String this$flinkHome = this.getFlinkHome();
        String other$flinkHome = other.getFlinkHome();
        if (this$flinkHome == null ? other$flinkHome != null : !this$flinkHome.equals(other$flinkHome)) {
            return false;
        }
        String this$flinkConf = this.getFlinkConf();
        String other$flinkConf = other.getFlinkConf();
        if (this$flinkConf == null ? other$flinkConf != null : !this$flinkConf.equals(other$flinkConf)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$scalaVersion = this.getScalaVersion();
        String other$scalaVersion = other.getScalaVersion();
        if (this$scalaVersion == null ? other$scalaVersion != null : !this$scalaVersion.equals(other$scalaVersion)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        return !(this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlinkEnv;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $isDefault = this.getIsDefault();
        result = result * 59 + ($isDefault == null ? 43 : ((Object)$isDefault).hashCode());
        String $flinkName = this.getFlinkName();
        result = result * 59 + ($flinkName == null ? 43 : $flinkName.hashCode());
        String $flinkHome = this.getFlinkHome();
        result = result * 59 + ($flinkHome == null ? 43 : $flinkHome.hashCode());
        String $flinkConf = this.getFlinkConf();
        result = result * 59 + ($flinkConf == null ? 43 : $flinkConf.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $scalaVersion = this.getScalaVersion();
        result = result * 59 + ($scalaVersion == null ? 43 : $scalaVersion.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        return result;
    }

    public String toString() {
        return "FlinkEnv(id=" + this.getId() + ", flinkName=" + this.getFlinkName() + ", flinkHome=" + this.getFlinkHome() + ", flinkConf=" + this.getFlinkConf() + ", description=" + this.getDescription() + ", scalaVersion=" + this.getScalaVersion() + ", version=" + this.getVersion() + ", isDefault=" + this.getIsDefault() + ", createTime=" + this.getCreateTime() + ", flinkVersion=" + this.getFlinkVersion() + ", streamParkScalaVersion=" + this.getStreamParkScalaVersion() + ")";
    }
}

