/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.messages;

import org.apache.flink.runtime.rpc.messages.RpcInvocation;
import org.apache.flink.util.Preconditions;

public final class LocalRpcInvocation
implements RpcInvocation {
    private final String declaringClass;
    private final String methodName;
    private final Class<?>[] parameterTypes;
    private final Object[] args;
    private transient String toString;

    public LocalRpcInvocation(String declaringClass, String methodName, Class<?>[] parameterTypes, Object[] args) {
        this.declaringClass = declaringClass;
        this.methodName = (String)Preconditions.checkNotNull((Object)methodName);
        this.parameterTypes = (Class[])Preconditions.checkNotNull(parameterTypes);
        this.args = args;
        this.toString = null;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Object[] getArgs() {
        return this.args;
    }

    public String toString() {
        if (this.toString == null) {
            this.toString = "LocalRpcInvocation(" + RpcInvocation.convertRpcToString(this.declaringClass, this.methodName, this.parameterTypes) + ")";
        }
        return this.toString;
    }
}

