/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.lang.invoke.LambdaMetafactory;
import java.util.function.Supplier;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.api.operators.YieldingOperatorFactory;
import org.apache.flink.streaming.runtime.operators.sink.ForwardCommittingHandler;
import org.apache.flink.streaming.runtime.operators.sink.NoopCommitterHandler;
import org.apache.flink.streaming.runtime.operators.sink.SinkOperator;
import org.apache.flink.streaming.runtime.operators.sink.StatefulSinkWriterStateHandler;
import org.apache.flink.streaming.runtime.operators.sink.StatelessSinkWriterStateHandler;
import org.apache.flink.streaming.runtime.operators.sink.StreamingCommitterHandler;
import org.apache.flink.util.function.BiFunctionWithException;

@Internal
public final class SinkOperatorFactory<InputT, CommT, WriterStateT>
extends AbstractStreamOperatorFactory<byte[]>
implements OneInputStreamOperatorFactory<InputT, byte[]>,
YieldingOperatorFactory<byte[]> {
    private final Sink<InputT, CommT, WriterStateT, ?> sink;
    private final boolean batch;
    private final boolean shouldEmit;

    public SinkOperatorFactory(Sink<InputT, CommT, WriterStateT, ?> sink, boolean batch, boolean shouldEmit) {
        this.sink = sink;
        this.batch = batch;
        this.shouldEmit = shouldEmit;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public <T extends StreamOperator<byte[]>> T createStreamOperator(StreamOperatorParameters<byte[]> parameters) {
        writerStateSerializer = this.sink.getWriterStateSerializer();
        writerStateHandler = writerStateSerializer.isPresent() != false ? new StatefulSinkWriterStateHandler<WriterStateT>((SimpleVersionedSerializer)writerStateSerializer.get(), this.sink.getCompatibleStateNames()) : StatelessSinkWriterStateHandler.getInstance();
        committableSerializerOpt = this.sink.getCommittableSerializer();
        v0 = committerHandler /* !! */  = this.shouldEmit != false ? new ForwardCommittingHandler<CommT>() : NoopCommitterHandler.getInstance();
        if (!this.batch) {
            try {
                committer = this.sink.createCommitter();
                if (!committer.isPresent()) ** GOTO lbl13
                committerHandler /* !! */  = new StreamingCommitterHandler<CommT>((Committer)committer.get(), (SimpleVersionedSerializer)committableSerializerOpt.orElseThrow((Supplier<IllegalStateException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, noSerializerFound(), ()Ljava/lang/IllegalStateException;)((SinkOperatorFactory)this)));
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot create committer of " + this.sink, e);
            }
        }
lbl13:
        // 4 sources

        sinkOperator = new SinkOperator<InputT, CommT, WriterStateT>(this.processingTimeService, this.getMailboxExecutor(), (BiFunctionWithException)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, createWriter(org.apache.flink.api.connector.sink.Sink$InitContext java.util.List ), (Lorg/apache/flink/api/connector/sink/Sink$InitContext;Ljava/util/List;)Lorg/apache/flink/api/connector/sink/SinkWriter;)(this.sink), writerStateHandler, committerHandler /* !! */ , this.shouldEmit != false ? (SimpleVersionedSerializer)committableSerializerOpt.orElseThrow((Supplier<IllegalStateException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, noSerializerFound(), ()Ljava/lang/IllegalStateException;)((SinkOperatorFactory)this)) : null);
        sinkOperator.setup(parameters.getContainingTask(), parameters.getStreamConfig(), parameters.getOutput());
        return (T)sinkOperator;
    }

    private IllegalStateException noSerializerFound() {
        return new IllegalStateException(this.sink.getClass() + " does not implement getCommittableSerializer which is needed for any (global) committer.");
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return SinkOperator.class;
    }

    @VisibleForTesting
    public Sink<InputT, CommT, WriterStateT, ?> getSink() {
        return this.sink;
    }
}

