/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Map;
import javax.validation.Valid;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.domain.router.VueRouter;
import org.apache.streampark.console.core.service.CommonService;
import org.apache.streampark.console.system.entity.Menu;
import org.apache.streampark.console.system.service.MenuService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="MENU_TAG")
@Validated
@RestController
@RequestMapping(value={"/menu"})
public class MenuController {
    private static final Logger log = LoggerFactory.getLogger(MenuController.class);
    @Autowired
    private MenuService menuService;
    @Autowired
    private CommonService commonService;

    @Operation(summary="List menu-routes")
    @PostMapping(value={"router"})
    public RestResponse getUserRouters(Long teamId) {
        ArrayList<VueRouter<Menu>> routers = this.menuService.getUserRouters(this.commonService.getUserId(), teamId);
        return RestResponse.success(routers);
    }

    @Operation(summary="List menus")
    @PostMapping(value={"list"})
    @RequiresPermissions(value={"menu:view"})
    public RestResponse menuList(Menu menu) {
        Map<String, Object> maps = this.menuService.findMenus(menu);
        return RestResponse.success(maps);
    }

    @Operation(summary="Create menu")
    @PostMapping(value={"post"})
    @RequiresPermissions(value={"menu:add"})
    public RestResponse addMenu(@Valid Menu menu) {
        this.menuService.createMenu(menu);
        return RestResponse.success();
    }

    @PutMapping(value={"update"})
    @RequiresPermissions(value={"menu:update"})
    public RestResponse updateMenu(@Valid Menu menu) throws Exception {
        this.menuService.updateMenu(menu);
        return RestResponse.success();
    }
}

