/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import java.util.Date;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public final class DateComparator
extends BasicTypeComparator<Date> {
    private static final long serialVersionUID = 1L;

    public DateComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        return DateComparator.compareSerializedDate(firstSource, secondSource, this.ascendingComparison);
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public int getNormalizeKeyLen() {
        return 8;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < 8;
    }

    @Override
    public void putNormalizedKey(Date record, MemorySegment target, int offset, int numBytes) {
        DateComparator.putNormalizedKeyDate(record, target, offset, numBytes);
    }

    public DateComparator duplicate() {
        return new DateComparator(this.ascendingComparison);
    }

    public static int compareSerializedDate(DataInputView firstSource, DataInputView secondSource, boolean ascendingComparison) throws IOException {
        long l2;
        long l1 = firstSource.readLong();
        int comp = l1 < (l2 = secondSource.readLong()) ? -1 : (l1 == l2 ? 0 : 1);
        return ascendingComparison ? comp : -comp;
    }

    public static void putNormalizedKeyDate(Date record, MemorySegment target, int offset, int numBytes) {
        long value = record.getTime() - Long.MIN_VALUE;
        if (numBytes == 8) {
            target.putLongBigEndian(offset, value);
        } else if (numBytes < 8) {
            int i = 0;
            while (numBytes > 0) {
                target.put(offset + i, (byte)(value >>> (7 - i << 3)));
                --numBytes;
                ++i;
            }
        } else {
            target.putLongBigEndian(offset, value);
            for (int i = 8; i < numBytes; ++i) {
                target.put(offset + i, (byte)0);
            }
        }
    }
}

