/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc.messages;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.flink.runtime.rpc.messages.RpcInvocation;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;

public class RemoteRpcInvocation
implements RpcInvocation,
Serializable {
    private static final long serialVersionUID = 6179354390913843809L;
    private SerializedValue<MethodInvocation> serializedMethodInvocation;
    private transient MethodInvocation methodInvocation;
    private transient String toString;

    public RemoteRpcInvocation(String declaringClassName, String methodName, Class<?>[] parameterTypes, Object[] args) throws IOException {
        this.serializedMethodInvocation = new SerializedValue((Object)new MethodInvocation(declaringClassName, methodName, parameterTypes, args));
        this.methodInvocation = null;
    }

    @Override
    public String getMethodName() throws IOException, ClassNotFoundException {
        this.deserializeMethodInvocation();
        return this.methodInvocation.getMethodName();
    }

    private String getDeclaringClassName() throws IOException, ClassNotFoundException {
        this.deserializeMethodInvocation();
        return this.methodInvocation.getDeclaringClassName();
    }

    @Override
    public Class<?>[] getParameterTypes() throws IOException, ClassNotFoundException {
        this.deserializeMethodInvocation();
        return this.methodInvocation.getParameterTypes();
    }

    @Override
    public Object[] getArgs() throws IOException, ClassNotFoundException {
        this.deserializeMethodInvocation();
        return this.methodInvocation.getArgs();
    }

    public String toString() {
        if (this.toString == null) {
            try {
                Class<?>[] parameterTypes = this.getParameterTypes();
                String methodName = this.getMethodName();
                String declaringClassName = this.getDeclaringClassName();
                this.toString = "RemoteRpcInvocation(" + RpcInvocation.convertRpcToString(declaringClassName, methodName, parameterTypes) + ")";
            }
            catch (IOException | ClassNotFoundException e) {
                this.toString = "Could not deserialize RemoteRpcInvocation: " + e.getMessage();
            }
        }
        return this.toString;
    }

    public long getSize() {
        return this.serializedMethodInvocation.getByteArray().length;
    }

    private void deserializeMethodInvocation() throws IOException, ClassNotFoundException {
        if (this.methodInvocation == null) {
            this.methodInvocation = (MethodInvocation)this.serializedMethodInvocation.deserializeValue(ClassLoader.getSystemClassLoader());
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.serializedMethodInvocation);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.serializedMethodInvocation = (SerializedValue)ois.readObject();
        this.methodInvocation = null;
    }

    private static final class MethodInvocation
    implements Serializable {
        private static final long serialVersionUID = 9187962608946082519L;
        private String declaringClassName;
        private String methodName;
        private Class<?>[] parameterTypes;
        private Object[] args;

        private MethodInvocation(String declaringClassName, String methodName, Class<?>[] parameterTypes, Object[] args) {
            this.methodName = methodName;
            this.parameterTypes = (Class[])Preconditions.checkNotNull(parameterTypes);
            this.args = args;
        }

        String getDeclaringClassName() {
            return this.declaringClassName;
        }

        String getMethodName() {
            return this.methodName;
        }

        Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        Object[] getArgs() {
            return this.args;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeUTF(this.methodName);
            oos.writeInt(this.parameterTypes.length);
            for (Class<?> parameterType : this.parameterTypes) {
                oos.writeObject(parameterType);
            }
            if (this.args != null) {
                oos.writeBoolean(true);
                for (int i = 0; i < this.args.length; ++i) {
                    try {
                        oos.writeObject(this.args[i]);
                        continue;
                    }
                    catch (IOException e) {
                        throw new IOException("Could not serialize " + i + "th argument of method " + this.methodName + ". This indicates that the argument type " + this.args.getClass().getName() + " is not serializable. Arguments have to be serializable for remote rpc calls.", e);
                    }
                }
            } else {
                oos.writeBoolean(false);
            }
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            this.methodName = ois.readUTF();
            int length = ois.readInt();
            this.parameterTypes = new Class[length];
            for (int i = 0; i < length; ++i) {
                try {
                    this.parameterTypes[i] = (Class)ois.readObject();
                    continue;
                }
                catch (IOException e) {
                    StringBuilder incompleteMethod = this.getIncompleteMethodString(i, 0);
                    throw new IOException("Could not deserialize " + i + "th parameter type of method " + incompleteMethod + '.', e);
                }
                catch (ClassNotFoundException e) {
                    StringBuilder incompleteMethod = this.getIncompleteMethodString(i, 0);
                    e.addSuppressed(new ClassNotFoundException("Could not deserialize " + i + "th parameter type of method " + incompleteMethod + ". This indicates that the parameter type is not part of the system class loader."));
                    throw e;
                }
            }
            boolean hasArgs = ois.readBoolean();
            if (hasArgs) {
                this.args = new Object[length];
                for (int i = 0; i < length; ++i) {
                    try {
                        this.args[i] = ois.readObject();
                        continue;
                    }
                    catch (IOException e) {
                        StringBuilder incompleteMethod = this.getIncompleteMethodString(length, i);
                        throw new IOException("Could not deserialize " + i + "th argument of method " + incompleteMethod + '.', e);
                    }
                    catch (ClassNotFoundException e) {
                        StringBuilder incompleteMethod = this.getIncompleteMethodString(length, i);
                        e.addSuppressed(new ClassNotFoundException("Could not deserialize " + i + "th argument of method " + incompleteMethod + ". This indicates that the argument type is not part of the system class loader."));
                        throw e;
                    }
                }
            } else {
                this.args = null;
            }
        }

        private StringBuilder getIncompleteMethodString(int lastMethodTypeIdx, int lastArgumentIdx) {
            StringBuilder incompleteMethod = new StringBuilder();
            incompleteMethod.append(this.methodName).append('(');
            for (int i = 0; i < lastMethodTypeIdx; ++i) {
                incompleteMethod.append(this.parameterTypes[i].getCanonicalName());
                if (i < lastArgumentIdx) {
                    incompleteMethod.append(": ").append(this.args[i]);
                }
                incompleteMethod.append(", ");
            }
            incompleteMethod.append("...)");
            return incompleteMethod;
        }
    }
}

