/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.dependencies.resolve.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.shared.artifact.filter.resolve.FilterTransformer;
import org.apache.maven.shared.artifact.filter.resolve.TransformableFilter;
import org.apache.maven.shared.artifact.filter.resolve.transform.EclipseAetherFilterTransformer;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.resolve.DependencyResolverException;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.Invoker;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.Maven31ArtifactResult;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.Maven31DependencyResolverException;
import org.apache.maven.shared.transfer.dependencies.resolve.internal.MavenDependencyResolver;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;

class Maven31DependencyResolver
implements MavenDependencyResolver {
    private RepositorySystem repositorySystem;
    private ArtifactHandlerManager artifactHandlerManager;
    private final RepositorySystemSession session;
    private final List<RemoteRepository> aetherRepositories;

    Maven31DependencyResolver(RepositorySystem repositorySystem, ArtifactHandlerManager artifactHandlerManager, RepositorySystemSession session, List<RemoteRepository> aetherRepositories) {
        this.repositorySystem = repositorySystem;
        this.artifactHandlerManager = artifactHandlerManager;
        this.session = session;
        this.aetherRepositories = aetherRepositories;
    }

    @Override
    public Iterable<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult> resolveDependencies(DependableCoordinate coordinate, TransformableFilter dependencyFilter) throws DependencyResolverException {
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        Dependency aetherRoot = Maven31DependencyResolver.toDependency(coordinate, typeRegistry);
        CollectRequest request = new CollectRequest(aetherRoot, this.aetherRepositories);
        return this.resolveDependencies(this.aetherRepositories, dependencyFilter, request);
    }

    @Override
    public Iterable<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult> resolveDependencies(Model model, TransformableFilter dependencyFilter) throws DependencyResolverException {
        ArtifactHandler artifactHandler = this.artifactHandlerManager.getArtifactHandler(model.getPackaging());
        String extension = artifactHandler != null ? artifactHandler.getExtension() : null;
        DefaultArtifact aetherArtifact = new DefaultArtifact(model.getGroupId(), model.getArtifactId(), extension, model.getVersion());
        Dependency aetherRoot = new Dependency((Artifact)aetherArtifact, null);
        CollectRequest request = new CollectRequest(aetherRoot, this.aetherRepositories);
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        ArrayList<Dependency> aetherDependencies = new ArrayList<Dependency>(model.getDependencies().size());
        for (org.apache.maven.model.Dependency mavenDependency : model.getDependencies()) {
            aetherDependencies.add(Maven31DependencyResolver.toDependency(mavenDependency, typeRegistry));
        }
        request.setDependencies(aetherDependencies);
        DependencyManagement mavenDependencyManagement = model.getDependencyManagement();
        if (mavenDependencyManagement != null) {
            ArrayList<Dependency> aetherManagerDependencies = new ArrayList<Dependency>(mavenDependencyManagement.getDependencies().size());
            for (org.apache.maven.model.Dependency mavenDependency : mavenDependencyManagement.getDependencies()) {
                aetherManagerDependencies.add(Maven31DependencyResolver.toDependency(mavenDependency, typeRegistry));
            }
            request.setManagedDependencies(aetherManagerDependencies);
        }
        return this.resolveDependencies(this.aetherRepositories, dependencyFilter, request);
    }

    @Override
    public Iterable<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult> resolveDependencies(Collection<org.apache.maven.model.Dependency> mavenDependencies, Collection<org.apache.maven.model.Dependency> managedMavenDependencies, TransformableFilter filter) throws DependencyResolverException {
        ArtifactTypeRegistry typeRegistry = (ArtifactTypeRegistry)Invoker.invoke(RepositoryUtils.class, "newArtifactTypeRegistry", ArtifactHandlerManager.class, (Object)this.artifactHandlerManager);
        Class[] argClasses = new Class[]{org.apache.maven.model.Dependency.class, ArtifactTypeRegistry.class};
        ArrayList<Dependency> aetherDeps = null;
        if (mavenDependencies != null) {
            aetherDeps = new ArrayList<Dependency>(mavenDependencies.size());
            for (org.apache.maven.model.Dependency mavenDependency : mavenDependencies) {
                Object[] args = new Object[]{mavenDependency, typeRegistry};
                Dependency aetherDependency = (Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", argClasses, args);
                aetherDeps.add(aetherDependency);
            }
        }
        ArrayList<Dependency> aetherManagedDependencies = null;
        if (managedMavenDependencies != null) {
            aetherManagedDependencies = new ArrayList<Dependency>(managedMavenDependencies.size());
            for (org.apache.maven.model.Dependency mavenDependency : managedMavenDependencies) {
                Object[] args = new Object[]{mavenDependency, typeRegistry};
                Dependency aetherDependency = (Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", argClasses, args);
                aetherManagedDependencies.add(aetherDependency);
            }
        }
        CollectRequest request = new CollectRequest(aetherDeps, aetherManagedDependencies, this.aetherRepositories);
        return this.resolveDependencies(this.aetherRepositories, filter, request);
    }

    private Iterable<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult> resolveDependencies(List<RemoteRepository> aetherRepositories, TransformableFilter dependencyFilter, CollectRequest request) throws DependencyResolverException {
        try {
            DependencyFilter depFilter = null;
            if (dependencyFilter != null) {
                depFilter = (DependencyFilter)dependencyFilter.transform((FilterTransformer)new EclipseAetherFilterTransformer());
            }
            DependencyRequest depRequest = new DependencyRequest(request, depFilter);
            final DependencyResult dependencyResults = this.repositorySystem.resolveDependencies(this.session, depRequest);
            return new Iterable<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult>(){

                @Override
                public Iterator<org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult> iterator() {
                    ArrayList<Maven31ArtifactResult> artResults = new ArrayList<Maven31ArtifactResult>(dependencyResults.getArtifactResults().size());
                    for (ArtifactResult artifactResult : dependencyResults.getArtifactResults()) {
                        artResults.add(new Maven31ArtifactResult(artifactResult));
                    }
                    return artResults.iterator();
                }
            };
        }
        catch (DependencyResolutionException e) {
            throw new Maven31DependencyResolverException(e);
        }
    }

    private static Dependency toDependency(DependableCoordinate coordinate, ArtifactTypeRegistry stereotypes) {
        ArtifactType stereotype = stereotypes.get(coordinate.getType());
        if (stereotype == null) {
            stereotype = new DefaultArtifactType(coordinate.getType());
        }
        DefaultArtifact artifact = new DefaultArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getClassifier(), null, coordinate.getVersion(), null, stereotype);
        return new Dependency((Artifact)artifact, null);
    }

    private static Dependency toDependency(org.apache.maven.model.Dependency root, ArtifactTypeRegistry typeRegistry) throws DependencyResolverException {
        Class[] argClasses = new Class[]{org.apache.maven.model.Dependency.class, ArtifactTypeRegistry.class};
        Object[] args = new Object[]{root, typeRegistry};
        return (Dependency)Invoker.invoke(RepositoryUtils.class, "toDependency", argClasses, args);
    }
}

