/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.GenericKeyMetricGroup;
import org.apache.flink.runtime.metrics.groups.GenericMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class AbstractMetricGroup<A extends AbstractMetricGroup<?>>
implements MetricGroup {
    protected static final Logger LOG = LoggerFactory.getLogger(MetricGroup.class);
    protected final A parent;
    protected volatile Map<String, String>[] variables;
    protected final MetricRegistry registry;
    private final Map<String, Metric> metrics = new HashMap<String, Metric>();
    private final Map<String, AbstractMetricGroup> groups = new HashMap<String, AbstractMetricGroup>();
    private final String[] scopeComponents;
    private final String[] scopeStrings;
    private String[] logicalScopeStrings;
    protected QueryScopeInfo queryServiceScopeInfo;
    private volatile boolean closed;

    public AbstractMetricGroup(MetricRegistry registry, String[] scope, A parent) {
        this.registry = (MetricRegistry)Preconditions.checkNotNull((Object)registry);
        this.scopeComponents = (String[])Preconditions.checkNotNull((Object)scope);
        this.parent = parent;
        this.scopeStrings = new String[registry.getNumberReporters()];
        this.logicalScopeStrings = new String[registry.getNumberReporters()];
        this.variables = new Map[registry.getNumberReporters() + 1];
    }

    public Map<String, String> getAllVariables() {
        return this.internalGetAllVariables(0, Collections.emptySet());
    }

    public Map<String, String> getAllVariables(int reporterIndex, Set<String> excludedVariables) {
        if (reporterIndex < 0 || reporterIndex >= this.logicalScopeStrings.length) {
            reporterIndex = -1;
        }
        return this.internalGetAllVariables(excludedVariables.isEmpty() ? 0 : ++reporterIndex, excludedVariables);
    }

    private Map<String, String> internalGetAllVariables(int cachingIndex, Set<String> excludedVariables) {
        if (this.variables[cachingIndex] == null) {
            HashMap<String, String> tmpVariables = new HashMap<String, String>();
            this.putVariables(tmpVariables);
            excludedVariables.forEach(tmpVariables::remove);
            if (this.parent != null) {
                for (Map.Entry<String, String> entry : ((AbstractMetricGroup)this.parent).getAllVariables().entrySet()) {
                    if (excludedVariables.contains(entry.getKey())) continue;
                    tmpVariables.put(entry.getKey(), entry.getValue());
                }
            }
            this.variables[cachingIndex] = tmpVariables;
        }
        return this.variables[cachingIndex];
    }

    protected void putVariables(Map<String, String> variables) {
    }

    public String getLogicalScope(CharacterFilter filter) {
        return this.getLogicalScope(filter, this.registry.getDelimiter());
    }

    public String getLogicalScope(CharacterFilter filter, char delimiter) {
        return this.getLogicalScope(filter, delimiter, -1);
    }

    String getLogicalScope(CharacterFilter filter, char delimiter, int reporterIndex) {
        if (this.logicalScopeStrings.length == 0 || reporterIndex < 0 || reporterIndex >= this.logicalScopeStrings.length) {
            return this.createLogicalScope(filter, delimiter);
        }
        if (this.logicalScopeStrings[reporterIndex] == null) {
            this.logicalScopeStrings[reporterIndex] = this.createLogicalScope(filter, delimiter);
        }
        return this.logicalScopeStrings[reporterIndex];
    }

    protected String createLogicalScope(CharacterFilter filter, char delimiter) {
        String groupName = this.getGroupName(filter);
        return this.parent == null ? groupName : ((AbstractMetricGroup)this.parent).getLogicalScope(filter, delimiter) + delimiter + groupName;
    }

    protected abstract String getGroupName(CharacterFilter var1);

    public String[] getScopeComponents() {
        return this.scopeComponents;
    }

    public QueryScopeInfo getQueryServiceMetricInfo(CharacterFilter filter) {
        if (this.queryServiceScopeInfo == null) {
            this.queryServiceScopeInfo = this.createQueryServiceMetricInfo(filter);
        }
        return this.queryServiceScopeInfo;
    }

    protected abstract QueryScopeInfo createQueryServiceMetricInfo(CharacterFilter var1);

    public String getMetricIdentifier(String metricName) {
        return this.getMetricIdentifier(metricName, CharacterFilter.NO_OP_FILTER);
    }

    public String getMetricIdentifier(String metricName, CharacterFilter filter) {
        return this.getMetricIdentifier(metricName, filter, -1, this.registry.getDelimiter());
    }

    public String getMetricIdentifier(String metricName, CharacterFilter filter, int reporterIndex, char delimiter) {
        Preconditions.checkNotNull((Object)filter);
        metricName = filter.filterCharacters(metricName);
        if (this.scopeStrings.length == 0 || reporterIndex < 0 || reporterIndex >= this.scopeStrings.length) {
            return ScopeFormat.concat(filter, Character.valueOf(delimiter), this.scopeComponents) + delimiter + metricName;
        }
        if (this.scopeStrings[reporterIndex] == null) {
            this.scopeStrings[reporterIndex] = ScopeFormat.concat(filter, Character.valueOf(delimiter), this.scopeComponents);
        }
        return this.scopeStrings[reporterIndex] + delimiter + metricName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        AbstractMetricGroup abstractMetricGroup = this;
        synchronized (abstractMetricGroup) {
            if (!this.closed) {
                this.closed = true;
                for (AbstractMetricGroup abstractMetricGroup2 : this.groups.values()) {
                    abstractMetricGroup2.close();
                }
                this.groups.clear();
                for (Map.Entry entry : this.metrics.entrySet()) {
                    this.registry.unregister((Metric)entry.getValue(), (String)entry.getKey(), this);
                }
                this.metrics.clear();
            }
        }
    }

    public final boolean isClosed() {
        return this.closed;
    }

    public Counter counter(String name) {
        return this.counter(name, new SimpleCounter());
    }

    public <C extends Counter> C counter(String name, C counter) {
        this.addMetric(name, (Metric)counter);
        return counter;
    }

    public <T, G extends Gauge<T>> G gauge(String name, G gauge) {
        this.addMetric(name, (Metric)gauge);
        return gauge;
    }

    public <H extends Histogram> H histogram(String name, H histogram) {
        this.addMetric(name, (Metric)histogram);
        return histogram;
    }

    public <M extends Meter> M meter(String name, M meter) {
        this.addMetric(name, (Metric)meter);
        return meter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addMetric(String name, Metric metric) {
        if (metric == null) {
            LOG.warn("Ignoring attempted registration of a metric due to being null for name {}.", (Object)name);
            return;
        }
        AbstractMetricGroup abstractMetricGroup = this;
        synchronized (abstractMetricGroup) {
            if (!this.closed) {
                Metric prior = this.metrics.put(name, metric);
                if (prior == null) {
                    if (this.groups.containsKey(name)) {
                        LOG.warn("Name collision: Adding a metric with the same name as a metric subgroup: '" + name + "'. Metric might not get properly reported. " + Arrays.toString(this.scopeComponents));
                    }
                    this.registry.register(metric, name, this);
                } else {
                    this.metrics.put(name, prior);
                    LOG.warn("Name collision: Group already contains a Metric with the name '" + name + "'. Metric will not be reported." + Arrays.toString(this.scopeComponents));
                }
            }
        }
    }

    public MetricGroup addGroup(String name) {
        return this.addGroup(name, ChildType.GENERIC);
    }

    public MetricGroup addGroup(String key, String value) {
        return super.addGroup(value, ChildType.VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbstractMetricGroup<?> addGroup(String name, ChildType childType) {
        AbstractMetricGroup abstractMetricGroup = this;
        synchronized (abstractMetricGroup) {
            if (!this.closed) {
                GenericMetricGroup newGroup;
                AbstractMetricGroup prior;
                if (this.metrics.containsKey(name)) {
                    LOG.warn("Name collision: Adding a metric subgroup with the same name as an existing metric: '" + name + "'. Metric might not get properly reported. " + Arrays.toString(this.scopeComponents));
                }
                if ((prior = this.groups.put(name, newGroup = this.createChildGroup(name, childType))) == null) {
                    return newGroup;
                }
                this.groups.put(name, prior);
                return prior;
            }
            GenericMetricGroup closedGroup = new GenericMetricGroup(this.registry, this, name);
            closedGroup.close();
            return closedGroup;
        }
    }

    protected GenericMetricGroup createChildGroup(String name, ChildType childType) {
        switch (childType) {
            case KEY: {
                return new GenericKeyMetricGroup(this.registry, this, name);
            }
        }
        return new GenericMetricGroup(this.registry, this, name);
    }

    protected static enum ChildType {
        KEY,
        VALUE,
        GENERIC;

    }
}

