/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.security.impl;

import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.stereotype.Component;

@Component
@Configuration
public class LdapService {
    private static final Logger log = LoggerFactory.getLogger(LdapService.class);
    @Value(value="${ldap.enable:#{false}}")
    private Boolean enable;
    @Value(value="${ldap.urls:#{null}}")
    private String ldapUrls;
    @Value(value="${ldap.base-dn:#{null}}")
    private String ldapBaseDn;
    @Value(value="${ldap.username:#{null}}")
    private String ldapSecurityPrincipal;
    @Value(value="${ldap.password:#{null}}")
    private String ldapPrincipalPassword;
    @Value(value="${ldap.user.identity-attribute:#{null}}")
    private String ldapUserIdentifyingAttribute;
    @Value(value="${ldap.user.email-attribute:#{null}}")
    private String ldapEmailAttribute;
    private Properties ldapEnv = null;

    public String ldapLogin(String userId, String userPwd) {
        block7: {
            if (!this.enable.booleanValue()) {
                throw new ApiAlertException("ldap is not enabled, Please check the configuration: ldap.enable");
            }
            if (this.ldapEnv == null) {
                this.ldapEnv = new Properties();
                this.ldapEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                this.ldapEnv.put("java.naming.security.authentication", "simple");
                this.ldapEnv.put("java.naming.security.principal", this.ldapSecurityPrincipal);
                this.ldapEnv.put("java.naming.security.credentials", this.ldapPrincipalPassword);
                this.ldapEnv.put("java.naming.provider.url", this.ldapUrls);
            }
            try {
                InitialLdapContext ctx = new InitialLdapContext(this.ldapEnv, null);
                SearchControls sc = new SearchControls();
                sc.setReturningAttributes(new String[]{this.ldapEmailAttribute});
                sc.setSearchScope(2);
                EqualsFilter filter = new EqualsFilter(this.ldapUserIdentifyingAttribute, userId);
                NamingEnumeration<SearchResult> results = ctx.search(this.ldapBaseDn, filter.toString(), sc);
                if (!results.hasMore()) break block7;
                SearchResult result = results.next();
                NamingEnumeration<? extends Attribute> attrs = result.getAttributes().getAll();
                while (attrs.hasMore()) {
                    this.ldapEnv.put("java.naming.security.principal", result.getNameInNamespace());
                    this.ldapEnv.put("java.naming.security.credentials", userPwd);
                    try {
                        new InitialDirContext(this.ldapEnv);
                    }
                    catch (Exception e) {
                        log.warn("invalid ldap credentials or ldap search error", (Throwable)e);
                        return null;
                    }
                    Attribute attr = attrs.next();
                    if (!attr.getID().equals(this.ldapEmailAttribute)) continue;
                    return (String)attr.get();
                }
            }
            catch (NamingException e) {
                log.error("ldap search error", (Throwable)e);
                return null;
            }
        }
        return null;
    }
}

