/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.transport;

import com.github.dockerjava.transport.ImmutableRequest;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.immutables.value.Value;

public interface DockerHttpClient
extends Closeable {
    public Response execute(Request var1);

    @Value.Immutable
    @Value.Style(visibility=Value.Style.ImplementationVisibility.PACKAGE, overshadowImplementation=true, depluralize=true)
    public static abstract class Request {
        public static Builder builder() {
            return new Builder();
        }

        public abstract String method();

        public abstract String path();

        @Nullable
        @Value.Default
        public InputStream body() {
            byte[] bodyBytes = this.bodyBytes();
            return bodyBytes != null ? new ByteArrayInputStream(bodyBytes) : null;
        }

        @Nullable
        public abstract byte[] bodyBytes();

        @Nullable
        public abstract InputStream hijackedInput();

        public abstract Map<String, String> headers();

        public static class Builder
        extends ImmutableRequest.Builder {
            public Builder method(Method method) {
                return this.method(method.name());
            }
        }

        public static enum Method {
            GET,
            POST,
            PUT,
            DELETE,
            OPTIONS,
            PATCH;

        }
    }

    public static interface Response
    extends Closeable {
        public int getStatusCode();

        public Map<String, List<String>> getHeaders();

        public InputStream getBody();

        @Override
        public void close();

        @Nullable
        default public String getHeader(@Nonnull String name) {
            for (Map.Entry<String, List<String>> entry : this.getHeaders().entrySet()) {
                if (!name.equalsIgnoreCase(entry.getKey())) continue;
                List<String> values = entry.getValue();
                return values.isEmpty() ? null : values.get(0);
            }
            return null;
        }
    }
}

