/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Scanner;
import org.apache.streampark.common.util.DeflaterUtils;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.ApplicationConfig;
import org.apache.streampark.console.core.enums.ConfigFileType;
import org.apache.streampark.console.core.enums.EffectiveType;
import org.apache.streampark.console.core.mapper.ApplicationConfigMapper;
import org.apache.streampark.console.core.service.ApplicationConfigService;
import org.apache.streampark.console.core.service.EffectiveService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class ApplicationConfigServiceImpl
extends ServiceImpl<ApplicationConfigMapper, ApplicationConfig>
implements ApplicationConfigService {
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfigServiceImpl.class);
    private String flinkConfTemplate = null;
    @Autowired
    private ResourceLoader resourceLoader;
    @Autowired
    private EffectiveService effectiveService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public synchronized void create(Application application, Boolean latest) {
        String decode = new String(Base64.getDecoder().decode(application.getConfig()));
        String config = DeflaterUtils.zipString((String)decode.trim());
        ApplicationConfig applicationConfig = new ApplicationConfig();
        applicationConfig.setAppId(application.getId());
        if (application.getFormat() != null) {
            ConfigFileType fileType = ConfigFileType.of(application.getFormat());
            if (fileType == null || ConfigFileType.UNKNOWN.equals(fileType)) {
                throw new ApiAlertException("application' config error. must be (.properties|.yaml|.yml |.conf)");
            }
            applicationConfig.setFormat(fileType.getValue());
        }
        applicationConfig.setContent(config);
        applicationConfig.setCreateTime(new Date());
        Integer version = ((ApplicationConfigMapper)this.baseMapper).getLastVersion(application.getId());
        applicationConfig.setVersion(version == null ? 1 : version + 1);
        this.save(applicationConfig);
        this.setLatestOrEffective(latest, applicationConfig.getId(), application.getId());
    }

    @Transactional(rollbackFor={Exception.class})
    public void setLatest(Long appId, Long configId) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)updateWrapper.set(ApplicationConfig::getLatest, (Object)false)).eq(ApplicationConfig::getAppId, (Object)appId);
        this.update((Wrapper)updateWrapper);
        updateWrapper.clear();
        ((LambdaUpdateWrapper)updateWrapper.set(ApplicationConfig::getLatest, (Object)true)).eq(ApplicationConfig::getId, (Object)configId);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public synchronized void update(Application application, Boolean latest) {
        ApplicationConfig latestConfig = this.getLatest(application.getId());
        if (application.isFlinkSqlJob()) {
            ApplicationConfig effectiveConfig = this.getEffective(application.getId());
            if (Utils.isEmpty((Object)application.getConfig())) {
                if (effectiveConfig != null) {
                    this.effectiveService.delete(application.getId(), EffectiveType.CONFIG);
                }
            } else if (effectiveConfig == null) {
                if (latestConfig != null) {
                    this.removeById(latestConfig.getId());
                }
                this.create(application, latest);
            } else {
                String decode = new String(Base64.getDecoder().decode(application.getConfig()));
                String encode = DeflaterUtils.zipString((String)decode.trim());
                if (!effectiveConfig.getContent().equals(encode)) {
                    if (latestConfig != null) {
                        this.removeById(latestConfig.getId());
                    }
                    this.create(application, latest);
                }
            }
        } else {
            Long configId = application.getConfigId();
            if (configId != null) {
                ApplicationConfig config = (ApplicationConfig)this.getById(configId);
                String decode = new String(Base64.getDecoder().decode(application.getConfig()));
                String encode = DeflaterUtils.zipString((String)decode.trim());
                if (!config.getContent().equals(encode)) {
                    if (latestConfig != null) {
                        this.removeById(latestConfig.getId());
                    }
                    this.create(application, latest);
                } else {
                    this.setLatestOrEffective(latest, configId, application.getId());
                }
            } else {
                ApplicationConfig config = this.getEffective(application.getId());
                if (config != null) {
                    String decode = new String(Base64.getDecoder().decode(application.getConfig()));
                    String encode = DeflaterUtils.zipString((String)decode.trim());
                    if (!config.getContent().equals(encode)) {
                        this.create(application, latest);
                    }
                } else {
                    this.create(application, latest);
                }
            }
        }
    }

    @Override
    public void setLatestOrEffective(Boolean latest, Long configId, Long appId) {
        if (latest.booleanValue()) {
            this.setLatest(appId, configId);
        } else {
            this.toEffective(appId, configId);
        }
    }

    @Override
    public void toEffective(Long appId, Long configId) {
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)updateWrapper.eq(ApplicationConfig::getAppId, (Object)appId)).set(ApplicationConfig::getLatest, (Object)false);
        this.update((Wrapper)updateWrapper);
        this.effectiveService.saveOrUpdate(appId, EffectiveType.CONFIG, configId);
    }

    @Override
    public ApplicationConfig getLatest(Long appId) {
        return ((ApplicationConfigMapper)this.baseMapper).getLatest(appId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApplicationConfig getEffective(Long appId) {
        return ((ApplicationConfigMapper)this.baseMapper).getEffective(appId);
    }

    @Override
    public ApplicationConfig get(Long id) {
        ApplicationConfig config = (ApplicationConfig)this.getById(id);
        if (config.getContent() != null) {
            String unzipString = DeflaterUtils.unzipString((String)config.getContent());
            String encode = Base64.getEncoder().encodeToString(unzipString.getBytes());
            config.setContent(encode);
        }
        return config;
    }

    @Override
    public IPage<ApplicationConfig> page(ApplicationConfig config, RestRequest request) {
        Page page = new MybatisPager().getPage(request, "version", "desc");
        IPage<ApplicationConfig> configList = ((ApplicationConfigMapper)this.baseMapper).pageByAppId(page, config.getAppId());
        this.fillEffectiveField(config.getAppId(), configList.getRecords());
        return configList;
    }

    @Override
    public List<ApplicationConfig> history(Application application) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApplicationConfig::getAppId, (Object)application.getId())).orderByDesc(ApplicationConfig::getVersion);
        List configList = ((ApplicationConfigMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        this.fillEffectiveField(application.getId(), configList);
        return configList;
    }

    @Override
    public synchronized String readTemplate() {
        if (this.flinkConfTemplate == null) {
            try {
                Resource resource = this.resourceLoader.getResource("classpath:flink-application.conf");
                Scanner scanner = new Scanner(resource.getInputStream());
                StringBuilder stringBuffer = new StringBuilder();
                while (scanner.hasNextLine()) {
                    stringBuffer.append(scanner.nextLine()).append(System.lineSeparator());
                }
                scanner.close();
                String template = stringBuffer.toString();
                this.flinkConfTemplate = Base64.getEncoder().encodeToString(template.getBytes());
            }
            catch (Exception e) {
                log.error("Read conf/flink-application.conf failed, please check your deployment");
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return this.flinkConfTemplate;
    }

    @Override
    public void removeApp(Long appId) {
        ((ApplicationConfigMapper)this.baseMapper).delete((Wrapper)new LambdaQueryWrapper().eq(ApplicationConfig::getAppId, (Object)appId));
    }

    private void fillEffectiveField(Long id, List<ApplicationConfig> configList) {
        ApplicationConfig effective = this.getEffective(id);
        if (effective != null) {
            for (ApplicationConfig config : configList) {
                if (!config.getId().equals(effective.getId())) continue;
                config.setEffective(true);
                break;
            }
        }
    }
}

