/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.HashSet;
import java.util.Set;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;

public class RangerResourceAccessInfo {
    private final RangerAccessRequest request;
    private final Set<String> allowedUsers;
    private final Set<String> allowedGroups;
    private final Set<String> deniedUsers;
    private final Set<String> deniedGroups;

    public RangerResourceAccessInfo(RangerAccessRequest request) {
        this.request = request;
        this.allowedUsers = new HashSet<String>();
        this.allowedGroups = new HashSet<String>();
        this.deniedUsers = new HashSet<String>();
        this.deniedGroups = new HashSet<String>();
    }

    public RangerResourceAccessInfo(RangerResourceAccessInfo other) {
        this.request = other.request;
        this.allowedUsers = other.allowedUsers == null ? new HashSet<String>() : new HashSet<String>(other.allowedUsers);
        this.allowedGroups = other.allowedGroups == null ? new HashSet<String>() : new HashSet<String>(other.allowedGroups);
        this.deniedUsers = other.deniedUsers == null ? new HashSet<String>() : new HashSet<String>(other.deniedUsers);
        this.deniedGroups = other.deniedGroups == null ? new HashSet<String>() : new HashSet<String>(other.deniedGroups);
    }

    public RangerAccessRequest getRequest() {
        return this.request;
    }

    public Set<String> getAllowedUsers() {
        return this.allowedUsers;
    }

    public Set<String> getAllowedGroups() {
        return this.allowedGroups;
    }

    public Set<String> getDeniedUsers() {
        return this.deniedUsers;
    }

    public Set<String> getDeniedGroups() {
        return this.deniedGroups;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerResourceAccessInfo={");
        sb.append("request={");
        if (this.request != null) {
            sb.append(this.request);
        }
        sb.append("} ");
        sb.append("allowedUsers={");
        for (String user : this.allowedUsers) {
            sb.append(user).append(" ");
        }
        sb.append("} ");
        sb.append("allowedGroups={");
        for (String group : this.allowedGroups) {
            sb.append(group).append(" ");
        }
        sb.append("} ");
        sb.append("deniedUsers={");
        for (String user : this.deniedUsers) {
            sb.append(user).append(" ");
        }
        sb.append("} ");
        sb.append("deniedGroups={");
        for (String group : this.deniedGroups) {
            sb.append(group).append(" ");
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }
}

