/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.queue;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.ranger.audit.model.AuditEventBase;
import org.apache.ranger.audit.model.AuditIndexRecord;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.audit.model.SPOOL_FILE_STATUS;
import org.apache.ranger.audit.provider.AuditHandler;
import org.apache.ranger.audit.provider.MiscUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AuditFileQueueSpool
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(AuditFileQueueSpool.class);
    public static final String PROP_FILE_SPOOL_LOCAL_DIR = "filespool.dir";
    public static final String PROP_FILE_SPOOL_LOCAL_FILE_NAME = "filespool.filename.format";
    public static final String PROP_FILE_SPOOL_ARCHIVE_DIR = "filespool.archive.dir";
    public static final String PROP_FILE_SPOOL_ARCHIVE_MAX_FILES_COUNT = "filespool.archive.max.files";
    public static final String PROP_FILE_SPOOL_FILENAME_PREFIX = "filespool.file.prefix";
    public static final String PROP_FILE_SPOOL_FILE_ROLLOVER = "filespool.file.rollover.sec";
    public static final String PROP_FILE_SPOOL_INDEX_FILE = "filespool.index.filename";
    public static final String PROP_FILE_SPOOL_DEST_RETRY_MS = "filespool.destination.retry.ms";
    public static final String PROP_FILE_SPOOL_BATCH_SIZE = "filespool.buffer.size";
    public static final String FILE_QUEUE_PROVIDER_NAME = "AuditFileQueueSpool";
    public static final String DEFAULT_AUDIT_FILE_TYPE = "json";
    AuditHandler consumerProvider = null;
    BlockingQueue<AuditIndexRecord> indexQueue = new LinkedBlockingQueue<AuditIndexRecord>();
    List<AuditIndexRecord> indexRecords = new ArrayList<AuditIndexRecord>();
    File logFolder = null;
    String logFileNameFormat = null;
    File archiveFolder = null;
    String fileNamePrefix = null;
    String indexFileName = null;
    File indexFile = null;
    String indexDoneFileName = null;
    String auditFileType = null;
    File indexDoneFile = null;
    int retryDestinationMS = 30000;
    int fileRolloverSec = 86400;
    int maxArchiveFiles = 100;
    int errorLogIntervalMS = 30000;
    long lastErrorLogMS = 0L;
    boolean isAuditFileCacheProviderEnabled = false;
    boolean closeFile = false;
    boolean isPending = false;
    long lastAttemptTime = 0L;
    long bufferSize = 1000L;
    boolean initDone = false;
    PrintWriter logWriter = null;
    AuditIndexRecord currentWriterIndexRecord = null;
    AuditIndexRecord currentConsumerIndexRecord = null;
    BufferedReader logReader = null;
    Thread destinationThread = null;
    boolean isWriting = true;
    boolean isDrain = false;
    boolean isDestDown = false;
    boolean isSpoolingSuccessful = true;

    public AuditFileQueueSpool(AuditHandler consumerProvider) {
        this.consumerProvider = consumerProvider;
    }

    public void init(Properties prop) {
        this.init(prop, null);
    }

    public boolean init(Properties props, String basePropertyName) {
        logger.debug("==> AuditFileQueueSpool.init()");
        if (this.initDone) {
            logger.error("init() called more than once. queueProvider=, consumerProvider=" + this.consumerProvider.getName());
            return true;
        }
        String propPrefix = "xasecure.audit.filespool";
        if (basePropertyName != null) {
            propPrefix = basePropertyName;
        }
        try {
            boolean ret;
            boolean ret2;
            boolean result;
            String logFolderProp = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_LOCAL_DIR);
            this.logFileNameFormat = MiscUtil.getStringProperty(props, basePropertyName + "." + PROP_FILE_SPOOL_LOCAL_FILE_NAME);
            String archiveFolderProp = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_ARCHIVE_DIR);
            this.fileNamePrefix = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_FILENAME_PREFIX);
            this.indexFileName = MiscUtil.getStringProperty(props, propPrefix + "." + PROP_FILE_SPOOL_INDEX_FILE);
            this.retryDestinationMS = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILE_SPOOL_DEST_RETRY_MS, this.retryDestinationMS);
            this.fileRolloverSec = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILE_SPOOL_FILE_ROLLOVER, this.fileRolloverSec);
            this.maxArchiveFiles = MiscUtil.getIntProperty(props, propPrefix + "." + PROP_FILE_SPOOL_ARCHIVE_MAX_FILES_COUNT, this.maxArchiveFiles);
            logger.info("retryDestinationMS=" + this.retryDestinationMS + ", queueName=" + FILE_QUEUE_PROVIDER_NAME);
            logger.info("fileRolloverSec=" + this.fileRolloverSec + ", queueName=" + FILE_QUEUE_PROVIDER_NAME);
            logger.info("maxArchiveFiles=" + this.maxArchiveFiles + ", queueName=" + FILE_QUEUE_PROVIDER_NAME);
            if (logFolderProp == null || logFolderProp.isEmpty()) {
                logger.error("Audit spool folder is not configured. Please set " + propPrefix + "." + PROP_FILE_SPOOL_LOCAL_DIR + ". queueName=" + FILE_QUEUE_PROVIDER_NAME);
                return false;
            }
            this.logFolder = new File(logFolderProp);
            if (!this.logFolder.isDirectory()) {
                result = this.logFolder.mkdirs();
                if (!this.logFolder.isDirectory() || !result) {
                    logger.error("File Spool folder not found and can't be created. folder=" + this.logFolder.getAbsolutePath() + ", queueName=" + FILE_QUEUE_PROVIDER_NAME);
                    return false;
                }
            }
            logger.info("logFolder=" + this.logFolder + ", queueName=" + FILE_QUEUE_PROVIDER_NAME);
            if (this.logFileNameFormat == null || this.logFileNameFormat.isEmpty()) {
                this.logFileNameFormat = "spool_%app-type%_%time:yyyyMMdd-HHmm.ss%.log";
            }
            logger.info("logFileNameFormat=" + this.logFileNameFormat + ", queueName=" + FILE_QUEUE_PROVIDER_NAME);
            this.archiveFolder = archiveFolderProp == null || archiveFolderProp.isEmpty() ? new File(this.logFolder, "archive") : new File(archiveFolderProp);
            if (!this.archiveFolder.isDirectory()) {
                result = this.archiveFolder.mkdirs();
                if (!this.archiveFolder.isDirectory() || !result) {
                    logger.error("File Spool archive folder not found and can't be created. folder=" + this.archiveFolder.getAbsolutePath() + ", queueName=" + FILE_QUEUE_PROVIDER_NAME);
                    return false;
                }
            }
            logger.info("archiveFolder=" + this.archiveFolder + ", queueName=" + FILE_QUEUE_PROVIDER_NAME);
            if (this.indexFileName == null || this.indexFileName.isEmpty()) {
                if (this.fileNamePrefix == null || this.fileNamePrefix.isEmpty()) {
                    this.fileNamePrefix = "AuditFileQueueSpool_" + this.consumerProvider.getName();
                }
                this.indexFileName = "index_" + this.fileNamePrefix + "_%app-type%.json";
                this.indexFileName = MiscUtil.replaceTokens(this.indexFileName, System.currentTimeMillis());
            }
            this.indexFile = new File(this.logFolder, this.indexFileName);
            if (!this.indexFile.exists() && !(ret2 = this.indexFile.createNewFile())) {
                logger.error("Error creating index file. fileName=" + this.indexFile.getPath());
                return false;
            }
            logger.info("indexFile=" + this.indexFile + ", queueName=" + FILE_QUEUE_PROVIDER_NAME);
            int lastDot = this.indexFileName.lastIndexOf(46);
            if (lastDot < 0) {
                lastDot = this.indexFileName.length() - 1;
            }
            this.indexDoneFileName = this.indexFileName.substring(0, lastDot) + "_closed.json";
            this.indexDoneFile = new File(this.logFolder, this.indexDoneFileName);
            if (!this.indexDoneFile.exists() && !(ret = this.indexDoneFile.createNewFile())) {
                logger.error("Error creating index done file. fileName=" + this.indexDoneFile.getPath());
                return false;
            }
            logger.info("indexDoneFile=" + this.indexDoneFile + ", queueName=" + FILE_QUEUE_PROVIDER_NAME);
            this.loadIndexFile();
            for (AuditIndexRecord auditIndexRecord : this.indexRecords) {
                if (!auditIndexRecord.getStatus().equals((Object)SPOOL_FILE_STATUS.done)) {
                    this.isPending = true;
                }
                if (auditIndexRecord.getStatus().equals((Object)SPOOL_FILE_STATUS.write_inprogress)) {
                    this.currentWriterIndexRecord = auditIndexRecord;
                    logger.info("currentWriterIndexRecord=" + this.currentWriterIndexRecord.getFilePath() + ", queueName=" + FILE_QUEUE_PROVIDER_NAME);
                }
                if (!auditIndexRecord.getStatus().equals((Object)SPOOL_FILE_STATUS.read_inprogress)) continue;
                this.indexQueue.add(auditIndexRecord);
            }
            this.printIndex();
            for (int i = 0; i < this.indexRecords.size(); ++i) {
                AuditIndexRecord auditIndexRecord;
                auditIndexRecord = this.indexRecords.get(i);
                if (!auditIndexRecord.getStatus().equals((Object)SPOOL_FILE_STATUS.pending)) continue;
                File consumerFile = new File(auditIndexRecord.getFilePath());
                if (!consumerFile.exists()) {
                    logger.error("INIT: Consumer file=" + consumerFile.getPath() + " not found.");
                    continue;
                }
                this.indexQueue.add(auditIndexRecord);
            }
            this.auditFileType = MiscUtil.getStringProperty(props, propPrefix + ".filetype", DEFAULT_AUDIT_FILE_TYPE);
            if (this.auditFileType == null) {
                this.auditFileType = DEFAULT_AUDIT_FILE_TYPE;
            }
        }
        catch (Throwable t) {
            logger.error("Error initializing File Spooler. queue=AuditFileQueueSpool", t);
            return false;
        }
        this.bufferSize = MiscUtil.getLongProperty(props, propPrefix + "." + PROP_FILE_SPOOL_BATCH_SIZE, this.bufferSize);
        this.initDone = true;
        logger.debug("<== AuditFileQueueSpool.init()");
        return true;
    }

    public void start() {
        if (!this.initDone) {
            logger.error("Cannot start Audit File Spooler. Initilization not done yet. queueName=AuditFileQueueSpool");
            return;
        }
        logger.info("Starting writerThread, queueName=AuditFileQueueSpool, consumer=" + this.consumerProvider.getName());
        this.destinationThread = new Thread((Runnable)this, "AuditFileQueueSpool_" + this.consumerProvider.getName() + "_destWriter");
        this.destinationThread.setDaemon(true);
        this.destinationThread.start();
    }

    public void stop() {
        if (!this.initDone) {
            logger.error("Cannot stop Audit File Spooler. Initilization not done. queueName=AuditFileQueueSpool");
            return;
        }
        logger.info("Stop called, queueName=AuditFileQueueSpool, consumer=" + this.consumerProvider.getName());
        this.isDrain = true;
        this.flush();
        PrintWriter out = this.getOpenLogFileStream();
        if (out != null) {
            for (int i = 0; i < 3; ++i) {
                if (this.isWriting) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    logger.info("Closing open file, queueName=AuditFileQueueSpool, consumer=" + this.consumerProvider.getName());
                    out.flush();
                    out.close();
                    break;
                }
                catch (Throwable t) {
                    logger.debug("Error closing spool out file.", t);
                }
            }
        }
        try {
            if (this.destinationThread != null) {
                this.destinationThread.interrupt();
            }
            this.destinationThread = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void flush() {
        if (!this.initDone) {
            logger.error("Cannot flush Audit File Spooler. Initilization not done. queueName=AuditFileQueueSpool");
            return;
        }
        PrintWriter out = this.getOpenLogFileStream();
        if (out != null) {
            out.flush();
        }
    }

    public boolean isPending() {
        if (!this.initDone) {
            this.logError("isPending(): File Spooler not initialized. queueName=AuditFileQueueSpool");
            return false;
        }
        return this.isPending;
    }

    public long getLastAttemptTimeDelta() {
        if (this.lastAttemptTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.lastAttemptTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stashLogs(AuditEventBase event) {
        if (this.isDrain) {
            logger.error("stashLogs() is called after stop is called. event=" + event);
            return;
        }
        try {
            this.isWriting = true;
            PrintWriter logOut = this.getLogFileStream();
            String jsonStr = MiscUtil.stringify(event);
            logOut.println(jsonStr);
            logOut.flush();
            this.isPending = true;
            this.isSpoolingSuccessful = true;
        }
        catch (Throwable t) {
            this.isSpoolingSuccessful = false;
            logger.error("Error writing to file. event=" + event, t);
        }
        finally {
            this.isWriting = false;
        }
    }

    public synchronized void stashLogs(Collection<AuditEventBase> events) {
        for (AuditEventBase event : events) {
            this.stashLogs(event);
        }
        this.flush();
    }

    public synchronized void stashLogsString(String event) {
        if (this.isDrain) {
            logger.error("stashLogs() is called after stop is called. event=" + event);
            return;
        }
        try {
            this.isWriting = true;
            PrintWriter logOut = this.getLogFileStream();
            logOut.println(event);
        }
        catch (Exception ex) {
            logger.error("Error writing to file. event=" + event, (Throwable)ex);
        }
        finally {
            this.isWriting = false;
        }
    }

    public synchronized boolean isSpoolingSuccessful() {
        return this.isSpoolingSuccessful;
    }

    public synchronized void stashLogsString(Collection<String> events) {
        for (String event : events) {
            this.stashLogsString(event);
        }
        this.flush();
    }

    private synchronized PrintWriter getOpenLogFileStream() {
        return this.logWriter;
    }

    private synchronized PrintWriter getLogFileStream() throws Exception {
        this.closeFileIfNeeded();
        if (this.currentWriterIndexRecord == null) {
            String fileName;
            Date currentTime = new Date();
            String newFileName = fileName = MiscUtil.replaceTokens(this.logFileNameFormat, currentTime.getTime());
            File outLogFile = null;
            int i = 0;
            while (true) {
                outLogFile = new File(this.logFolder, newFileName);
                File archiveLogFile = new File(this.archiveFolder, newFileName);
                if (!outLogFile.exists() && !archiveLogFile.exists()) break;
                int lastDot = fileName.lastIndexOf(46);
                String baseName = fileName.substring(0, lastDot);
                String extension = fileName.substring(lastDot);
                newFileName = baseName + "." + ++i + extension;
            }
            fileName = newFileName;
            logger.info("Creating new file. queueName=AuditFileQueueSpool, fileName=" + fileName);
            this.logWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outLogFile), "UTF-8")));
            AuditIndexRecord tmpIndexRecord = new AuditIndexRecord();
            tmpIndexRecord.setId(MiscUtil.generateUniqueId());
            tmpIndexRecord.setFilePath(outLogFile.getPath());
            tmpIndexRecord.setStatus(SPOOL_FILE_STATUS.write_inprogress);
            tmpIndexRecord.setFileCreateTime(currentTime);
            tmpIndexRecord.setLastAttempt(true);
            this.currentWriterIndexRecord = tmpIndexRecord;
            this.indexRecords.add(this.currentWriterIndexRecord);
            this.saveIndexFile();
        } else if (this.logWriter == null) {
            logger.info("Opening existing file for append. queueName=AuditFileQueueSpool, fileName=" + this.currentWriterIndexRecord.getFilePath());
            this.logWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.currentWriterIndexRecord.getFilePath(), true), "UTF-8")));
        }
        return this.logWriter;
    }

    private synchronized void closeFileIfNeeded() throws FileNotFoundException, IOException {
        if (this.currentWriterIndexRecord != null) {
            this.rollOverSpoolFileByTime();
            if (this.closeFile) {
                if (this.logWriter != null) {
                    this.logWriter.flush();
                    this.logWriter.close();
                    this.logWriter = null;
                    this.closeFile = false;
                }
                this.currentWriterIndexRecord.setStatus(SPOOL_FILE_STATUS.pending);
                this.currentWriterIndexRecord.setWriteCompleteTime(new Date());
                this.saveIndexFile();
                logger.info("Adding file to queue. queueName=AuditFileQueueSpool, fileName=" + this.currentWriterIndexRecord.getFilePath());
                this.indexQueue.add(this.currentWriterIndexRecord);
                this.currentWriterIndexRecord = null;
            }
        }
    }

    private void rollOverSpoolFileByTime() {
        if (System.currentTimeMillis() - this.currentWriterIndexRecord.getFileCreateTime().getTime() > (long)(this.fileRolloverSec * 1000)) {
            this.closeFile = true;
            logger.info("Closing file. Rolling over. queueName=AuditFileQueueSpool, fileName=" + this.currentWriterIndexRecord.getFilePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadIndexFile() throws IOException {
        logger.info("Loading index file. fileName=" + this.indexFile.getPath());
        try (BufferedReader br = null;){
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.indexFile), "UTF-8"));
            this.indexRecords.clear();
            while ((line = br.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("#")) continue;
                try {
                    AuditIndexRecord record = MiscUtil.fromJson(line, AuditIndexRecord.class);
                    this.indexRecords.add(record);
                }
                catch (Exception e) {
                    logger.error("Error parsing following JSON: " + line, (Throwable)e);
                }
            }
        }
    }

    synchronized void printIndex() {
        logger.info("INDEX printIndex() ==== START");
        for (AuditIndexRecord record : this.indexRecords) {
            logger.info("INDEX=" + record + ", isFileExist=" + new File(record.getFilePath()).exists());
        }
        logger.info("INDEX printIndex() ==== END");
    }

    synchronized void removeIndexRecord(AuditIndexRecord indexRecord) throws FileNotFoundException, IOException {
        Iterator<AuditIndexRecord> iter = this.indexRecords.iterator();
        while (iter.hasNext()) {
            AuditIndexRecord record = iter.next();
            if (!record.getId().equals(indexRecord.getId())) continue;
            logger.info("Removing file from index. file=" + record.getFilePath() + ", queueName=" + FILE_QUEUE_PROVIDER_NAME + ", consumer=" + this.consumerProvider.getName());
            iter.remove();
            this.appendToDoneFile(record);
        }
        this.saveIndexFile();
        if (this.indexRecords.size() == 0) {
            this.isPending = false;
        }
    }

    synchronized void saveIndexFile() throws FileNotFoundException, IOException {
        try (PrintWriter out = new PrintWriter(this.indexFile, "UTF-8");){
            for (AuditIndexRecord auditIndexRecord : this.indexRecords) {
                out.println(MiscUtil.stringify(auditIndexRecord));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendToDoneFile(AuditIndexRecord indexRecord) throws FileNotFoundException, IOException {
        block12: {
            logger.info("Moving to done file. " + indexRecord.getFilePath() + ", queueName=" + FILE_QUEUE_PROVIDER_NAME + ", consumer=" + this.consumerProvider.getName());
            String line = MiscUtil.stringify(indexRecord);
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.indexDoneFile, true), "UTF-8")));
            out.println(line);
            out.flush();
            out.close();
            this.consumerProvider.flush();
            File logFile = null;
            File archiveFile = null;
            try {
                logFile = new File(indexRecord.getFilePath());
                String fileName = logFile.getName();
                archiveFile = new File(this.archiveFolder, fileName);
                logger.info("Moving logFile " + logFile + " to " + archiveFile);
                boolean result = logFile.renameTo(archiveFile);
                if (!result) {
                    logger.error("Error moving log file to archive folder. Unable to rename" + logFile + " to archiveFile=" + archiveFile);
                }
            }
            catch (Throwable t) {
                logger.error("Error moving log file to archive folder. logFile=" + logFile + ", archiveFile=" + archiveFile, t);
            }
            this.consumerProvider.flush();
            archiveFile = null;
            try {
                File[] logFiles = this.archiveFolder.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.getName().toLowerCase().endsWith(".log");
                    }
                });
                if (logFiles == null || logFiles.length <= this.maxArchiveFiles) break block12;
                int filesToDelete = logFiles.length - this.maxArchiveFiles;
                try (BufferedReader br = new BufferedReader(new FileReader(this.indexDoneFile));){
                    int filesDeletedCount = 0;
                    while ((line = br.readLine()) != null) {
                        if (line.isEmpty() || line.startsWith("#")) continue;
                        try {
                            AuditIndexRecord record = MiscUtil.fromJson(line, AuditIndexRecord.class);
                            logFile = new File(record.getFilePath());
                            String fileName = logFile.getName();
                            archiveFile = new File(this.archiveFolder, fileName);
                            if (!archiveFile.exists()) continue;
                            logger.info("Deleting archive file " + archiveFile);
                            boolean ret = archiveFile.delete();
                            if (!ret) {
                                logger.error("Error deleting archive file. archiveFile=" + archiveFile);
                            }
                            if (++filesDeletedCount < filesToDelete) continue;
                            logger.info("Deleted " + filesDeletedCount + " files");
                            break;
                        }
                        catch (Exception e) {
                            logger.error("Error parsing following JSON: " + line, (Throwable)e);
                        }
                    }
                }
            }
            catch (Throwable t) {
                logger.error("Error deleting older archive file. archiveFile=" + archiveFile, t);
            }
        }
    }

    void logError(String msg) {
        long currTimeMS = System.currentTimeMillis();
        if (currTimeMS - this.lastErrorLogMS > (long)this.errorLogIntervalMS) {
            logger.error(msg);
            this.lastErrorLogMS = currTimeMS;
        }
    }

    @Override
    public void run() {
        try {
            MDC.clear();
            this.runLogAudit();
        }
        catch (Throwable t) {
            logger.error("Exited thread without abnormaly. queue=" + this.consumerProvider.getName(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runLogAudit() {
        block8: while (true) {
            try {
                while (true) {
                    if (this.isDestDown) {
                        logger.info("Destination is down. sleeping for " + this.retryDestinationMS + " milli seconds. indexQueue=" + this.indexQueue.size() + ", queueName=" + FILE_QUEUE_PROVIDER_NAME + ", consumer=" + this.consumerProvider.getName());
                        Thread.sleep(this.retryDestinationMS);
                    }
                    if (this.currentConsumerIndexRecord == null) {
                        this.currentConsumerIndexRecord = this.indexQueue.poll(this.retryDestinationMS, TimeUnit.MILLISECONDS);
                    } else {
                        Thread.sleep(this.retryDestinationMS);
                    }
                    if (this.isDrain) break block8;
                    if (this.currentConsumerIndexRecord == null) {
                        this.closeFileIfNeeded();
                        continue;
                    }
                    boolean isRemoveIndex = false;
                    File consumerFile = new File(this.currentConsumerIndexRecord.getFilePath());
                    if (!consumerFile.exists()) {
                        logger.error("Consumer file=" + consumerFile.getPath() + " not found.");
                        this.printIndex();
                        isRemoveIndex = true;
                    } else {
                        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.currentConsumerIndexRecord.getFilePath()), "UTF-8"));){
                            if (this.auditFileType.equalsIgnoreCase(DEFAULT_AUDIT_FILE_TYPE)) {
                                File srcFile = new File(this.currentConsumerIndexRecord.getFilePath());
                                this.logFile(srcFile);
                            } else {
                                this.logEvent(br);
                            }
                            logger.info("Done reading file. file=" + this.currentConsumerIndexRecord.getFilePath() + ", queueName=" + FILE_QUEUE_PROVIDER_NAME + ", consumer=" + this.consumerProvider.getName());
                            this.currentConsumerIndexRecord.setStatus(SPOOL_FILE_STATUS.done);
                            this.currentConsumerIndexRecord.setDoneCompleteTime(new Date());
                            this.currentConsumerIndexRecord.setLastAttempt(true);
                            isRemoveIndex = true;
                        }
                    }
                    if (!isRemoveIndex) continue;
                    this.removeIndexRecord(this.currentConsumerIndexRecord);
                    this.currentConsumerIndexRecord = null;
                    this.closeFileIfNeeded();
                }
            }
            catch (InterruptedException e) {
                logger.info("Caught exception in consumer thread. Shutdown might be in progress");
                continue;
            }
            catch (Throwable t) {
                logger.error("Exception in destination writing thread.", t);
                continue;
            }
            break;
        }
        logger.info("Exiting file spooler. provider=AuditFileQueueSpool, consumer=" + this.consumerProvider.getName());
    }

    private void logEvent(BufferedReader br) throws Exception {
        String line;
        int currLine = 0;
        int startLine = this.currentConsumerIndexRecord.getLinePosition();
        ArrayList<AuditEventBase> events = new ArrayList<AuditEventBase>();
        while ((line = br.readLine()) != null) {
            if (++currLine < startLine) continue;
            AuditEventBase event = MiscUtil.fromJson(line, AuthzAuditEvent.class);
            events.add(event);
            if ((long)events.size() != this.bufferSize) continue;
            boolean ret = this.sendEvent(events, this.currentConsumerIndexRecord, currLine);
            if (!ret) {
                throw new Exception("Destination down");
            }
            events.clear();
        }
        if (events.size() > 0) {
            boolean ret = this.sendEvent(events, this.currentConsumerIndexRecord, currLine);
            if (!ret) {
                throw new Exception("Destination down");
            }
            events.clear();
        }
    }

    private boolean sendEvent(List<AuditEventBase> events, AuditIndexRecord indexRecord, int currLine) {
        boolean ret = true;
        try {
            ret = this.consumerProvider.log(events);
            if (!ret) {
                this.logError("Error sending logs to consumer. provider=AuditFileQueueSpool, consumer=" + this.consumerProvider.getName());
            } else {
                indexRecord.setLinePosition(currLine);
                indexRecord.setStatus(SPOOL_FILE_STATUS.read_inprogress);
                indexRecord.setLastSuccessTime(new Date());
                indexRecord.setLastAttempt(true);
                this.saveIndexFile();
                if (this.isDestDown) {
                    this.isDestDown = false;
                    logger.info("Destination up now. " + indexRecord.getFilePath() + ", queueName=" + FILE_QUEUE_PROVIDER_NAME + ", consumer=" + this.consumerProvider.getName());
                }
            }
        }
        catch (Throwable t) {
            logger.error("Error while sending logs to consumer. provider=AuditFileQueueSpool, consumer=" + this.consumerProvider.getName() + ", log=" + events, t);
        }
        return ret;
    }

    private void logFile(File file) throws Exception {
        boolean ret;
        int startLine;
        int currLine;
        if (logger.isDebugEnabled()) {
            logger.debug("==> AuditFileQueueSpool.logFile()");
        }
        if ((currLine = 0) < (startLine = this.currentConsumerIndexRecord.getLinePosition())) {
            ++currLine;
        }
        if (!(ret = this.sendFile(file, this.currentConsumerIndexRecord, currLine))) {
            throw new Exception("Destination down");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== AuditFileQueueSpool.logFile()");
        }
    }

    private boolean sendFile(File file, AuditIndexRecord indexRecord, int currLine) {
        boolean ret = true;
        if (logger.isDebugEnabled()) {
            logger.debug("==> AuditFileQueueSpool.sendFile()");
        }
        try {
            ret = this.consumerProvider.logFile(file);
            if (!ret) {
                this.logError("Error sending log file to consumer. provider=AuditFileQueueSpool, consumer=" + this.consumerProvider.getName() + ", logFile=" + file.getName());
            } else {
                indexRecord.setLinePosition(currLine);
                indexRecord.setStatus(SPOOL_FILE_STATUS.read_inprogress);
                indexRecord.setLastSuccessTime(new Date());
                indexRecord.setLastAttempt(true);
                this.saveIndexFile();
                if (this.isDestDown) {
                    this.isDestDown = false;
                    logger.info("Destination up now. " + indexRecord.getFilePath() + ", queueName=" + FILE_QUEUE_PROVIDER_NAME + ", consumer=" + this.consumerProvider.getName());
                }
            }
        }
        catch (Throwable t) {
            logger.error("Error sending log file to consumer. provider=AuditFileQueueSpool, consumer=" + this.consumerProvider.getName() + ", logFile=" + file.getName(), t);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("<== AuditFileQueueSpool.sendFile() " + ret);
        }
        return ret;
    }
}

