/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.policyengine;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.ranger.authorization.hadoop.config.RangerPluginConfig;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineImpl;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfTestEngine {
    static final Logger LOG = LoggerFactory.getLogger(PerfTestEngine.class);
    private final URL servicePoliciesFileURL;
    private final RangerPolicyEngineOptions policyEngineOptions;
    private final URL configFileURL;
    private RangerPolicyEngine policyEvaluationEngine;
    private RangerPluginContext rangerPluginContext;

    public PerfTestEngine(URL servicePoliciesFileURL, RangerPolicyEngineOptions policyEngineOptions, URL configFileURL) {
        this.servicePoliciesFileURL = servicePoliciesFileURL;
        this.policyEngineOptions = policyEngineOptions;
        this.configFileURL = configFileURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> init()");
        }
        boolean ret = false;
        Gson gsonBuilder = new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z").setPrettyPrinting().create();
        Reader reader = null;
        try (InputStream in = this.servicePoliciesFileURL.openStream();){
            reader = new InputStreamReader(in, Charset.forName("UTF-8"));
            ServicePolicies servicePolicies = (ServicePolicies)gsonBuilder.fromJson(reader, ServicePolicies.class);
            RangerServiceDef serviceDef = servicePolicies.getServiceDef();
            String serviceType = serviceDef != null ? serviceDef.getName() : "";
            this.rangerPluginContext = new RangerPluginContext(new RangerPluginConfig(serviceType, null, "perf-test", null, null, this.policyEngineOptions));
            this.rangerPluginContext.getConfig().addResource(this.configFileURL);
            this.policyEvaluationEngine = new RangerPolicyEngineImpl(servicePolicies, this.rangerPluginContext, null);
            ret = true;
        }
        catch (Exception excp) {
            LOG.error("Error opening service-policies file or loading service-policies from file, URL=" + this.servicePoliciesFileURL, (Throwable)excp);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception excp) {
                    LOG.error("Error closing file", (Throwable)excp);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== init() : " + ret);
        }
        return ret;
    }

    public RangerAccessResult execute(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> execute(" + request + ")");
        }
        RangerAccessResult ret = null;
        if (this.policyEvaluationEngine != null) {
            ret = this.policyEvaluationEngine.evaluatePolicies(request, 0, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executed request = {" + request + "}, result={" + ret + "}");
            }
        } else {
            LOG.error("Error executing request: PolicyEngine is null!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== execute(" + request + ") : " + ret);
        }
        return ret;
    }

    public void cleanUp() {
        if (this.policyEvaluationEngine != null) {
            ((RangerPolicyEngineImpl)this.policyEvaluationEngine).releaseResources(true);
            this.policyEvaluationEngine = null;
        }
    }
}

