/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.elasticsearch.authorizer;

import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.plugin.audit.RangerMultiResourceAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;

public class RangerElasticsearchAuditHandler
extends RangerMultiResourceAuditHandler {
    private static final String PROP_ES_PLUGIN_AUDIT_EXCLUDED_USERS = "ranger.elasticsearch.plugin.audit.excluded.users";
    private static final String PROP_ES_PLUGIN_AUDIT_INDEX = "xasecure.audit.destination.elasticsearch.index";
    private String indexName = "ranger_audits";
    private String esUser = "elasticsearch";
    private List<String> excludeUsers = null;
    private AuthzAuditEvent auditEvent = null;

    public RangerElasticsearchAuditHandler(Configuration config) {
        String excludeUserList = config.get(PROP_ES_PLUGIN_AUDIT_EXCLUDED_USERS, this.esUser);
        this.excludeUsers = Arrays.asList(excludeUserList.split(","));
        this.indexName = config.get(PROP_ES_PLUGIN_AUDIT_INDEX, this.indexName);
    }

    public void processResult(RangerAccessResult result) {
        if (!this.isAuditingNeeded(result)) {
            return;
        }
        this.auditEvent = super.getAuthzEvents(result);
        super.logAuthzAudit(this.auditEvent);
    }

    private boolean isAuditingNeeded(RangerAccessResult result) {
        boolean ret = true;
        boolean isAllowed = result.getIsAllowed();
        RangerAccessRequest request = result.getAccessRequest();
        RangerAccessResourceImpl resource = (RangerAccessResourceImpl)request.getResource();
        String resourceName = (String)resource.getValue("index");
        String requestUser = request.getUser();
        if (resourceName != null && resourceName.equals(this.indexName) && this.excludeUsers.contains(requestUser) && isAllowed) {
            ret = false;
        }
        return ret;
    }
}

