/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsAbortPolicy;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.SizeBlockingQueue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.concurrent.XRejectedExecutionHandler;

public class EsThreadPoolExecutor
extends ThreadPoolExecutor {
    private final ThreadContext contextHolder;
    private volatile ShutdownListener listener;
    private final Object monitor = new Object();
    private final String name;

    final String getName() {
        return this.name;
    }

    EsThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, ThreadContext contextHolder) {
        this(name, corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, new EsAbortPolicy(), contextHolder);
    }

    @SuppressForbidden(reason="properly rethrowing errors, see EsExecutors.rethrowErrors")
    EsThreadPoolExecutor(String name, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, XRejectedExecutionHandler handler, ThreadContext contextHolder) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
        this.name = name;
        this.contextHolder = contextHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void terminated() {
        super.terminated();
        Object object = this.monitor;
        synchronized (object) {
            if (this.listener != null) {
                try {
                    this.listener.onTerminated();
                }
                finally {
                    this.listener = null;
                }
            }
        }
    }

    @Override
    public void execute(Runnable command) {
        command = this.wrapRunnable(command);
        try {
            super.execute(command);
        }
        catch (EsRejectedExecutionException ex) {
            if (command instanceof AbstractRunnable) {
                try {
                    ((AbstractRunnable)command).onRejection(ex);
                }
                finally {
                    ((AbstractRunnable)command).onAfter();
                }
            }
            throw ex;
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        EsExecutors.rethrowErrors(this.unwrap(r));
        assert (this.assertDefaultContext(r));
    }

    private boolean assertDefaultContext(Runnable r) {
        assert (this.contextHolder.isDefaultContext()) : "the thread context is not the default context and the thread [" + Thread.currentThread().getName() + "] is being returned to the pool after executing [" + r + "]";
        return true;
    }

    public Stream<Runnable> getTasks() {
        return this.getQueue().stream().map(this::unwrap);
    }

    @Override
    public final String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName()).append('[');
        b.append("name = ").append(this.name).append(", ");
        if (this.getQueue() instanceof SizeBlockingQueue) {
            SizeBlockingQueue queue = (SizeBlockingQueue)this.getQueue();
            b.append("queue capacity = ").append(queue.capacity()).append(", ");
        }
        this.appendThreadPoolExecutorDetails(b);
        b.append(super.toString()).append(']');
        return b.toString();
    }

    protected void appendThreadPoolExecutorDetails(StringBuilder sb) {
    }

    protected Runnable wrapRunnable(Runnable command) {
        return this.contextHolder.preserveContext(command);
    }

    protected Runnable unwrap(Runnable runnable) {
        return this.contextHolder.unwrap(runnable);
    }

    public static interface ShutdownListener {
        public void onTerminated();
    }
}

