/*
 * Copyright (C) 2015-2017, Ambiq Micro
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name of the copyright holder nor the names of itscontributors may be used to endorse
 * or promote products derived from thissoftware without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @file     apollo2.h
 * @brief    CMSIS HeaderFile
 * @version  1.0
 * @date     13. March 2017
 * @note     Generated by SVDConv V3.2.53 on Monday, 13.03.2017 18:37:05
 *           from File 'apollo2.svd',
 *           last modified on Monday, 13.03.2017 23:37:02
 */



/** @addtogroup Ambiq Micro
  * @{
  */


/** @addtogroup apollo2
  * @{
  */


#ifndef APOLLO2_H
#define APOLLO2_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Configuration_of_CMSIS
  * @{
  */



/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum {
/* =======================================  ARM Cortex-M4 Specific Interrupt Numbers  ======================================== */
  Reset_IRQn                = -15,              /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /*!< -13  Hard Fault, all classes of Fault                                     */
  MemoryManagement_IRQn     = -12,              /*!< -12  Memory Management, MPU mismatch, including Access Violation
                                                      and No Match                                                             */
  BusFault_IRQn             = -11,              /*!< -11  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                                      related Fault                                                            */
  UsageFault_IRQn           = -10,              /*!< -10  Usage Fault, i.e. Undef Instruction, Illegal State Transition        */
  SVCall_IRQn               =  -5,              /*!< -5 System Service Call via SVC instruction                                */
  DebugMonitor_IRQn         =  -4,              /*!< -4 Debug Monitor                                                          */
  PendSV_IRQn               =  -2,              /*!< -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /*!< -1 System Tick Timer                                                      */
/* ==========================================  apollo2 Specific Interrupt Numbers  =========================================== */
  BROWNOUT_IRQn             =   0,              /*!< 0  BROWNOUT                                                               */
  WDT_IRQn                  =   1,              /*!< 1  WDT                                                                    */
  CLKGEN_RTC_IRQn           =   2,              /*!< 2  CLKGEN_RTC                                                             */
  VCOMP_IRQn                =   3,              /*!< 3  VCOMP                                                                  */
  IOSLAVE_IRQn              =   4,              /*!< 4  IOSLAVE                                                                */
  IOSLAVEACC_IRQn           =   5,              /*!< 5  IOSLAVEACC                                                             */
  IOMSTR0_IRQn              =   6,              /*!< 6  IOMSTR0                                                                */
  IOMSTR1_IRQn              =   7,              /*!< 7  IOMSTR1                                                                */
  IOMSTR2_IRQn              =   8,              /*!< 8  IOMSTR2                                                                */
  IOMSTR3_IRQn              =   9,              /*!< 9  IOMSTR3                                                                */
  IOMSTR4_IRQn              =  10,              /*!< 10 IOMSTR4                                                                */
  IOMSTR5_IRQn              =  11,              /*!< 11 IOMSTR5                                                                */
  GPIO_IRQn                 =  12,              /*!< 12 GPIO                                                                   */
  CTIMER_IRQn               =  13,              /*!< 13 CTIMER                                                                 */
  UART0_IRQn                =  14,              /*!< 14 UART0                                                                  */
  UART1_IRQn                =  15,              /*!< 15 UART1                                                                  */
  ADC_IRQn                  =  16,              /*!< 16 ADC                                                                    */
  PDM_IRQn                  =  17,              /*!< 17 PDM                                                                    */
  STIMER_IRQn               =  18,              /*!< 18 STIMER                                                                 */
  STIMER_CMPR0_IRQn         =  19,              /*!< 19 STIMER_CMPR0                                                           */
  STIMER_CMPR1_IRQn         =  20,              /*!< 20 STIMER_CMPR1                                                           */
  STIMER_CMPR2_IRQn         =  21,              /*!< 21 STIMER_CMPR2                                                           */
  STIMER_CMPR3_IRQn         =  22,              /*!< 22 STIMER_CMPR3                                                           */
  STIMER_CMPR4_IRQn         =  23,              /*!< 23 STIMER_CMPR4                                                           */
  STIMER_CMPR5_IRQn         =  24,              /*!< 24 STIMER_CMPR5                                                           */
  STIMER_CMPR6_IRQn         =  25,              /*!< 25 STIMER_CMPR6                                                           */
  STIMER_CMPR7_IRQn         =  26               /*!< 26 STIMER_CMPR7                                                           */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ===========================  Configuration of the ARM Cortex-M4 Processor and Core Peripherals  =========================== */
#define __CM4_REV                 0x0100U       /*!< CM4 Core Revision                                                         */
#define __NVIC_PRIO_BITS               3        /*!< Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0        /*!< Set to 1 if different SysTick Config is used                              */
#define __MPU_PRESENT                  1        /*!< MPU present or not                                                        */
#define __FPU_PRESENT                  1        /*!< FPU present or not                                                        */


/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm4.h"                           /*!< ARM Cortex-M4 processor and core peripherals                              */
#include "system_apollo2.h"                     /*!< apollo2 System                                                            */

#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif


/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Analog Digital Converter Control (ADC)
  */

typedef struct {                                /*!< (@ 0x50010000) ADC Structure                                              */
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Configuration Register                                     */
    
    struct {
      __IOM uint32_t ADCEN      : 1;            /*!< (@ 0x00000000) This bit enables the ADC module. While the ADC
                                                                    is enabled, the ADCCFG and SLOT Configuration
                                                                    regsiter settings must remain stable and
                                                                    unchanged. All configuration register settings,
                                                                    slot configuration settings and window
                                                                    comparison settings should be written prior
                                                                    to setting the ADCEN bit to '1'.                           */
      __IM  uint32_t            : 1;
      __IOM uint32_t RPTEN      : 1;            /*!< (@ 0x00000002) This bit enables Repeating Scan Mode.                      */
      __IOM uint32_t LPMODE     : 1;            /*!< (@ 0x00000003) Select power mode to enter between active scans.           */
      __IOM uint32_t CKMODE     : 1;            /*!< (@ 0x00000004) Clock mode register                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t REFSEL     : 2;            /*!< (@ 0x00000008) Select the ADC reference voltage.                          */
      __IM  uint32_t            : 6;
      __IOM uint32_t TRIGSEL    : 3;            /*!< (@ 0x00000010) Select the ADC trigger source.                             */
      __IOM uint32_t TRIGPOL    : 1;            /*!< (@ 0x00000013) This bit selects the ADC trigger polarity for
                                                                    external off chip triggers.                                */
      __IM  uint32_t            : 4;
      __IOM uint32_t CLKSEL     : 2;            /*!< (@ 0x00000018) Select the source and frequency for the ADC clock.
                                                                    All values not enumerated below are undefined.             */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x00000004) ADC Power Status                                           */
    
    struct {
      __IOM uint32_t PWDSTAT    : 1;            /*!< (@ 0x00000000) Indicates the power-status of the ADC.                     */
    } STAT_b;
  } ;
  
  union {
    __IOM uint32_t SWT;                         /*!< (@ 0x00000008) Software trigger                                           */
    
    struct {
      __IOM uint32_t SWT        : 8;            /*!< (@ 0x00000000) Writing 0x37 to this register generates a software
                                                                    trigger.                                                   */
    } SWT_b;
  } ;
  
  union {
    __IOM uint32_t SL0CFG;                      /*!< (@ 0x0000000C) Slot 0 Configuration Register                              */
    
    struct {
      __IOM uint32_t SLEN0      : 1;            /*!< (@ 0x00000000) This bit enables slot 0 for ADC conversions.               */
      __IOM uint32_t WCEN0      : 1;            /*!< (@ 0x00000001) This bit enables the window compare function
                                                                    for slot 0.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL0     : 4;            /*!< (@ 0x00000008) Select one of the 14 channel inputs for this
                                                                    slot.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE0    : 2;            /*!< (@ 0x00000010) Set the Precision Mode For Slot.                           */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL0     : 3;            /*!< (@ 0x00000018) Select the number of measurements to average
                                                                    in the accumulate divide module for this
                                                                    slot.                                                      */
    } SL0CFG_b;
  } ;
  
  union {
    __IOM uint32_t SL1CFG;                      /*!< (@ 0x00000010) Slot 1 Configuration Register                              */
    
    struct {
      __IOM uint32_t SLEN1      : 1;            /*!< (@ 0x00000000) This bit enables slot 1 for ADC conversions.               */
      __IOM uint32_t WCEN1      : 1;            /*!< (@ 0x00000001) This bit enables the window compare function
                                                                    for slot 1.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL1     : 4;            /*!< (@ 0x00000008) Select one of the 14 channel inputs for this
                                                                    slot.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE1    : 2;            /*!< (@ 0x00000010) Set the Precision Mode For Slot.                           */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL1     : 3;            /*!< (@ 0x00000018) Select the number of measurements to average
                                                                    in the accumulate divide module for this
                                                                    slot.                                                      */
    } SL1CFG_b;
  } ;
  
  union {
    __IOM uint32_t SL2CFG;                      /*!< (@ 0x00000014) Slot 2 Configuration Register                              */
    
    struct {
      __IOM uint32_t SLEN2      : 1;            /*!< (@ 0x00000000) This bit enables slot 2 for ADC conversions.               */
      __IOM uint32_t WCEN2      : 1;            /*!< (@ 0x00000001) This bit enables the window compare function
                                                                    for slot 2.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL2     : 4;            /*!< (@ 0x00000008) Select one of the 14 channel inputs for this
                                                                    slot.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE2    : 2;            /*!< (@ 0x00000010) Set the Precision Mode For Slot.                           */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL2     : 3;            /*!< (@ 0x00000018) Select the number of measurements to average
                                                                    in the accumulate divide module for this
                                                                    slot.                                                      */
    } SL2CFG_b;
  } ;
  
  union {
    __IOM uint32_t SL3CFG;                      /*!< (@ 0x00000018) Slot 3 Configuration Register                              */
    
    struct {
      __IOM uint32_t SLEN3      : 1;            /*!< (@ 0x00000000) This bit enables slot 3 for ADC conversions.               */
      __IOM uint32_t WCEN3      : 1;            /*!< (@ 0x00000001) This bit enables the window compare function
                                                                    for slot 3.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL3     : 4;            /*!< (@ 0x00000008) Select one of the 14 channel inputs for this
                                                                    slot.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE3    : 2;            /*!< (@ 0x00000010) Set the Precision Mode For Slot.                           */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL3     : 3;            /*!< (@ 0x00000018) Select the number of measurements to average
                                                                    in the accumulate divide module for this
                                                                    slot.                                                      */
    } SL3CFG_b;
  } ;
  
  union {
    __IOM uint32_t SL4CFG;                      /*!< (@ 0x0000001C) Slot 4 Configuration Register                              */
    
    struct {
      __IOM uint32_t SLEN4      : 1;            /*!< (@ 0x00000000) This bit enables slot 4 for ADC conversions.               */
      __IOM uint32_t WCEN4      : 1;            /*!< (@ 0x00000001) This bit enables the window compare function
                                                                    for slot 4.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL4     : 4;            /*!< (@ 0x00000008) Select one of the 14 channel inputs for this
                                                                    slot.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE4    : 2;            /*!< (@ 0x00000010) Set the Precision Mode For Slot.                           */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL4     : 3;            /*!< (@ 0x00000018) Select the number of measurements to average
                                                                    in the accumulate divide module for this
                                                                    slot.                                                      */
    } SL4CFG_b;
  } ;
  
  union {
    __IOM uint32_t SL5CFG;                      /*!< (@ 0x00000020) Slot 5 Configuration Register                              */
    
    struct {
      __IOM uint32_t SLEN5      : 1;            /*!< (@ 0x00000000) This bit enables slot 5 for ADC conversions.               */
      __IOM uint32_t WCEN5      : 1;            /*!< (@ 0x00000001) This bit enables the window compare function
                                                                    for slot 5.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL5     : 4;            /*!< (@ 0x00000008) Select one of the 14 channel inputs for this
                                                                    slot.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE5    : 2;            /*!< (@ 0x00000010) Set the Precision Mode For Slot.                           */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL5     : 3;            /*!< (@ 0x00000018) Select number of measurements to average in the
                                                                    accumulate divide module for this slot.                    */
    } SL5CFG_b;
  } ;
  
  union {
    __IOM uint32_t SL6CFG;                      /*!< (@ 0x00000024) Slot 6 Configuration Register                              */
    
    struct {
      __IOM uint32_t SLEN6      : 1;            /*!< (@ 0x00000000) This bit enables slot 6 for ADC conversions.               */
      __IOM uint32_t WCEN6      : 1;            /*!< (@ 0x00000001) This bit enables the window compare function
                                                                    for slot 6.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL6     : 4;            /*!< (@ 0x00000008) Select one of the 14 channel inputs for this
                                                                    slot.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE6    : 2;            /*!< (@ 0x00000010) Set the Precision Mode For Slot.                           */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL6     : 3;            /*!< (@ 0x00000018) Select the number of measurements to average
                                                                    in the accumulate divide module for this
                                                                    slot.                                                      */
    } SL6CFG_b;
  } ;
  
  union {
    __IOM uint32_t SL7CFG;                      /*!< (@ 0x00000028) Slot 7 Configuration Register                              */
    
    struct {
      __IOM uint32_t SLEN7      : 1;            /*!< (@ 0x00000000) This bit enables slot 7 for ADC conversions.               */
      __IOM uint32_t WCEN7      : 1;            /*!< (@ 0x00000001) This bit enables the window compare function
                                                                    for slot 7.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL7     : 4;            /*!< (@ 0x00000008) Select one of the 14 channel inputs for this
                                                                    slot.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE7    : 2;            /*!< (@ 0x00000010) Set the Precision Mode For Slot.                           */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL7     : 3;            /*!< (@ 0x00000018) Select the number of measurements to average
                                                                    in the accumulate divide module for this
                                                                    slot.                                                      */
    } SL7CFG_b;
  } ;
  
  union {
    __IOM uint32_t WULIM;                       /*!< (@ 0x0000002C) Window Comparator Upper Limits Register                    */
    
    struct {
      __IOM uint32_t ULIM       : 20;           /*!< (@ 0x00000000) Sets the upper limit for the wondow comparator.            */
    } WULIM_b;
  } ;
  
  union {
    __IOM uint32_t WLLIM;                       /*!< (@ 0x00000030) Window Comparator Lower Limits Register                    */
    
    struct {
      __IOM uint32_t LLIM       : 20;           /*!< (@ 0x00000000) Sets the lower limit for the wondow comparator.            */
    } WLLIM_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t FIFO;                        /*!< (@ 0x00000038) FIFO Data and Valid Count Register                         */
    
    struct {
      __IOM uint32_t DATA       : 20;           /*!< (@ 0x00000000) Oldest data in the FIFO.                                   */
      __IOM uint32_t COUNT      : 8;            /*!< (@ 0x00000014) Number of valid entries in the ADC FIFO.                   */
      __IOM uint32_t SLOTNUM    : 3;            /*!< (@ 0x0000001C) Slot number associated with this FIFO data.                */
      __IOM uint32_t RSVD       : 1;            /*!< (@ 0x0000001F) RESERVED.                                                  */
    } FIFO_b;
  } ;
  __IM  uint32_t  RESERVED1[113];
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) ADC Interrupt registers: Enable                            */
    
    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< (@ 0x00000000) ADC conversion complete interrupt.                         */
      __IOM uint32_t SCNCMP     : 1;            /*!< (@ 0x00000001) ADC scan complete interrupt.                               */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< (@ 0x00000002) FIFO 75 percent full interrupt.                            */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< (@ 0x00000003) FIFO 100 percent full interrupt.                           */
      __IOM uint32_t WCEXC      : 1;            /*!< (@ 0x00000004) Window comparator voltage excursion interrupt.             */
      __IOM uint32_t WCINC      : 1;            /*!< (@ 0x00000005) Window comparator voltage incursion interrupt.             */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) ADC Interrupt registers: Status                            */
    
    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< (@ 0x00000000) ADC conversion complete interrupt.                         */
      __IOM uint32_t SCNCMP     : 1;            /*!< (@ 0x00000001) ADC scan complete interrupt.                               */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< (@ 0x00000002) FIFO 75 percent full interrupt.                            */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< (@ 0x00000003) FIFO 100 percent full interrupt.                           */
      __IOM uint32_t WCEXC      : 1;            /*!< (@ 0x00000004) Window comparator voltage excursion interrupt.             */
      __IOM uint32_t WCINC      : 1;            /*!< (@ 0x00000005) Window comparator voltage incursion interrupt.             */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) ADC Interrupt registers: Clear                             */
    
    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< (@ 0x00000000) ADC conversion complete interrupt.                         */
      __IOM uint32_t SCNCMP     : 1;            /*!< (@ 0x00000001) ADC scan complete interrupt.                               */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< (@ 0x00000002) FIFO 75 percent full interrupt.                            */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< (@ 0x00000003) FIFO 100 percent full interrupt.                           */
      __IOM uint32_t WCEXC      : 1;            /*!< (@ 0x00000004) Window comparator voltage excursion interrupt.             */
      __IOM uint32_t WCINC      : 1;            /*!< (@ 0x00000005) Window comparator voltage incursion interrupt.             */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) ADC Interrupt registers: Set                               */
    
    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< (@ 0x00000000) ADC conversion complete interrupt.                         */
      __IOM uint32_t SCNCMP     : 1;            /*!< (@ 0x00000001) ADC scan complete interrupt.                               */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< (@ 0x00000002) FIFO 75 percent full interrupt.                            */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< (@ 0x00000003) FIFO 100 percent full interrupt.                           */
      __IOM uint32_t WCEXC      : 1;            /*!< (@ 0x00000004) Window comparator voltage excursion interrupt.             */
      __IOM uint32_t WCINC      : 1;            /*!< (@ 0x00000005) Window comparator voltage incursion interrupt.             */
    } INTSET_b;
  } ;
} ADC_Type;                                     /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                         CACHECTRL                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief Flash Cache Controller (CACHECTRL)
  */

typedef struct {                                /*!< (@ 0x40018000) CACHECTRL Structure                                        */
  
  union {
    __IOM uint32_t CACHECFG;                    /*!< (@ 0x00000000) Flash Cache Control Register                               */
    
    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< (@ 0x00000000) Enables the flash cache controller. I/D caching
                                                                    enabled independently.                                     */
      __IOM uint32_t LRU        : 1;            /*!< (@ 0x00000001) Sets the cache replacement policy. 0=LRR (least
                                                                    recently replaced), 1=LRU (least recently
                                                                    used). LRR minimizes writes to the TAG
                                                                    SRAM.                                                      */
      __IOM uint32_t ENABLE_NC0 : 1;            /*!< (@ 0x00000002) Enable Non-cacheable region 0                              */
      __IOM uint32_t ENABLE_NC1 : 1;            /*!< (@ 0x00000003) Enable Non-cacheable region 1                              */
      __IOM uint32_t CONFIG     : 3;            /*!< (@ 0x00000004) Sets the cache configuration                               */
      __IOM uint32_t SERIAL     : 1;            /*!< (@ 0x00000007) Bitfield should always be programmed to 0.                 */
      __IOM uint32_t ICACHE_ENABLE : 1;         /*!< (@ 0x00000008) Enable Flash Instruction Caching                           */
      __IOM uint32_t DCACHE_ENABLE : 1;         /*!< (@ 0x00000009) Enable Flash Instruction Caching                           */
      __IOM uint32_t CACHE_CLKGATE : 1;         /*!< (@ 0x0000000A) Enable clock gating of cache RAMs                          */
      __IOM uint32_t CACHE_LS   : 1;            /*!< (@ 0x0000000B) Enable LS (light sleep) of cache RAMs. When this
                                                                    bit is set, the cache's RAMS will be put
                                                                    into light sleep mode while inactive. NOTE:
                                                                    if the cache is actively used, this may
                                                                    have an adverse affect on power since entering/exiting
                                                                    LS mode may consume more power than would
                                                                    be saved.                                                  */
      __IOM uint32_t DLY        : 4;            /*!< (@ 0x0000000C) Data RAM delay                                             */
      __IOM uint32_t SMDLY      : 4;            /*!< (@ 0x00000010) Data RAM delay                                             */
      __IOM uint32_t DATA_CLKGATE : 1;          /*!< (@ 0x00000014) Enable clock gating of entire data array                   */
      __IM  uint32_t            : 3;
      __IOM uint32_t ENABLE_MONITOR : 1;        /*!< (@ 0x00000018) Enable Cache Monitoring Stats                              */
    } CACHECFG_b;
  } ;
  
  union {
    __IOM uint32_t FLASHCFG;                    /*!< (@ 0x00000004) Flash Control Register                                     */
    
    struct {
      __IOM uint32_t RD_WAIT    : 3;            /*!< (@ 0x00000000) Sets read waitstates (HCLK cycles)                         */
    } FLASHCFG_b;
  } ;
  
  union {
    __IOM uint32_t CACHECTRL;                   /*!< (@ 0x00000008) Cache Control                                              */
    
    struct {
      __IOM uint32_t INVALIDATE : 1;            /*!< (@ 0x00000000) Writing a 1 to this bitfield invalidates the
                                                                    flash cache contents.                                      */
      __IOM uint32_t RESET_STAT : 1;            /*!< (@ 0x00000001) Writing a 1 to this bitfield will reset the cache
                                                                    monitor statistics (DMON0-3, IMON0-3).
                                                                    Statistic gathering can be paused/stopped
                                                                    by disabling the MONITOR_ENABLE bit in
                                                                    CACHECFG, which will maintain the count
                                                                    values until the stats are reset by writing
                                                                    this bitfield.                                             */
      __IOM uint32_t CACHE_READY : 1;           /*!< (@ 0x00000002) Cache Ready Status (enabled and not processing
                                                                    an invalidate operation)                                   */
      __IM  uint32_t            : 1;
      __IOM uint32_t FLASH0_SLM_STATUS : 1;     /*!< (@ 0x00000004) Flash Sleep Mode Status                                    */
      __IOM uint32_t FLASH0_SLM_DISABLE : 1;    /*!< (@ 0x00000005) Disable Flash Sleep Mode                                   */
      __IOM uint32_t FLASH0_SLM_ENABLE : 1;     /*!< (@ 0x00000006) Enable Flash Sleep Mode                                    */
      __IM  uint32_t            : 1;
      __IOM uint32_t FLASH1_SLM_STATUS : 1;     /*!< (@ 0x00000008) Flash Sleep Mode Status                                    */
      __IOM uint32_t FLASH1_SLM_DISABLE : 1;    /*!< (@ 0x00000009) Disable Flash Sleep Mode                                   */
      __IOM uint32_t FLASH1_SLM_ENABLE : 1;     /*!< (@ 0x0000000A) Enable Flash Sleep Mode                                    */
    } CACHECTRL_b;
  } ;
  __IM  uint32_t  RESERVED;
  
  union {
    __IOM uint32_t NCR0START;                   /*!< (@ 0x00000010) Flash Cache Noncachable Region 0 Start Address.            */
    
    struct {
      __IM  uint32_t            : 4;
      __IOM uint32_t ADDR       : 16;           /*!< (@ 0x00000004) Start address for non-cacheable region 0. The
                                                                    physical address of the start of this region
                                                                    should be programmed to this register and
                                                                    must be aligned to a 16-byte boundary (thus
                                                                    the lower 4 address bits are unused).                      */
    } NCR0START_b;
  } ;
  
  union {
    __IOM uint32_t NCR0END;                     /*!< (@ 0x00000014) Flash Cache Noncachable Region 0 End                       */
    
    struct {
      __IM  uint32_t            : 4;
      __IOM uint32_t ADDR       : 16;           /*!< (@ 0x00000004) End address for non-cacheable region 0. The physical
                                                                    address of the end of this region should
                                                                    be programmed to this register and must
                                                                    be aligned to a 16-byte boundary (thus
                                                                    the lower 4 address bits are unused).                      */
    } NCR0END_b;
  } ;
  
  union {
    __IOM uint32_t NCR1START;                   /*!< (@ 0x00000018) Flash Cache Noncachable Region 1 Start                     */
    
    struct {
      __IM  uint32_t            : 4;
      __IOM uint32_t ADDR       : 16;           /*!< (@ 0x00000004) Start address for non-cacheable region 1. The
                                                                    physical address of the start of this region
                                                                    should be programmed to this register and
                                                                    must be aligned to a 16-byte boundary (thus
                                                                    the lower 4 address bits are unused).                      */
    } NCR1START_b;
  } ;
  
  union {
    __IOM uint32_t NCR1END;                     /*!< (@ 0x0000001C) Flash Cache Noncachable Region 1 End                       */
    
    struct {
      __IM  uint32_t            : 4;
      __IOM uint32_t ADDR       : 16;           /*!< (@ 0x00000004) End address for non-cacheable region 1. The physical
                                                                    address of the end of this region should
                                                                    be programmed to this register and must
                                                                    be aligned to a 16-byte boundary (thus
                                                                    the lower 4 address bits are unused).                      */
    } NCR1END_b;
  } ;
  __IM  uint32_t  RESERVED1[4];
  
  union {
    __IOM uint32_t CACHEMODE;                   /*!< (@ 0x00000030) Flash Cache Mode Register. Used to trim performance/power. */
    
    struct {
      __IOM uint32_t THROTTLE1  : 1;            /*!< (@ 0x00000000) Disallow cache data RAM writes on tag RAM fill
                                                                    cycles                                                     */
      __IOM uint32_t THROTTLE2  : 1;            /*!< (@ 0x00000001) Disallow cache data RAM writes on tag RAM read
                                                                    cycles                                                     */
      __IOM uint32_t THROTTLE3  : 1;            /*!< (@ 0x00000002) Disallow cache data RAM writes on data RAM read
                                                                    cycles                                                     */
      __IOM uint32_t THROTTLE4  : 1;            /*!< (@ 0x00000003) Disallow Data RAM reads (from line hits) on tag
                                                                    RAM fill cycles                                            */
      __IOM uint32_t THROTTLE5  : 1;            /*!< (@ 0x00000004) Disallow Data RAM reads (from line hits) during
                                                                    lookup read ops                                            */
      __IOM uint32_t THROTTLE6  : 1;            /*!< (@ 0x00000005) Disallow Simultaneous Data RAM reads (from 2
                                                                    line hits on each bus)                                     */
    } CACHEMODE_b;
  } ;
  __IM  uint32_t  RESERVED2[3];
  
  union {
    __IOM uint32_t DMON0;                       /*!< (@ 0x00000040) Data Cache Total Accesses                                  */
    
    struct {
      __IOM uint32_t DACCESS_COUNT : 32;        /*!< (@ 0x00000000) Total accesses to data cache                               */
    } DMON0_b;
  } ;
  
  union {
    __IOM uint32_t DMON1;                       /*!< (@ 0x00000044) Data Cache Tag Lookups                                     */
    
    struct {
      __IOM uint32_t DLOOKUP_COUNT : 32;        /*!< (@ 0x00000000) Total tag lookups from data cache                          */
    } DMON1_b;
  } ;
  
  union {
    __IOM uint32_t DMON2;                       /*!< (@ 0x00000048) Data Cache Hits                                            */
    
    struct {
      __IOM uint32_t DHIT_COUNT : 32;           /*!< (@ 0x00000000) Cache hits from lookup operations                          */
    } DMON2_b;
  } ;
  
  union {
    __IOM uint32_t DMON3;                       /*!< (@ 0x0000004C) Data Cache Line Hits                                       */
    
    struct {
      __IOM uint32_t DLINE_COUNT : 32;          /*!< (@ 0x00000000) Cache hits from line cache                                 */
    } DMON3_b;
  } ;
  
  union {
    __IOM uint32_t IMON0;                       /*!< (@ 0x00000050) Instruction Cache Total Accesses                           */
    
    struct {
      __IOM uint32_t IACCESS_COUNT : 32;        /*!< (@ 0x00000000) Total accesses to Instruction cache                        */
    } IMON0_b;
  } ;
  
  union {
    __IOM uint32_t IMON1;                       /*!< (@ 0x00000054) Instruction Cache Tag Lookups                              */
    
    struct {
      __IOM uint32_t ILOOKUP_COUNT : 32;        /*!< (@ 0x00000000) Total tag lookups from Instruction cache                   */
    } IMON1_b;
  } ;
  
  union {
    __IOM uint32_t IMON2;                       /*!< (@ 0x00000058) Instruction Cache Hits                                     */
    
    struct {
      __IOM uint32_t IHIT_COUNT : 32;           /*!< (@ 0x00000000) Cache hits from lookup operations                          */
    } IMON2_b;
  } ;
  
  union {
    __IOM uint32_t IMON3;                       /*!< (@ 0x0000005C) Instruction Cache Line Hits                                */
    
    struct {
      __IOM uint32_t ILINE_COUNT : 32;          /*!< (@ 0x00000000) Cache hits from line cache                                 */
    } IMON3_b;
  } ;
} CACHECTRL_Type;                               /*!< Size = 96 (0x60)                                                          */



/* =========================================================================================================================== */
/* ================                                          CTIMER                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Counter/Timer (CTIMER)
  */

typedef struct {                                /*!< (@ 0x40008000) CTIMER Structure                                           */
  
  union {
    __IOM uint32_t TMR0;                        /*!< (@ 0x00000000) Counter/Timer Register                                     */
    
    struct {
      __IOM uint32_t CTTMRA0    : 16;           /*!< (@ 0x00000000) Counter/Timer A0.                                          */
      __IOM uint32_t CTTMRB0    : 16;           /*!< (@ 0x00000010) Counter/Timer B0.                                          */
    } TMR0_b;
  } ;
  
  union {
    __IOM uint32_t CMPRA0;                      /*!< (@ 0x00000004) Counter/Timer A0 Compare Registers                         */
    
    struct {
      __IOM uint32_t CMPR0A0    : 16;           /*!< (@ 0x00000000) Counter/Timer A0 Compare Register 0. Holds the
                                                                    lower limit for timer half A.                              */
      __IOM uint32_t CMPR1A0    : 16;           /*!< (@ 0x00000010) Counter/Timer A0 Compare Register 1. Holds the
                                                                    upper limit for timer half A.                              */
    } CMPRA0_b;
  } ;
  
  union {
    __IOM uint32_t CMPRB0;                      /*!< (@ 0x00000008) Counter/Timer B0 Compare Registers                         */
    
    struct {
      __IOM uint32_t CMPR0B0    : 16;           /*!< (@ 0x00000000) Counter/Timer B0 Compare Register 0. Holds the
                                                                    lower limit for timer half B.                              */
      __IOM uint32_t CMPR1B0    : 16;           /*!< (@ 0x00000010) Counter/Timer B0 Compare Register 1. Holds the
                                                                    upper limit for timer half B.                              */
    } CMPRB0_b;
  } ;
  
  union {
    __IOM uint32_t CTRL0;                       /*!< (@ 0x0000000C) Counter/Timer Control                                      */
    
    struct {
      __IOM uint32_t TMRA0EN    : 1;            /*!< (@ 0x00000000) Counter/Timer A0 Enable bit.                               */
      __IOM uint32_t TMRA0CLK   : 5;            /*!< (@ 0x00000001) Counter/Timer A0 Clock Select.                             */
      __IOM uint32_t TMRA0FN    : 3;            /*!< (@ 0x00000006) Counter/Timer A0 Function Select.                          */
      __IOM uint32_t TMRA0IE0   : 1;            /*!< (@ 0x00000009) Counter/Timer A0 Interrupt Enable bit based on
                                                                    COMPR0.                                                    */
      __IOM uint32_t TMRA0IE1   : 1;            /*!< (@ 0x0000000A) Counter/Timer A0 Interrupt Enable bit based on
                                                                    COMPR1.                                                    */
      __IOM uint32_t TMRA0CLR   : 1;            /*!< (@ 0x0000000B) Counter/Timer A0 Clear bit.                                */
      __IOM uint32_t TMRA0POL   : 1;            /*!< (@ 0x0000000C) Counter/Timer A0 output polarity.                          */
      __IOM uint32_t TMRA0PE    : 1;            /*!< (@ 0x0000000D) Counter/Timer A0 Output Enable bit.                        */
      __IM  uint32_t            : 2;
      __IOM uint32_t TMRB0EN    : 1;            /*!< (@ 0x00000010) Counter/Timer B0 Enable bit.                               */
      __IOM uint32_t TMRB0CLK   : 5;            /*!< (@ 0x00000011) Counter/Timer B0 Clock Select.                             */
      __IOM uint32_t TMRB0FN    : 3;            /*!< (@ 0x00000016) Counter/Timer B0 Function Select.                          */
      __IOM uint32_t TMRB0IE0   : 1;            /*!< (@ 0x00000019) Counter/Timer B0 Interrupt Enable bit for COMPR0.          */
      __IOM uint32_t TMRB0IE1   : 1;            /*!< (@ 0x0000001A) Counter/Timer B0 Interrupt Enable bit for COMPR1.          */
      __IOM uint32_t TMRB0CLR   : 1;            /*!< (@ 0x0000001B) Counter/Timer B0 Clear bit.                                */
      __IOM uint32_t TMRB0POL   : 1;            /*!< (@ 0x0000001C) Counter/Timer B0 output polarity.                          */
      __IOM uint32_t TMRB0PE    : 1;            /*!< (@ 0x0000001D) Counter/Timer B0 Output Enable bit.                        */
      __IM  uint32_t            : 1;
      __IOM uint32_t CTLINK0    : 1;            /*!< (@ 0x0000001F) Counter/Timer A0/B0 Link bit.                              */
    } CTRL0_b;
  } ;
  
  union {
    __IOM uint32_t TMR1;                        /*!< (@ 0x00000010) Counter/Timer Register                                     */
    
    struct {
      __IOM uint32_t CTTMRA1    : 16;           /*!< (@ 0x00000000) Counter/Timer A1.                                          */
      __IOM uint32_t CTTMRB1    : 16;           /*!< (@ 0x00000010) Counter/Timer B1.                                          */
    } TMR1_b;
  } ;
  
  union {
    __IOM uint32_t CMPRA1;                      /*!< (@ 0x00000014) Counter/Timer A1 Compare Registers                         */
    
    struct {
      __IOM uint32_t CMPR0A1    : 16;           /*!< (@ 0x00000000) Counter/Timer A1 Compare Register 0.                       */
      __IOM uint32_t CMPR1A1    : 16;           /*!< (@ 0x00000010) Counter/Timer A1 Compare Register 1.                       */
    } CMPRA1_b;
  } ;
  
  union {
    __IOM uint32_t CMPRB1;                      /*!< (@ 0x00000018) Counter/Timer B1 Compare Registers                         */
    
    struct {
      __IOM uint32_t CMPR0B1    : 16;           /*!< (@ 0x00000000) Counter/Timer B1 Compare Register 0.                       */
      __IOM uint32_t CMPR1B1    : 16;           /*!< (@ 0x00000010) Counter/Timer B1 Compare Register 1.                       */
    } CMPRB1_b;
  } ;
  
  union {
    __IOM uint32_t CTRL1;                       /*!< (@ 0x0000001C) Counter/Timer Control                                      */
    
    struct {
      __IOM uint32_t TMRA1EN    : 1;            /*!< (@ 0x00000000) Counter/Timer A1 Enable bit.                               */
      __IOM uint32_t TMRA1CLK   : 5;            /*!< (@ 0x00000001) Counter/Timer A1 Clock Select.                             */
      __IOM uint32_t TMRA1FN    : 3;            /*!< (@ 0x00000006) Counter/Timer A1 Function Select.                          */
      __IOM uint32_t TMRA1IE0   : 1;            /*!< (@ 0x00000009) Counter/Timer A1 Interrupt Enable bit based on
                                                                    COMPR0.                                                    */
      __IOM uint32_t TMRA1IE1   : 1;            /*!< (@ 0x0000000A) Counter/Timer A1 Interrupt Enable bit based on
                                                                    COMPR1.                                                    */
      __IOM uint32_t TMRA1CLR   : 1;            /*!< (@ 0x0000000B) Counter/Timer A1 Clear bit.                                */
      __IOM uint32_t TMRA1POL   : 1;            /*!< (@ 0x0000000C) Counter/Timer A1 output polarity.                          */
      __IOM uint32_t TMRA1PE    : 1;            /*!< (@ 0x0000000D) Counter/Timer A1 Output Enable bit.                        */
      __IM  uint32_t            : 2;
      __IOM uint32_t TMRB1EN    : 1;            /*!< (@ 0x00000010) Counter/Timer B1 Enable bit.                               */
      __IOM uint32_t TMRB1CLK   : 5;            /*!< (@ 0x00000011) Counter/Timer B1 Clock Select.                             */
      __IOM uint32_t TMRB1FN    : 3;            /*!< (@ 0x00000016) Counter/Timer B1 Function Select.                          */
      __IOM uint32_t TMRB1IE0   : 1;            /*!< (@ 0x00000019) Counter/Timer B1 Interrupt Enable bit for COMPR0.          */
      __IOM uint32_t TMRB1IE1   : 1;            /*!< (@ 0x0000001A) Counter/Timer B1 Interrupt Enable bit for COMPR1.          */
      __IOM uint32_t TMRB1CLR   : 1;            /*!< (@ 0x0000001B) Counter/Timer B1 Clear bit.                                */
      __IOM uint32_t TMRB1POL   : 1;            /*!< (@ 0x0000001C) Counter/Timer B1 output polarity.                          */
      __IOM uint32_t TMRB1PE    : 1;            /*!< (@ 0x0000001D) Counter/Timer B1 Output Enable bit.                        */
      __IM  uint32_t            : 1;
      __IOM uint32_t CTLINK1    : 1;            /*!< (@ 0x0000001F) Counter/Timer A1/B1 Link bit.                              */
    } CTRL1_b;
  } ;
  
  union {
    __IOM uint32_t TMR2;                        /*!< (@ 0x00000020) Counter/Timer Register                                     */
    
    struct {
      __IOM uint32_t CTTMRA2    : 16;           /*!< (@ 0x00000000) Counter/Timer A2.                                          */
      __IOM uint32_t CTTMRB2    : 16;           /*!< (@ 0x00000010) Counter/Timer B2.                                          */
    } TMR2_b;
  } ;
  
  union {
    __IOM uint32_t CMPRA2;                      /*!< (@ 0x00000024) Counter/Timer A2 Compare Registers                         */
    
    struct {
      __IOM uint32_t CMPR0A2    : 16;           /*!< (@ 0x00000000) Counter/Timer A2 Compare Register 0.                       */
      __IOM uint32_t CMPR1A2    : 16;           /*!< (@ 0x00000010) Counter/Timer A2 Compare Register 1.                       */
    } CMPRA2_b;
  } ;
  
  union {
    __IOM uint32_t CMPRB2;                      /*!< (@ 0x00000028) Counter/Timer B2 Compare Registers                         */
    
    struct {
      __IOM uint32_t CMPR0B2    : 16;           /*!< (@ 0x00000000) Counter/Timer B2 Compare Register 0.                       */
      __IOM uint32_t CMPR1B2    : 16;           /*!< (@ 0x00000010) Counter/Timer B2 Compare Register 1.                       */
    } CMPRB2_b;
  } ;
  
  union {
    __IOM uint32_t CTRL2;                       /*!< (@ 0x0000002C) Counter/Timer Control                                      */
    
    struct {
      __IOM uint32_t TMRA2EN    : 1;            /*!< (@ 0x00000000) Counter/Timer A2 Enable bit.                               */
      __IOM uint32_t TMRA2CLK   : 5;            /*!< (@ 0x00000001) Counter/Timer A2 Clock Select.                             */
      __IOM uint32_t TMRA2FN    : 3;            /*!< (@ 0x00000006) Counter/Timer A2 Function Select.                          */
      __IOM uint32_t TMRA2IE0   : 1;            /*!< (@ 0x00000009) Counter/Timer A2 Interrupt Enable bit based on
                                                                    COMPR0.                                                    */
      __IOM uint32_t TMRA2IE1   : 1;            /*!< (@ 0x0000000A) Counter/Timer A2 Interrupt Enable bit based on
                                                                    COMPR1.                                                    */
      __IOM uint32_t TMRA2CLR   : 1;            /*!< (@ 0x0000000B) Counter/Timer A2 Clear bit.                                */
      __IOM uint32_t TMRA2POL   : 1;            /*!< (@ 0x0000000C) Counter/Timer A2 output polarity.                          */
      __IOM uint32_t TMRA2PE    : 1;            /*!< (@ 0x0000000D) Counter/Timer A2 Output Enable bit.                        */
      __IM  uint32_t            : 2;
      __IOM uint32_t TMRB2EN    : 1;            /*!< (@ 0x00000010) Counter/Timer B2 Enable bit.                               */
      __IOM uint32_t TMRB2CLK   : 5;            /*!< (@ 0x00000011) Counter/Timer B2 Clock Select.                             */
      __IOM uint32_t TMRB2FN    : 3;            /*!< (@ 0x00000016) Counter/Timer B2 Function Select.                          */
      __IOM uint32_t TMRB2IE0   : 1;            /*!< (@ 0x00000019) Counter/Timer B2 Interrupt Enable bit for COMPR0.          */
      __IOM uint32_t TMRB2IE1   : 1;            /*!< (@ 0x0000001A) Counter/Timer B2 Interrupt Enable bit for COMPR1.          */
      __IOM uint32_t TMRB2CLR   : 1;            /*!< (@ 0x0000001B) Counter/Timer B2 Clear bit.                                */
      __IOM uint32_t TMRB2POL   : 1;            /*!< (@ 0x0000001C) Counter/Timer B2 output polarity.                          */
      __IOM uint32_t TMRB2PE    : 1;            /*!< (@ 0x0000001D) Counter/Timer B2 Output Enable bit.                        */
      __IM  uint32_t            : 1;
      __IOM uint32_t CTLINK2    : 1;            /*!< (@ 0x0000001F) Counter/Timer A2/B2 Link bit.                              */
    } CTRL2_b;
  } ;
  
  union {
    __IOM uint32_t TMR3;                        /*!< (@ 0x00000030) Counter/Timer Register                                     */
    
    struct {
      __IOM uint32_t CTTMRA3    : 16;           /*!< (@ 0x00000000) Counter/Timer A3.                                          */
      __IOM uint32_t CTTMRB3    : 16;           /*!< (@ 0x00000010) Counter/Timer B3.                                          */
    } TMR3_b;
  } ;
  
  union {
    __IOM uint32_t CMPRA3;                      /*!< (@ 0x00000034) Counter/Timer A3 Compare Registers                         */
    
    struct {
      __IOM uint32_t CMPR0A3    : 16;           /*!< (@ 0x00000000) Counter/Timer A3 Compare Register 0.                       */
      __IOM uint32_t CMPR1A3    : 16;           /*!< (@ 0x00000010) Counter/Timer A3 Compare Register 1.                       */
    } CMPRA3_b;
  } ;
  
  union {
    __IOM uint32_t CMPRB3;                      /*!< (@ 0x00000038) Counter/Timer B3 Compare Registers                         */
    
    struct {
      __IOM uint32_t CMPR0B3    : 16;           /*!< (@ 0x00000000) Counter/Timer B3 Compare Register 0.                       */
      __IOM uint32_t CMPR1B3    : 16;           /*!< (@ 0x00000010) Counter/Timer B3 Compare Register 1.                       */
    } CMPRB3_b;
  } ;
  
  union {
    __IOM uint32_t CTRL3;                       /*!< (@ 0x0000003C) Counter/Timer Control                                      */
    
    struct {
      __IOM uint32_t TMRA3EN    : 1;            /*!< (@ 0x00000000) Counter/Timer A3 Enable bit.                               */
      __IOM uint32_t TMRA3CLK   : 5;            /*!< (@ 0x00000001) Counter/Timer A3 Clock Select.                             */
      __IOM uint32_t TMRA3FN    : 3;            /*!< (@ 0x00000006) Counter/Timer A3 Function Select.                          */
      __IOM uint32_t TMRA3IE0   : 1;            /*!< (@ 0x00000009) Counter/Timer A3 Interrupt Enable bit based on
                                                                    COMPR0.                                                    */
      __IOM uint32_t TMRA3IE1   : 1;            /*!< (@ 0x0000000A) Counter/Timer A3 Interrupt Enable bit based on
                                                                    COMPR1.                                                    */
      __IOM uint32_t TMRA3CLR   : 1;            /*!< (@ 0x0000000B) Counter/Timer A3 Clear bit.                                */
      __IOM uint32_t TMRA3POL   : 1;            /*!< (@ 0x0000000C) Counter/Timer A3 output polarity.                          */
      __IOM uint32_t TMRA3PE    : 1;            /*!< (@ 0x0000000D) Counter/Timer A3 Output Enable bit.                        */
      __IM  uint32_t            : 1;
      __IOM uint32_t ADCEN      : 1;            /*!< (@ 0x0000000F) Special Timer A3 enable for ADC function.                  */
      __IOM uint32_t TMRB3EN    : 1;            /*!< (@ 0x00000010) Counter/Timer B3 Enable bit.                               */
      __IOM uint32_t TMRB3CLK   : 5;            /*!< (@ 0x00000011) Counter/Timer B3 Clock Select.                             */
      __IOM uint32_t TMRB3FN    : 3;            /*!< (@ 0x00000016) Counter/Timer B3 Function Select.                          */
      __IOM uint32_t TMRB3IE0   : 1;            /*!< (@ 0x00000019) Counter/Timer B3 Interrupt Enable bit for COMPR0.          */
      __IOM uint32_t TMRB3IE1   : 1;            /*!< (@ 0x0000001A) Counter/Timer B3 Interrupt Enable bit for COMPR1.          */
      __IOM uint32_t TMRB3CLR   : 1;            /*!< (@ 0x0000001B) Counter/Timer B3 Clear bit.                                */
      __IOM uint32_t TMRB3POL   : 1;            /*!< (@ 0x0000001C) Counter/Timer B3 output polarity.                          */
      __IOM uint32_t TMRB3PE    : 1;            /*!< (@ 0x0000001D) Counter/Timer B3 Output Enable bit.                        */
      __IM  uint32_t            : 1;
      __IOM uint32_t CTLINK3    : 1;            /*!< (@ 0x0000001F) Counter/Timer A3/B3 Link bit.                              */
    } CTRL3_b;
  } ;
  __IM  uint32_t  RESERVED[48];
  
  union {
    __IOM uint32_t STCFG;                       /*!< (@ 0x00000100) Configuration Register                                     */
    
    struct {
      __IOM uint32_t CLKSEL     : 4;            /*!< (@ 0x00000000) Selects an appropriate clock source and divider
                                                                    to use for the System Timer clock.                         */
      __IM  uint32_t            : 4;
      __IOM uint32_t COMPARE_A_EN : 1;          /*!< (@ 0x00000008) Selects whether compare is enabled for the corresponding
                                                                    SCMPR register. If compare is enabled,
                                                                    the interrupt status is set once the comparision
                                                                    is met.                                                    */
      __IOM uint32_t COMPARE_B_EN : 1;          /*!< (@ 0x00000009) Selects whether compare is enabled for the corresponding
                                                                    SCMPR register. If compare is enabled,
                                                                    the interrupt status is set once the comparision
                                                                    is met.                                                    */
      __IOM uint32_t COMPARE_C_EN : 1;          /*!< (@ 0x0000000A) Selects whether compare is enabled for the corresponding
                                                                    SCMPR register. If compare is enabled,
                                                                    the interrupt status is set once the comparision
                                                                    is met.                                                    */
      __IOM uint32_t COMPARE_D_EN : 1;          /*!< (@ 0x0000000B) Selects whether compare is enabled for the corresponding
                                                                    SCMPR register. If compare is enabled,
                                                                    the interrupt status is set once the comparision
                                                                    is met.                                                    */
      __IOM uint32_t COMPARE_E_EN : 1;          /*!< (@ 0x0000000C) Selects whether compare is enabled for the corresponding
                                                                    SCMPR register. If compare is enabled,
                                                                    the interrupt status is set once the comparision
                                                                    is met.                                                    */
      __IOM uint32_t COMPARE_F_EN : 1;          /*!< (@ 0x0000000D) Selects whether compare is enabled for the corresponding
                                                                    SCMPR register. If compare is enabled,
                                                                    the interrupt status is set once the comparision
                                                                    is met.                                                    */
      __IOM uint32_t COMPARE_G_EN : 1;          /*!< (@ 0x0000000E) Selects whether compare is enabled for the corresponding
                                                                    SCMPR register. If compare is enabled,
                                                                    the interrupt status is set once the comparision
                                                                    is met.                                                    */
      __IOM uint32_t COMPARE_H_EN : 1;          /*!< (@ 0x0000000F) Selects whether compare is enabled for the corresponding
                                                                    SCMPR register. If compare is enabled,
                                                                    the interrupt status is set once the comparision
                                                                    is met.                                                    */
      __IM  uint32_t            : 14;
      __IOM uint32_t CLEAR      : 1;            /*!< (@ 0x0000001E) Set this bit to one to clear the System Timer
                                                                    register. If this bit is set to '1', the
                                                                    system timer register will stay cleared.
                                                                    It needs to be set to '0' for the system
                                                                    timer to start running.                                    */
      __IOM uint32_t FREEZE     : 1;            /*!< (@ 0x0000001F) Set this bit to one to freeze the clock input
                                                                    to the COUNTER register. Once frozen, the
                                                                    value can be safely written from the MCU.
                                                                    Unfreeze to resume.                                        */
    } STCFG_b;
  } ;
  
  union {
    __IOM uint32_t STTMR;                       /*!< (@ 0x00000104) System Timer Count Register (Real Time Counter)            */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Value of the 32-bit counter as it ticks over.              */
    } STTMR_b;
  } ;
  
  union {
    __IOM uint32_t CAPTURE_CONTROL;             /*!< (@ 0x00000108) Capture Control Register                                   */
    
    struct {
      __IOM uint32_t CAPTURE_A  : 1;            /*!< (@ 0x00000000) Selects whether capture is enabled for the specified
                                                                    capture register.                                          */
      __IOM uint32_t CAPTURE_B  : 1;            /*!< (@ 0x00000001) Selects whether capture is enabled for the specified
                                                                    capture register.                                          */
      __IOM uint32_t CAPTURE_C  : 1;            /*!< (@ 0x00000002) Selects whether capture is enabled for the specified
                                                                    capture register.                                          */
      __IOM uint32_t CAPTURE_D  : 1;            /*!< (@ 0x00000003) Selects whether capture is enabled for the specified
                                                                    capture register.                                          */
    } CAPTURE_CONTROL_b;
  } ;
  __IM  uint32_t  RESERVED1;
  
  union {
    __IOM uint32_t SCMPR0;                      /*!< (@ 0x00000110) Compare Register A                                         */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Compare this value to the value in the COUNTER
                                                                    register according to the match criterion,
                                                                    as selected in the COMPARE_A_EN bit in
                                                                    the REG_CTIMER_STCGF register.                             */
    } SCMPR0_b;
  } ;
  
  union {
    __IOM uint32_t SCMPR1;                      /*!< (@ 0x00000114) Compare Register B                                         */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Compare this value to the value in the COUNTER
                                                                    register according to the match criterion,
                                                                    as selected in the COMPARE_B_EN bit in
                                                                    the REG_CTIMER_STCGF register.                             */
    } SCMPR1_b;
  } ;
  
  union {
    __IOM uint32_t SCMPR2;                      /*!< (@ 0x00000118) Compare Register C                                         */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Compare this value to the value in the COUNTER
                                                                    register according to the match criterion,
                                                                    as selected in the COMPARE_C_EN bit in
                                                                    the REG_CTIMER_STCGF register.                             */
    } SCMPR2_b;
  } ;
  
  union {
    __IOM uint32_t SCMPR3;                      /*!< (@ 0x0000011C) Compare Register D                                         */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Compare this value to the value in the COUNTER
                                                                    register according to the match criterion,
                                                                    as selected in the COMPARE_D_EN bit in
                                                                    the REG_CTIMER_STCGF register.                             */
    } SCMPR3_b;
  } ;
  
  union {
    __IOM uint32_t SCMPR4;                      /*!< (@ 0x00000120) Compare Register E                                         */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Compare this value to the value in the COUNTER
                                                                    register according to the match criterion,
                                                                    as selected in the COMPARE_E_EN bit in
                                                                    the REG_CTIMER_STCGF register.                             */
    } SCMPR4_b;
  } ;
  
  union {
    __IOM uint32_t SCMPR5;                      /*!< (@ 0x00000124) Compare Register F                                         */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Compare this value to the value in the COUNTER
                                                                    register according to the match criterion,
                                                                    as selected in the COMPARE_F_EN bit in
                                                                    the REG_CTIMER_STCGF register.                             */
    } SCMPR5_b;
  } ;
  
  union {
    __IOM uint32_t SCMPR6;                      /*!< (@ 0x00000128) Compare Register G                                         */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Compare this value to the value in the COUNTER
                                                                    register according to the match criterion,
                                                                    as selected in the COMPARE_G_EN bit in
                                                                    the REG_CTIMER_STCGF register.                             */
    } SCMPR6_b;
  } ;
  
  union {
    __IOM uint32_t SCMPR7;                      /*!< (@ 0x0000012C) Compare Register H                                         */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Compare this value to the value in the COUNTER
                                                                    register according to the match criterion,
                                                                    as selected in the COMPARE_H_EN bit in
                                                                    the REG_CTIMER_STCGF register.                             */
    } SCMPR7_b;
  } ;
  __IM  uint32_t  RESERVED2[44];
  
  union {
    __IOM uint32_t SCAPT0;                      /*!< (@ 0x000001E0) Capture Register A                                         */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Whenever the event is detected, the value in
                                                                    the COUNTER is copied into this register
                                                                    and the corresponding interrupt status
                                                                    bit is set.                                                */
    } SCAPT0_b;
  } ;
  
  union {
    __IOM uint32_t SCAPT1;                      /*!< (@ 0x000001E4) Capture Register B                                         */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Whenever the event is detected, the value in
                                                                    the COUNTER is copied into this register
                                                                    and the corresponding interrupt status
                                                                    bit is set.                                                */
    } SCAPT1_b;
  } ;
  
  union {
    __IOM uint32_t SCAPT2;                      /*!< (@ 0x000001E8) Capture Register C                                         */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Whenever the event is detected, the value in
                                                                    the COUNTER is copied into this register
                                                                    and the corresponding interrupt status
                                                                    bit is set.                                                */
    } SCAPT2_b;
  } ;
  
  union {
    __IOM uint32_t SCAPT3;                      /*!< (@ 0x000001EC) Capture Register D                                         */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Whenever the event is detected, the value in
                                                                    the COUNTER is copied into this register
                                                                    and the corresponding interrupt status
                                                                    bit is set.                                                */
    } SCAPT3_b;
  } ;
  
  union {
    __IOM uint32_t SNVR0;                       /*!< (@ 0x000001F0) System Timer NVRAM_A Register                              */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Value of the 32-bit counter as it ticks over.              */
    } SNVR0_b;
  } ;
  
  union {
    __IOM uint32_t SNVR1;                       /*!< (@ 0x000001F4) System Timer NVRAM_B Register                              */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Value of the 32-bit counter as it ticks over.              */
    } SNVR1_b;
  } ;
  
  union {
    __IOM uint32_t SNVR2;                       /*!< (@ 0x000001F8) System Timer NVRAM_C Register                              */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Value of the 32-bit counter as it ticks over.              */
    } SNVR2_b;
  } ;
  __IM  uint32_t  RESERVED3;
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Counter/Timer Interrupts: Enable                           */
    
    struct {
      __IOM uint32_t CTMRA0C0INT : 1;           /*!< (@ 0x00000000) Counter/Timer A0 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRB0C0INT : 1;           /*!< (@ 0x00000001) Counter/Timer B0 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRA1C0INT : 1;           /*!< (@ 0x00000002) Counter/Timer A1 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRB1C0INT : 1;           /*!< (@ 0x00000003) Counter/Timer B1 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRA2C0INT : 1;           /*!< (@ 0x00000004) Counter/Timer A2 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRB2C0INT : 1;           /*!< (@ 0x00000005) Counter/Timer B2 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRA3C0INT : 1;           /*!< (@ 0x00000006) Counter/Timer A3 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRB3C0INT : 1;           /*!< (@ 0x00000007) Counter/Timer B3 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRA0C1INT : 1;           /*!< (@ 0x00000008) Counter/Timer A0 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRB0C1INT : 1;           /*!< (@ 0x00000009) Counter/Timer B0 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRA1C1INT : 1;           /*!< (@ 0x0000000A) Counter/Timer A1 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRB1C1INT : 1;           /*!< (@ 0x0000000B) Counter/Timer B1 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRA2C1INT : 1;           /*!< (@ 0x0000000C) Counter/Timer A2 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRB2C1INT : 1;           /*!< (@ 0x0000000D) Counter/Timer B2 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRA3C1INT : 1;           /*!< (@ 0x0000000E) Counter/Timer A3 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRB3C1INT : 1;           /*!< (@ 0x0000000F) Counter/Timer B3 interrupt based on COMPR1.                */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Counter/Timer Interrupts: Status                           */
    
    struct {
      __IOM uint32_t CTMRA0C0INT : 1;           /*!< (@ 0x00000000) Counter/Timer A0 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRB0C0INT : 1;           /*!< (@ 0x00000001) Counter/Timer B0 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRA1C0INT : 1;           /*!< (@ 0x00000002) Counter/Timer A1 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRB1C0INT : 1;           /*!< (@ 0x00000003) Counter/Timer B1 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRA2C0INT : 1;           /*!< (@ 0x00000004) Counter/Timer A2 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRB2C0INT : 1;           /*!< (@ 0x00000005) Counter/Timer B2 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRA3C0INT : 1;           /*!< (@ 0x00000006) Counter/Timer A3 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRB3C0INT : 1;           /*!< (@ 0x00000007) Counter/Timer B3 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRA0C1INT : 1;           /*!< (@ 0x00000008) Counter/Timer A0 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRB0C1INT : 1;           /*!< (@ 0x00000009) Counter/Timer B0 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRA1C1INT : 1;           /*!< (@ 0x0000000A) Counter/Timer A1 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRB1C1INT : 1;           /*!< (@ 0x0000000B) Counter/Timer B1 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRA2C1INT : 1;           /*!< (@ 0x0000000C) Counter/Timer A2 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRB2C1INT : 1;           /*!< (@ 0x0000000D) Counter/Timer B2 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRA3C1INT : 1;           /*!< (@ 0x0000000E) Counter/Timer A3 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRB3C1INT : 1;           /*!< (@ 0x0000000F) Counter/Timer B3 interrupt based on COMPR1.                */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Counter/Timer Interrupts: Clear                            */
    
    struct {
      __IOM uint32_t CTMRA0C0INT : 1;           /*!< (@ 0x00000000) Counter/Timer A0 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRB0C0INT : 1;           /*!< (@ 0x00000001) Counter/Timer B0 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRA1C0INT : 1;           /*!< (@ 0x00000002) Counter/Timer A1 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRB1C0INT : 1;           /*!< (@ 0x00000003) Counter/Timer B1 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRA2C0INT : 1;           /*!< (@ 0x00000004) Counter/Timer A2 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRB2C0INT : 1;           /*!< (@ 0x00000005) Counter/Timer B2 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRA3C0INT : 1;           /*!< (@ 0x00000006) Counter/Timer A3 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRB3C0INT : 1;           /*!< (@ 0x00000007) Counter/Timer B3 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRA0C1INT : 1;           /*!< (@ 0x00000008) Counter/Timer A0 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRB0C1INT : 1;           /*!< (@ 0x00000009) Counter/Timer B0 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRA1C1INT : 1;           /*!< (@ 0x0000000A) Counter/Timer A1 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRB1C1INT : 1;           /*!< (@ 0x0000000B) Counter/Timer B1 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRA2C1INT : 1;           /*!< (@ 0x0000000C) Counter/Timer A2 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRB2C1INT : 1;           /*!< (@ 0x0000000D) Counter/Timer B2 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRA3C1INT : 1;           /*!< (@ 0x0000000E) Counter/Timer A3 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRB3C1INT : 1;           /*!< (@ 0x0000000F) Counter/Timer B3 interrupt based on COMPR1.                */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Counter/Timer Interrupts: Set                              */
    
    struct {
      __IOM uint32_t CTMRA0C0INT : 1;           /*!< (@ 0x00000000) Counter/Timer A0 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRB0C0INT : 1;           /*!< (@ 0x00000001) Counter/Timer B0 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRA1C0INT : 1;           /*!< (@ 0x00000002) Counter/Timer A1 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRB1C0INT : 1;           /*!< (@ 0x00000003) Counter/Timer B1 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRA2C0INT : 1;           /*!< (@ 0x00000004) Counter/Timer A2 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRB2C0INT : 1;           /*!< (@ 0x00000005) Counter/Timer B2 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRA3C0INT : 1;           /*!< (@ 0x00000006) Counter/Timer A3 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRB3C0INT : 1;           /*!< (@ 0x00000007) Counter/Timer B3 interrupt based on COMPR0.                */
      __IOM uint32_t CTMRA0C1INT : 1;           /*!< (@ 0x00000008) Counter/Timer A0 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRB0C1INT : 1;           /*!< (@ 0x00000009) Counter/Timer B0 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRA1C1INT : 1;           /*!< (@ 0x0000000A) Counter/Timer A1 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRB1C1INT : 1;           /*!< (@ 0x0000000B) Counter/Timer B1 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRA2C1INT : 1;           /*!< (@ 0x0000000C) Counter/Timer A2 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRB2C1INT : 1;           /*!< (@ 0x0000000D) Counter/Timer B2 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRA3C1INT : 1;           /*!< (@ 0x0000000E) Counter/Timer A3 interrupt based on COMPR1.                */
      __IOM uint32_t CTMRB3C1INT : 1;           /*!< (@ 0x0000000F) Counter/Timer B3 interrupt based on COMPR1.                */
    } INTSET_b;
  } ;
  __IM  uint32_t  RESERVED4[60];
  
  union {
    __IOM uint32_t STMINTEN;                    /*!< (@ 0x00000300) STIMER Interrupt registers: Enable                         */
    
    struct {
      __IOM uint32_t COMPAREA   : 1;            /*!< (@ 0x00000000) COUNTER is greater than or equal to COMPARE register
                                                                    A.                                                         */
      __IOM uint32_t COMPAREB   : 1;            /*!< (@ 0x00000001) COUNTER is greater than or equal to COMPARE register
                                                                    B.                                                         */
      __IOM uint32_t COMPAREC   : 1;            /*!< (@ 0x00000002) COUNTER is greater than or equal to COMPARE register
                                                                    C.                                                         */
      __IOM uint32_t COMPARED   : 1;            /*!< (@ 0x00000003) COUNTER is greater than or equal to COMPARE register
                                                                    D.                                                         */
      __IOM uint32_t COMPAREE   : 1;            /*!< (@ 0x00000004) COUNTER is greater than or equal to COMPARE register
                                                                    E.                                                         */
      __IOM uint32_t COMPAREF   : 1;            /*!< (@ 0x00000005) COUNTER is greater than or equal to COMPARE register
                                                                    F.                                                         */
      __IOM uint32_t COMPAREG   : 1;            /*!< (@ 0x00000006) COUNTER is greater than or equal to COMPARE register
                                                                    G.                                                         */
      __IOM uint32_t COMPAREH   : 1;            /*!< (@ 0x00000007) COUNTER is greater than or equal to COMPARE register
                                                                    H.                                                         */
      __IOM uint32_t OVERFLOW   : 1;            /*!< (@ 0x00000008) COUNTER over flowed from 0xFFFFFFFF back to 0x00000000.    */
      __IOM uint32_t CAPTUREA   : 1;            /*!< (@ 0x00000009) CAPTURE register A has grabbed the value in the
                                                                    counter                                                    */
      __IOM uint32_t CAPTUREB   : 1;            /*!< (@ 0x0000000A) CAPTURE register B has grabbed the value in the
                                                                    counter                                                    */
      __IOM uint32_t CAPTUREC   : 1;            /*!< (@ 0x0000000B) CAPTURE register C has grabbed the value in the
                                                                    counter                                                    */
      __IOM uint32_t CAPTURED   : 1;            /*!< (@ 0x0000000C) CAPTURE register D has grabbed the value in the
                                                                    counter                                                    */
    } STMINTEN_b;
  } ;
  
  union {
    __IOM uint32_t STMINTSTAT;                  /*!< (@ 0x00000304) STIMER Interrupt registers: Status                         */
    
    struct {
      __IOM uint32_t COMPAREA   : 1;            /*!< (@ 0x00000000) COUNTER is greater than or equal to COMPARE register
                                                                    A.                                                         */
      __IOM uint32_t COMPAREB   : 1;            /*!< (@ 0x00000001) COUNTER is greater than or equal to COMPARE register
                                                                    B.                                                         */
      __IOM uint32_t COMPAREC   : 1;            /*!< (@ 0x00000002) COUNTER is greater than or equal to COMPARE register
                                                                    C.                                                         */
      __IOM uint32_t COMPARED   : 1;            /*!< (@ 0x00000003) COUNTER is greater than or equal to COMPARE register
                                                                    D.                                                         */
      __IOM uint32_t COMPAREE   : 1;            /*!< (@ 0x00000004) COUNTER is greater than or equal to COMPARE register
                                                                    E.                                                         */
      __IOM uint32_t COMPAREF   : 1;            /*!< (@ 0x00000005) COUNTER is greater than or equal to COMPARE register
                                                                    F.                                                         */
      __IOM uint32_t COMPAREG   : 1;            /*!< (@ 0x00000006) COUNTER is greater than or equal to COMPARE register
                                                                    G.                                                         */
      __IOM uint32_t COMPAREH   : 1;            /*!< (@ 0x00000007) COUNTER is greater than or equal to COMPARE register
                                                                    H.                                                         */
      __IOM uint32_t OVERFLOW   : 1;            /*!< (@ 0x00000008) COUNTER over flowed from 0xFFFFFFFF back to 0x00000000.    */
      __IOM uint32_t CAPTUREA   : 1;            /*!< (@ 0x00000009) CAPTURE register A has grabbed the value in the
                                                                    counter                                                    */
      __IOM uint32_t CAPTUREB   : 1;            /*!< (@ 0x0000000A) CAPTURE register B has grabbed the value in the
                                                                    counter                                                    */
      __IOM uint32_t CAPTUREC   : 1;            /*!< (@ 0x0000000B) CAPTURE register C has grabbed the value in the
                                                                    counter                                                    */
      __IOM uint32_t CAPTURED   : 1;            /*!< (@ 0x0000000C) CAPTURE register D has grabbed the value in the
                                                                    counter                                                    */
    } STMINTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t STMINTCLR;                   /*!< (@ 0x00000308) STIMER Interrupt registers: Clear                          */
    
    struct {
      __IOM uint32_t COMPAREA   : 1;            /*!< (@ 0x00000000) COUNTER is greater than or equal to COMPARE register
                                                                    A.                                                         */
      __IOM uint32_t COMPAREB   : 1;            /*!< (@ 0x00000001) COUNTER is greater than or equal to COMPARE register
                                                                    B.                                                         */
      __IOM uint32_t COMPAREC   : 1;            /*!< (@ 0x00000002) COUNTER is greater than or equal to COMPARE register
                                                                    C.                                                         */
      __IOM uint32_t COMPARED   : 1;            /*!< (@ 0x00000003) COUNTER is greater than or equal to COMPARE register
                                                                    D.                                                         */
      __IOM uint32_t COMPAREE   : 1;            /*!< (@ 0x00000004) COUNTER is greater than or equal to COMPARE register
                                                                    E.                                                         */
      __IOM uint32_t COMPAREF   : 1;            /*!< (@ 0x00000005) COUNTER is greater than or equal to COMPARE register
                                                                    F.                                                         */
      __IOM uint32_t COMPAREG   : 1;            /*!< (@ 0x00000006) COUNTER is greater than or equal to COMPARE register
                                                                    G.                                                         */
      __IOM uint32_t COMPAREH   : 1;            /*!< (@ 0x00000007) COUNTER is greater than or equal to COMPARE register
                                                                    H.                                                         */
      __IOM uint32_t OVERFLOW   : 1;            /*!< (@ 0x00000008) COUNTER over flowed from 0xFFFFFFFF back to 0x00000000.    */
      __IOM uint32_t CAPTUREA   : 1;            /*!< (@ 0x00000009) CAPTURE register A has grabbed the value in the
                                                                    counter                                                    */
      __IOM uint32_t CAPTUREB   : 1;            /*!< (@ 0x0000000A) CAPTURE register B has grabbed the value in the
                                                                    counter                                                    */
      __IOM uint32_t CAPTUREC   : 1;            /*!< (@ 0x0000000B) CAPTURE register C has grabbed the value in the
                                                                    counter                                                    */
      __IOM uint32_t CAPTURED   : 1;            /*!< (@ 0x0000000C) CAPTURE register D has grabbed the value in the
                                                                    counter                                                    */
    } STMINTCLR_b;
  } ;
  
  union {
    __IOM uint32_t STMINTSET;                   /*!< (@ 0x0000030C) STIMER Interrupt registers: Set                            */
    
    struct {
      __IOM uint32_t COMPAREA   : 1;            /*!< (@ 0x00000000) COUNTER is greater than or equal to COMPARE register
                                                                    A.                                                         */
      __IOM uint32_t COMPAREB   : 1;            /*!< (@ 0x00000001) COUNTER is greater than or equal to COMPARE register
                                                                    B.                                                         */
      __IOM uint32_t COMPAREC   : 1;            /*!< (@ 0x00000002) COUNTER is greater than or equal to COMPARE register
                                                                    C.                                                         */
      __IOM uint32_t COMPARED   : 1;            /*!< (@ 0x00000003) COUNTER is greater than or equal to COMPARE register
                                                                    D.                                                         */
      __IOM uint32_t COMPAREE   : 1;            /*!< (@ 0x00000004) COUNTER is greater than or equal to COMPARE register
                                                                    E.                                                         */
      __IOM uint32_t COMPAREF   : 1;            /*!< (@ 0x00000005) COUNTER is greater than or equal to COMPARE register
                                                                    F.                                                         */
      __IOM uint32_t COMPAREG   : 1;            /*!< (@ 0x00000006) COUNTER is greater than or equal to COMPARE register
                                                                    G.                                                         */
      __IOM uint32_t COMPAREH   : 1;            /*!< (@ 0x00000007) COUNTER is greater than or equal to COMPARE register
                                                                    H.                                                         */
      __IOM uint32_t OVERFLOW   : 1;            /*!< (@ 0x00000008) COUNTER over flowed from 0xFFFFFFFF back to 0x00000000.    */
      __IOM uint32_t CAPTUREA   : 1;            /*!< (@ 0x00000009) CAPTURE register A has grabbed the value in the
                                                                    counter                                                    */
      __IOM uint32_t CAPTUREB   : 1;            /*!< (@ 0x0000000A) CAPTURE register B has grabbed the value in the
                                                                    counter                                                    */
      __IOM uint32_t CAPTUREC   : 1;            /*!< (@ 0x0000000B) CAPTURE register C has grabbed the value in the
                                                                    counter                                                    */
      __IOM uint32_t CAPTURED   : 1;            /*!< (@ 0x0000000C) CAPTURE register D has grabbed the value in the
                                                                    counter                                                    */
    } STMINTSET_b;
  } ;
} CTIMER_Type;                                  /*!< Size = 784 (0x310)                                                        */



/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose IO (GPIO)
  */

typedef struct {                                /*!< (@ 0x40010000) GPIO Structure                                             */
  
  union {
    __IOM uint32_t PADREGA;                     /*!< (@ 0x00000000) Pad Configuration Register A                               */
    
    struct {
      __IOM uint32_t PAD0PULL   : 1;            /*!< (@ 0x00000000) Pad 0 pullup enable                                        */
      __IOM uint32_t PAD0INPEN  : 1;            /*!< (@ 0x00000001) Pad 0 input enable                                         */
      __IOM uint32_t PAD0STRNG  : 1;            /*!< (@ 0x00000002) Pad 0 drive strength                                       */
      __IOM uint32_t PAD0FNCSEL : 3;            /*!< (@ 0x00000003) Pad 0 function select                                      */
      __IOM uint32_t PAD0RSEL   : 2;            /*!< (@ 0x00000006) Pad 0 pullup resistor selection.                           */
      __IOM uint32_t PAD1PULL   : 1;            /*!< (@ 0x00000008) Pad 1 pullup enable                                        */
      __IOM uint32_t PAD1INPEN  : 1;            /*!< (@ 0x00000009) Pad 1 input enable                                         */
      __IOM uint32_t PAD1STRNG  : 1;            /*!< (@ 0x0000000A) Pad 1 drive strength                                       */
      __IOM uint32_t PAD1FNCSEL : 3;            /*!< (@ 0x0000000B) Pad 1 function select                                      */
      __IOM uint32_t PAD1RSEL   : 2;            /*!< (@ 0x0000000E) Pad 1 pullup resistor selection.                           */
      __IOM uint32_t PAD2PULL   : 1;            /*!< (@ 0x00000010) Pad 2 pullup enable                                        */
      __IOM uint32_t PAD2INPEN  : 1;            /*!< (@ 0x00000011) Pad 2 input enable                                         */
      __IOM uint32_t PAD2STRNG  : 1;            /*!< (@ 0x00000012) Pad 2 drive strength                                       */
      __IOM uint32_t PAD2FNCSEL : 3;            /*!< (@ 0x00000013) Pad 2 function select                                      */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD3PULL   : 1;            /*!< (@ 0x00000018) Pad 3 pullup enable                                        */
      __IOM uint32_t PAD3INPEN  : 1;            /*!< (@ 0x00000019) Pad 3 input enable.                                        */
      __IOM uint32_t PAD3STRNG  : 1;            /*!< (@ 0x0000001A) Pad 3 drive strength.                                      */
      __IOM uint32_t PAD3FNCSEL : 3;            /*!< (@ 0x0000001B) Pad 3 function select                                      */
    } PADREGA_b;
  } ;
  
  union {
    __IOM uint32_t PADREGB;                     /*!< (@ 0x00000004) Pad Configuration Register B                               */
    
    struct {
      __IOM uint32_t PAD4PULL   : 1;            /*!< (@ 0x00000000) Pad 4 pullup enable                                        */
      __IOM uint32_t PAD4INPEN  : 1;            /*!< (@ 0x00000001) Pad 4 input enable                                         */
      __IOM uint32_t PAD4STRNG  : 1;            /*!< (@ 0x00000002) Pad 4 drive strength                                       */
      __IOM uint32_t PAD4FNCSEL : 3;            /*!< (@ 0x00000003) Pad 4 function select                                      */
      __IM  uint32_t            : 1;
      __IOM uint32_t PAD4PWRDN  : 1;            /*!< (@ 0x00000007) Pad 4 VSS power switch enable                              */
      __IOM uint32_t PAD5PULL   : 1;            /*!< (@ 0x00000008) Pad 5 pullup enable                                        */
      __IOM uint32_t PAD5INPEN  : 1;            /*!< (@ 0x00000009) Pad 5 input enable                                         */
      __IOM uint32_t PAD5STRNG  : 1;            /*!< (@ 0x0000000A) Pad 5 drive strength                                       */
      __IOM uint32_t PAD5FNCSEL : 3;            /*!< (@ 0x0000000B) Pad 5 function select                                      */
      __IOM uint32_t PAD5RSEL   : 2;            /*!< (@ 0x0000000E) Pad 5 pullup resistor selection.                           */
      __IOM uint32_t PAD6PULL   : 1;            /*!< (@ 0x00000010) Pad 6 pullup enable                                        */
      __IOM uint32_t PAD6INPEN  : 1;            /*!< (@ 0x00000011) Pad 6 input enable                                         */
      __IOM uint32_t PAD6STRNG  : 1;            /*!< (@ 0x00000012) Pad 6 drive strength                                       */
      __IOM uint32_t PAD6FNCSEL : 3;            /*!< (@ 0x00000013) Pad 6 function select                                      */
      __IOM uint32_t PAD6RSEL   : 2;            /*!< (@ 0x00000016) Pad 6 pullup resistor selection.                           */
      __IOM uint32_t PAD7PULL   : 1;            /*!< (@ 0x00000018) Pad 7 pullup enable                                        */
      __IOM uint32_t PAD7INPEN  : 1;            /*!< (@ 0x00000019) Pad 7 input enable                                         */
      __IOM uint32_t PAD7STRNG  : 1;            /*!< (@ 0x0000001A) Pad 7 drive strentgh                                       */
      __IOM uint32_t PAD7FNCSEL : 3;            /*!< (@ 0x0000001B) Pad 7 function select                                      */
    } PADREGB_b;
  } ;
  
  union {
    __IOM uint32_t PADREGC;                     /*!< (@ 0x00000008) Pad Configuration Register C                               */
    
    struct {
      __IOM uint32_t PAD8PULL   : 1;            /*!< (@ 0x00000000) Pad 8 pullup enable                                        */
      __IOM uint32_t PAD8INPEN  : 1;            /*!< (@ 0x00000001) Pad 8 input enable                                         */
      __IOM uint32_t PAD8STRNG  : 1;            /*!< (@ 0x00000002) Pad 8 drive strength                                       */
      __IOM uint32_t PAD8FNCSEL : 3;            /*!< (@ 0x00000003) Pad 8 function select                                      */
      __IOM uint32_t PAD8RSEL   : 2;            /*!< (@ 0x00000006) Pad 8 pullup resistor selection.                           */
      __IOM uint32_t PAD9PULL   : 1;            /*!< (@ 0x00000008) Pad 9 pullup enable                                        */
      __IOM uint32_t PAD9INPEN  : 1;            /*!< (@ 0x00000009) Pad 9 input enable                                         */
      __IOM uint32_t PAD9STRNG  : 1;            /*!< (@ 0x0000000A) Pad 9 drive strength                                       */
      __IOM uint32_t PAD9FNCSEL : 3;            /*!< (@ 0x0000000B) Pad 9 function select                                      */
      __IOM uint32_t PAD9RSEL   : 2;            /*!< (@ 0x0000000E) Pad 9 pullup resistor selection                            */
      __IOM uint32_t PAD10PULL  : 1;            /*!< (@ 0x00000010) Pad 10 pullup enable                                       */
      __IOM uint32_t PAD10INPEN : 1;            /*!< (@ 0x00000011) Pad 10 input enable                                        */
      __IOM uint32_t PAD10STRNG : 1;            /*!< (@ 0x00000012) Pad 10 drive strength                                      */
      __IOM uint32_t PAD10FNCSEL : 3;           /*!< (@ 0x00000013) Pad 10 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD11PULL  : 1;            /*!< (@ 0x00000018) Pad 11 pullup enable                                       */
      __IOM uint32_t PAD11INPEN : 1;            /*!< (@ 0x00000019) Pad 11 input enable                                        */
      __IOM uint32_t PAD11STRNG : 1;            /*!< (@ 0x0000001A) Pad 11 drive strentgh                                      */
      __IOM uint32_t PAD11FNCSEL : 3;           /*!< (@ 0x0000001B) Pad 11 function select                                     */
    } PADREGC_b;
  } ;
  
  union {
    __IOM uint32_t PADREGD;                     /*!< (@ 0x0000000C) Pad Configuration Register D                               */
    
    struct {
      __IOM uint32_t PAD12PULL  : 1;            /*!< (@ 0x00000000) Pad 12 pullup enable                                       */
      __IOM uint32_t PAD12INPEN : 1;            /*!< (@ 0x00000001) Pad 12 input enable                                        */
      __IOM uint32_t PAD12STRNG : 1;            /*!< (@ 0x00000002) Pad 12 drive strength                                      */
      __IOM uint32_t PAD12FNCSEL : 3;           /*!< (@ 0x00000003) Pad 12 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD13PULL  : 1;            /*!< (@ 0x00000008) Pad 13 pullup enable                                       */
      __IOM uint32_t PAD13INPEN : 1;            /*!< (@ 0x00000009) Pad 13 input enable                                        */
      __IOM uint32_t PAD13STRNG : 1;            /*!< (@ 0x0000000A) Pad 13 drive strength                                      */
      __IOM uint32_t PAD13FNCSEL : 3;           /*!< (@ 0x0000000B) Pad 13 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD14PULL  : 1;            /*!< (@ 0x00000010) Pad 14 pullup enable                                       */
      __IOM uint32_t PAD14INPEN : 1;            /*!< (@ 0x00000011) Pad 14 input enable                                        */
      __IOM uint32_t PAD14STRNG : 1;            /*!< (@ 0x00000012) Pad 14 drive strength                                      */
      __IOM uint32_t PAD14FNCSEL : 3;           /*!< (@ 0x00000013) Pad 14 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD15PULL  : 1;            /*!< (@ 0x00000018) Pad 15 pullup enable                                       */
      __IOM uint32_t PAD15INPEN : 1;            /*!< (@ 0x00000019) Pad 15 input enable                                        */
      __IOM uint32_t PAD15STRNG : 1;            /*!< (@ 0x0000001A) Pad 15 drive strentgh                                      */
      __IOM uint32_t PAD15FNCSEL : 3;           /*!< (@ 0x0000001B) Pad 15 function select                                     */
    } PADREGD_b;
  } ;
  
  union {
    __IOM uint32_t PADREGE;                     /*!< (@ 0x00000010) Pad Configuration Register E                               */
    
    struct {
      __IOM uint32_t PAD16PULL  : 1;            /*!< (@ 0x00000000) Pad 16 pullup enable                                       */
      __IOM uint32_t PAD16INPEN : 1;            /*!< (@ 0x00000001) Pad 16 input enable                                        */
      __IOM uint32_t PAD16STRNG : 1;            /*!< (@ 0x00000002) Pad 16 drive strength                                      */
      __IOM uint32_t PAD16FNCSEL : 3;           /*!< (@ 0x00000003) Pad 16 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD17PULL  : 1;            /*!< (@ 0x00000008) Pad 17 pullup enable                                       */
      __IOM uint32_t PAD17INPEN : 1;            /*!< (@ 0x00000009) Pad 17 input enable                                        */
      __IOM uint32_t PAD17STRNG : 1;            /*!< (@ 0x0000000A) Pad 17 drive strength                                      */
      __IOM uint32_t PAD17FNCSEL : 3;           /*!< (@ 0x0000000B) Pad 17 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD18PULL  : 1;            /*!< (@ 0x00000010) Pad 18 pullup enable                                       */
      __IOM uint32_t PAD18INPEN : 1;            /*!< (@ 0x00000011) Pad 18 input enable                                        */
      __IOM uint32_t PAD18STRNG : 1;            /*!< (@ 0x00000012) Pad 18 drive strength                                      */
      __IOM uint32_t PAD18FNCSEL : 3;           /*!< (@ 0x00000013) Pad 18 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD19PULL  : 1;            /*!< (@ 0x00000018) Pad 19 pullup enable                                       */
      __IOM uint32_t PAD19INPEN : 1;            /*!< (@ 0x00000019) Pad 19 input enable                                        */
      __IOM uint32_t PAD19STRNG : 1;            /*!< (@ 0x0000001A) Pad 19 drive strentgh                                      */
      __IOM uint32_t PAD19FNCSEL : 3;           /*!< (@ 0x0000001B) Pad 19 function select                                     */
    } PADREGE_b;
  } ;
  
  union {
    __IOM uint32_t PADREGF;                     /*!< (@ 0x00000014) Pad Configuration Register F                               */
    
    struct {
      __IOM uint32_t PAD20PULL  : 1;            /*!< (@ 0x00000000) Pad 20 pulldown enable                                     */
      __IOM uint32_t PAD20INPEN : 1;            /*!< (@ 0x00000001) Pad 20 input enable                                        */
      __IOM uint32_t PAD20STRNG : 1;            /*!< (@ 0x00000002) Pad 20 drive strength                                      */
      __IOM uint32_t PAD20FNCSEL : 3;           /*!< (@ 0x00000003) Pad 20 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD21PULL  : 1;            /*!< (@ 0x00000008) Pad 21 pullup enable                                       */
      __IOM uint32_t PAD21INPEN : 1;            /*!< (@ 0x00000009) Pad 21 input enable                                        */
      __IOM uint32_t PAD21STRNG : 1;            /*!< (@ 0x0000000A) Pad 21 drive strength                                      */
      __IOM uint32_t PAD21FNCSEL : 3;           /*!< (@ 0x0000000B) Pad 21 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD22PULL  : 1;            /*!< (@ 0x00000010) Pad 22 pullup enable                                       */
      __IOM uint32_t PAD22INPEN : 1;            /*!< (@ 0x00000011) Pad 22 input enable                                        */
      __IOM uint32_t PAD22STRNG : 1;            /*!< (@ 0x00000012) Pad 22 drive strength                                      */
      __IOM uint32_t PAD22FNCSEL : 3;           /*!< (@ 0x00000013) Pad 22 function select                                     */
      __IM  uint32_t            : 1;
      __IOM uint32_t PAD22PWRUP : 1;            /*!< (@ 0x00000017) Pad 22 upper power switch enable                           */
      __IOM uint32_t PAD23PULL  : 1;            /*!< (@ 0x00000018) Pad 23 pullup enable                                       */
      __IOM uint32_t PAD23INPEN : 1;            /*!< (@ 0x00000019) Pad 23 input enable                                        */
      __IOM uint32_t PAD23STRNG : 1;            /*!< (@ 0x0000001A) Pad 23 drive strentgh                                      */
      __IOM uint32_t PAD23FNCSEL : 3;           /*!< (@ 0x0000001B) Pad 23 function select                                     */
    } PADREGF_b;
  } ;
  
  union {
    __IOM uint32_t PADREGG;                     /*!< (@ 0x00000018) Pad Configuration Register G                               */
    
    struct {
      __IOM uint32_t PAD24PULL  : 1;            /*!< (@ 0x00000000) Pad 24 pullup enable                                       */
      __IOM uint32_t PAD24INPEN : 1;            /*!< (@ 0x00000001) Pad 24 input enable                                        */
      __IOM uint32_t PAD24STRNG : 1;            /*!< (@ 0x00000002) Pad 24 drive strength                                      */
      __IOM uint32_t PAD24FNCSEL : 3;           /*!< (@ 0x00000003) Pad 24 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD25PULL  : 1;            /*!< (@ 0x00000008) Pad 25 pullup enable                                       */
      __IOM uint32_t PAD25INPEN : 1;            /*!< (@ 0x00000009) Pad 25 input enable                                        */
      __IOM uint32_t PAD25STRNG : 1;            /*!< (@ 0x0000000A) Pad 25 drive strength                                      */
      __IOM uint32_t PAD25FNCSEL : 3;           /*!< (@ 0x0000000B) Pad 25 function select                                     */
      __IOM uint32_t PAD25RSEL  : 2;            /*!< (@ 0x0000000E) Pad 25 pullup resistor selection.                          */
      __IOM uint32_t PAD26PULL  : 1;            /*!< (@ 0x00000010) Pad 26 pullup enable                                       */
      __IOM uint32_t PAD26INPEN : 1;            /*!< (@ 0x00000011) Pad 26 input enable                                        */
      __IOM uint32_t PAD26STRNG : 1;            /*!< (@ 0x00000012) Pad 26 drive strength                                      */
      __IOM uint32_t PAD26FNCSEL : 3;           /*!< (@ 0x00000013) Pad 26 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD27PULL  : 1;            /*!< (@ 0x00000018) Pad 27 pullup enable                                       */
      __IOM uint32_t PAD27INPEN : 1;            /*!< (@ 0x00000019) Pad 27 input enable                                        */
      __IOM uint32_t PAD27STRNG : 1;            /*!< (@ 0x0000001A) Pad 27 drive strentgh                                      */
      __IOM uint32_t PAD27FNCSEL : 3;           /*!< (@ 0x0000001B) Pad 27 function select                                     */
      __IOM uint32_t PAD27RSEL  : 2;            /*!< (@ 0x0000001E) Pad 27 pullup resistor selection.                          */
    } PADREGG_b;
  } ;
  
  union {
    __IOM uint32_t PADREGH;                     /*!< (@ 0x0000001C) Pad Configuration Register H                               */
    
    struct {
      __IOM uint32_t PAD28PULL  : 1;            /*!< (@ 0x00000000) Pad 28 pullup enable                                       */
      __IOM uint32_t PAD28INPEN : 1;            /*!< (@ 0x00000001) Pad 28 input enable                                        */
      __IOM uint32_t PAD28STRNG : 1;            /*!< (@ 0x00000002) Pad 28 drive strength                                      */
      __IOM uint32_t PAD28FNCSEL : 3;           /*!< (@ 0x00000003) Pad 28 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD29PULL  : 1;            /*!< (@ 0x00000008) Pad 29 pullup enable                                       */
      __IOM uint32_t PAD29INPEN : 1;            /*!< (@ 0x00000009) Pad 29 input enable                                        */
      __IOM uint32_t PAD29STRNG : 1;            /*!< (@ 0x0000000A) Pad 29 drive strength                                      */
      __IOM uint32_t PAD29FNCSEL : 3;           /*!< (@ 0x0000000B) Pad 29 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD30PULL  : 1;            /*!< (@ 0x00000010) Pad 30 pullup enable                                       */
      __IOM uint32_t PAD30INPEN : 1;            /*!< (@ 0x00000011) Pad 30 input enable                                        */
      __IOM uint32_t PAD30STRNG : 1;            /*!< (@ 0x00000012) Pad 30 drive strength                                      */
      __IOM uint32_t PAD30FNCSEL : 3;           /*!< (@ 0x00000013) Pad 30 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD31PULL  : 1;            /*!< (@ 0x00000018) Pad 31 pullup enable                                       */
      __IOM uint32_t PAD31INPEN : 1;            /*!< (@ 0x00000019) Pad 31 input enable                                        */
      __IOM uint32_t PAD31STRNG : 1;            /*!< (@ 0x0000001A) Pad 31 drive strentgh                                      */
      __IOM uint32_t PAD31FNCSEL : 3;           /*!< (@ 0x0000001B) Pad 31 function select                                     */
    } PADREGH_b;
  } ;
  
  union {
    __IOM uint32_t PADREGI;                     /*!< (@ 0x00000020) Pad Configuration Register I                               */
    
    struct {
      __IOM uint32_t PAD32PULL  : 1;            /*!< (@ 0x00000000) Pad 32 pullup enable                                       */
      __IOM uint32_t PAD32INPEN : 1;            /*!< (@ 0x00000001) Pad 32 input enable                                        */
      __IOM uint32_t PAD32STRNG : 1;            /*!< (@ 0x00000002) Pad 32 drive strength                                      */
      __IOM uint32_t PAD32FNCSEL : 3;           /*!< (@ 0x00000003) Pad 32 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD33PULL  : 1;            /*!< (@ 0x00000008) Pad 33 pullup enable                                       */
      __IOM uint32_t PAD33INPEN : 1;            /*!< (@ 0x00000009) Pad 33 input enable                                        */
      __IOM uint32_t PAD33STRNG : 1;            /*!< (@ 0x0000000A) Pad 33 drive strength                                      */
      __IOM uint32_t PAD33FNCSEL : 3;           /*!< (@ 0x0000000B) Pad 33 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD34PULL  : 1;            /*!< (@ 0x00000010) Pad 34 pullup enable                                       */
      __IOM uint32_t PAD34INPEN : 1;            /*!< (@ 0x00000011) Pad 34 input enable                                        */
      __IOM uint32_t PAD34STRNG : 1;            /*!< (@ 0x00000012) Pad 34 drive strength                                      */
      __IOM uint32_t PAD34FNCSEL : 3;           /*!< (@ 0x00000013) Pad 34 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD35PULL  : 1;            /*!< (@ 0x00000018) Pad 35 pullup enable                                       */
      __IOM uint32_t PAD35INPEN : 1;            /*!< (@ 0x00000019) Pad 35 input enable                                        */
      __IOM uint32_t PAD35STRNG : 1;            /*!< (@ 0x0000001A) Pad 35 drive strentgh                                      */
      __IOM uint32_t PAD35FNCSEL : 3;           /*!< (@ 0x0000001B) Pad 35 function select                                     */
    } PADREGI_b;
  } ;
  
  union {
    __IOM uint32_t PADREGJ;                     /*!< (@ 0x00000024) Pad Configuration Register J                               */
    
    struct {
      __IOM uint32_t PAD36PULL  : 1;            /*!< (@ 0x00000000) Pad 36 pullup enable                                       */
      __IOM uint32_t PAD36INPEN : 1;            /*!< (@ 0x00000001) Pad 36 input enable                                        */
      __IOM uint32_t PAD36STRNG : 1;            /*!< (@ 0x00000002) Pad 36 drive strength                                      */
      __IOM uint32_t PAD36FNCSEL : 3;           /*!< (@ 0x00000003) Pad 36 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD37PULL  : 1;            /*!< (@ 0x00000008) Pad 37 pullup enable                                       */
      __IOM uint32_t PAD37INPEN : 1;            /*!< (@ 0x00000009) Pad 37 input enable                                        */
      __IOM uint32_t PAD37STRNG : 1;            /*!< (@ 0x0000000A) Pad 37 drive strength                                      */
      __IOM uint32_t PAD37FNCSEL : 3;           /*!< (@ 0x0000000B) Pad 37 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD38PULL  : 1;            /*!< (@ 0x00000010) Pad 38 pullup enable                                       */
      __IOM uint32_t PAD38INPEN : 1;            /*!< (@ 0x00000011) Pad 38 input enable                                        */
      __IOM uint32_t PAD38STRNG : 1;            /*!< (@ 0x00000012) Pad 38 drive strength                                      */
      __IOM uint32_t PAD38FNCSEL : 3;           /*!< (@ 0x00000013) Pad 38 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD39PULL  : 1;            /*!< (@ 0x00000018) Pad 39 pullup enable                                       */
      __IOM uint32_t PAD39INPEN : 1;            /*!< (@ 0x00000019) Pad 39 input enable                                        */
      __IOM uint32_t PAD39STRNG : 1;            /*!< (@ 0x0000001A) Pad 39 drive strentgh                                      */
      __IOM uint32_t PAD39FNCSEL : 3;           /*!< (@ 0x0000001B) Pad 39 function select                                     */
      __IOM uint32_t PAD39RSEL  : 2;            /*!< (@ 0x0000001E) Pad 39 pullup resistor selection.                          */
    } PADREGJ_b;
  } ;
  
  union {
    __IOM uint32_t PADREGK;                     /*!< (@ 0x00000028) Pad Configuration Register K                               */
    
    struct {
      __IOM uint32_t PAD40PULL  : 1;            /*!< (@ 0x00000000) Pad 40 pullup enable                                       */
      __IOM uint32_t PAD40INPEN : 1;            /*!< (@ 0x00000001) Pad 40 input enable                                        */
      __IOM uint32_t PAD40STRNG : 1;            /*!< (@ 0x00000002) Pad 40 drive strength                                      */
      __IOM uint32_t PAD40FNCSEL : 3;           /*!< (@ 0x00000003) Pad 40 function select                                     */
      __IOM uint32_t PAD40RSEL  : 2;            /*!< (@ 0x00000006) Pad 40 pullup resistor selection.                          */
      __IOM uint32_t PAD41PULL  : 1;            /*!< (@ 0x00000008) Pad 41 pullup enable                                       */
      __IOM uint32_t PAD41INPEN : 1;            /*!< (@ 0x00000009) Pad 41 input enable                                        */
      __IOM uint32_t PAD41STRNG : 1;            /*!< (@ 0x0000000A) Pad 41 drive strength                                      */
      __IOM uint32_t PAD41FNCSEL : 3;           /*!< (@ 0x0000000B) Pad 41 function select                                     */
      __IM  uint32_t            : 1;
      __IOM uint32_t PAD41PWRUP : 1;            /*!< (@ 0x0000000F) Pad 41 upper power switch enable                           */
      __IOM uint32_t PAD42PULL  : 1;            /*!< (@ 0x00000010) Pad 42 pullup enable                                       */
      __IOM uint32_t PAD42INPEN : 1;            /*!< (@ 0x00000011) Pad 42 input enable                                        */
      __IOM uint32_t PAD42STRNG : 1;            /*!< (@ 0x00000012) Pad 42 drive strength                                      */
      __IOM uint32_t PAD42FNCSEL : 3;           /*!< (@ 0x00000013) Pad 42 function select                                     */
      __IOM uint32_t PAD42RSEL  : 2;            /*!< (@ 0x00000016) Pad 42 pullup resistor selection.                          */
      __IOM uint32_t PAD43PULL  : 1;            /*!< (@ 0x00000018) Pad 43 pullup enable                                       */
      __IOM uint32_t PAD43INPEN : 1;            /*!< (@ 0x00000019) Pad 43 input enable                                        */
      __IOM uint32_t PAD43STRNG : 1;            /*!< (@ 0x0000001A) Pad 43 drive strentgh                                      */
      __IOM uint32_t PAD43FNCSEL : 3;           /*!< (@ 0x0000001B) Pad 43 function select                                     */
      __IOM uint32_t PAD43RSEL  : 2;            /*!< (@ 0x0000001E) Pad 43 pullup resistor selection.                          */
    } PADREGK_b;
  } ;
  
  union {
    __IOM uint32_t PADREGL;                     /*!< (@ 0x0000002C) Pad Configuration Register L                               */
    
    struct {
      __IOM uint32_t PAD44PULL  : 1;            /*!< (@ 0x00000000) Pad 44 pullup enable                                       */
      __IOM uint32_t PAD44INPEN : 1;            /*!< (@ 0x00000001) Pad 44 input enable                                        */
      __IOM uint32_t PAD44STRNG : 1;            /*!< (@ 0x00000002) Pad 44 drive strength                                      */
      __IOM uint32_t PAD44FNCSEL : 3;           /*!< (@ 0x00000003) Pad 44 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD45PULL  : 1;            /*!< (@ 0x00000008) Pad 45 pullup enable                                       */
      __IOM uint32_t PAD45INPEN : 1;            /*!< (@ 0x00000009) Pad 45 input enable                                        */
      __IOM uint32_t PAD45STRNG : 1;            /*!< (@ 0x0000000A) Pad 45 drive strength                                      */
      __IOM uint32_t PAD45FNCSEL : 3;           /*!< (@ 0x0000000B) Pad 45 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD46PULL  : 1;            /*!< (@ 0x00000010) Pad 46 pullup enable                                       */
      __IOM uint32_t PAD46INPEN : 1;            /*!< (@ 0x00000011) Pad 46 input enable                                        */
      __IOM uint32_t PAD46STRNG : 1;            /*!< (@ 0x00000012) Pad 46 drive strength                                      */
      __IOM uint32_t PAD46FNCSEL : 3;           /*!< (@ 0x00000013) Pad 46 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD47PULL  : 1;            /*!< (@ 0x00000018) Pad 47 pullup enable                                       */
      __IOM uint32_t PAD47INPEN : 1;            /*!< (@ 0x00000019) Pad 47 input enable                                        */
      __IOM uint32_t PAD47STRNG : 1;            /*!< (@ 0x0000001A) Pad 47 drive strentgh                                      */
      __IOM uint32_t PAD47FNCSEL : 3;           /*!< (@ 0x0000001B) Pad 47 function select                                     */
    } PADREGL_b;
  } ;
  
  union {
    __IOM uint32_t PADREGM;                     /*!< (@ 0x00000030) Pad Configuration Register M                               */
    
    struct {
      __IOM uint32_t PAD48PULL  : 1;            /*!< (@ 0x00000000) Pad 48 pullup enable                                       */
      __IOM uint32_t PAD48INPEN : 1;            /*!< (@ 0x00000001) Pad 48 input enable                                        */
      __IOM uint32_t PAD48STRNG : 1;            /*!< (@ 0x00000002) Pad 48 drive strength                                      */
      __IOM uint32_t PAD48FNCSEL : 3;           /*!< (@ 0x00000003) Pad 48 function select                                     */
      __IOM uint32_t PAD48RSEL  : 2;            /*!< (@ 0x00000006) Pad 48 pullup resistor selection.                          */
      __IOM uint32_t PAD49PULL  : 1;            /*!< (@ 0x00000008) Pad 49 pullup enable                                       */
      __IOM uint32_t PAD49INPEN : 1;            /*!< (@ 0x00000009) Pad 49 input enable                                        */
      __IOM uint32_t PAD49STRNG : 1;            /*!< (@ 0x0000000A) Pad 49 drive strength                                      */
      __IOM uint32_t PAD49FNCSEL : 3;           /*!< (@ 0x0000000B) Pad 49 function select                                     */
      __IOM uint32_t PAD49RSEL  : 2;            /*!< (@ 0x0000000E) Pad 49 pullup resistor selection.                          */
    } PADREGM_b;
  } ;
  __IM  uint32_t  RESERVED[3];
  
  union {
    __IOM uint32_t CFGA;                        /*!< (@ 0x00000040) GPIO Configuration Register A                              */
    
    struct {
      __IOM uint32_t GPIO0INCFG : 1;            /*!< (@ 0x00000000) GPIO0 input enable.                                        */
      __IOM uint32_t GPIO0OUTCFG : 2;           /*!< (@ 0x00000001) GPIO0 output configuration.                                */
      __IOM uint32_t GPIO0INTD  : 1;            /*!< (@ 0x00000003) GPIO0 interrupt direction.                                 */
      __IOM uint32_t GPIO1INCFG : 1;            /*!< (@ 0x00000004) GPIO1 input enable.                                        */
      __IOM uint32_t GPIO1OUTCFG : 2;           /*!< (@ 0x00000005) GPIO1 output configuration.                                */
      __IOM uint32_t GPIO1INTD  : 1;            /*!< (@ 0x00000007) GPIO1 interrupt direction.                                 */
      __IOM uint32_t GPIO2INCFG : 1;            /*!< (@ 0x00000008) GPIO2 input enable.                                        */
      __IOM uint32_t GPIO2OUTCFG : 2;           /*!< (@ 0x00000009) GPIO2 output configuration.                                */
      __IOM uint32_t GPIO2INTD  : 1;            /*!< (@ 0x0000000B) GPIO2 interrupt direction.                                 */
      __IOM uint32_t GPIO3INCFG : 1;            /*!< (@ 0x0000000C) GPIO3 input enable.                                        */
      __IOM uint32_t GPIO3OUTCFG : 2;           /*!< (@ 0x0000000D) GPIO3 output configuration.                                */
      __IOM uint32_t GPIO3INTD  : 1;            /*!< (@ 0x0000000F) GPIO3 interrupt direction.                                 */
      __IOM uint32_t GPIO4INCFG : 1;            /*!< (@ 0x00000010) GPIO4 input enable.                                        */
      __IOM uint32_t GPIO4OUTCFG : 2;           /*!< (@ 0x00000011) GPIO4 output configuration.                                */
      __IOM uint32_t GPIO4INTD  : 1;            /*!< (@ 0x00000013) GPIO4 interrupt direction.                                 */
      __IOM uint32_t GPIO5INCFG : 1;            /*!< (@ 0x00000014) GPIO5 input enable.                                        */
      __IOM uint32_t GPIO5OUTCFG : 2;           /*!< (@ 0x00000015) GPIO5 output configuration.                                */
      __IOM uint32_t GPIO5INTD  : 1;            /*!< (@ 0x00000017) GPIO5 interrupt direction.                                 */
      __IOM uint32_t GPIO6INCFG : 1;            /*!< (@ 0x00000018) GPIO6 input enable.                                        */
      __IOM uint32_t GPIO6OUTCFG : 2;           /*!< (@ 0x00000019) GPIO6 output configuration.                                */
      __IOM uint32_t GPIO6INTD  : 1;            /*!< (@ 0x0000001B) GPIO6 interrupt direction.                                 */
      __IOM uint32_t GPIO7INCFG : 1;            /*!< (@ 0x0000001C) GPIO7 input enable.                                        */
      __IOM uint32_t GPIO7OUTCFG : 2;           /*!< (@ 0x0000001D) GPIO7 output configuration.                                */
      __IOM uint32_t GPIO7INTD  : 1;            /*!< (@ 0x0000001F) GPIO7 interrupt direction.                                 */
    } CFGA_b;
  } ;
  
  union {
    __IOM uint32_t CFGB;                        /*!< (@ 0x00000044) GPIO Configuration Register B                              */
    
    struct {
      __IOM uint32_t GPIO8INCFG : 1;            /*!< (@ 0x00000000) GPIO8 input enable.                                        */
      __IOM uint32_t GPIO8OUTCFG : 2;           /*!< (@ 0x00000001) GPIO8 output configuration.                                */
      __IOM uint32_t GPIO8INTD  : 1;            /*!< (@ 0x00000003) GPIO8 interrupt direction.                                 */
      __IOM uint32_t GPIO9INCFG : 1;            /*!< (@ 0x00000004) GPIO9 input enable.                                        */
      __IOM uint32_t GPIO9OUTCFG : 2;           /*!< (@ 0x00000005) GPIO9 output configuration.                                */
      __IOM uint32_t GPIO9INTD  : 1;            /*!< (@ 0x00000007) GPIO9 interrupt direction.                                 */
      __IOM uint32_t GPIO10INCFG : 1;           /*!< (@ 0x00000008) GPIO10 input enable.                                       */
      __IOM uint32_t GPIO10OUTCFG : 2;          /*!< (@ 0x00000009) GPIO10 output configuration.                               */
      __IOM uint32_t GPIO10INTD : 1;            /*!< (@ 0x0000000B) GPIO10 interrupt direction.                                */
      __IOM uint32_t GPIO11INCFG : 1;           /*!< (@ 0x0000000C) GPIO11 input enable.                                       */
      __IOM uint32_t GPIO11OUTCFG : 2;          /*!< (@ 0x0000000D) GPIO11 output configuration.                               */
      __IOM uint32_t GPIO11INTD : 1;            /*!< (@ 0x0000000F) GPIO11 interrupt direction.                                */
      __IOM uint32_t GPIO12INCFG : 1;           /*!< (@ 0x00000010) GPIO12 input enable.                                       */
      __IOM uint32_t GPIO12OUTCFG : 2;          /*!< (@ 0x00000011) GPIO12 output configuration.                               */
      __IOM uint32_t GPIO12INTD : 1;            /*!< (@ 0x00000013) GPIO12 interrupt direction.                                */
      __IOM uint32_t GPIO13INCFG : 1;           /*!< (@ 0x00000014) GPIO13 input enable.                                       */
      __IOM uint32_t GPIO13OUTCFG : 2;          /*!< (@ 0x00000015) GPIO13 output configuration.                               */
      __IOM uint32_t GPIO13INTD : 1;            /*!< (@ 0x00000017) GPIO13 interrupt direction.                                */
      __IOM uint32_t GPIO14INCFG : 1;           /*!< (@ 0x00000018) GPIO14 input enable.                                       */
      __IOM uint32_t GPIO14OUTCFG : 2;          /*!< (@ 0x00000019) GPIO14 output configuration.                               */
      __IOM uint32_t GPIO14INTD : 1;            /*!< (@ 0x0000001B) GPIO14 interrupt direction.                                */
      __IOM uint32_t GPIO15INCFG : 1;           /*!< (@ 0x0000001C) GPIO15 input enable.                                       */
      __IOM uint32_t GPIO15OUTCFG : 2;          /*!< (@ 0x0000001D) GPIO15 output configuration.                               */
      __IOM uint32_t GPIO15INTD : 1;            /*!< (@ 0x0000001F) GPIO15 interrupt direction.                                */
    } CFGB_b;
  } ;
  
  union {
    __IOM uint32_t CFGC;                        /*!< (@ 0x00000048) GPIO Configuration Register C                              */
    
    struct {
      __IOM uint32_t GPIO16INCFG : 1;           /*!< (@ 0x00000000) GPIO16 input enable.                                       */
      __IOM uint32_t GPIO16OUTCFG : 2;          /*!< (@ 0x00000001) GPIO16 output configuration.                               */
      __IOM uint32_t GPIO16INTD : 1;            /*!< (@ 0x00000003) GPIO16 interrupt direction.                                */
      __IOM uint32_t GPIO17INCFG : 1;           /*!< (@ 0x00000004) GPIO17 input enable.                                       */
      __IOM uint32_t GPIO17OUTCFG : 2;          /*!< (@ 0x00000005) GPIO17 output configuration.                               */
      __IOM uint32_t GPIO17INTD : 1;            /*!< (@ 0x00000007) GPIO17 interrupt direction.                                */
      __IOM uint32_t GPIO18INCFG : 1;           /*!< (@ 0x00000008) GPIO18 input enable.                                       */
      __IOM uint32_t GPIO18OUTCFG : 2;          /*!< (@ 0x00000009) GPIO18 output configuration.                               */
      __IOM uint32_t GPIO18INTD : 1;            /*!< (@ 0x0000000B) GPIO18 interrupt direction.                                */
      __IOM uint32_t GPIO19INCFG : 1;           /*!< (@ 0x0000000C) GPIO19 input enable.                                       */
      __IOM uint32_t GPIO19OUTCFG : 2;          /*!< (@ 0x0000000D) GPIO19 output configuration.                               */
      __IOM uint32_t GPIO19INTD : 1;            /*!< (@ 0x0000000F) GPIO19 interrupt direction.                                */
      __IOM uint32_t GPIO20INCFG : 1;           /*!< (@ 0x00000010) GPIO20 input enable.                                       */
      __IOM uint32_t GPIO20OUTCFG : 2;          /*!< (@ 0x00000011) GPIO20 output configuration.                               */
      __IOM uint32_t GPIO20INTD : 1;            /*!< (@ 0x00000013) GPIO20 interrupt direction.                                */
      __IOM uint32_t GPIO21INCFG : 1;           /*!< (@ 0x00000014) GPIO21 input enable.                                       */
      __IOM uint32_t GPIO21OUTCFG : 2;          /*!< (@ 0x00000015) GPIO21 output configuration.                               */
      __IOM uint32_t GPIO21INTD : 1;            /*!< (@ 0x00000017) GPIO21 interrupt direction.                                */
      __IOM uint32_t GPIO22INCFG : 1;           /*!< (@ 0x00000018) GPIO22 input enable.                                       */
      __IOM uint32_t GPIO22OUTCFG : 2;          /*!< (@ 0x00000019) GPIO22 output configuration.                               */
      __IOM uint32_t GPIO22INTD : 1;            /*!< (@ 0x0000001B) GPIO22 interrupt direction.                                */
      __IOM uint32_t GPIO23INCFG : 1;           /*!< (@ 0x0000001C) GPIO23 input enable.                                       */
      __IOM uint32_t GPIO23OUTCFG : 2;          /*!< (@ 0x0000001D) GPIO23 output configuration.                               */
      __IOM uint32_t GPIO23INTD : 1;            /*!< (@ 0x0000001F) GPIO23 interrupt direction.                                */
    } CFGC_b;
  } ;
  
  union {
    __IOM uint32_t CFGD;                        /*!< (@ 0x0000004C) GPIO Configuration Register D                              */
    
    struct {
      __IOM uint32_t GPIO24INCFG : 1;           /*!< (@ 0x00000000) GPIO24 input enable.                                       */
      __IOM uint32_t GPIO24OUTCFG : 2;          /*!< (@ 0x00000001) GPIO24 output configuration.                               */
      __IOM uint32_t GPIO24INTD : 1;            /*!< (@ 0x00000003) GPIO24 interrupt direction.                                */
      __IOM uint32_t GPIO25INCFG : 1;           /*!< (@ 0x00000004) GPIO25 input enable.                                       */
      __IOM uint32_t GPIO25OUTCFG : 2;          /*!< (@ 0x00000005) GPIO25 output configuration.                               */
      __IOM uint32_t GPIO25INTD : 1;            /*!< (@ 0x00000007) GPIO25 interrupt direction.                                */
      __IOM uint32_t GPIO26INCFG : 1;           /*!< (@ 0x00000008) GPIO26 input enable.                                       */
      __IOM uint32_t GPIO26OUTCFG : 2;          /*!< (@ 0x00000009) GPIO26 output configuration.                               */
      __IOM uint32_t GPIO26INTD : 1;            /*!< (@ 0x0000000B) GPIO26 interrupt direction.                                */
      __IOM uint32_t GPIO27INCFG : 1;           /*!< (@ 0x0000000C) GPIO27 input enable.                                       */
      __IOM uint32_t GPIO27OUTCFG : 2;          /*!< (@ 0x0000000D) GPIO27 output configuration.                               */
      __IOM uint32_t GPIO27INTD : 1;            /*!< (@ 0x0000000F) GPIO27 interrupt direction.                                */
      __IOM uint32_t GPIO28INCFG : 1;           /*!< (@ 0x00000010) GPIO28 input enable.                                       */
      __IOM uint32_t GPIO28OUTCFG : 2;          /*!< (@ 0x00000011) GPIO28 output configuration.                               */
      __IOM uint32_t GPIO28INTD : 1;            /*!< (@ 0x00000013) GPIO28 interrupt direction.                                */
      __IOM uint32_t GPIO29INCFG : 1;           /*!< (@ 0x00000014) GPIO29 input enable.                                       */
      __IOM uint32_t GPIO29OUTCFG : 2;          /*!< (@ 0x00000015) GPIO29 output configuration.                               */
      __IOM uint32_t GPIO29INTD : 1;            /*!< (@ 0x00000017) GPIO29 interrupt direction.                                */
      __IOM uint32_t GPIO30INCFG : 1;           /*!< (@ 0x00000018) GPIO30 input enable.                                       */
      __IOM uint32_t GPIO30OUTCFG : 2;          /*!< (@ 0x00000019) GPIO30 output configuration.                               */
      __IOM uint32_t GPIO30INTD : 1;            /*!< (@ 0x0000001B) GPIO30 interrupt direction.                                */
      __IOM uint32_t GPIO31INCFG : 1;           /*!< (@ 0x0000001C) GPIO31 input enable.                                       */
      __IOM uint32_t GPIO31OUTCFG : 2;          /*!< (@ 0x0000001D) GPIO31 output configuration.                               */
      __IOM uint32_t GPIO31INTD : 1;            /*!< (@ 0x0000001F) GPIO31 interrupt direction.                                */
    } CFGD_b;
  } ;
  
  union {
    __IOM uint32_t CFGE;                        /*!< (@ 0x00000050) GPIO Configuration Register E                              */
    
    struct {
      __IOM uint32_t GPIO32INCFG : 1;           /*!< (@ 0x00000000) GPIO32 input enable.                                       */
      __IOM uint32_t GPIO32OUTCFG : 2;          /*!< (@ 0x00000001) GPIO32 output configuration.                               */
      __IOM uint32_t GPIO32INTD : 1;            /*!< (@ 0x00000003) GPIO32 interrupt direction.                                */
      __IOM uint32_t GPIO33INCFG : 1;           /*!< (@ 0x00000004) GPIO33 input enable.                                       */
      __IOM uint32_t GPIO33OUTCFG : 2;          /*!< (@ 0x00000005) GPIO33 output configuration.                               */
      __IOM uint32_t GPIO33INTD : 1;            /*!< (@ 0x00000007) GPIO33 interrupt direction.                                */
      __IOM uint32_t GPIO34INCFG : 1;           /*!< (@ 0x00000008) GPIO34 input enable.                                       */
      __IOM uint32_t GPIO34OUTCFG : 2;          /*!< (@ 0x00000009) GPIO34 output configuration.                               */
      __IOM uint32_t GPIO34INTD : 1;            /*!< (@ 0x0000000B) GPIO34 interrupt direction.                                */
      __IOM uint32_t GPIO35INCFG : 1;           /*!< (@ 0x0000000C) GPIO35 input enable.                                       */
      __IOM uint32_t GPIO35OUTCFG : 2;          /*!< (@ 0x0000000D) GPIO35 output configuration.                               */
      __IOM uint32_t GPIO35INTD : 1;            /*!< (@ 0x0000000F) GPIO35 interrupt direction.                                */
      __IOM uint32_t GPIO36INCFG : 1;           /*!< (@ 0x00000010) GPIO36 input enable.                                       */
      __IOM uint32_t GPIO36OUTCFG : 2;          /*!< (@ 0x00000011) GPIO36 output configuration.                               */
      __IOM uint32_t GPIO36INTD : 1;            /*!< (@ 0x00000013) GPIO36 interrupt direction.                                */
      __IOM uint32_t GPIO37INCFG : 1;           /*!< (@ 0x00000014) GPIO37 input enable.                                       */
      __IOM uint32_t GPIO37OUTCFG : 2;          /*!< (@ 0x00000015) GPIO37 output configuration.                               */
      __IOM uint32_t GPIO37INTD : 1;            /*!< (@ 0x00000017) GPIO37 interrupt direction.                                */
      __IOM uint32_t GPIO38INCFG : 1;           /*!< (@ 0x00000018) GPIO38 input enable.                                       */
      __IOM uint32_t GPIO38OUTCFG : 2;          /*!< (@ 0x00000019) GPIO38 output configuration.                               */
      __IOM uint32_t GPIO38INTD : 1;            /*!< (@ 0x0000001B) GPIO38 interrupt direction.                                */
      __IOM uint32_t GPIO39INCFG : 1;           /*!< (@ 0x0000001C) GPIO39 input enable.                                       */
      __IOM uint32_t GPIO39OUTCFG : 2;          /*!< (@ 0x0000001D) GPIO39 output configuration.                               */
      __IOM uint32_t GPIO39INTD : 1;            /*!< (@ 0x0000001F) GPIO39 interrupt direction.                                */
    } CFGE_b;
  } ;
  
  union {
    __IOM uint32_t CFGF;                        /*!< (@ 0x00000054) GPIO Configuration Register F                              */
    
    struct {
      __IOM uint32_t GPIO40INCFG : 1;           /*!< (@ 0x00000000) GPIO40 input enable.                                       */
      __IOM uint32_t GPIO40OUTCFG : 2;          /*!< (@ 0x00000001) GPIO40 output configuration.                               */
      __IOM uint32_t GPIO40INTD : 1;            /*!< (@ 0x00000003) GPIO40 interrupt direction.                                */
      __IOM uint32_t GPIO41INCFG : 1;           /*!< (@ 0x00000004) GPIO41 input enable.                                       */
      __IOM uint32_t GPIO41OUTCFG : 2;          /*!< (@ 0x00000005) GPIO41 output configuration.                               */
      __IOM uint32_t GPIO41INTD : 1;            /*!< (@ 0x00000007) GPIO41 interrupt direction.                                */
      __IOM uint32_t GPIO42INCFG : 1;           /*!< (@ 0x00000008) GPIO42 input enable.                                       */
      __IOM uint32_t GPIO42OUTCFG : 2;          /*!< (@ 0x00000009) GPIO42 output configuration.                               */
      __IOM uint32_t GPIO42INTD : 1;            /*!< (@ 0x0000000B) GPIO42 interrupt direction.                                */
      __IOM uint32_t GPIO43INCFG : 1;           /*!< (@ 0x0000000C) GPIO43 input enable.                                       */
      __IOM uint32_t GPIO43OUTCFG : 2;          /*!< (@ 0x0000000D) GPIO43 output configuration.                               */
      __IOM uint32_t GPIO43INTD : 1;            /*!< (@ 0x0000000F) GPIO43 interrupt direction.                                */
      __IOM uint32_t GPIO44INCFG : 1;           /*!< (@ 0x00000010) GPIO44 input enable.                                       */
      __IOM uint32_t GPIO44OUTCFG : 2;          /*!< (@ 0x00000011) GPIO44 output configuration.                               */
      __IOM uint32_t GPIO44INTD : 1;            /*!< (@ 0x00000013) GPIO44 interrupt direction.                                */
      __IOM uint32_t GPIO45INCFG : 1;           /*!< (@ 0x00000014) GPIO45 input enable.                                       */
      __IOM uint32_t GPIO45OUTCFG : 2;          /*!< (@ 0x00000015) GPIO45 output configuration.                               */
      __IOM uint32_t GPIO45INTD : 1;            /*!< (@ 0x00000017) GPIO45 interrupt direction.                                */
      __IOM uint32_t GPIO46INCFG : 1;           /*!< (@ 0x00000018) GPIO46 input enable.                                       */
      __IOM uint32_t GPIO46OUTCFG : 2;          /*!< (@ 0x00000019) GPIO46 output configuration.                               */
      __IOM uint32_t GPIO46INTD : 1;            /*!< (@ 0x0000001B) GPIO46 interrupt direction.                                */
      __IOM uint32_t GPIO47INCFG : 1;           /*!< (@ 0x0000001C) GPIO47 input enable.                                       */
      __IOM uint32_t GPIO47OUTCFG : 2;          /*!< (@ 0x0000001D) GPIO47 output configuration.                               */
      __IOM uint32_t GPIO47INTD : 1;            /*!< (@ 0x0000001F) GPIO47 interrupt direction.                                */
    } CFGF_b;
  } ;
  
  union {
    __IOM uint32_t CFGG;                        /*!< (@ 0x00000058) GPIO Configuration Register G                              */
    
    struct {
      __IOM uint32_t GPIO48INCFG : 1;           /*!< (@ 0x00000000) GPIO48 input enable.                                       */
      __IOM uint32_t GPIO48OUTCFG : 2;          /*!< (@ 0x00000001) GPIO48 output configuration.                               */
      __IOM uint32_t GPIO48INTD : 1;            /*!< (@ 0x00000003) GPIO48 interrupt direction.                                */
      __IOM uint32_t GPIO49INCFG : 1;           /*!< (@ 0x00000004) GPIO49 input enable.                                       */
      __IOM uint32_t GPIO49OUTCFG : 2;          /*!< (@ 0x00000005) GPIO49 output configuration.                               */
      __IOM uint32_t GPIO49INTD : 1;            /*!< (@ 0x00000007) GPIO49 interrupt direction.                                */
    } CFGG_b;
  } ;
  __IM  uint32_t  RESERVED1;
  
  union {
    __IOM uint32_t PADKEY;                      /*!< (@ 0x00000060) Key Register for all pad configuration registers           */
    
    struct {
      __IOM uint32_t PADKEY     : 32;           /*!< (@ 0x00000000) Key register value.                                        */
    } PADKEY_b;
  } ;
  __IM  uint32_t  RESERVED2[7];
  
  union {
    __IOM uint32_t RDA;                         /*!< (@ 0x00000080) GPIO Input Register A                                      */
    
    struct {
      __IOM uint32_t RDA        : 32;           /*!< (@ 0x00000000) GPIO31-0 read data.                                        */
    } RDA_b;
  } ;
  
  union {
    __IOM uint32_t RDB;                         /*!< (@ 0x00000084) GPIO Input Register B                                      */
    
    struct {
      __IOM uint32_t RDB        : 18;           /*!< (@ 0x00000000) GPIO49-32 read data.                                       */
    } RDB_b;
  } ;
  
  union {
    __IOM uint32_t WTA;                         /*!< (@ 0x00000088) GPIO Output Register A                                     */
    
    struct {
      __IOM uint32_t WTA        : 32;           /*!< (@ 0x00000000) GPIO31-0 write data.                                       */
    } WTA_b;
  } ;
  
  union {
    __IOM uint32_t WTB;                         /*!< (@ 0x0000008C) GPIO Output Register B                                     */
    
    struct {
      __IOM uint32_t WTB        : 18;           /*!< (@ 0x00000000) GPIO49-32 write data.                                      */
    } WTB_b;
  } ;
  
  union {
    __IOM uint32_t WTSA;                        /*!< (@ 0x00000090) GPIO Output Register A Set                                 */
    
    struct {
      __IOM uint32_t WTSA       : 32;           /*!< (@ 0x00000000) Set the GPIO31-0 write data.                               */
    } WTSA_b;
  } ;
  
  union {
    __IOM uint32_t WTSB;                        /*!< (@ 0x00000094) GPIO Output Register B Set                                 */
    
    struct {
      __IOM uint32_t WTSB       : 18;           /*!< (@ 0x00000000) Set the GPIO49-32 write data.                              */
    } WTSB_b;
  } ;
  
  union {
    __IOM uint32_t WTCA;                        /*!< (@ 0x00000098) GPIO Output Register A Clear                               */
    
    struct {
      __IOM uint32_t WTCA       : 32;           /*!< (@ 0x00000000) Clear the GPIO31-0 write data.                             */
    } WTCA_b;
  } ;
  
  union {
    __IOM uint32_t WTCB;                        /*!< (@ 0x0000009C) GPIO Output Register B Clear                               */
    
    struct {
      __IOM uint32_t WTCB       : 18;           /*!< (@ 0x00000000) Clear the GPIO49-32 write data.                            */
    } WTCB_b;
  } ;
  
  union {
    __IOM uint32_t ENA;                         /*!< (@ 0x000000A0) GPIO Enable Register A                                     */
    
    struct {
      __IOM uint32_t ENA        : 32;           /*!< (@ 0x00000000) GPIO31-0 output enables                                    */
    } ENA_b;
  } ;
  
  union {
    __IOM uint32_t ENB;                         /*!< (@ 0x000000A4) GPIO Enable Register B                                     */
    
    struct {
      __IOM uint32_t ENB        : 18;           /*!< (@ 0x00000000) GPIO49-32 output enables                                   */
    } ENB_b;
  } ;
  
  union {
    __IOM uint32_t ENSA;                        /*!< (@ 0x000000A8) GPIO Enable Register A Set                                 */
    
    struct {
      __IOM uint32_t ENSA       : 32;           /*!< (@ 0x00000000) Set the GPIO31-0 output enables                            */
    } ENSA_b;
  } ;
  
  union {
    __IOM uint32_t ENSB;                        /*!< (@ 0x000000AC) GPIO Enable Register B Set                                 */
    
    struct {
      __IOM uint32_t ENSB       : 18;           /*!< (@ 0x00000000) Set the GPIO49-32 output enables                           */
    } ENSB_b;
  } ;
  __IM  uint32_t  RESERVED3;
  
  union {
    __IOM uint32_t ENCA;                        /*!< (@ 0x000000B4) GPIO Enable Register A Clear                               */
    
    struct {
      __IOM uint32_t ENCA       : 32;           /*!< (@ 0x00000000) Clear the GPIO31-0 output enables                          */
    } ENCA_b;
  } ;
  
  union {
    __IOM uint32_t ENCB;                        /*!< (@ 0x000000B8) GPIO Enable Register B Clear                               */
    
    struct {
      __IOM uint32_t ENCB       : 18;           /*!< (@ 0x00000000) Clear the GPIO49-32 output enables                         */
    } ENCB_b;
  } ;
  
  union {
    __IOM uint32_t STMRCAP;                     /*!< (@ 0x000000BC) STIMER Capture Control                                     */
    
    struct {
      __IOM uint32_t STSEL0     : 6;            /*!< (@ 0x00000000) STIMER Capture 0 Select.                                   */
      __IOM uint32_t STPOL0     : 1;            /*!< (@ 0x00000006) STIMER Capture 0 Polarity.                                 */
      __IM  uint32_t            : 1;
      __IOM uint32_t STSEL1     : 6;            /*!< (@ 0x00000008) STIMER Capture 1 Select.                                   */
      __IOM uint32_t STPOL1     : 1;            /*!< (@ 0x0000000E) STIMER Capture 1 Polarity.                                 */
      __IM  uint32_t            : 1;
      __IOM uint32_t STSEL2     : 6;            /*!< (@ 0x00000010) STIMER Capture 2 Select.                                   */
      __IOM uint32_t STPOL2     : 1;            /*!< (@ 0x00000016) STIMER Capture 2 Polarity.                                 */
      __IM  uint32_t            : 1;
      __IOM uint32_t STSEL3     : 6;            /*!< (@ 0x00000018) STIMER Capture 3 Select.                                   */
      __IOM uint32_t STPOL3     : 1;            /*!< (@ 0x0000001E) STIMER Capture 3 Polarity.                                 */
    } STMRCAP_b;
  } ;
  
  union {
    __IOM uint32_t IOM0IRQ;                     /*!< (@ 0x000000C0) IOM0 Flow Control IRQ Select                               */
    
    struct {
      __IOM uint32_t IOM0IRQ    : 6;            /*!< (@ 0x00000000) IOMSTR0 IRQ pad select.                                    */
    } IOM0IRQ_b;
  } ;
  
  union {
    __IOM uint32_t IOM1IRQ;                     /*!< (@ 0x000000C4) IOM1 Flow Control IRQ Select                               */
    
    struct {
      __IOM uint32_t IOM1IRQ    : 6;            /*!< (@ 0x00000000) IOMSTR1 IRQ pad select.                                    */
    } IOM1IRQ_b;
  } ;
  
  union {
    __IOM uint32_t IOM2IRQ;                     /*!< (@ 0x000000C8) IOM2 Flow Control IRQ Select                               */
    
    struct {
      __IOM uint32_t IOM2IRQ    : 6;            /*!< (@ 0x00000000) IOMSTR2 IRQ pad select.                                    */
    } IOM2IRQ_b;
  } ;
  
  union {
    __IOM uint32_t IOM3IRQ;                     /*!< (@ 0x000000CC) IOM3 Flow Control IRQ Select                               */
    
    struct {
      __IOM uint32_t IOM3IRQ    : 6;            /*!< (@ 0x00000000) IOMSTR3 IRQ pad select.                                    */
    } IOM3IRQ_b;
  } ;
  
  union {
    __IOM uint32_t IOM4IRQ;                     /*!< (@ 0x000000D0) IOM4 Flow Control IRQ Select                               */
    
    struct {
      __IOM uint32_t IOM4IRQ    : 6;            /*!< (@ 0x00000000) IOMSTR4 IRQ pad select.                                    */
    } IOM4IRQ_b;
  } ;
  
  union {
    __IOM uint32_t IOM5IRQ;                     /*!< (@ 0x000000D4) IOM5 Flow Control IRQ Select                               */
    
    struct {
      __IOM uint32_t IOM5IRQ    : 6;            /*!< (@ 0x00000000) IOMSTR5 IRQ pad select.                                    */
    } IOM5IRQ_b;
  } ;
  
  union {
    __IOM uint32_t LOOPBACK;                    /*!< (@ 0x000000D8) IOM to IOS Loopback Control                                */
    
    struct {
      __IOM uint32_t LOOPBACK   : 3;            /*!< (@ 0x00000000) IOM to IOS loopback control.                               */
    } LOOPBACK_b;
  } ;
  
  union {
    __IOM uint32_t GPIOOBS;                     /*!< (@ 0x000000DC) GPIO Observation Mode Sample register                      */
    
    struct {
      __IOM uint32_t OBS_DATA   : 16;           /*!< (@ 0x00000000) Sample of the data output on the GPIO observation
                                                                    port. May have async sampling issues, as
                                                                    the data is not synronized to the read
                                                                    operation. Intended for debug purposes
                                                                    only                                                       */
    } GPIOOBS_b;
  } ;
  
  union {
    __IOM uint32_t ALTPADCFGA;                  /*!< (@ 0x000000E0) Alternate Pad Configuration reg0 (Pads 3,2,1,0)            */
    
    struct {
      __IOM uint32_t PAD0_DS1   : 1;            /*!< (@ 0x00000000) Pad 0 high order drive strength selection. Used
                                                                    in conjunction with PAD0STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD0_SR    : 1;            /*!< (@ 0x00000004) Pad 0 slew rate selection.                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD1_DS1   : 1;            /*!< (@ 0x00000008) Pad 1 high order drive strength selection. Used
                                                                    in conjunction with PAD1STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD1_SR    : 1;            /*!< (@ 0x0000000C) Pad 1 slew rate selection.                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD2_DS1   : 1;            /*!< (@ 0x00000010) Pad 2 high order drive strength selection. Used
                                                                    in conjunction with PAD2STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD2_SR    : 1;            /*!< (@ 0x00000014) Pad 2 slew rate selection.                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD3_DS1   : 1;            /*!< (@ 0x00000018) Pad 3 high order drive strength selection. Used
                                                                    in conjunction with PAD3STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD3_SR    : 1;            /*!< (@ 0x0000001C) Pad 3 slew rate selection.                                 */
    } ALTPADCFGA_b;
  } ;
  
  union {
    __IOM uint32_t ALTPADCFGB;                  /*!< (@ 0x000000E4) Alternate Pad Configuration reg1 (Pads 7,6,5,4)            */
    
    struct {
      __IOM uint32_t PAD4_DS1   : 1;            /*!< (@ 0x00000000) Pad 4 high order drive strength selection. Used
                                                                    in conjunction with PAD4STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD4_SR    : 1;            /*!< (@ 0x00000004) Pad 4 slew rate selection.                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD5_DS1   : 1;            /*!< (@ 0x00000008) Pad 5 high order drive strength selection. Used
                                                                    in conjunction with PAD5STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD5_SR    : 1;            /*!< (@ 0x0000000C) Pad 5 slew rate selection.                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD6_DS1   : 1;            /*!< (@ 0x00000010) Pad 6 high order drive strength selection. Used
                                                                    in conjunction with PAD6STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD6_SR    : 1;            /*!< (@ 0x00000014) Pad 6 slew rate selection.                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD7_DS1   : 1;            /*!< (@ 0x00000018) Pad 7 high order drive strength selection. Used
                                                                    in conjunction with PAD7STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD7_SR    : 1;            /*!< (@ 0x0000001C) Pad 7 slew rate selection.                                 */
    } ALTPADCFGB_b;
  } ;
  
  union {
    __IOM uint32_t ALTPADCFGC;                  /*!< (@ 0x000000E8) Alternate Pad Configuration reg2 (Pads 11,10,9,8)          */
    
    struct {
      __IOM uint32_t PAD8_DS1   : 1;            /*!< (@ 0x00000000) Pad 8 high order drive strength selection. Used
                                                                    in conjunction with PAD8STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD8_SR    : 1;            /*!< (@ 0x00000004) Pad 8 slew rate selection.                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD9_DS1   : 1;            /*!< (@ 0x00000008) Pad 9 high order drive strength selection. Used
                                                                    in conjunction with PAD9STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD9_SR    : 1;            /*!< (@ 0x0000000C) Pad 9 slew rate selection.                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD10_DS1  : 1;            /*!< (@ 0x00000010) Pad 10 high order drive strength selection. Used
                                                                    in conjunction with PAD10STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD10_SR   : 1;            /*!< (@ 0x00000014) Pad 10 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD11_DS1  : 1;            /*!< (@ 0x00000018) Pad 11 high order drive strength selection. Used
                                                                    in conjunction with PAD11STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD11_SR   : 1;            /*!< (@ 0x0000001C) Pad 11 slew rate selection.                                */
    } ALTPADCFGC_b;
  } ;
  
  union {
    __IOM uint32_t ALTPADCFGD;                  /*!< (@ 0x000000EC) Alternate Pad Configuration reg3 (Pads 15,14,13,12)        */
    
    struct {
      __IOM uint32_t PAD12_DS1  : 1;            /*!< (@ 0x00000000) Pad 12 high order drive strength selection. Used
                                                                    in conjunction with PAD12STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD12_SR   : 1;            /*!< (@ 0x00000004) Pad 12 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD13_DS1  : 1;            /*!< (@ 0x00000008) Pad 13 high order drive strength selection. Used
                                                                    in conjunction with PAD13STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD13_SR   : 1;            /*!< (@ 0x0000000C) Pad 13 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD14_DS1  : 1;            /*!< (@ 0x00000010) Pad 14 high order drive strength selection. Used
                                                                    in conjunction with PAD14STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD14_SR   : 1;            /*!< (@ 0x00000014) Pad 14 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD15_DS1  : 1;            /*!< (@ 0x00000018) Pad 15 high order drive strength selection. Used
                                                                    in conjunction with PAD15STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD15_SR   : 1;            /*!< (@ 0x0000001C) Pad 15 slew rate selection.                                */
    } ALTPADCFGD_b;
  } ;
  
  union {
    __IOM uint32_t ALTPADCFGE;                  /*!< (@ 0x000000F0) Alternate Pad Configuration reg4 (Pads 19,18,17,16)        */
    
    struct {
      __IOM uint32_t PAD16_DS1  : 1;            /*!< (@ 0x00000000) Pad 16 high order drive strength selection. Used
                                                                    in conjunction with PAD16STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD16_SR   : 1;            /*!< (@ 0x00000004) Pad 16 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD17_DS1  : 1;            /*!< (@ 0x00000008) Pad 17 high order drive strength selection. Used
                                                                    in conjunction with PAD17STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD17_SR   : 1;            /*!< (@ 0x0000000C) Pad 17 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD18_DS1  : 1;            /*!< (@ 0x00000010) Pad 18 high order drive strength selection. Used
                                                                    in conjunction with PAD18STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD18_SR   : 1;            /*!< (@ 0x00000014) Pad 18 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD19_DS1  : 1;            /*!< (@ 0x00000018) Pad 19 high order drive strength selection. Used
                                                                    in conjunction with PAD19STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD19_SR   : 1;            /*!< (@ 0x0000001C) Pad 19 slew rate selection.                                */
    } ALTPADCFGE_b;
  } ;
  
  union {
    __IOM uint32_t ALTPADCFGF;                  /*!< (@ 0x000000F4) Alternate Pad Configuration reg5 (Pads 23,22,21,20)        */
    
    struct {
      __IOM uint32_t PAD20_DS1  : 1;            /*!< (@ 0x00000000) Pad 20 high order drive strength selection. Used
                                                                    in conjunction with PAD20STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD20_SR   : 1;            /*!< (@ 0x00000004) Pad 20 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD21_DS1  : 1;            /*!< (@ 0x00000008) Pad 21 high order drive strength selection. Used
                                                                    in conjunction with PAD21STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD21_SR   : 1;            /*!< (@ 0x0000000C) Pad 21 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD22_DS1  : 1;            /*!< (@ 0x00000010) Pad 22 high order drive strength selection. Used
                                                                    in conjunction with PAD22STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD22_SR   : 1;            /*!< (@ 0x00000014) Pad 22 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD23_DS1  : 1;            /*!< (@ 0x00000018) Pad 23 high order drive strength selection. Used
                                                                    in conjunction with PAD23STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD23_SR   : 1;            /*!< (@ 0x0000001C) Pad 23 slew rate selection.                                */
    } ALTPADCFGF_b;
  } ;
  
  union {
    __IOM uint32_t ALTPADCFGG;                  /*!< (@ 0x000000F8) Alternate Pad Configuration reg6 (Pads 27,26,25,24)        */
    
    struct {
      __IOM uint32_t PAD24_DS1  : 1;            /*!< (@ 0x00000000) Pad 24 high order drive strength selection. Used
                                                                    in conjunction with PAD24STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD24_SR   : 1;            /*!< (@ 0x00000004) Pad 24 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD25_DS1  : 1;            /*!< (@ 0x00000008) Pad 25 high order drive strength selection. Used
                                                                    in conjunction with PAD25STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD25_SR   : 1;            /*!< (@ 0x0000000C) Pad 25 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD26_DS1  : 1;            /*!< (@ 0x00000010) Pad 26 high order drive strength selection. Used
                                                                    in conjunction with PAD26STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD26_SR   : 1;            /*!< (@ 0x00000014) Pad 26 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD27_DS1  : 1;            /*!< (@ 0x00000018) Pad 27 high order drive strength selection. Used
                                                                    in conjunction with PAD27STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD27_SR   : 1;            /*!< (@ 0x0000001C) Pad 27 slew rate selection.                                */
    } ALTPADCFGG_b;
  } ;
  
  union {
    __IOM uint32_t ALTPADCFGH;                  /*!< (@ 0x000000FC) Alternate Pad Configuration reg7 (Pads 31,30,29,28)        */
    
    struct {
      __IOM uint32_t PAD28_DS1  : 1;            /*!< (@ 0x00000000) Pad 28 high order drive strength selection. Used
                                                                    in conjunction with PAD28STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD28_SR   : 1;            /*!< (@ 0x00000004) Pad 28 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD29_DS1  : 1;            /*!< (@ 0x00000008) Pad 29 high order drive strength selection. Used
                                                                    in conjunction with PAD29STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD29_SR   : 1;            /*!< (@ 0x0000000C) Pad 29 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD30_DS1  : 1;            /*!< (@ 0x00000010) Pad 30 high order drive strength selection. Used
                                                                    in conjunction with PAD30STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD30_SR   : 1;            /*!< (@ 0x00000014) Pad 30 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD31_DS1  : 1;            /*!< (@ 0x00000018) Pad 31 high order drive strength selection. Used
                                                                    in conjunction with PAD31STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD31_SR   : 1;            /*!< (@ 0x0000001C) Pad 31 slew rate selection.                                */
    } ALTPADCFGH_b;
  } ;
  
  union {
    __IOM uint32_t ALTPADCFGI;                  /*!< (@ 0x00000100) Alternate Pad Configuration reg8 (Pads 35,34,33,32)        */
    
    struct {
      __IOM uint32_t PAD32_DS1  : 1;            /*!< (@ 0x00000000) Pad 32 high order drive strength selection. Used
                                                                    in conjunction with PAD32STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD32_SR   : 1;            /*!< (@ 0x00000004) Pad 32 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD33_DS1  : 1;            /*!< (@ 0x00000008) Pad 33 high order drive strength selection. Used
                                                                    in conjunction with PAD33STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD33_SR   : 1;            /*!< (@ 0x0000000C) Pad 33 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD34_DS1  : 1;            /*!< (@ 0x00000010) Pad 34 high order drive strength selection. Used
                                                                    in conjunction with PAD34STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD34_SR   : 1;            /*!< (@ 0x00000014) Pad 34 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD35_DS1  : 1;            /*!< (@ 0x00000018) Pad 35 high order drive strength selection. Used
                                                                    in conjunction with PAD35STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD35_SR   : 1;            /*!< (@ 0x0000001C) Pad 35 slew rate selection.                                */
    } ALTPADCFGI_b;
  } ;
  
  union {
    __IOM uint32_t ALTPADCFGJ;                  /*!< (@ 0x00000104) Alternate Pad Configuration reg9 (Pads 39,38,37,36)        */
    
    struct {
      __IOM uint32_t PAD36_DS1  : 1;            /*!< (@ 0x00000000) Pad 36 high order drive strength selection. Used
                                                                    in conjunction with PAD36STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD36_SR   : 1;            /*!< (@ 0x00000004) Pad 36 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD37_DS1  : 1;            /*!< (@ 0x00000008) Pad 37 high order drive strength selection. Used
                                                                    in conjunction with PAD37STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD37_SR   : 1;            /*!< (@ 0x0000000C) Pad 37 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD38_DS1  : 1;            /*!< (@ 0x00000010) Pad 38 high order drive strength selection. Used
                                                                    in conjunction with PAD38STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD38_SR   : 1;            /*!< (@ 0x00000014) Pad 38 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD39_DS1  : 1;            /*!< (@ 0x00000018) Pad 39 high order drive strength selection. Used
                                                                    in conjunction with PAD39STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD39_SR   : 1;            /*!< (@ 0x0000001C) Pad 39 slew rate selection.                                */
    } ALTPADCFGJ_b;
  } ;
  
  union {
    __IOM uint32_t ALTPADCFGK;                  /*!< (@ 0x00000108) Alternate Pad Configuration reg10 (Pads 43,42,41,40)       */
    
    struct {
      __IOM uint32_t PAD40_DS1  : 1;            /*!< (@ 0x00000000) Pad 40 high order drive strength selection. Used
                                                                    in conjunction with PAD40STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD40_SR   : 1;            /*!< (@ 0x00000004) Pad 40 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD41_DS1  : 1;            /*!< (@ 0x00000008) Pad 41 high order drive strength selection. Used
                                                                    in conjunction with PAD41STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD41_SR   : 1;            /*!< (@ 0x0000000C) Pad 41 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD42_DS1  : 1;            /*!< (@ 0x00000010) Pad 42 high order drive strength selection. Used
                                                                    in conjunction with PAD42STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD42_SR   : 1;            /*!< (@ 0x00000014) Pad 42 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD43_DS1  : 1;            /*!< (@ 0x00000018) Pad 43 high order drive strength selection. Used
                                                                    in conjunction with PAD43STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD43_SR   : 1;            /*!< (@ 0x0000001C) Pad 43 slew rate selection.                                */
    } ALTPADCFGK_b;
  } ;
  
  union {
    __IOM uint32_t ALTPADCFGL;                  /*!< (@ 0x0000010C) Alternate Pad Configuration reg11 (Pads 47,46,45,44)       */
    
    struct {
      __IOM uint32_t PAD44_DS1  : 1;            /*!< (@ 0x00000000) Pad 44 high order drive strength selection. Used
                                                                    in conjunction with PAD44STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD44_SR   : 1;            /*!< (@ 0x00000004) Pad 44 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD45_DS1  : 1;            /*!< (@ 0x00000008) Pad 45 high order drive strength selection. Used
                                                                    in conjunction with PAD45STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD45_SR   : 1;            /*!< (@ 0x0000000C) Pad 45 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD46_DS1  : 1;            /*!< (@ 0x00000010) Pad 46 high order drive strength selection. Used
                                                                    in conjunction with PAD46STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD46_SR   : 1;            /*!< (@ 0x00000014) Pad 46 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD47_DS1  : 1;            /*!< (@ 0x00000018) Pad 47 high order drive strength selection. Used
                                                                    in conjunction with PAD47STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD47_SR   : 1;            /*!< (@ 0x0000001C) Pad 47 slew rate selection.                                */
    } ALTPADCFGL_b;
  } ;
  
  union {
    __IOM uint32_t ALTPADCFGM;                  /*!< (@ 0x00000110) Alternate Pad Configuration reg12 (Pads 49,48)             */
    
    struct {
      __IOM uint32_t PAD48_DS1  : 1;            /*!< (@ 0x00000000) Pad 48 high order drive strength selection. Used
                                                                    in conjunction with PAD48STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD48_SR   : 1;            /*!< (@ 0x00000004) Pad 48 slew rate selection.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD49_DS1  : 1;            /*!< (@ 0x00000008) Pad 49 high order drive strength selection. Used
                                                                    in conjunction with PAD49STRNG field to
                                                                    set the pad drive strength.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD49_SR   : 1;            /*!< (@ 0x0000000C) Pad 49 slew rate selection.                                */
    } ALTPADCFGM_b;
  } ;
  __IM  uint32_t  RESERVED4[59];
  
  union {
    __IOM uint32_t INT0EN;                      /*!< (@ 0x00000200) GPIO Interrupt Registers 31-0: Enable                      */
    
    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< (@ 0x00000000) GPIO0 interrupt.                                           */
      __IOM uint32_t GPIO1      : 1;            /*!< (@ 0x00000001) GPIO1 interrupt.                                           */
      __IOM uint32_t GPIO2      : 1;            /*!< (@ 0x00000002) GPIO2 interrupt.                                           */
      __IOM uint32_t GPIO3      : 1;            /*!< (@ 0x00000003) GPIO3 interrupt.                                           */
      __IOM uint32_t GPIO4      : 1;            /*!< (@ 0x00000004) GPIO4 interrupt.                                           */
      __IOM uint32_t GPIO5      : 1;            /*!< (@ 0x00000005) GPIO5 interrupt.                                           */
      __IOM uint32_t GPIO6      : 1;            /*!< (@ 0x00000006) GPIO6 interrupt.                                           */
      __IOM uint32_t GPIO7      : 1;            /*!< (@ 0x00000007) GPIO7 interrupt.                                           */
      __IOM uint32_t GPIO8      : 1;            /*!< (@ 0x00000008) GPIO8 interrupt.                                           */
      __IOM uint32_t GPIO9      : 1;            /*!< (@ 0x00000009) GPIO9 interrupt.                                           */
      __IOM uint32_t GPIO10     : 1;            /*!< (@ 0x0000000A) GPIO10 interrupt.                                          */
      __IOM uint32_t GPIO11     : 1;            /*!< (@ 0x0000000B) GPIO11 interrupt.                                          */
      __IOM uint32_t GPIO12     : 1;            /*!< (@ 0x0000000C) GPIO12 interrupt.                                          */
      __IOM uint32_t GPIO13     : 1;            /*!< (@ 0x0000000D) GPIO13 interrupt.                                          */
      __IOM uint32_t GPIO14     : 1;            /*!< (@ 0x0000000E) GPIO14 interrupt.                                          */
      __IOM uint32_t GPIO15     : 1;            /*!< (@ 0x0000000F) GPIO15 interrupt.                                          */
      __IOM uint32_t GPIO16     : 1;            /*!< (@ 0x00000010) GPIO16 interrupt.                                          */
      __IOM uint32_t GPIO17     : 1;            /*!< (@ 0x00000011) GPIO17 interrupt.                                          */
      __IOM uint32_t GPIO18     : 1;            /*!< (@ 0x00000012) GPIO18interrupt.                                           */
      __IOM uint32_t GPIO19     : 1;            /*!< (@ 0x00000013) GPIO19 interrupt.                                          */
      __IOM uint32_t GPIO20     : 1;            /*!< (@ 0x00000014) GPIO20 interrupt.                                          */
      __IOM uint32_t GPIO21     : 1;            /*!< (@ 0x00000015) GPIO21 interrupt.                                          */
      __IOM uint32_t GPIO22     : 1;            /*!< (@ 0x00000016) GPIO22 interrupt.                                          */
      __IOM uint32_t GPIO23     : 1;            /*!< (@ 0x00000017) GPIO23 interrupt.                                          */
      __IOM uint32_t GPIO24     : 1;            /*!< (@ 0x00000018) GPIO24 interrupt.                                          */
      __IOM uint32_t GPIO25     : 1;            /*!< (@ 0x00000019) GPIO25 interrupt.                                          */
      __IOM uint32_t GPIO26     : 1;            /*!< (@ 0x0000001A) GPIO26 interrupt.                                          */
      __IOM uint32_t GPIO27     : 1;            /*!< (@ 0x0000001B) GPIO27 interrupt.                                          */
      __IOM uint32_t GPIO28     : 1;            /*!< (@ 0x0000001C) GPIO28 interrupt.                                          */
      __IOM uint32_t GPIO29     : 1;            /*!< (@ 0x0000001D) GPIO29 interrupt.                                          */
      __IOM uint32_t GPIO30     : 1;            /*!< (@ 0x0000001E) GPIO30 interrupt.                                          */
      __IOM uint32_t GPIO31     : 1;            /*!< (@ 0x0000001F) GPIO31 interrupt.                                          */
    } INT0EN_b;
  } ;
  
  union {
    __IOM uint32_t INT0STAT;                    /*!< (@ 0x00000204) GPIO Interrupt Registers 31-0: Status                      */
    
    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< (@ 0x00000000) GPIO0 interrupt.                                           */
      __IOM uint32_t GPIO1      : 1;            /*!< (@ 0x00000001) GPIO1 interrupt.                                           */
      __IOM uint32_t GPIO2      : 1;            /*!< (@ 0x00000002) GPIO2 interrupt.                                           */
      __IOM uint32_t GPIO3      : 1;            /*!< (@ 0x00000003) GPIO3 interrupt.                                           */
      __IOM uint32_t GPIO4      : 1;            /*!< (@ 0x00000004) GPIO4 interrupt.                                           */
      __IOM uint32_t GPIO5      : 1;            /*!< (@ 0x00000005) GPIO5 interrupt.                                           */
      __IOM uint32_t GPIO6      : 1;            /*!< (@ 0x00000006) GPIO6 interrupt.                                           */
      __IOM uint32_t GPIO7      : 1;            /*!< (@ 0x00000007) GPIO7 interrupt.                                           */
      __IOM uint32_t GPIO8      : 1;            /*!< (@ 0x00000008) GPIO8 interrupt.                                           */
      __IOM uint32_t GPIO9      : 1;            /*!< (@ 0x00000009) GPIO9 interrupt.                                           */
      __IOM uint32_t GPIO10     : 1;            /*!< (@ 0x0000000A) GPIO10 interrupt.                                          */
      __IOM uint32_t GPIO11     : 1;            /*!< (@ 0x0000000B) GPIO11 interrupt.                                          */
      __IOM uint32_t GPIO12     : 1;            /*!< (@ 0x0000000C) GPIO12 interrupt.                                          */
      __IOM uint32_t GPIO13     : 1;            /*!< (@ 0x0000000D) GPIO13 interrupt.                                          */
      __IOM uint32_t GPIO14     : 1;            /*!< (@ 0x0000000E) GPIO14 interrupt.                                          */
      __IOM uint32_t GPIO15     : 1;            /*!< (@ 0x0000000F) GPIO15 interrupt.                                          */
      __IOM uint32_t GPIO16     : 1;            /*!< (@ 0x00000010) GPIO16 interrupt.                                          */
      __IOM uint32_t GPIO17     : 1;            /*!< (@ 0x00000011) GPIO17 interrupt.                                          */
      __IOM uint32_t GPIO18     : 1;            /*!< (@ 0x00000012) GPIO18interrupt.                                           */
      __IOM uint32_t GPIO19     : 1;            /*!< (@ 0x00000013) GPIO19 interrupt.                                          */
      __IOM uint32_t GPIO20     : 1;            /*!< (@ 0x00000014) GPIO20 interrupt.                                          */
      __IOM uint32_t GPIO21     : 1;            /*!< (@ 0x00000015) GPIO21 interrupt.                                          */
      __IOM uint32_t GPIO22     : 1;            /*!< (@ 0x00000016) GPIO22 interrupt.                                          */
      __IOM uint32_t GPIO23     : 1;            /*!< (@ 0x00000017) GPIO23 interrupt.                                          */
      __IOM uint32_t GPIO24     : 1;            /*!< (@ 0x00000018) GPIO24 interrupt.                                          */
      __IOM uint32_t GPIO25     : 1;            /*!< (@ 0x00000019) GPIO25 interrupt.                                          */
      __IOM uint32_t GPIO26     : 1;            /*!< (@ 0x0000001A) GPIO26 interrupt.                                          */
      __IOM uint32_t GPIO27     : 1;            /*!< (@ 0x0000001B) GPIO27 interrupt.                                          */
      __IOM uint32_t GPIO28     : 1;            /*!< (@ 0x0000001C) GPIO28 interrupt.                                          */
      __IOM uint32_t GPIO29     : 1;            /*!< (@ 0x0000001D) GPIO29 interrupt.                                          */
      __IOM uint32_t GPIO30     : 1;            /*!< (@ 0x0000001E) GPIO30 interrupt.                                          */
      __IOM uint32_t GPIO31     : 1;            /*!< (@ 0x0000001F) GPIO31 interrupt.                                          */
    } INT0STAT_b;
  } ;
  
  union {
    __IOM uint32_t INT0CLR;                     /*!< (@ 0x00000208) GPIO Interrupt Registers 31-0: Clear                       */
    
    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< (@ 0x00000000) GPIO0 interrupt.                                           */
      __IOM uint32_t GPIO1      : 1;            /*!< (@ 0x00000001) GPIO1 interrupt.                                           */
      __IOM uint32_t GPIO2      : 1;            /*!< (@ 0x00000002) GPIO2 interrupt.                                           */
      __IOM uint32_t GPIO3      : 1;            /*!< (@ 0x00000003) GPIO3 interrupt.                                           */
      __IOM uint32_t GPIO4      : 1;            /*!< (@ 0x00000004) GPIO4 interrupt.                                           */
      __IOM uint32_t GPIO5      : 1;            /*!< (@ 0x00000005) GPIO5 interrupt.                                           */
      __IOM uint32_t GPIO6      : 1;            /*!< (@ 0x00000006) GPIO6 interrupt.                                           */
      __IOM uint32_t GPIO7      : 1;            /*!< (@ 0x00000007) GPIO7 interrupt.                                           */
      __IOM uint32_t GPIO8      : 1;            /*!< (@ 0x00000008) GPIO8 interrupt.                                           */
      __IOM uint32_t GPIO9      : 1;            /*!< (@ 0x00000009) GPIO9 interrupt.                                           */
      __IOM uint32_t GPIO10     : 1;            /*!< (@ 0x0000000A) GPIO10 interrupt.                                          */
      __IOM uint32_t GPIO11     : 1;            /*!< (@ 0x0000000B) GPIO11 interrupt.                                          */
      __IOM uint32_t GPIO12     : 1;            /*!< (@ 0x0000000C) GPIO12 interrupt.                                          */
      __IOM uint32_t GPIO13     : 1;            /*!< (@ 0x0000000D) GPIO13 interrupt.                                          */
      __IOM uint32_t GPIO14     : 1;            /*!< (@ 0x0000000E) GPIO14 interrupt.                                          */
      __IOM uint32_t GPIO15     : 1;            /*!< (@ 0x0000000F) GPIO15 interrupt.                                          */
      __IOM uint32_t GPIO16     : 1;            /*!< (@ 0x00000010) GPIO16 interrupt.                                          */
      __IOM uint32_t GPIO17     : 1;            /*!< (@ 0x00000011) GPIO17 interrupt.                                          */
      __IOM uint32_t GPIO18     : 1;            /*!< (@ 0x00000012) GPIO18interrupt.                                           */
      __IOM uint32_t GPIO19     : 1;            /*!< (@ 0x00000013) GPIO19 interrupt.                                          */
      __IOM uint32_t GPIO20     : 1;            /*!< (@ 0x00000014) GPIO20 interrupt.                                          */
      __IOM uint32_t GPIO21     : 1;            /*!< (@ 0x00000015) GPIO21 interrupt.                                          */
      __IOM uint32_t GPIO22     : 1;            /*!< (@ 0x00000016) GPIO22 interrupt.                                          */
      __IOM uint32_t GPIO23     : 1;            /*!< (@ 0x00000017) GPIO23 interrupt.                                          */
      __IOM uint32_t GPIO24     : 1;            /*!< (@ 0x00000018) GPIO24 interrupt.                                          */
      __IOM uint32_t GPIO25     : 1;            /*!< (@ 0x00000019) GPIO25 interrupt.                                          */
      __IOM uint32_t GPIO26     : 1;            /*!< (@ 0x0000001A) GPIO26 interrupt.                                          */
      __IOM uint32_t GPIO27     : 1;            /*!< (@ 0x0000001B) GPIO27 interrupt.                                          */
      __IOM uint32_t GPIO28     : 1;            /*!< (@ 0x0000001C) GPIO28 interrupt.                                          */
      __IOM uint32_t GPIO29     : 1;            /*!< (@ 0x0000001D) GPIO29 interrupt.                                          */
      __IOM uint32_t GPIO30     : 1;            /*!< (@ 0x0000001E) GPIO30 interrupt.                                          */
      __IOM uint32_t GPIO31     : 1;            /*!< (@ 0x0000001F) GPIO31 interrupt.                                          */
    } INT0CLR_b;
  } ;
  
  union {
    __IOM uint32_t INT0SET;                     /*!< (@ 0x0000020C) GPIO Interrupt Registers 31-0: Set                         */
    
    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< (@ 0x00000000) GPIO0 interrupt.                                           */
      __IOM uint32_t GPIO1      : 1;            /*!< (@ 0x00000001) GPIO1 interrupt.                                           */
      __IOM uint32_t GPIO2      : 1;            /*!< (@ 0x00000002) GPIO2 interrupt.                                           */
      __IOM uint32_t GPIO3      : 1;            /*!< (@ 0x00000003) GPIO3 interrupt.                                           */
      __IOM uint32_t GPIO4      : 1;            /*!< (@ 0x00000004) GPIO4 interrupt.                                           */
      __IOM uint32_t GPIO5      : 1;            /*!< (@ 0x00000005) GPIO5 interrupt.                                           */
      __IOM uint32_t GPIO6      : 1;            /*!< (@ 0x00000006) GPIO6 interrupt.                                           */
      __IOM uint32_t GPIO7      : 1;            /*!< (@ 0x00000007) GPIO7 interrupt.                                           */
      __IOM uint32_t GPIO8      : 1;            /*!< (@ 0x00000008) GPIO8 interrupt.                                           */
      __IOM uint32_t GPIO9      : 1;            /*!< (@ 0x00000009) GPIO9 interrupt.                                           */
      __IOM uint32_t GPIO10     : 1;            /*!< (@ 0x0000000A) GPIO10 interrupt.                                          */
      __IOM uint32_t GPIO11     : 1;            /*!< (@ 0x0000000B) GPIO11 interrupt.                                          */
      __IOM uint32_t GPIO12     : 1;            /*!< (@ 0x0000000C) GPIO12 interrupt.                                          */
      __IOM uint32_t GPIO13     : 1;            /*!< (@ 0x0000000D) GPIO13 interrupt.                                          */
      __IOM uint32_t GPIO14     : 1;            /*!< (@ 0x0000000E) GPIO14 interrupt.                                          */
      __IOM uint32_t GPIO15     : 1;            /*!< (@ 0x0000000F) GPIO15 interrupt.                                          */
      __IOM uint32_t GPIO16     : 1;            /*!< (@ 0x00000010) GPIO16 interrupt.                                          */
      __IOM uint32_t GPIO17     : 1;            /*!< (@ 0x00000011) GPIO17 interrupt.                                          */
      __IOM uint32_t GPIO18     : 1;            /*!< (@ 0x00000012) GPIO18interrupt.                                           */
      __IOM uint32_t GPIO19     : 1;            /*!< (@ 0x00000013) GPIO19 interrupt.                                          */
      __IOM uint32_t GPIO20     : 1;            /*!< (@ 0x00000014) GPIO20 interrupt.                                          */
      __IOM uint32_t GPIO21     : 1;            /*!< (@ 0x00000015) GPIO21 interrupt.                                          */
      __IOM uint32_t GPIO22     : 1;            /*!< (@ 0x00000016) GPIO22 interrupt.                                          */
      __IOM uint32_t GPIO23     : 1;            /*!< (@ 0x00000017) GPIO23 interrupt.                                          */
      __IOM uint32_t GPIO24     : 1;            /*!< (@ 0x00000018) GPIO24 interrupt.                                          */
      __IOM uint32_t GPIO25     : 1;            /*!< (@ 0x00000019) GPIO25 interrupt.                                          */
      __IOM uint32_t GPIO26     : 1;            /*!< (@ 0x0000001A) GPIO26 interrupt.                                          */
      __IOM uint32_t GPIO27     : 1;            /*!< (@ 0x0000001B) GPIO27 interrupt.                                          */
      __IOM uint32_t GPIO28     : 1;            /*!< (@ 0x0000001C) GPIO28 interrupt.                                          */
      __IOM uint32_t GPIO29     : 1;            /*!< (@ 0x0000001D) GPIO29 interrupt.                                          */
      __IOM uint32_t GPIO30     : 1;            /*!< (@ 0x0000001E) GPIO30 interrupt.                                          */
      __IOM uint32_t GPIO31     : 1;            /*!< (@ 0x0000001F) GPIO31 interrupt.                                          */
    } INT0SET_b;
  } ;
  
  union {
    __IOM uint32_t INT1EN;                      /*!< (@ 0x00000210) GPIO Interrupt Registers 49-32: Enable                     */
    
    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< (@ 0x00000000) GPIO32 interrupt.                                          */
      __IOM uint32_t GPIO33     : 1;            /*!< (@ 0x00000001) GPIO33 interrupt.                                          */
      __IOM uint32_t GPIO34     : 1;            /*!< (@ 0x00000002) GPIO34 interrupt.                                          */
      __IOM uint32_t GPIO35     : 1;            /*!< (@ 0x00000003) GPIO35 interrupt.                                          */
      __IOM uint32_t GPIO36     : 1;            /*!< (@ 0x00000004) GPIO36 interrupt.                                          */
      __IOM uint32_t GPIO37     : 1;            /*!< (@ 0x00000005) GPIO37 interrupt.                                          */
      __IOM uint32_t GPIO38     : 1;            /*!< (@ 0x00000006) GPIO38 interrupt.                                          */
      __IOM uint32_t GPIO39     : 1;            /*!< (@ 0x00000007) GPIO39 interrupt.                                          */
      __IOM uint32_t GPIO40     : 1;            /*!< (@ 0x00000008) GPIO40 interrupt.                                          */
      __IOM uint32_t GPIO41     : 1;            /*!< (@ 0x00000009) GPIO41 interrupt.                                          */
      __IOM uint32_t GPIO42     : 1;            /*!< (@ 0x0000000A) GPIO42 interrupt.                                          */
      __IOM uint32_t GPIO43     : 1;            /*!< (@ 0x0000000B) GPIO43 interrupt.                                          */
      __IOM uint32_t GPIO44     : 1;            /*!< (@ 0x0000000C) GPIO44 interrupt.                                          */
      __IOM uint32_t GPIO45     : 1;            /*!< (@ 0x0000000D) GPIO45 interrupt.                                          */
      __IOM uint32_t GPIO46     : 1;            /*!< (@ 0x0000000E) GPIO46 interrupt.                                          */
      __IOM uint32_t GPIO47     : 1;            /*!< (@ 0x0000000F) GPIO47 interrupt.                                          */
      __IOM uint32_t GPIO48     : 1;            /*!< (@ 0x00000010) GPIO48 interrupt.                                          */
      __IOM uint32_t GPIO49     : 1;            /*!< (@ 0x00000011) GPIO49 interrupt.                                          */
    } INT1EN_b;
  } ;
  
  union {
    __IOM uint32_t INT1STAT;                    /*!< (@ 0x00000214) GPIO Interrupt Registers 49-32: Status                     */
    
    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< (@ 0x00000000) GPIO32 interrupt.                                          */
      __IOM uint32_t GPIO33     : 1;            /*!< (@ 0x00000001) GPIO33 interrupt.                                          */
      __IOM uint32_t GPIO34     : 1;            /*!< (@ 0x00000002) GPIO34 interrupt.                                          */
      __IOM uint32_t GPIO35     : 1;            /*!< (@ 0x00000003) GPIO35 interrupt.                                          */
      __IOM uint32_t GPIO36     : 1;            /*!< (@ 0x00000004) GPIO36 interrupt.                                          */
      __IOM uint32_t GPIO37     : 1;            /*!< (@ 0x00000005) GPIO37 interrupt.                                          */
      __IOM uint32_t GPIO38     : 1;            /*!< (@ 0x00000006) GPIO38 interrupt.                                          */
      __IOM uint32_t GPIO39     : 1;            /*!< (@ 0x00000007) GPIO39 interrupt.                                          */
      __IOM uint32_t GPIO40     : 1;            /*!< (@ 0x00000008) GPIO40 interrupt.                                          */
      __IOM uint32_t GPIO41     : 1;            /*!< (@ 0x00000009) GPIO41 interrupt.                                          */
      __IOM uint32_t GPIO42     : 1;            /*!< (@ 0x0000000A) GPIO42 interrupt.                                          */
      __IOM uint32_t GPIO43     : 1;            /*!< (@ 0x0000000B) GPIO43 interrupt.                                          */
      __IOM uint32_t GPIO44     : 1;            /*!< (@ 0x0000000C) GPIO44 interrupt.                                          */
      __IOM uint32_t GPIO45     : 1;            /*!< (@ 0x0000000D) GPIO45 interrupt.                                          */
      __IOM uint32_t GPIO46     : 1;            /*!< (@ 0x0000000E) GPIO46 interrupt.                                          */
      __IOM uint32_t GPIO47     : 1;            /*!< (@ 0x0000000F) GPIO47 interrupt.                                          */
      __IOM uint32_t GPIO48     : 1;            /*!< (@ 0x00000010) GPIO48 interrupt.                                          */
      __IOM uint32_t GPIO49     : 1;            /*!< (@ 0x00000011) GPIO49 interrupt.                                          */
    } INT1STAT_b;
  } ;
  
  union {
    __IOM uint32_t INT1CLR;                     /*!< (@ 0x00000218) GPIO Interrupt Registers 49-32: Clear                      */
    
    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< (@ 0x00000000) GPIO32 interrupt.                                          */
      __IOM uint32_t GPIO33     : 1;            /*!< (@ 0x00000001) GPIO33 interrupt.                                          */
      __IOM uint32_t GPIO34     : 1;            /*!< (@ 0x00000002) GPIO34 interrupt.                                          */
      __IOM uint32_t GPIO35     : 1;            /*!< (@ 0x00000003) GPIO35 interrupt.                                          */
      __IOM uint32_t GPIO36     : 1;            /*!< (@ 0x00000004) GPIO36 interrupt.                                          */
      __IOM uint32_t GPIO37     : 1;            /*!< (@ 0x00000005) GPIO37 interrupt.                                          */
      __IOM uint32_t GPIO38     : 1;            /*!< (@ 0x00000006) GPIO38 interrupt.                                          */
      __IOM uint32_t GPIO39     : 1;            /*!< (@ 0x00000007) GPIO39 interrupt.                                          */
      __IOM uint32_t GPIO40     : 1;            /*!< (@ 0x00000008) GPIO40 interrupt.                                          */
      __IOM uint32_t GPIO41     : 1;            /*!< (@ 0x00000009) GPIO41 interrupt.                                          */
      __IOM uint32_t GPIO42     : 1;            /*!< (@ 0x0000000A) GPIO42 interrupt.                                          */
      __IOM uint32_t GPIO43     : 1;            /*!< (@ 0x0000000B) GPIO43 interrupt.                                          */
      __IOM uint32_t GPIO44     : 1;            /*!< (@ 0x0000000C) GPIO44 interrupt.                                          */
      __IOM uint32_t GPIO45     : 1;            /*!< (@ 0x0000000D) GPIO45 interrupt.                                          */
      __IOM uint32_t GPIO46     : 1;            /*!< (@ 0x0000000E) GPIO46 interrupt.                                          */
      __IOM uint32_t GPIO47     : 1;            /*!< (@ 0x0000000F) GPIO47 interrupt.                                          */
      __IOM uint32_t GPIO48     : 1;            /*!< (@ 0x00000010) GPIO48 interrupt.                                          */
      __IOM uint32_t GPIO49     : 1;            /*!< (@ 0x00000011) GPIO49 interrupt.                                          */
    } INT1CLR_b;
  } ;
  
  union {
    __IOM uint32_t INT1SET;                     /*!< (@ 0x0000021C) GPIO Interrupt Registers 49-32: Set                        */
    
    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< (@ 0x00000000) GPIO32 interrupt.                                          */
      __IOM uint32_t GPIO33     : 1;            /*!< (@ 0x00000001) GPIO33 interrupt.                                          */
      __IOM uint32_t GPIO34     : 1;            /*!< (@ 0x00000002) GPIO34 interrupt.                                          */
      __IOM uint32_t GPIO35     : 1;            /*!< (@ 0x00000003) GPIO35 interrupt.                                          */
      __IOM uint32_t GPIO36     : 1;            /*!< (@ 0x00000004) GPIO36 interrupt.                                          */
      __IOM uint32_t GPIO37     : 1;            /*!< (@ 0x00000005) GPIO37 interrupt.                                          */
      __IOM uint32_t GPIO38     : 1;            /*!< (@ 0x00000006) GPIO38 interrupt.                                          */
      __IOM uint32_t GPIO39     : 1;            /*!< (@ 0x00000007) GPIO39 interrupt.                                          */
      __IOM uint32_t GPIO40     : 1;            /*!< (@ 0x00000008) GPIO40 interrupt.                                          */
      __IOM uint32_t GPIO41     : 1;            /*!< (@ 0x00000009) GPIO41 interrupt.                                          */
      __IOM uint32_t GPIO42     : 1;            /*!< (@ 0x0000000A) GPIO42 interrupt.                                          */
      __IOM uint32_t GPIO43     : 1;            /*!< (@ 0x0000000B) GPIO43 interrupt.                                          */
      __IOM uint32_t GPIO44     : 1;            /*!< (@ 0x0000000C) GPIO44 interrupt.                                          */
      __IOM uint32_t GPIO45     : 1;            /*!< (@ 0x0000000D) GPIO45 interrupt.                                          */
      __IOM uint32_t GPIO46     : 1;            /*!< (@ 0x0000000E) GPIO46 interrupt.                                          */
      __IOM uint32_t GPIO47     : 1;            /*!< (@ 0x0000000F) GPIO47 interrupt.                                          */
      __IOM uint32_t GPIO48     : 1;            /*!< (@ 0x00000010) GPIO48 interrupt.                                          */
      __IOM uint32_t GPIO49     : 1;            /*!< (@ 0x00000011) GPIO49 interrupt.                                          */
    } INT1SET_b;
  } ;
} GPIO_Type;                                    /*!< Size = 544 (0x220)                                                        */



/* =========================================================================================================================== */
/* ================                                          IOMSTR0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief I2C/SPI Master (IOMSTR0)
  */

typedef struct {                                /*!< (@ 0x50004000) IOMSTR0 Structure                                          */
  
  union {
    __IOM uint32_t FIFO;                        /*!< (@ 0x00000000) FIFO Access Port                                           */
    
    struct {
      __IOM uint32_t FIFO       : 32;           /*!< (@ 0x00000000) FIFO access port.                                          */
    } FIFO_b;
  } ;
  __IM  uint32_t  RESERVED[63];
  
  union {
    __IOM uint32_t FIFOPTR;                     /*!< (@ 0x00000100) Current FIFO Pointers                                      */
    
    struct {
      __IOM uint32_t FIFOSIZ    : 8;            /*!< (@ 0x00000000) The number of bytes currently in the FIFO.                 */
      __IM  uint32_t            : 8;
      __IOM uint32_t FIFOREM    : 8;            /*!< (@ 0x00000010) The number of bytes remaining in the FIFO (i.e.
                                                                    128-FIFOSIZ if FULLDUP = 0 or 64-FIFOSIZ
                                                                    if FULLDUP = 1)).                                          */
    } FIFOPTR_b;
  } ;
  
  union {
    __IOM uint32_t TLNGTH;                      /*!< (@ 0x00000104) Transfer Length                                            */
    
    struct {
      __IOM uint32_t TLNGTH     : 12;           /*!< (@ 0x00000000) Remaining transfer length.                                 */
    } TLNGTH_b;
  } ;
  
  union {
    __IOM uint32_t FIFOTHR;                     /*!< (@ 0x00000108) FIFO Threshold Configuration                               */
    
    struct {
      __IOM uint32_t FIFORTHR   : 7;            /*!< (@ 0x00000000) FIFO read threshold.                                       */
      __IM  uint32_t            : 1;
      __IOM uint32_t FIFOWTHR   : 7;            /*!< (@ 0x00000008) FIFO write threshold.                                      */
    } FIFOTHR_b;
  } ;
  
  union {
    __IOM uint32_t CLKCFG;                      /*!< (@ 0x0000010C) I/O Clock Configuration                                    */
    
    struct {
      __IM  uint32_t            : 8;
      __IOM uint32_t FSEL       : 3;            /*!< (@ 0x00000008) Select the input clock frequency.                          */
      __IOM uint32_t DIV3       : 1;            /*!< (@ 0x0000000B) Enable divide by 3.                                        */
      __IOM uint32_t DIVEN      : 1;            /*!< (@ 0x0000000C) Enable clock division by TOTPER.                           */
      __IM  uint32_t            : 3;
      __IOM uint32_t LOWPER     : 8;            /*!< (@ 0x00000010) Clock low count minus 1.                                   */
      __IOM uint32_t TOTPER     : 8;            /*!< (@ 0x00000018) Clock total count minus 1.                                 */
    } CLKCFG_b;
  } ;
  
  union {
    __IOM uint32_t CMD;                         /*!< (@ 0x00000110) Command Register                                           */
    
    struct {
      __IOM uint32_t CMD        : 32;           /*!< (@ 0x00000000) This register holds the I/O Command                        */
    } CMD_b;
  } ;
  
  union {
    __IOM uint32_t CMDRPT;                      /*!< (@ 0x00000114) Command Repeat Register                                    */
    
    struct {
      __IOM uint32_t CMDRPT     : 5;            /*!< (@ 0x00000000) These bits hold the Command repeat count.                  */
    } CMDRPT_b;
  } ;
  
  union {
    __IOM uint32_t STATUS;                      /*!< (@ 0x00000118) Status Register                                            */
    
    struct {
      __IOM uint32_t ERR        : 1;            /*!< (@ 0x00000000) This bit indicates if an error interrupt has
                                                                    occurred.                                                  */
      __IOM uint32_t CMDACT     : 1;            /*!< (@ 0x00000001) This bit indicates if the I/O Command is active.           */
      __IOM uint32_t IDLEST     : 1;            /*!< (@ 0x00000002) This bit indicates if the I/O state machine is
                                                                    IDLE.                                                      */
    } STATUS_b;
  } ;
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x0000011C) I/O Master Configuration                                   */
    
    struct {
      __IOM uint32_t IFCSEL     : 1;            /*!< (@ 0x00000000) This bit selects the I/O interface.                        */
      __IOM uint32_t SPOL       : 1;            /*!< (@ 0x00000001) This bit selects SPI polarity.                             */
      __IOM uint32_t SPHA       : 1;            /*!< (@ 0x00000002) This bit selects SPI phase.                                */
      __IOM uint32_t FULLDUP    : 1;            /*!< (@ 0x00000003) This bit selects full duplex mode.                         */
      __IOM uint32_t STARTRD    : 2;            /*!< (@ 0x00000004) This bit selects the preread timing.                       */
      __IM  uint32_t            : 2;
      __IOM uint32_t WTFC       : 1;            /*!< (@ 0x00000008) This bit enables write mode flow control.                  */
      __IOM uint32_t RDFC       : 1;            /*!< (@ 0x00000009) This bit enables read mode flow control.                   */
      __IOM uint32_t MOSIINV    : 1;            /*!< (@ 0x0000000A) This bit invewrts MOSI when flow control is enabled.       */
      __IOM uint32_t FCDEL      : 1;            /*!< (@ 0x0000000B) This bit must be left at the default value of
                                                                    0.                                                         */
      __IOM uint32_t WTFCIRQ    : 1;            /*!< (@ 0x0000000C) This bit selects the write mode flow control
                                                                    signal.                                                    */
      __IOM uint32_t WTFCPOL    : 1;            /*!< (@ 0x0000000D) This bit selects the write flow control signal
                                                                    polarity.                                                  */
      __IOM uint32_t RDFCPOL    : 1;            /*!< (@ 0x0000000E) This bit selects the read flow control signal
                                                                    polarity.                                                  */
      __IM  uint32_t            : 16;
      __IOM uint32_t IFCEN      : 1;            /*!< (@ 0x0000001F) This bit enables the IO Master.                            */
    } CFG_b;
  } ;
  __IM  uint32_t  RESERVED1[56];
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) IO Master Interrupts: Enable                               */
    
    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< (@ 0x00000000) This is the Command Complete interrupt.                    */
      __IOM uint32_t THR        : 1;            /*!< (@ 0x00000001) This is the FIFO Threshold interrupt.                      */
      __IOM uint32_t FUNDFL     : 1;            /*!< (@ 0x00000002) This is the Read FIFO Underflow interrupt. An
                                                                    attempt was made to read FIFO when empty
                                                                    (i.e. while FIFOSIZ less than 4).                          */
      __IOM uint32_t FOVFL      : 1;            /*!< (@ 0x00000003) This is the Write FIFO Overflow interrupt. An
                                                                    attempt was made to write the FIFO while
                                                                    it was full (i.e. while FIFOSIZ > 124).                    */
      __IOM uint32_t NAK        : 1;            /*!< (@ 0x00000004) This is the I2C NAK interrupt. The expected ACK
                                                                    from the slave was not received by the
                                                                    IOM.                                                       */
      __IOM uint32_t WTLEN      : 1;            /*!< (@ 0x00000005) This is the WTLEN interrupt.                               */
      __IOM uint32_t IACC       : 1;            /*!< (@ 0x00000006) This is the illegal FIFO access interrupt. An
                                                                    attempt was made to read the FIFO during
                                                                    a write CMD. Or an attempt was made to
                                                                    write the FIFO on a read CMD.                              */
      __IOM uint32_t ICMD       : 1;            /*!< (@ 0x00000007) This is the illegal command interrupt. Software
                                                                    attempted to issue a CMD while another
                                                                    CMD was already in progress. Or an attempt
                                                                    was made to issue a non-zero-length write
                                                                    CMD with an empty FIFO.                                    */
      __IOM uint32_t START      : 1;            /*!< (@ 0x00000008) This is the START command interrupt. A START
                                                                    from another master was detected. Software
                                                                    must wait for a STOP before proceeding.                    */
      __IOM uint32_t STOP       : 1;            /*!< (@ 0x00000009) This is the STOP command interrupt. A STOP bit
                                                                    was detected by the IOM.                                   */
      __IOM uint32_t ARB        : 1;            /*!< (@ 0x0000000A) This is the arbitration loss interrupt. This
                                                                    error occurs if another master collides
                                                                    with an IO Master transfer. Generally,
                                                                    the IOM started an operation but found
                                                                    SDA already low.                                           */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) IO Master Interrupts: Status                               */
    
    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< (@ 0x00000000) This is the Command Complete interrupt.                    */
      __IOM uint32_t THR        : 1;            /*!< (@ 0x00000001) This is the FIFO Threshold interrupt.                      */
      __IOM uint32_t FUNDFL     : 1;            /*!< (@ 0x00000002) This is the Read FIFO Underflow interrupt. An
                                                                    attempt was made to read FIFO when empty
                                                                    (i.e. while FIFOSIZ less than 4).                          */
      __IOM uint32_t FOVFL      : 1;            /*!< (@ 0x00000003) This is the Write FIFO Overflow interrupt. An
                                                                    attempt was made to write the FIFO while
                                                                    it was full (i.e. while FIFOSIZ > 124).                    */
      __IOM uint32_t NAK        : 1;            /*!< (@ 0x00000004) This is the I2C NAK interrupt. The expected ACK
                                                                    from the slave was not received by the
                                                                    IOM.                                                       */
      __IOM uint32_t WTLEN      : 1;            /*!< (@ 0x00000005) This is the WTLEN interrupt.                               */
      __IOM uint32_t IACC       : 1;            /*!< (@ 0x00000006) This is the illegal FIFO access interrupt. An
                                                                    attempt was made to read the FIFO during
                                                                    a write CMD. Or an attempt was made to
                                                                    write the FIFO on a read CMD.                              */
      __IOM uint32_t ICMD       : 1;            /*!< (@ 0x00000007) This is the illegal command interrupt. Software
                                                                    attempted to issue a CMD while another
                                                                    CMD was already in progress. Or an attempt
                                                                    was made to issue a non-zero-length write
                                                                    CMD with an empty FIFO.                                    */
      __IOM uint32_t START      : 1;            /*!< (@ 0x00000008) This is the START command interrupt. A START
                                                                    from another master was detected. Software
                                                                    must wait for a STOP before proceeding.                    */
      __IOM uint32_t STOP       : 1;            /*!< (@ 0x00000009) This is the STOP command interrupt. A STOP bit
                                                                    was detected by the IOM.                                   */
      __IOM uint32_t ARB        : 1;            /*!< (@ 0x0000000A) This is the arbitration loss interrupt. This
                                                                    error occurs if another master collides
                                                                    with an IO Master transfer. Generally,
                                                                    the IOM started an operation but found
                                                                    SDA already low.                                           */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) IO Master Interrupts: Clear                                */
    
    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< (@ 0x00000000) This is the Command Complete interrupt.                    */
      __IOM uint32_t THR        : 1;            /*!< (@ 0x00000001) This is the FIFO Threshold interrupt.                      */
      __IOM uint32_t FUNDFL     : 1;            /*!< (@ 0x00000002) This is the Read FIFO Underflow interrupt. An
                                                                    attempt was made to read FIFO when empty
                                                                    (i.e. while FIFOSIZ less than 4).                          */
      __IOM uint32_t FOVFL      : 1;            /*!< (@ 0x00000003) This is the Write FIFO Overflow interrupt. An
                                                                    attempt was made to write the FIFO while
                                                                    it was full (i.e. while FIFOSIZ > 124).                    */
      __IOM uint32_t NAK        : 1;            /*!< (@ 0x00000004) This is the I2C NAK interrupt. The expected ACK
                                                                    from the slave was not received by the
                                                                    IOM.                                                       */
      __IOM uint32_t WTLEN      : 1;            /*!< (@ 0x00000005) This is the WTLEN interrupt.                               */
      __IOM uint32_t IACC       : 1;            /*!< (@ 0x00000006) This is the illegal FIFO access interrupt. An
                                                                    attempt was made to read the FIFO during
                                                                    a write CMD. Or an attempt was made to
                                                                    write the FIFO on a read CMD.                              */
      __IOM uint32_t ICMD       : 1;            /*!< (@ 0x00000007) This is the illegal command interrupt. Software
                                                                    attempted to issue a CMD while another
                                                                    CMD was already in progress. Or an attempt
                                                                    was made to issue a non-zero-length write
                                                                    CMD with an empty FIFO.                                    */
      __IOM uint32_t START      : 1;            /*!< (@ 0x00000008) This is the START command interrupt. A START
                                                                    from another master was detected. Software
                                                                    must wait for a STOP before proceeding.                    */
      __IOM uint32_t STOP       : 1;            /*!< (@ 0x00000009) This is the STOP command interrupt. A STOP bit
                                                                    was detected by the IOM.                                   */
      __IOM uint32_t ARB        : 1;            /*!< (@ 0x0000000A) This is the arbitration loss interrupt. This
                                                                    error occurs if another master collides
                                                                    with an IO Master transfer. Generally,
                                                                    the IOM started an operation but found
                                                                    SDA already low.                                           */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) IO Master Interrupts: Set                                  */
    
    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< (@ 0x00000000) This is the Command Complete interrupt.                    */
      __IOM uint32_t THR        : 1;            /*!< (@ 0x00000001) This is the FIFO Threshold interrupt.                      */
      __IOM uint32_t FUNDFL     : 1;            /*!< (@ 0x00000002) This is the Read FIFO Underflow interrupt. An
                                                                    attempt was made to read FIFO when empty
                                                                    (i.e. while FIFOSIZ less than 4).                          */
      __IOM uint32_t FOVFL      : 1;            /*!< (@ 0x00000003) This is the Write FIFO Overflow interrupt. An
                                                                    attempt was made to write the FIFO while
                                                                    it was full (i.e. while FIFOSIZ > 124).                    */
      __IOM uint32_t NAK        : 1;            /*!< (@ 0x00000004) This is the I2C NAK interrupt. The expected ACK
                                                                    from the slave was not received by the
                                                                    IOM.                                                       */
      __IOM uint32_t WTLEN      : 1;            /*!< (@ 0x00000005) This is the WTLEN interrupt.                               */
      __IOM uint32_t IACC       : 1;            /*!< (@ 0x00000006) This is the illegal FIFO access interrupt. An
                                                                    attempt was made to read the FIFO during
                                                                    a write CMD. Or an attempt was made to
                                                                    write the FIFO on a read CMD.                              */
      __IOM uint32_t ICMD       : 1;            /*!< (@ 0x00000007) This is the illegal command interrupt. Software
                                                                    attempted to issue a CMD while another
                                                                    CMD was already in progress. Or an attempt
                                                                    was made to issue a non-zero-length write
                                                                    CMD with an empty FIFO.                                    */
      __IOM uint32_t START      : 1;            /*!< (@ 0x00000008) This is the START command interrupt. A START
                                                                    from another master was detected. Software
                                                                    must wait for a STOP before proceeding.                    */
      __IOM uint32_t STOP       : 1;            /*!< (@ 0x00000009) This is the STOP command interrupt. A STOP bit
                                                                    was detected by the IOM.                                   */
      __IOM uint32_t ARB        : 1;            /*!< (@ 0x0000000A) This is the arbitration loss interrupt. This
                                                                    error occurs if another master collides
                                                                    with an IO Master transfer. Generally,
                                                                    the IOM started an operation but found
                                                                    SDA already low.                                           */
    } INTSET_b;
  } ;
} IOMSTR0_Type;                                 /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                          IOSLAVE                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief I2C/SPI Slave (IOSLAVE)
  */

typedef struct {                                /*!< (@ 0x50000000) IOSLAVE Structure                                          */
  __IM  uint32_t  RESERVED[64];
  
  union {
    __IOM uint32_t FIFOPTR;                     /*!< (@ 0x00000100) Current FIFO Pointer                                       */
    
    struct {
      __IOM uint32_t FIFOPTR    : 8;            /*!< (@ 0x00000000) Current FIFO pointer.                                      */
      __IOM uint32_t FIFOSIZ    : 8;            /*!< (@ 0x00000008) The number of bytes currently in the hardware
                                                                    FIFO.                                                      */
    } FIFOPTR_b;
  } ;
  
  union {
    __IOM uint32_t FIFOCFG;                     /*!< (@ 0x00000104) FIFO Configuration                                         */
    
    struct {
      __IOM uint32_t FIFOBASE   : 5;            /*!< (@ 0x00000000) These bits hold the base address of the I/O FIFO
                                                                    in 8 byte segments. The IO Slave FIFO is
                                                                    situated in LRAM at (FIFOBASE*8) to (FIFOMAX*8-1).         */
      __IM  uint32_t            : 3;
      __IOM uint32_t FIFOMAX    : 6;            /*!< (@ 0x00000008) These bits hold the maximum FIFO address in 8
                                                                    byte segments. It is also the beginning
                                                                    of the RAM area of the LRAM. Note that
                                                                    no RAM area is configured if FIFOMAX is
                                                                    set to 0x1F.                                               */
      __IM  uint32_t            : 10;
      __IOM uint32_t ROBASE     : 6;            /*!< (@ 0x00000018) Defines the read-only area. The IO Slave read-only
                                                                    area is situated in LRAM at (ROBASE*8)
                                                                    to (FIFOOBASE*8-1)                                         */
    } FIFOCFG_b;
  } ;
  
  union {
    __IOM uint32_t FIFOTHR;                     /*!< (@ 0x00000108) FIFO Threshold Configuration                               */
    
    struct {
      __IOM uint32_t FIFOTHR    : 8;            /*!< (@ 0x00000000) FIFO size interrupt threshold.                             */
    } FIFOTHR_b;
  } ;
  
  union {
    __IOM uint32_t FUPD;                        /*!< (@ 0x0000010C) FIFO Update Status                                         */
    
    struct {
      __IOM uint32_t FIFOUPD    : 1;            /*!< (@ 0x00000000) This bit indicates that a FIFO update is underway.         */
      __IOM uint32_t IOREAD     : 1;            /*!< (@ 0x00000001) This bitfield indicates an IO read is active.              */
    } FUPD_b;
  } ;
  
  union {
    __IOM uint32_t FIFOCTR;                     /*!< (@ 0x00000110) Overall FIFO Counter                                       */
    
    struct {
      __IOM uint32_t FIFOCTR    : 10;           /*!< (@ 0x00000000) Virtual FIFO byte count                                    */
    } FIFOCTR_b;
  } ;
  
  union {
    __IOM uint32_t FIFOINC;                     /*!< (@ 0x00000114) Overall FIFO Counter Increment                             */
    
    struct {
      __IOM uint32_t FIFOINC    : 10;           /*!< (@ 0x00000000) Increment the Overall FIFO Counter by this value
                                                                    on a write                                                 */
    } FIFOINC_b;
  } ;
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000118) I/O Slave Configuration                                    */
    
    struct {
      __IOM uint32_t IFCSEL     : 1;            /*!< (@ 0x00000000) This bit selects the I/O interface.                        */
      __IOM uint32_t SPOL       : 1;            /*!< (@ 0x00000001) This bit selects SPI polarity.                             */
      __IOM uint32_t LSB        : 1;            /*!< (@ 0x00000002) This bit selects the transfer bit ordering.                */
      __IM  uint32_t            : 1;
      __IOM uint32_t STARTRD    : 1;            /*!< (@ 0x00000004) This bit holds the cycle to initiate an I/O RAM
                                                                    read.                                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t I2CADDR    : 12;           /*!< (@ 0x00000008) 7-bit or 10-bit I2C device address.                        */
      __IM  uint32_t            : 11;
      __IOM uint32_t IFCEN      : 1;            /*!< (@ 0x0000001F) IOSLAVE interface enable.                                  */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t PRENC;                       /*!< (@ 0x0000011C) I/O Slave Interrupt Priority Encode                        */
    
    struct {
      __IOM uint32_t PRENC      : 5;            /*!< (@ 0x00000000) These bits hold the priority encode of the REGACC
                                                                    interrupts.                                                */
    } PRENC_b;
  } ;
  
  union {
    __IOM uint32_t IOINTCTL;                    /*!< (@ 0x00000120) I/O Interrupt Control                                      */
    
    struct {
      __IOM uint32_t IOINTEN    : 8;            /*!< (@ 0x00000000) These read-only bits indicate whether the IOINT
                                                                    interrupts are enabled.                                    */
      __IOM uint32_t IOINT      : 8;            /*!< (@ 0x00000008) These bits read the IOINT interrupts.                      */
      __IOM uint32_t IOINTCLR   : 1;            /*!< (@ 0x00000010) This bit clears all of the IOINT interrupts when
                                                                    written with a 1.                                          */
      __IM  uint32_t            : 7;
      __IOM uint32_t IOINTSET   : 8;            /*!< (@ 0x00000018) These bits set the IOINT interrupts when written
                                                                    with a 1.                                                  */
    } IOINTCTL_b;
  } ;
  
  union {
    __IOM uint32_t GENADD;                      /*!< (@ 0x00000124) General Address Data                                       */
    
    struct {
      __IOM uint32_t GADATA     : 8;            /*!< (@ 0x00000000) The data supplied on the last General Address
                                                                    reference.                                                 */
    } GENADD_b;
  } ;
  __IM  uint32_t  RESERVED1[54];
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) IO Slave Interrupts: Enable                                */
    
    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< (@ 0x00000000) FIFO Size interrupt.                                       */
      __IOM uint32_t FOVFL      : 1;            /*!< (@ 0x00000001) FIFO Overflow interrupt.                                   */
      __IOM uint32_t FUNDFL     : 1;            /*!< (@ 0x00000002) FIFO Underflow interrupt.                                  */
      __IOM uint32_t FRDERR     : 1;            /*!< (@ 0x00000003) FIFO Read Error interrupt.                                 */
      __IOM uint32_t GENAD      : 1;            /*!< (@ 0x00000004) I2C General Address interrupt.                             */
      __IOM uint32_t IOINTW     : 1;            /*!< (@ 0x00000005) I2C Interrupt Write interrupt.                             */
      __IOM uint32_t XCMPRF     : 1;            /*!< (@ 0x00000006) Transfer complete interrupt, read from FIFO space.         */
      __IOM uint32_t XCMPRR     : 1;            /*!< (@ 0x00000007) Transfer complete interrupt, read from register
                                                                    space.                                                     */
      __IOM uint32_t XCMPWF     : 1;            /*!< (@ 0x00000008) Transfer complete interrupt, write to FIFO space.          */
      __IOM uint32_t XCMPWR     : 1;            /*!< (@ 0x00000009) Transfer complete interrupt, write to register
                                                                    space.                                                     */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) IO Slave Interrupts: Status                                */
    
    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< (@ 0x00000000) FIFO Size interrupt.                                       */
      __IOM uint32_t FOVFL      : 1;            /*!< (@ 0x00000001) FIFO Overflow interrupt.                                   */
      __IOM uint32_t FUNDFL     : 1;            /*!< (@ 0x00000002) FIFO Underflow interrupt.                                  */
      __IOM uint32_t FRDERR     : 1;            /*!< (@ 0x00000003) FIFO Read Error interrupt.                                 */
      __IOM uint32_t GENAD      : 1;            /*!< (@ 0x00000004) I2C General Address interrupt.                             */
      __IOM uint32_t IOINTW     : 1;            /*!< (@ 0x00000005) I2C Interrupt Write interrupt.                             */
      __IOM uint32_t XCMPRF     : 1;            /*!< (@ 0x00000006) Transfer complete interrupt, read from FIFO space.         */
      __IOM uint32_t XCMPRR     : 1;            /*!< (@ 0x00000007) Transfer complete interrupt, read from register
                                                                    space.                                                     */
      __IOM uint32_t XCMPWF     : 1;            /*!< (@ 0x00000008) Transfer complete interrupt, write to FIFO space.          */
      __IOM uint32_t XCMPWR     : 1;            /*!< (@ 0x00000009) Transfer complete interrupt, write to register
                                                                    space.                                                     */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) IO Slave Interrupts: Clear                                 */
    
    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< (@ 0x00000000) FIFO Size interrupt.                                       */
      __IOM uint32_t FOVFL      : 1;            /*!< (@ 0x00000001) FIFO Overflow interrupt.                                   */
      __IOM uint32_t FUNDFL     : 1;            /*!< (@ 0x00000002) FIFO Underflow interrupt.                                  */
      __IOM uint32_t FRDERR     : 1;            /*!< (@ 0x00000003) FIFO Read Error interrupt.                                 */
      __IOM uint32_t GENAD      : 1;            /*!< (@ 0x00000004) I2C General Address interrupt.                             */
      __IOM uint32_t IOINTW     : 1;            /*!< (@ 0x00000005) I2C Interrupt Write interrupt.                             */
      __IOM uint32_t XCMPRF     : 1;            /*!< (@ 0x00000006) Transfer complete interrupt, read from FIFO space.         */
      __IOM uint32_t XCMPRR     : 1;            /*!< (@ 0x00000007) Transfer complete interrupt, read from register
                                                                    space.                                                     */
      __IOM uint32_t XCMPWF     : 1;            /*!< (@ 0x00000008) Transfer complete interrupt, write to FIFO space.          */
      __IOM uint32_t XCMPWR     : 1;            /*!< (@ 0x00000009) Transfer complete interrupt, write to register
                                                                    space.                                                     */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) IO Slave Interrupts: Set                                   */
    
    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< (@ 0x00000000) FIFO Size interrupt.                                       */
      __IOM uint32_t FOVFL      : 1;            /*!< (@ 0x00000001) FIFO Overflow interrupt.                                   */
      __IOM uint32_t FUNDFL     : 1;            /*!< (@ 0x00000002) FIFO Underflow interrupt.                                  */
      __IOM uint32_t FRDERR     : 1;            /*!< (@ 0x00000003) FIFO Read Error interrupt.                                 */
      __IOM uint32_t GENAD      : 1;            /*!< (@ 0x00000004) I2C General Address interrupt.                             */
      __IOM uint32_t IOINTW     : 1;            /*!< (@ 0x00000005) I2C Interrupt Write interrupt.                             */
      __IOM uint32_t XCMPRF     : 1;            /*!< (@ 0x00000006) Transfer complete interrupt, read from FIFO space.         */
      __IOM uint32_t XCMPRR     : 1;            /*!< (@ 0x00000007) Transfer complete interrupt, read from register
                                                                    space.                                                     */
      __IOM uint32_t XCMPWF     : 1;            /*!< (@ 0x00000008) Transfer complete interrupt, write to FIFO space.          */
      __IOM uint32_t XCMPWR     : 1;            /*!< (@ 0x00000009) Transfer complete interrupt, write to register
                                                                    space.                                                     */
    } INTSET_b;
  } ;
  
  union {
    __IOM uint32_t REGACCINTEN;                 /*!< (@ 0x00000210) Register Access Interrupts: Enable                         */
    
    struct {
      __IOM uint32_t REGACC     : 32;           /*!< (@ 0x00000000) Register access interrupts.                                */
    } REGACCINTEN_b;
  } ;
  
  union {
    __IOM uint32_t REGACCINTSTAT;               /*!< (@ 0x00000214) Register Access Interrupts: Status                         */
    
    struct {
      __IOM uint32_t REGACC     : 32;           /*!< (@ 0x00000000) Register access interrupts.                                */
    } REGACCINTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t REGACCINTCLR;                /*!< (@ 0x00000218) Register Access Interrupts: Clear                          */
    
    struct {
      __IOM uint32_t REGACC     : 32;           /*!< (@ 0x00000000) Register access interrupts.                                */
    } REGACCINTCLR_b;
  } ;
  
  union {
    __IOM uint32_t REGACCINTSET;                /*!< (@ 0x0000021C) Register Access Interrupts: Set                            */
    
    struct {
      __IOM uint32_t REGACC     : 32;           /*!< (@ 0x00000000) Register access interrupts.                                */
    } REGACCINTSET_b;
  } ;
} IOSLAVE_Type;                                 /*!< Size = 544 (0x220)                                                        */



/* =========================================================================================================================== */
/* ================                                          MCUCTRL                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief MCU Miscellaneous Control Logic (MCUCTRL)
  */

typedef struct {                                /*!< (@ 0x40020000) MCUCTRL Structure                                          */
  
  union {
    __IOM uint32_t CHIP_INFO;                   /*!< (@ 0x00000000) Chip Information Register                                  */
    
    struct {
      __IOM uint32_t PARTNUM    : 32;           /*!< (@ 0x00000000) BCD part number.                                           */
    } CHIP_INFO_b;
  } ;
  
  union {
    __IOM uint32_t CHIPID0;                     /*!< (@ 0x00000004) Unique Chip ID 0                                           */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Unique chip ID 0.                                          */
    } CHIPID0_b;
  } ;
  
  union {
    __IOM uint32_t CHIPID1;                     /*!< (@ 0x00000008) Unique Chip ID 1                                           */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Unique chip ID 1.                                          */
    } CHIPID1_b;
  } ;
  
  union {
    __IOM uint32_t CHIPREV;                     /*!< (@ 0x0000000C) Chip Revision                                              */
    
    struct {
      __IOM uint32_t REVMIN     : 4;            /*!< (@ 0x00000000) Minor Revision ID.                                         */
      __IOM uint32_t REVMAJ     : 4;            /*!< (@ 0x00000004) Major Revision ID.                                         */
    } CHIPREV_b;
  } ;
  
  union {
    __IOM uint32_t VENDORID;                    /*!< (@ 0x00000010) Unique Vendor ID                                           */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Unique Vendor ID                                           */
    } VENDORID_b;
  } ;
  
  union {
    __IOM uint32_t DEBUGGER;                    /*!< (@ 0x00000014) Debugger Access Control                                    */
    
    struct {
      __IOM uint32_t LOCKOUT    : 1;            /*!< (@ 0x00000000) Lockout of debugger (SWD).                                 */
    } DEBUGGER_b;
  } ;
  __IM  uint32_t  RESERVED[18];
  
  union {
    __IOM uint32_t BUCK;                        /*!< (@ 0x00000060) Analog Buck Control                                        */
    
    struct {
      __IOM uint32_t BUCKSWE    : 1;            /*!< (@ 0x00000000) Buck Register Software Override Enable. This
                                                                    will enable the override values for MEMBUCKPWD,
                                                                    COREBUCKPWD, COREBUCKRST, MEMBUCKRST, all
                                                                    to be propagated to the control logic,
                                                                    instead of the normal power control module
                                                                    signal. Note - Must take care to have correct
                                                                    value for ALL the register bits when this
                                                                    SWE is enabled.                                            */
      __IOM uint32_t BYPBUCKCORE : 1;           /*!< (@ 0x00000001) Not used. Additional control of buck is available
                                                                    in the power control module                                */
      __IOM uint32_t COREBUCKPWD : 1;           /*!< (@ 0x00000002) Core buck power down override. 1=Powered Down;
                                                                    0=Enabled; Value is propagated only when
                                                                    the BUCKSWE bit is active, otherwise control
                                                                    is from the power control module.                          */
      __IOM uint32_t SLEEPBUCKANA : 1;          /*!< (@ 0x00000003) HFRC clkgen bit 0 override. When set, this will
                                                                    override to 0 bit 0 of the hfrc_freq_clkgen
                                                                    internal bus (see internal Shelby-1473)                    */
      __IOM uint32_t MEMBUCKPWD : 1;            /*!< (@ 0x00000004) Memory buck power down override. 1=Powered Down;
                                                                    0=Enabled; Value is propagated only when
                                                                    the BUCKSWE bit is active, otherwise control
                                                                    is from the power control module.                          */
      __IOM uint32_t BYPBUCKMEM : 1;            /*!< (@ 0x00000005) Not used. Additional control of buck is available
                                                                    in the power control module                                */
      __IOM uint32_t COREBUCKRST : 1;           /*!< (@ 0x00000006) Reset control override for Core Buck; 0=enabled,
                                                                    1=reset; Value is propagated only when
                                                                    the BUCKSWE bit is active, otherwise control
                                                                    is from the power control module.                          */
      __IOM uint32_t MEMBUCKRST : 1;            /*!< (@ 0x00000007) Reset control override for Mem Buck; 0=enabled,
                                                                    1=reset; Value is propagated only when
                                                                    the BUCKSWE bit is active, otherwise contrl
                                                                    is from the power control module.                          */
    } BUCK_b;
  } ;
  
  union {
    __IOM uint32_t BUCK2;                       /*!< (@ 0x00000064) Buck Control Reg2                                          */
    
    struct {
      __IOM uint32_t BCORETONSEL : 4;           /*!< (@ 0x00000000) Core Buck low turn on trim                                 */
      __IOM uint32_t BMEMTONSEL : 4;            /*!< (@ 0x00000004) Flash Buck high turn on trim                               */
      __IOM uint32_t HYSTBUCKMEM : 1;           /*!< (@ 0x00000008) Enable/disable hysteresis on memory buck converters
                                                                    internal comparators.                                      */
      __IOM uint32_t HYSTBUCKCORE : 1;          /*!< (@ 0x00000009) Enable/disable hysteresis on core buck converters
                                                                    internal comparators.                                      */
      __IOM uint32_t BUCKLFCLKSEL : 2;          /*!< (@ 0x0000000A) Buck clkgen divider trim. 00 = 1.5MHz; 01 = 750kHz;
                                                                    10 = 375kHz; 11 = 187.5kHz                                 */
    } BUCK2_b;
  } ;
  
  union {
    __IOM uint32_t BUCK3;                       /*!< (@ 0x00000068) Buck control reg 3                                         */
    
    struct {
      __IOM uint32_t COREBUCKHYSTTRIM : 2;      /*!< (@ 0x00000000) Hysterisis trim for core buck                              */
      __IOM uint32_t COREBUCKZXTRIM : 4;        /*!< (@ 0x00000002) Core buck zero crossing trim value                         */
      __IOM uint32_t COREBUCKBURSTEN : 1;       /*!< (@ 0x00000006) Core Buck burst enable. 0=disabled, 1=enabled              */
      __IOM uint32_t COREBUCKLOTON : 4;         /*!< (@ 0x00000007) Core Buck low TON trim value                               */
      __IOM uint32_t MEMBUCKHYSTTRIM : 2;       /*!< (@ 0x0000000B) Hysterisis trim for mem buck                               */
      __IOM uint32_t MEMBUCKZXTRIM : 4;         /*!< (@ 0x0000000D) Memory buck zero crossing trim value                       */
      __IOM uint32_t MEMBUCKBURSTEN : 1;        /*!< (@ 0x00000011) MEM Buck burst enable 0=disable, 0=disabled,
                                                                    1=enable.                                                  */
      __IOM uint32_t MEMBUCKLOTON : 4;          /*!< (@ 0x00000012) MEM Buck low TON trim value                                */
    } BUCK3_b;
  } ;
  __IM  uint32_t  RESERVED1[5];
  
  union {
    __IOM uint32_t LDOREG1;                     /*!< (@ 0x00000080) Analog LDO Reg 1                                           */
    
    struct {
      __IOM uint32_t TRIMCORELDOR1 : 10;        /*!< (@ 0x00000000) CORE LDO Active mode ouput trim (R1).                      */
      __IOM uint32_t TRIMCORELDOR3 : 4;         /*!< (@ 0x0000000A) CORE LDO tempco trim (R3).                                 */
      __IOM uint32_t CORELDOLPTRIM : 6;         /*!< (@ 0x0000000E) CORE LDO Low Power Trim                                    */
      __IOM uint32_t CORELDOIBSTRM : 1;         /*!< (@ 0x00000014) CORE LDO IBIAS Trim                                        */
    } LDOREG1_b;
  } ;
  
  union {
    __IOM uint32_t LDOREG2;                     /*!< (@ 0x00000084) LDO Control Register 2                                     */
    
    struct {
      __IOM uint32_t LDO2SWE    : 1;            /*!< (@ 0x00000000) LDO2 Software Override Enable. If enabled (=1),
                                                                    this will enable the override values from
                                                                    this register to be used instead of the
                                                                    normal control signals for the following
                                                                    fields: CORELDOVDDLEN, RAMLDOLPMODE, PWDRAMLDO,
                                                                    PWDANALDO, PWDMEMLDO, PWDCORELDO, SLEEPANALDO,
                                                                    SLEEPMEMLDO, SLEEPCORELDO.                                 */
      __IOM uint32_t RAMLDOTRIM : 5;            /*!< (@ 0x00000001) RAM LDO TRIM                                               */
      __IOM uint32_t TRIMANALDO : 4;            /*!< (@ 0x00000006) Analog LDO Trim.                                           */
      __IOM uint32_t VREFSELCORELDO : 1;        /*!< (@ 0x0000000A) CONTROL BIT IS NOT USED. PLEASE TREAT AS RESERVED          */
      __IOM uint32_t VREFSELFLASHLDO : 1;       /*!< (@ 0x0000000B) CONTROL BIT IS NOT USED. PLEASE TREAT AS RESERVED          */
      __IOM uint32_t VREFSELSRAMLDO : 1;        /*!< (@ 0x0000000C) CONTROL BIT IS NOT USED. PLEASE TREAT AS RESERVED          */
      __IOM uint32_t VREFSELANALDO : 1;         /*!< (@ 0x0000000D) CONTROL BIT IS NOT USED. PLEASE TREAT AS RESERVED          */
      __IOM uint32_t SLEEPCORELDO : 1;          /*!< (@ 0x0000000E) CORE LDO Sleep. This value is propagated only
                                                                    when LDO2SWE bit is active(1).                             */
      __IOM uint32_t SLEEPMEMLDO : 1;           /*!< (@ 0x0000000F) FLASH LDO Sleep. This value is propagated only
                                                                    when LDO2SWE bit is active(1).                             */
      __IOM uint32_t SLEEPANALDO : 1;           /*!< (@ 0x00000010) Analog LDO Sleep. This value is propagated only
                                                                    when LDO2SWE bit is active(1).                             */
      __IOM uint32_t PWDCORELDO : 1;            /*!< (@ 0x00000011) CORE LDO Power Down. This value is propagated
                                                                    only when LDO2SWE bit is active(1).                        */
      __IOM uint32_t PWDMEMLDO  : 1;            /*!< (@ 0x00000012) MEM LDO Power Down. This value is propagated
                                                                    only when LDO2SWE bit is active(1).                        */
      __IOM uint32_t PWDANALDO  : 1;            /*!< (@ 0x00000013) Analog LDO Power Down. This value is propagated
                                                                    only when LDO2SWE bit is active(1).                        */
      __IOM uint32_t PWDRAMLDO  : 1;            /*!< (@ 0x00000014) RAM LDO Power Down. 0=powered up, 1=powered down
                                                                    ; This value is propagated only when LDO2SWE
                                                                    bit is active(1).                                          */
      __IOM uint32_t RAMLDOLPMODE : 1;          /*!< (@ 0x00000015) RAM LDO LP Mode. 0=normal mode, 1=low power mode;
                                                                    This value is propagated only when LDO2SWE
                                                                    bit is active(1).                                          */
      __IOM uint32_t CORELDOVDDLEN : 1;         /*!< (@ 0x00000016) Core LDO output enable. 0=Hi-Z, 1=enable. This
                                                                    value is propagated only when LDO2SWE bit
                                                                    is active(1).                                              */
    } LDOREG2_b;
  } ;
  
  union {
    __IOM uint32_t LDOREG3;                     /*!< (@ 0x00000088) LDO Control Register 3                                     */
    
    struct {
      __IOM uint32_t MEMLDOLPTRIM : 6;          /*!< (@ 0x00000000) MEM LDO TRIM for low power mode with ADC inactive          */
      __IOM uint32_t MEMLDOLPALTTRIM : 6;       /*!< (@ 0x00000006) MEM LDO TRIM for low power mode with ADC active            */
      __IOM uint32_t TRIMMEMLDOR1 : 6;          /*!< (@ 0x0000000C) MEM LDO active mode trim (R1).                             */
    } LDOREG3_b;
  } ;
  __IM  uint32_t  RESERVED2[29];
  
  union {
    __IOM uint32_t BODPORCTRL;                  /*!< (@ 0x00000100) BOD and PDR control Register                               */
    
    struct {
      __IOM uint32_t PWDPDR     : 1;            /*!< (@ 0x00000000) PDR Power Down.                                            */
      __IOM uint32_t PWDBOD     : 1;            /*!< (@ 0x00000001) BOD Power Down.                                            */
      __IOM uint32_t PDREXTREFSEL : 1;          /*!< (@ 0x00000002) PDR External Reference Select.                             */
      __IOM uint32_t BODEXTREFSEL : 1;          /*!< (@ 0x00000003) BOD External Reference Select.                             */
    } BODPORCTRL_b;
  } ;
  
  union {
    __IOM uint32_t ADCPWRDLY;                   /*!< (@ 0x00000104) ADC Power Up Delay Control                                 */
    
    struct {
      __IOM uint32_t ADCPWR0    : 8;            /*!< (@ 0x00000000) ADC Reference Buffer Power Enable delay in 64
                                                                    ADC CLK increments for ADC_CLKSEL = 0x1,
                                                                    32 ADC CLOCK increments for ADC_CLKSEL
                                                                    = 0x2.                                                     */
      __IOM uint32_t ADCPWR1    : 8;            /*!< (@ 0x00000008) ADC Reference Keeper enable delay in 16 ADC CLK
                                                                    increments for ADC_CLKSEL = 0x1, 8 ADC
                                                                    CLOCK increments for ADC_CLKSEL = 0x2.                     */
    } ADCPWRDLY_b;
  } ;
  __IM  uint32_t  RESERVED3;
  
  union {
    __IOM uint32_t ADCCAL;                      /*!< (@ 0x0000010C) ADC Calibration Control                                    */
    
    struct {
      __IOM uint32_t CALONPWRUP : 1;            /*!< (@ 0x00000000) Run ADC Calibration on initial power up sequence           */
      __IOM uint32_t ADCCALIBRATED : 1;         /*!< (@ 0x00000001) Status for ADC Calibration                                 */
    } ADCCAL_b;
  } ;
  
  union {
    __IOM uint32_t ADCBATTLOAD;                 /*!< (@ 0x00000110) ADC Battery Load Enable                                    */
    
    struct {
      __IOM uint32_t BATTLOAD   : 1;            /*!< (@ 0x00000000) Enable the ADC battery load resistor                       */
    } ADCBATTLOAD_b;
  } ;
  
  union {
    __IOM uint32_t BUCKTRIM;                    /*!< (@ 0x00000114) Trim settings for Core and Mem buck modules                */
    
    struct {
      __IOM uint32_t MEMBUCKR1  : 6;            /*!< (@ 0x00000000) Trim values for BUCK regulator.                            */
      __IM  uint32_t            : 2;
      __IOM uint32_t COREBUCKR1_LO : 6;         /*!< (@ 0x00000008) Core Buck voltage output trim bits[5:0], Concatenate
                                                                    with field COREBUCKR1_HI for the full trim
                                                                    value.                                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t COREBUCKR1_HI : 4;         /*!< (@ 0x00000010) Core Buck voltage output trim bits[9:6]. Concatenate
                                                                    with field COREBUCKR1_LO for the full trim
                                                                    value.                                                     */
      __IM  uint32_t            : 4;
      __IOM uint32_t RSVD2      : 6;            /*!< (@ 0x00000018) RESERVED.                                                  */
    } BUCKTRIM_b;
  } ;
  
  union {
    __IOM uint32_t ADCTRIM;                     /*!< (@ 0x00000118) ADC Trims                                                  */
    
    struct {
      __IOM uint32_t ADCREFKEEPIBTRIM : 2;      /*!< (@ 0x00000000) ADC Reference Ibias trim                                   */
      __IM  uint32_t            : 4;
      __IOM uint32_t ADCREFBUFTRIM : 5;         /*!< (@ 0x00000006) ADC Reference buffer trim                                  */
      __IOM uint32_t ADCRFBUFIBTRIM : 2;        /*!< (@ 0x0000000B) ADC reference buffer input bias trim                       */
    } ADCTRIM_b;
  } ;
  
  union {
    __IOM uint32_t ADCREFCOMP;                  /*!< (@ 0x0000011C) ADC Reference Keeper and Comparator Control                */
    
    struct {
      __IOM uint32_t ADC_REFCOMP_OUT : 1;       /*!< (@ 0x00000000) Output of the ADC reference comparator                     */
      __IM  uint32_t            : 7;
      __IOM uint32_t ADCREFKEEPTRIM : 5;        /*!< (@ 0x00000008) ADC Reference Keeper Trim                                  */
      __IM  uint32_t            : 3;
      __IOM uint32_t ADCRFCMPEN : 1;            /*!< (@ 0x00000010) ADC Reference comparator power down                        */
    } ADCREFCOMP_b;
  } ;
  __IM  uint32_t  RESERVED4;
  
  union {
    __IOM uint32_t XTALGENCTRL;                 /*!< (@ 0x00000124) XTAL Oscillator General Control                            */
    
    struct {
      __IOM uint32_t ACWARMUP   : 2;            /*!< (@ 0x00000000) Auto-calibration delay control                             */
      __IOM uint32_t XTALBIASTRIM : 6;          /*!< (@ 0x00000002) XTAL IBIAS trim                                            */
      __IOM uint32_t XTALKSBIASTRIM : 6;        /*!< (@ 0x00000008) XTAL IBIAS Kick start trim . This trim value
                                                                    is used during the startup process to enable
                                                                    a faster lock and is applied when the kickstart
                                                                    signal is active.                                          */
    } XTALGENCTRL_b;
  } ;
  __IM  uint32_t  RESERVED5[14];
  
  union {
    __IOM uint32_t EXTCLKSEL;                   /*!< (@ 0x00000160) Source selection of LFRC, HFRC and XTAL clock
                                                                    sources                                                    */
    
    struct {
      __IOM uint32_t EXT_XT     : 1;            /*!< (@ 0x00000000) XTAL External Clock Source Select.                         */
      __IOM uint32_t EXT_LF     : 1;            /*!< (@ 0x00000001) LFRC External Clock Source Select.                         */
      __IOM uint32_t EXT_HF     : 1;            /*!< (@ 0x00000002) HFRC External Clock Source Select.                         */
    } EXTCLKSEL_b;
  } ;
  __IM  uint32_t  RESERVED6[15];
  
  union {
    __IOM uint32_t BOOTLOADERLOW;               /*!< (@ 0x000001A0) Determines whether the bootloader code is visible
                                                                    at address 0x00000000                                      */
    
    struct {
      __IOM uint32_t VALUE      : 1;            /*!< (@ 0x00000000) Determines whether the bootloader code is visible
                                                                    at address 0x00000000 or not.                              */
    } BOOTLOADERLOW_b;
  } ;
  
  union {
    __IOM uint32_t SHADOWVALID;                 /*!< (@ 0x000001A4) Register to indicate whether the shadow registers
                                                                    have been successfully loaded from the
                                                                    Flash Information Space.                                   */
    
    struct {
      __IOM uint32_t VALID      : 1;            /*!< (@ 0x00000000) Indicates whether the shadow registers contain
                                                                    valid data from the Flash Information Space.               */
      __IOM uint32_t BL_DSLEEP  : 1;            /*!< (@ 0x00000001) Indicates whether the bootloader should sleep
                                                                    or deep sleep if no image loaded.                          */
    } SHADOWVALID_b;
  } ;
  __IM  uint32_t  RESERVED7[6];
  
  union {
    __IOM uint32_t ICODEFAULTADDR;              /*!< (@ 0x000001C0) ICODE bus address which was present when a bus
                                                                    fault occurred.                                            */
    
    struct {
      __IOM uint32_t ADDR       : 32;           /*!< (@ 0x00000000) The ICODE bus address observed when a Bus Fault
                                                                    occurred. Once an address is captured in
                                                                    this field, it is held until the corresponding
                                                                    Fault Observed bit is cleared in the FAULTSTATUS
                                                                    register.                                                  */
    } ICODEFAULTADDR_b;
  } ;
  
  union {
    __IOM uint32_t DCODEFAULTADDR;              /*!< (@ 0x000001C4) DCODE bus address which was present when a bus
                                                                    fault occurred.                                            */
    
    struct {
      __IOM uint32_t ADDR       : 32;           /*!< (@ 0x00000000) The DCODE bus address observed when a Bus Fault
                                                                    occurred. Once an address is captured in
                                                                    this field, it is held until the corresponding
                                                                    Fault Observed bit is cleared in the FAULTSTATUS
                                                                    register.                                                  */
    } DCODEFAULTADDR_b;
  } ;
  
  union {
    __IOM uint32_t SYSFAULTADDR;                /*!< (@ 0x000001C8) System bus address which was present when a bus
                                                                    fault occurred.                                            */
    
    struct {
      __IOM uint32_t ADDR       : 32;           /*!< (@ 0x00000000) SYS bus address observed when a Bus Fault occurred.
                                                                    Once an address is captured in this field,
                                                                    it is held until the corresponding Fault
                                                                    Observed bit is cleared in the FAULTSTATUS
                                                                    register.                                                  */
    } SYSFAULTADDR_b;
  } ;
  
  union {
    __IOM uint32_t FAULTSTATUS;                 /*!< (@ 0x000001CC) Reflects the status of the bus decoders' fault
                                                                    detection. Any write to this register will
                                                                    clear all of the status bits within the
                                                                    register.                                                  */
    
    struct {
      __IOM uint32_t ICODE      : 1;            /*!< (@ 0x00000000) The ICODE Bus Decoder Fault Detected bit. When
                                                                    set, a fault has been detected, and the
                                                                    ICODEFAULTADDR register will contain the
                                                                    bus address which generated the fault.                     */
      __IOM uint32_t DCODE      : 1;            /*!< (@ 0x00000001) DCODE Bus Decoder Fault Detected bit. When set,
                                                                    a fault has been detected, and the DCODEFAULTADDR
                                                                    register will contain the bus address which
                                                                    generated the fault.                                       */
      __IOM uint32_t SYS        : 1;            /*!< (@ 0x00000002) SYS Bus Decoder Fault Detected bit. When set,
                                                                    a fault has been detected, and the SYSFAULTADDR
                                                                    register will contain the bus address which
                                                                    generated the fault.                                       */
    } FAULTSTATUS_b;
  } ;
  
  union {
    __IOM uint32_t FAULTCAPTUREEN;              /*!< (@ 0x000001D0) Enable the fault capture registers                         */
    
    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< (@ 0x00000000) Fault Capture Enable field. When set, the Fault
                                                                    Capture monitors are enabled and addresses
                                                                    which generate a hard fault are captured
                                                                    into the FAULTADDR registers.                              */
    } FAULTCAPTUREEN_b;
  } ;
  __IM  uint32_t  RESERVED8[11];
  
  union {
    __IOM uint32_t DBGR1;                       /*!< (@ 0x00000200) Read-only debug register 1                                 */
    
    struct {
      __IOM uint32_t ONETO8     : 32;           /*!< (@ 0x00000000) Read-only register for communication validation            */
    } DBGR1_b;
  } ;
  
  union {
    __IOM uint32_t DBGR2;                       /*!< (@ 0x00000204) Read-only debug register 2                                 */
    
    struct {
      __IOM uint32_t COOLCODE   : 32;           /*!< (@ 0x00000000) Read-only register for communication validation            */
    } DBGR2_b;
  } ;
  __IM  uint32_t  RESERVED9[6];
  
  union {
    __IOM uint32_t PMUENABLE;                   /*!< (@ 0x00000220) Control bit to enable/disable the PMU                      */
    
    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< (@ 0x00000000) PMU Enable Control bit. When set, the MCU's PMU
                                                                    will place the MCU into the lowest power
                                                                    consuming Deep Sleep mode upon execution
                                                                    of a WFI instruction (dependent on the
                                                                    setting of the SLEEPDEEP bit in the ARM
                                                                    SCR register). When cleared, regardless
                                                                    of the requested sleep mode, the PMU will
                                                                    not enter the lowest power Deep Sleep mode,
                                                                    instead entering the Sleep mode.                           */
    } PMUENABLE_b;
  } ;
  __IM  uint32_t  RESERVED10[11];
  
  union {
    __IOM uint32_t TPIUCTRL;                    /*!< (@ 0x00000250) TPIU Control Register. Determines the clock enable
                                                                    and frequency for the M4's TPIU interface.                 */
    
    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< (@ 0x00000000) TPIU Enable field. When set, the ARM M4 TPIU
                                                                    is enabled and data can be streamed out
                                                                    of the MCU's SWO port using the ARM ITM
                                                                    and TPIU modules.                                          */
      __IM  uint32_t            : 7;
      __IOM uint32_t CLKSEL     : 3;            /*!< (@ 0x00000008) This field selects the frequency of the ARM M4
                                                                    TPIU port.                                                 */
    } TPIUCTRL_b;
  } ;
  __IM  uint32_t  RESERVED11[61];
  
  union {
    __IOM uint32_t KEXTCLKSEL;                  /*!< (@ 0x00000348) Key Register to enable the use of external clock
                                                                    selects via the EXTCLKSEL reg                              */
    
    struct {
      __IOM uint32_t KEXTCLKSEL : 32;           /*!< (@ 0x00000000) Key register value.                                        */
    } KEXTCLKSEL_b;
  } ;
} MCUCTRL_Type;                                 /*!< Size = 844 (0x34c)                                                        */



/* =========================================================================================================================== */
/* ================                                            PDM                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief PDM Audio (PDM)
  */

typedef struct {                                /*!< (@ 0x50011000) PDM Structure                                              */
  
  union {
    __IOM uint32_t PCFG;                        /*!< (@ 0x00000000) PDM Configuration Register                                 */
    
    struct {
      __IOM uint32_t PDMCORE    : 1;            /*!< (@ 0x00000000) Data Streaming Control.                                    */
      __IOM uint32_t SOFTMUTE   : 1;            /*!< (@ 0x00000001) Soft mute control.                                         */
      __IOM uint32_t CYCLES     : 3;            /*!< (@ 0x00000002) Number of clocks during gain-setting changes.              */
      __IOM uint32_t HPCUTOFF   : 4;            /*!< (@ 0x00000005) High pass filter coefficients.                             */
      __IOM uint32_t ADCHPD     : 1;            /*!< (@ 0x00000009) High pass filter control.                                  */
      __IOM uint32_t SINCRATE   : 7;            /*!< (@ 0x0000000A) SINC decimation rate.                                      */
      __IOM uint32_t MCLKDIV    : 2;            /*!< (@ 0x00000011) PDM_CLK frequency divisor.                                 */
      __IM  uint32_t            : 4;
      __IOM uint32_t PGALEFT    : 4;            /*!< (@ 0x00000017) Left channel PGA gain.                                     */
      __IOM uint32_t PGARIGHT   : 4;            /*!< (@ 0x0000001B) Right channel PGA gain.                                    */
      __IOM uint32_t LRSWAP     : 1;            /*!< (@ 0x0000001F) Left/right channel swap.                                   */
    } PCFG_b;
  } ;
  
  union {
    __IOM uint32_t VCFG;                        /*!< (@ 0x00000004) Voice Configuration Register                               */
    
    struct {
      __IM  uint32_t            : 3;
      __IOM uint32_t CHSET      : 2;            /*!< (@ 0x00000003) Set PCM channels.                                          */
      __IM  uint32_t            : 3;
      __IOM uint32_t PCMPACK    : 1;            /*!< (@ 0x00000008) PCM data packing enable.                                   */
      __IM  uint32_t            : 7;
      __IOM uint32_t SELAP      : 1;            /*!< (@ 0x00000010) Select PDM input clock source.                             */
      __IOM uint32_t DMICKDEL   : 1;            /*!< (@ 0x00000011) PDM clock sampling delay.                                  */
      __IM  uint32_t            : 1;
      __IOM uint32_t BCLKINV    : 1;            /*!< (@ 0x00000013) I2S BCLK input inversion.                                  */
      __IOM uint32_t I2SMODE    : 1;            /*!< (@ 0x00000014) I2S interface enable.                                      */
      __IM  uint32_t            : 5;
      __IOM uint32_t PDMCLK     : 1;            /*!< (@ 0x0000001A) Enable the serial clock.                                   */
      __IOM uint32_t PDMCLKSEL  : 3;            /*!< (@ 0x0000001B) Select the PDM input clock.                                */
      __IOM uint32_t RSTB       : 1;            /*!< (@ 0x0000001E) Reset the IP core.                                         */
      __IOM uint32_t IOCLKEN    : 1;            /*!< (@ 0x0000001F) Enable the IO clock.                                       */
    } VCFG_b;
  } ;
  
  union {
    __IOM uint32_t FR;                          /*!< (@ 0x00000008) Voice Status Register                                      */
    
    struct {
      __IOM uint32_t FIFOCNT    : 9;            /*!< (@ 0x00000000) Valid 32-bit entries currently in the FIFO.                */
    } FR_b;
  } ;
  
  union {
    __IOM uint32_t FRD;                         /*!< (@ 0x0000000C) FIFO Read                                                  */
    
    struct {
      __IOM uint32_t FIFOREAD   : 32;           /*!< (@ 0x00000000) FIFO read data.                                            */
    } FRD_b;
  } ;
  
  union {
    __IOM uint32_t FLUSH;                       /*!< (@ 0x00000010) FIFO Flush                                                 */
    
    struct {
      __IOM uint32_t FIFOFLUSH  : 1;            /*!< (@ 0x00000000) FIFO FLUSH.                                                */
    } FLUSH_b;
  } ;
  
  union {
    __IOM uint32_t FTHR;                        /*!< (@ 0x00000014) FIFO Threshold                                             */
    
    struct {
      __IOM uint32_t FIFOTHR    : 8;            /*!< (@ 0x00000000) FIFO interrupt threshold.                                  */
    } FTHR_b;
  } ;
  __IM  uint32_t  RESERVED[122];
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) IO Master Interrupts: Enable                               */
    
    struct {
      __IOM uint32_t THR        : 1;            /*!< (@ 0x00000000) This is the FIFO threshold interrupt.                      */
      __IOM uint32_t OVF        : 1;            /*!< (@ 0x00000001) This is the FIFO overflow interrupt.                       */
      __IOM uint32_t UNDFL      : 1;            /*!< (@ 0x00000002) This is the FIFO underflow interrupt.                      */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) IO Master Interrupts: Status                               */
    
    struct {
      __IOM uint32_t THR        : 1;            /*!< (@ 0x00000000) This is the FIFO threshold interrupt.                      */
      __IOM uint32_t OVF        : 1;            /*!< (@ 0x00000001) This is the FIFO overflow interrupt.                       */
      __IOM uint32_t UNDFL      : 1;            /*!< (@ 0x00000002) This is the FIFO underflow interrupt.                      */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) IO Master Interrupts: Clear                                */
    
    struct {
      __IOM uint32_t THR        : 1;            /*!< (@ 0x00000000) This is the FIFO threshold interrupt.                      */
      __IOM uint32_t OVF        : 1;            /*!< (@ 0x00000001) This is the FIFO overflow interrupt.                       */
      __IOM uint32_t UNDFL      : 1;            /*!< (@ 0x00000002) This is the FIFO underflow interrupt.                      */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) IO Master Interrupts: Set                                  */
    
    struct {
      __IOM uint32_t THR        : 1;            /*!< (@ 0x00000000) This is the FIFO threshold interrupt.                      */
      __IOM uint32_t OVF        : 1;            /*!< (@ 0x00000001) This is the FIFO overflow interrupt.                       */
      __IOM uint32_t UNDFL      : 1;            /*!< (@ 0x00000002) This is the FIFO underflow interrupt.                      */
    } INTSET_b;
  } ;
} PDM_Type;                                     /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                          PWRCTRL                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief PWR Controller Register Bank (PWRCTRL)
  */

typedef struct {                                /*!< (@ 0x40021000) PWRCTRL Structure                                          */
  
  union {
    __IOM uint32_t SUPPLYSRC;                   /*!< (@ 0x00000000) Memory and Core Voltage Supply Source Select
                                                                    Register                                                   */
    
    struct {
      __IOM uint32_t MEMBUCKEN  : 1;            /*!< (@ 0x00000000) Enables and select the Memory Buck as the supply
                                                                    for the Flash and SRAM power domain.                       */
      __IOM uint32_t COREBUCKEN : 1;            /*!< (@ 0x00000001) Enables and Selects the Core Buck as the supply
                                                                    for the low-voltage power domain.                          */
      __IOM uint32_t SWITCH_LDO_IN_SLEEP : 1;   /*!< (@ 0x00000002) Switches the CORE DOMAIN from BUCK mode (if enabled)
                                                                    to LDO when CPU is in DEEP SLEEP. If all
                                                                    the devices are off then this does not
                                                                    matter and LDO (low power mode) is used                    */
    } SUPPLYSRC_b;
  } ;
  
  union {
    __IOM uint32_t POWERSTATUS;                 /*!< (@ 0x00000004) Power Status Register for MCU supplies and peripherals     */
    
    struct {
      __IOM uint32_t MEMBUCKON  : 1;            /*!< (@ 0x00000000) Indicate whether the Memory power domain is supplied
                                                                    from the LDO or the Buck.                                  */
      __IOM uint32_t COREBUCKON : 1;            /*!< (@ 0x00000001) Indicates whether the Core low-voltage domain
                                                                    is supplied from the LDO or the Buck.                      */
    } POWERSTATUS_b;
  } ;
  
  union {
    __IOM uint32_t DEVICEEN;                    /*!< (@ 0x00000008) DEVICE ENABLES for SHELBY                                  */
    
    struct {
      __IOM uint32_t IO_SLAVE   : 1;            /*!< (@ 0x00000000) Enable IO SLAVE                                            */
      __IOM uint32_t IO_MASTER0 : 1;            /*!< (@ 0x00000001) Enable IO MASTER 0                                         */
      __IOM uint32_t IO_MASTER1 : 1;            /*!< (@ 0x00000002) Enable IO MASTER 1                                         */
      __IOM uint32_t IO_MASTER2 : 1;            /*!< (@ 0x00000003) Enable IO MASTER 2                                         */
      __IOM uint32_t IO_MASTER3 : 1;            /*!< (@ 0x00000004) Enable IO MASTER 3                                         */
      __IOM uint32_t IO_MASTER4 : 1;            /*!< (@ 0x00000005) Enable IO MASTER 4                                         */
      __IOM uint32_t IO_MASTER5 : 1;            /*!< (@ 0x00000006) Enable IO MASTER 5                                         */
      __IOM uint32_t UART0      : 1;            /*!< (@ 0x00000007) Enable UART 0                                              */
      __IOM uint32_t UART1      : 1;            /*!< (@ 0x00000008) Enable UART 1                                              */
      __IOM uint32_t ADC        : 1;            /*!< (@ 0x00000009) Enable ADC Digital Block                                   */
      __IOM uint32_t PDM        : 1;            /*!< (@ 0x0000000A) Enable PDM Digital Block                                   */
    } DEVICEEN_b;
  } ;
  
  union {
    __IOM uint32_t SRAMPWDINSLEEP;              /*!< (@ 0x0000000C) Powerdown an SRAM Banks in Deep Sleep mode                 */
    
    struct {
      __IOM uint32_t SRAMSLEEPPOWERDOWN : 11;   /*!< (@ 0x00000000) Selects which SRAM banks are powered down in
                                                                    deep sleep mode, causing the contents of
                                                                    the bank to be lost.                                       */
      __IM  uint32_t            : 20;
      __IOM uint32_t CACHE_PWD_SLP : 1;         /*!< (@ 0x0000001F) Enable CACHE BANKS to power down in deep sleep             */
    } SRAMPWDINSLEEP_b;
  } ;
  
  union {
    __IOM uint32_t MEMEN;                       /*!< (@ 0x00000010) Disables individual banks of the MEMORY array              */
    
    struct {
      __IOM uint32_t SRAMEN     : 11;           /*!< (@ 0x00000000) Enables power for selected SRAM banks (else an
                                                                    access to its address space to generate
                                                                    a Hard Fault).                                             */
      __IOM uint32_t FLASH0     : 1;            /*!< (@ 0x0000000B) Enable FLASH 0                                             */
      __IOM uint32_t FLASH1     : 1;            /*!< (@ 0x0000000C) Enable FLASH1                                              */
      __IM  uint32_t            : 16;
      __IOM uint32_t CACHEB0    : 1;            /*!< (@ 0x0000001D) Enable CACHE BANK 0                                        */
      __IM  uint32_t            : 1;
      __IOM uint32_t CACHEB2    : 1;            /*!< (@ 0x0000001F) Enable CACHE BANK 2                                        */
    } MEMEN_b;
  } ;
  
  union {
    __IOM uint32_t PWRONSTATUS;                 /*!< (@ 0x00000014) POWER ON Status                                            */
    
    struct {
      __IM  uint32_t            : 1;
      __IOM uint32_t PDA        : 1;            /*!< (@ 0x00000001) This bit is 1 if power is supplied to power domain
                                                                    A, which supplies IOS and UART0,1.                         */
      __IOM uint32_t PDB        : 1;            /*!< (@ 0x00000002) This bit is 1 if power is supplied to power domain
                                                                    B, which supplies IOM0-2.                                  */
      __IOM uint32_t PDC        : 1;            /*!< (@ 0x00000003) This bit is 1 if power is supplied to power domain
                                                                    C, which supplies IOM3-5.                                  */
      __IOM uint32_t PD_PDM     : 1;            /*!< (@ 0x00000004) This bit is 1 if power is supplied to domain
                                                                    PD_PDM                                                     */
      __IOM uint32_t PD_FLAM0   : 1;            /*!< (@ 0x00000005) This bit is 1 if power is supplied to domain
                                                                    PD_FLAM0                                                   */
      __IOM uint32_t PD_FLAM1   : 1;            /*!< (@ 0x00000006) This bit is 1 if power is supplied to domain
                                                                    PD_FLAM1                                                   */
      __IOM uint32_t PDADC      : 1;            /*!< (@ 0x00000007) This bit is 1 if power is supplied to domain
                                                                    PD_ADC                                                     */
      __IOM uint32_t PD_GRP0_SRAM0 : 1;         /*!< (@ 0x00000008) This bit is 1 if power is supplied to SRAM domain
                                                                    SRAM0_0                                                    */
      __IOM uint32_t PD_GRP0_SRAM1 : 1;         /*!< (@ 0x00000009) This bit is 1 if power is supplied to SRAM domain
                                                                    SRAM0_1                                                    */
      __IOM uint32_t PD_GRP0_SRAM2 : 1;         /*!< (@ 0x0000000A) This bit is 1 if power is supplied to SRAM domain
                                                                    PD_SRAM0_2                                                 */
      __IOM uint32_t PD_GRP0_SRAM3 : 1;         /*!< (@ 0x0000000B) This bit is 1 if power is supplied to SRAM domain
                                                                    PD_SRAM0_3                                                 */
      __IOM uint32_t PD_GRP1_SRAM : 1;          /*!< (@ 0x0000000C) This bit is 1 if power is supplied to SRAM domain
                                                                    PD_GRP1                                                    */
      __IOM uint32_t PD_GRP2_SRAM : 1;          /*!< (@ 0x0000000D) This bit is 1 if power is supplied to SRAM domain
                                                                    PD_GRP2                                                    */
      __IOM uint32_t PD_GRP3_SRAM : 1;          /*!< (@ 0x0000000E) This bit is 1 if power is supplied to SRAM domain
                                                                    PD_GRP3                                                    */
      __IOM uint32_t PD_GRP4_SRAM : 1;          /*!< (@ 0x0000000F) This bit is 1 if power is supplied to SRAM domain
                                                                    PD_GRP4                                                    */
      __IOM uint32_t PD_GRP5_SRAM : 1;          /*!< (@ 0x00000010) This bit is 1 if power is supplied to SRAM domain
                                                                    PD_GRP5                                                    */
      __IOM uint32_t PD_GRP6_SRAM : 1;          /*!< (@ 0x00000011) This bit is 1 if power is supplied to SRAM domain
                                                                    PD_GRP6                                                    */
      __IOM uint32_t PD_GRP7_SRAM : 1;          /*!< (@ 0x00000012) This bit is 1 if power is supplied to SRAM domain
                                                                    PD_GRP7                                                    */
      __IOM uint32_t PD_CACHEB0 : 1;            /*!< (@ 0x00000013) This bit is 1 if power is supplied to CACHE BANK
                                                                    0                                                          */
      __IM  uint32_t            : 1;
      __IOM uint32_t PD_CACHEB2 : 1;            /*!< (@ 0x00000015) This bit is 1 if power is supplied to CACHE BANK
                                                                    2                                                          */
    } PWRONSTATUS_b;
  } ;
  
  union {
    __IOM uint32_t SRAMCTRL;                    /*!< (@ 0x00000018) SRAM Control register                                      */
    
    struct {
      __IOM uint32_t SRAM_LIGHT_SLEEP : 1;      /*!< (@ 0x00000000) Enable LS (light sleep) of cache RAMs. When this
                                                                    bit is set, the RAMS will be put into light
                                                                    sleep mode while inactive. NOTE: if the
                                                                    SRAM is actively used, this may have an
                                                                    adverse affect on power since entering/exiting
                                                                    LS mode may consume more power than would
                                                                    be saved.                                                  */
      __IOM uint32_t SRAM_CLKGATE : 1;          /*!< (@ 0x00000001) Enables individual per-RAM clock gating in the
                                                                    SRAM block. This bit should be enabled
                                                                    for lowest power operation.                                */
      __IOM uint32_t SRAM_MASTER_CLKGATE : 1;   /*!< (@ 0x00000002) Enables top-level clock gating in the SRAM block.
                                                                    This bit should be enabled for lowest power
                                                                    operation.                                                 */
    } SRAMCTRL_b;
  } ;
  
  union {
    __IOM uint32_t ADCSTATUS;                   /*!< (@ 0x0000001C) Power Status Register for ADC Block                        */
    
    struct {
      __IOM uint32_t ADC_PWD    : 1;            /*!< (@ 0x00000000) This bit indicates that the ADC is powered down            */
      __IOM uint32_t ADC_BGT_PWD : 1;           /*!< (@ 0x00000001) This bit indicates that the ADC Band Gap is powered
                                                                    down                                                       */
      __IOM uint32_t ADC_VPTAT_PWD : 1;         /*!< (@ 0x00000002) This bit indicates that the ADC temperature sensor
                                                                    input buffer is powered down                               */
      __IOM uint32_t ADC_VBAT_PWD : 1;          /*!< (@ 0x00000003) This bit indicates that the ADC VBAT resistor
                                                                    divider is powered down                                    */
      __IOM uint32_t ADC_REFKEEP_PWD : 1;       /*!< (@ 0x00000004) This bit indicates that the ADC REFKEEP is powered
                                                                    down                                                       */
      __IOM uint32_t ADC_REFBUF_PWD : 1;        /*!< (@ 0x00000005) This bit indicates that the ADC REFBUF is powered
                                                                    down                                                       */
    } ADCSTATUS_b;
  } ;
  
  union {
    __IOM uint32_t MISCOPT;                     /*!< (@ 0x00000020) Power Optimization Control Bits                            */
    
    struct {
      __IOM uint32_t ADC_EN_MASK : 1;           /*!< (@ 0x00000000) Control Bit to mask the ADC_EN in the adc_pwr_down
                                                                    equation.                                                  */
      __IOM uint32_t DIS_LDOLPMODE_HFRC : 1;    /*!< (@ 0x00000001) Setting this bit will enable the Core LDO to
                                                                    be in LPMODE during deep sleep even when
                                                                    HFRC is enabled.                                           */
      __IOM uint32_t DIS_LDOLPMODE_TIMERS : 1;  /*!< (@ 0x00000002) Setting this bit will enable the MEM LDO to be
                                                                    in LPMODE during deep sleep even when the
                                                                    ctimers or stimers are running                             */
    } MISCOPT_b;
  } ;
} PWRCTRL_Type;                                 /*!< Size = 36 (0x24)                                                          */



/* =========================================================================================================================== */
/* ================                                          RSTGEN                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief MCU Reset Generator (RSTGEN)
  */

typedef struct {                                /*!< (@ 0x40000000) RSTGEN Structure                                           */
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Configuration Register                                     */
    
    struct {
      __IOM uint32_t BODHREN    : 1;            /*!< (@ 0x00000000) Brown out high (2.1v) reset enable.                        */
      __IOM uint32_t WDREN      : 1;            /*!< (@ 0x00000001) Watchdog Timer Reset Enable. NOTE: The WDT module
                                                                    must also be configured for WDT reset.                     */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t SWPOI;                       /*!< (@ 0x00000004) Software POI Reset                                         */
    
    struct {
      __IOM uint32_t SWPOIKEY   : 8;            /*!< (@ 0x00000000) 0x1B generates a software POI reset.                       */
    } SWPOI_b;
  } ;
  
  union {
    __IOM uint32_t SWPOR;                       /*!< (@ 0x00000008) Software POR Reset                                         */
    
    struct {
      __IOM uint32_t SWPORKEY   : 8;            /*!< (@ 0x00000000) 0xD4 generates a software POR reset.                       */
    } SWPOR_b;
  } ;
  
  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x0000000C) Status Register                                            */
    
    struct {
      __IOM uint32_t EXRSTAT    : 1;            /*!< (@ 0x00000000) Reset was initiated by an External Reset.                  */
      __IOM uint32_t PORSTAT    : 1;            /*!< (@ 0x00000001) Reset was initiated by a Power-On Reset.                   */
      __IOM uint32_t BORSTAT    : 1;            /*!< (@ 0x00000002) Reset was initiated by a Brown-Out Reset.                  */
      __IOM uint32_t SWRSTAT    : 1;            /*!< (@ 0x00000003) Reset was a initiated by SW POR or AIRCR Reset.            */
      __IOM uint32_t POIRSTAT   : 1;            /*!< (@ 0x00000004) Reset was a initiated by Software POI Reset.               */
      __IOM uint32_t DBGRSTAT   : 1;            /*!< (@ 0x00000005) Reset was a initiated by Debugger Reset.                   */
      __IOM uint32_t WDRSTAT    : 1;            /*!< (@ 0x00000006) Reset was initiated by a Watchdog Timer Reset.             */
    } STAT_b;
  } ;
  
  union {
    __IOM uint32_t CLRSTAT;                     /*!< (@ 0x00000010) Clear the status register                                  */
    
    struct {
      __IOM uint32_t CLRSTAT    : 1;            /*!< (@ 0x00000000) Writing a 1 to this bit clears all bits in the
                                                                    RST_STAT.                                                  */
    } CLRSTAT_b;
  } ;
  
  union {
    __IOM uint32_t TPIU_RST;                    /*!< (@ 0x00000014) TPIU reset                                                 */
    
    struct {
      __IOM uint32_t TPIURST    : 1;            /*!< (@ 0x00000000) Static reset for the TPIU. Write to '1' to assert
                                                                    reset to TPIU. Write to '0' to clear the
                                                                    reset.                                                     */
    } TPIU_RST_b;
  } ;
  __IM  uint32_t  RESERVED[122];
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Reset Interrupt register: Enable                           */
    
    struct {
      __IOM uint32_t BODH       : 1;            /*!< (@ 0x00000000) Enables an interrupt that triggers when VCC is
                                                                    below BODH level.                                          */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Reset Interrupt register: Status                           */
    
    struct {
      __IOM uint32_t BODH       : 1;            /*!< (@ 0x00000000) Enables an interrupt that triggers when VCC is
                                                                    below BODH level.                                          */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Reset Interrupt register: Clear                            */
    
    struct {
      __IOM uint32_t BODH       : 1;            /*!< (@ 0x00000000) Enables an interrupt that triggers when VCC is
                                                                    below BODH level.                                          */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Reset Interrupt register: Set                              */
    
    struct {
      __IOM uint32_t BODH       : 1;            /*!< (@ 0x00000000) Enables an interrupt that triggers when VCC is
                                                                    below BODH level.                                          */
    } INTSET_b;
  } ;
} RSTGEN_Type;                                  /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                           UART0                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Serial UART (UART0)
  */

typedef struct {                                /*!< (@ 0x4001C000) UART0 Structure                                            */
  
  union {
    __IOM uint32_t DR;                          /*!< (@ 0x00000000) UART Data Register                                         */
    
    struct {
      __IOM uint32_t DATA       : 8;            /*!< (@ 0x00000000) This is the UART data port.                                */
      __IOM uint32_t FEDATA     : 1;            /*!< (@ 0x00000008) This is the framing error indicator.                       */
      __IOM uint32_t PEDATA     : 1;            /*!< (@ 0x00000009) This is the parity error indicator.                        */
      __IOM uint32_t BEDATA     : 1;            /*!< (@ 0x0000000A) This is the break error indicator.                         */
      __IOM uint32_t OEDATA     : 1;            /*!< (@ 0x0000000B) This is the overrun error indicator.                       */
    } DR_b;
  } ;
  
  union {
    __IOM uint32_t RSR;                         /*!< (@ 0x00000004) UART Status Register                                       */
    
    struct {
      __IOM uint32_t FESTAT     : 1;            /*!< (@ 0x00000000) This is the framing error indicator.                       */
      __IOM uint32_t PESTAT     : 1;            /*!< (@ 0x00000001) This is the parity error indicator.                        */
      __IOM uint32_t BESTAT     : 1;            /*!< (@ 0x00000002) This is the break error indicator.                         */
      __IOM uint32_t OESTAT     : 1;            /*!< (@ 0x00000003) This is the overrun error indicator.                       */
    } RSR_b;
  } ;
  __IM  uint32_t  RESERVED[4];
  
  union {
    __IOM uint32_t FR;                          /*!< (@ 0x00000018) Flag Register                                              */
    
    struct {
      __IOM uint32_t CTS        : 1;            /*!< (@ 0x00000000) This bit holds the clear to send indicator.                */
      __IOM uint32_t DSR        : 1;            /*!< (@ 0x00000001) This bit holds the data set ready indicator.               */
      __IOM uint32_t DCD        : 1;            /*!< (@ 0x00000002) This bit holds the data carrier detect indicator.          */
      __IOM uint32_t BUSY       : 1;            /*!< (@ 0x00000003) This bit holds the busy indicator.                         */
      __IOM uint32_t RXFE       : 1;            /*!< (@ 0x00000004) This bit holds the receive FIFO empty indicator.           */
      __IOM uint32_t TXFF       : 1;            /*!< (@ 0x00000005) This bit holds the transmit FIFO full indicator.           */
      __IOM uint32_t RXFF       : 1;            /*!< (@ 0x00000006) This bit holds the receive FIFO full indicator.            */
      __IOM uint32_t TXFE       : 1;            /*!< (@ 0x00000007) This bit holds the transmit FIFO empty indicator.          */
      __IOM uint32_t TXBUSY     : 1;            /*!< (@ 0x00000008) This bit holds the transmit BUSY indicator.                */
    } FR_b;
  } ;
  __IM  uint32_t  RESERVED1;
  
  union {
    __IOM uint32_t ILPR;                        /*!< (@ 0x00000020) IrDA Counter                                               */
    
    struct {
      __IOM uint32_t ILPDVSR    : 8;            /*!< (@ 0x00000000) These bits hold the IrDA counter divisor.                  */
    } ILPR_b;
  } ;
  
  union {
    __IOM uint32_t IBRD;                        /*!< (@ 0x00000024) Integer Baud Rate Divisor                                  */
    
    struct {
      __IOM uint32_t DIVINT     : 16;           /*!< (@ 0x00000000) These bits hold the baud integer divisor.                  */
    } IBRD_b;
  } ;
  
  union {
    __IOM uint32_t FBRD;                        /*!< (@ 0x00000028) Fractional Baud Rate Divisor                               */
    
    struct {
      __IOM uint32_t DIVFRAC    : 6;            /*!< (@ 0x00000000) These bits hold the baud fractional divisor.               */
    } FBRD_b;
  } ;
  
  union {
    __IOM uint32_t LCRH;                        /*!< (@ 0x0000002C) Line Control High                                          */
    
    struct {
      __IOM uint32_t BRK        : 1;            /*!< (@ 0x00000000) This bit holds the break set.                              */
      __IOM uint32_t PEN        : 1;            /*!< (@ 0x00000001) This bit holds the parity enable.                          */
      __IOM uint32_t EPS        : 1;            /*!< (@ 0x00000002) This bit holds the even parity select.                     */
      __IOM uint32_t STP2       : 1;            /*!< (@ 0x00000003) This bit holds the two stop bits select.                   */
      __IOM uint32_t FEN        : 1;            /*!< (@ 0x00000004) This bit holds the FIFO enable.                            */
      __IOM uint32_t WLEN       : 2;            /*!< (@ 0x00000005) These bits hold the write length.                          */
      __IOM uint32_t SPS        : 1;            /*!< (@ 0x00000007) This bit holds the stick parity select.                    */
    } LCRH_b;
  } ;
  
  union {
    __IOM uint32_t CR;                          /*!< (@ 0x00000030) Control Register                                           */
    
    struct {
      __IOM uint32_t UARTEN     : 1;            /*!< (@ 0x00000000) This bit is the UART enable.                               */
      __IOM uint32_t SIREN      : 1;            /*!< (@ 0x00000001) This bit is the SIR ENDEC enable.                          */
      __IOM uint32_t SIRLP      : 1;            /*!< (@ 0x00000002) This bit is the SIR low power select.                      */
      __IOM uint32_t CLKEN      : 1;            /*!< (@ 0x00000003) This bit is the UART clock enable.                         */
      __IOM uint32_t CLKSEL     : 3;            /*!< (@ 0x00000004) This bitfield is the UART clock select.                    */
      __IOM uint32_t LBE        : 1;            /*!< (@ 0x00000007) This bit is the loopback enable.                           */
      __IOM uint32_t TXE        : 1;            /*!< (@ 0x00000008) This bit is the transmit enable.                           */
      __IOM uint32_t RXE        : 1;            /*!< (@ 0x00000009) This bit is the receive enable.                            */
      __IOM uint32_t DTR        : 1;            /*!< (@ 0x0000000A) This bit enables data transmit ready.                      */
      __IOM uint32_t RTS        : 1;            /*!< (@ 0x0000000B) This bit enables request to send.                          */
      __IOM uint32_t OUT1       : 1;            /*!< (@ 0x0000000C) This bit holds modem Out1.                                 */
      __IOM uint32_t OUT2       : 1;            /*!< (@ 0x0000000D) This bit holds modem Out2.                                 */
      __IOM uint32_t RTSEN      : 1;            /*!< (@ 0x0000000E) This bit enables RTS hardware flow control.                */
      __IOM uint32_t CTSEN      : 1;            /*!< (@ 0x0000000F) This bit enables CTS hardware flow control.                */
    } CR_b;
  } ;
  
  union {
    __IOM uint32_t IFLS;                        /*!< (@ 0x00000034) FIFO Interrupt Level Select                                */
    
    struct {
      __IOM uint32_t TXIFLSEL   : 3;            /*!< (@ 0x00000000) These bits hold the transmit FIFO interrupt level.         */
      __IOM uint32_t RXIFLSEL   : 3;            /*!< (@ 0x00000003) These bits hold the receive FIFO interrupt level.          */
    } IFLS_b;
  } ;
  
  union {
    __IOM uint32_t IER;                         /*!< (@ 0x00000038) Interrupt Enable                                           */
    
    struct {
      __IOM uint32_t TXCMPMIM   : 1;            /*!< (@ 0x00000000) This bit holds the modem TXCMP interrupt enable.           */
      __IOM uint32_t CTSMIM     : 1;            /*!< (@ 0x00000001) This bit holds the modem CTS interrupt enable.             */
      __IOM uint32_t DCDMIM     : 1;            /*!< (@ 0x00000002) This bit holds the modem DCD interrupt enable.             */
      __IOM uint32_t DSRMIM     : 1;            /*!< (@ 0x00000003) This bit holds the modem DSR interrupt enable.             */
      __IOM uint32_t RXIM       : 1;            /*!< (@ 0x00000004) This bit holds the receive interrupt enable.               */
      __IOM uint32_t TXIM       : 1;            /*!< (@ 0x00000005) This bit holds the transmit interrupt enable.              */
      __IOM uint32_t RTIM       : 1;            /*!< (@ 0x00000006) This bit holds the receive timeout interrupt
                                                                    enable.                                                    */
      __IOM uint32_t FEIM       : 1;            /*!< (@ 0x00000007) This bit holds the framing error interrupt enable.         */
      __IOM uint32_t PEIM       : 1;            /*!< (@ 0x00000008) This bit holds the parity error interrupt enable.          */
      __IOM uint32_t BEIM       : 1;            /*!< (@ 0x00000009) This bit holds the break error interrupt enable.           */
      __IOM uint32_t OEIM       : 1;            /*!< (@ 0x0000000A) This bit holds the overflow interrupt enable.              */
    } IER_b;
  } ;
  
  union {
    __IOM uint32_t IES;                         /*!< (@ 0x0000003C) Interrupt Status                                           */
    
    struct {
      __IOM uint32_t TXCMPMRIS  : 1;            /*!< (@ 0x00000000) This bit holds the modem TXCMP interrupt status.           */
      __IOM uint32_t CTSMRIS    : 1;            /*!< (@ 0x00000001) This bit holds the modem CTS interrupt status.             */
      __IOM uint32_t DCDMRIS    : 1;            /*!< (@ 0x00000002) This bit holds the modem DCD interrupt status.             */
      __IOM uint32_t DSRMRIS    : 1;            /*!< (@ 0x00000003) This bit holds the modem DSR interrupt status.             */
      __IOM uint32_t RXRIS      : 1;            /*!< (@ 0x00000004) This bit holds the receive interrupt status.               */
      __IOM uint32_t TXRIS      : 1;            /*!< (@ 0x00000005) This bit holds the transmit interrupt status.              */
      __IOM uint32_t RTRIS      : 1;            /*!< (@ 0x00000006) This bit holds the receive timeout interrupt
                                                                    status.                                                    */
      __IOM uint32_t FERIS      : 1;            /*!< (@ 0x00000007) This bit holds the framing error interrupt status.         */
      __IOM uint32_t PERIS      : 1;            /*!< (@ 0x00000008) This bit holds the parity error interrupt status.          */
      __IOM uint32_t BERIS      : 1;            /*!< (@ 0x00000009) This bit holds the break error interrupt status.           */
      __IOM uint32_t OERIS      : 1;            /*!< (@ 0x0000000A) This bit holds the overflow interrupt status.              */
    } IES_b;
  } ;
  
  union {
    __IOM uint32_t MIS;                         /*!< (@ 0x00000040) Masked Interrupt Status                                    */
    
    struct {
      __IOM uint32_t TXCMPMMIS  : 1;            /*!< (@ 0x00000000) This bit holds the modem TXCMP interrupt status
                                                                    masked.                                                    */
      __IOM uint32_t CTSMMIS    : 1;            /*!< (@ 0x00000001) This bit holds the modem CTS interrupt status
                                                                    masked.                                                    */
      __IOM uint32_t DCDMMIS    : 1;            /*!< (@ 0x00000002) This bit holds the modem DCD interrupt status
                                                                    masked.                                                    */
      __IOM uint32_t DSRMMIS    : 1;            /*!< (@ 0x00000003) This bit holds the modem DSR interrupt status
                                                                    masked.                                                    */
      __IOM uint32_t RXMIS      : 1;            /*!< (@ 0x00000004) This bit holds the receive interrupt status masked.        */
      __IOM uint32_t TXMIS      : 1;            /*!< (@ 0x00000005) This bit holds the transmit interrupt status
                                                                    masked.                                                    */
      __IOM uint32_t RTMIS      : 1;            /*!< (@ 0x00000006) This bit holds the receive timeout interrupt
                                                                    status masked.                                             */
      __IOM uint32_t FEMIS      : 1;            /*!< (@ 0x00000007) This bit holds the framing error interrupt status
                                                                    masked.                                                    */
      __IOM uint32_t PEMIS      : 1;            /*!< (@ 0x00000008) This bit holds the parity error interrupt status
                                                                    masked.                                                    */
      __IOM uint32_t BEMIS      : 1;            /*!< (@ 0x00000009) This bit holds the break error interrupt status
                                                                    masked.                                                    */
      __IOM uint32_t OEMIS      : 1;            /*!< (@ 0x0000000A) This bit holds the overflow interrupt status
                                                                    masked.                                                    */
    } MIS_b;
  } ;
  
  union {
    __IOM uint32_t IEC;                         /*!< (@ 0x00000044) Interrupt Clear                                            */
    
    struct {
      __IOM uint32_t TXCMPMIC   : 1;            /*!< (@ 0x00000000) This bit holds the modem TXCMP interrupt clear.            */
      __IOM uint32_t CTSMIC     : 1;            /*!< (@ 0x00000001) This bit holds the modem CTS interrupt clear.              */
      __IOM uint32_t DCDMIC     : 1;            /*!< (@ 0x00000002) This bit holds the modem DCD interrupt clear.              */
      __IOM uint32_t DSRMIC     : 1;            /*!< (@ 0x00000003) This bit holds the modem DSR interrupt clear.              */
      __IOM uint32_t RXIC       : 1;            /*!< (@ 0x00000004) This bit holds the receive interrupt clear.                */
      __IOM uint32_t TXIC       : 1;            /*!< (@ 0x00000005) This bit holds the transmit interrupt clear.               */
      __IOM uint32_t RTIC       : 1;            /*!< (@ 0x00000006) This bit holds the receive timeout interrupt
                                                                    clear.                                                     */
      __IOM uint32_t FEIC       : 1;            /*!< (@ 0x00000007) This bit holds the framing error interrupt clear.          */
      __IOM uint32_t PEIC       : 1;            /*!< (@ 0x00000008) This bit holds the parity error interrupt clear.           */
      __IOM uint32_t BEIC       : 1;            /*!< (@ 0x00000009) This bit holds the break error interrupt clear.            */
      __IOM uint32_t OEIC       : 1;            /*!< (@ 0x0000000A) This bit holds the overflow interrupt clear.               */
    } IEC_b;
  } ;
} UART0_Type;                                   /*!< Size = 72 (0x48)                                                          */



/* =========================================================================================================================== */
/* ================                                           VCOMP                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Voltage Comparator (VCOMP)
  */

typedef struct {                                /*!< (@ 0x4000C000) VCOMP Structure                                            */
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Configuration Register                                     */
    
    struct {
      __IOM uint32_t PSEL       : 2;            /*!< (@ 0x00000000) This bitfield selects the positive input to the
                                                                    comparator.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t NSEL       : 2;            /*!< (@ 0x00000008) This bitfield selects the negative input to the
                                                                    comparator.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t LVLSEL     : 4;            /*!< (@ 0x00000010) When the reference input NSEL is set to NSEL_DAC,
                                                                    this bitfield selects the voltage level
                                                                    for the negative input to the comparator.                  */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x00000004) Status Register                                            */
    
    struct {
      __IOM uint32_t CMPOUT     : 1;            /*!< (@ 0x00000000) This bit is 1 if the positive input of the comparator
                                                                    is greater than the negative input.                        */
      __IOM uint32_t PWDSTAT    : 1;            /*!< (@ 0x00000001) This bit indicates the power down state of the
                                                                    voltage comparator.                                        */
    } STAT_b;
  } ;
  
  union {
    __IOM uint32_t PWDKEY;                      /*!< (@ 0x00000008) Key Register for Powering Down the Voltage Comparator      */
    
    struct {
      __IOM uint32_t PWDKEY     : 32;           /*!< (@ 0x00000000) Key register value.                                        */
    } PWDKEY_b;
  } ;
  __IM  uint32_t  RESERVED[125];
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Voltage Comparator Interrupt registers: Enable             */
    
    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< (@ 0x00000000) This bit is the vcompout low interrupt.                    */
      __IOM uint32_t OUTHI      : 1;            /*!< (@ 0x00000001) This bit is the vcompout high interrupt.                   */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Voltage Comparator Interrupt registers: Status             */
    
    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< (@ 0x00000000) This bit is the vcompout low interrupt.                    */
      __IOM uint32_t OUTHI      : 1;            /*!< (@ 0x00000001) This bit is the vcompout high interrupt.                   */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Voltage Comparator Interrupt registers: Clear              */
    
    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< (@ 0x00000000) This bit is the vcompout low interrupt.                    */
      __IOM uint32_t OUTHI      : 1;            /*!< (@ 0x00000001) This bit is the vcompout high interrupt.                   */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Voltage Comparator Interrupt registers: Set                */
    
    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< (@ 0x00000000) This bit is the vcompout low interrupt.                    */
      __IOM uint32_t OUTHI      : 1;            /*!< (@ 0x00000001) This bit is the vcompout high interrupt.                   */
    } INTSET_b;
  } ;
} VCOMP_Type;                                   /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                            WDT                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Watchdog Timer (WDT)
  */

typedef struct {                                /*!< (@ 0x40024000) WDT Structure                                              */
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Configuration Register                                     */
    
    struct {
      __IOM uint32_t WDTEN      : 1;            /*!< (@ 0x00000000) This bitfield enables the WDT.                             */
      __IOM uint32_t INTEN      : 1;            /*!< (@ 0x00000001) This bitfield enables the WDT interrupt. Note
                                                                    : This bit must be set before the interrupt
                                                                    status bit will reflect a watchdog timer
                                                                    expiration. The IER interrupt register
                                                                    must also be enabled for a WDT interrupt
                                                                    to be sent to the NVIC.                                    */
      __IOM uint32_t RESEN      : 1;            /*!< (@ 0x00000002) This bitfield enables the WDT reset.                       */
      __IM  uint32_t            : 5;
      __IOM uint32_t RESVAL     : 8;            /*!< (@ 0x00000008) This bitfield is the compare value for counter
                                                                    bits 7:0 to generate a watchdog reset.                     */
      __IOM uint32_t INTVAL     : 8;            /*!< (@ 0x00000010) This bitfield is the compare value for counter
                                                                    bits 7:0 to generate a watchdog interrupt.                 */
      __IOM uint32_t CLKSEL     : 3;            /*!< (@ 0x00000018) Select the frequency for the WDT. All values
                                                                    not enumerated below are undefined.                        */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t RSTRT;                       /*!< (@ 0x00000004) Restart the watchdog timer                                 */
    
    struct {
      __IOM uint32_t RSTRT      : 8;            /*!< (@ 0x00000000) Writing 0xB2 to WDTRSTRT restarts the watchdog
                                                                    timer.                                                     */
    } RSTRT_b;
  } ;
  
  union {
    __IOM uint32_t LOCK;                        /*!< (@ 0x00000008) Locks the WDT                                              */
    
    struct {
      __IOM uint32_t LOCK       : 8;            /*!< (@ 0x00000000) Writing 0x3A locks the watchdog timer. Once locked,
                                                                    the WDTCFG reg cannot be written and WDTEN
                                                                    is set.                                                    */
    } LOCK_b;
  } ;
  
  union {
    __IOM uint32_t COUNT;                       /*!< (@ 0x0000000C) Current Counter Value for WDT                              */
    
    struct {
      __IOM uint32_t COUNT      : 8;            /*!< (@ 0x00000000) Read-Only current value of the WDT counter                 */
    } COUNT_b;
  } ;
  __IM  uint32_t  RESERVED[124];
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) WDT Interrupt register: Enable                             */
    
    struct {
      __IOM uint32_t WDT        : 1;            /*!< (@ 0x00000000) Watchdog Timer Interrupt.                                  */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) WDT Interrupt register: Status                             */
    
    struct {
      __IOM uint32_t WDT        : 1;            /*!< (@ 0x00000000) Watchdog Timer Interrupt.                                  */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) WDT Interrupt register: Clear                              */
    
    struct {
      __IOM uint32_t WDT        : 1;            /*!< (@ 0x00000000) Watchdog Timer Interrupt.                                  */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) WDT Interrupt register: Set                                */
    
    struct {
      __IOM uint32_t WDT        : 1;            /*!< (@ 0x00000000) Watchdog Timer Interrupt.                                  */
    } INTSET_b;
  } ;
} WDT_Type;                                     /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                          CLKGEN                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Clock Generator (CLKGEN)
  */

typedef struct {                                /*!< (@ 0x40004000) CLKGEN Structure                                           */
  
  union {
    __IOM uint32_t CALXT;                       /*!< (@ 0x00000000) XT Oscillator Control                                      */
    
    struct {
      __IOM uint32_t CALXT      : 11;           /*!< (@ 0x00000000) XT Oscillator calibration value                            */
    } CALXT_b;
  } ;
  
  union {
    __IOM uint32_t CALRC;                       /*!< (@ 0x00000004) RC Oscillator Control                                      */
    
    struct {
      __IOM uint32_t CALRC      : 18;           /*!< (@ 0x00000000) LFRC Oscillator calibration value                          */
    } CALRC_b;
  } ;
  
  union {
    __IOM uint32_t ACALCTR;                     /*!< (@ 0x00000008) Autocalibration Counter                                    */
    
    struct {
      __IOM uint32_t ACALCTR    : 24;           /*!< (@ 0x00000000) Autocalibration Counter result.                            */
    } ACALCTR_b;
  } ;
  
  union {
    __IOM uint32_t OCTRL;                       /*!< (@ 0x0000000C) Oscillator Control                                         */
    
    struct {
      __IOM uint32_t STOPXT     : 1;            /*!< (@ 0x00000000) Stop the XT Oscillator to the RTC                          */
      __IOM uint32_t STOPRC     : 1;            /*!< (@ 0x00000001) Stop the LFRC Oscillator to the RTC                        */
      __IM  uint32_t            : 4;
      __IOM uint32_t FOS        : 1;            /*!< (@ 0x00000006) Oscillator switch on failure function                      */
      __IOM uint32_t OSEL       : 1;            /*!< (@ 0x00000007) Selects the RTC oscillator (1 => LFRC, 0 => XT)            */
      __IOM uint32_t ACAL       : 3;            /*!< (@ 0x00000008) Autocalibration control                                    */
    } OCTRL_b;
  } ;
  
  union {
    __IOM uint32_t CLKOUT;                      /*!< (@ 0x00000010) CLKOUT Frequency Select                                    */
    
    struct {
      __IOM uint32_t CKSEL      : 6;            /*!< (@ 0x00000000) CLKOUT signal select                                       */
      __IM  uint32_t            : 1;
      __IOM uint32_t CKEN       : 1;            /*!< (@ 0x00000007) Enable the CLKOUT signal                                   */
    } CLKOUT_b;
  } ;
  
  union {
    __IOM uint32_t CLKKEY;                      /*!< (@ 0x00000014) Key Register for Clock Control Register                    */
    
    struct {
      __IOM uint32_t CLKKEY     : 32;           /*!< (@ 0x00000000) Key register value.                                        */
    } CLKKEY_b;
  } ;
  
  union {
    __IOM uint32_t CCTRL;                       /*!< (@ 0x00000018) HFRC Clock Control                                         */
    
    struct {
      __IOM uint32_t CORESEL    : 1;            /*!< (@ 0x00000000) Core Clock divisor                                         */
    } CCTRL_b;
  } ;
  
  union {
    __IOM uint32_t STATUS;                      /*!< (@ 0x0000001C) Clock Generator Status                                     */
    
    struct {
      __IOM uint32_t OMODE      : 1;            /*!< (@ 0x00000000) Current RTC oscillator (1 => LFRC, 0 => XT)                */
      __IOM uint32_t OSCF       : 1;            /*!< (@ 0x00000001) XT Oscillator is enabled but not oscillating               */
    } STATUS_b;
  } ;
  
  union {
    __IOM uint32_t HFADJ;                       /*!< (@ 0x00000020) HFRC Adjustment                                            */
    
    struct {
      __IOM uint32_t HFADJEN    : 1;            /*!< (@ 0x00000000) HFRC adjustment control                                    */
      __IOM uint32_t HFADJCK    : 3;            /*!< (@ 0x00000001) Repeat period for HFRC adjustment                          */
      __IM  uint32_t            : 4;
      __IOM uint32_t HFXTADJ    : 12;           /*!< (@ 0x00000008) Target HFRC adjustment value.                              */
      __IOM uint32_t HFWARMUP   : 1;            /*!< (@ 0x00000014) XT warmup period for HFRC adjustment                       */
      __IOM uint32_t HFADJ_GAIN : 3;            /*!< (@ 0x00000015) Gain control for HFRC adjustment                           */
    } HFADJ_b;
  } ;
  
  union {
    __IOM uint32_t HFVAL;                       /*!< (@ 0x00000024) HFADJ readback                                             */
    
    struct {
      __IOM uint32_t HFTUNERB   : 11;           /*!< (@ 0x00000000) Current HFTUNE value                                       */
    } HFVAL_b;
  } ;
  
  union {
    __IOM uint32_t CLOCKEN;                     /*!< (@ 0x00000028) Clock Enable Status                                        */
    
    struct {
      __IOM uint32_t CLOCKEN    : 32;           /*!< (@ 0x00000000) Clock enable status                                        */
    } CLOCKEN_b;
  } ;
  
  union {
    __IOM uint32_t CLOCKEN2;                    /*!< (@ 0x0000002C) Clock Enable Status                                        */
    
    struct {
      __IOM uint32_t CLOCKEN2   : 32;           /*!< (@ 0x00000000) Clock enable status 2                                      */
    } CLOCKEN2_b;
  } ;
  
  union {
    __IOM uint32_t CLOCKEN3;                    /*!< (@ 0x00000030) Clock Enable Status                                        */
    
    struct {
      __IOM uint32_t CLOCKEN3   : 32;           /*!< (@ 0x00000000) Clock enable status 3                                      */
    } CLOCKEN3_b;
  } ;
  
  union {
    __IOM uint32_t UARTEN;                      /*!< (@ 0x00000034) UART Enable                                                */
    
    struct {
      __IOM uint32_t UART0EN    : 2;            /*!< (@ 0x00000000) UART0 system clock control                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t UART1EN    : 2;            /*!< (@ 0x00000008) UART1 system clock control                                 */
    } UARTEN_b;
  } ;
  __IM  uint32_t  RESERVED[2];
  
  union {
    __IOM uint32_t CTRLOW;                      /*!< (@ 0x00000040) RTC Counters Lower                                         */
    
    struct {
      __IOM uint32_t CTR100     : 8;            /*!< (@ 0x00000000) 100ths of a second Counter                                 */
      __IOM uint32_t CTRSEC     : 7;            /*!< (@ 0x00000008) Seconds Counter                                            */
      __IM  uint32_t            : 1;
      __IOM uint32_t CTRMIN     : 7;            /*!< (@ 0x00000010) Minutes Counter                                            */
      __IM  uint32_t            : 1;
      __IOM uint32_t CTRHR      : 6;            /*!< (@ 0x00000018) Hours Counter                                              */
    } CTRLOW_b;
  } ;
  
  union {
    __IOM uint32_t CTRUP;                       /*!< (@ 0x00000044) RTC Counters Upper                                         */
    
    struct {
      __IOM uint32_t CTRDATE    : 6;            /*!< (@ 0x00000000) Date Counter                                               */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTRMO      : 5;            /*!< (@ 0x00000008) Months Counter                                             */
      __IM  uint32_t            : 3;
      __IOM uint32_t CTRYR      : 8;            /*!< (@ 0x00000010) Years Counter                                              */
      __IOM uint32_t CTRWKDY    : 3;            /*!< (@ 0x00000018) Weekdays Counter                                           */
      __IOM uint32_t CB         : 1;            /*!< (@ 0x0000001B) Century                                                    */
      __IOM uint32_t CEB        : 1;            /*!< (@ 0x0000001C) Century enable                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTERR      : 1;            /*!< (@ 0x0000001F) Counter read error status                                  */
    } CTRUP_b;
  } ;
  
  union {
    __IOM uint32_t ALMLOW;                      /*!< (@ 0x00000048) RTC Alarms Lower                                           */
    
    struct {
      __IOM uint32_t ALM100     : 8;            /*!< (@ 0x00000000) 100ths of a second Alarm                                   */
      __IOM uint32_t ALMSEC     : 7;            /*!< (@ 0x00000008) Seconds Alarm                                              */
      __IM  uint32_t            : 1;
      __IOM uint32_t ALMMIN     : 7;            /*!< (@ 0x00000010) Minutes Alarm                                              */
      __IM  uint32_t            : 1;
      __IOM uint32_t ALMHR      : 6;            /*!< (@ 0x00000018) Hours Alarm                                                */
    } ALMLOW_b;
  } ;
  
  union {
    __IOM uint32_t ALMUP;                       /*!< (@ 0x0000004C) RTC Alarms Upper                                           */
    
    struct {
      __IOM uint32_t ALMDATE    : 6;            /*!< (@ 0x00000000) Date Alarm                                                 */
      __IM  uint32_t            : 2;
      __IOM uint32_t ALMMO      : 5;            /*!< (@ 0x00000008) Months Alarm                                               */
      __IM  uint32_t            : 3;
      __IOM uint32_t ALMWKDY    : 3;            /*!< (@ 0x00000010) Weekdays Alarm                                             */
    } ALMUP_b;
  } ;
  
  union {
    __IOM uint32_t RTCCTL;                      /*!< (@ 0x00000050) RTC Control Register                                       */
    
    struct {
      __IOM uint32_t WRTC       : 1;            /*!< (@ 0x00000000) Counter write control                                      */
      __IOM uint32_t RPT        : 3;            /*!< (@ 0x00000001) Alarm repeat interval                                      */
      __IOM uint32_t RSTOP      : 1;            /*!< (@ 0x00000004) RTC input clock control                                    */
      __IOM uint32_t HR1224     : 1;            /*!< (@ 0x00000005) Hours Counter mode                                         */
    } RTCCTL_b;
  } ;
  __IM  uint32_t  RESERVED1[43];
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000100) CLKGEN Interrupt Register: Enable                          */
    
    struct {
      __IOM uint32_t ACF        : 1;            /*!< (@ 0x00000000) Autocalibration Fail interrupt                             */
      __IOM uint32_t ACC        : 1;            /*!< (@ 0x00000001) Autocalibration Complete interrupt                         */
      __IOM uint32_t OF         : 1;            /*!< (@ 0x00000002) XT Oscillator Fail interrupt                               */
      __IOM uint32_t ALM        : 1;            /*!< (@ 0x00000003) RTC Alarm interrupt                                        */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000104) CLKGEN Interrupt Register: Status                          */
    
    struct {
      __IOM uint32_t ACF        : 1;            /*!< (@ 0x00000000) Autocalibration Fail interrupt                             */
      __IOM uint32_t ACC        : 1;            /*!< (@ 0x00000001) Autocalibration Complete interrupt                         */
      __IOM uint32_t OF         : 1;            /*!< (@ 0x00000002) XT Oscillator Fail interrupt                               */
      __IOM uint32_t ALM        : 1;            /*!< (@ 0x00000003) RTC Alarm interrupt                                        */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000108) CLKGEN Interrupt Register: Clear                           */
    
    struct {
      __IOM uint32_t ACF        : 1;            /*!< (@ 0x00000000) Autocalibration Fail interrupt                             */
      __IOM uint32_t ACC        : 1;            /*!< (@ 0x00000001) Autocalibration Complete interrupt                         */
      __IOM uint32_t OF         : 1;            /*!< (@ 0x00000002) XT Oscillator Fail interrupt                               */
      __IOM uint32_t ALM        : 1;            /*!< (@ 0x00000003) RTC Alarm interrupt                                        */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000010C) CLKGEN Interrupt Register: Set                             */
    
    struct {
      __IOM uint32_t ACF        : 1;            /*!< (@ 0x00000000) Autocalibration Fail interrupt                             */
      __IOM uint32_t ACC        : 1;            /*!< (@ 0x00000001) Autocalibration Complete interrupt                         */
      __IOM uint32_t OF         : 1;            /*!< (@ 0x00000002) XT Oscillator Fail interrupt                               */
      __IOM uint32_t ALM        : 1;            /*!< (@ 0x00000003) RTC Alarm interrupt                                        */
    } INTSET_b;
  } ;
} CLKGEN_Type;                                  /*!< Size = 272 (0x110)                                                        */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================  End of section using anonymous unions  ========================================= */
#if defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#endif


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */

#define ADC_BASE                    0x50010000UL
#define CACHECTRL_BASE              0x40018000UL
#define CTIMER_BASE                 0x40008000UL
#define GPIO_BASE                   0x40010000UL
#define IOMSTR0_BASE                0x50004000UL
#define IOMSTR1_BASE                0x50005000UL
#define IOMSTR2_BASE                0x50006000UL
#define IOMSTR3_BASE                0x50007000UL
#define IOMSTR4_BASE                0x50008000UL
#define IOMSTR5_BASE                0x50009000UL
#define IOSLAVE_BASE                0x50000000UL
#define MCUCTRL_BASE                0x40020000UL
#define PDM_BASE                    0x50011000UL
#define PWRCTRL_BASE                0x40021000UL
#define RSTGEN_BASE                 0x40000000UL
#define UART0_BASE                  0x4001C000UL
#define UART1_BASE                  0x4001D000UL
#define VCOMP_BASE                  0x4000C000UL
#define WDT_BASE                    0x40024000UL
#define CLKGEN_BASE                 0x40004000UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_declaration
  * @{
  */

#define ADC                         ((ADC_Type*)               ADC_BASE)
#define CACHECTRL                   ((CACHECTRL_Type*)         CACHECTRL_BASE)
#define CTIMER                      ((CTIMER_Type*)            CTIMER_BASE)
#define GPIO                        ((GPIO_Type*)              GPIO_BASE)
#define IOMSTR0                     ((IOMSTR0_Type*)           IOMSTR0_BASE)
#define IOMSTR1                     ((IOMSTR0_Type*)           IOMSTR1_BASE)
#define IOMSTR2                     ((IOMSTR0_Type*)           IOMSTR2_BASE)
#define IOMSTR3                     ((IOMSTR0_Type*)           IOMSTR3_BASE)
#define IOMSTR4                     ((IOMSTR0_Type*)           IOMSTR4_BASE)
#define IOMSTR5                     ((IOMSTR0_Type*)           IOMSTR5_BASE)
#define IOSLAVE                     ((IOSLAVE_Type*)           IOSLAVE_BASE)
#define MCUCTRL                     ((MCUCTRL_Type*)           MCUCTRL_BASE)
#define PDM                         ((PDM_Type*)               PDM_BASE)
#define PWRCTRL                     ((PWRCTRL_Type*)           PWRCTRL_BASE)
#define RSTGEN                      ((RSTGEN_Type*)            RSTGEN_BASE)
#define UART0                       ((UART0_Type*)             UART0_BASE)
#define UART1                       ((UART0_Type*)             UART1_BASE)
#define VCOMP                       ((VCOMP_Type*)             VCOMP_BASE)
#define WDT                         ((WDT_Type*)               WDT_BASE)
#define CLKGEN                      ((CLKGEN_Type*)            CLKGEN_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */


/* =========================================================================================================================== */
/* ================                                Pos/Mask Peripheral Section                                ================ */
/* =========================================================================================================================== */


/** @addtogroup PosMask_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
#define ADC_CFG_CLKSEL_Pos                (24UL)                    /*!< ADC CFG: CLKSEL (Bit 24)                              */
#define ADC_CFG_CLKSEL_Msk                (0x3000000UL)             /*!< ADC CFG: CLKSEL (Bitfield-Mask: 0x03)                 */
#define ADC_CFG_TRIGPOL_Pos               (19UL)                    /*!< ADC CFG: TRIGPOL (Bit 19)                             */
#define ADC_CFG_TRIGPOL_Msk               (0x80000UL)               /*!< ADC CFG: TRIGPOL (Bitfield-Mask: 0x01)                */
#define ADC_CFG_TRIGSEL_Pos               (16UL)                    /*!< ADC CFG: TRIGSEL (Bit 16)                             */
#define ADC_CFG_TRIGSEL_Msk               (0x70000UL)               /*!< ADC CFG: TRIGSEL (Bitfield-Mask: 0x07)                */
#define ADC_CFG_REFSEL_Pos                (8UL)                     /*!< ADC CFG: REFSEL (Bit 8)                               */
#define ADC_CFG_REFSEL_Msk                (0x300UL)                 /*!< ADC CFG: REFSEL (Bitfield-Mask: 0x03)                 */
#define ADC_CFG_CKMODE_Pos                (4UL)                     /*!< ADC CFG: CKMODE (Bit 4)                               */
#define ADC_CFG_CKMODE_Msk                (0x10UL)                  /*!< ADC CFG: CKMODE (Bitfield-Mask: 0x01)                 */
#define ADC_CFG_LPMODE_Pos                (3UL)                     /*!< ADC CFG: LPMODE (Bit 3)                               */
#define ADC_CFG_LPMODE_Msk                (0x8UL)                   /*!< ADC CFG: LPMODE (Bitfield-Mask: 0x01)                 */
#define ADC_CFG_RPTEN_Pos                 (2UL)                     /*!< ADC CFG: RPTEN (Bit 2)                                */
#define ADC_CFG_RPTEN_Msk                 (0x4UL)                   /*!< ADC CFG: RPTEN (Bitfield-Mask: 0x01)                  */
#define ADC_CFG_ADCEN_Pos                 (0UL)                     /*!< ADC CFG: ADCEN (Bit 0)                                */
#define ADC_CFG_ADCEN_Msk                 (0x1UL)                   /*!< ADC CFG: ADCEN (Bitfield-Mask: 0x01)                  */
/* =========================================================  STAT  ========================================================== */
#define ADC_STAT_PWDSTAT_Pos              (0UL)                     /*!< ADC STAT: PWDSTAT (Bit 0)                             */
#define ADC_STAT_PWDSTAT_Msk              (0x1UL)                   /*!< ADC STAT: PWDSTAT (Bitfield-Mask: 0x01)               */
/* ==========================================================  SWT  ========================================================== */
#define ADC_SWT_SWT_Pos                   (0UL)                     /*!< ADC SWT: SWT (Bit 0)                                  */
#define ADC_SWT_SWT_Msk                   (0xffUL)                  /*!< ADC SWT: SWT (Bitfield-Mask: 0xff)                    */
/* ========================================================  SL0CFG  ========================================================= */
#define ADC_SL0CFG_ADSEL0_Pos             (24UL)                    /*!< ADC SL0CFG: ADSEL0 (Bit 24)                           */
#define ADC_SL0CFG_ADSEL0_Msk             (0x7000000UL)             /*!< ADC SL0CFG: ADSEL0 (Bitfield-Mask: 0x07)              */
#define ADC_SL0CFG_PRMODE0_Pos            (16UL)                    /*!< ADC SL0CFG: PRMODE0 (Bit 16)                          */
#define ADC_SL0CFG_PRMODE0_Msk            (0x30000UL)               /*!< ADC SL0CFG: PRMODE0 (Bitfield-Mask: 0x03)             */
#define ADC_SL0CFG_CHSEL0_Pos             (8UL)                     /*!< ADC SL0CFG: CHSEL0 (Bit 8)                            */
#define ADC_SL0CFG_CHSEL0_Msk             (0xf00UL)                 /*!< ADC SL0CFG: CHSEL0 (Bitfield-Mask: 0x0f)              */
#define ADC_SL0CFG_WCEN0_Pos              (1UL)                     /*!< ADC SL0CFG: WCEN0 (Bit 1)                             */
#define ADC_SL0CFG_WCEN0_Msk              (0x2UL)                   /*!< ADC SL0CFG: WCEN0 (Bitfield-Mask: 0x01)               */
#define ADC_SL0CFG_SLEN0_Pos              (0UL)                     /*!< ADC SL0CFG: SLEN0 (Bit 0)                             */
#define ADC_SL0CFG_SLEN0_Msk              (0x1UL)                   /*!< ADC SL0CFG: SLEN0 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL1CFG  ========================================================= */
#define ADC_SL1CFG_ADSEL1_Pos             (24UL)                    /*!< ADC SL1CFG: ADSEL1 (Bit 24)                           */
#define ADC_SL1CFG_ADSEL1_Msk             (0x7000000UL)             /*!< ADC SL1CFG: ADSEL1 (Bitfield-Mask: 0x07)              */
#define ADC_SL1CFG_PRMODE1_Pos            (16UL)                    /*!< ADC SL1CFG: PRMODE1 (Bit 16)                          */
#define ADC_SL1CFG_PRMODE1_Msk            (0x30000UL)               /*!< ADC SL1CFG: PRMODE1 (Bitfield-Mask: 0x03)             */
#define ADC_SL1CFG_CHSEL1_Pos             (8UL)                     /*!< ADC SL1CFG: CHSEL1 (Bit 8)                            */
#define ADC_SL1CFG_CHSEL1_Msk             (0xf00UL)                 /*!< ADC SL1CFG: CHSEL1 (Bitfield-Mask: 0x0f)              */
#define ADC_SL1CFG_WCEN1_Pos              (1UL)                     /*!< ADC SL1CFG: WCEN1 (Bit 1)                             */
#define ADC_SL1CFG_WCEN1_Msk              (0x2UL)                   /*!< ADC SL1CFG: WCEN1 (Bitfield-Mask: 0x01)               */
#define ADC_SL1CFG_SLEN1_Pos              (0UL)                     /*!< ADC SL1CFG: SLEN1 (Bit 0)                             */
#define ADC_SL1CFG_SLEN1_Msk              (0x1UL)                   /*!< ADC SL1CFG: SLEN1 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL2CFG  ========================================================= */
#define ADC_SL2CFG_ADSEL2_Pos             (24UL)                    /*!< ADC SL2CFG: ADSEL2 (Bit 24)                           */
#define ADC_SL2CFG_ADSEL2_Msk             (0x7000000UL)             /*!< ADC SL2CFG: ADSEL2 (Bitfield-Mask: 0x07)              */
#define ADC_SL2CFG_PRMODE2_Pos            (16UL)                    /*!< ADC SL2CFG: PRMODE2 (Bit 16)                          */
#define ADC_SL2CFG_PRMODE2_Msk            (0x30000UL)               /*!< ADC SL2CFG: PRMODE2 (Bitfield-Mask: 0x03)             */
#define ADC_SL2CFG_CHSEL2_Pos             (8UL)                     /*!< ADC SL2CFG: CHSEL2 (Bit 8)                            */
#define ADC_SL2CFG_CHSEL2_Msk             (0xf00UL)                 /*!< ADC SL2CFG: CHSEL2 (Bitfield-Mask: 0x0f)              */
#define ADC_SL2CFG_WCEN2_Pos              (1UL)                     /*!< ADC SL2CFG: WCEN2 (Bit 1)                             */
#define ADC_SL2CFG_WCEN2_Msk              (0x2UL)                   /*!< ADC SL2CFG: WCEN2 (Bitfield-Mask: 0x01)               */
#define ADC_SL2CFG_SLEN2_Pos              (0UL)                     /*!< ADC SL2CFG: SLEN2 (Bit 0)                             */
#define ADC_SL2CFG_SLEN2_Msk              (0x1UL)                   /*!< ADC SL2CFG: SLEN2 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL3CFG  ========================================================= */
#define ADC_SL3CFG_ADSEL3_Pos             (24UL)                    /*!< ADC SL3CFG: ADSEL3 (Bit 24)                           */
#define ADC_SL3CFG_ADSEL3_Msk             (0x7000000UL)             /*!< ADC SL3CFG: ADSEL3 (Bitfield-Mask: 0x07)              */
#define ADC_SL3CFG_PRMODE3_Pos            (16UL)                    /*!< ADC SL3CFG: PRMODE3 (Bit 16)                          */
#define ADC_SL3CFG_PRMODE3_Msk            (0x30000UL)               /*!< ADC SL3CFG: PRMODE3 (Bitfield-Mask: 0x03)             */
#define ADC_SL3CFG_CHSEL3_Pos             (8UL)                     /*!< ADC SL3CFG: CHSEL3 (Bit 8)                            */
#define ADC_SL3CFG_CHSEL3_Msk             (0xf00UL)                 /*!< ADC SL3CFG: CHSEL3 (Bitfield-Mask: 0x0f)              */
#define ADC_SL3CFG_WCEN3_Pos              (1UL)                     /*!< ADC SL3CFG: WCEN3 (Bit 1)                             */
#define ADC_SL3CFG_WCEN3_Msk              (0x2UL)                   /*!< ADC SL3CFG: WCEN3 (Bitfield-Mask: 0x01)               */
#define ADC_SL3CFG_SLEN3_Pos              (0UL)                     /*!< ADC SL3CFG: SLEN3 (Bit 0)                             */
#define ADC_SL3CFG_SLEN3_Msk              (0x1UL)                   /*!< ADC SL3CFG: SLEN3 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL4CFG  ========================================================= */
#define ADC_SL4CFG_ADSEL4_Pos             (24UL)                    /*!< ADC SL4CFG: ADSEL4 (Bit 24)                           */
#define ADC_SL4CFG_ADSEL4_Msk             (0x7000000UL)             /*!< ADC SL4CFG: ADSEL4 (Bitfield-Mask: 0x07)              */
#define ADC_SL4CFG_PRMODE4_Pos            (16UL)                    /*!< ADC SL4CFG: PRMODE4 (Bit 16)                          */
#define ADC_SL4CFG_PRMODE4_Msk            (0x30000UL)               /*!< ADC SL4CFG: PRMODE4 (Bitfield-Mask: 0x03)             */
#define ADC_SL4CFG_CHSEL4_Pos             (8UL)                     /*!< ADC SL4CFG: CHSEL4 (Bit 8)                            */
#define ADC_SL4CFG_CHSEL4_Msk             (0xf00UL)                 /*!< ADC SL4CFG: CHSEL4 (Bitfield-Mask: 0x0f)              */
#define ADC_SL4CFG_WCEN4_Pos              (1UL)                     /*!< ADC SL4CFG: WCEN4 (Bit 1)                             */
#define ADC_SL4CFG_WCEN4_Msk              (0x2UL)                   /*!< ADC SL4CFG: WCEN4 (Bitfield-Mask: 0x01)               */
#define ADC_SL4CFG_SLEN4_Pos              (0UL)                     /*!< ADC SL4CFG: SLEN4 (Bit 0)                             */
#define ADC_SL4CFG_SLEN4_Msk              (0x1UL)                   /*!< ADC SL4CFG: SLEN4 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL5CFG  ========================================================= */
#define ADC_SL5CFG_ADSEL5_Pos             (24UL)                    /*!< ADC SL5CFG: ADSEL5 (Bit 24)                           */
#define ADC_SL5CFG_ADSEL5_Msk             (0x7000000UL)             /*!< ADC SL5CFG: ADSEL5 (Bitfield-Mask: 0x07)              */
#define ADC_SL5CFG_PRMODE5_Pos            (16UL)                    /*!< ADC SL5CFG: PRMODE5 (Bit 16)                          */
#define ADC_SL5CFG_PRMODE5_Msk            (0x30000UL)               /*!< ADC SL5CFG: PRMODE5 (Bitfield-Mask: 0x03)             */
#define ADC_SL5CFG_CHSEL5_Pos             (8UL)                     /*!< ADC SL5CFG: CHSEL5 (Bit 8)                            */
#define ADC_SL5CFG_CHSEL5_Msk             (0xf00UL)                 /*!< ADC SL5CFG: CHSEL5 (Bitfield-Mask: 0x0f)              */
#define ADC_SL5CFG_WCEN5_Pos              (1UL)                     /*!< ADC SL5CFG: WCEN5 (Bit 1)                             */
#define ADC_SL5CFG_WCEN5_Msk              (0x2UL)                   /*!< ADC SL5CFG: WCEN5 (Bitfield-Mask: 0x01)               */
#define ADC_SL5CFG_SLEN5_Pos              (0UL)                     /*!< ADC SL5CFG: SLEN5 (Bit 0)                             */
#define ADC_SL5CFG_SLEN5_Msk              (0x1UL)                   /*!< ADC SL5CFG: SLEN5 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL6CFG  ========================================================= */
#define ADC_SL6CFG_ADSEL6_Pos             (24UL)                    /*!< ADC SL6CFG: ADSEL6 (Bit 24)                           */
#define ADC_SL6CFG_ADSEL6_Msk             (0x7000000UL)             /*!< ADC SL6CFG: ADSEL6 (Bitfield-Mask: 0x07)              */
#define ADC_SL6CFG_PRMODE6_Pos            (16UL)                    /*!< ADC SL6CFG: PRMODE6 (Bit 16)                          */
#define ADC_SL6CFG_PRMODE6_Msk            (0x30000UL)               /*!< ADC SL6CFG: PRMODE6 (Bitfield-Mask: 0x03)             */
#define ADC_SL6CFG_CHSEL6_Pos             (8UL)                     /*!< ADC SL6CFG: CHSEL6 (Bit 8)                            */
#define ADC_SL6CFG_CHSEL6_Msk             (0xf00UL)                 /*!< ADC SL6CFG: CHSEL6 (Bitfield-Mask: 0x0f)              */
#define ADC_SL6CFG_WCEN6_Pos              (1UL)                     /*!< ADC SL6CFG: WCEN6 (Bit 1)                             */
#define ADC_SL6CFG_WCEN6_Msk              (0x2UL)                   /*!< ADC SL6CFG: WCEN6 (Bitfield-Mask: 0x01)               */
#define ADC_SL6CFG_SLEN6_Pos              (0UL)                     /*!< ADC SL6CFG: SLEN6 (Bit 0)                             */
#define ADC_SL6CFG_SLEN6_Msk              (0x1UL)                   /*!< ADC SL6CFG: SLEN6 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL7CFG  ========================================================= */
#define ADC_SL7CFG_ADSEL7_Pos             (24UL)                    /*!< ADC SL7CFG: ADSEL7 (Bit 24)                           */
#define ADC_SL7CFG_ADSEL7_Msk             (0x7000000UL)             /*!< ADC SL7CFG: ADSEL7 (Bitfield-Mask: 0x07)              */
#define ADC_SL7CFG_PRMODE7_Pos            (16UL)                    /*!< ADC SL7CFG: PRMODE7 (Bit 16)                          */
#define ADC_SL7CFG_PRMODE7_Msk            (0x30000UL)               /*!< ADC SL7CFG: PRMODE7 (Bitfield-Mask: 0x03)             */
#define ADC_SL7CFG_CHSEL7_Pos             (8UL)                     /*!< ADC SL7CFG: CHSEL7 (Bit 8)                            */
#define ADC_SL7CFG_CHSEL7_Msk             (0xf00UL)                 /*!< ADC SL7CFG: CHSEL7 (Bitfield-Mask: 0x0f)              */
#define ADC_SL7CFG_WCEN7_Pos              (1UL)                     /*!< ADC SL7CFG: WCEN7 (Bit 1)                             */
#define ADC_SL7CFG_WCEN7_Msk              (0x2UL)                   /*!< ADC SL7CFG: WCEN7 (Bitfield-Mask: 0x01)               */
#define ADC_SL7CFG_SLEN7_Pos              (0UL)                     /*!< ADC SL7CFG: SLEN7 (Bit 0)                             */
#define ADC_SL7CFG_SLEN7_Msk              (0x1UL)                   /*!< ADC SL7CFG: SLEN7 (Bitfield-Mask: 0x01)               */
/* =========================================================  WULIM  ========================================================= */
#define ADC_WULIM_ULIM_Pos                (0UL)                     /*!< ADC WULIM: ULIM (Bit 0)                               */
#define ADC_WULIM_ULIM_Msk                (0xfffffUL)               /*!< ADC WULIM: ULIM (Bitfield-Mask: 0xfffff)              */
/* =========================================================  WLLIM  ========================================================= */
#define ADC_WLLIM_LLIM_Pos                (0UL)                     /*!< ADC WLLIM: LLIM (Bit 0)                               */
#define ADC_WLLIM_LLIM_Msk                (0xfffffUL)               /*!< ADC WLLIM: LLIM (Bitfield-Mask: 0xfffff)              */
/* =========================================================  FIFO  ========================================================== */
#define ADC_FIFO_RSVD_Pos                 (31UL)                    /*!< ADC FIFO: RSVD (Bit 31)                               */
#define ADC_FIFO_RSVD_Msk                 (0x80000000UL)            /*!< ADC FIFO: RSVD (Bitfield-Mask: 0x01)                  */
#define ADC_FIFO_SLOTNUM_Pos              (28UL)                    /*!< ADC FIFO: SLOTNUM (Bit 28)                            */
#define ADC_FIFO_SLOTNUM_Msk              (0x70000000UL)            /*!< ADC FIFO: SLOTNUM (Bitfield-Mask: 0x07)               */
#define ADC_FIFO_COUNT_Pos                (20UL)                    /*!< ADC FIFO: COUNT (Bit 20)                              */
#define ADC_FIFO_COUNT_Msk                (0xff00000UL)             /*!< ADC FIFO: COUNT (Bitfield-Mask: 0xff)                 */
#define ADC_FIFO_DATA_Pos                 (0UL)                     /*!< ADC FIFO: DATA (Bit 0)                                */
#define ADC_FIFO_DATA_Msk                 (0xfffffUL)               /*!< ADC FIFO: DATA (Bitfield-Mask: 0xfffff)               */
/* =========================================================  INTEN  ========================================================= */
#define ADC_INTEN_WCINC_Pos               (5UL)                     /*!< ADC INTEN: WCINC (Bit 5)                              */
#define ADC_INTEN_WCINC_Msk               (0x20UL)                  /*!< ADC INTEN: WCINC (Bitfield-Mask: 0x01)                */
#define ADC_INTEN_WCEXC_Pos               (4UL)                     /*!< ADC INTEN: WCEXC (Bit 4)                              */
#define ADC_INTEN_WCEXC_Msk               (0x10UL)                  /*!< ADC INTEN: WCEXC (Bitfield-Mask: 0x01)                */
#define ADC_INTEN_FIFOOVR2_Pos            (3UL)                     /*!< ADC INTEN: FIFOOVR2 (Bit 3)                           */
#define ADC_INTEN_FIFOOVR2_Msk            (0x8UL)                   /*!< ADC INTEN: FIFOOVR2 (Bitfield-Mask: 0x01)             */
#define ADC_INTEN_FIFOOVR1_Pos            (2UL)                     /*!< ADC INTEN: FIFOOVR1 (Bit 2)                           */
#define ADC_INTEN_FIFOOVR1_Msk            (0x4UL)                   /*!< ADC INTEN: FIFOOVR1 (Bitfield-Mask: 0x01)             */
#define ADC_INTEN_SCNCMP_Pos              (1UL)                     /*!< ADC INTEN: SCNCMP (Bit 1)                             */
#define ADC_INTEN_SCNCMP_Msk              (0x2UL)                   /*!< ADC INTEN: SCNCMP (Bitfield-Mask: 0x01)               */
#define ADC_INTEN_CNVCMP_Pos              (0UL)                     /*!< ADC INTEN: CNVCMP (Bit 0)                             */
#define ADC_INTEN_CNVCMP_Msk              (0x1UL)                   /*!< ADC INTEN: CNVCMP (Bitfield-Mask: 0x01)               */
/* ========================================================  INTSTAT  ======================================================== */
#define ADC_INTSTAT_WCINC_Pos             (5UL)                     /*!< ADC INTSTAT: WCINC (Bit 5)                            */
#define ADC_INTSTAT_WCINC_Msk             (0x20UL)                  /*!< ADC INTSTAT: WCINC (Bitfield-Mask: 0x01)              */
#define ADC_INTSTAT_WCEXC_Pos             (4UL)                     /*!< ADC INTSTAT: WCEXC (Bit 4)                            */
#define ADC_INTSTAT_WCEXC_Msk             (0x10UL)                  /*!< ADC INTSTAT: WCEXC (Bitfield-Mask: 0x01)              */
#define ADC_INTSTAT_FIFOOVR2_Pos          (3UL)                     /*!< ADC INTSTAT: FIFOOVR2 (Bit 3)                         */
#define ADC_INTSTAT_FIFOOVR2_Msk          (0x8UL)                   /*!< ADC INTSTAT: FIFOOVR2 (Bitfield-Mask: 0x01)           */
#define ADC_INTSTAT_FIFOOVR1_Pos          (2UL)                     /*!< ADC INTSTAT: FIFOOVR1 (Bit 2)                         */
#define ADC_INTSTAT_FIFOOVR1_Msk          (0x4UL)                   /*!< ADC INTSTAT: FIFOOVR1 (Bitfield-Mask: 0x01)           */
#define ADC_INTSTAT_SCNCMP_Pos            (1UL)                     /*!< ADC INTSTAT: SCNCMP (Bit 1)                           */
#define ADC_INTSTAT_SCNCMP_Msk            (0x2UL)                   /*!< ADC INTSTAT: SCNCMP (Bitfield-Mask: 0x01)             */
#define ADC_INTSTAT_CNVCMP_Pos            (0UL)                     /*!< ADC INTSTAT: CNVCMP (Bit 0)                           */
#define ADC_INTSTAT_CNVCMP_Msk            (0x1UL)                   /*!< ADC INTSTAT: CNVCMP (Bitfield-Mask: 0x01)             */
/* ========================================================  INTCLR  ========================================================= */
#define ADC_INTCLR_WCINC_Pos              (5UL)                     /*!< ADC INTCLR: WCINC (Bit 5)                             */
#define ADC_INTCLR_WCINC_Msk              (0x20UL)                  /*!< ADC INTCLR: WCINC (Bitfield-Mask: 0x01)               */
#define ADC_INTCLR_WCEXC_Pos              (4UL)                     /*!< ADC INTCLR: WCEXC (Bit 4)                             */
#define ADC_INTCLR_WCEXC_Msk              (0x10UL)                  /*!< ADC INTCLR: WCEXC (Bitfield-Mask: 0x01)               */
#define ADC_INTCLR_FIFOOVR2_Pos           (3UL)                     /*!< ADC INTCLR: FIFOOVR2 (Bit 3)                          */
#define ADC_INTCLR_FIFOOVR2_Msk           (0x8UL)                   /*!< ADC INTCLR: FIFOOVR2 (Bitfield-Mask: 0x01)            */
#define ADC_INTCLR_FIFOOVR1_Pos           (2UL)                     /*!< ADC INTCLR: FIFOOVR1 (Bit 2)                          */
#define ADC_INTCLR_FIFOOVR1_Msk           (0x4UL)                   /*!< ADC INTCLR: FIFOOVR1 (Bitfield-Mask: 0x01)            */
#define ADC_INTCLR_SCNCMP_Pos             (1UL)                     /*!< ADC INTCLR: SCNCMP (Bit 1)                            */
#define ADC_INTCLR_SCNCMP_Msk             (0x2UL)                   /*!< ADC INTCLR: SCNCMP (Bitfield-Mask: 0x01)              */
#define ADC_INTCLR_CNVCMP_Pos             (0UL)                     /*!< ADC INTCLR: CNVCMP (Bit 0)                            */
#define ADC_INTCLR_CNVCMP_Msk             (0x1UL)                   /*!< ADC INTCLR: CNVCMP (Bitfield-Mask: 0x01)              */
/* ========================================================  INTSET  ========================================================= */
#define ADC_INTSET_WCINC_Pos              (5UL)                     /*!< ADC INTSET: WCINC (Bit 5)                             */
#define ADC_INTSET_WCINC_Msk              (0x20UL)                  /*!< ADC INTSET: WCINC (Bitfield-Mask: 0x01)               */
#define ADC_INTSET_WCEXC_Pos              (4UL)                     /*!< ADC INTSET: WCEXC (Bit 4)                             */
#define ADC_INTSET_WCEXC_Msk              (0x10UL)                  /*!< ADC INTSET: WCEXC (Bitfield-Mask: 0x01)               */
#define ADC_INTSET_FIFOOVR2_Pos           (3UL)                     /*!< ADC INTSET: FIFOOVR2 (Bit 3)                          */
#define ADC_INTSET_FIFOOVR2_Msk           (0x8UL)                   /*!< ADC INTSET: FIFOOVR2 (Bitfield-Mask: 0x01)            */
#define ADC_INTSET_FIFOOVR1_Pos           (2UL)                     /*!< ADC INTSET: FIFOOVR1 (Bit 2)                          */
#define ADC_INTSET_FIFOOVR1_Msk           (0x4UL)                   /*!< ADC INTSET: FIFOOVR1 (Bitfield-Mask: 0x01)            */
#define ADC_INTSET_SCNCMP_Pos             (1UL)                     /*!< ADC INTSET: SCNCMP (Bit 1)                            */
#define ADC_INTSET_SCNCMP_Msk             (0x2UL)                   /*!< ADC INTSET: SCNCMP (Bitfield-Mask: 0x01)              */
#define ADC_INTSET_CNVCMP_Pos             (0UL)                     /*!< ADC INTSET: CNVCMP (Bit 0)                            */
#define ADC_INTSET_CNVCMP_Msk             (0x1UL)                   /*!< ADC INTSET: CNVCMP (Bitfield-Mask: 0x01)              */


/* =========================================================================================================================== */
/* ================                                         CACHECTRL                                         ================ */
/* =========================================================================================================================== */

/* =======================================================  CACHECFG  ======================================================== */
#define CACHECTRL_CACHECFG_ENABLE_MONITOR_Pos (24UL)                /*!< CACHECTRL CACHECFG: ENABLE_MONITOR (Bit 24)           */
#define CACHECTRL_CACHECFG_ENABLE_MONITOR_Msk (0x1000000UL)         /*!< CACHECTRL CACHECFG: ENABLE_MONITOR (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECFG_DATA_CLKGATE_Pos (20UL)                  /*!< CACHECTRL CACHECFG: DATA_CLKGATE (Bit 20)             */
#define CACHECTRL_CACHECFG_DATA_CLKGATE_Msk (0x100000UL)            /*!< CACHECTRL CACHECFG: DATA_CLKGATE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECFG_SMDLY_Pos      (16UL)                    /*!< CACHECTRL CACHECFG: SMDLY (Bit 16)                    */
#define CACHECTRL_CACHECFG_SMDLY_Msk      (0xf0000UL)               /*!< CACHECTRL CACHECFG: SMDLY (Bitfield-Mask: 0x0f)       */
#define CACHECTRL_CACHECFG_DLY_Pos        (12UL)                    /*!< CACHECTRL CACHECFG: DLY (Bit 12)                      */
#define CACHECTRL_CACHECFG_DLY_Msk        (0xf000UL)                /*!< CACHECTRL CACHECFG: DLY (Bitfield-Mask: 0x0f)         */
#define CACHECTRL_CACHECFG_CACHE_LS_Pos   (11UL)                    /*!< CACHECTRL CACHECFG: CACHE_LS (Bit 11)                 */
#define CACHECTRL_CACHECFG_CACHE_LS_Msk   (0x800UL)                 /*!< CACHECTRL CACHECFG: CACHE_LS (Bitfield-Mask: 0x01)    */
#define CACHECTRL_CACHECFG_CACHE_CLKGATE_Pos (10UL)                 /*!< CACHECTRL CACHECFG: CACHE_CLKGATE (Bit 10)            */
#define CACHECTRL_CACHECFG_CACHE_CLKGATE_Msk (0x400UL)              /*!< CACHECTRL CACHECFG: CACHE_CLKGATE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECFG_DCACHE_ENABLE_Pos (9UL)                  /*!< CACHECTRL CACHECFG: DCACHE_ENABLE (Bit 9)             */
#define CACHECTRL_CACHECFG_DCACHE_ENABLE_Msk (0x200UL)              /*!< CACHECTRL CACHECFG: DCACHE_ENABLE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECFG_ICACHE_ENABLE_Pos (8UL)                  /*!< CACHECTRL CACHECFG: ICACHE_ENABLE (Bit 8)             */
#define CACHECTRL_CACHECFG_ICACHE_ENABLE_Msk (0x100UL)              /*!< CACHECTRL CACHECFG: ICACHE_ENABLE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECFG_SERIAL_Pos     (7UL)                     /*!< CACHECTRL CACHECFG: SERIAL (Bit 7)                    */
#define CACHECTRL_CACHECFG_SERIAL_Msk     (0x80UL)                  /*!< CACHECTRL CACHECFG: SERIAL (Bitfield-Mask: 0x01)      */
#define CACHECTRL_CACHECFG_CONFIG_Pos     (4UL)                     /*!< CACHECTRL CACHECFG: CONFIG (Bit 4)                    */
#define CACHECTRL_CACHECFG_CONFIG_Msk     (0x70UL)                  /*!< CACHECTRL CACHECFG: CONFIG (Bitfield-Mask: 0x07)      */
#define CACHECTRL_CACHECFG_ENABLE_NC1_Pos (3UL)                     /*!< CACHECTRL CACHECFG: ENABLE_NC1 (Bit 3)                */
#define CACHECTRL_CACHECFG_ENABLE_NC1_Msk (0x8UL)                   /*!< CACHECTRL CACHECFG: ENABLE_NC1 (Bitfield-Mask: 0x01)  */
#define CACHECTRL_CACHECFG_ENABLE_NC0_Pos (2UL)                     /*!< CACHECTRL CACHECFG: ENABLE_NC0 (Bit 2)                */
#define CACHECTRL_CACHECFG_ENABLE_NC0_Msk (0x4UL)                   /*!< CACHECTRL CACHECFG: ENABLE_NC0 (Bitfield-Mask: 0x01)  */
#define CACHECTRL_CACHECFG_LRU_Pos        (1UL)                     /*!< CACHECTRL CACHECFG: LRU (Bit 1)                       */
#define CACHECTRL_CACHECFG_LRU_Msk        (0x2UL)                   /*!< CACHECTRL CACHECFG: LRU (Bitfield-Mask: 0x01)         */
#define CACHECTRL_CACHECFG_ENABLE_Pos     (0UL)                     /*!< CACHECTRL CACHECFG: ENABLE (Bit 0)                    */
#define CACHECTRL_CACHECFG_ENABLE_Msk     (0x1UL)                   /*!< CACHECTRL CACHECFG: ENABLE (Bitfield-Mask: 0x01)      */
/* =======================================================  FLASHCFG  ======================================================== */
#define CACHECTRL_FLASHCFG_RD_WAIT_Pos    (0UL)                     /*!< CACHECTRL FLASHCFG: RD_WAIT (Bit 0)                   */
#define CACHECTRL_FLASHCFG_RD_WAIT_Msk    (0x7UL)                   /*!< CACHECTRL FLASHCFG: RD_WAIT (Bitfield-Mask: 0x07)     */
/* =======================================================  CACHECTRL  ======================================================= */
#define CACHECTRL_CACHECTRL_FLASH1_SLM_ENABLE_Pos (10UL)            /*!< CACHECTRL CACHECTRL: FLASH1_SLM_ENABLE (Bit 10)       */
#define CACHECTRL_CACHECTRL_FLASH1_SLM_ENABLE_Msk (0x400UL)         /*!< CACHECTRL CACHECTRL: FLASH1_SLM_ENABLE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECTRL_FLASH1_SLM_DISABLE_Pos (9UL)            /*!< CACHECTRL CACHECTRL: FLASH1_SLM_DISABLE (Bit 9)       */
#define CACHECTRL_CACHECTRL_FLASH1_SLM_DISABLE_Msk (0x200UL)        /*!< CACHECTRL CACHECTRL: FLASH1_SLM_DISABLE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECTRL_FLASH1_SLM_STATUS_Pos (8UL)             /*!< CACHECTRL CACHECTRL: FLASH1_SLM_STATUS (Bit 8)        */
#define CACHECTRL_CACHECTRL_FLASH1_SLM_STATUS_Msk (0x100UL)         /*!< CACHECTRL CACHECTRL: FLASH1_SLM_STATUS (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECTRL_FLASH0_SLM_ENABLE_Pos (6UL)             /*!< CACHECTRL CACHECTRL: FLASH0_SLM_ENABLE (Bit 6)        */
#define CACHECTRL_CACHECTRL_FLASH0_SLM_ENABLE_Msk (0x40UL)          /*!< CACHECTRL CACHECTRL: FLASH0_SLM_ENABLE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECTRL_FLASH0_SLM_DISABLE_Pos (5UL)            /*!< CACHECTRL CACHECTRL: FLASH0_SLM_DISABLE (Bit 5)       */
#define CACHECTRL_CACHECTRL_FLASH0_SLM_DISABLE_Msk (0x20UL)         /*!< CACHECTRL CACHECTRL: FLASH0_SLM_DISABLE (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECTRL_FLASH0_SLM_STATUS_Pos (4UL)             /*!< CACHECTRL CACHECTRL: FLASH0_SLM_STATUS (Bit 4)        */
#define CACHECTRL_CACHECTRL_FLASH0_SLM_STATUS_Msk (0x10UL)          /*!< CACHECTRL CACHECTRL: FLASH0_SLM_STATUS (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECTRL_CACHE_READY_Pos (2UL)                   /*!< CACHECTRL CACHECTRL: CACHE_READY (Bit 2)              */
#define CACHECTRL_CACHECTRL_CACHE_READY_Msk (0x4UL)                 /*!< CACHECTRL CACHECTRL: CACHE_READY (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECTRL_RESET_STAT_Pos (1UL)                    /*!< CACHECTRL CACHECTRL: RESET_STAT (Bit 1)               */
#define CACHECTRL_CACHECTRL_RESET_STAT_Msk (0x2UL)                  /*!< CACHECTRL CACHECTRL: RESET_STAT (Bitfield-Mask: 0x01) */
#define CACHECTRL_CACHECTRL_INVALIDATE_Pos (0UL)                    /*!< CACHECTRL CACHECTRL: INVALIDATE (Bit 0)               */
#define CACHECTRL_CACHECTRL_INVALIDATE_Msk (0x1UL)                  /*!< CACHECTRL CACHECTRL: INVALIDATE (Bitfield-Mask: 0x01) */
/* =======================================================  NCR0START  ======================================================= */
#define CACHECTRL_NCR0START_ADDR_Pos      (4UL)                     /*!< CACHECTRL NCR0START: ADDR (Bit 4)                     */
#define CACHECTRL_NCR0START_ADDR_Msk      (0xffff0UL)               /*!< CACHECTRL NCR0START: ADDR (Bitfield-Mask: 0xffff)     */
/* ========================================================  NCR0END  ======================================================== */
#define CACHECTRL_NCR0END_ADDR_Pos        (4UL)                     /*!< CACHECTRL NCR0END: ADDR (Bit 4)                       */
#define CACHECTRL_NCR0END_ADDR_Msk        (0xffff0UL)               /*!< CACHECTRL NCR0END: ADDR (Bitfield-Mask: 0xffff)       */
/* =======================================================  NCR1START  ======================================================= */
#define CACHECTRL_NCR1START_ADDR_Pos      (4UL)                     /*!< CACHECTRL NCR1START: ADDR (Bit 4)                     */
#define CACHECTRL_NCR1START_ADDR_Msk      (0xffff0UL)               /*!< CACHECTRL NCR1START: ADDR (Bitfield-Mask: 0xffff)     */
/* ========================================================  NCR1END  ======================================================== */
#define CACHECTRL_NCR1END_ADDR_Pos        (4UL)                     /*!< CACHECTRL NCR1END: ADDR (Bit 4)                       */
#define CACHECTRL_NCR1END_ADDR_Msk        (0xffff0UL)               /*!< CACHECTRL NCR1END: ADDR (Bitfield-Mask: 0xffff)       */
/* =======================================================  CACHEMODE  ======================================================= */
#define CACHECTRL_CACHEMODE_THROTTLE6_Pos (5UL)                     /*!< CACHECTRL CACHEMODE: THROTTLE6 (Bit 5)                */
#define CACHECTRL_CACHEMODE_THROTTLE6_Msk (0x20UL)                  /*!< CACHECTRL CACHEMODE: THROTTLE6 (Bitfield-Mask: 0x01)  */
#define CACHECTRL_CACHEMODE_THROTTLE5_Pos (4UL)                     /*!< CACHECTRL CACHEMODE: THROTTLE5 (Bit 4)                */
#define CACHECTRL_CACHEMODE_THROTTLE5_Msk (0x10UL)                  /*!< CACHECTRL CACHEMODE: THROTTLE5 (Bitfield-Mask: 0x01)  */
#define CACHECTRL_CACHEMODE_THROTTLE4_Pos (3UL)                     /*!< CACHECTRL CACHEMODE: THROTTLE4 (Bit 3)                */
#define CACHECTRL_CACHEMODE_THROTTLE4_Msk (0x8UL)                   /*!< CACHECTRL CACHEMODE: THROTTLE4 (Bitfield-Mask: 0x01)  */
#define CACHECTRL_CACHEMODE_THROTTLE3_Pos (2UL)                     /*!< CACHECTRL CACHEMODE: THROTTLE3 (Bit 2)                */
#define CACHECTRL_CACHEMODE_THROTTLE3_Msk (0x4UL)                   /*!< CACHECTRL CACHEMODE: THROTTLE3 (Bitfield-Mask: 0x01)  */
#define CACHECTRL_CACHEMODE_THROTTLE2_Pos (1UL)                     /*!< CACHECTRL CACHEMODE: THROTTLE2 (Bit 1)                */
#define CACHECTRL_CACHEMODE_THROTTLE2_Msk (0x2UL)                   /*!< CACHECTRL CACHEMODE: THROTTLE2 (Bitfield-Mask: 0x01)  */
#define CACHECTRL_CACHEMODE_THROTTLE1_Pos (0UL)                     /*!< CACHECTRL CACHEMODE: THROTTLE1 (Bit 0)                */
#define CACHECTRL_CACHEMODE_THROTTLE1_Msk (0x1UL)                   /*!< CACHECTRL CACHEMODE: THROTTLE1 (Bitfield-Mask: 0x01)  */
/* =========================================================  DMON0  ========================================================= */
#define CACHECTRL_DMON0_DACCESS_COUNT_Pos (0UL)                     /*!< CACHECTRL DMON0: DACCESS_COUNT (Bit 0)                */
#define CACHECTRL_DMON0_DACCESS_COUNT_Msk (0xffffffffUL)            /*!< CACHECTRL DMON0: DACCESS_COUNT (Bitfield-Mask: 0xffffffff) */
/* =========================================================  DMON1  ========================================================= */
#define CACHECTRL_DMON1_DLOOKUP_COUNT_Pos (0UL)                     /*!< CACHECTRL DMON1: DLOOKUP_COUNT (Bit 0)                */
#define CACHECTRL_DMON1_DLOOKUP_COUNT_Msk (0xffffffffUL)            /*!< CACHECTRL DMON1: DLOOKUP_COUNT (Bitfield-Mask: 0xffffffff) */
/* =========================================================  DMON2  ========================================================= */
#define CACHECTRL_DMON2_DHIT_COUNT_Pos    (0UL)                     /*!< CACHECTRL DMON2: DHIT_COUNT (Bit 0)                   */
#define CACHECTRL_DMON2_DHIT_COUNT_Msk    (0xffffffffUL)            /*!< CACHECTRL DMON2: DHIT_COUNT (Bitfield-Mask: 0xffffffff) */
/* =========================================================  DMON3  ========================================================= */
#define CACHECTRL_DMON3_DLINE_COUNT_Pos   (0UL)                     /*!< CACHECTRL DMON3: DLINE_COUNT (Bit 0)                  */
#define CACHECTRL_DMON3_DLINE_COUNT_Msk   (0xffffffffUL)            /*!< CACHECTRL DMON3: DLINE_COUNT (Bitfield-Mask: 0xffffffff) */
/* =========================================================  IMON0  ========================================================= */
#define CACHECTRL_IMON0_IACCESS_COUNT_Pos (0UL)                     /*!< CACHECTRL IMON0: IACCESS_COUNT (Bit 0)                */
#define CACHECTRL_IMON0_IACCESS_COUNT_Msk (0xffffffffUL)            /*!< CACHECTRL IMON0: IACCESS_COUNT (Bitfield-Mask: 0xffffffff) */
/* =========================================================  IMON1  ========================================================= */
#define CACHECTRL_IMON1_ILOOKUP_COUNT_Pos (0UL)                     /*!< CACHECTRL IMON1: ILOOKUP_COUNT (Bit 0)                */
#define CACHECTRL_IMON1_ILOOKUP_COUNT_Msk (0xffffffffUL)            /*!< CACHECTRL IMON1: ILOOKUP_COUNT (Bitfield-Mask: 0xffffffff) */
/* =========================================================  IMON2  ========================================================= */
#define CACHECTRL_IMON2_IHIT_COUNT_Pos    (0UL)                     /*!< CACHECTRL IMON2: IHIT_COUNT (Bit 0)                   */
#define CACHECTRL_IMON2_IHIT_COUNT_Msk    (0xffffffffUL)            /*!< CACHECTRL IMON2: IHIT_COUNT (Bitfield-Mask: 0xffffffff) */
/* =========================================================  IMON3  ========================================================= */
#define CACHECTRL_IMON3_ILINE_COUNT_Pos   (0UL)                     /*!< CACHECTRL IMON3: ILINE_COUNT (Bit 0)                  */
#define CACHECTRL_IMON3_ILINE_COUNT_Msk   (0xffffffffUL)            /*!< CACHECTRL IMON3: ILINE_COUNT (Bitfield-Mask: 0xffffffff) */


/* =========================================================================================================================== */
/* ================                                          CTIMER                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  TMR0  ========================================================== */
#define CTIMER_TMR0_CTTMRB0_Pos           (16UL)                    /*!< CTIMER TMR0: CTTMRB0 (Bit 16)                         */
#define CTIMER_TMR0_CTTMRB0_Msk           (0xffff0000UL)            /*!< CTIMER TMR0: CTTMRB0 (Bitfield-Mask: 0xffff)          */
#define CTIMER_TMR0_CTTMRA0_Pos           (0UL)                     /*!< CTIMER TMR0: CTTMRA0 (Bit 0)                          */
#define CTIMER_TMR0_CTTMRA0_Msk           (0xffffUL)                /*!< CTIMER TMR0: CTTMRA0 (Bitfield-Mask: 0xffff)          */
/* ========================================================  CMPRA0  ========================================================= */
#define CTIMER_CMPRA0_CMPR1A0_Pos         (16UL)                    /*!< CTIMER CMPRA0: CMPR1A0 (Bit 16)                       */
#define CTIMER_CMPRA0_CMPR1A0_Msk         (0xffff0000UL)            /*!< CTIMER CMPRA0: CMPR1A0 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRA0_CMPR0A0_Pos         (0UL)                     /*!< CTIMER CMPRA0: CMPR0A0 (Bit 0)                        */
#define CTIMER_CMPRA0_CMPR0A0_Msk         (0xffffUL)                /*!< CTIMER CMPRA0: CMPR0A0 (Bitfield-Mask: 0xffff)        */
/* ========================================================  CMPRB0  ========================================================= */
#define CTIMER_CMPRB0_CMPR1B0_Pos         (16UL)                    /*!< CTIMER CMPRB0: CMPR1B0 (Bit 16)                       */
#define CTIMER_CMPRB0_CMPR1B0_Msk         (0xffff0000UL)            /*!< CTIMER CMPRB0: CMPR1B0 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRB0_CMPR0B0_Pos         (0UL)                     /*!< CTIMER CMPRB0: CMPR0B0 (Bit 0)                        */
#define CTIMER_CMPRB0_CMPR0B0_Msk         (0xffffUL)                /*!< CTIMER CMPRB0: CMPR0B0 (Bitfield-Mask: 0xffff)        */
/* =========================================================  CTRL0  ========================================================= */
#define CTIMER_CTRL0_CTLINK0_Pos          (31UL)                    /*!< CTIMER CTRL0: CTLINK0 (Bit 31)                        */
#define CTIMER_CTRL0_CTLINK0_Msk          (0x80000000UL)            /*!< CTIMER CTRL0: CTLINK0 (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL0_TMRB0PE_Pos          (29UL)                    /*!< CTIMER CTRL0: TMRB0PE (Bit 29)                        */
#define CTIMER_CTRL0_TMRB0PE_Msk          (0x20000000UL)            /*!< CTIMER CTRL0: TMRB0PE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL0_TMRB0POL_Pos         (28UL)                    /*!< CTIMER CTRL0: TMRB0POL (Bit 28)                       */
#define CTIMER_CTRL0_TMRB0POL_Msk         (0x10000000UL)            /*!< CTIMER CTRL0: TMRB0POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRB0CLR_Pos         (27UL)                    /*!< CTIMER CTRL0: TMRB0CLR (Bit 27)                       */
#define CTIMER_CTRL0_TMRB0CLR_Msk         (0x8000000UL)             /*!< CTIMER CTRL0: TMRB0CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRB0IE1_Pos         (26UL)                    /*!< CTIMER CTRL0: TMRB0IE1 (Bit 26)                       */
#define CTIMER_CTRL0_TMRB0IE1_Msk         (0x4000000UL)             /*!< CTIMER CTRL0: TMRB0IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRB0IE0_Pos         (25UL)                    /*!< CTIMER CTRL0: TMRB0IE0 (Bit 25)                       */
#define CTIMER_CTRL0_TMRB0IE0_Msk         (0x2000000UL)             /*!< CTIMER CTRL0: TMRB0IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRB0FN_Pos          (22UL)                    /*!< CTIMER CTRL0: TMRB0FN (Bit 22)                        */
#define CTIMER_CTRL0_TMRB0FN_Msk          (0x1c00000UL)             /*!< CTIMER CTRL0: TMRB0FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL0_TMRB0CLK_Pos         (17UL)                    /*!< CTIMER CTRL0: TMRB0CLK (Bit 17)                       */
#define CTIMER_CTRL0_TMRB0CLK_Msk         (0x3e0000UL)              /*!< CTIMER CTRL0: TMRB0CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL0_TMRB0EN_Pos          (16UL)                    /*!< CTIMER CTRL0: TMRB0EN (Bit 16)                        */
#define CTIMER_CTRL0_TMRB0EN_Msk          (0x10000UL)               /*!< CTIMER CTRL0: TMRB0EN (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL0_TMRA0PE_Pos          (13UL)                    /*!< CTIMER CTRL0: TMRA0PE (Bit 13)                        */
#define CTIMER_CTRL0_TMRA0PE_Msk          (0x2000UL)                /*!< CTIMER CTRL0: TMRA0PE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL0_TMRA0POL_Pos         (12UL)                    /*!< CTIMER CTRL0: TMRA0POL (Bit 12)                       */
#define CTIMER_CTRL0_TMRA0POL_Msk         (0x1000UL)                /*!< CTIMER CTRL0: TMRA0POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRA0CLR_Pos         (11UL)                    /*!< CTIMER CTRL0: TMRA0CLR (Bit 11)                       */
#define CTIMER_CTRL0_TMRA0CLR_Msk         (0x800UL)                 /*!< CTIMER CTRL0: TMRA0CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRA0IE1_Pos         (10UL)                    /*!< CTIMER CTRL0: TMRA0IE1 (Bit 10)                       */
#define CTIMER_CTRL0_TMRA0IE1_Msk         (0x400UL)                 /*!< CTIMER CTRL0: TMRA0IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRA0IE0_Pos         (9UL)                     /*!< CTIMER CTRL0: TMRA0IE0 (Bit 9)                        */
#define CTIMER_CTRL0_TMRA0IE0_Msk         (0x200UL)                 /*!< CTIMER CTRL0: TMRA0IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRA0FN_Pos          (6UL)                     /*!< CTIMER CTRL0: TMRA0FN (Bit 6)                         */
#define CTIMER_CTRL0_TMRA0FN_Msk          (0x1c0UL)                 /*!< CTIMER CTRL0: TMRA0FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL0_TMRA0CLK_Pos         (1UL)                     /*!< CTIMER CTRL0: TMRA0CLK (Bit 1)                        */
#define CTIMER_CTRL0_TMRA0CLK_Msk         (0x3eUL)                  /*!< CTIMER CTRL0: TMRA0CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL0_TMRA0EN_Pos          (0UL)                     /*!< CTIMER CTRL0: TMRA0EN (Bit 0)                         */
#define CTIMER_CTRL0_TMRA0EN_Msk          (0x1UL)                   /*!< CTIMER CTRL0: TMRA0EN (Bitfield-Mask: 0x01)           */
/* =========================================================  TMR1  ========================================================== */
#define CTIMER_TMR1_CTTMRB1_Pos           (16UL)                    /*!< CTIMER TMR1: CTTMRB1 (Bit 16)                         */
#define CTIMER_TMR1_CTTMRB1_Msk           (0xffff0000UL)            /*!< CTIMER TMR1: CTTMRB1 (Bitfield-Mask: 0xffff)          */
#define CTIMER_TMR1_CTTMRA1_Pos           (0UL)                     /*!< CTIMER TMR1: CTTMRA1 (Bit 0)                          */
#define CTIMER_TMR1_CTTMRA1_Msk           (0xffffUL)                /*!< CTIMER TMR1: CTTMRA1 (Bitfield-Mask: 0xffff)          */
/* ========================================================  CMPRA1  ========================================================= */
#define CTIMER_CMPRA1_CMPR1A1_Pos         (16UL)                    /*!< CTIMER CMPRA1: CMPR1A1 (Bit 16)                       */
#define CTIMER_CMPRA1_CMPR1A1_Msk         (0xffff0000UL)            /*!< CTIMER CMPRA1: CMPR1A1 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRA1_CMPR0A1_Pos         (0UL)                     /*!< CTIMER CMPRA1: CMPR0A1 (Bit 0)                        */
#define CTIMER_CMPRA1_CMPR0A1_Msk         (0xffffUL)                /*!< CTIMER CMPRA1: CMPR0A1 (Bitfield-Mask: 0xffff)        */
/* ========================================================  CMPRB1  ========================================================= */
#define CTIMER_CMPRB1_CMPR1B1_Pos         (16UL)                    /*!< CTIMER CMPRB1: CMPR1B1 (Bit 16)                       */
#define CTIMER_CMPRB1_CMPR1B1_Msk         (0xffff0000UL)            /*!< CTIMER CMPRB1: CMPR1B1 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRB1_CMPR0B1_Pos         (0UL)                     /*!< CTIMER CMPRB1: CMPR0B1 (Bit 0)                        */
#define CTIMER_CMPRB1_CMPR0B1_Msk         (0xffffUL)                /*!< CTIMER CMPRB1: CMPR0B1 (Bitfield-Mask: 0xffff)        */
/* =========================================================  CTRL1  ========================================================= */
#define CTIMER_CTRL1_CTLINK1_Pos          (31UL)                    /*!< CTIMER CTRL1: CTLINK1 (Bit 31)                        */
#define CTIMER_CTRL1_CTLINK1_Msk          (0x80000000UL)            /*!< CTIMER CTRL1: CTLINK1 (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL1_TMRB1PE_Pos          (29UL)                    /*!< CTIMER CTRL1: TMRB1PE (Bit 29)                        */
#define CTIMER_CTRL1_TMRB1PE_Msk          (0x20000000UL)            /*!< CTIMER CTRL1: TMRB1PE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL1_TMRB1POL_Pos         (28UL)                    /*!< CTIMER CTRL1: TMRB1POL (Bit 28)                       */
#define CTIMER_CTRL1_TMRB1POL_Msk         (0x10000000UL)            /*!< CTIMER CTRL1: TMRB1POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRB1CLR_Pos         (27UL)                    /*!< CTIMER CTRL1: TMRB1CLR (Bit 27)                       */
#define CTIMER_CTRL1_TMRB1CLR_Msk         (0x8000000UL)             /*!< CTIMER CTRL1: TMRB1CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRB1IE1_Pos         (26UL)                    /*!< CTIMER CTRL1: TMRB1IE1 (Bit 26)                       */
#define CTIMER_CTRL1_TMRB1IE1_Msk         (0x4000000UL)             /*!< CTIMER CTRL1: TMRB1IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRB1IE0_Pos         (25UL)                    /*!< CTIMER CTRL1: TMRB1IE0 (Bit 25)                       */
#define CTIMER_CTRL1_TMRB1IE0_Msk         (0x2000000UL)             /*!< CTIMER CTRL1: TMRB1IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRB1FN_Pos          (22UL)                    /*!< CTIMER CTRL1: TMRB1FN (Bit 22)                        */
#define CTIMER_CTRL1_TMRB1FN_Msk          (0x1c00000UL)             /*!< CTIMER CTRL1: TMRB1FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL1_TMRB1CLK_Pos         (17UL)                    /*!< CTIMER CTRL1: TMRB1CLK (Bit 17)                       */
#define CTIMER_CTRL1_TMRB1CLK_Msk         (0x3e0000UL)              /*!< CTIMER CTRL1: TMRB1CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL1_TMRB1EN_Pos          (16UL)                    /*!< CTIMER CTRL1: TMRB1EN (Bit 16)                        */
#define CTIMER_CTRL1_TMRB1EN_Msk          (0x10000UL)               /*!< CTIMER CTRL1: TMRB1EN (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL1_TMRA1PE_Pos          (13UL)                    /*!< CTIMER CTRL1: TMRA1PE (Bit 13)                        */
#define CTIMER_CTRL1_TMRA1PE_Msk          (0x2000UL)                /*!< CTIMER CTRL1: TMRA1PE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL1_TMRA1POL_Pos         (12UL)                    /*!< CTIMER CTRL1: TMRA1POL (Bit 12)                       */
#define CTIMER_CTRL1_TMRA1POL_Msk         (0x1000UL)                /*!< CTIMER CTRL1: TMRA1POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRA1CLR_Pos         (11UL)                    /*!< CTIMER CTRL1: TMRA1CLR (Bit 11)                       */
#define CTIMER_CTRL1_TMRA1CLR_Msk         (0x800UL)                 /*!< CTIMER CTRL1: TMRA1CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRA1IE1_Pos         (10UL)                    /*!< CTIMER CTRL1: TMRA1IE1 (Bit 10)                       */
#define CTIMER_CTRL1_TMRA1IE1_Msk         (0x400UL)                 /*!< CTIMER CTRL1: TMRA1IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRA1IE0_Pos         (9UL)                     /*!< CTIMER CTRL1: TMRA1IE0 (Bit 9)                        */
#define CTIMER_CTRL1_TMRA1IE0_Msk         (0x200UL)                 /*!< CTIMER CTRL1: TMRA1IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRA1FN_Pos          (6UL)                     /*!< CTIMER CTRL1: TMRA1FN (Bit 6)                         */
#define CTIMER_CTRL1_TMRA1FN_Msk          (0x1c0UL)                 /*!< CTIMER CTRL1: TMRA1FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL1_TMRA1CLK_Pos         (1UL)                     /*!< CTIMER CTRL1: TMRA1CLK (Bit 1)                        */
#define CTIMER_CTRL1_TMRA1CLK_Msk         (0x3eUL)                  /*!< CTIMER CTRL1: TMRA1CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL1_TMRA1EN_Pos          (0UL)                     /*!< CTIMER CTRL1: TMRA1EN (Bit 0)                         */
#define CTIMER_CTRL1_TMRA1EN_Msk          (0x1UL)                   /*!< CTIMER CTRL1: TMRA1EN (Bitfield-Mask: 0x01)           */
/* =========================================================  TMR2  ========================================================== */
#define CTIMER_TMR2_CTTMRB2_Pos           (16UL)                    /*!< CTIMER TMR2: CTTMRB2 (Bit 16)                         */
#define CTIMER_TMR2_CTTMRB2_Msk           (0xffff0000UL)            /*!< CTIMER TMR2: CTTMRB2 (Bitfield-Mask: 0xffff)          */
#define CTIMER_TMR2_CTTMRA2_Pos           (0UL)                     /*!< CTIMER TMR2: CTTMRA2 (Bit 0)                          */
#define CTIMER_TMR2_CTTMRA2_Msk           (0xffffUL)                /*!< CTIMER TMR2: CTTMRA2 (Bitfield-Mask: 0xffff)          */
/* ========================================================  CMPRA2  ========================================================= */
#define CTIMER_CMPRA2_CMPR1A2_Pos         (16UL)                    /*!< CTIMER CMPRA2: CMPR1A2 (Bit 16)                       */
#define CTIMER_CMPRA2_CMPR1A2_Msk         (0xffff0000UL)            /*!< CTIMER CMPRA2: CMPR1A2 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRA2_CMPR0A2_Pos         (0UL)                     /*!< CTIMER CMPRA2: CMPR0A2 (Bit 0)                        */
#define CTIMER_CMPRA2_CMPR0A2_Msk         (0xffffUL)                /*!< CTIMER CMPRA2: CMPR0A2 (Bitfield-Mask: 0xffff)        */
/* ========================================================  CMPRB2  ========================================================= */
#define CTIMER_CMPRB2_CMPR1B2_Pos         (16UL)                    /*!< CTIMER CMPRB2: CMPR1B2 (Bit 16)                       */
#define CTIMER_CMPRB2_CMPR1B2_Msk         (0xffff0000UL)            /*!< CTIMER CMPRB2: CMPR1B2 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRB2_CMPR0B2_Pos         (0UL)                     /*!< CTIMER CMPRB2: CMPR0B2 (Bit 0)                        */
#define CTIMER_CMPRB2_CMPR0B2_Msk         (0xffffUL)                /*!< CTIMER CMPRB2: CMPR0B2 (Bitfield-Mask: 0xffff)        */
/* =========================================================  CTRL2  ========================================================= */
#define CTIMER_CTRL2_CTLINK2_Pos          (31UL)                    /*!< CTIMER CTRL2: CTLINK2 (Bit 31)                        */
#define CTIMER_CTRL2_CTLINK2_Msk          (0x80000000UL)            /*!< CTIMER CTRL2: CTLINK2 (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL2_TMRB2PE_Pos          (29UL)                    /*!< CTIMER CTRL2: TMRB2PE (Bit 29)                        */
#define CTIMER_CTRL2_TMRB2PE_Msk          (0x20000000UL)            /*!< CTIMER CTRL2: TMRB2PE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL2_TMRB2POL_Pos         (28UL)                    /*!< CTIMER CTRL2: TMRB2POL (Bit 28)                       */
#define CTIMER_CTRL2_TMRB2POL_Msk         (0x10000000UL)            /*!< CTIMER CTRL2: TMRB2POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRB2CLR_Pos         (27UL)                    /*!< CTIMER CTRL2: TMRB2CLR (Bit 27)                       */
#define CTIMER_CTRL2_TMRB2CLR_Msk         (0x8000000UL)             /*!< CTIMER CTRL2: TMRB2CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRB2IE1_Pos         (26UL)                    /*!< CTIMER CTRL2: TMRB2IE1 (Bit 26)                       */
#define CTIMER_CTRL2_TMRB2IE1_Msk         (0x4000000UL)             /*!< CTIMER CTRL2: TMRB2IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRB2IE0_Pos         (25UL)                    /*!< CTIMER CTRL2: TMRB2IE0 (Bit 25)                       */
#define CTIMER_CTRL2_TMRB2IE0_Msk         (0x2000000UL)             /*!< CTIMER CTRL2: TMRB2IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRB2FN_Pos          (22UL)                    /*!< CTIMER CTRL2: TMRB2FN (Bit 22)                        */
#define CTIMER_CTRL2_TMRB2FN_Msk          (0x1c00000UL)             /*!< CTIMER CTRL2: TMRB2FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL2_TMRB2CLK_Pos         (17UL)                    /*!< CTIMER CTRL2: TMRB2CLK (Bit 17)                       */
#define CTIMER_CTRL2_TMRB2CLK_Msk         (0x3e0000UL)              /*!< CTIMER CTRL2: TMRB2CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL2_TMRB2EN_Pos          (16UL)                    /*!< CTIMER CTRL2: TMRB2EN (Bit 16)                        */
#define CTIMER_CTRL2_TMRB2EN_Msk          (0x10000UL)               /*!< CTIMER CTRL2: TMRB2EN (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL2_TMRA2PE_Pos          (13UL)                    /*!< CTIMER CTRL2: TMRA2PE (Bit 13)                        */
#define CTIMER_CTRL2_TMRA2PE_Msk          (0x2000UL)                /*!< CTIMER CTRL2: TMRA2PE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL2_TMRA2POL_Pos         (12UL)                    /*!< CTIMER CTRL2: TMRA2POL (Bit 12)                       */
#define CTIMER_CTRL2_TMRA2POL_Msk         (0x1000UL)                /*!< CTIMER CTRL2: TMRA2POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRA2CLR_Pos         (11UL)                    /*!< CTIMER CTRL2: TMRA2CLR (Bit 11)                       */
#define CTIMER_CTRL2_TMRA2CLR_Msk         (0x800UL)                 /*!< CTIMER CTRL2: TMRA2CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRA2IE1_Pos         (10UL)                    /*!< CTIMER CTRL2: TMRA2IE1 (Bit 10)                       */
#define CTIMER_CTRL2_TMRA2IE1_Msk         (0x400UL)                 /*!< CTIMER CTRL2: TMRA2IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRA2IE0_Pos         (9UL)                     /*!< CTIMER CTRL2: TMRA2IE0 (Bit 9)                        */
#define CTIMER_CTRL2_TMRA2IE0_Msk         (0x200UL)                 /*!< CTIMER CTRL2: TMRA2IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRA2FN_Pos          (6UL)                     /*!< CTIMER CTRL2: TMRA2FN (Bit 6)                         */
#define CTIMER_CTRL2_TMRA2FN_Msk          (0x1c0UL)                 /*!< CTIMER CTRL2: TMRA2FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL2_TMRA2CLK_Pos         (1UL)                     /*!< CTIMER CTRL2: TMRA2CLK (Bit 1)                        */
#define CTIMER_CTRL2_TMRA2CLK_Msk         (0x3eUL)                  /*!< CTIMER CTRL2: TMRA2CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL2_TMRA2EN_Pos          (0UL)                     /*!< CTIMER CTRL2: TMRA2EN (Bit 0)                         */
#define CTIMER_CTRL2_TMRA2EN_Msk          (0x1UL)                   /*!< CTIMER CTRL2: TMRA2EN (Bitfield-Mask: 0x01)           */
/* =========================================================  TMR3  ========================================================== */
#define CTIMER_TMR3_CTTMRB3_Pos           (16UL)                    /*!< CTIMER TMR3: CTTMRB3 (Bit 16)                         */
#define CTIMER_TMR3_CTTMRB3_Msk           (0xffff0000UL)            /*!< CTIMER TMR3: CTTMRB3 (Bitfield-Mask: 0xffff)          */
#define CTIMER_TMR3_CTTMRA3_Pos           (0UL)                     /*!< CTIMER TMR3: CTTMRA3 (Bit 0)                          */
#define CTIMER_TMR3_CTTMRA3_Msk           (0xffffUL)                /*!< CTIMER TMR3: CTTMRA3 (Bitfield-Mask: 0xffff)          */
/* ========================================================  CMPRA3  ========================================================= */
#define CTIMER_CMPRA3_CMPR1A3_Pos         (16UL)                    /*!< CTIMER CMPRA3: CMPR1A3 (Bit 16)                       */
#define CTIMER_CMPRA3_CMPR1A3_Msk         (0xffff0000UL)            /*!< CTIMER CMPRA3: CMPR1A3 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRA3_CMPR0A3_Pos         (0UL)                     /*!< CTIMER CMPRA3: CMPR0A3 (Bit 0)                        */
#define CTIMER_CMPRA3_CMPR0A3_Msk         (0xffffUL)                /*!< CTIMER CMPRA3: CMPR0A3 (Bitfield-Mask: 0xffff)        */
/* ========================================================  CMPRB3  ========================================================= */
#define CTIMER_CMPRB3_CMPR1B3_Pos         (16UL)                    /*!< CTIMER CMPRB3: CMPR1B3 (Bit 16)                       */
#define CTIMER_CMPRB3_CMPR1B3_Msk         (0xffff0000UL)            /*!< CTIMER CMPRB3: CMPR1B3 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRB3_CMPR0B3_Pos         (0UL)                     /*!< CTIMER CMPRB3: CMPR0B3 (Bit 0)                        */
#define CTIMER_CMPRB3_CMPR0B3_Msk         (0xffffUL)                /*!< CTIMER CMPRB3: CMPR0B3 (Bitfield-Mask: 0xffff)        */
/* =========================================================  CTRL3  ========================================================= */
#define CTIMER_CTRL3_CTLINK3_Pos          (31UL)                    /*!< CTIMER CTRL3: CTLINK3 (Bit 31)                        */
#define CTIMER_CTRL3_CTLINK3_Msk          (0x80000000UL)            /*!< CTIMER CTRL3: CTLINK3 (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL3_TMRB3PE_Pos          (29UL)                    /*!< CTIMER CTRL3: TMRB3PE (Bit 29)                        */
#define CTIMER_CTRL3_TMRB3PE_Msk          (0x20000000UL)            /*!< CTIMER CTRL3: TMRB3PE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL3_TMRB3POL_Pos         (28UL)                    /*!< CTIMER CTRL3: TMRB3POL (Bit 28)                       */
#define CTIMER_CTRL3_TMRB3POL_Msk         (0x10000000UL)            /*!< CTIMER CTRL3: TMRB3POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRB3CLR_Pos         (27UL)                    /*!< CTIMER CTRL3: TMRB3CLR (Bit 27)                       */
#define CTIMER_CTRL3_TMRB3CLR_Msk         (0x8000000UL)             /*!< CTIMER CTRL3: TMRB3CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRB3IE1_Pos         (26UL)                    /*!< CTIMER CTRL3: TMRB3IE1 (Bit 26)                       */
#define CTIMER_CTRL3_TMRB3IE1_Msk         (0x4000000UL)             /*!< CTIMER CTRL3: TMRB3IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRB3IE0_Pos         (25UL)                    /*!< CTIMER CTRL3: TMRB3IE0 (Bit 25)                       */
#define CTIMER_CTRL3_TMRB3IE0_Msk         (0x2000000UL)             /*!< CTIMER CTRL3: TMRB3IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRB3FN_Pos          (22UL)                    /*!< CTIMER CTRL3: TMRB3FN (Bit 22)                        */
#define CTIMER_CTRL3_TMRB3FN_Msk          (0x1c00000UL)             /*!< CTIMER CTRL3: TMRB3FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL3_TMRB3CLK_Pos         (17UL)                    /*!< CTIMER CTRL3: TMRB3CLK (Bit 17)                       */
#define CTIMER_CTRL3_TMRB3CLK_Msk         (0x3e0000UL)              /*!< CTIMER CTRL3: TMRB3CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL3_TMRB3EN_Pos          (16UL)                    /*!< CTIMER CTRL3: TMRB3EN (Bit 16)                        */
#define CTIMER_CTRL3_TMRB3EN_Msk          (0x10000UL)               /*!< CTIMER CTRL3: TMRB3EN (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL3_ADCEN_Pos            (15UL)                    /*!< CTIMER CTRL3: ADCEN (Bit 15)                          */
#define CTIMER_CTRL3_ADCEN_Msk            (0x8000UL)                /*!< CTIMER CTRL3: ADCEN (Bitfield-Mask: 0x01)             */
#define CTIMER_CTRL3_TMRA3PE_Pos          (13UL)                    /*!< CTIMER CTRL3: TMRA3PE (Bit 13)                        */
#define CTIMER_CTRL3_TMRA3PE_Msk          (0x2000UL)                /*!< CTIMER CTRL3: TMRA3PE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL3_TMRA3POL_Pos         (12UL)                    /*!< CTIMER CTRL3: TMRA3POL (Bit 12)                       */
#define CTIMER_CTRL3_TMRA3POL_Msk         (0x1000UL)                /*!< CTIMER CTRL3: TMRA3POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRA3CLR_Pos         (11UL)                    /*!< CTIMER CTRL3: TMRA3CLR (Bit 11)                       */
#define CTIMER_CTRL3_TMRA3CLR_Msk         (0x800UL)                 /*!< CTIMER CTRL3: TMRA3CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRA3IE1_Pos         (10UL)                    /*!< CTIMER CTRL3: TMRA3IE1 (Bit 10)                       */
#define CTIMER_CTRL3_TMRA3IE1_Msk         (0x400UL)                 /*!< CTIMER CTRL3: TMRA3IE1 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRA3IE0_Pos         (9UL)                     /*!< CTIMER CTRL3: TMRA3IE0 (Bit 9)                        */
#define CTIMER_CTRL3_TMRA3IE0_Msk         (0x200UL)                 /*!< CTIMER CTRL3: TMRA3IE0 (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRA3FN_Pos          (6UL)                     /*!< CTIMER CTRL3: TMRA3FN (Bit 6)                         */
#define CTIMER_CTRL3_TMRA3FN_Msk          (0x1c0UL)                 /*!< CTIMER CTRL3: TMRA3FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL3_TMRA3CLK_Pos         (1UL)                     /*!< CTIMER CTRL3: TMRA3CLK (Bit 1)                        */
#define CTIMER_CTRL3_TMRA3CLK_Msk         (0x3eUL)                  /*!< CTIMER CTRL3: TMRA3CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL3_TMRA3EN_Pos          (0UL)                     /*!< CTIMER CTRL3: TMRA3EN (Bit 0)                         */
#define CTIMER_CTRL3_TMRA3EN_Msk          (0x1UL)                   /*!< CTIMER CTRL3: TMRA3EN (Bitfield-Mask: 0x01)           */
/* =========================================================  STCFG  ========================================================= */
#define CTIMER_STCFG_FREEZE_Pos           (31UL)                    /*!< CTIMER STCFG: FREEZE (Bit 31)                         */
#define CTIMER_STCFG_FREEZE_Msk           (0x80000000UL)            /*!< CTIMER STCFG: FREEZE (Bitfield-Mask: 0x01)            */
#define CTIMER_STCFG_CLEAR_Pos            (30UL)                    /*!< CTIMER STCFG: CLEAR (Bit 30)                          */
#define CTIMER_STCFG_CLEAR_Msk            (0x40000000UL)            /*!< CTIMER STCFG: CLEAR (Bitfield-Mask: 0x01)             */
#define CTIMER_STCFG_COMPARE_H_EN_Pos     (15UL)                    /*!< CTIMER STCFG: COMPARE_H_EN (Bit 15)                   */
#define CTIMER_STCFG_COMPARE_H_EN_Msk     (0x8000UL)                /*!< CTIMER STCFG: COMPARE_H_EN (Bitfield-Mask: 0x01)      */
#define CTIMER_STCFG_COMPARE_G_EN_Pos     (14UL)                    /*!< CTIMER STCFG: COMPARE_G_EN (Bit 14)                   */
#define CTIMER_STCFG_COMPARE_G_EN_Msk     (0x4000UL)                /*!< CTIMER STCFG: COMPARE_G_EN (Bitfield-Mask: 0x01)      */
#define CTIMER_STCFG_COMPARE_F_EN_Pos     (13UL)                    /*!< CTIMER STCFG: COMPARE_F_EN (Bit 13)                   */
#define CTIMER_STCFG_COMPARE_F_EN_Msk     (0x2000UL)                /*!< CTIMER STCFG: COMPARE_F_EN (Bitfield-Mask: 0x01)      */
#define CTIMER_STCFG_COMPARE_E_EN_Pos     (12UL)                    /*!< CTIMER STCFG: COMPARE_E_EN (Bit 12)                   */
#define CTIMER_STCFG_COMPARE_E_EN_Msk     (0x1000UL)                /*!< CTIMER STCFG: COMPARE_E_EN (Bitfield-Mask: 0x01)      */
#define CTIMER_STCFG_COMPARE_D_EN_Pos     (11UL)                    /*!< CTIMER STCFG: COMPARE_D_EN (Bit 11)                   */
#define CTIMER_STCFG_COMPARE_D_EN_Msk     (0x800UL)                 /*!< CTIMER STCFG: COMPARE_D_EN (Bitfield-Mask: 0x01)      */
#define CTIMER_STCFG_COMPARE_C_EN_Pos     (10UL)                    /*!< CTIMER STCFG: COMPARE_C_EN (Bit 10)                   */
#define CTIMER_STCFG_COMPARE_C_EN_Msk     (0x400UL)                 /*!< CTIMER STCFG: COMPARE_C_EN (Bitfield-Mask: 0x01)      */
#define CTIMER_STCFG_COMPARE_B_EN_Pos     (9UL)                     /*!< CTIMER STCFG: COMPARE_B_EN (Bit 9)                    */
#define CTIMER_STCFG_COMPARE_B_EN_Msk     (0x200UL)                 /*!< CTIMER STCFG: COMPARE_B_EN (Bitfield-Mask: 0x01)      */
#define CTIMER_STCFG_COMPARE_A_EN_Pos     (8UL)                     /*!< CTIMER STCFG: COMPARE_A_EN (Bit 8)                    */
#define CTIMER_STCFG_COMPARE_A_EN_Msk     (0x100UL)                 /*!< CTIMER STCFG: COMPARE_A_EN (Bitfield-Mask: 0x01)      */
#define CTIMER_STCFG_CLKSEL_Pos           (0UL)                     /*!< CTIMER STCFG: CLKSEL (Bit 0)                          */
#define CTIMER_STCFG_CLKSEL_Msk           (0xfUL)                   /*!< CTIMER STCFG: CLKSEL (Bitfield-Mask: 0x0f)            */
/* =========================================================  STTMR  ========================================================= */
#define CTIMER_STTMR_VALUE_Pos            (0UL)                     /*!< CTIMER STTMR: VALUE (Bit 0)                           */
#define CTIMER_STTMR_VALUE_Msk            (0xffffffffUL)            /*!< CTIMER STTMR: VALUE (Bitfield-Mask: 0xffffffff)       */
/* ====================================================  CAPTURE_CONTROL  ==================================================== */
#define CTIMER_CAPTURE_CONTROL_CAPTURE_D_Pos (3UL)                  /*!< CTIMER CAPTURE_CONTROL: CAPTURE_D (Bit 3)             */
#define CTIMER_CAPTURE_CONTROL_CAPTURE_D_Msk (0x8UL)                /*!< CTIMER CAPTURE_CONTROL: CAPTURE_D (Bitfield-Mask: 0x01) */
#define CTIMER_CAPTURE_CONTROL_CAPTURE_C_Pos (2UL)                  /*!< CTIMER CAPTURE_CONTROL: CAPTURE_C (Bit 2)             */
#define CTIMER_CAPTURE_CONTROL_CAPTURE_C_Msk (0x4UL)                /*!< CTIMER CAPTURE_CONTROL: CAPTURE_C (Bitfield-Mask: 0x01) */
#define CTIMER_CAPTURE_CONTROL_CAPTURE_B_Pos (1UL)                  /*!< CTIMER CAPTURE_CONTROL: CAPTURE_B (Bit 1)             */
#define CTIMER_CAPTURE_CONTROL_CAPTURE_B_Msk (0x2UL)                /*!< CTIMER CAPTURE_CONTROL: CAPTURE_B (Bitfield-Mask: 0x01) */
#define CTIMER_CAPTURE_CONTROL_CAPTURE_A_Pos (0UL)                  /*!< CTIMER CAPTURE_CONTROL: CAPTURE_A (Bit 0)             */
#define CTIMER_CAPTURE_CONTROL_CAPTURE_A_Msk (0x1UL)                /*!< CTIMER CAPTURE_CONTROL: CAPTURE_A (Bitfield-Mask: 0x01) */
/* ========================================================  SCMPR0  ========================================================= */
#define CTIMER_SCMPR0_VALUE_Pos           (0UL)                     /*!< CTIMER SCMPR0: VALUE (Bit 0)                          */
#define CTIMER_SCMPR0_VALUE_Msk           (0xffffffffUL)            /*!< CTIMER SCMPR0: VALUE (Bitfield-Mask: 0xffffffff)      */
/* ========================================================  SCMPR1  ========================================================= */
#define CTIMER_SCMPR1_VALUE_Pos           (0UL)                     /*!< CTIMER SCMPR1: VALUE (Bit 0)                          */
#define CTIMER_SCMPR1_VALUE_Msk           (0xffffffffUL)            /*!< CTIMER SCMPR1: VALUE (Bitfield-Mask: 0xffffffff)      */
/* ========================================================  SCMPR2  ========================================================= */
#define CTIMER_SCMPR2_VALUE_Pos           (0UL)                     /*!< CTIMER SCMPR2: VALUE (Bit 0)                          */
#define CTIMER_SCMPR2_VALUE_Msk           (0xffffffffUL)            /*!< CTIMER SCMPR2: VALUE (Bitfield-Mask: 0xffffffff)      */
/* ========================================================  SCMPR3  ========================================================= */
#define CTIMER_SCMPR3_VALUE_Pos           (0UL)                     /*!< CTIMER SCMPR3: VALUE (Bit 0)                          */
#define CTIMER_SCMPR3_VALUE_Msk           (0xffffffffUL)            /*!< CTIMER SCMPR3: VALUE (Bitfield-Mask: 0xffffffff)      */
/* ========================================================  SCMPR4  ========================================================= */
#define CTIMER_SCMPR4_VALUE_Pos           (0UL)                     /*!< CTIMER SCMPR4: VALUE (Bit 0)                          */
#define CTIMER_SCMPR4_VALUE_Msk           (0xffffffffUL)            /*!< CTIMER SCMPR4: VALUE (Bitfield-Mask: 0xffffffff)      */
/* ========================================================  SCMPR5  ========================================================= */
#define CTIMER_SCMPR5_VALUE_Pos           (0UL)                     /*!< CTIMER SCMPR5: VALUE (Bit 0)                          */
#define CTIMER_SCMPR5_VALUE_Msk           (0xffffffffUL)            /*!< CTIMER SCMPR5: VALUE (Bitfield-Mask: 0xffffffff)      */
/* ========================================================  SCMPR6  ========================================================= */
#define CTIMER_SCMPR6_VALUE_Pos           (0UL)                     /*!< CTIMER SCMPR6: VALUE (Bit 0)                          */
#define CTIMER_SCMPR6_VALUE_Msk           (0xffffffffUL)            /*!< CTIMER SCMPR6: VALUE (Bitfield-Mask: 0xffffffff)      */
/* ========================================================  SCMPR7  ========================================================= */
#define CTIMER_SCMPR7_VALUE_Pos           (0UL)                     /*!< CTIMER SCMPR7: VALUE (Bit 0)                          */
#define CTIMER_SCMPR7_VALUE_Msk           (0xffffffffUL)            /*!< CTIMER SCMPR7: VALUE (Bitfield-Mask: 0xffffffff)      */
/* ========================================================  SCAPT0  ========================================================= */
#define CTIMER_SCAPT0_VALUE_Pos           (0UL)                     /*!< CTIMER SCAPT0: VALUE (Bit 0)                          */
#define CTIMER_SCAPT0_VALUE_Msk           (0xffffffffUL)            /*!< CTIMER SCAPT0: VALUE (Bitfield-Mask: 0xffffffff)      */
/* ========================================================  SCAPT1  ========================================================= */
#define CTIMER_SCAPT1_VALUE_Pos           (0UL)                     /*!< CTIMER SCAPT1: VALUE (Bit 0)                          */
#define CTIMER_SCAPT1_VALUE_Msk           (0xffffffffUL)            /*!< CTIMER SCAPT1: VALUE (Bitfield-Mask: 0xffffffff)      */
/* ========================================================  SCAPT2  ========================================================= */
#define CTIMER_SCAPT2_VALUE_Pos           (0UL)                     /*!< CTIMER SCAPT2: VALUE (Bit 0)                          */
#define CTIMER_SCAPT2_VALUE_Msk           (0xffffffffUL)            /*!< CTIMER SCAPT2: VALUE (Bitfield-Mask: 0xffffffff)      */
/* ========================================================  SCAPT3  ========================================================= */
#define CTIMER_SCAPT3_VALUE_Pos           (0UL)                     /*!< CTIMER SCAPT3: VALUE (Bit 0)                          */
#define CTIMER_SCAPT3_VALUE_Msk           (0xffffffffUL)            /*!< CTIMER SCAPT3: VALUE (Bitfield-Mask: 0xffffffff)      */
/* =========================================================  SNVR0  ========================================================= */
#define CTIMER_SNVR0_VALUE_Pos            (0UL)                     /*!< CTIMER SNVR0: VALUE (Bit 0)                           */
#define CTIMER_SNVR0_VALUE_Msk            (0xffffffffUL)            /*!< CTIMER SNVR0: VALUE (Bitfield-Mask: 0xffffffff)       */
/* =========================================================  SNVR1  ========================================================= */
#define CTIMER_SNVR1_VALUE_Pos            (0UL)                     /*!< CTIMER SNVR1: VALUE (Bit 0)                           */
#define CTIMER_SNVR1_VALUE_Msk            (0xffffffffUL)            /*!< CTIMER SNVR1: VALUE (Bitfield-Mask: 0xffffffff)       */
/* =========================================================  SNVR2  ========================================================= */
#define CTIMER_SNVR2_VALUE_Pos            (0UL)                     /*!< CTIMER SNVR2: VALUE (Bit 0)                           */
#define CTIMER_SNVR2_VALUE_Msk            (0xffffffffUL)            /*!< CTIMER SNVR2: VALUE (Bitfield-Mask: 0xffffffff)       */
/* =========================================================  INTEN  ========================================================= */
#define CTIMER_INTEN_CTMRB3C1INT_Pos      (15UL)                    /*!< CTIMER INTEN: CTMRB3C1INT (Bit 15)                    */
#define CTIMER_INTEN_CTMRB3C1INT_Msk      (0x8000UL)                /*!< CTIMER INTEN: CTMRB3C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA3C1INT_Pos      (14UL)                    /*!< CTIMER INTEN: CTMRA3C1INT (Bit 14)                    */
#define CTIMER_INTEN_CTMRA3C1INT_Msk      (0x4000UL)                /*!< CTIMER INTEN: CTMRA3C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB2C1INT_Pos      (13UL)                    /*!< CTIMER INTEN: CTMRB2C1INT (Bit 13)                    */
#define CTIMER_INTEN_CTMRB2C1INT_Msk      (0x2000UL)                /*!< CTIMER INTEN: CTMRB2C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA2C1INT_Pos      (12UL)                    /*!< CTIMER INTEN: CTMRA2C1INT (Bit 12)                    */
#define CTIMER_INTEN_CTMRA2C1INT_Msk      (0x1000UL)                /*!< CTIMER INTEN: CTMRA2C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB1C1INT_Pos      (11UL)                    /*!< CTIMER INTEN: CTMRB1C1INT (Bit 11)                    */
#define CTIMER_INTEN_CTMRB1C1INT_Msk      (0x800UL)                 /*!< CTIMER INTEN: CTMRB1C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA1C1INT_Pos      (10UL)                    /*!< CTIMER INTEN: CTMRA1C1INT (Bit 10)                    */
#define CTIMER_INTEN_CTMRA1C1INT_Msk      (0x400UL)                 /*!< CTIMER INTEN: CTMRA1C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB0C1INT_Pos      (9UL)                     /*!< CTIMER INTEN: CTMRB0C1INT (Bit 9)                     */
#define CTIMER_INTEN_CTMRB0C1INT_Msk      (0x200UL)                 /*!< CTIMER INTEN: CTMRB0C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA0C1INT_Pos      (8UL)                     /*!< CTIMER INTEN: CTMRA0C1INT (Bit 8)                     */
#define CTIMER_INTEN_CTMRA0C1INT_Msk      (0x100UL)                 /*!< CTIMER INTEN: CTMRA0C1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB3C0INT_Pos      (7UL)                     /*!< CTIMER INTEN: CTMRB3C0INT (Bit 7)                     */
#define CTIMER_INTEN_CTMRB3C0INT_Msk      (0x80UL)                  /*!< CTIMER INTEN: CTMRB3C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA3C0INT_Pos      (6UL)                     /*!< CTIMER INTEN: CTMRA3C0INT (Bit 6)                     */
#define CTIMER_INTEN_CTMRA3C0INT_Msk      (0x40UL)                  /*!< CTIMER INTEN: CTMRA3C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB2C0INT_Pos      (5UL)                     /*!< CTIMER INTEN: CTMRB2C0INT (Bit 5)                     */
#define CTIMER_INTEN_CTMRB2C0INT_Msk      (0x20UL)                  /*!< CTIMER INTEN: CTMRB2C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA2C0INT_Pos      (4UL)                     /*!< CTIMER INTEN: CTMRA2C0INT (Bit 4)                     */
#define CTIMER_INTEN_CTMRA2C0INT_Msk      (0x10UL)                  /*!< CTIMER INTEN: CTMRA2C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB1C0INT_Pos      (3UL)                     /*!< CTIMER INTEN: CTMRB1C0INT (Bit 3)                     */
#define CTIMER_INTEN_CTMRB1C0INT_Msk      (0x8UL)                   /*!< CTIMER INTEN: CTMRB1C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA1C0INT_Pos      (2UL)                     /*!< CTIMER INTEN: CTMRA1C0INT (Bit 2)                     */
#define CTIMER_INTEN_CTMRA1C0INT_Msk      (0x4UL)                   /*!< CTIMER INTEN: CTMRA1C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRB0C0INT_Pos      (1UL)                     /*!< CTIMER INTEN: CTMRB0C0INT (Bit 1)                     */
#define CTIMER_INTEN_CTMRB0C0INT_Msk      (0x2UL)                   /*!< CTIMER INTEN: CTMRB0C0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTEN_CTMRA0C0INT_Pos      (0UL)                     /*!< CTIMER INTEN: CTMRA0C0INT (Bit 0)                     */
#define CTIMER_INTEN_CTMRA0C0INT_Msk      (0x1UL)                   /*!< CTIMER INTEN: CTMRA0C0INT (Bitfield-Mask: 0x01)       */
/* ========================================================  INTSTAT  ======================================================== */
#define CTIMER_INTSTAT_CTMRB3C1INT_Pos    (15UL)                    /*!< CTIMER INTSTAT: CTMRB3C1INT (Bit 15)                  */
#define CTIMER_INTSTAT_CTMRB3C1INT_Msk    (0x8000UL)                /*!< CTIMER INTSTAT: CTMRB3C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA3C1INT_Pos    (14UL)                    /*!< CTIMER INTSTAT: CTMRA3C1INT (Bit 14)                  */
#define CTIMER_INTSTAT_CTMRA3C1INT_Msk    (0x4000UL)                /*!< CTIMER INTSTAT: CTMRA3C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB2C1INT_Pos    (13UL)                    /*!< CTIMER INTSTAT: CTMRB2C1INT (Bit 13)                  */
#define CTIMER_INTSTAT_CTMRB2C1INT_Msk    (0x2000UL)                /*!< CTIMER INTSTAT: CTMRB2C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA2C1INT_Pos    (12UL)                    /*!< CTIMER INTSTAT: CTMRA2C1INT (Bit 12)                  */
#define CTIMER_INTSTAT_CTMRA2C1INT_Msk    (0x1000UL)                /*!< CTIMER INTSTAT: CTMRA2C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB1C1INT_Pos    (11UL)                    /*!< CTIMER INTSTAT: CTMRB1C1INT (Bit 11)                  */
#define CTIMER_INTSTAT_CTMRB1C1INT_Msk    (0x800UL)                 /*!< CTIMER INTSTAT: CTMRB1C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA1C1INT_Pos    (10UL)                    /*!< CTIMER INTSTAT: CTMRA1C1INT (Bit 10)                  */
#define CTIMER_INTSTAT_CTMRA1C1INT_Msk    (0x400UL)                 /*!< CTIMER INTSTAT: CTMRA1C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB0C1INT_Pos    (9UL)                     /*!< CTIMER INTSTAT: CTMRB0C1INT (Bit 9)                   */
#define CTIMER_INTSTAT_CTMRB0C1INT_Msk    (0x200UL)                 /*!< CTIMER INTSTAT: CTMRB0C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA0C1INT_Pos    (8UL)                     /*!< CTIMER INTSTAT: CTMRA0C1INT (Bit 8)                   */
#define CTIMER_INTSTAT_CTMRA0C1INT_Msk    (0x100UL)                 /*!< CTIMER INTSTAT: CTMRA0C1INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB3C0INT_Pos    (7UL)                     /*!< CTIMER INTSTAT: CTMRB3C0INT (Bit 7)                   */
#define CTIMER_INTSTAT_CTMRB3C0INT_Msk    (0x80UL)                  /*!< CTIMER INTSTAT: CTMRB3C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA3C0INT_Pos    (6UL)                     /*!< CTIMER INTSTAT: CTMRA3C0INT (Bit 6)                   */
#define CTIMER_INTSTAT_CTMRA3C0INT_Msk    (0x40UL)                  /*!< CTIMER INTSTAT: CTMRA3C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB2C0INT_Pos    (5UL)                     /*!< CTIMER INTSTAT: CTMRB2C0INT (Bit 5)                   */
#define CTIMER_INTSTAT_CTMRB2C0INT_Msk    (0x20UL)                  /*!< CTIMER INTSTAT: CTMRB2C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA2C0INT_Pos    (4UL)                     /*!< CTIMER INTSTAT: CTMRA2C0INT (Bit 4)                   */
#define CTIMER_INTSTAT_CTMRA2C0INT_Msk    (0x10UL)                  /*!< CTIMER INTSTAT: CTMRA2C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB1C0INT_Pos    (3UL)                     /*!< CTIMER INTSTAT: CTMRB1C0INT (Bit 3)                   */
#define CTIMER_INTSTAT_CTMRB1C0INT_Msk    (0x8UL)                   /*!< CTIMER INTSTAT: CTMRB1C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA1C0INT_Pos    (2UL)                     /*!< CTIMER INTSTAT: CTMRA1C0INT (Bit 2)                   */
#define CTIMER_INTSTAT_CTMRA1C0INT_Msk    (0x4UL)                   /*!< CTIMER INTSTAT: CTMRA1C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRB0C0INT_Pos    (1UL)                     /*!< CTIMER INTSTAT: CTMRB0C0INT (Bit 1)                   */
#define CTIMER_INTSTAT_CTMRB0C0INT_Msk    (0x2UL)                   /*!< CTIMER INTSTAT: CTMRB0C0INT (Bitfield-Mask: 0x01)     */
#define CTIMER_INTSTAT_CTMRA0C0INT_Pos    (0UL)                     /*!< CTIMER INTSTAT: CTMRA0C0INT (Bit 0)                   */
#define CTIMER_INTSTAT_CTMRA0C0INT_Msk    (0x1UL)                   /*!< CTIMER INTSTAT: CTMRA0C0INT (Bitfield-Mask: 0x01)     */
/* ========================================================  INTCLR  ========================================================= */
#define CTIMER_INTCLR_CTMRB3C1INT_Pos     (15UL)                    /*!< CTIMER INTCLR: CTMRB3C1INT (Bit 15)                   */
#define CTIMER_INTCLR_CTMRB3C1INT_Msk     (0x8000UL)                /*!< CTIMER INTCLR: CTMRB3C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA3C1INT_Pos     (14UL)                    /*!< CTIMER INTCLR: CTMRA3C1INT (Bit 14)                   */
#define CTIMER_INTCLR_CTMRA3C1INT_Msk     (0x4000UL)                /*!< CTIMER INTCLR: CTMRA3C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB2C1INT_Pos     (13UL)                    /*!< CTIMER INTCLR: CTMRB2C1INT (Bit 13)                   */
#define CTIMER_INTCLR_CTMRB2C1INT_Msk     (0x2000UL)                /*!< CTIMER INTCLR: CTMRB2C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA2C1INT_Pos     (12UL)                    /*!< CTIMER INTCLR: CTMRA2C1INT (Bit 12)                   */
#define CTIMER_INTCLR_CTMRA2C1INT_Msk     (0x1000UL)                /*!< CTIMER INTCLR: CTMRA2C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB1C1INT_Pos     (11UL)                    /*!< CTIMER INTCLR: CTMRB1C1INT (Bit 11)                   */
#define CTIMER_INTCLR_CTMRB1C1INT_Msk     (0x800UL)                 /*!< CTIMER INTCLR: CTMRB1C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA1C1INT_Pos     (10UL)                    /*!< CTIMER INTCLR: CTMRA1C1INT (Bit 10)                   */
#define CTIMER_INTCLR_CTMRA1C1INT_Msk     (0x400UL)                 /*!< CTIMER INTCLR: CTMRA1C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB0C1INT_Pos     (9UL)                     /*!< CTIMER INTCLR: CTMRB0C1INT (Bit 9)                    */
#define CTIMER_INTCLR_CTMRB0C1INT_Msk     (0x200UL)                 /*!< CTIMER INTCLR: CTMRB0C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA0C1INT_Pos     (8UL)                     /*!< CTIMER INTCLR: CTMRA0C1INT (Bit 8)                    */
#define CTIMER_INTCLR_CTMRA0C1INT_Msk     (0x100UL)                 /*!< CTIMER INTCLR: CTMRA0C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB3C0INT_Pos     (7UL)                     /*!< CTIMER INTCLR: CTMRB3C0INT (Bit 7)                    */
#define CTIMER_INTCLR_CTMRB3C0INT_Msk     (0x80UL)                  /*!< CTIMER INTCLR: CTMRB3C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA3C0INT_Pos     (6UL)                     /*!< CTIMER INTCLR: CTMRA3C0INT (Bit 6)                    */
#define CTIMER_INTCLR_CTMRA3C0INT_Msk     (0x40UL)                  /*!< CTIMER INTCLR: CTMRA3C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB2C0INT_Pos     (5UL)                     /*!< CTIMER INTCLR: CTMRB2C0INT (Bit 5)                    */
#define CTIMER_INTCLR_CTMRB2C0INT_Msk     (0x20UL)                  /*!< CTIMER INTCLR: CTMRB2C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA2C0INT_Pos     (4UL)                     /*!< CTIMER INTCLR: CTMRA2C0INT (Bit 4)                    */
#define CTIMER_INTCLR_CTMRA2C0INT_Msk     (0x10UL)                  /*!< CTIMER INTCLR: CTMRA2C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB1C0INT_Pos     (3UL)                     /*!< CTIMER INTCLR: CTMRB1C0INT (Bit 3)                    */
#define CTIMER_INTCLR_CTMRB1C0INT_Msk     (0x8UL)                   /*!< CTIMER INTCLR: CTMRB1C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA1C0INT_Pos     (2UL)                     /*!< CTIMER INTCLR: CTMRA1C0INT (Bit 2)                    */
#define CTIMER_INTCLR_CTMRA1C0INT_Msk     (0x4UL)                   /*!< CTIMER INTCLR: CTMRA1C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRB0C0INT_Pos     (1UL)                     /*!< CTIMER INTCLR: CTMRB0C0INT (Bit 1)                    */
#define CTIMER_INTCLR_CTMRB0C0INT_Msk     (0x2UL)                   /*!< CTIMER INTCLR: CTMRB0C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTCLR_CTMRA0C0INT_Pos     (0UL)                     /*!< CTIMER INTCLR: CTMRA0C0INT (Bit 0)                    */
#define CTIMER_INTCLR_CTMRA0C0INT_Msk     (0x1UL)                   /*!< CTIMER INTCLR: CTMRA0C0INT (Bitfield-Mask: 0x01)      */
/* ========================================================  INTSET  ========================================================= */
#define CTIMER_INTSET_CTMRB3C1INT_Pos     (15UL)                    /*!< CTIMER INTSET: CTMRB3C1INT (Bit 15)                   */
#define CTIMER_INTSET_CTMRB3C1INT_Msk     (0x8000UL)                /*!< CTIMER INTSET: CTMRB3C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA3C1INT_Pos     (14UL)                    /*!< CTIMER INTSET: CTMRA3C1INT (Bit 14)                   */
#define CTIMER_INTSET_CTMRA3C1INT_Msk     (0x4000UL)                /*!< CTIMER INTSET: CTMRA3C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB2C1INT_Pos     (13UL)                    /*!< CTIMER INTSET: CTMRB2C1INT (Bit 13)                   */
#define CTIMER_INTSET_CTMRB2C1INT_Msk     (0x2000UL)                /*!< CTIMER INTSET: CTMRB2C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA2C1INT_Pos     (12UL)                    /*!< CTIMER INTSET: CTMRA2C1INT (Bit 12)                   */
#define CTIMER_INTSET_CTMRA2C1INT_Msk     (0x1000UL)                /*!< CTIMER INTSET: CTMRA2C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB1C1INT_Pos     (11UL)                    /*!< CTIMER INTSET: CTMRB1C1INT (Bit 11)                   */
#define CTIMER_INTSET_CTMRB1C1INT_Msk     (0x800UL)                 /*!< CTIMER INTSET: CTMRB1C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA1C1INT_Pos     (10UL)                    /*!< CTIMER INTSET: CTMRA1C1INT (Bit 10)                   */
#define CTIMER_INTSET_CTMRA1C1INT_Msk     (0x400UL)                 /*!< CTIMER INTSET: CTMRA1C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB0C1INT_Pos     (9UL)                     /*!< CTIMER INTSET: CTMRB0C1INT (Bit 9)                    */
#define CTIMER_INTSET_CTMRB0C1INT_Msk     (0x200UL)                 /*!< CTIMER INTSET: CTMRB0C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA0C1INT_Pos     (8UL)                     /*!< CTIMER INTSET: CTMRA0C1INT (Bit 8)                    */
#define CTIMER_INTSET_CTMRA0C1INT_Msk     (0x100UL)                 /*!< CTIMER INTSET: CTMRA0C1INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB3C0INT_Pos     (7UL)                     /*!< CTIMER INTSET: CTMRB3C0INT (Bit 7)                    */
#define CTIMER_INTSET_CTMRB3C0INT_Msk     (0x80UL)                  /*!< CTIMER INTSET: CTMRB3C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA3C0INT_Pos     (6UL)                     /*!< CTIMER INTSET: CTMRA3C0INT (Bit 6)                    */
#define CTIMER_INTSET_CTMRA3C0INT_Msk     (0x40UL)                  /*!< CTIMER INTSET: CTMRA3C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB2C0INT_Pos     (5UL)                     /*!< CTIMER INTSET: CTMRB2C0INT (Bit 5)                    */
#define CTIMER_INTSET_CTMRB2C0INT_Msk     (0x20UL)                  /*!< CTIMER INTSET: CTMRB2C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA2C0INT_Pos     (4UL)                     /*!< CTIMER INTSET: CTMRA2C0INT (Bit 4)                    */
#define CTIMER_INTSET_CTMRA2C0INT_Msk     (0x10UL)                  /*!< CTIMER INTSET: CTMRA2C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB1C0INT_Pos     (3UL)                     /*!< CTIMER INTSET: CTMRB1C0INT (Bit 3)                    */
#define CTIMER_INTSET_CTMRB1C0INT_Msk     (0x8UL)                   /*!< CTIMER INTSET: CTMRB1C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA1C0INT_Pos     (2UL)                     /*!< CTIMER INTSET: CTMRA1C0INT (Bit 2)                    */
#define CTIMER_INTSET_CTMRA1C0INT_Msk     (0x4UL)                   /*!< CTIMER INTSET: CTMRA1C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRB0C0INT_Pos     (1UL)                     /*!< CTIMER INTSET: CTMRB0C0INT (Bit 1)                    */
#define CTIMER_INTSET_CTMRB0C0INT_Msk     (0x2UL)                   /*!< CTIMER INTSET: CTMRB0C0INT (Bitfield-Mask: 0x01)      */
#define CTIMER_INTSET_CTMRA0C0INT_Pos     (0UL)                     /*!< CTIMER INTSET: CTMRA0C0INT (Bit 0)                    */
#define CTIMER_INTSET_CTMRA0C0INT_Msk     (0x1UL)                   /*!< CTIMER INTSET: CTMRA0C0INT (Bitfield-Mask: 0x01)      */
/* =======================================================  STMINTEN  ======================================================== */
#define CTIMER_STMINTEN_CAPTURED_Pos      (12UL)                    /*!< CTIMER STMINTEN: CAPTURED (Bit 12)                    */
#define CTIMER_STMINTEN_CAPTURED_Msk      (0x1000UL)                /*!< CTIMER STMINTEN: CAPTURED (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_CAPTUREC_Pos      (11UL)                    /*!< CTIMER STMINTEN: CAPTUREC (Bit 11)                    */
#define CTIMER_STMINTEN_CAPTUREC_Msk      (0x800UL)                 /*!< CTIMER STMINTEN: CAPTUREC (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_CAPTUREB_Pos      (10UL)                    /*!< CTIMER STMINTEN: CAPTUREB (Bit 10)                    */
#define CTIMER_STMINTEN_CAPTUREB_Msk      (0x400UL)                 /*!< CTIMER STMINTEN: CAPTUREB (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_CAPTUREA_Pos      (9UL)                     /*!< CTIMER STMINTEN: CAPTUREA (Bit 9)                     */
#define CTIMER_STMINTEN_CAPTUREA_Msk      (0x200UL)                 /*!< CTIMER STMINTEN: CAPTUREA (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_OVERFLOW_Pos      (8UL)                     /*!< CTIMER STMINTEN: OVERFLOW (Bit 8)                     */
#define CTIMER_STMINTEN_OVERFLOW_Msk      (0x100UL)                 /*!< CTIMER STMINTEN: OVERFLOW (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_COMPAREH_Pos      (7UL)                     /*!< CTIMER STMINTEN: COMPAREH (Bit 7)                     */
#define CTIMER_STMINTEN_COMPAREH_Msk      (0x80UL)                  /*!< CTIMER STMINTEN: COMPAREH (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_COMPAREG_Pos      (6UL)                     /*!< CTIMER STMINTEN: COMPAREG (Bit 6)                     */
#define CTIMER_STMINTEN_COMPAREG_Msk      (0x40UL)                  /*!< CTIMER STMINTEN: COMPAREG (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_COMPAREF_Pos      (5UL)                     /*!< CTIMER STMINTEN: COMPAREF (Bit 5)                     */
#define CTIMER_STMINTEN_COMPAREF_Msk      (0x20UL)                  /*!< CTIMER STMINTEN: COMPAREF (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_COMPAREE_Pos      (4UL)                     /*!< CTIMER STMINTEN: COMPAREE (Bit 4)                     */
#define CTIMER_STMINTEN_COMPAREE_Msk      (0x10UL)                  /*!< CTIMER STMINTEN: COMPAREE (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_COMPARED_Pos      (3UL)                     /*!< CTIMER STMINTEN: COMPARED (Bit 3)                     */
#define CTIMER_STMINTEN_COMPARED_Msk      (0x8UL)                   /*!< CTIMER STMINTEN: COMPARED (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_COMPAREC_Pos      (2UL)                     /*!< CTIMER STMINTEN: COMPAREC (Bit 2)                     */
#define CTIMER_STMINTEN_COMPAREC_Msk      (0x4UL)                   /*!< CTIMER STMINTEN: COMPAREC (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_COMPAREB_Pos      (1UL)                     /*!< CTIMER STMINTEN: COMPAREB (Bit 1)                     */
#define CTIMER_STMINTEN_COMPAREB_Msk      (0x2UL)                   /*!< CTIMER STMINTEN: COMPAREB (Bitfield-Mask: 0x01)       */
#define CTIMER_STMINTEN_COMPAREA_Pos      (0UL)                     /*!< CTIMER STMINTEN: COMPAREA (Bit 0)                     */
#define CTIMER_STMINTEN_COMPAREA_Msk      (0x1UL)                   /*!< CTIMER STMINTEN: COMPAREA (Bitfield-Mask: 0x01)       */
/* ======================================================  STMINTSTAT  ======================================================= */
#define CTIMER_STMINTSTAT_CAPTURED_Pos    (12UL)                    /*!< CTIMER STMINTSTAT: CAPTURED (Bit 12)                  */
#define CTIMER_STMINTSTAT_CAPTURED_Msk    (0x1000UL)                /*!< CTIMER STMINTSTAT: CAPTURED (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_CAPTUREC_Pos    (11UL)                    /*!< CTIMER STMINTSTAT: CAPTUREC (Bit 11)                  */
#define CTIMER_STMINTSTAT_CAPTUREC_Msk    (0x800UL)                 /*!< CTIMER STMINTSTAT: CAPTUREC (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_CAPTUREB_Pos    (10UL)                    /*!< CTIMER STMINTSTAT: CAPTUREB (Bit 10)                  */
#define CTIMER_STMINTSTAT_CAPTUREB_Msk    (0x400UL)                 /*!< CTIMER STMINTSTAT: CAPTUREB (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_CAPTUREA_Pos    (9UL)                     /*!< CTIMER STMINTSTAT: CAPTUREA (Bit 9)                   */
#define CTIMER_STMINTSTAT_CAPTUREA_Msk    (0x200UL)                 /*!< CTIMER STMINTSTAT: CAPTUREA (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_OVERFLOW_Pos    (8UL)                     /*!< CTIMER STMINTSTAT: OVERFLOW (Bit 8)                   */
#define CTIMER_STMINTSTAT_OVERFLOW_Msk    (0x100UL)                 /*!< CTIMER STMINTSTAT: OVERFLOW (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_COMPAREH_Pos    (7UL)                     /*!< CTIMER STMINTSTAT: COMPAREH (Bit 7)                   */
#define CTIMER_STMINTSTAT_COMPAREH_Msk    (0x80UL)                  /*!< CTIMER STMINTSTAT: COMPAREH (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_COMPAREG_Pos    (6UL)                     /*!< CTIMER STMINTSTAT: COMPAREG (Bit 6)                   */
#define CTIMER_STMINTSTAT_COMPAREG_Msk    (0x40UL)                  /*!< CTIMER STMINTSTAT: COMPAREG (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_COMPAREF_Pos    (5UL)                     /*!< CTIMER STMINTSTAT: COMPAREF (Bit 5)                   */
#define CTIMER_STMINTSTAT_COMPAREF_Msk    (0x20UL)                  /*!< CTIMER STMINTSTAT: COMPAREF (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_COMPAREE_Pos    (4UL)                     /*!< CTIMER STMINTSTAT: COMPAREE (Bit 4)                   */
#define CTIMER_STMINTSTAT_COMPAREE_Msk    (0x10UL)                  /*!< CTIMER STMINTSTAT: COMPAREE (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_COMPARED_Pos    (3UL)                     /*!< CTIMER STMINTSTAT: COMPARED (Bit 3)                   */
#define CTIMER_STMINTSTAT_COMPARED_Msk    (0x8UL)                   /*!< CTIMER STMINTSTAT: COMPARED (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_COMPAREC_Pos    (2UL)                     /*!< CTIMER STMINTSTAT: COMPAREC (Bit 2)                   */
#define CTIMER_STMINTSTAT_COMPAREC_Msk    (0x4UL)                   /*!< CTIMER STMINTSTAT: COMPAREC (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_COMPAREB_Pos    (1UL)                     /*!< CTIMER STMINTSTAT: COMPAREB (Bit 1)                   */
#define CTIMER_STMINTSTAT_COMPAREB_Msk    (0x2UL)                   /*!< CTIMER STMINTSTAT: COMPAREB (Bitfield-Mask: 0x01)     */
#define CTIMER_STMINTSTAT_COMPAREA_Pos    (0UL)                     /*!< CTIMER STMINTSTAT: COMPAREA (Bit 0)                   */
#define CTIMER_STMINTSTAT_COMPAREA_Msk    (0x1UL)                   /*!< CTIMER STMINTSTAT: COMPAREA (Bitfield-Mask: 0x01)     */
/* =======================================================  STMINTCLR  ======================================================= */
#define CTIMER_STMINTCLR_CAPTURED_Pos     (12UL)                    /*!< CTIMER STMINTCLR: CAPTURED (Bit 12)                   */
#define CTIMER_STMINTCLR_CAPTURED_Msk     (0x1000UL)                /*!< CTIMER STMINTCLR: CAPTURED (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_CAPTUREC_Pos     (11UL)                    /*!< CTIMER STMINTCLR: CAPTUREC (Bit 11)                   */
#define CTIMER_STMINTCLR_CAPTUREC_Msk     (0x800UL)                 /*!< CTIMER STMINTCLR: CAPTUREC (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_CAPTUREB_Pos     (10UL)                    /*!< CTIMER STMINTCLR: CAPTUREB (Bit 10)                   */
#define CTIMER_STMINTCLR_CAPTUREB_Msk     (0x400UL)                 /*!< CTIMER STMINTCLR: CAPTUREB (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_CAPTUREA_Pos     (9UL)                     /*!< CTIMER STMINTCLR: CAPTUREA (Bit 9)                    */
#define CTIMER_STMINTCLR_CAPTUREA_Msk     (0x200UL)                 /*!< CTIMER STMINTCLR: CAPTUREA (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_OVERFLOW_Pos     (8UL)                     /*!< CTIMER STMINTCLR: OVERFLOW (Bit 8)                    */
#define CTIMER_STMINTCLR_OVERFLOW_Msk     (0x100UL)                 /*!< CTIMER STMINTCLR: OVERFLOW (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_COMPAREH_Pos     (7UL)                     /*!< CTIMER STMINTCLR: COMPAREH (Bit 7)                    */
#define CTIMER_STMINTCLR_COMPAREH_Msk     (0x80UL)                  /*!< CTIMER STMINTCLR: COMPAREH (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_COMPAREG_Pos     (6UL)                     /*!< CTIMER STMINTCLR: COMPAREG (Bit 6)                    */
#define CTIMER_STMINTCLR_COMPAREG_Msk     (0x40UL)                  /*!< CTIMER STMINTCLR: COMPAREG (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_COMPAREF_Pos     (5UL)                     /*!< CTIMER STMINTCLR: COMPAREF (Bit 5)                    */
#define CTIMER_STMINTCLR_COMPAREF_Msk     (0x20UL)                  /*!< CTIMER STMINTCLR: COMPAREF (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_COMPAREE_Pos     (4UL)                     /*!< CTIMER STMINTCLR: COMPAREE (Bit 4)                    */
#define CTIMER_STMINTCLR_COMPAREE_Msk     (0x10UL)                  /*!< CTIMER STMINTCLR: COMPAREE (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_COMPARED_Pos     (3UL)                     /*!< CTIMER STMINTCLR: COMPARED (Bit 3)                    */
#define CTIMER_STMINTCLR_COMPARED_Msk     (0x8UL)                   /*!< CTIMER STMINTCLR: COMPARED (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_COMPAREC_Pos     (2UL)                     /*!< CTIMER STMINTCLR: COMPAREC (Bit 2)                    */
#define CTIMER_STMINTCLR_COMPAREC_Msk     (0x4UL)                   /*!< CTIMER STMINTCLR: COMPAREC (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_COMPAREB_Pos     (1UL)                     /*!< CTIMER STMINTCLR: COMPAREB (Bit 1)                    */
#define CTIMER_STMINTCLR_COMPAREB_Msk     (0x2UL)                   /*!< CTIMER STMINTCLR: COMPAREB (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTCLR_COMPAREA_Pos     (0UL)                     /*!< CTIMER STMINTCLR: COMPAREA (Bit 0)                    */
#define CTIMER_STMINTCLR_COMPAREA_Msk     (0x1UL)                   /*!< CTIMER STMINTCLR: COMPAREA (Bitfield-Mask: 0x01)      */
/* =======================================================  STMINTSET  ======================================================= */
#define CTIMER_STMINTSET_CAPTURED_Pos     (12UL)                    /*!< CTIMER STMINTSET: CAPTURED (Bit 12)                   */
#define CTIMER_STMINTSET_CAPTURED_Msk     (0x1000UL)                /*!< CTIMER STMINTSET: CAPTURED (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_CAPTUREC_Pos     (11UL)                    /*!< CTIMER STMINTSET: CAPTUREC (Bit 11)                   */
#define CTIMER_STMINTSET_CAPTUREC_Msk     (0x800UL)                 /*!< CTIMER STMINTSET: CAPTUREC (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_CAPTUREB_Pos     (10UL)                    /*!< CTIMER STMINTSET: CAPTUREB (Bit 10)                   */
#define CTIMER_STMINTSET_CAPTUREB_Msk     (0x400UL)                 /*!< CTIMER STMINTSET: CAPTUREB (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_CAPTUREA_Pos     (9UL)                     /*!< CTIMER STMINTSET: CAPTUREA (Bit 9)                    */
#define CTIMER_STMINTSET_CAPTUREA_Msk     (0x200UL)                 /*!< CTIMER STMINTSET: CAPTUREA (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_OVERFLOW_Pos     (8UL)                     /*!< CTIMER STMINTSET: OVERFLOW (Bit 8)                    */
#define CTIMER_STMINTSET_OVERFLOW_Msk     (0x100UL)                 /*!< CTIMER STMINTSET: OVERFLOW (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_COMPAREH_Pos     (7UL)                     /*!< CTIMER STMINTSET: COMPAREH (Bit 7)                    */
#define CTIMER_STMINTSET_COMPAREH_Msk     (0x80UL)                  /*!< CTIMER STMINTSET: COMPAREH (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_COMPAREG_Pos     (6UL)                     /*!< CTIMER STMINTSET: COMPAREG (Bit 6)                    */
#define CTIMER_STMINTSET_COMPAREG_Msk     (0x40UL)                  /*!< CTIMER STMINTSET: COMPAREG (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_COMPAREF_Pos     (5UL)                     /*!< CTIMER STMINTSET: COMPAREF (Bit 5)                    */
#define CTIMER_STMINTSET_COMPAREF_Msk     (0x20UL)                  /*!< CTIMER STMINTSET: COMPAREF (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_COMPAREE_Pos     (4UL)                     /*!< CTIMER STMINTSET: COMPAREE (Bit 4)                    */
#define CTIMER_STMINTSET_COMPAREE_Msk     (0x10UL)                  /*!< CTIMER STMINTSET: COMPAREE (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_COMPARED_Pos     (3UL)                     /*!< CTIMER STMINTSET: COMPARED (Bit 3)                    */
#define CTIMER_STMINTSET_COMPARED_Msk     (0x8UL)                   /*!< CTIMER STMINTSET: COMPARED (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_COMPAREC_Pos     (2UL)                     /*!< CTIMER STMINTSET: COMPAREC (Bit 2)                    */
#define CTIMER_STMINTSET_COMPAREC_Msk     (0x4UL)                   /*!< CTIMER STMINTSET: COMPAREC (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_COMPAREB_Pos     (1UL)                     /*!< CTIMER STMINTSET: COMPAREB (Bit 1)                    */
#define CTIMER_STMINTSET_COMPAREB_Msk     (0x2UL)                   /*!< CTIMER STMINTSET: COMPAREB (Bitfield-Mask: 0x01)      */
#define CTIMER_STMINTSET_COMPAREA_Pos     (0UL)                     /*!< CTIMER STMINTSET: COMPAREA (Bit 0)                    */
#define CTIMER_STMINTSET_COMPAREA_Msk     (0x1UL)                   /*!< CTIMER STMINTSET: COMPAREA (Bitfield-Mask: 0x01)      */


/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */

/* ========================================================  PADREGA  ======================================================== */
#define GPIO_PADREGA_PAD3FNCSEL_Pos       (27UL)                    /*!< GPIO PADREGA: PAD3FNCSEL (Bit 27)                     */
#define GPIO_PADREGA_PAD3FNCSEL_Msk       (0x38000000UL)            /*!< GPIO PADREGA: PAD3FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGA_PAD3STRNG_Pos        (26UL)                    /*!< GPIO PADREGA: PAD3STRNG (Bit 26)                      */
#define GPIO_PADREGA_PAD3STRNG_Msk        (0x4000000UL)             /*!< GPIO PADREGA: PAD3STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD3INPEN_Pos        (25UL)                    /*!< GPIO PADREGA: PAD3INPEN (Bit 25)                      */
#define GPIO_PADREGA_PAD3INPEN_Msk        (0x2000000UL)             /*!< GPIO PADREGA: PAD3INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD3PULL_Pos         (24UL)                    /*!< GPIO PADREGA: PAD3PULL (Bit 24)                       */
#define GPIO_PADREGA_PAD3PULL_Msk         (0x1000000UL)             /*!< GPIO PADREGA: PAD3PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGA_PAD2FNCSEL_Pos       (19UL)                    /*!< GPIO PADREGA: PAD2FNCSEL (Bit 19)                     */
#define GPIO_PADREGA_PAD2FNCSEL_Msk       (0x380000UL)              /*!< GPIO PADREGA: PAD2FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGA_PAD2STRNG_Pos        (18UL)                    /*!< GPIO PADREGA: PAD2STRNG (Bit 18)                      */
#define GPIO_PADREGA_PAD2STRNG_Msk        (0x40000UL)               /*!< GPIO PADREGA: PAD2STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD2INPEN_Pos        (17UL)                    /*!< GPIO PADREGA: PAD2INPEN (Bit 17)                      */
#define GPIO_PADREGA_PAD2INPEN_Msk        (0x20000UL)               /*!< GPIO PADREGA: PAD2INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD2PULL_Pos         (16UL)                    /*!< GPIO PADREGA: PAD2PULL (Bit 16)                       */
#define GPIO_PADREGA_PAD2PULL_Msk         (0x10000UL)               /*!< GPIO PADREGA: PAD2PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGA_PAD1RSEL_Pos         (14UL)                    /*!< GPIO PADREGA: PAD1RSEL (Bit 14)                       */
#define GPIO_PADREGA_PAD1RSEL_Msk         (0xc000UL)                /*!< GPIO PADREGA: PAD1RSEL (Bitfield-Mask: 0x03)          */
#define GPIO_PADREGA_PAD1FNCSEL_Pos       (11UL)                    /*!< GPIO PADREGA: PAD1FNCSEL (Bit 11)                     */
#define GPIO_PADREGA_PAD1FNCSEL_Msk       (0x3800UL)                /*!< GPIO PADREGA: PAD1FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGA_PAD1STRNG_Pos        (10UL)                    /*!< GPIO PADREGA: PAD1STRNG (Bit 10)                      */
#define GPIO_PADREGA_PAD1STRNG_Msk        (0x400UL)                 /*!< GPIO PADREGA: PAD1STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD1INPEN_Pos        (9UL)                     /*!< GPIO PADREGA: PAD1INPEN (Bit 9)                       */
#define GPIO_PADREGA_PAD1INPEN_Msk        (0x200UL)                 /*!< GPIO PADREGA: PAD1INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD1PULL_Pos         (8UL)                     /*!< GPIO PADREGA: PAD1PULL (Bit 8)                        */
#define GPIO_PADREGA_PAD1PULL_Msk         (0x100UL)                 /*!< GPIO PADREGA: PAD1PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGA_PAD0RSEL_Pos         (6UL)                     /*!< GPIO PADREGA: PAD0RSEL (Bit 6)                        */
#define GPIO_PADREGA_PAD0RSEL_Msk         (0xc0UL)                  /*!< GPIO PADREGA: PAD0RSEL (Bitfield-Mask: 0x03)          */
#define GPIO_PADREGA_PAD0FNCSEL_Pos       (3UL)                     /*!< GPIO PADREGA: PAD0FNCSEL (Bit 3)                      */
#define GPIO_PADREGA_PAD0FNCSEL_Msk       (0x38UL)                  /*!< GPIO PADREGA: PAD0FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGA_PAD0STRNG_Pos        (2UL)                     /*!< GPIO PADREGA: PAD0STRNG (Bit 2)                       */
#define GPIO_PADREGA_PAD0STRNG_Msk        (0x4UL)                   /*!< GPIO PADREGA: PAD0STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD0INPEN_Pos        (1UL)                     /*!< GPIO PADREGA: PAD0INPEN (Bit 1)                       */
#define GPIO_PADREGA_PAD0INPEN_Msk        (0x2UL)                   /*!< GPIO PADREGA: PAD0INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD0PULL_Pos         (0UL)                     /*!< GPIO PADREGA: PAD0PULL (Bit 0)                        */
#define GPIO_PADREGA_PAD0PULL_Msk         (0x1UL)                   /*!< GPIO PADREGA: PAD0PULL (Bitfield-Mask: 0x01)          */
/* ========================================================  PADREGB  ======================================================== */
#define GPIO_PADREGB_PAD7FNCSEL_Pos       (27UL)                    /*!< GPIO PADREGB: PAD7FNCSEL (Bit 27)                     */
#define GPIO_PADREGB_PAD7FNCSEL_Msk       (0x38000000UL)            /*!< GPIO PADREGB: PAD7FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGB_PAD7STRNG_Pos        (26UL)                    /*!< GPIO PADREGB: PAD7STRNG (Bit 26)                      */
#define GPIO_PADREGB_PAD7STRNG_Msk        (0x4000000UL)             /*!< GPIO PADREGB: PAD7STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD7INPEN_Pos        (25UL)                    /*!< GPIO PADREGB: PAD7INPEN (Bit 25)                      */
#define GPIO_PADREGB_PAD7INPEN_Msk        (0x2000000UL)             /*!< GPIO PADREGB: PAD7INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD7PULL_Pos         (24UL)                    /*!< GPIO PADREGB: PAD7PULL (Bit 24)                       */
#define GPIO_PADREGB_PAD7PULL_Msk         (0x1000000UL)             /*!< GPIO PADREGB: PAD7PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGB_PAD6RSEL_Pos         (22UL)                    /*!< GPIO PADREGB: PAD6RSEL (Bit 22)                       */
#define GPIO_PADREGB_PAD6RSEL_Msk         (0xc00000UL)              /*!< GPIO PADREGB: PAD6RSEL (Bitfield-Mask: 0x03)          */
#define GPIO_PADREGB_PAD6FNCSEL_Pos       (19UL)                    /*!< GPIO PADREGB: PAD6FNCSEL (Bit 19)                     */
#define GPIO_PADREGB_PAD6FNCSEL_Msk       (0x380000UL)              /*!< GPIO PADREGB: PAD6FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGB_PAD6STRNG_Pos        (18UL)                    /*!< GPIO PADREGB: PAD6STRNG (Bit 18)                      */
#define GPIO_PADREGB_PAD6STRNG_Msk        (0x40000UL)               /*!< GPIO PADREGB: PAD6STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD6INPEN_Pos        (17UL)                    /*!< GPIO PADREGB: PAD6INPEN (Bit 17)                      */
#define GPIO_PADREGB_PAD6INPEN_Msk        (0x20000UL)               /*!< GPIO PADREGB: PAD6INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD6PULL_Pos         (16UL)                    /*!< GPIO PADREGB: PAD6PULL (Bit 16)                       */
#define GPIO_PADREGB_PAD6PULL_Msk         (0x10000UL)               /*!< GPIO PADREGB: PAD6PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGB_PAD5RSEL_Pos         (14UL)                    /*!< GPIO PADREGB: PAD5RSEL (Bit 14)                       */
#define GPIO_PADREGB_PAD5RSEL_Msk         (0xc000UL)                /*!< GPIO PADREGB: PAD5RSEL (Bitfield-Mask: 0x03)          */
#define GPIO_PADREGB_PAD5FNCSEL_Pos       (11UL)                    /*!< GPIO PADREGB: PAD5FNCSEL (Bit 11)                     */
#define GPIO_PADREGB_PAD5FNCSEL_Msk       (0x3800UL)                /*!< GPIO PADREGB: PAD5FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGB_PAD5STRNG_Pos        (10UL)                    /*!< GPIO PADREGB: PAD5STRNG (Bit 10)                      */
#define GPIO_PADREGB_PAD5STRNG_Msk        (0x400UL)                 /*!< GPIO PADREGB: PAD5STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD5INPEN_Pos        (9UL)                     /*!< GPIO PADREGB: PAD5INPEN (Bit 9)                       */
#define GPIO_PADREGB_PAD5INPEN_Msk        (0x200UL)                 /*!< GPIO PADREGB: PAD5INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD5PULL_Pos         (8UL)                     /*!< GPIO PADREGB: PAD5PULL (Bit 8)                        */
#define GPIO_PADREGB_PAD5PULL_Msk         (0x100UL)                 /*!< GPIO PADREGB: PAD5PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGB_PAD4PWRDN_Pos        (7UL)                     /*!< GPIO PADREGB: PAD4PWRDN (Bit 7)                       */
#define GPIO_PADREGB_PAD4PWRDN_Msk        (0x80UL)                  /*!< GPIO PADREGB: PAD4PWRDN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD4FNCSEL_Pos       (3UL)                     /*!< GPIO PADREGB: PAD4FNCSEL (Bit 3)                      */
#define GPIO_PADREGB_PAD4FNCSEL_Msk       (0x38UL)                  /*!< GPIO PADREGB: PAD4FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGB_PAD4STRNG_Pos        (2UL)                     /*!< GPIO PADREGB: PAD4STRNG (Bit 2)                       */
#define GPIO_PADREGB_PAD4STRNG_Msk        (0x4UL)                   /*!< GPIO PADREGB: PAD4STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD4INPEN_Pos        (1UL)                     /*!< GPIO PADREGB: PAD4INPEN (Bit 1)                       */
#define GPIO_PADREGB_PAD4INPEN_Msk        (0x2UL)                   /*!< GPIO PADREGB: PAD4INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD4PULL_Pos         (0UL)                     /*!< GPIO PADREGB: PAD4PULL (Bit 0)                        */
#define GPIO_PADREGB_PAD4PULL_Msk         (0x1UL)                   /*!< GPIO PADREGB: PAD4PULL (Bitfield-Mask: 0x01)          */
/* ========================================================  PADREGC  ======================================================== */
#define GPIO_PADREGC_PAD11FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGC: PAD11FNCSEL (Bit 27)                    */
#define GPIO_PADREGC_PAD11FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGC: PAD11FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGC_PAD11STRNG_Pos       (26UL)                    /*!< GPIO PADREGC: PAD11STRNG (Bit 26)                     */
#define GPIO_PADREGC_PAD11STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGC: PAD11STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGC_PAD11INPEN_Pos       (25UL)                    /*!< GPIO PADREGC: PAD11INPEN (Bit 25)                     */
#define GPIO_PADREGC_PAD11INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGC: PAD11INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGC_PAD11PULL_Pos        (24UL)                    /*!< GPIO PADREGC: PAD11PULL (Bit 24)                      */
#define GPIO_PADREGC_PAD11PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGC: PAD11PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD10FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGC: PAD10FNCSEL (Bit 19)                    */
#define GPIO_PADREGC_PAD10FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGC: PAD10FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGC_PAD10STRNG_Pos       (18UL)                    /*!< GPIO PADREGC: PAD10STRNG (Bit 18)                     */
#define GPIO_PADREGC_PAD10STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGC: PAD10STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGC_PAD10INPEN_Pos       (17UL)                    /*!< GPIO PADREGC: PAD10INPEN (Bit 17)                     */
#define GPIO_PADREGC_PAD10INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGC: PAD10INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGC_PAD10PULL_Pos        (16UL)                    /*!< GPIO PADREGC: PAD10PULL (Bit 16)                      */
#define GPIO_PADREGC_PAD10PULL_Msk        (0x10000UL)               /*!< GPIO PADREGC: PAD10PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD9RSEL_Pos         (14UL)                    /*!< GPIO PADREGC: PAD9RSEL (Bit 14)                       */
#define GPIO_PADREGC_PAD9RSEL_Msk         (0xc000UL)                /*!< GPIO PADREGC: PAD9RSEL (Bitfield-Mask: 0x03)          */
#define GPIO_PADREGC_PAD9FNCSEL_Pos       (11UL)                    /*!< GPIO PADREGC: PAD9FNCSEL (Bit 11)                     */
#define GPIO_PADREGC_PAD9FNCSEL_Msk       (0x3800UL)                /*!< GPIO PADREGC: PAD9FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGC_PAD9STRNG_Pos        (10UL)                    /*!< GPIO PADREGC: PAD9STRNG (Bit 10)                      */
#define GPIO_PADREGC_PAD9STRNG_Msk        (0x400UL)                 /*!< GPIO PADREGC: PAD9STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD9INPEN_Pos        (9UL)                     /*!< GPIO PADREGC: PAD9INPEN (Bit 9)                       */
#define GPIO_PADREGC_PAD9INPEN_Msk        (0x200UL)                 /*!< GPIO PADREGC: PAD9INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD9PULL_Pos         (8UL)                     /*!< GPIO PADREGC: PAD9PULL (Bit 8)                        */
#define GPIO_PADREGC_PAD9PULL_Msk         (0x100UL)                 /*!< GPIO PADREGC: PAD9PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGC_PAD8RSEL_Pos         (6UL)                     /*!< GPIO PADREGC: PAD8RSEL (Bit 6)                        */
#define GPIO_PADREGC_PAD8RSEL_Msk         (0xc0UL)                  /*!< GPIO PADREGC: PAD8RSEL (Bitfield-Mask: 0x03)          */
#define GPIO_PADREGC_PAD8FNCSEL_Pos       (3UL)                     /*!< GPIO PADREGC: PAD8FNCSEL (Bit 3)                      */
#define GPIO_PADREGC_PAD8FNCSEL_Msk       (0x38UL)                  /*!< GPIO PADREGC: PAD8FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGC_PAD8STRNG_Pos        (2UL)                     /*!< GPIO PADREGC: PAD8STRNG (Bit 2)                       */
#define GPIO_PADREGC_PAD8STRNG_Msk        (0x4UL)                   /*!< GPIO PADREGC: PAD8STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD8INPEN_Pos        (1UL)                     /*!< GPIO PADREGC: PAD8INPEN (Bit 1)                       */
#define GPIO_PADREGC_PAD8INPEN_Msk        (0x2UL)                   /*!< GPIO PADREGC: PAD8INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD8PULL_Pos         (0UL)                     /*!< GPIO PADREGC: PAD8PULL (Bit 0)                        */
#define GPIO_PADREGC_PAD8PULL_Msk         (0x1UL)                   /*!< GPIO PADREGC: PAD8PULL (Bitfield-Mask: 0x01)          */
/* ========================================================  PADREGD  ======================================================== */
#define GPIO_PADREGD_PAD15FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGD: PAD15FNCSEL (Bit 27)                    */
#define GPIO_PADREGD_PAD15FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGD: PAD15FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGD_PAD15STRNG_Pos       (26UL)                    /*!< GPIO PADREGD: PAD15STRNG (Bit 26)                     */
#define GPIO_PADREGD_PAD15STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGD: PAD15STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD15INPEN_Pos       (25UL)                    /*!< GPIO PADREGD: PAD15INPEN (Bit 25)                     */
#define GPIO_PADREGD_PAD15INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGD: PAD15INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD15PULL_Pos        (24UL)                    /*!< GPIO PADREGD: PAD15PULL (Bit 24)                      */
#define GPIO_PADREGD_PAD15PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGD: PAD15PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGD_PAD14FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGD: PAD14FNCSEL (Bit 19)                    */
#define GPIO_PADREGD_PAD14FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGD: PAD14FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGD_PAD14STRNG_Pos       (18UL)                    /*!< GPIO PADREGD: PAD14STRNG (Bit 18)                     */
#define GPIO_PADREGD_PAD14STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGD: PAD14STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD14INPEN_Pos       (17UL)                    /*!< GPIO PADREGD: PAD14INPEN (Bit 17)                     */
#define GPIO_PADREGD_PAD14INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGD: PAD14INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD14PULL_Pos        (16UL)                    /*!< GPIO PADREGD: PAD14PULL (Bit 16)                      */
#define GPIO_PADREGD_PAD14PULL_Msk        (0x10000UL)               /*!< GPIO PADREGD: PAD14PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGD_PAD13FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGD: PAD13FNCSEL (Bit 11)                    */
#define GPIO_PADREGD_PAD13FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGD: PAD13FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGD_PAD13STRNG_Pos       (10UL)                    /*!< GPIO PADREGD: PAD13STRNG (Bit 10)                     */
#define GPIO_PADREGD_PAD13STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGD: PAD13STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD13INPEN_Pos       (9UL)                     /*!< GPIO PADREGD: PAD13INPEN (Bit 9)                      */
#define GPIO_PADREGD_PAD13INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGD: PAD13INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD13PULL_Pos        (8UL)                     /*!< GPIO PADREGD: PAD13PULL (Bit 8)                       */
#define GPIO_PADREGD_PAD13PULL_Msk        (0x100UL)                 /*!< GPIO PADREGD: PAD13PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGD_PAD12FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGD: PAD12FNCSEL (Bit 3)                     */
#define GPIO_PADREGD_PAD12FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGD: PAD12FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGD_PAD12STRNG_Pos       (2UL)                     /*!< GPIO PADREGD: PAD12STRNG (Bit 2)                      */
#define GPIO_PADREGD_PAD12STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGD: PAD12STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD12INPEN_Pos       (1UL)                     /*!< GPIO PADREGD: PAD12INPEN (Bit 1)                      */
#define GPIO_PADREGD_PAD12INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGD: PAD12INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD12PULL_Pos        (0UL)                     /*!< GPIO PADREGD: PAD12PULL (Bit 0)                       */
#define GPIO_PADREGD_PAD12PULL_Msk        (0x1UL)                   /*!< GPIO PADREGD: PAD12PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGE  ======================================================== */
#define GPIO_PADREGE_PAD19FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGE: PAD19FNCSEL (Bit 27)                    */
#define GPIO_PADREGE_PAD19FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGE: PAD19FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGE_PAD19STRNG_Pos       (26UL)                    /*!< GPIO PADREGE: PAD19STRNG (Bit 26)                     */
#define GPIO_PADREGE_PAD19STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGE: PAD19STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD19INPEN_Pos       (25UL)                    /*!< GPIO PADREGE: PAD19INPEN (Bit 25)                     */
#define GPIO_PADREGE_PAD19INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGE: PAD19INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD19PULL_Pos        (24UL)                    /*!< GPIO PADREGE: PAD19PULL (Bit 24)                      */
#define GPIO_PADREGE_PAD19PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGE: PAD19PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGE_PAD18FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGE: PAD18FNCSEL (Bit 19)                    */
#define GPIO_PADREGE_PAD18FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGE: PAD18FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGE_PAD18STRNG_Pos       (18UL)                    /*!< GPIO PADREGE: PAD18STRNG (Bit 18)                     */
#define GPIO_PADREGE_PAD18STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGE: PAD18STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD18INPEN_Pos       (17UL)                    /*!< GPIO PADREGE: PAD18INPEN (Bit 17)                     */
#define GPIO_PADREGE_PAD18INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGE: PAD18INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD18PULL_Pos        (16UL)                    /*!< GPIO PADREGE: PAD18PULL (Bit 16)                      */
#define GPIO_PADREGE_PAD18PULL_Msk        (0x10000UL)               /*!< GPIO PADREGE: PAD18PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGE_PAD17FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGE: PAD17FNCSEL (Bit 11)                    */
#define GPIO_PADREGE_PAD17FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGE: PAD17FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGE_PAD17STRNG_Pos       (10UL)                    /*!< GPIO PADREGE: PAD17STRNG (Bit 10)                     */
#define GPIO_PADREGE_PAD17STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGE: PAD17STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD17INPEN_Pos       (9UL)                     /*!< GPIO PADREGE: PAD17INPEN (Bit 9)                      */
#define GPIO_PADREGE_PAD17INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGE: PAD17INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD17PULL_Pos        (8UL)                     /*!< GPIO PADREGE: PAD17PULL (Bit 8)                       */
#define GPIO_PADREGE_PAD17PULL_Msk        (0x100UL)                 /*!< GPIO PADREGE: PAD17PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGE_PAD16FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGE: PAD16FNCSEL (Bit 3)                     */
#define GPIO_PADREGE_PAD16FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGE: PAD16FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGE_PAD16STRNG_Pos       (2UL)                     /*!< GPIO PADREGE: PAD16STRNG (Bit 2)                      */
#define GPIO_PADREGE_PAD16STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGE: PAD16STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD16INPEN_Pos       (1UL)                     /*!< GPIO PADREGE: PAD16INPEN (Bit 1)                      */
#define GPIO_PADREGE_PAD16INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGE: PAD16INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD16PULL_Pos        (0UL)                     /*!< GPIO PADREGE: PAD16PULL (Bit 0)                       */
#define GPIO_PADREGE_PAD16PULL_Msk        (0x1UL)                   /*!< GPIO PADREGE: PAD16PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGF  ======================================================== */
#define GPIO_PADREGF_PAD23FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGF: PAD23FNCSEL (Bit 27)                    */
#define GPIO_PADREGF_PAD23FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGF: PAD23FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGF_PAD23STRNG_Pos       (26UL)                    /*!< GPIO PADREGF: PAD23STRNG (Bit 26)                     */
#define GPIO_PADREGF_PAD23STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGF: PAD23STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD23INPEN_Pos       (25UL)                    /*!< GPIO PADREGF: PAD23INPEN (Bit 25)                     */
#define GPIO_PADREGF_PAD23INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGF: PAD23INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD23PULL_Pos        (24UL)                    /*!< GPIO PADREGF: PAD23PULL (Bit 24)                      */
#define GPIO_PADREGF_PAD23PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGF: PAD23PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGF_PAD22PWRUP_Pos       (23UL)                    /*!< GPIO PADREGF: PAD22PWRUP (Bit 23)                     */
#define GPIO_PADREGF_PAD22PWRUP_Msk       (0x800000UL)              /*!< GPIO PADREGF: PAD22PWRUP (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD22FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGF: PAD22FNCSEL (Bit 19)                    */
#define GPIO_PADREGF_PAD22FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGF: PAD22FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGF_PAD22STRNG_Pos       (18UL)                    /*!< GPIO PADREGF: PAD22STRNG (Bit 18)                     */
#define GPIO_PADREGF_PAD22STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGF: PAD22STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD22INPEN_Pos       (17UL)                    /*!< GPIO PADREGF: PAD22INPEN (Bit 17)                     */
#define GPIO_PADREGF_PAD22INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGF: PAD22INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD22PULL_Pos        (16UL)                    /*!< GPIO PADREGF: PAD22PULL (Bit 16)                      */
#define GPIO_PADREGF_PAD22PULL_Msk        (0x10000UL)               /*!< GPIO PADREGF: PAD22PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGF_PAD21FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGF: PAD21FNCSEL (Bit 11)                    */
#define GPIO_PADREGF_PAD21FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGF: PAD21FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGF_PAD21STRNG_Pos       (10UL)                    /*!< GPIO PADREGF: PAD21STRNG (Bit 10)                     */
#define GPIO_PADREGF_PAD21STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGF: PAD21STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD21INPEN_Pos       (9UL)                     /*!< GPIO PADREGF: PAD21INPEN (Bit 9)                      */
#define GPIO_PADREGF_PAD21INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGF: PAD21INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD21PULL_Pos        (8UL)                     /*!< GPIO PADREGF: PAD21PULL (Bit 8)                       */
#define GPIO_PADREGF_PAD21PULL_Msk        (0x100UL)                 /*!< GPIO PADREGF: PAD21PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGF_PAD20FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGF: PAD20FNCSEL (Bit 3)                     */
#define GPIO_PADREGF_PAD20FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGF: PAD20FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGF_PAD20STRNG_Pos       (2UL)                     /*!< GPIO PADREGF: PAD20STRNG (Bit 2)                      */
#define GPIO_PADREGF_PAD20STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGF: PAD20STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD20INPEN_Pos       (1UL)                     /*!< GPIO PADREGF: PAD20INPEN (Bit 1)                      */
#define GPIO_PADREGF_PAD20INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGF: PAD20INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD20PULL_Pos        (0UL)                     /*!< GPIO PADREGF: PAD20PULL (Bit 0)                       */
#define GPIO_PADREGF_PAD20PULL_Msk        (0x1UL)                   /*!< GPIO PADREGF: PAD20PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGG  ======================================================== */
#define GPIO_PADREGG_PAD27RSEL_Pos        (30UL)                    /*!< GPIO PADREGG: PAD27RSEL (Bit 30)                      */
#define GPIO_PADREGG_PAD27RSEL_Msk        (0xc0000000UL)            /*!< GPIO PADREGG: PAD27RSEL (Bitfield-Mask: 0x03)         */
#define GPIO_PADREGG_PAD27FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGG: PAD27FNCSEL (Bit 27)                    */
#define GPIO_PADREGG_PAD27FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGG: PAD27FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGG_PAD27STRNG_Pos       (26UL)                    /*!< GPIO PADREGG: PAD27STRNG (Bit 26)                     */
#define GPIO_PADREGG_PAD27STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGG: PAD27STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD27INPEN_Pos       (25UL)                    /*!< GPIO PADREGG: PAD27INPEN (Bit 25)                     */
#define GPIO_PADREGG_PAD27INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGG: PAD27INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD27PULL_Pos        (24UL)                    /*!< GPIO PADREGG: PAD27PULL (Bit 24)                      */
#define GPIO_PADREGG_PAD27PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGG: PAD27PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGG_PAD26FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGG: PAD26FNCSEL (Bit 19)                    */
#define GPIO_PADREGG_PAD26FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGG: PAD26FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGG_PAD26STRNG_Pos       (18UL)                    /*!< GPIO PADREGG: PAD26STRNG (Bit 18)                     */
#define GPIO_PADREGG_PAD26STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGG: PAD26STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD26INPEN_Pos       (17UL)                    /*!< GPIO PADREGG: PAD26INPEN (Bit 17)                     */
#define GPIO_PADREGG_PAD26INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGG: PAD26INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD26PULL_Pos        (16UL)                    /*!< GPIO PADREGG: PAD26PULL (Bit 16)                      */
#define GPIO_PADREGG_PAD26PULL_Msk        (0x10000UL)               /*!< GPIO PADREGG: PAD26PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGG_PAD25RSEL_Pos        (14UL)                    /*!< GPIO PADREGG: PAD25RSEL (Bit 14)                      */
#define GPIO_PADREGG_PAD25RSEL_Msk        (0xc000UL)                /*!< GPIO PADREGG: PAD25RSEL (Bitfield-Mask: 0x03)         */
#define GPIO_PADREGG_PAD25FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGG: PAD25FNCSEL (Bit 11)                    */
#define GPIO_PADREGG_PAD25FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGG: PAD25FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGG_PAD25STRNG_Pos       (10UL)                    /*!< GPIO PADREGG: PAD25STRNG (Bit 10)                     */
#define GPIO_PADREGG_PAD25STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGG: PAD25STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD25INPEN_Pos       (9UL)                     /*!< GPIO PADREGG: PAD25INPEN (Bit 9)                      */
#define GPIO_PADREGG_PAD25INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGG: PAD25INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD25PULL_Pos        (8UL)                     /*!< GPIO PADREGG: PAD25PULL (Bit 8)                       */
#define GPIO_PADREGG_PAD25PULL_Msk        (0x100UL)                 /*!< GPIO PADREGG: PAD25PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGG_PAD24FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGG: PAD24FNCSEL (Bit 3)                     */
#define GPIO_PADREGG_PAD24FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGG: PAD24FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGG_PAD24STRNG_Pos       (2UL)                     /*!< GPIO PADREGG: PAD24STRNG (Bit 2)                      */
#define GPIO_PADREGG_PAD24STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGG: PAD24STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD24INPEN_Pos       (1UL)                     /*!< GPIO PADREGG: PAD24INPEN (Bit 1)                      */
#define GPIO_PADREGG_PAD24INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGG: PAD24INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD24PULL_Pos        (0UL)                     /*!< GPIO PADREGG: PAD24PULL (Bit 0)                       */
#define GPIO_PADREGG_PAD24PULL_Msk        (0x1UL)                   /*!< GPIO PADREGG: PAD24PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGH  ======================================================== */
#define GPIO_PADREGH_PAD31FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGH: PAD31FNCSEL (Bit 27)                    */
#define GPIO_PADREGH_PAD31FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGH: PAD31FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGH_PAD31STRNG_Pos       (26UL)                    /*!< GPIO PADREGH: PAD31STRNG (Bit 26)                     */
#define GPIO_PADREGH_PAD31STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGH: PAD31STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD31INPEN_Pos       (25UL)                    /*!< GPIO PADREGH: PAD31INPEN (Bit 25)                     */
#define GPIO_PADREGH_PAD31INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGH: PAD31INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD31PULL_Pos        (24UL)                    /*!< GPIO PADREGH: PAD31PULL (Bit 24)                      */
#define GPIO_PADREGH_PAD31PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGH: PAD31PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGH_PAD30FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGH: PAD30FNCSEL (Bit 19)                    */
#define GPIO_PADREGH_PAD30FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGH: PAD30FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGH_PAD30STRNG_Pos       (18UL)                    /*!< GPIO PADREGH: PAD30STRNG (Bit 18)                     */
#define GPIO_PADREGH_PAD30STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGH: PAD30STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD30INPEN_Pos       (17UL)                    /*!< GPIO PADREGH: PAD30INPEN (Bit 17)                     */
#define GPIO_PADREGH_PAD30INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGH: PAD30INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD30PULL_Pos        (16UL)                    /*!< GPIO PADREGH: PAD30PULL (Bit 16)                      */
#define GPIO_PADREGH_PAD30PULL_Msk        (0x10000UL)               /*!< GPIO PADREGH: PAD30PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGH_PAD29FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGH: PAD29FNCSEL (Bit 11)                    */
#define GPIO_PADREGH_PAD29FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGH: PAD29FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGH_PAD29STRNG_Pos       (10UL)                    /*!< GPIO PADREGH: PAD29STRNG (Bit 10)                     */
#define GPIO_PADREGH_PAD29STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGH: PAD29STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD29INPEN_Pos       (9UL)                     /*!< GPIO PADREGH: PAD29INPEN (Bit 9)                      */
#define GPIO_PADREGH_PAD29INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGH: PAD29INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD29PULL_Pos        (8UL)                     /*!< GPIO PADREGH: PAD29PULL (Bit 8)                       */
#define GPIO_PADREGH_PAD29PULL_Msk        (0x100UL)                 /*!< GPIO PADREGH: PAD29PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGH_PAD28FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGH: PAD28FNCSEL (Bit 3)                     */
#define GPIO_PADREGH_PAD28FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGH: PAD28FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGH_PAD28STRNG_Pos       (2UL)                     /*!< GPIO PADREGH: PAD28STRNG (Bit 2)                      */
#define GPIO_PADREGH_PAD28STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGH: PAD28STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD28INPEN_Pos       (1UL)                     /*!< GPIO PADREGH: PAD28INPEN (Bit 1)                      */
#define GPIO_PADREGH_PAD28INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGH: PAD28INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD28PULL_Pos        (0UL)                     /*!< GPIO PADREGH: PAD28PULL (Bit 0)                       */
#define GPIO_PADREGH_PAD28PULL_Msk        (0x1UL)                   /*!< GPIO PADREGH: PAD28PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGI  ======================================================== */
#define GPIO_PADREGI_PAD35FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGI: PAD35FNCSEL (Bit 27)                    */
#define GPIO_PADREGI_PAD35FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGI: PAD35FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGI_PAD35STRNG_Pos       (26UL)                    /*!< GPIO PADREGI: PAD35STRNG (Bit 26)                     */
#define GPIO_PADREGI_PAD35STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGI: PAD35STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD35INPEN_Pos       (25UL)                    /*!< GPIO PADREGI: PAD35INPEN (Bit 25)                     */
#define GPIO_PADREGI_PAD35INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGI: PAD35INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD35PULL_Pos        (24UL)                    /*!< GPIO PADREGI: PAD35PULL (Bit 24)                      */
#define GPIO_PADREGI_PAD35PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGI: PAD35PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGI_PAD34FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGI: PAD34FNCSEL (Bit 19)                    */
#define GPIO_PADREGI_PAD34FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGI: PAD34FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGI_PAD34STRNG_Pos       (18UL)                    /*!< GPIO PADREGI: PAD34STRNG (Bit 18)                     */
#define GPIO_PADREGI_PAD34STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGI: PAD34STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD34INPEN_Pos       (17UL)                    /*!< GPIO PADREGI: PAD34INPEN (Bit 17)                     */
#define GPIO_PADREGI_PAD34INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGI: PAD34INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD34PULL_Pos        (16UL)                    /*!< GPIO PADREGI: PAD34PULL (Bit 16)                      */
#define GPIO_PADREGI_PAD34PULL_Msk        (0x10000UL)               /*!< GPIO PADREGI: PAD34PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGI_PAD33FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGI: PAD33FNCSEL (Bit 11)                    */
#define GPIO_PADREGI_PAD33FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGI: PAD33FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGI_PAD33STRNG_Pos       (10UL)                    /*!< GPIO PADREGI: PAD33STRNG (Bit 10)                     */
#define GPIO_PADREGI_PAD33STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGI: PAD33STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD33INPEN_Pos       (9UL)                     /*!< GPIO PADREGI: PAD33INPEN (Bit 9)                      */
#define GPIO_PADREGI_PAD33INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGI: PAD33INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD33PULL_Pos        (8UL)                     /*!< GPIO PADREGI: PAD33PULL (Bit 8)                       */
#define GPIO_PADREGI_PAD33PULL_Msk        (0x100UL)                 /*!< GPIO PADREGI: PAD33PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGI_PAD32FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGI: PAD32FNCSEL (Bit 3)                     */
#define GPIO_PADREGI_PAD32FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGI: PAD32FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGI_PAD32STRNG_Pos       (2UL)                     /*!< GPIO PADREGI: PAD32STRNG (Bit 2)                      */
#define GPIO_PADREGI_PAD32STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGI: PAD32STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD32INPEN_Pos       (1UL)                     /*!< GPIO PADREGI: PAD32INPEN (Bit 1)                      */
#define GPIO_PADREGI_PAD32INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGI: PAD32INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD32PULL_Pos        (0UL)                     /*!< GPIO PADREGI: PAD32PULL (Bit 0)                       */
#define GPIO_PADREGI_PAD32PULL_Msk        (0x1UL)                   /*!< GPIO PADREGI: PAD32PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGJ  ======================================================== */
#define GPIO_PADREGJ_PAD39RSEL_Pos        (30UL)                    /*!< GPIO PADREGJ: PAD39RSEL (Bit 30)                      */
#define GPIO_PADREGJ_PAD39RSEL_Msk        (0xc0000000UL)            /*!< GPIO PADREGJ: PAD39RSEL (Bitfield-Mask: 0x03)         */
#define GPIO_PADREGJ_PAD39FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGJ: PAD39FNCSEL (Bit 27)                    */
#define GPIO_PADREGJ_PAD39FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGJ: PAD39FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGJ_PAD39STRNG_Pos       (26UL)                    /*!< GPIO PADREGJ: PAD39STRNG (Bit 26)                     */
#define GPIO_PADREGJ_PAD39STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGJ: PAD39STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD39INPEN_Pos       (25UL)                    /*!< GPIO PADREGJ: PAD39INPEN (Bit 25)                     */
#define GPIO_PADREGJ_PAD39INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGJ: PAD39INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD39PULL_Pos        (24UL)                    /*!< GPIO PADREGJ: PAD39PULL (Bit 24)                      */
#define GPIO_PADREGJ_PAD39PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGJ: PAD39PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGJ_PAD38FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGJ: PAD38FNCSEL (Bit 19)                    */
#define GPIO_PADREGJ_PAD38FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGJ: PAD38FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGJ_PAD38STRNG_Pos       (18UL)                    /*!< GPIO PADREGJ: PAD38STRNG (Bit 18)                     */
#define GPIO_PADREGJ_PAD38STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGJ: PAD38STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD38INPEN_Pos       (17UL)                    /*!< GPIO PADREGJ: PAD38INPEN (Bit 17)                     */
#define GPIO_PADREGJ_PAD38INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGJ: PAD38INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD38PULL_Pos        (16UL)                    /*!< GPIO PADREGJ: PAD38PULL (Bit 16)                      */
#define GPIO_PADREGJ_PAD38PULL_Msk        (0x10000UL)               /*!< GPIO PADREGJ: PAD38PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGJ_PAD37FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGJ: PAD37FNCSEL (Bit 11)                    */
#define GPIO_PADREGJ_PAD37FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGJ: PAD37FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGJ_PAD37STRNG_Pos       (10UL)                    /*!< GPIO PADREGJ: PAD37STRNG (Bit 10)                     */
#define GPIO_PADREGJ_PAD37STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGJ: PAD37STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD37INPEN_Pos       (9UL)                     /*!< GPIO PADREGJ: PAD37INPEN (Bit 9)                      */
#define GPIO_PADREGJ_PAD37INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGJ: PAD37INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD37PULL_Pos        (8UL)                     /*!< GPIO PADREGJ: PAD37PULL (Bit 8)                       */
#define GPIO_PADREGJ_PAD37PULL_Msk        (0x100UL)                 /*!< GPIO PADREGJ: PAD37PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGJ_PAD36FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGJ: PAD36FNCSEL (Bit 3)                     */
#define GPIO_PADREGJ_PAD36FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGJ: PAD36FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGJ_PAD36STRNG_Pos       (2UL)                     /*!< GPIO PADREGJ: PAD36STRNG (Bit 2)                      */
#define GPIO_PADREGJ_PAD36STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGJ: PAD36STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD36INPEN_Pos       (1UL)                     /*!< GPIO PADREGJ: PAD36INPEN (Bit 1)                      */
#define GPIO_PADREGJ_PAD36INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGJ: PAD36INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD36PULL_Pos        (0UL)                     /*!< GPIO PADREGJ: PAD36PULL (Bit 0)                       */
#define GPIO_PADREGJ_PAD36PULL_Msk        (0x1UL)                   /*!< GPIO PADREGJ: PAD36PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGK  ======================================================== */
#define GPIO_PADREGK_PAD43RSEL_Pos        (30UL)                    /*!< GPIO PADREGK: PAD43RSEL (Bit 30)                      */
#define GPIO_PADREGK_PAD43RSEL_Msk        (0xc0000000UL)            /*!< GPIO PADREGK: PAD43RSEL (Bitfield-Mask: 0x03)         */
#define GPIO_PADREGK_PAD43FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGK: PAD43FNCSEL (Bit 27)                    */
#define GPIO_PADREGK_PAD43FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGK: PAD43FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGK_PAD43STRNG_Pos       (26UL)                    /*!< GPIO PADREGK: PAD43STRNG (Bit 26)                     */
#define GPIO_PADREGK_PAD43STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGK: PAD43STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD43INPEN_Pos       (25UL)                    /*!< GPIO PADREGK: PAD43INPEN (Bit 25)                     */
#define GPIO_PADREGK_PAD43INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGK: PAD43INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD43PULL_Pos        (24UL)                    /*!< GPIO PADREGK: PAD43PULL (Bit 24)                      */
#define GPIO_PADREGK_PAD43PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGK: PAD43PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGK_PAD42RSEL_Pos        (22UL)                    /*!< GPIO PADREGK: PAD42RSEL (Bit 22)                      */
#define GPIO_PADREGK_PAD42RSEL_Msk        (0xc00000UL)              /*!< GPIO PADREGK: PAD42RSEL (Bitfield-Mask: 0x03)         */
#define GPIO_PADREGK_PAD42FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGK: PAD42FNCSEL (Bit 19)                    */
#define GPIO_PADREGK_PAD42FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGK: PAD42FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGK_PAD42STRNG_Pos       (18UL)                    /*!< GPIO PADREGK: PAD42STRNG (Bit 18)                     */
#define GPIO_PADREGK_PAD42STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGK: PAD42STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD42INPEN_Pos       (17UL)                    /*!< GPIO PADREGK: PAD42INPEN (Bit 17)                     */
#define GPIO_PADREGK_PAD42INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGK: PAD42INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD42PULL_Pos        (16UL)                    /*!< GPIO PADREGK: PAD42PULL (Bit 16)                      */
#define GPIO_PADREGK_PAD42PULL_Msk        (0x10000UL)               /*!< GPIO PADREGK: PAD42PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGK_PAD41PWRUP_Pos       (15UL)                    /*!< GPIO PADREGK: PAD41PWRUP (Bit 15)                     */
#define GPIO_PADREGK_PAD41PWRUP_Msk       (0x8000UL)                /*!< GPIO PADREGK: PAD41PWRUP (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD41FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGK: PAD41FNCSEL (Bit 11)                    */
#define GPIO_PADREGK_PAD41FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGK: PAD41FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGK_PAD41STRNG_Pos       (10UL)                    /*!< GPIO PADREGK: PAD41STRNG (Bit 10)                     */
#define GPIO_PADREGK_PAD41STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGK: PAD41STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD41INPEN_Pos       (9UL)                     /*!< GPIO PADREGK: PAD41INPEN (Bit 9)                      */
#define GPIO_PADREGK_PAD41INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGK: PAD41INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD41PULL_Pos        (8UL)                     /*!< GPIO PADREGK: PAD41PULL (Bit 8)                       */
#define GPIO_PADREGK_PAD41PULL_Msk        (0x100UL)                 /*!< GPIO PADREGK: PAD41PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGK_PAD40RSEL_Pos        (6UL)                     /*!< GPIO PADREGK: PAD40RSEL (Bit 6)                       */
#define GPIO_PADREGK_PAD40RSEL_Msk        (0xc0UL)                  /*!< GPIO PADREGK: PAD40RSEL (Bitfield-Mask: 0x03)         */
#define GPIO_PADREGK_PAD40FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGK: PAD40FNCSEL (Bit 3)                     */
#define GPIO_PADREGK_PAD40FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGK: PAD40FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGK_PAD40STRNG_Pos       (2UL)                     /*!< GPIO PADREGK: PAD40STRNG (Bit 2)                      */
#define GPIO_PADREGK_PAD40STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGK: PAD40STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD40INPEN_Pos       (1UL)                     /*!< GPIO PADREGK: PAD40INPEN (Bit 1)                      */
#define GPIO_PADREGK_PAD40INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGK: PAD40INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD40PULL_Pos        (0UL)                     /*!< GPIO PADREGK: PAD40PULL (Bit 0)                       */
#define GPIO_PADREGK_PAD40PULL_Msk        (0x1UL)                   /*!< GPIO PADREGK: PAD40PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGL  ======================================================== */
#define GPIO_PADREGL_PAD47FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGL: PAD47FNCSEL (Bit 27)                    */
#define GPIO_PADREGL_PAD47FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGL: PAD47FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGL_PAD47STRNG_Pos       (26UL)                    /*!< GPIO PADREGL: PAD47STRNG (Bit 26)                     */
#define GPIO_PADREGL_PAD47STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGL: PAD47STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD47INPEN_Pos       (25UL)                    /*!< GPIO PADREGL: PAD47INPEN (Bit 25)                     */
#define GPIO_PADREGL_PAD47INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGL: PAD47INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD47PULL_Pos        (24UL)                    /*!< GPIO PADREGL: PAD47PULL (Bit 24)                      */
#define GPIO_PADREGL_PAD47PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGL: PAD47PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGL_PAD46FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGL: PAD46FNCSEL (Bit 19)                    */
#define GPIO_PADREGL_PAD46FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGL: PAD46FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGL_PAD46STRNG_Pos       (18UL)                    /*!< GPIO PADREGL: PAD46STRNG (Bit 18)                     */
#define GPIO_PADREGL_PAD46STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGL: PAD46STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD46INPEN_Pos       (17UL)                    /*!< GPIO PADREGL: PAD46INPEN (Bit 17)                     */
#define GPIO_PADREGL_PAD46INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGL: PAD46INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD46PULL_Pos        (16UL)                    /*!< GPIO PADREGL: PAD46PULL (Bit 16)                      */
#define GPIO_PADREGL_PAD46PULL_Msk        (0x10000UL)               /*!< GPIO PADREGL: PAD46PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGL_PAD45FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGL: PAD45FNCSEL (Bit 11)                    */
#define GPIO_PADREGL_PAD45FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGL: PAD45FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGL_PAD45STRNG_Pos       (10UL)                    /*!< GPIO PADREGL: PAD45STRNG (Bit 10)                     */
#define GPIO_PADREGL_PAD45STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGL: PAD45STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD45INPEN_Pos       (9UL)                     /*!< GPIO PADREGL: PAD45INPEN (Bit 9)                      */
#define GPIO_PADREGL_PAD45INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGL: PAD45INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD45PULL_Pos        (8UL)                     /*!< GPIO PADREGL: PAD45PULL (Bit 8)                       */
#define GPIO_PADREGL_PAD45PULL_Msk        (0x100UL)                 /*!< GPIO PADREGL: PAD45PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGL_PAD44FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGL: PAD44FNCSEL (Bit 3)                     */
#define GPIO_PADREGL_PAD44FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGL: PAD44FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGL_PAD44STRNG_Pos       (2UL)                     /*!< GPIO PADREGL: PAD44STRNG (Bit 2)                      */
#define GPIO_PADREGL_PAD44STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGL: PAD44STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD44INPEN_Pos       (1UL)                     /*!< GPIO PADREGL: PAD44INPEN (Bit 1)                      */
#define GPIO_PADREGL_PAD44INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGL: PAD44INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD44PULL_Pos        (0UL)                     /*!< GPIO PADREGL: PAD44PULL (Bit 0)                       */
#define GPIO_PADREGL_PAD44PULL_Msk        (0x1UL)                   /*!< GPIO PADREGL: PAD44PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGM  ======================================================== */
#define GPIO_PADREGM_PAD49RSEL_Pos        (14UL)                    /*!< GPIO PADREGM: PAD49RSEL (Bit 14)                      */
#define GPIO_PADREGM_PAD49RSEL_Msk        (0xc000UL)                /*!< GPIO PADREGM: PAD49RSEL (Bitfield-Mask: 0x03)         */
#define GPIO_PADREGM_PAD49FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGM: PAD49FNCSEL (Bit 11)                    */
#define GPIO_PADREGM_PAD49FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGM: PAD49FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGM_PAD49STRNG_Pos       (10UL)                    /*!< GPIO PADREGM: PAD49STRNG (Bit 10)                     */
#define GPIO_PADREGM_PAD49STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGM: PAD49STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGM_PAD49INPEN_Pos       (9UL)                     /*!< GPIO PADREGM: PAD49INPEN (Bit 9)                      */
#define GPIO_PADREGM_PAD49INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGM: PAD49INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGM_PAD49PULL_Pos        (8UL)                     /*!< GPIO PADREGM: PAD49PULL (Bit 8)                       */
#define GPIO_PADREGM_PAD49PULL_Msk        (0x100UL)                 /*!< GPIO PADREGM: PAD49PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGM_PAD48RSEL_Pos        (6UL)                     /*!< GPIO PADREGM: PAD48RSEL (Bit 6)                       */
#define GPIO_PADREGM_PAD48RSEL_Msk        (0xc0UL)                  /*!< GPIO PADREGM: PAD48RSEL (Bitfield-Mask: 0x03)         */
#define GPIO_PADREGM_PAD48FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGM: PAD48FNCSEL (Bit 3)                     */
#define GPIO_PADREGM_PAD48FNCSEL_Msk      (0x38UL)                  /*!< GPIO PADREGM: PAD48FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGM_PAD48STRNG_Pos       (2UL)                     /*!< GPIO PADREGM: PAD48STRNG (Bit 2)                      */
#define GPIO_PADREGM_PAD48STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGM: PAD48STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGM_PAD48INPEN_Pos       (1UL)                     /*!< GPIO PADREGM: PAD48INPEN (Bit 1)                      */
#define GPIO_PADREGM_PAD48INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGM: PAD48INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGM_PAD48PULL_Pos        (0UL)                     /*!< GPIO PADREGM: PAD48PULL (Bit 0)                       */
#define GPIO_PADREGM_PAD48PULL_Msk        (0x1UL)                   /*!< GPIO PADREGM: PAD48PULL (Bitfield-Mask: 0x01)         */
/* =========================================================  CFGA  ========================================================== */
#define GPIO_CFGA_GPIO7INTD_Pos           (31UL)                    /*!< GPIO CFGA: GPIO7INTD (Bit 31)                         */
#define GPIO_CFGA_GPIO7INTD_Msk           (0x80000000UL)            /*!< GPIO CFGA: GPIO7INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGA_GPIO7OUTCFG_Pos         (29UL)                    /*!< GPIO CFGA: GPIO7OUTCFG (Bit 29)                       */
#define GPIO_CFGA_GPIO7OUTCFG_Msk         (0x60000000UL)            /*!< GPIO CFGA: GPIO7OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGA_GPIO7INCFG_Pos          (28UL)                    /*!< GPIO CFGA: GPIO7INCFG (Bit 28)                        */
#define GPIO_CFGA_GPIO7INCFG_Msk          (0x10000000UL)            /*!< GPIO CFGA: GPIO7INCFG (Bitfield-Mask: 0x01)           */
#define GPIO_CFGA_GPIO6INTD_Pos           (27UL)                    /*!< GPIO CFGA: GPIO6INTD (Bit 27)                         */
#define GPIO_CFGA_GPIO6INTD_Msk           (0x8000000UL)             /*!< GPIO CFGA: GPIO6INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGA_GPIO6OUTCFG_Pos         (25UL)                    /*!< GPIO CFGA: GPIO6OUTCFG (Bit 25)                       */
#define GPIO_CFGA_GPIO6OUTCFG_Msk         (0x6000000UL)             /*!< GPIO CFGA: GPIO6OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGA_GPIO6INCFG_Pos          (24UL)                    /*!< GPIO CFGA: GPIO6INCFG (Bit 24)                        */
#define GPIO_CFGA_GPIO6INCFG_Msk          (0x1000000UL)             /*!< GPIO CFGA: GPIO6INCFG (Bitfield-Mask: 0x01)           */
#define GPIO_CFGA_GPIO5INTD_Pos           (23UL)                    /*!< GPIO CFGA: GPIO5INTD (Bit 23)                         */
#define GPIO_CFGA_GPIO5INTD_Msk           (0x800000UL)              /*!< GPIO CFGA: GPIO5INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGA_GPIO5OUTCFG_Pos         (21UL)                    /*!< GPIO CFGA: GPIO5OUTCFG (Bit 21)                       */
#define GPIO_CFGA_GPIO5OUTCFG_Msk         (0x600000UL)              /*!< GPIO CFGA: GPIO5OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGA_GPIO5INCFG_Pos          (20UL)                    /*!< GPIO CFGA: GPIO5INCFG (Bit 20)                        */
#define GPIO_CFGA_GPIO5INCFG_Msk          (0x100000UL)              /*!< GPIO CFGA: GPIO5INCFG (Bitfield-Mask: 0x01)           */
#define GPIO_CFGA_GPIO4INTD_Pos           (19UL)                    /*!< GPIO CFGA: GPIO4INTD (Bit 19)                         */
#define GPIO_CFGA_GPIO4INTD_Msk           (0x80000UL)               /*!< GPIO CFGA: GPIO4INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGA_GPIO4OUTCFG_Pos         (17UL)                    /*!< GPIO CFGA: GPIO4OUTCFG (Bit 17)                       */
#define GPIO_CFGA_GPIO4OUTCFG_Msk         (0x60000UL)               /*!< GPIO CFGA: GPIO4OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGA_GPIO4INCFG_Pos          (16UL)                    /*!< GPIO CFGA: GPIO4INCFG (Bit 16)                        */
#define GPIO_CFGA_GPIO4INCFG_Msk          (0x10000UL)               /*!< GPIO CFGA: GPIO4INCFG (Bitfield-Mask: 0x01)           */
#define GPIO_CFGA_GPIO3INTD_Pos           (15UL)                    /*!< GPIO CFGA: GPIO3INTD (Bit 15)                         */
#define GPIO_CFGA_GPIO3INTD_Msk           (0x8000UL)                /*!< GPIO CFGA: GPIO3INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGA_GPIO3OUTCFG_Pos         (13UL)                    /*!< GPIO CFGA: GPIO3OUTCFG (Bit 13)                       */
#define GPIO_CFGA_GPIO3OUTCFG_Msk         (0x6000UL)                /*!< GPIO CFGA: GPIO3OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGA_GPIO3INCFG_Pos          (12UL)                    /*!< GPIO CFGA: GPIO3INCFG (Bit 12)                        */
#define GPIO_CFGA_GPIO3INCFG_Msk          (0x1000UL)                /*!< GPIO CFGA: GPIO3INCFG (Bitfield-Mask: 0x01)           */
#define GPIO_CFGA_GPIO2INTD_Pos           (11UL)                    /*!< GPIO CFGA: GPIO2INTD (Bit 11)                         */
#define GPIO_CFGA_GPIO2INTD_Msk           (0x800UL)                 /*!< GPIO CFGA: GPIO2INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGA_GPIO2OUTCFG_Pos         (9UL)                     /*!< GPIO CFGA: GPIO2OUTCFG (Bit 9)                        */
#define GPIO_CFGA_GPIO2OUTCFG_Msk         (0x600UL)                 /*!< GPIO CFGA: GPIO2OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGA_GPIO2INCFG_Pos          (8UL)                     /*!< GPIO CFGA: GPIO2INCFG (Bit 8)                         */
#define GPIO_CFGA_GPIO2INCFG_Msk          (0x100UL)                 /*!< GPIO CFGA: GPIO2INCFG (Bitfield-Mask: 0x01)           */
#define GPIO_CFGA_GPIO1INTD_Pos           (7UL)                     /*!< GPIO CFGA: GPIO1INTD (Bit 7)                          */
#define GPIO_CFGA_GPIO1INTD_Msk           (0x80UL)                  /*!< GPIO CFGA: GPIO1INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGA_GPIO1OUTCFG_Pos         (5UL)                     /*!< GPIO CFGA: GPIO1OUTCFG (Bit 5)                        */
#define GPIO_CFGA_GPIO1OUTCFG_Msk         (0x60UL)                  /*!< GPIO CFGA: GPIO1OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGA_GPIO1INCFG_Pos          (4UL)                     /*!< GPIO CFGA: GPIO1INCFG (Bit 4)                         */
#define GPIO_CFGA_GPIO1INCFG_Msk          (0x10UL)                  /*!< GPIO CFGA: GPIO1INCFG (Bitfield-Mask: 0x01)           */
#define GPIO_CFGA_GPIO0INTD_Pos           (3UL)                     /*!< GPIO CFGA: GPIO0INTD (Bit 3)                          */
#define GPIO_CFGA_GPIO0INTD_Msk           (0x8UL)                   /*!< GPIO CFGA: GPIO0INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGA_GPIO0OUTCFG_Pos         (1UL)                     /*!< GPIO CFGA: GPIO0OUTCFG (Bit 1)                        */
#define GPIO_CFGA_GPIO0OUTCFG_Msk         (0x6UL)                   /*!< GPIO CFGA: GPIO0OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGA_GPIO0INCFG_Pos          (0UL)                     /*!< GPIO CFGA: GPIO0INCFG (Bit 0)                         */
#define GPIO_CFGA_GPIO0INCFG_Msk          (0x1UL)                   /*!< GPIO CFGA: GPIO0INCFG (Bitfield-Mask: 0x01)           */
/* =========================================================  CFGB  ========================================================== */
#define GPIO_CFGB_GPIO15INTD_Pos          (31UL)                    /*!< GPIO CFGB: GPIO15INTD (Bit 31)                        */
#define GPIO_CFGB_GPIO15INTD_Msk          (0x80000000UL)            /*!< GPIO CFGB: GPIO15INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGB_GPIO15OUTCFG_Pos        (29UL)                    /*!< GPIO CFGB: GPIO15OUTCFG (Bit 29)                      */
#define GPIO_CFGB_GPIO15OUTCFG_Msk        (0x60000000UL)            /*!< GPIO CFGB: GPIO15OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGB_GPIO15INCFG_Pos         (28UL)                    /*!< GPIO CFGB: GPIO15INCFG (Bit 28)                       */
#define GPIO_CFGB_GPIO15INCFG_Msk         (0x10000000UL)            /*!< GPIO CFGB: GPIO15INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGB_GPIO14INTD_Pos          (27UL)                    /*!< GPIO CFGB: GPIO14INTD (Bit 27)                        */
#define GPIO_CFGB_GPIO14INTD_Msk          (0x8000000UL)             /*!< GPIO CFGB: GPIO14INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGB_GPIO14OUTCFG_Pos        (25UL)                    /*!< GPIO CFGB: GPIO14OUTCFG (Bit 25)                      */
#define GPIO_CFGB_GPIO14OUTCFG_Msk        (0x6000000UL)             /*!< GPIO CFGB: GPIO14OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGB_GPIO14INCFG_Pos         (24UL)                    /*!< GPIO CFGB: GPIO14INCFG (Bit 24)                       */
#define GPIO_CFGB_GPIO14INCFG_Msk         (0x1000000UL)             /*!< GPIO CFGB: GPIO14INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGB_GPIO13INTD_Pos          (23UL)                    /*!< GPIO CFGB: GPIO13INTD (Bit 23)                        */
#define GPIO_CFGB_GPIO13INTD_Msk          (0x800000UL)              /*!< GPIO CFGB: GPIO13INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGB_GPIO13OUTCFG_Pos        (21UL)                    /*!< GPIO CFGB: GPIO13OUTCFG (Bit 21)                      */
#define GPIO_CFGB_GPIO13OUTCFG_Msk        (0x600000UL)              /*!< GPIO CFGB: GPIO13OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGB_GPIO13INCFG_Pos         (20UL)                    /*!< GPIO CFGB: GPIO13INCFG (Bit 20)                       */
#define GPIO_CFGB_GPIO13INCFG_Msk         (0x100000UL)              /*!< GPIO CFGB: GPIO13INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGB_GPIO12INTD_Pos          (19UL)                    /*!< GPIO CFGB: GPIO12INTD (Bit 19)                        */
#define GPIO_CFGB_GPIO12INTD_Msk          (0x80000UL)               /*!< GPIO CFGB: GPIO12INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGB_GPIO12OUTCFG_Pos        (17UL)                    /*!< GPIO CFGB: GPIO12OUTCFG (Bit 17)                      */
#define GPIO_CFGB_GPIO12OUTCFG_Msk        (0x60000UL)               /*!< GPIO CFGB: GPIO12OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGB_GPIO12INCFG_Pos         (16UL)                    /*!< GPIO CFGB: GPIO12INCFG (Bit 16)                       */
#define GPIO_CFGB_GPIO12INCFG_Msk         (0x10000UL)               /*!< GPIO CFGB: GPIO12INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGB_GPIO11INTD_Pos          (15UL)                    /*!< GPIO CFGB: GPIO11INTD (Bit 15)                        */
#define GPIO_CFGB_GPIO11INTD_Msk          (0x8000UL)                /*!< GPIO CFGB: GPIO11INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGB_GPIO11OUTCFG_Pos        (13UL)                    /*!< GPIO CFGB: GPIO11OUTCFG (Bit 13)                      */
#define GPIO_CFGB_GPIO11OUTCFG_Msk        (0x6000UL)                /*!< GPIO CFGB: GPIO11OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGB_GPIO11INCFG_Pos         (12UL)                    /*!< GPIO CFGB: GPIO11INCFG (Bit 12)                       */
#define GPIO_CFGB_GPIO11INCFG_Msk         (0x1000UL)                /*!< GPIO CFGB: GPIO11INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGB_GPIO10INTD_Pos          (11UL)                    /*!< GPIO CFGB: GPIO10INTD (Bit 11)                        */
#define GPIO_CFGB_GPIO10INTD_Msk          (0x800UL)                 /*!< GPIO CFGB: GPIO10INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGB_GPIO10OUTCFG_Pos        (9UL)                     /*!< GPIO CFGB: GPIO10OUTCFG (Bit 9)                       */
#define GPIO_CFGB_GPIO10OUTCFG_Msk        (0x600UL)                 /*!< GPIO CFGB: GPIO10OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGB_GPIO10INCFG_Pos         (8UL)                     /*!< GPIO CFGB: GPIO10INCFG (Bit 8)                        */
#define GPIO_CFGB_GPIO10INCFG_Msk         (0x100UL)                 /*!< GPIO CFGB: GPIO10INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGB_GPIO9INTD_Pos           (7UL)                     /*!< GPIO CFGB: GPIO9INTD (Bit 7)                          */
#define GPIO_CFGB_GPIO9INTD_Msk           (0x80UL)                  /*!< GPIO CFGB: GPIO9INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGB_GPIO9OUTCFG_Pos         (5UL)                     /*!< GPIO CFGB: GPIO9OUTCFG (Bit 5)                        */
#define GPIO_CFGB_GPIO9OUTCFG_Msk         (0x60UL)                  /*!< GPIO CFGB: GPIO9OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGB_GPIO9INCFG_Pos          (4UL)                     /*!< GPIO CFGB: GPIO9INCFG (Bit 4)                         */
#define GPIO_CFGB_GPIO9INCFG_Msk          (0x10UL)                  /*!< GPIO CFGB: GPIO9INCFG (Bitfield-Mask: 0x01)           */
#define GPIO_CFGB_GPIO8INTD_Pos           (3UL)                     /*!< GPIO CFGB: GPIO8INTD (Bit 3)                          */
#define GPIO_CFGB_GPIO8INTD_Msk           (0x8UL)                   /*!< GPIO CFGB: GPIO8INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGB_GPIO8OUTCFG_Pos         (1UL)                     /*!< GPIO CFGB: GPIO8OUTCFG (Bit 1)                        */
#define GPIO_CFGB_GPIO8OUTCFG_Msk         (0x6UL)                   /*!< GPIO CFGB: GPIO8OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGB_GPIO8INCFG_Pos          (0UL)                     /*!< GPIO CFGB: GPIO8INCFG (Bit 0)                         */
#define GPIO_CFGB_GPIO8INCFG_Msk          (0x1UL)                   /*!< GPIO CFGB: GPIO8INCFG (Bitfield-Mask: 0x01)           */
/* =========================================================  CFGC  ========================================================== */
#define GPIO_CFGC_GPIO23INTD_Pos          (31UL)                    /*!< GPIO CFGC: GPIO23INTD (Bit 31)                        */
#define GPIO_CFGC_GPIO23INTD_Msk          (0x80000000UL)            /*!< GPIO CFGC: GPIO23INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGC_GPIO23OUTCFG_Pos        (29UL)                    /*!< GPIO CFGC: GPIO23OUTCFG (Bit 29)                      */
#define GPIO_CFGC_GPIO23OUTCFG_Msk        (0x60000000UL)            /*!< GPIO CFGC: GPIO23OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGC_GPIO23INCFG_Pos         (28UL)                    /*!< GPIO CFGC: GPIO23INCFG (Bit 28)                       */
#define GPIO_CFGC_GPIO23INCFG_Msk         (0x10000000UL)            /*!< GPIO CFGC: GPIO23INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGC_GPIO22INTD_Pos          (27UL)                    /*!< GPIO CFGC: GPIO22INTD (Bit 27)                        */
#define GPIO_CFGC_GPIO22INTD_Msk          (0x8000000UL)             /*!< GPIO CFGC: GPIO22INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGC_GPIO22OUTCFG_Pos        (25UL)                    /*!< GPIO CFGC: GPIO22OUTCFG (Bit 25)                      */
#define GPIO_CFGC_GPIO22OUTCFG_Msk        (0x6000000UL)             /*!< GPIO CFGC: GPIO22OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGC_GPIO22INCFG_Pos         (24UL)                    /*!< GPIO CFGC: GPIO22INCFG (Bit 24)                       */
#define GPIO_CFGC_GPIO22INCFG_Msk         (0x1000000UL)             /*!< GPIO CFGC: GPIO22INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGC_GPIO21INTD_Pos          (23UL)                    /*!< GPIO CFGC: GPIO21INTD (Bit 23)                        */
#define GPIO_CFGC_GPIO21INTD_Msk          (0x800000UL)              /*!< GPIO CFGC: GPIO21INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGC_GPIO21OUTCFG_Pos        (21UL)                    /*!< GPIO CFGC: GPIO21OUTCFG (Bit 21)                      */
#define GPIO_CFGC_GPIO21OUTCFG_Msk        (0x600000UL)              /*!< GPIO CFGC: GPIO21OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGC_GPIO21INCFG_Pos         (20UL)                    /*!< GPIO CFGC: GPIO21INCFG (Bit 20)                       */
#define GPIO_CFGC_GPIO21INCFG_Msk         (0x100000UL)              /*!< GPIO CFGC: GPIO21INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGC_GPIO20INTD_Pos          (19UL)                    /*!< GPIO CFGC: GPIO20INTD (Bit 19)                        */
#define GPIO_CFGC_GPIO20INTD_Msk          (0x80000UL)               /*!< GPIO CFGC: GPIO20INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGC_GPIO20OUTCFG_Pos        (17UL)                    /*!< GPIO CFGC: GPIO20OUTCFG (Bit 17)                      */
#define GPIO_CFGC_GPIO20OUTCFG_Msk        (0x60000UL)               /*!< GPIO CFGC: GPIO20OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGC_GPIO20INCFG_Pos         (16UL)                    /*!< GPIO CFGC: GPIO20INCFG (Bit 16)                       */
#define GPIO_CFGC_GPIO20INCFG_Msk         (0x10000UL)               /*!< GPIO CFGC: GPIO20INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGC_GPIO19INTD_Pos          (15UL)                    /*!< GPIO CFGC: GPIO19INTD (Bit 15)                        */
#define GPIO_CFGC_GPIO19INTD_Msk          (0x8000UL)                /*!< GPIO CFGC: GPIO19INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGC_GPIO19OUTCFG_Pos        (13UL)                    /*!< GPIO CFGC: GPIO19OUTCFG (Bit 13)                      */
#define GPIO_CFGC_GPIO19OUTCFG_Msk        (0x6000UL)                /*!< GPIO CFGC: GPIO19OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGC_GPIO19INCFG_Pos         (12UL)                    /*!< GPIO CFGC: GPIO19INCFG (Bit 12)                       */
#define GPIO_CFGC_GPIO19INCFG_Msk         (0x1000UL)                /*!< GPIO CFGC: GPIO19INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGC_GPIO18INTD_Pos          (11UL)                    /*!< GPIO CFGC: GPIO18INTD (Bit 11)                        */
#define GPIO_CFGC_GPIO18INTD_Msk          (0x800UL)                 /*!< GPIO CFGC: GPIO18INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGC_GPIO18OUTCFG_Pos        (9UL)                     /*!< GPIO CFGC: GPIO18OUTCFG (Bit 9)                       */
#define GPIO_CFGC_GPIO18OUTCFG_Msk        (0x600UL)                 /*!< GPIO CFGC: GPIO18OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGC_GPIO18INCFG_Pos         (8UL)                     /*!< GPIO CFGC: GPIO18INCFG (Bit 8)                        */
#define GPIO_CFGC_GPIO18INCFG_Msk         (0x100UL)                 /*!< GPIO CFGC: GPIO18INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGC_GPIO17INTD_Pos          (7UL)                     /*!< GPIO CFGC: GPIO17INTD (Bit 7)                         */
#define GPIO_CFGC_GPIO17INTD_Msk          (0x80UL)                  /*!< GPIO CFGC: GPIO17INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGC_GPIO17OUTCFG_Pos        (5UL)                     /*!< GPIO CFGC: GPIO17OUTCFG (Bit 5)                       */
#define GPIO_CFGC_GPIO17OUTCFG_Msk        (0x60UL)                  /*!< GPIO CFGC: GPIO17OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGC_GPIO17INCFG_Pos         (4UL)                     /*!< GPIO CFGC: GPIO17INCFG (Bit 4)                        */
#define GPIO_CFGC_GPIO17INCFG_Msk         (0x10UL)                  /*!< GPIO CFGC: GPIO17INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGC_GPIO16INTD_Pos          (3UL)                     /*!< GPIO CFGC: GPIO16INTD (Bit 3)                         */
#define GPIO_CFGC_GPIO16INTD_Msk          (0x8UL)                   /*!< GPIO CFGC: GPIO16INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGC_GPIO16OUTCFG_Pos        (1UL)                     /*!< GPIO CFGC: GPIO16OUTCFG (Bit 1)                       */
#define GPIO_CFGC_GPIO16OUTCFG_Msk        (0x6UL)                   /*!< GPIO CFGC: GPIO16OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGC_GPIO16INCFG_Pos         (0UL)                     /*!< GPIO CFGC: GPIO16INCFG (Bit 0)                        */
#define GPIO_CFGC_GPIO16INCFG_Msk         (0x1UL)                   /*!< GPIO CFGC: GPIO16INCFG (Bitfield-Mask: 0x01)          */
/* =========================================================  CFGD  ========================================================== */
#define GPIO_CFGD_GPIO31INTD_Pos          (31UL)                    /*!< GPIO CFGD: GPIO31INTD (Bit 31)                        */
#define GPIO_CFGD_GPIO31INTD_Msk          (0x80000000UL)            /*!< GPIO CFGD: GPIO31INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGD_GPIO31OUTCFG_Pos        (29UL)                    /*!< GPIO CFGD: GPIO31OUTCFG (Bit 29)                      */
#define GPIO_CFGD_GPIO31OUTCFG_Msk        (0x60000000UL)            /*!< GPIO CFGD: GPIO31OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGD_GPIO31INCFG_Pos         (28UL)                    /*!< GPIO CFGD: GPIO31INCFG (Bit 28)                       */
#define GPIO_CFGD_GPIO31INCFG_Msk         (0x10000000UL)            /*!< GPIO CFGD: GPIO31INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGD_GPIO30INTD_Pos          (27UL)                    /*!< GPIO CFGD: GPIO30INTD (Bit 27)                        */
#define GPIO_CFGD_GPIO30INTD_Msk          (0x8000000UL)             /*!< GPIO CFGD: GPIO30INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGD_GPIO30OUTCFG_Pos        (25UL)                    /*!< GPIO CFGD: GPIO30OUTCFG (Bit 25)                      */
#define GPIO_CFGD_GPIO30OUTCFG_Msk        (0x6000000UL)             /*!< GPIO CFGD: GPIO30OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGD_GPIO30INCFG_Pos         (24UL)                    /*!< GPIO CFGD: GPIO30INCFG (Bit 24)                       */
#define GPIO_CFGD_GPIO30INCFG_Msk         (0x1000000UL)             /*!< GPIO CFGD: GPIO30INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGD_GPIO29INTD_Pos          (23UL)                    /*!< GPIO CFGD: GPIO29INTD (Bit 23)                        */
#define GPIO_CFGD_GPIO29INTD_Msk          (0x800000UL)              /*!< GPIO CFGD: GPIO29INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGD_GPIO29OUTCFG_Pos        (21UL)                    /*!< GPIO CFGD: GPIO29OUTCFG (Bit 21)                      */
#define GPIO_CFGD_GPIO29OUTCFG_Msk        (0x600000UL)              /*!< GPIO CFGD: GPIO29OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGD_GPIO29INCFG_Pos         (20UL)                    /*!< GPIO CFGD: GPIO29INCFG (Bit 20)                       */
#define GPIO_CFGD_GPIO29INCFG_Msk         (0x100000UL)              /*!< GPIO CFGD: GPIO29INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGD_GPIO28INTD_Pos          (19UL)                    /*!< GPIO CFGD: GPIO28INTD (Bit 19)                        */
#define GPIO_CFGD_GPIO28INTD_Msk          (0x80000UL)               /*!< GPIO CFGD: GPIO28INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGD_GPIO28OUTCFG_Pos        (17UL)                    /*!< GPIO CFGD: GPIO28OUTCFG (Bit 17)                      */
#define GPIO_CFGD_GPIO28OUTCFG_Msk        (0x60000UL)               /*!< GPIO CFGD: GPIO28OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGD_GPIO28INCFG_Pos         (16UL)                    /*!< GPIO CFGD: GPIO28INCFG (Bit 16)                       */
#define GPIO_CFGD_GPIO28INCFG_Msk         (0x10000UL)               /*!< GPIO CFGD: GPIO28INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGD_GPIO27INTD_Pos          (15UL)                    /*!< GPIO CFGD: GPIO27INTD (Bit 15)                        */
#define GPIO_CFGD_GPIO27INTD_Msk          (0x8000UL)                /*!< GPIO CFGD: GPIO27INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGD_GPIO27OUTCFG_Pos        (13UL)                    /*!< GPIO CFGD: GPIO27OUTCFG (Bit 13)                      */
#define GPIO_CFGD_GPIO27OUTCFG_Msk        (0x6000UL)                /*!< GPIO CFGD: GPIO27OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGD_GPIO27INCFG_Pos         (12UL)                    /*!< GPIO CFGD: GPIO27INCFG (Bit 12)                       */
#define GPIO_CFGD_GPIO27INCFG_Msk         (0x1000UL)                /*!< GPIO CFGD: GPIO27INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGD_GPIO26INTD_Pos          (11UL)                    /*!< GPIO CFGD: GPIO26INTD (Bit 11)                        */
#define GPIO_CFGD_GPIO26INTD_Msk          (0x800UL)                 /*!< GPIO CFGD: GPIO26INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGD_GPIO26OUTCFG_Pos        (9UL)                     /*!< GPIO CFGD: GPIO26OUTCFG (Bit 9)                       */
#define GPIO_CFGD_GPIO26OUTCFG_Msk        (0x600UL)                 /*!< GPIO CFGD: GPIO26OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGD_GPIO26INCFG_Pos         (8UL)                     /*!< GPIO CFGD: GPIO26INCFG (Bit 8)                        */
#define GPIO_CFGD_GPIO26INCFG_Msk         (0x100UL)                 /*!< GPIO CFGD: GPIO26INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGD_GPIO25INTD_Pos          (7UL)                     /*!< GPIO CFGD: GPIO25INTD (Bit 7)                         */
#define GPIO_CFGD_GPIO25INTD_Msk          (0x80UL)                  /*!< GPIO CFGD: GPIO25INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGD_GPIO25OUTCFG_Pos        (5UL)                     /*!< GPIO CFGD: GPIO25OUTCFG (Bit 5)                       */
#define GPIO_CFGD_GPIO25OUTCFG_Msk        (0x60UL)                  /*!< GPIO CFGD: GPIO25OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGD_GPIO25INCFG_Pos         (4UL)                     /*!< GPIO CFGD: GPIO25INCFG (Bit 4)                        */
#define GPIO_CFGD_GPIO25INCFG_Msk         (0x10UL)                  /*!< GPIO CFGD: GPIO25INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGD_GPIO24INTD_Pos          (3UL)                     /*!< GPIO CFGD: GPIO24INTD (Bit 3)                         */
#define GPIO_CFGD_GPIO24INTD_Msk          (0x8UL)                   /*!< GPIO CFGD: GPIO24INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGD_GPIO24OUTCFG_Pos        (1UL)                     /*!< GPIO CFGD: GPIO24OUTCFG (Bit 1)                       */
#define GPIO_CFGD_GPIO24OUTCFG_Msk        (0x6UL)                   /*!< GPIO CFGD: GPIO24OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGD_GPIO24INCFG_Pos         (0UL)                     /*!< GPIO CFGD: GPIO24INCFG (Bit 0)                        */
#define GPIO_CFGD_GPIO24INCFG_Msk         (0x1UL)                   /*!< GPIO CFGD: GPIO24INCFG (Bitfield-Mask: 0x01)          */
/* =========================================================  CFGE  ========================================================== */
#define GPIO_CFGE_GPIO39INTD_Pos          (31UL)                    /*!< GPIO CFGE: GPIO39INTD (Bit 31)                        */
#define GPIO_CFGE_GPIO39INTD_Msk          (0x80000000UL)            /*!< GPIO CFGE: GPIO39INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGE_GPIO39OUTCFG_Pos        (29UL)                    /*!< GPIO CFGE: GPIO39OUTCFG (Bit 29)                      */
#define GPIO_CFGE_GPIO39OUTCFG_Msk        (0x60000000UL)            /*!< GPIO CFGE: GPIO39OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGE_GPIO39INCFG_Pos         (28UL)                    /*!< GPIO CFGE: GPIO39INCFG (Bit 28)                       */
#define GPIO_CFGE_GPIO39INCFG_Msk         (0x10000000UL)            /*!< GPIO CFGE: GPIO39INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGE_GPIO38INTD_Pos          (27UL)                    /*!< GPIO CFGE: GPIO38INTD (Bit 27)                        */
#define GPIO_CFGE_GPIO38INTD_Msk          (0x8000000UL)             /*!< GPIO CFGE: GPIO38INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGE_GPIO38OUTCFG_Pos        (25UL)                    /*!< GPIO CFGE: GPIO38OUTCFG (Bit 25)                      */
#define GPIO_CFGE_GPIO38OUTCFG_Msk        (0x6000000UL)             /*!< GPIO CFGE: GPIO38OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGE_GPIO38INCFG_Pos         (24UL)                    /*!< GPIO CFGE: GPIO38INCFG (Bit 24)                       */
#define GPIO_CFGE_GPIO38INCFG_Msk         (0x1000000UL)             /*!< GPIO CFGE: GPIO38INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGE_GPIO37INTD_Pos          (23UL)                    /*!< GPIO CFGE: GPIO37INTD (Bit 23)                        */
#define GPIO_CFGE_GPIO37INTD_Msk          (0x800000UL)              /*!< GPIO CFGE: GPIO37INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGE_GPIO37OUTCFG_Pos        (21UL)                    /*!< GPIO CFGE: GPIO37OUTCFG (Bit 21)                      */
#define GPIO_CFGE_GPIO37OUTCFG_Msk        (0x600000UL)              /*!< GPIO CFGE: GPIO37OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGE_GPIO37INCFG_Pos         (20UL)                    /*!< GPIO CFGE: GPIO37INCFG (Bit 20)                       */
#define GPIO_CFGE_GPIO37INCFG_Msk         (0x100000UL)              /*!< GPIO CFGE: GPIO37INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGE_GPIO36INTD_Pos          (19UL)                    /*!< GPIO CFGE: GPIO36INTD (Bit 19)                        */
#define GPIO_CFGE_GPIO36INTD_Msk          (0x80000UL)               /*!< GPIO CFGE: GPIO36INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGE_GPIO36OUTCFG_Pos        (17UL)                    /*!< GPIO CFGE: GPIO36OUTCFG (Bit 17)                      */
#define GPIO_CFGE_GPIO36OUTCFG_Msk        (0x60000UL)               /*!< GPIO CFGE: GPIO36OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGE_GPIO36INCFG_Pos         (16UL)                    /*!< GPIO CFGE: GPIO36INCFG (Bit 16)                       */
#define GPIO_CFGE_GPIO36INCFG_Msk         (0x10000UL)               /*!< GPIO CFGE: GPIO36INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGE_GPIO35INTD_Pos          (15UL)                    /*!< GPIO CFGE: GPIO35INTD (Bit 15)                        */
#define GPIO_CFGE_GPIO35INTD_Msk          (0x8000UL)                /*!< GPIO CFGE: GPIO35INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGE_GPIO35OUTCFG_Pos        (13UL)                    /*!< GPIO CFGE: GPIO35OUTCFG (Bit 13)                      */
#define GPIO_CFGE_GPIO35OUTCFG_Msk        (0x6000UL)                /*!< GPIO CFGE: GPIO35OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGE_GPIO35INCFG_Pos         (12UL)                    /*!< GPIO CFGE: GPIO35INCFG (Bit 12)                       */
#define GPIO_CFGE_GPIO35INCFG_Msk         (0x1000UL)                /*!< GPIO CFGE: GPIO35INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGE_GPIO34INTD_Pos          (11UL)                    /*!< GPIO CFGE: GPIO34INTD (Bit 11)                        */
#define GPIO_CFGE_GPIO34INTD_Msk          (0x800UL)                 /*!< GPIO CFGE: GPIO34INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGE_GPIO34OUTCFG_Pos        (9UL)                     /*!< GPIO CFGE: GPIO34OUTCFG (Bit 9)                       */
#define GPIO_CFGE_GPIO34OUTCFG_Msk        (0x600UL)                 /*!< GPIO CFGE: GPIO34OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGE_GPIO34INCFG_Pos         (8UL)                     /*!< GPIO CFGE: GPIO34INCFG (Bit 8)                        */
#define GPIO_CFGE_GPIO34INCFG_Msk         (0x100UL)                 /*!< GPIO CFGE: GPIO34INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGE_GPIO33INTD_Pos          (7UL)                     /*!< GPIO CFGE: GPIO33INTD (Bit 7)                         */
#define GPIO_CFGE_GPIO33INTD_Msk          (0x80UL)                  /*!< GPIO CFGE: GPIO33INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGE_GPIO33OUTCFG_Pos        (5UL)                     /*!< GPIO CFGE: GPIO33OUTCFG (Bit 5)                       */
#define GPIO_CFGE_GPIO33OUTCFG_Msk        (0x60UL)                  /*!< GPIO CFGE: GPIO33OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGE_GPIO33INCFG_Pos         (4UL)                     /*!< GPIO CFGE: GPIO33INCFG (Bit 4)                        */
#define GPIO_CFGE_GPIO33INCFG_Msk         (0x10UL)                  /*!< GPIO CFGE: GPIO33INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGE_GPIO32INTD_Pos          (3UL)                     /*!< GPIO CFGE: GPIO32INTD (Bit 3)                         */
#define GPIO_CFGE_GPIO32INTD_Msk          (0x8UL)                   /*!< GPIO CFGE: GPIO32INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGE_GPIO32OUTCFG_Pos        (1UL)                     /*!< GPIO CFGE: GPIO32OUTCFG (Bit 1)                       */
#define GPIO_CFGE_GPIO32OUTCFG_Msk        (0x6UL)                   /*!< GPIO CFGE: GPIO32OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGE_GPIO32INCFG_Pos         (0UL)                     /*!< GPIO CFGE: GPIO32INCFG (Bit 0)                        */
#define GPIO_CFGE_GPIO32INCFG_Msk         (0x1UL)                   /*!< GPIO CFGE: GPIO32INCFG (Bitfield-Mask: 0x01)          */
/* =========================================================  CFGF  ========================================================== */
#define GPIO_CFGF_GPIO47INTD_Pos          (31UL)                    /*!< GPIO CFGF: GPIO47INTD (Bit 31)                        */
#define GPIO_CFGF_GPIO47INTD_Msk          (0x80000000UL)            /*!< GPIO CFGF: GPIO47INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGF_GPIO47OUTCFG_Pos        (29UL)                    /*!< GPIO CFGF: GPIO47OUTCFG (Bit 29)                      */
#define GPIO_CFGF_GPIO47OUTCFG_Msk        (0x60000000UL)            /*!< GPIO CFGF: GPIO47OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGF_GPIO47INCFG_Pos         (28UL)                    /*!< GPIO CFGF: GPIO47INCFG (Bit 28)                       */
#define GPIO_CFGF_GPIO47INCFG_Msk         (0x10000000UL)            /*!< GPIO CFGF: GPIO47INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGF_GPIO46INTD_Pos          (27UL)                    /*!< GPIO CFGF: GPIO46INTD (Bit 27)                        */
#define GPIO_CFGF_GPIO46INTD_Msk          (0x8000000UL)             /*!< GPIO CFGF: GPIO46INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGF_GPIO46OUTCFG_Pos        (25UL)                    /*!< GPIO CFGF: GPIO46OUTCFG (Bit 25)                      */
#define GPIO_CFGF_GPIO46OUTCFG_Msk        (0x6000000UL)             /*!< GPIO CFGF: GPIO46OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGF_GPIO46INCFG_Pos         (24UL)                    /*!< GPIO CFGF: GPIO46INCFG (Bit 24)                       */
#define GPIO_CFGF_GPIO46INCFG_Msk         (0x1000000UL)             /*!< GPIO CFGF: GPIO46INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGF_GPIO45INTD_Pos          (23UL)                    /*!< GPIO CFGF: GPIO45INTD (Bit 23)                        */
#define GPIO_CFGF_GPIO45INTD_Msk          (0x800000UL)              /*!< GPIO CFGF: GPIO45INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGF_GPIO45OUTCFG_Pos        (21UL)                    /*!< GPIO CFGF: GPIO45OUTCFG (Bit 21)                      */
#define GPIO_CFGF_GPIO45OUTCFG_Msk        (0x600000UL)              /*!< GPIO CFGF: GPIO45OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGF_GPIO45INCFG_Pos         (20UL)                    /*!< GPIO CFGF: GPIO45INCFG (Bit 20)                       */
#define GPIO_CFGF_GPIO45INCFG_Msk         (0x100000UL)              /*!< GPIO CFGF: GPIO45INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGF_GPIO44INTD_Pos          (19UL)                    /*!< GPIO CFGF: GPIO44INTD (Bit 19)                        */
#define GPIO_CFGF_GPIO44INTD_Msk          (0x80000UL)               /*!< GPIO CFGF: GPIO44INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGF_GPIO44OUTCFG_Pos        (17UL)                    /*!< GPIO CFGF: GPIO44OUTCFG (Bit 17)                      */
#define GPIO_CFGF_GPIO44OUTCFG_Msk        (0x60000UL)               /*!< GPIO CFGF: GPIO44OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGF_GPIO44INCFG_Pos         (16UL)                    /*!< GPIO CFGF: GPIO44INCFG (Bit 16)                       */
#define GPIO_CFGF_GPIO44INCFG_Msk         (0x10000UL)               /*!< GPIO CFGF: GPIO44INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGF_GPIO43INTD_Pos          (15UL)                    /*!< GPIO CFGF: GPIO43INTD (Bit 15)                        */
#define GPIO_CFGF_GPIO43INTD_Msk          (0x8000UL)                /*!< GPIO CFGF: GPIO43INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGF_GPIO43OUTCFG_Pos        (13UL)                    /*!< GPIO CFGF: GPIO43OUTCFG (Bit 13)                      */
#define GPIO_CFGF_GPIO43OUTCFG_Msk        (0x6000UL)                /*!< GPIO CFGF: GPIO43OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGF_GPIO43INCFG_Pos         (12UL)                    /*!< GPIO CFGF: GPIO43INCFG (Bit 12)                       */
#define GPIO_CFGF_GPIO43INCFG_Msk         (0x1000UL)                /*!< GPIO CFGF: GPIO43INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGF_GPIO42INTD_Pos          (11UL)                    /*!< GPIO CFGF: GPIO42INTD (Bit 11)                        */
#define GPIO_CFGF_GPIO42INTD_Msk          (0x800UL)                 /*!< GPIO CFGF: GPIO42INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGF_GPIO42OUTCFG_Pos        (9UL)                     /*!< GPIO CFGF: GPIO42OUTCFG (Bit 9)                       */
#define GPIO_CFGF_GPIO42OUTCFG_Msk        (0x600UL)                 /*!< GPIO CFGF: GPIO42OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGF_GPIO42INCFG_Pos         (8UL)                     /*!< GPIO CFGF: GPIO42INCFG (Bit 8)                        */
#define GPIO_CFGF_GPIO42INCFG_Msk         (0x100UL)                 /*!< GPIO CFGF: GPIO42INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGF_GPIO41INTD_Pos          (7UL)                     /*!< GPIO CFGF: GPIO41INTD (Bit 7)                         */
#define GPIO_CFGF_GPIO41INTD_Msk          (0x80UL)                  /*!< GPIO CFGF: GPIO41INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGF_GPIO41OUTCFG_Pos        (5UL)                     /*!< GPIO CFGF: GPIO41OUTCFG (Bit 5)                       */
#define GPIO_CFGF_GPIO41OUTCFG_Msk        (0x60UL)                  /*!< GPIO CFGF: GPIO41OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGF_GPIO41INCFG_Pos         (4UL)                     /*!< GPIO CFGF: GPIO41INCFG (Bit 4)                        */
#define GPIO_CFGF_GPIO41INCFG_Msk         (0x10UL)                  /*!< GPIO CFGF: GPIO41INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGF_GPIO40INTD_Pos          (3UL)                     /*!< GPIO CFGF: GPIO40INTD (Bit 3)                         */
#define GPIO_CFGF_GPIO40INTD_Msk          (0x8UL)                   /*!< GPIO CFGF: GPIO40INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGF_GPIO40OUTCFG_Pos        (1UL)                     /*!< GPIO CFGF: GPIO40OUTCFG (Bit 1)                       */
#define GPIO_CFGF_GPIO40OUTCFG_Msk        (0x6UL)                   /*!< GPIO CFGF: GPIO40OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGF_GPIO40INCFG_Pos         (0UL)                     /*!< GPIO CFGF: GPIO40INCFG (Bit 0)                        */
#define GPIO_CFGF_GPIO40INCFG_Msk         (0x1UL)                   /*!< GPIO CFGF: GPIO40INCFG (Bitfield-Mask: 0x01)          */
/* =========================================================  CFGG  ========================================================== */
#define GPIO_CFGG_GPIO49INTD_Pos          (7UL)                     /*!< GPIO CFGG: GPIO49INTD (Bit 7)                         */
#define GPIO_CFGG_GPIO49INTD_Msk          (0x80UL)                  /*!< GPIO CFGG: GPIO49INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGG_GPIO49OUTCFG_Pos        (5UL)                     /*!< GPIO CFGG: GPIO49OUTCFG (Bit 5)                       */
#define GPIO_CFGG_GPIO49OUTCFG_Msk        (0x60UL)                  /*!< GPIO CFGG: GPIO49OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGG_GPIO49INCFG_Pos         (4UL)                     /*!< GPIO CFGG: GPIO49INCFG (Bit 4)                        */
#define GPIO_CFGG_GPIO49INCFG_Msk         (0x10UL)                  /*!< GPIO CFGG: GPIO49INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGG_GPIO48INTD_Pos          (3UL)                     /*!< GPIO CFGG: GPIO48INTD (Bit 3)                         */
#define GPIO_CFGG_GPIO48INTD_Msk          (0x8UL)                   /*!< GPIO CFGG: GPIO48INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGG_GPIO48OUTCFG_Pos        (1UL)                     /*!< GPIO CFGG: GPIO48OUTCFG (Bit 1)                       */
#define GPIO_CFGG_GPIO48OUTCFG_Msk        (0x6UL)                   /*!< GPIO CFGG: GPIO48OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGG_GPIO48INCFG_Pos         (0UL)                     /*!< GPIO CFGG: GPIO48INCFG (Bit 0)                        */
#define GPIO_CFGG_GPIO48INCFG_Msk         (0x1UL)                   /*!< GPIO CFGG: GPIO48INCFG (Bitfield-Mask: 0x01)          */
/* ========================================================  PADKEY  ========================================================= */
#define GPIO_PADKEY_PADKEY_Pos            (0UL)                     /*!< GPIO PADKEY: PADKEY (Bit 0)                           */
#define GPIO_PADKEY_PADKEY_Msk            (0xffffffffUL)            /*!< GPIO PADKEY: PADKEY (Bitfield-Mask: 0xffffffff)       */
/* ==========================================================  RDA  ========================================================== */
#define GPIO_RDA_RDA_Pos                  (0UL)                     /*!< GPIO RDA: RDA (Bit 0)                                 */
#define GPIO_RDA_RDA_Msk                  (0xffffffffUL)            /*!< GPIO RDA: RDA (Bitfield-Mask: 0xffffffff)             */
/* ==========================================================  RDB  ========================================================== */
#define GPIO_RDB_RDB_Pos                  (0UL)                     /*!< GPIO RDB: RDB (Bit 0)                                 */
#define GPIO_RDB_RDB_Msk                  (0x3ffffUL)               /*!< GPIO RDB: RDB (Bitfield-Mask: 0x3ffff)                */
/* ==========================================================  WTA  ========================================================== */
#define GPIO_WTA_WTA_Pos                  (0UL)                     /*!< GPIO WTA: WTA (Bit 0)                                 */
#define GPIO_WTA_WTA_Msk                  (0xffffffffUL)            /*!< GPIO WTA: WTA (Bitfield-Mask: 0xffffffff)             */
/* ==========================================================  WTB  ========================================================== */
#define GPIO_WTB_WTB_Pos                  (0UL)                     /*!< GPIO WTB: WTB (Bit 0)                                 */
#define GPIO_WTB_WTB_Msk                  (0x3ffffUL)               /*!< GPIO WTB: WTB (Bitfield-Mask: 0x3ffff)                */
/* =========================================================  WTSA  ========================================================== */
#define GPIO_WTSA_WTSA_Pos                (0UL)                     /*!< GPIO WTSA: WTSA (Bit 0)                               */
#define GPIO_WTSA_WTSA_Msk                (0xffffffffUL)            /*!< GPIO WTSA: WTSA (Bitfield-Mask: 0xffffffff)           */
/* =========================================================  WTSB  ========================================================== */
#define GPIO_WTSB_WTSB_Pos                (0UL)                     /*!< GPIO WTSB: WTSB (Bit 0)                               */
#define GPIO_WTSB_WTSB_Msk                (0x3ffffUL)               /*!< GPIO WTSB: WTSB (Bitfield-Mask: 0x3ffff)              */
/* =========================================================  WTCA  ========================================================== */
#define GPIO_WTCA_WTCA_Pos                (0UL)                     /*!< GPIO WTCA: WTCA (Bit 0)                               */
#define GPIO_WTCA_WTCA_Msk                (0xffffffffUL)            /*!< GPIO WTCA: WTCA (Bitfield-Mask: 0xffffffff)           */
/* =========================================================  WTCB  ========================================================== */
#define GPIO_WTCB_WTCB_Pos                (0UL)                     /*!< GPIO WTCB: WTCB (Bit 0)                               */
#define GPIO_WTCB_WTCB_Msk                (0x3ffffUL)               /*!< GPIO WTCB: WTCB (Bitfield-Mask: 0x3ffff)              */
/* ==========================================================  ENA  ========================================================== */
#define GPIO_ENA_ENA_Pos                  (0UL)                     /*!< GPIO ENA: ENA (Bit 0)                                 */
#define GPIO_ENA_ENA_Msk                  (0xffffffffUL)            /*!< GPIO ENA: ENA (Bitfield-Mask: 0xffffffff)             */
/* ==========================================================  ENB  ========================================================== */
#define GPIO_ENB_ENB_Pos                  (0UL)                     /*!< GPIO ENB: ENB (Bit 0)                                 */
#define GPIO_ENB_ENB_Msk                  (0x3ffffUL)               /*!< GPIO ENB: ENB (Bitfield-Mask: 0x3ffff)                */
/* =========================================================  ENSA  ========================================================== */
#define GPIO_ENSA_ENSA_Pos                (0UL)                     /*!< GPIO ENSA: ENSA (Bit 0)                               */
#define GPIO_ENSA_ENSA_Msk                (0xffffffffUL)            /*!< GPIO ENSA: ENSA (Bitfield-Mask: 0xffffffff)           */
/* =========================================================  ENSB  ========================================================== */
#define GPIO_ENSB_ENSB_Pos                (0UL)                     /*!< GPIO ENSB: ENSB (Bit 0)                               */
#define GPIO_ENSB_ENSB_Msk                (0x3ffffUL)               /*!< GPIO ENSB: ENSB (Bitfield-Mask: 0x3ffff)              */
/* =========================================================  ENCA  ========================================================== */
#define GPIO_ENCA_ENCA_Pos                (0UL)                     /*!< GPIO ENCA: ENCA (Bit 0)                               */
#define GPIO_ENCA_ENCA_Msk                (0xffffffffUL)            /*!< GPIO ENCA: ENCA (Bitfield-Mask: 0xffffffff)           */
/* =========================================================  ENCB  ========================================================== */
#define GPIO_ENCB_ENCB_Pos                (0UL)                     /*!< GPIO ENCB: ENCB (Bit 0)                               */
#define GPIO_ENCB_ENCB_Msk                (0x3ffffUL)               /*!< GPIO ENCB: ENCB (Bitfield-Mask: 0x3ffff)              */
/* ========================================================  STMRCAP  ======================================================== */
#define GPIO_STMRCAP_STPOL3_Pos           (30UL)                    /*!< GPIO STMRCAP: STPOL3 (Bit 30)                         */
#define GPIO_STMRCAP_STPOL3_Msk           (0x40000000UL)            /*!< GPIO STMRCAP: STPOL3 (Bitfield-Mask: 0x01)            */
#define GPIO_STMRCAP_STSEL3_Pos           (24UL)                    /*!< GPIO STMRCAP: STSEL3 (Bit 24)                         */
#define GPIO_STMRCAP_STSEL3_Msk           (0x3f000000UL)            /*!< GPIO STMRCAP: STSEL3 (Bitfield-Mask: 0x3f)            */
#define GPIO_STMRCAP_STPOL2_Pos           (22UL)                    /*!< GPIO STMRCAP: STPOL2 (Bit 22)                         */
#define GPIO_STMRCAP_STPOL2_Msk           (0x400000UL)              /*!< GPIO STMRCAP: STPOL2 (Bitfield-Mask: 0x01)            */
#define GPIO_STMRCAP_STSEL2_Pos           (16UL)                    /*!< GPIO STMRCAP: STSEL2 (Bit 16)                         */
#define GPIO_STMRCAP_STSEL2_Msk           (0x3f0000UL)              /*!< GPIO STMRCAP: STSEL2 (Bitfield-Mask: 0x3f)            */
#define GPIO_STMRCAP_STPOL1_Pos           (14UL)                    /*!< GPIO STMRCAP: STPOL1 (Bit 14)                         */
#define GPIO_STMRCAP_STPOL1_Msk           (0x4000UL)                /*!< GPIO STMRCAP: STPOL1 (Bitfield-Mask: 0x01)            */
#define GPIO_STMRCAP_STSEL1_Pos           (8UL)                     /*!< GPIO STMRCAP: STSEL1 (Bit 8)                          */
#define GPIO_STMRCAP_STSEL1_Msk           (0x3f00UL)                /*!< GPIO STMRCAP: STSEL1 (Bitfield-Mask: 0x3f)            */
#define GPIO_STMRCAP_STPOL0_Pos           (6UL)                     /*!< GPIO STMRCAP: STPOL0 (Bit 6)                          */
#define GPIO_STMRCAP_STPOL0_Msk           (0x40UL)                  /*!< GPIO STMRCAP: STPOL0 (Bitfield-Mask: 0x01)            */
#define GPIO_STMRCAP_STSEL0_Pos           (0UL)                     /*!< GPIO STMRCAP: STSEL0 (Bit 0)                          */
#define GPIO_STMRCAP_STSEL0_Msk           (0x3fUL)                  /*!< GPIO STMRCAP: STSEL0 (Bitfield-Mask: 0x3f)            */
/* ========================================================  IOM0IRQ  ======================================================== */
#define GPIO_IOM0IRQ_IOM0IRQ_Pos          (0UL)                     /*!< GPIO IOM0IRQ: IOM0IRQ (Bit 0)                         */
#define GPIO_IOM0IRQ_IOM0IRQ_Msk          (0x3fUL)                  /*!< GPIO IOM0IRQ: IOM0IRQ (Bitfield-Mask: 0x3f)           */
/* ========================================================  IOM1IRQ  ======================================================== */
#define GPIO_IOM1IRQ_IOM1IRQ_Pos          (0UL)                     /*!< GPIO IOM1IRQ: IOM1IRQ (Bit 0)                         */
#define GPIO_IOM1IRQ_IOM1IRQ_Msk          (0x3fUL)                  /*!< GPIO IOM1IRQ: IOM1IRQ (Bitfield-Mask: 0x3f)           */
/* ========================================================  IOM2IRQ  ======================================================== */
#define GPIO_IOM2IRQ_IOM2IRQ_Pos          (0UL)                     /*!< GPIO IOM2IRQ: IOM2IRQ (Bit 0)                         */
#define GPIO_IOM2IRQ_IOM2IRQ_Msk          (0x3fUL)                  /*!< GPIO IOM2IRQ: IOM2IRQ (Bitfield-Mask: 0x3f)           */
/* ========================================================  IOM3IRQ  ======================================================== */
#define GPIO_IOM3IRQ_IOM3IRQ_Pos          (0UL)                     /*!< GPIO IOM3IRQ: IOM3IRQ (Bit 0)                         */
#define GPIO_IOM3IRQ_IOM3IRQ_Msk          (0x3fUL)                  /*!< GPIO IOM3IRQ: IOM3IRQ (Bitfield-Mask: 0x3f)           */
/* ========================================================  IOM4IRQ  ======================================================== */
#define GPIO_IOM4IRQ_IOM4IRQ_Pos          (0UL)                     /*!< GPIO IOM4IRQ: IOM4IRQ (Bit 0)                         */
#define GPIO_IOM4IRQ_IOM4IRQ_Msk          (0x3fUL)                  /*!< GPIO IOM4IRQ: IOM4IRQ (Bitfield-Mask: 0x3f)           */
/* ========================================================  IOM5IRQ  ======================================================== */
#define GPIO_IOM5IRQ_IOM5IRQ_Pos          (0UL)                     /*!< GPIO IOM5IRQ: IOM5IRQ (Bit 0)                         */
#define GPIO_IOM5IRQ_IOM5IRQ_Msk          (0x3fUL)                  /*!< GPIO IOM5IRQ: IOM5IRQ (Bitfield-Mask: 0x3f)           */
/* =======================================================  LOOPBACK  ======================================================== */
#define GPIO_LOOPBACK_LOOPBACK_Pos        (0UL)                     /*!< GPIO LOOPBACK: LOOPBACK (Bit 0)                       */
#define GPIO_LOOPBACK_LOOPBACK_Msk        (0x7UL)                   /*!< GPIO LOOPBACK: LOOPBACK (Bitfield-Mask: 0x07)         */
/* ========================================================  GPIOOBS  ======================================================== */
#define GPIO_GPIOOBS_OBS_DATA_Pos         (0UL)                     /*!< GPIO GPIOOBS: OBS_DATA (Bit 0)                        */
#define GPIO_GPIOOBS_OBS_DATA_Msk         (0xffffUL)                /*!< GPIO GPIOOBS: OBS_DATA (Bitfield-Mask: 0xffff)        */
/* ======================================================  ALTPADCFGA  ======================================================= */
#define GPIO_ALTPADCFGA_PAD3_SR_Pos       (28UL)                    /*!< GPIO ALTPADCFGA: PAD3_SR (Bit 28)                     */
#define GPIO_ALTPADCFGA_PAD3_SR_Msk       (0x10000000UL)            /*!< GPIO ALTPADCFGA: PAD3_SR (Bitfield-Mask: 0x01)        */
#define GPIO_ALTPADCFGA_PAD3_DS1_Pos      (24UL)                    /*!< GPIO ALTPADCFGA: PAD3_DS1 (Bit 24)                    */
#define GPIO_ALTPADCFGA_PAD3_DS1_Msk      (0x1000000UL)             /*!< GPIO ALTPADCFGA: PAD3_DS1 (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGA_PAD2_SR_Pos       (20UL)                    /*!< GPIO ALTPADCFGA: PAD2_SR (Bit 20)                     */
#define GPIO_ALTPADCFGA_PAD2_SR_Msk       (0x100000UL)              /*!< GPIO ALTPADCFGA: PAD2_SR (Bitfield-Mask: 0x01)        */
#define GPIO_ALTPADCFGA_PAD2_DS1_Pos      (16UL)                    /*!< GPIO ALTPADCFGA: PAD2_DS1 (Bit 16)                    */
#define GPIO_ALTPADCFGA_PAD2_DS1_Msk      (0x10000UL)               /*!< GPIO ALTPADCFGA: PAD2_DS1 (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGA_PAD1_SR_Pos       (12UL)                    /*!< GPIO ALTPADCFGA: PAD1_SR (Bit 12)                     */
#define GPIO_ALTPADCFGA_PAD1_SR_Msk       (0x1000UL)                /*!< GPIO ALTPADCFGA: PAD1_SR (Bitfield-Mask: 0x01)        */
#define GPIO_ALTPADCFGA_PAD1_DS1_Pos      (8UL)                     /*!< GPIO ALTPADCFGA: PAD1_DS1 (Bit 8)                     */
#define GPIO_ALTPADCFGA_PAD1_DS1_Msk      (0x100UL)                 /*!< GPIO ALTPADCFGA: PAD1_DS1 (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGA_PAD0_SR_Pos       (4UL)                     /*!< GPIO ALTPADCFGA: PAD0_SR (Bit 4)                      */
#define GPIO_ALTPADCFGA_PAD0_SR_Msk       (0x10UL)                  /*!< GPIO ALTPADCFGA: PAD0_SR (Bitfield-Mask: 0x01)        */
#define GPIO_ALTPADCFGA_PAD0_DS1_Pos      (0UL)                     /*!< GPIO ALTPADCFGA: PAD0_DS1 (Bit 0)                     */
#define GPIO_ALTPADCFGA_PAD0_DS1_Msk      (0x1UL)                   /*!< GPIO ALTPADCFGA: PAD0_DS1 (Bitfield-Mask: 0x01)       */
/* ======================================================  ALTPADCFGB  ======================================================= */
#define GPIO_ALTPADCFGB_PAD7_SR_Pos       (28UL)                    /*!< GPIO ALTPADCFGB: PAD7_SR (Bit 28)                     */
#define GPIO_ALTPADCFGB_PAD7_SR_Msk       (0x10000000UL)            /*!< GPIO ALTPADCFGB: PAD7_SR (Bitfield-Mask: 0x01)        */
#define GPIO_ALTPADCFGB_PAD7_DS1_Pos      (24UL)                    /*!< GPIO ALTPADCFGB: PAD7_DS1 (Bit 24)                    */
#define GPIO_ALTPADCFGB_PAD7_DS1_Msk      (0x1000000UL)             /*!< GPIO ALTPADCFGB: PAD7_DS1 (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGB_PAD6_SR_Pos       (20UL)                    /*!< GPIO ALTPADCFGB: PAD6_SR (Bit 20)                     */
#define GPIO_ALTPADCFGB_PAD6_SR_Msk       (0x100000UL)              /*!< GPIO ALTPADCFGB: PAD6_SR (Bitfield-Mask: 0x01)        */
#define GPIO_ALTPADCFGB_PAD6_DS1_Pos      (16UL)                    /*!< GPIO ALTPADCFGB: PAD6_DS1 (Bit 16)                    */
#define GPIO_ALTPADCFGB_PAD6_DS1_Msk      (0x10000UL)               /*!< GPIO ALTPADCFGB: PAD6_DS1 (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGB_PAD5_SR_Pos       (12UL)                    /*!< GPIO ALTPADCFGB: PAD5_SR (Bit 12)                     */
#define GPIO_ALTPADCFGB_PAD5_SR_Msk       (0x1000UL)                /*!< GPIO ALTPADCFGB: PAD5_SR (Bitfield-Mask: 0x01)        */
#define GPIO_ALTPADCFGB_PAD5_DS1_Pos      (8UL)                     /*!< GPIO ALTPADCFGB: PAD5_DS1 (Bit 8)                     */
#define GPIO_ALTPADCFGB_PAD5_DS1_Msk      (0x100UL)                 /*!< GPIO ALTPADCFGB: PAD5_DS1 (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGB_PAD4_SR_Pos       (4UL)                     /*!< GPIO ALTPADCFGB: PAD4_SR (Bit 4)                      */
#define GPIO_ALTPADCFGB_PAD4_SR_Msk       (0x10UL)                  /*!< GPIO ALTPADCFGB: PAD4_SR (Bitfield-Mask: 0x01)        */
#define GPIO_ALTPADCFGB_PAD4_DS1_Pos      (0UL)                     /*!< GPIO ALTPADCFGB: PAD4_DS1 (Bit 0)                     */
#define GPIO_ALTPADCFGB_PAD4_DS1_Msk      (0x1UL)                   /*!< GPIO ALTPADCFGB: PAD4_DS1 (Bitfield-Mask: 0x01)       */
/* ======================================================  ALTPADCFGC  ======================================================= */
#define GPIO_ALTPADCFGC_PAD11_SR_Pos      (28UL)                    /*!< GPIO ALTPADCFGC: PAD11_SR (Bit 28)                    */
#define GPIO_ALTPADCFGC_PAD11_SR_Msk      (0x10000000UL)            /*!< GPIO ALTPADCFGC: PAD11_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGC_PAD11_DS1_Pos     (24UL)                    /*!< GPIO ALTPADCFGC: PAD11_DS1 (Bit 24)                   */
#define GPIO_ALTPADCFGC_PAD11_DS1_Msk     (0x1000000UL)             /*!< GPIO ALTPADCFGC: PAD11_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGC_PAD10_SR_Pos      (20UL)                    /*!< GPIO ALTPADCFGC: PAD10_SR (Bit 20)                    */
#define GPIO_ALTPADCFGC_PAD10_SR_Msk      (0x100000UL)              /*!< GPIO ALTPADCFGC: PAD10_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGC_PAD10_DS1_Pos     (16UL)                    /*!< GPIO ALTPADCFGC: PAD10_DS1 (Bit 16)                   */
#define GPIO_ALTPADCFGC_PAD10_DS1_Msk     (0x10000UL)               /*!< GPIO ALTPADCFGC: PAD10_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGC_PAD9_SR_Pos       (12UL)                    /*!< GPIO ALTPADCFGC: PAD9_SR (Bit 12)                     */
#define GPIO_ALTPADCFGC_PAD9_SR_Msk       (0x1000UL)                /*!< GPIO ALTPADCFGC: PAD9_SR (Bitfield-Mask: 0x01)        */
#define GPIO_ALTPADCFGC_PAD9_DS1_Pos      (8UL)                     /*!< GPIO ALTPADCFGC: PAD9_DS1 (Bit 8)                     */
#define GPIO_ALTPADCFGC_PAD9_DS1_Msk      (0x100UL)                 /*!< GPIO ALTPADCFGC: PAD9_DS1 (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGC_PAD8_SR_Pos       (4UL)                     /*!< GPIO ALTPADCFGC: PAD8_SR (Bit 4)                      */
#define GPIO_ALTPADCFGC_PAD8_SR_Msk       (0x10UL)                  /*!< GPIO ALTPADCFGC: PAD8_SR (Bitfield-Mask: 0x01)        */
#define GPIO_ALTPADCFGC_PAD8_DS1_Pos      (0UL)                     /*!< GPIO ALTPADCFGC: PAD8_DS1 (Bit 0)                     */
#define GPIO_ALTPADCFGC_PAD8_DS1_Msk      (0x1UL)                   /*!< GPIO ALTPADCFGC: PAD8_DS1 (Bitfield-Mask: 0x01)       */
/* ======================================================  ALTPADCFGD  ======================================================= */
#define GPIO_ALTPADCFGD_PAD15_SR_Pos      (28UL)                    /*!< GPIO ALTPADCFGD: PAD15_SR (Bit 28)                    */
#define GPIO_ALTPADCFGD_PAD15_SR_Msk      (0x10000000UL)            /*!< GPIO ALTPADCFGD: PAD15_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGD_PAD15_DS1_Pos     (24UL)                    /*!< GPIO ALTPADCFGD: PAD15_DS1 (Bit 24)                   */
#define GPIO_ALTPADCFGD_PAD15_DS1_Msk     (0x1000000UL)             /*!< GPIO ALTPADCFGD: PAD15_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGD_PAD14_SR_Pos      (20UL)                    /*!< GPIO ALTPADCFGD: PAD14_SR (Bit 20)                    */
#define GPIO_ALTPADCFGD_PAD14_SR_Msk      (0x100000UL)              /*!< GPIO ALTPADCFGD: PAD14_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGD_PAD14_DS1_Pos     (16UL)                    /*!< GPIO ALTPADCFGD: PAD14_DS1 (Bit 16)                   */
#define GPIO_ALTPADCFGD_PAD14_DS1_Msk     (0x10000UL)               /*!< GPIO ALTPADCFGD: PAD14_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGD_PAD13_SR_Pos      (12UL)                    /*!< GPIO ALTPADCFGD: PAD13_SR (Bit 12)                    */
#define GPIO_ALTPADCFGD_PAD13_SR_Msk      (0x1000UL)                /*!< GPIO ALTPADCFGD: PAD13_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGD_PAD13_DS1_Pos     (8UL)                     /*!< GPIO ALTPADCFGD: PAD13_DS1 (Bit 8)                    */
#define GPIO_ALTPADCFGD_PAD13_DS1_Msk     (0x100UL)                 /*!< GPIO ALTPADCFGD: PAD13_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGD_PAD12_SR_Pos      (4UL)                     /*!< GPIO ALTPADCFGD: PAD12_SR (Bit 4)                     */
#define GPIO_ALTPADCFGD_PAD12_SR_Msk      (0x10UL)                  /*!< GPIO ALTPADCFGD: PAD12_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGD_PAD12_DS1_Pos     (0UL)                     /*!< GPIO ALTPADCFGD: PAD12_DS1 (Bit 0)                    */
#define GPIO_ALTPADCFGD_PAD12_DS1_Msk     (0x1UL)                   /*!< GPIO ALTPADCFGD: PAD12_DS1 (Bitfield-Mask: 0x01)      */
/* ======================================================  ALTPADCFGE  ======================================================= */
#define GPIO_ALTPADCFGE_PAD19_SR_Pos      (28UL)                    /*!< GPIO ALTPADCFGE: PAD19_SR (Bit 28)                    */
#define GPIO_ALTPADCFGE_PAD19_SR_Msk      (0x10000000UL)            /*!< GPIO ALTPADCFGE: PAD19_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGE_PAD19_DS1_Pos     (24UL)                    /*!< GPIO ALTPADCFGE: PAD19_DS1 (Bit 24)                   */
#define GPIO_ALTPADCFGE_PAD19_DS1_Msk     (0x1000000UL)             /*!< GPIO ALTPADCFGE: PAD19_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGE_PAD18_SR_Pos      (20UL)                    /*!< GPIO ALTPADCFGE: PAD18_SR (Bit 20)                    */
#define GPIO_ALTPADCFGE_PAD18_SR_Msk      (0x100000UL)              /*!< GPIO ALTPADCFGE: PAD18_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGE_PAD18_DS1_Pos     (16UL)                    /*!< GPIO ALTPADCFGE: PAD18_DS1 (Bit 16)                   */
#define GPIO_ALTPADCFGE_PAD18_DS1_Msk     (0x10000UL)               /*!< GPIO ALTPADCFGE: PAD18_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGE_PAD17_SR_Pos      (12UL)                    /*!< GPIO ALTPADCFGE: PAD17_SR (Bit 12)                    */
#define GPIO_ALTPADCFGE_PAD17_SR_Msk      (0x1000UL)                /*!< GPIO ALTPADCFGE: PAD17_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGE_PAD17_DS1_Pos     (8UL)                     /*!< GPIO ALTPADCFGE: PAD17_DS1 (Bit 8)                    */
#define GPIO_ALTPADCFGE_PAD17_DS1_Msk     (0x100UL)                 /*!< GPIO ALTPADCFGE: PAD17_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGE_PAD16_SR_Pos      (4UL)                     /*!< GPIO ALTPADCFGE: PAD16_SR (Bit 4)                     */
#define GPIO_ALTPADCFGE_PAD16_SR_Msk      (0x10UL)                  /*!< GPIO ALTPADCFGE: PAD16_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGE_PAD16_DS1_Pos     (0UL)                     /*!< GPIO ALTPADCFGE: PAD16_DS1 (Bit 0)                    */
#define GPIO_ALTPADCFGE_PAD16_DS1_Msk     (0x1UL)                   /*!< GPIO ALTPADCFGE: PAD16_DS1 (Bitfield-Mask: 0x01)      */
/* ======================================================  ALTPADCFGF  ======================================================= */
#define GPIO_ALTPADCFGF_PAD23_SR_Pos      (28UL)                    /*!< GPIO ALTPADCFGF: PAD23_SR (Bit 28)                    */
#define GPIO_ALTPADCFGF_PAD23_SR_Msk      (0x10000000UL)            /*!< GPIO ALTPADCFGF: PAD23_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGF_PAD23_DS1_Pos     (24UL)                    /*!< GPIO ALTPADCFGF: PAD23_DS1 (Bit 24)                   */
#define GPIO_ALTPADCFGF_PAD23_DS1_Msk     (0x1000000UL)             /*!< GPIO ALTPADCFGF: PAD23_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGF_PAD22_SR_Pos      (20UL)                    /*!< GPIO ALTPADCFGF: PAD22_SR (Bit 20)                    */
#define GPIO_ALTPADCFGF_PAD22_SR_Msk      (0x100000UL)              /*!< GPIO ALTPADCFGF: PAD22_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGF_PAD22_DS1_Pos     (16UL)                    /*!< GPIO ALTPADCFGF: PAD22_DS1 (Bit 16)                   */
#define GPIO_ALTPADCFGF_PAD22_DS1_Msk     (0x10000UL)               /*!< GPIO ALTPADCFGF: PAD22_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGF_PAD21_SR_Pos      (12UL)                    /*!< GPIO ALTPADCFGF: PAD21_SR (Bit 12)                    */
#define GPIO_ALTPADCFGF_PAD21_SR_Msk      (0x1000UL)                /*!< GPIO ALTPADCFGF: PAD21_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGF_PAD21_DS1_Pos     (8UL)                     /*!< GPIO ALTPADCFGF: PAD21_DS1 (Bit 8)                    */
#define GPIO_ALTPADCFGF_PAD21_DS1_Msk     (0x100UL)                 /*!< GPIO ALTPADCFGF: PAD21_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGF_PAD20_SR_Pos      (4UL)                     /*!< GPIO ALTPADCFGF: PAD20_SR (Bit 4)                     */
#define GPIO_ALTPADCFGF_PAD20_SR_Msk      (0x10UL)                  /*!< GPIO ALTPADCFGF: PAD20_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGF_PAD20_DS1_Pos     (0UL)                     /*!< GPIO ALTPADCFGF: PAD20_DS1 (Bit 0)                    */
#define GPIO_ALTPADCFGF_PAD20_DS1_Msk     (0x1UL)                   /*!< GPIO ALTPADCFGF: PAD20_DS1 (Bitfield-Mask: 0x01)      */
/* ======================================================  ALTPADCFGG  ======================================================= */
#define GPIO_ALTPADCFGG_PAD27_SR_Pos      (28UL)                    /*!< GPIO ALTPADCFGG: PAD27_SR (Bit 28)                    */
#define GPIO_ALTPADCFGG_PAD27_SR_Msk      (0x10000000UL)            /*!< GPIO ALTPADCFGG: PAD27_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGG_PAD27_DS1_Pos     (24UL)                    /*!< GPIO ALTPADCFGG: PAD27_DS1 (Bit 24)                   */
#define GPIO_ALTPADCFGG_PAD27_DS1_Msk     (0x1000000UL)             /*!< GPIO ALTPADCFGG: PAD27_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGG_PAD26_SR_Pos      (20UL)                    /*!< GPIO ALTPADCFGG: PAD26_SR (Bit 20)                    */
#define GPIO_ALTPADCFGG_PAD26_SR_Msk      (0x100000UL)              /*!< GPIO ALTPADCFGG: PAD26_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGG_PAD26_DS1_Pos     (16UL)                    /*!< GPIO ALTPADCFGG: PAD26_DS1 (Bit 16)                   */
#define GPIO_ALTPADCFGG_PAD26_DS1_Msk     (0x10000UL)               /*!< GPIO ALTPADCFGG: PAD26_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGG_PAD25_SR_Pos      (12UL)                    /*!< GPIO ALTPADCFGG: PAD25_SR (Bit 12)                    */
#define GPIO_ALTPADCFGG_PAD25_SR_Msk      (0x1000UL)                /*!< GPIO ALTPADCFGG: PAD25_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGG_PAD25_DS1_Pos     (8UL)                     /*!< GPIO ALTPADCFGG: PAD25_DS1 (Bit 8)                    */
#define GPIO_ALTPADCFGG_PAD25_DS1_Msk     (0x100UL)                 /*!< GPIO ALTPADCFGG: PAD25_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGG_PAD24_SR_Pos      (4UL)                     /*!< GPIO ALTPADCFGG: PAD24_SR (Bit 4)                     */
#define GPIO_ALTPADCFGG_PAD24_SR_Msk      (0x10UL)                  /*!< GPIO ALTPADCFGG: PAD24_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGG_PAD24_DS1_Pos     (0UL)                     /*!< GPIO ALTPADCFGG: PAD24_DS1 (Bit 0)                    */
#define GPIO_ALTPADCFGG_PAD24_DS1_Msk     (0x1UL)                   /*!< GPIO ALTPADCFGG: PAD24_DS1 (Bitfield-Mask: 0x01)      */
/* ======================================================  ALTPADCFGH  ======================================================= */
#define GPIO_ALTPADCFGH_PAD31_SR_Pos      (28UL)                    /*!< GPIO ALTPADCFGH: PAD31_SR (Bit 28)                    */
#define GPIO_ALTPADCFGH_PAD31_SR_Msk      (0x10000000UL)            /*!< GPIO ALTPADCFGH: PAD31_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGH_PAD31_DS1_Pos     (24UL)                    /*!< GPIO ALTPADCFGH: PAD31_DS1 (Bit 24)                   */
#define GPIO_ALTPADCFGH_PAD31_DS1_Msk     (0x1000000UL)             /*!< GPIO ALTPADCFGH: PAD31_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGH_PAD30_SR_Pos      (20UL)                    /*!< GPIO ALTPADCFGH: PAD30_SR (Bit 20)                    */
#define GPIO_ALTPADCFGH_PAD30_SR_Msk      (0x100000UL)              /*!< GPIO ALTPADCFGH: PAD30_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGH_PAD30_DS1_Pos     (16UL)                    /*!< GPIO ALTPADCFGH: PAD30_DS1 (Bit 16)                   */
#define GPIO_ALTPADCFGH_PAD30_DS1_Msk     (0x10000UL)               /*!< GPIO ALTPADCFGH: PAD30_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGH_PAD29_SR_Pos      (12UL)                    /*!< GPIO ALTPADCFGH: PAD29_SR (Bit 12)                    */
#define GPIO_ALTPADCFGH_PAD29_SR_Msk      (0x1000UL)                /*!< GPIO ALTPADCFGH: PAD29_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGH_PAD29_DS1_Pos     (8UL)                     /*!< GPIO ALTPADCFGH: PAD29_DS1 (Bit 8)                    */
#define GPIO_ALTPADCFGH_PAD29_DS1_Msk     (0x100UL)                 /*!< GPIO ALTPADCFGH: PAD29_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGH_PAD28_SR_Pos      (4UL)                     /*!< GPIO ALTPADCFGH: PAD28_SR (Bit 4)                     */
#define GPIO_ALTPADCFGH_PAD28_SR_Msk      (0x10UL)                  /*!< GPIO ALTPADCFGH: PAD28_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGH_PAD28_DS1_Pos     (0UL)                     /*!< GPIO ALTPADCFGH: PAD28_DS1 (Bit 0)                    */
#define GPIO_ALTPADCFGH_PAD28_DS1_Msk     (0x1UL)                   /*!< GPIO ALTPADCFGH: PAD28_DS1 (Bitfield-Mask: 0x01)      */
/* ======================================================  ALTPADCFGI  ======================================================= */
#define GPIO_ALTPADCFGI_PAD35_SR_Pos      (28UL)                    /*!< GPIO ALTPADCFGI: PAD35_SR (Bit 28)                    */
#define GPIO_ALTPADCFGI_PAD35_SR_Msk      (0x10000000UL)            /*!< GPIO ALTPADCFGI: PAD35_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGI_PAD35_DS1_Pos     (24UL)                    /*!< GPIO ALTPADCFGI: PAD35_DS1 (Bit 24)                   */
#define GPIO_ALTPADCFGI_PAD35_DS1_Msk     (0x1000000UL)             /*!< GPIO ALTPADCFGI: PAD35_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGI_PAD34_SR_Pos      (20UL)                    /*!< GPIO ALTPADCFGI: PAD34_SR (Bit 20)                    */
#define GPIO_ALTPADCFGI_PAD34_SR_Msk      (0x100000UL)              /*!< GPIO ALTPADCFGI: PAD34_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGI_PAD34_DS1_Pos     (16UL)                    /*!< GPIO ALTPADCFGI: PAD34_DS1 (Bit 16)                   */
#define GPIO_ALTPADCFGI_PAD34_DS1_Msk     (0x10000UL)               /*!< GPIO ALTPADCFGI: PAD34_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGI_PAD33_SR_Pos      (12UL)                    /*!< GPIO ALTPADCFGI: PAD33_SR (Bit 12)                    */
#define GPIO_ALTPADCFGI_PAD33_SR_Msk      (0x1000UL)                /*!< GPIO ALTPADCFGI: PAD33_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGI_PAD33_DS1_Pos     (8UL)                     /*!< GPIO ALTPADCFGI: PAD33_DS1 (Bit 8)                    */
#define GPIO_ALTPADCFGI_PAD33_DS1_Msk     (0x100UL)                 /*!< GPIO ALTPADCFGI: PAD33_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGI_PAD32_SR_Pos      (4UL)                     /*!< GPIO ALTPADCFGI: PAD32_SR (Bit 4)                     */
#define GPIO_ALTPADCFGI_PAD32_SR_Msk      (0x10UL)                  /*!< GPIO ALTPADCFGI: PAD32_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGI_PAD32_DS1_Pos     (0UL)                     /*!< GPIO ALTPADCFGI: PAD32_DS1 (Bit 0)                    */
#define GPIO_ALTPADCFGI_PAD32_DS1_Msk     (0x1UL)                   /*!< GPIO ALTPADCFGI: PAD32_DS1 (Bitfield-Mask: 0x01)      */
/* ======================================================  ALTPADCFGJ  ======================================================= */
#define GPIO_ALTPADCFGJ_PAD39_SR_Pos      (28UL)                    /*!< GPIO ALTPADCFGJ: PAD39_SR (Bit 28)                    */
#define GPIO_ALTPADCFGJ_PAD39_SR_Msk      (0x10000000UL)            /*!< GPIO ALTPADCFGJ: PAD39_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGJ_PAD39_DS1_Pos     (24UL)                    /*!< GPIO ALTPADCFGJ: PAD39_DS1 (Bit 24)                   */
#define GPIO_ALTPADCFGJ_PAD39_DS1_Msk     (0x1000000UL)             /*!< GPIO ALTPADCFGJ: PAD39_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGJ_PAD38_SR_Pos      (20UL)                    /*!< GPIO ALTPADCFGJ: PAD38_SR (Bit 20)                    */
#define GPIO_ALTPADCFGJ_PAD38_SR_Msk      (0x100000UL)              /*!< GPIO ALTPADCFGJ: PAD38_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGJ_PAD38_DS1_Pos     (16UL)                    /*!< GPIO ALTPADCFGJ: PAD38_DS1 (Bit 16)                   */
#define GPIO_ALTPADCFGJ_PAD38_DS1_Msk     (0x10000UL)               /*!< GPIO ALTPADCFGJ: PAD38_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGJ_PAD37_SR_Pos      (12UL)                    /*!< GPIO ALTPADCFGJ: PAD37_SR (Bit 12)                    */
#define GPIO_ALTPADCFGJ_PAD37_SR_Msk      (0x1000UL)                /*!< GPIO ALTPADCFGJ: PAD37_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGJ_PAD37_DS1_Pos     (8UL)                     /*!< GPIO ALTPADCFGJ: PAD37_DS1 (Bit 8)                    */
#define GPIO_ALTPADCFGJ_PAD37_DS1_Msk     (0x100UL)                 /*!< GPIO ALTPADCFGJ: PAD37_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGJ_PAD36_SR_Pos      (4UL)                     /*!< GPIO ALTPADCFGJ: PAD36_SR (Bit 4)                     */
#define GPIO_ALTPADCFGJ_PAD36_SR_Msk      (0x10UL)                  /*!< GPIO ALTPADCFGJ: PAD36_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGJ_PAD36_DS1_Pos     (0UL)                     /*!< GPIO ALTPADCFGJ: PAD36_DS1 (Bit 0)                    */
#define GPIO_ALTPADCFGJ_PAD36_DS1_Msk     (0x1UL)                   /*!< GPIO ALTPADCFGJ: PAD36_DS1 (Bitfield-Mask: 0x01)      */
/* ======================================================  ALTPADCFGK  ======================================================= */
#define GPIO_ALTPADCFGK_PAD43_SR_Pos      (28UL)                    /*!< GPIO ALTPADCFGK: PAD43_SR (Bit 28)                    */
#define GPIO_ALTPADCFGK_PAD43_SR_Msk      (0x10000000UL)            /*!< GPIO ALTPADCFGK: PAD43_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGK_PAD43_DS1_Pos     (24UL)                    /*!< GPIO ALTPADCFGK: PAD43_DS1 (Bit 24)                   */
#define GPIO_ALTPADCFGK_PAD43_DS1_Msk     (0x1000000UL)             /*!< GPIO ALTPADCFGK: PAD43_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGK_PAD42_SR_Pos      (20UL)                    /*!< GPIO ALTPADCFGK: PAD42_SR (Bit 20)                    */
#define GPIO_ALTPADCFGK_PAD42_SR_Msk      (0x100000UL)              /*!< GPIO ALTPADCFGK: PAD42_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGK_PAD42_DS1_Pos     (16UL)                    /*!< GPIO ALTPADCFGK: PAD42_DS1 (Bit 16)                   */
#define GPIO_ALTPADCFGK_PAD42_DS1_Msk     (0x10000UL)               /*!< GPIO ALTPADCFGK: PAD42_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGK_PAD41_SR_Pos      (12UL)                    /*!< GPIO ALTPADCFGK: PAD41_SR (Bit 12)                    */
#define GPIO_ALTPADCFGK_PAD41_SR_Msk      (0x1000UL)                /*!< GPIO ALTPADCFGK: PAD41_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGK_PAD41_DS1_Pos     (8UL)                     /*!< GPIO ALTPADCFGK: PAD41_DS1 (Bit 8)                    */
#define GPIO_ALTPADCFGK_PAD41_DS1_Msk     (0x100UL)                 /*!< GPIO ALTPADCFGK: PAD41_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGK_PAD40_SR_Pos      (4UL)                     /*!< GPIO ALTPADCFGK: PAD40_SR (Bit 4)                     */
#define GPIO_ALTPADCFGK_PAD40_SR_Msk      (0x10UL)                  /*!< GPIO ALTPADCFGK: PAD40_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGK_PAD40_DS1_Pos     (0UL)                     /*!< GPIO ALTPADCFGK: PAD40_DS1 (Bit 0)                    */
#define GPIO_ALTPADCFGK_PAD40_DS1_Msk     (0x1UL)                   /*!< GPIO ALTPADCFGK: PAD40_DS1 (Bitfield-Mask: 0x01)      */
/* ======================================================  ALTPADCFGL  ======================================================= */
#define GPIO_ALTPADCFGL_PAD47_SR_Pos      (28UL)                    /*!< GPIO ALTPADCFGL: PAD47_SR (Bit 28)                    */
#define GPIO_ALTPADCFGL_PAD47_SR_Msk      (0x10000000UL)            /*!< GPIO ALTPADCFGL: PAD47_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGL_PAD47_DS1_Pos     (24UL)                    /*!< GPIO ALTPADCFGL: PAD47_DS1 (Bit 24)                   */
#define GPIO_ALTPADCFGL_PAD47_DS1_Msk     (0x1000000UL)             /*!< GPIO ALTPADCFGL: PAD47_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGL_PAD46_SR_Pos      (20UL)                    /*!< GPIO ALTPADCFGL: PAD46_SR (Bit 20)                    */
#define GPIO_ALTPADCFGL_PAD46_SR_Msk      (0x100000UL)              /*!< GPIO ALTPADCFGL: PAD46_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGL_PAD46_DS1_Pos     (16UL)                    /*!< GPIO ALTPADCFGL: PAD46_DS1 (Bit 16)                   */
#define GPIO_ALTPADCFGL_PAD46_DS1_Msk     (0x10000UL)               /*!< GPIO ALTPADCFGL: PAD46_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGL_PAD45_SR_Pos      (12UL)                    /*!< GPIO ALTPADCFGL: PAD45_SR (Bit 12)                    */
#define GPIO_ALTPADCFGL_PAD45_SR_Msk      (0x1000UL)                /*!< GPIO ALTPADCFGL: PAD45_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGL_PAD45_DS1_Pos     (8UL)                     /*!< GPIO ALTPADCFGL: PAD45_DS1 (Bit 8)                    */
#define GPIO_ALTPADCFGL_PAD45_DS1_Msk     (0x100UL)                 /*!< GPIO ALTPADCFGL: PAD45_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGL_PAD44_SR_Pos      (4UL)                     /*!< GPIO ALTPADCFGL: PAD44_SR (Bit 4)                     */
#define GPIO_ALTPADCFGL_PAD44_SR_Msk      (0x10UL)                  /*!< GPIO ALTPADCFGL: PAD44_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGL_PAD44_DS1_Pos     (0UL)                     /*!< GPIO ALTPADCFGL: PAD44_DS1 (Bit 0)                    */
#define GPIO_ALTPADCFGL_PAD44_DS1_Msk     (0x1UL)                   /*!< GPIO ALTPADCFGL: PAD44_DS1 (Bitfield-Mask: 0x01)      */
/* ======================================================  ALTPADCFGM  ======================================================= */
#define GPIO_ALTPADCFGM_PAD49_SR_Pos      (12UL)                    /*!< GPIO ALTPADCFGM: PAD49_SR (Bit 12)                    */
#define GPIO_ALTPADCFGM_PAD49_SR_Msk      (0x1000UL)                /*!< GPIO ALTPADCFGM: PAD49_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGM_PAD49_DS1_Pos     (8UL)                     /*!< GPIO ALTPADCFGM: PAD49_DS1 (Bit 8)                    */
#define GPIO_ALTPADCFGM_PAD49_DS1_Msk     (0x100UL)                 /*!< GPIO ALTPADCFGM: PAD49_DS1 (Bitfield-Mask: 0x01)      */
#define GPIO_ALTPADCFGM_PAD48_SR_Pos      (4UL)                     /*!< GPIO ALTPADCFGM: PAD48_SR (Bit 4)                     */
#define GPIO_ALTPADCFGM_PAD48_SR_Msk      (0x10UL)                  /*!< GPIO ALTPADCFGM: PAD48_SR (Bitfield-Mask: 0x01)       */
#define GPIO_ALTPADCFGM_PAD48_DS1_Pos     (0UL)                     /*!< GPIO ALTPADCFGM: PAD48_DS1 (Bit 0)                    */
#define GPIO_ALTPADCFGM_PAD48_DS1_Msk     (0x1UL)                   /*!< GPIO ALTPADCFGM: PAD48_DS1 (Bitfield-Mask: 0x01)      */
/* ========================================================  INT0EN  ========================================================= */
#define GPIO_INT0EN_GPIO31_Pos            (31UL)                    /*!< GPIO INT0EN: GPIO31 (Bit 31)                          */
#define GPIO_INT0EN_GPIO31_Msk            (0x80000000UL)            /*!< GPIO INT0EN: GPIO31 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO30_Pos            (30UL)                    /*!< GPIO INT0EN: GPIO30 (Bit 30)                          */
#define GPIO_INT0EN_GPIO30_Msk            (0x40000000UL)            /*!< GPIO INT0EN: GPIO30 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO29_Pos            (29UL)                    /*!< GPIO INT0EN: GPIO29 (Bit 29)                          */
#define GPIO_INT0EN_GPIO29_Msk            (0x20000000UL)            /*!< GPIO INT0EN: GPIO29 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO28_Pos            (28UL)                    /*!< GPIO INT0EN: GPIO28 (Bit 28)                          */
#define GPIO_INT0EN_GPIO28_Msk            (0x10000000UL)            /*!< GPIO INT0EN: GPIO28 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO27_Pos            (27UL)                    /*!< GPIO INT0EN: GPIO27 (Bit 27)                          */
#define GPIO_INT0EN_GPIO27_Msk            (0x8000000UL)             /*!< GPIO INT0EN: GPIO27 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO26_Pos            (26UL)                    /*!< GPIO INT0EN: GPIO26 (Bit 26)                          */
#define GPIO_INT0EN_GPIO26_Msk            (0x4000000UL)             /*!< GPIO INT0EN: GPIO26 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO25_Pos            (25UL)                    /*!< GPIO INT0EN: GPIO25 (Bit 25)                          */
#define GPIO_INT0EN_GPIO25_Msk            (0x2000000UL)             /*!< GPIO INT0EN: GPIO25 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO24_Pos            (24UL)                    /*!< GPIO INT0EN: GPIO24 (Bit 24)                          */
#define GPIO_INT0EN_GPIO24_Msk            (0x1000000UL)             /*!< GPIO INT0EN: GPIO24 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO23_Pos            (23UL)                    /*!< GPIO INT0EN: GPIO23 (Bit 23)                          */
#define GPIO_INT0EN_GPIO23_Msk            (0x800000UL)              /*!< GPIO INT0EN: GPIO23 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO22_Pos            (22UL)                    /*!< GPIO INT0EN: GPIO22 (Bit 22)                          */
#define GPIO_INT0EN_GPIO22_Msk            (0x400000UL)              /*!< GPIO INT0EN: GPIO22 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO21_Pos            (21UL)                    /*!< GPIO INT0EN: GPIO21 (Bit 21)                          */
#define GPIO_INT0EN_GPIO21_Msk            (0x200000UL)              /*!< GPIO INT0EN: GPIO21 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO20_Pos            (20UL)                    /*!< GPIO INT0EN: GPIO20 (Bit 20)                          */
#define GPIO_INT0EN_GPIO20_Msk            (0x100000UL)              /*!< GPIO INT0EN: GPIO20 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO19_Pos            (19UL)                    /*!< GPIO INT0EN: GPIO19 (Bit 19)                          */
#define GPIO_INT0EN_GPIO19_Msk            (0x80000UL)               /*!< GPIO INT0EN: GPIO19 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO18_Pos            (18UL)                    /*!< GPIO INT0EN: GPIO18 (Bit 18)                          */
#define GPIO_INT0EN_GPIO18_Msk            (0x40000UL)               /*!< GPIO INT0EN: GPIO18 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO17_Pos            (17UL)                    /*!< GPIO INT0EN: GPIO17 (Bit 17)                          */
#define GPIO_INT0EN_GPIO17_Msk            (0x20000UL)               /*!< GPIO INT0EN: GPIO17 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO16_Pos            (16UL)                    /*!< GPIO INT0EN: GPIO16 (Bit 16)                          */
#define GPIO_INT0EN_GPIO16_Msk            (0x10000UL)               /*!< GPIO INT0EN: GPIO16 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO15_Pos            (15UL)                    /*!< GPIO INT0EN: GPIO15 (Bit 15)                          */
#define GPIO_INT0EN_GPIO15_Msk            (0x8000UL)                /*!< GPIO INT0EN: GPIO15 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO14_Pos            (14UL)                    /*!< GPIO INT0EN: GPIO14 (Bit 14)                          */
#define GPIO_INT0EN_GPIO14_Msk            (0x4000UL)                /*!< GPIO INT0EN: GPIO14 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO13_Pos            (13UL)                    /*!< GPIO INT0EN: GPIO13 (Bit 13)                          */
#define GPIO_INT0EN_GPIO13_Msk            (0x2000UL)                /*!< GPIO INT0EN: GPIO13 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO12_Pos            (12UL)                    /*!< GPIO INT0EN: GPIO12 (Bit 12)                          */
#define GPIO_INT0EN_GPIO12_Msk            (0x1000UL)                /*!< GPIO INT0EN: GPIO12 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO11_Pos            (11UL)                    /*!< GPIO INT0EN: GPIO11 (Bit 11)                          */
#define GPIO_INT0EN_GPIO11_Msk            (0x800UL)                 /*!< GPIO INT0EN: GPIO11 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO10_Pos            (10UL)                    /*!< GPIO INT0EN: GPIO10 (Bit 10)                          */
#define GPIO_INT0EN_GPIO10_Msk            (0x400UL)                 /*!< GPIO INT0EN: GPIO10 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO9_Pos             (9UL)                     /*!< GPIO INT0EN: GPIO9 (Bit 9)                            */
#define GPIO_INT0EN_GPIO9_Msk             (0x200UL)                 /*!< GPIO INT0EN: GPIO9 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO8_Pos             (8UL)                     /*!< GPIO INT0EN: GPIO8 (Bit 8)                            */
#define GPIO_INT0EN_GPIO8_Msk             (0x100UL)                 /*!< GPIO INT0EN: GPIO8 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO7_Pos             (7UL)                     /*!< GPIO INT0EN: GPIO7 (Bit 7)                            */
#define GPIO_INT0EN_GPIO7_Msk             (0x80UL)                  /*!< GPIO INT0EN: GPIO7 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO6_Pos             (6UL)                     /*!< GPIO INT0EN: GPIO6 (Bit 6)                            */
#define GPIO_INT0EN_GPIO6_Msk             (0x40UL)                  /*!< GPIO INT0EN: GPIO6 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO5_Pos             (5UL)                     /*!< GPIO INT0EN: GPIO5 (Bit 5)                            */
#define GPIO_INT0EN_GPIO5_Msk             (0x20UL)                  /*!< GPIO INT0EN: GPIO5 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO4_Pos             (4UL)                     /*!< GPIO INT0EN: GPIO4 (Bit 4)                            */
#define GPIO_INT0EN_GPIO4_Msk             (0x10UL)                  /*!< GPIO INT0EN: GPIO4 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO3_Pos             (3UL)                     /*!< GPIO INT0EN: GPIO3 (Bit 3)                            */
#define GPIO_INT0EN_GPIO3_Msk             (0x8UL)                   /*!< GPIO INT0EN: GPIO3 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO2_Pos             (2UL)                     /*!< GPIO INT0EN: GPIO2 (Bit 2)                            */
#define GPIO_INT0EN_GPIO2_Msk             (0x4UL)                   /*!< GPIO INT0EN: GPIO2 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO1_Pos             (1UL)                     /*!< GPIO INT0EN: GPIO1 (Bit 1)                            */
#define GPIO_INT0EN_GPIO1_Msk             (0x2UL)                   /*!< GPIO INT0EN: GPIO1 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO0_Pos             (0UL)                     /*!< GPIO INT0EN: GPIO0 (Bit 0)                            */
#define GPIO_INT0EN_GPIO0_Msk             (0x1UL)                   /*!< GPIO INT0EN: GPIO0 (Bitfield-Mask: 0x01)              */
/* =======================================================  INT0STAT  ======================================================== */
#define GPIO_INT0STAT_GPIO31_Pos          (31UL)                    /*!< GPIO INT0STAT: GPIO31 (Bit 31)                        */
#define GPIO_INT0STAT_GPIO31_Msk          (0x80000000UL)            /*!< GPIO INT0STAT: GPIO31 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO30_Pos          (30UL)                    /*!< GPIO INT0STAT: GPIO30 (Bit 30)                        */
#define GPIO_INT0STAT_GPIO30_Msk          (0x40000000UL)            /*!< GPIO INT0STAT: GPIO30 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO29_Pos          (29UL)                    /*!< GPIO INT0STAT: GPIO29 (Bit 29)                        */
#define GPIO_INT0STAT_GPIO29_Msk          (0x20000000UL)            /*!< GPIO INT0STAT: GPIO29 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO28_Pos          (28UL)                    /*!< GPIO INT0STAT: GPIO28 (Bit 28)                        */
#define GPIO_INT0STAT_GPIO28_Msk          (0x10000000UL)            /*!< GPIO INT0STAT: GPIO28 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO27_Pos          (27UL)                    /*!< GPIO INT0STAT: GPIO27 (Bit 27)                        */
#define GPIO_INT0STAT_GPIO27_Msk          (0x8000000UL)             /*!< GPIO INT0STAT: GPIO27 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO26_Pos          (26UL)                    /*!< GPIO INT0STAT: GPIO26 (Bit 26)                        */
#define GPIO_INT0STAT_GPIO26_Msk          (0x4000000UL)             /*!< GPIO INT0STAT: GPIO26 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO25_Pos          (25UL)                    /*!< GPIO INT0STAT: GPIO25 (Bit 25)                        */
#define GPIO_INT0STAT_GPIO25_Msk          (0x2000000UL)             /*!< GPIO INT0STAT: GPIO25 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO24_Pos          (24UL)                    /*!< GPIO INT0STAT: GPIO24 (Bit 24)                        */
#define GPIO_INT0STAT_GPIO24_Msk          (0x1000000UL)             /*!< GPIO INT0STAT: GPIO24 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO23_Pos          (23UL)                    /*!< GPIO INT0STAT: GPIO23 (Bit 23)                        */
#define GPIO_INT0STAT_GPIO23_Msk          (0x800000UL)              /*!< GPIO INT0STAT: GPIO23 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO22_Pos          (22UL)                    /*!< GPIO INT0STAT: GPIO22 (Bit 22)                        */
#define GPIO_INT0STAT_GPIO22_Msk          (0x400000UL)              /*!< GPIO INT0STAT: GPIO22 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO21_Pos          (21UL)                    /*!< GPIO INT0STAT: GPIO21 (Bit 21)                        */
#define GPIO_INT0STAT_GPIO21_Msk          (0x200000UL)              /*!< GPIO INT0STAT: GPIO21 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO20_Pos          (20UL)                    /*!< GPIO INT0STAT: GPIO20 (Bit 20)                        */
#define GPIO_INT0STAT_GPIO20_Msk          (0x100000UL)              /*!< GPIO INT0STAT: GPIO20 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO19_Pos          (19UL)                    /*!< GPIO INT0STAT: GPIO19 (Bit 19)                        */
#define GPIO_INT0STAT_GPIO19_Msk          (0x80000UL)               /*!< GPIO INT0STAT: GPIO19 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO18_Pos          (18UL)                    /*!< GPIO INT0STAT: GPIO18 (Bit 18)                        */
#define GPIO_INT0STAT_GPIO18_Msk          (0x40000UL)               /*!< GPIO INT0STAT: GPIO18 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO17_Pos          (17UL)                    /*!< GPIO INT0STAT: GPIO17 (Bit 17)                        */
#define GPIO_INT0STAT_GPIO17_Msk          (0x20000UL)               /*!< GPIO INT0STAT: GPIO17 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO16_Pos          (16UL)                    /*!< GPIO INT0STAT: GPIO16 (Bit 16)                        */
#define GPIO_INT0STAT_GPIO16_Msk          (0x10000UL)               /*!< GPIO INT0STAT: GPIO16 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO15_Pos          (15UL)                    /*!< GPIO INT0STAT: GPIO15 (Bit 15)                        */
#define GPIO_INT0STAT_GPIO15_Msk          (0x8000UL)                /*!< GPIO INT0STAT: GPIO15 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO14_Pos          (14UL)                    /*!< GPIO INT0STAT: GPIO14 (Bit 14)                        */
#define GPIO_INT0STAT_GPIO14_Msk          (0x4000UL)                /*!< GPIO INT0STAT: GPIO14 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO13_Pos          (13UL)                    /*!< GPIO INT0STAT: GPIO13 (Bit 13)                        */
#define GPIO_INT0STAT_GPIO13_Msk          (0x2000UL)                /*!< GPIO INT0STAT: GPIO13 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO12_Pos          (12UL)                    /*!< GPIO INT0STAT: GPIO12 (Bit 12)                        */
#define GPIO_INT0STAT_GPIO12_Msk          (0x1000UL)                /*!< GPIO INT0STAT: GPIO12 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO11_Pos          (11UL)                    /*!< GPIO INT0STAT: GPIO11 (Bit 11)                        */
#define GPIO_INT0STAT_GPIO11_Msk          (0x800UL)                 /*!< GPIO INT0STAT: GPIO11 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO10_Pos          (10UL)                    /*!< GPIO INT0STAT: GPIO10 (Bit 10)                        */
#define GPIO_INT0STAT_GPIO10_Msk          (0x400UL)                 /*!< GPIO INT0STAT: GPIO10 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO9_Pos           (9UL)                     /*!< GPIO INT0STAT: GPIO9 (Bit 9)                          */
#define GPIO_INT0STAT_GPIO9_Msk           (0x200UL)                 /*!< GPIO INT0STAT: GPIO9 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO8_Pos           (8UL)                     /*!< GPIO INT0STAT: GPIO8 (Bit 8)                          */
#define GPIO_INT0STAT_GPIO8_Msk           (0x100UL)                 /*!< GPIO INT0STAT: GPIO8 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO7_Pos           (7UL)                     /*!< GPIO INT0STAT: GPIO7 (Bit 7)                          */
#define GPIO_INT0STAT_GPIO7_Msk           (0x80UL)                  /*!< GPIO INT0STAT: GPIO7 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO6_Pos           (6UL)                     /*!< GPIO INT0STAT: GPIO6 (Bit 6)                          */
#define GPIO_INT0STAT_GPIO6_Msk           (0x40UL)                  /*!< GPIO INT0STAT: GPIO6 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO5_Pos           (5UL)                     /*!< GPIO INT0STAT: GPIO5 (Bit 5)                          */
#define GPIO_INT0STAT_GPIO5_Msk           (0x20UL)                  /*!< GPIO INT0STAT: GPIO5 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO4_Pos           (4UL)                     /*!< GPIO INT0STAT: GPIO4 (Bit 4)                          */
#define GPIO_INT0STAT_GPIO4_Msk           (0x10UL)                  /*!< GPIO INT0STAT: GPIO4 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO3_Pos           (3UL)                     /*!< GPIO INT0STAT: GPIO3 (Bit 3)                          */
#define GPIO_INT0STAT_GPIO3_Msk           (0x8UL)                   /*!< GPIO INT0STAT: GPIO3 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO2_Pos           (2UL)                     /*!< GPIO INT0STAT: GPIO2 (Bit 2)                          */
#define GPIO_INT0STAT_GPIO2_Msk           (0x4UL)                   /*!< GPIO INT0STAT: GPIO2 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO1_Pos           (1UL)                     /*!< GPIO INT0STAT: GPIO1 (Bit 1)                          */
#define GPIO_INT0STAT_GPIO1_Msk           (0x2UL)                   /*!< GPIO INT0STAT: GPIO1 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO0_Pos           (0UL)                     /*!< GPIO INT0STAT: GPIO0 (Bit 0)                          */
#define GPIO_INT0STAT_GPIO0_Msk           (0x1UL)                   /*!< GPIO INT0STAT: GPIO0 (Bitfield-Mask: 0x01)            */
/* ========================================================  INT0CLR  ======================================================== */
#define GPIO_INT0CLR_GPIO31_Pos           (31UL)                    /*!< GPIO INT0CLR: GPIO31 (Bit 31)                         */
#define GPIO_INT0CLR_GPIO31_Msk           (0x80000000UL)            /*!< GPIO INT0CLR: GPIO31 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO30_Pos           (30UL)                    /*!< GPIO INT0CLR: GPIO30 (Bit 30)                         */
#define GPIO_INT0CLR_GPIO30_Msk           (0x40000000UL)            /*!< GPIO INT0CLR: GPIO30 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO29_Pos           (29UL)                    /*!< GPIO INT0CLR: GPIO29 (Bit 29)                         */
#define GPIO_INT0CLR_GPIO29_Msk           (0x20000000UL)            /*!< GPIO INT0CLR: GPIO29 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO28_Pos           (28UL)                    /*!< GPIO INT0CLR: GPIO28 (Bit 28)                         */
#define GPIO_INT0CLR_GPIO28_Msk           (0x10000000UL)            /*!< GPIO INT0CLR: GPIO28 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO27_Pos           (27UL)                    /*!< GPIO INT0CLR: GPIO27 (Bit 27)                         */
#define GPIO_INT0CLR_GPIO27_Msk           (0x8000000UL)             /*!< GPIO INT0CLR: GPIO27 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO26_Pos           (26UL)                    /*!< GPIO INT0CLR: GPIO26 (Bit 26)                         */
#define GPIO_INT0CLR_GPIO26_Msk           (0x4000000UL)             /*!< GPIO INT0CLR: GPIO26 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO25_Pos           (25UL)                    /*!< GPIO INT0CLR: GPIO25 (Bit 25)                         */
#define GPIO_INT0CLR_GPIO25_Msk           (0x2000000UL)             /*!< GPIO INT0CLR: GPIO25 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO24_Pos           (24UL)                    /*!< GPIO INT0CLR: GPIO24 (Bit 24)                         */
#define GPIO_INT0CLR_GPIO24_Msk           (0x1000000UL)             /*!< GPIO INT0CLR: GPIO24 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO23_Pos           (23UL)                    /*!< GPIO INT0CLR: GPIO23 (Bit 23)                         */
#define GPIO_INT0CLR_GPIO23_Msk           (0x800000UL)              /*!< GPIO INT0CLR: GPIO23 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO22_Pos           (22UL)                    /*!< GPIO INT0CLR: GPIO22 (Bit 22)                         */
#define GPIO_INT0CLR_GPIO22_Msk           (0x400000UL)              /*!< GPIO INT0CLR: GPIO22 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO21_Pos           (21UL)                    /*!< GPIO INT0CLR: GPIO21 (Bit 21)                         */
#define GPIO_INT0CLR_GPIO21_Msk           (0x200000UL)              /*!< GPIO INT0CLR: GPIO21 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO20_Pos           (20UL)                    /*!< GPIO INT0CLR: GPIO20 (Bit 20)                         */
#define GPIO_INT0CLR_GPIO20_Msk           (0x100000UL)              /*!< GPIO INT0CLR: GPIO20 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO19_Pos           (19UL)                    /*!< GPIO INT0CLR: GPIO19 (Bit 19)                         */
#define GPIO_INT0CLR_GPIO19_Msk           (0x80000UL)               /*!< GPIO INT0CLR: GPIO19 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO18_Pos           (18UL)                    /*!< GPIO INT0CLR: GPIO18 (Bit 18)                         */
#define GPIO_INT0CLR_GPIO18_Msk           (0x40000UL)               /*!< GPIO INT0CLR: GPIO18 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO17_Pos           (17UL)                    /*!< GPIO INT0CLR: GPIO17 (Bit 17)                         */
#define GPIO_INT0CLR_GPIO17_Msk           (0x20000UL)               /*!< GPIO INT0CLR: GPIO17 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO16_Pos           (16UL)                    /*!< GPIO INT0CLR: GPIO16 (Bit 16)                         */
#define GPIO_INT0CLR_GPIO16_Msk           (0x10000UL)               /*!< GPIO INT0CLR: GPIO16 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO15_Pos           (15UL)                    /*!< GPIO INT0CLR: GPIO15 (Bit 15)                         */
#define GPIO_INT0CLR_GPIO15_Msk           (0x8000UL)                /*!< GPIO INT0CLR: GPIO15 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO14_Pos           (14UL)                    /*!< GPIO INT0CLR: GPIO14 (Bit 14)                         */
#define GPIO_INT0CLR_GPIO14_Msk           (0x4000UL)                /*!< GPIO INT0CLR: GPIO14 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO13_Pos           (13UL)                    /*!< GPIO INT0CLR: GPIO13 (Bit 13)                         */
#define GPIO_INT0CLR_GPIO13_Msk           (0x2000UL)                /*!< GPIO INT0CLR: GPIO13 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO12_Pos           (12UL)                    /*!< GPIO INT0CLR: GPIO12 (Bit 12)                         */
#define GPIO_INT0CLR_GPIO12_Msk           (0x1000UL)                /*!< GPIO INT0CLR: GPIO12 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO11_Pos           (11UL)                    /*!< GPIO INT0CLR: GPIO11 (Bit 11)                         */
#define GPIO_INT0CLR_GPIO11_Msk           (0x800UL)                 /*!< GPIO INT0CLR: GPIO11 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO10_Pos           (10UL)                    /*!< GPIO INT0CLR: GPIO10 (Bit 10)                         */
#define GPIO_INT0CLR_GPIO10_Msk           (0x400UL)                 /*!< GPIO INT0CLR: GPIO10 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO9_Pos            (9UL)                     /*!< GPIO INT0CLR: GPIO9 (Bit 9)                           */
#define GPIO_INT0CLR_GPIO9_Msk            (0x200UL)                 /*!< GPIO INT0CLR: GPIO9 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO8_Pos            (8UL)                     /*!< GPIO INT0CLR: GPIO8 (Bit 8)                           */
#define GPIO_INT0CLR_GPIO8_Msk            (0x100UL)                 /*!< GPIO INT0CLR: GPIO8 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO7_Pos            (7UL)                     /*!< GPIO INT0CLR: GPIO7 (Bit 7)                           */
#define GPIO_INT0CLR_GPIO7_Msk            (0x80UL)                  /*!< GPIO INT0CLR: GPIO7 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO6_Pos            (6UL)                     /*!< GPIO INT0CLR: GPIO6 (Bit 6)                           */
#define GPIO_INT0CLR_GPIO6_Msk            (0x40UL)                  /*!< GPIO INT0CLR: GPIO6 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO5_Pos            (5UL)                     /*!< GPIO INT0CLR: GPIO5 (Bit 5)                           */
#define GPIO_INT0CLR_GPIO5_Msk            (0x20UL)                  /*!< GPIO INT0CLR: GPIO5 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO4_Pos            (4UL)                     /*!< GPIO INT0CLR: GPIO4 (Bit 4)                           */
#define GPIO_INT0CLR_GPIO4_Msk            (0x10UL)                  /*!< GPIO INT0CLR: GPIO4 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO3_Pos            (3UL)                     /*!< GPIO INT0CLR: GPIO3 (Bit 3)                           */
#define GPIO_INT0CLR_GPIO3_Msk            (0x8UL)                   /*!< GPIO INT0CLR: GPIO3 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO2_Pos            (2UL)                     /*!< GPIO INT0CLR: GPIO2 (Bit 2)                           */
#define GPIO_INT0CLR_GPIO2_Msk            (0x4UL)                   /*!< GPIO INT0CLR: GPIO2 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO1_Pos            (1UL)                     /*!< GPIO INT0CLR: GPIO1 (Bit 1)                           */
#define GPIO_INT0CLR_GPIO1_Msk            (0x2UL)                   /*!< GPIO INT0CLR: GPIO1 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO0_Pos            (0UL)                     /*!< GPIO INT0CLR: GPIO0 (Bit 0)                           */
#define GPIO_INT0CLR_GPIO0_Msk            (0x1UL)                   /*!< GPIO INT0CLR: GPIO0 (Bitfield-Mask: 0x01)             */
/* ========================================================  INT0SET  ======================================================== */
#define GPIO_INT0SET_GPIO31_Pos           (31UL)                    /*!< GPIO INT0SET: GPIO31 (Bit 31)                         */
#define GPIO_INT0SET_GPIO31_Msk           (0x80000000UL)            /*!< GPIO INT0SET: GPIO31 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO30_Pos           (30UL)                    /*!< GPIO INT0SET: GPIO30 (Bit 30)                         */
#define GPIO_INT0SET_GPIO30_Msk           (0x40000000UL)            /*!< GPIO INT0SET: GPIO30 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO29_Pos           (29UL)                    /*!< GPIO INT0SET: GPIO29 (Bit 29)                         */
#define GPIO_INT0SET_GPIO29_Msk           (0x20000000UL)            /*!< GPIO INT0SET: GPIO29 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO28_Pos           (28UL)                    /*!< GPIO INT0SET: GPIO28 (Bit 28)                         */
#define GPIO_INT0SET_GPIO28_Msk           (0x10000000UL)            /*!< GPIO INT0SET: GPIO28 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO27_Pos           (27UL)                    /*!< GPIO INT0SET: GPIO27 (Bit 27)                         */
#define GPIO_INT0SET_GPIO27_Msk           (0x8000000UL)             /*!< GPIO INT0SET: GPIO27 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO26_Pos           (26UL)                    /*!< GPIO INT0SET: GPIO26 (Bit 26)                         */
#define GPIO_INT0SET_GPIO26_Msk           (0x4000000UL)             /*!< GPIO INT0SET: GPIO26 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO25_Pos           (25UL)                    /*!< GPIO INT0SET: GPIO25 (Bit 25)                         */
#define GPIO_INT0SET_GPIO25_Msk           (0x2000000UL)             /*!< GPIO INT0SET: GPIO25 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO24_Pos           (24UL)                    /*!< GPIO INT0SET: GPIO24 (Bit 24)                         */
#define GPIO_INT0SET_GPIO24_Msk           (0x1000000UL)             /*!< GPIO INT0SET: GPIO24 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO23_Pos           (23UL)                    /*!< GPIO INT0SET: GPIO23 (Bit 23)                         */
#define GPIO_INT0SET_GPIO23_Msk           (0x800000UL)              /*!< GPIO INT0SET: GPIO23 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO22_Pos           (22UL)                    /*!< GPIO INT0SET: GPIO22 (Bit 22)                         */
#define GPIO_INT0SET_GPIO22_Msk           (0x400000UL)              /*!< GPIO INT0SET: GPIO22 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO21_Pos           (21UL)                    /*!< GPIO INT0SET: GPIO21 (Bit 21)                         */
#define GPIO_INT0SET_GPIO21_Msk           (0x200000UL)              /*!< GPIO INT0SET: GPIO21 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO20_Pos           (20UL)                    /*!< GPIO INT0SET: GPIO20 (Bit 20)                         */
#define GPIO_INT0SET_GPIO20_Msk           (0x100000UL)              /*!< GPIO INT0SET: GPIO20 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO19_Pos           (19UL)                    /*!< GPIO INT0SET: GPIO19 (Bit 19)                         */
#define GPIO_INT0SET_GPIO19_Msk           (0x80000UL)               /*!< GPIO INT0SET: GPIO19 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO18_Pos           (18UL)                    /*!< GPIO INT0SET: GPIO18 (Bit 18)                         */
#define GPIO_INT0SET_GPIO18_Msk           (0x40000UL)               /*!< GPIO INT0SET: GPIO18 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO17_Pos           (17UL)                    /*!< GPIO INT0SET: GPIO17 (Bit 17)                         */
#define GPIO_INT0SET_GPIO17_Msk           (0x20000UL)               /*!< GPIO INT0SET: GPIO17 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO16_Pos           (16UL)                    /*!< GPIO INT0SET: GPIO16 (Bit 16)                         */
#define GPIO_INT0SET_GPIO16_Msk           (0x10000UL)               /*!< GPIO INT0SET: GPIO16 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO15_Pos           (15UL)                    /*!< GPIO INT0SET: GPIO15 (Bit 15)                         */
#define GPIO_INT0SET_GPIO15_Msk           (0x8000UL)                /*!< GPIO INT0SET: GPIO15 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO14_Pos           (14UL)                    /*!< GPIO INT0SET: GPIO14 (Bit 14)                         */
#define GPIO_INT0SET_GPIO14_Msk           (0x4000UL)                /*!< GPIO INT0SET: GPIO14 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO13_Pos           (13UL)                    /*!< GPIO INT0SET: GPIO13 (Bit 13)                         */
#define GPIO_INT0SET_GPIO13_Msk           (0x2000UL)                /*!< GPIO INT0SET: GPIO13 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO12_Pos           (12UL)                    /*!< GPIO INT0SET: GPIO12 (Bit 12)                         */
#define GPIO_INT0SET_GPIO12_Msk           (0x1000UL)                /*!< GPIO INT0SET: GPIO12 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO11_Pos           (11UL)                    /*!< GPIO INT0SET: GPIO11 (Bit 11)                         */
#define GPIO_INT0SET_GPIO11_Msk           (0x800UL)                 /*!< GPIO INT0SET: GPIO11 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO10_Pos           (10UL)                    /*!< GPIO INT0SET: GPIO10 (Bit 10)                         */
#define GPIO_INT0SET_GPIO10_Msk           (0x400UL)                 /*!< GPIO INT0SET: GPIO10 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO9_Pos            (9UL)                     /*!< GPIO INT0SET: GPIO9 (Bit 9)                           */
#define GPIO_INT0SET_GPIO9_Msk            (0x200UL)                 /*!< GPIO INT0SET: GPIO9 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO8_Pos            (8UL)                     /*!< GPIO INT0SET: GPIO8 (Bit 8)                           */
#define GPIO_INT0SET_GPIO8_Msk            (0x100UL)                 /*!< GPIO INT0SET: GPIO8 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO7_Pos            (7UL)                     /*!< GPIO INT0SET: GPIO7 (Bit 7)                           */
#define GPIO_INT0SET_GPIO7_Msk            (0x80UL)                  /*!< GPIO INT0SET: GPIO7 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO6_Pos            (6UL)                     /*!< GPIO INT0SET: GPIO6 (Bit 6)                           */
#define GPIO_INT0SET_GPIO6_Msk            (0x40UL)                  /*!< GPIO INT0SET: GPIO6 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO5_Pos            (5UL)                     /*!< GPIO INT0SET: GPIO5 (Bit 5)                           */
#define GPIO_INT0SET_GPIO5_Msk            (0x20UL)                  /*!< GPIO INT0SET: GPIO5 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO4_Pos            (4UL)                     /*!< GPIO INT0SET: GPIO4 (Bit 4)                           */
#define GPIO_INT0SET_GPIO4_Msk            (0x10UL)                  /*!< GPIO INT0SET: GPIO4 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO3_Pos            (3UL)                     /*!< GPIO INT0SET: GPIO3 (Bit 3)                           */
#define GPIO_INT0SET_GPIO3_Msk            (0x8UL)                   /*!< GPIO INT0SET: GPIO3 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO2_Pos            (2UL)                     /*!< GPIO INT0SET: GPIO2 (Bit 2)                           */
#define GPIO_INT0SET_GPIO2_Msk            (0x4UL)                   /*!< GPIO INT0SET: GPIO2 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO1_Pos            (1UL)                     /*!< GPIO INT0SET: GPIO1 (Bit 1)                           */
#define GPIO_INT0SET_GPIO1_Msk            (0x2UL)                   /*!< GPIO INT0SET: GPIO1 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO0_Pos            (0UL)                     /*!< GPIO INT0SET: GPIO0 (Bit 0)                           */
#define GPIO_INT0SET_GPIO0_Msk            (0x1UL)                   /*!< GPIO INT0SET: GPIO0 (Bitfield-Mask: 0x01)             */
/* ========================================================  INT1EN  ========================================================= */
#define GPIO_INT1EN_GPIO49_Pos            (17UL)                    /*!< GPIO INT1EN: GPIO49 (Bit 17)                          */
#define GPIO_INT1EN_GPIO49_Msk            (0x20000UL)               /*!< GPIO INT1EN: GPIO49 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO48_Pos            (16UL)                    /*!< GPIO INT1EN: GPIO48 (Bit 16)                          */
#define GPIO_INT1EN_GPIO48_Msk            (0x10000UL)               /*!< GPIO INT1EN: GPIO48 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO47_Pos            (15UL)                    /*!< GPIO INT1EN: GPIO47 (Bit 15)                          */
#define GPIO_INT1EN_GPIO47_Msk            (0x8000UL)                /*!< GPIO INT1EN: GPIO47 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO46_Pos            (14UL)                    /*!< GPIO INT1EN: GPIO46 (Bit 14)                          */
#define GPIO_INT1EN_GPIO46_Msk            (0x4000UL)                /*!< GPIO INT1EN: GPIO46 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO45_Pos            (13UL)                    /*!< GPIO INT1EN: GPIO45 (Bit 13)                          */
#define GPIO_INT1EN_GPIO45_Msk            (0x2000UL)                /*!< GPIO INT1EN: GPIO45 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO44_Pos            (12UL)                    /*!< GPIO INT1EN: GPIO44 (Bit 12)                          */
#define GPIO_INT1EN_GPIO44_Msk            (0x1000UL)                /*!< GPIO INT1EN: GPIO44 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO43_Pos            (11UL)                    /*!< GPIO INT1EN: GPIO43 (Bit 11)                          */
#define GPIO_INT1EN_GPIO43_Msk            (0x800UL)                 /*!< GPIO INT1EN: GPIO43 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO42_Pos            (10UL)                    /*!< GPIO INT1EN: GPIO42 (Bit 10)                          */
#define GPIO_INT1EN_GPIO42_Msk            (0x400UL)                 /*!< GPIO INT1EN: GPIO42 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO41_Pos            (9UL)                     /*!< GPIO INT1EN: GPIO41 (Bit 9)                           */
#define GPIO_INT1EN_GPIO41_Msk            (0x200UL)                 /*!< GPIO INT1EN: GPIO41 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO40_Pos            (8UL)                     /*!< GPIO INT1EN: GPIO40 (Bit 8)                           */
#define GPIO_INT1EN_GPIO40_Msk            (0x100UL)                 /*!< GPIO INT1EN: GPIO40 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO39_Pos            (7UL)                     /*!< GPIO INT1EN: GPIO39 (Bit 7)                           */
#define GPIO_INT1EN_GPIO39_Msk            (0x80UL)                  /*!< GPIO INT1EN: GPIO39 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO38_Pos            (6UL)                     /*!< GPIO INT1EN: GPIO38 (Bit 6)                           */
#define GPIO_INT1EN_GPIO38_Msk            (0x40UL)                  /*!< GPIO INT1EN: GPIO38 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO37_Pos            (5UL)                     /*!< GPIO INT1EN: GPIO37 (Bit 5)                           */
#define GPIO_INT1EN_GPIO37_Msk            (0x20UL)                  /*!< GPIO INT1EN: GPIO37 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO36_Pos            (4UL)                     /*!< GPIO INT1EN: GPIO36 (Bit 4)                           */
#define GPIO_INT1EN_GPIO36_Msk            (0x10UL)                  /*!< GPIO INT1EN: GPIO36 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO35_Pos            (3UL)                     /*!< GPIO INT1EN: GPIO35 (Bit 3)                           */
#define GPIO_INT1EN_GPIO35_Msk            (0x8UL)                   /*!< GPIO INT1EN: GPIO35 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO34_Pos            (2UL)                     /*!< GPIO INT1EN: GPIO34 (Bit 2)                           */
#define GPIO_INT1EN_GPIO34_Msk            (0x4UL)                   /*!< GPIO INT1EN: GPIO34 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO33_Pos            (1UL)                     /*!< GPIO INT1EN: GPIO33 (Bit 1)                           */
#define GPIO_INT1EN_GPIO33_Msk            (0x2UL)                   /*!< GPIO INT1EN: GPIO33 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO32_Pos            (0UL)                     /*!< GPIO INT1EN: GPIO32 (Bit 0)                           */
#define GPIO_INT1EN_GPIO32_Msk            (0x1UL)                   /*!< GPIO INT1EN: GPIO32 (Bitfield-Mask: 0x01)             */
/* =======================================================  INT1STAT  ======================================================== */
#define GPIO_INT1STAT_GPIO49_Pos          (17UL)                    /*!< GPIO INT1STAT: GPIO49 (Bit 17)                        */
#define GPIO_INT1STAT_GPIO49_Msk          (0x20000UL)               /*!< GPIO INT1STAT: GPIO49 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO48_Pos          (16UL)                    /*!< GPIO INT1STAT: GPIO48 (Bit 16)                        */
#define GPIO_INT1STAT_GPIO48_Msk          (0x10000UL)               /*!< GPIO INT1STAT: GPIO48 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO47_Pos          (15UL)                    /*!< GPIO INT1STAT: GPIO47 (Bit 15)                        */
#define GPIO_INT1STAT_GPIO47_Msk          (0x8000UL)                /*!< GPIO INT1STAT: GPIO47 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO46_Pos          (14UL)                    /*!< GPIO INT1STAT: GPIO46 (Bit 14)                        */
#define GPIO_INT1STAT_GPIO46_Msk          (0x4000UL)                /*!< GPIO INT1STAT: GPIO46 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO45_Pos          (13UL)                    /*!< GPIO INT1STAT: GPIO45 (Bit 13)                        */
#define GPIO_INT1STAT_GPIO45_Msk          (0x2000UL)                /*!< GPIO INT1STAT: GPIO45 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO44_Pos          (12UL)                    /*!< GPIO INT1STAT: GPIO44 (Bit 12)                        */
#define GPIO_INT1STAT_GPIO44_Msk          (0x1000UL)                /*!< GPIO INT1STAT: GPIO44 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO43_Pos          (11UL)                    /*!< GPIO INT1STAT: GPIO43 (Bit 11)                        */
#define GPIO_INT1STAT_GPIO43_Msk          (0x800UL)                 /*!< GPIO INT1STAT: GPIO43 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO42_Pos          (10UL)                    /*!< GPIO INT1STAT: GPIO42 (Bit 10)                        */
#define GPIO_INT1STAT_GPIO42_Msk          (0x400UL)                 /*!< GPIO INT1STAT: GPIO42 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO41_Pos          (9UL)                     /*!< GPIO INT1STAT: GPIO41 (Bit 9)                         */
#define GPIO_INT1STAT_GPIO41_Msk          (0x200UL)                 /*!< GPIO INT1STAT: GPIO41 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO40_Pos          (8UL)                     /*!< GPIO INT1STAT: GPIO40 (Bit 8)                         */
#define GPIO_INT1STAT_GPIO40_Msk          (0x100UL)                 /*!< GPIO INT1STAT: GPIO40 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO39_Pos          (7UL)                     /*!< GPIO INT1STAT: GPIO39 (Bit 7)                         */
#define GPIO_INT1STAT_GPIO39_Msk          (0x80UL)                  /*!< GPIO INT1STAT: GPIO39 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO38_Pos          (6UL)                     /*!< GPIO INT1STAT: GPIO38 (Bit 6)                         */
#define GPIO_INT1STAT_GPIO38_Msk          (0x40UL)                  /*!< GPIO INT1STAT: GPIO38 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO37_Pos          (5UL)                     /*!< GPIO INT1STAT: GPIO37 (Bit 5)                         */
#define GPIO_INT1STAT_GPIO37_Msk          (0x20UL)                  /*!< GPIO INT1STAT: GPIO37 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO36_Pos          (4UL)                     /*!< GPIO INT1STAT: GPIO36 (Bit 4)                         */
#define GPIO_INT1STAT_GPIO36_Msk          (0x10UL)                  /*!< GPIO INT1STAT: GPIO36 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO35_Pos          (3UL)                     /*!< GPIO INT1STAT: GPIO35 (Bit 3)                         */
#define GPIO_INT1STAT_GPIO35_Msk          (0x8UL)                   /*!< GPIO INT1STAT: GPIO35 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO34_Pos          (2UL)                     /*!< GPIO INT1STAT: GPIO34 (Bit 2)                         */
#define GPIO_INT1STAT_GPIO34_Msk          (0x4UL)                   /*!< GPIO INT1STAT: GPIO34 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO33_Pos          (1UL)                     /*!< GPIO INT1STAT: GPIO33 (Bit 1)                         */
#define GPIO_INT1STAT_GPIO33_Msk          (0x2UL)                   /*!< GPIO INT1STAT: GPIO33 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO32_Pos          (0UL)                     /*!< GPIO INT1STAT: GPIO32 (Bit 0)                         */
#define GPIO_INT1STAT_GPIO32_Msk          (0x1UL)                   /*!< GPIO INT1STAT: GPIO32 (Bitfield-Mask: 0x01)           */
/* ========================================================  INT1CLR  ======================================================== */
#define GPIO_INT1CLR_GPIO49_Pos           (17UL)                    /*!< GPIO INT1CLR: GPIO49 (Bit 17)                         */
#define GPIO_INT1CLR_GPIO49_Msk           (0x20000UL)               /*!< GPIO INT1CLR: GPIO49 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO48_Pos           (16UL)                    /*!< GPIO INT1CLR: GPIO48 (Bit 16)                         */
#define GPIO_INT1CLR_GPIO48_Msk           (0x10000UL)               /*!< GPIO INT1CLR: GPIO48 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO47_Pos           (15UL)                    /*!< GPIO INT1CLR: GPIO47 (Bit 15)                         */
#define GPIO_INT1CLR_GPIO47_Msk           (0x8000UL)                /*!< GPIO INT1CLR: GPIO47 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO46_Pos           (14UL)                    /*!< GPIO INT1CLR: GPIO46 (Bit 14)                         */
#define GPIO_INT1CLR_GPIO46_Msk           (0x4000UL)                /*!< GPIO INT1CLR: GPIO46 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO45_Pos           (13UL)                    /*!< GPIO INT1CLR: GPIO45 (Bit 13)                         */
#define GPIO_INT1CLR_GPIO45_Msk           (0x2000UL)                /*!< GPIO INT1CLR: GPIO45 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO44_Pos           (12UL)                    /*!< GPIO INT1CLR: GPIO44 (Bit 12)                         */
#define GPIO_INT1CLR_GPIO44_Msk           (0x1000UL)                /*!< GPIO INT1CLR: GPIO44 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO43_Pos           (11UL)                    /*!< GPIO INT1CLR: GPIO43 (Bit 11)                         */
#define GPIO_INT1CLR_GPIO43_Msk           (0x800UL)                 /*!< GPIO INT1CLR: GPIO43 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO42_Pos           (10UL)                    /*!< GPIO INT1CLR: GPIO42 (Bit 10)                         */
#define GPIO_INT1CLR_GPIO42_Msk           (0x400UL)                 /*!< GPIO INT1CLR: GPIO42 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO41_Pos           (9UL)                     /*!< GPIO INT1CLR: GPIO41 (Bit 9)                          */
#define GPIO_INT1CLR_GPIO41_Msk           (0x200UL)                 /*!< GPIO INT1CLR: GPIO41 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO40_Pos           (8UL)                     /*!< GPIO INT1CLR: GPIO40 (Bit 8)                          */
#define GPIO_INT1CLR_GPIO40_Msk           (0x100UL)                 /*!< GPIO INT1CLR: GPIO40 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO39_Pos           (7UL)                     /*!< GPIO INT1CLR: GPIO39 (Bit 7)                          */
#define GPIO_INT1CLR_GPIO39_Msk           (0x80UL)                  /*!< GPIO INT1CLR: GPIO39 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO38_Pos           (6UL)                     /*!< GPIO INT1CLR: GPIO38 (Bit 6)                          */
#define GPIO_INT1CLR_GPIO38_Msk           (0x40UL)                  /*!< GPIO INT1CLR: GPIO38 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO37_Pos           (5UL)                     /*!< GPIO INT1CLR: GPIO37 (Bit 5)                          */
#define GPIO_INT1CLR_GPIO37_Msk           (0x20UL)                  /*!< GPIO INT1CLR: GPIO37 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO36_Pos           (4UL)                     /*!< GPIO INT1CLR: GPIO36 (Bit 4)                          */
#define GPIO_INT1CLR_GPIO36_Msk           (0x10UL)                  /*!< GPIO INT1CLR: GPIO36 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO35_Pos           (3UL)                     /*!< GPIO INT1CLR: GPIO35 (Bit 3)                          */
#define GPIO_INT1CLR_GPIO35_Msk           (0x8UL)                   /*!< GPIO INT1CLR: GPIO35 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO34_Pos           (2UL)                     /*!< GPIO INT1CLR: GPIO34 (Bit 2)                          */
#define GPIO_INT1CLR_GPIO34_Msk           (0x4UL)                   /*!< GPIO INT1CLR: GPIO34 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO33_Pos           (1UL)                     /*!< GPIO INT1CLR: GPIO33 (Bit 1)                          */
#define GPIO_INT1CLR_GPIO33_Msk           (0x2UL)                   /*!< GPIO INT1CLR: GPIO33 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO32_Pos           (0UL)                     /*!< GPIO INT1CLR: GPIO32 (Bit 0)                          */
#define GPIO_INT1CLR_GPIO32_Msk           (0x1UL)                   /*!< GPIO INT1CLR: GPIO32 (Bitfield-Mask: 0x01)            */
/* ========================================================  INT1SET  ======================================================== */
#define GPIO_INT1SET_GPIO49_Pos           (17UL)                    /*!< GPIO INT1SET: GPIO49 (Bit 17)                         */
#define GPIO_INT1SET_GPIO49_Msk           (0x20000UL)               /*!< GPIO INT1SET: GPIO49 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO48_Pos           (16UL)                    /*!< GPIO INT1SET: GPIO48 (Bit 16)                         */
#define GPIO_INT1SET_GPIO48_Msk           (0x10000UL)               /*!< GPIO INT1SET: GPIO48 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO47_Pos           (15UL)                    /*!< GPIO INT1SET: GPIO47 (Bit 15)                         */
#define GPIO_INT1SET_GPIO47_Msk           (0x8000UL)                /*!< GPIO INT1SET: GPIO47 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO46_Pos           (14UL)                    /*!< GPIO INT1SET: GPIO46 (Bit 14)                         */
#define GPIO_INT1SET_GPIO46_Msk           (0x4000UL)                /*!< GPIO INT1SET: GPIO46 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO45_Pos           (13UL)                    /*!< GPIO INT1SET: GPIO45 (Bit 13)                         */
#define GPIO_INT1SET_GPIO45_Msk           (0x2000UL)                /*!< GPIO INT1SET: GPIO45 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO44_Pos           (12UL)                    /*!< GPIO INT1SET: GPIO44 (Bit 12)                         */
#define GPIO_INT1SET_GPIO44_Msk           (0x1000UL)                /*!< GPIO INT1SET: GPIO44 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO43_Pos           (11UL)                    /*!< GPIO INT1SET: GPIO43 (Bit 11)                         */
#define GPIO_INT1SET_GPIO43_Msk           (0x800UL)                 /*!< GPIO INT1SET: GPIO43 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO42_Pos           (10UL)                    /*!< GPIO INT1SET: GPIO42 (Bit 10)                         */
#define GPIO_INT1SET_GPIO42_Msk           (0x400UL)                 /*!< GPIO INT1SET: GPIO42 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO41_Pos           (9UL)                     /*!< GPIO INT1SET: GPIO41 (Bit 9)                          */
#define GPIO_INT1SET_GPIO41_Msk           (0x200UL)                 /*!< GPIO INT1SET: GPIO41 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO40_Pos           (8UL)                     /*!< GPIO INT1SET: GPIO40 (Bit 8)                          */
#define GPIO_INT1SET_GPIO40_Msk           (0x100UL)                 /*!< GPIO INT1SET: GPIO40 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO39_Pos           (7UL)                     /*!< GPIO INT1SET: GPIO39 (Bit 7)                          */
#define GPIO_INT1SET_GPIO39_Msk           (0x80UL)                  /*!< GPIO INT1SET: GPIO39 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO38_Pos           (6UL)                     /*!< GPIO INT1SET: GPIO38 (Bit 6)                          */
#define GPIO_INT1SET_GPIO38_Msk           (0x40UL)                  /*!< GPIO INT1SET: GPIO38 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO37_Pos           (5UL)                     /*!< GPIO INT1SET: GPIO37 (Bit 5)                          */
#define GPIO_INT1SET_GPIO37_Msk           (0x20UL)                  /*!< GPIO INT1SET: GPIO37 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO36_Pos           (4UL)                     /*!< GPIO INT1SET: GPIO36 (Bit 4)                          */
#define GPIO_INT1SET_GPIO36_Msk           (0x10UL)                  /*!< GPIO INT1SET: GPIO36 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO35_Pos           (3UL)                     /*!< GPIO INT1SET: GPIO35 (Bit 3)                          */
#define GPIO_INT1SET_GPIO35_Msk           (0x8UL)                   /*!< GPIO INT1SET: GPIO35 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO34_Pos           (2UL)                     /*!< GPIO INT1SET: GPIO34 (Bit 2)                          */
#define GPIO_INT1SET_GPIO34_Msk           (0x4UL)                   /*!< GPIO INT1SET: GPIO34 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO33_Pos           (1UL)                     /*!< GPIO INT1SET: GPIO33 (Bit 1)                          */
#define GPIO_INT1SET_GPIO33_Msk           (0x2UL)                   /*!< GPIO INT1SET: GPIO33 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO32_Pos           (0UL)                     /*!< GPIO INT1SET: GPIO32 (Bit 0)                          */
#define GPIO_INT1SET_GPIO32_Msk           (0x1UL)                   /*!< GPIO INT1SET: GPIO32 (Bitfield-Mask: 0x01)            */


/* =========================================================================================================================== */
/* ================                                          IOMSTR0                                          ================ */
/* =========================================================================================================================== */

/* =========================================================  FIFO  ========================================================== */
#define IOMSTR0_FIFO_FIFO_Pos             (0UL)                     /*!< IOMSTR0 FIFO: FIFO (Bit 0)                            */
#define IOMSTR0_FIFO_FIFO_Msk             (0xffffffffUL)            /*!< IOMSTR0 FIFO: FIFO (Bitfield-Mask: 0xffffffff)        */
/* ========================================================  FIFOPTR  ======================================================== */
#define IOMSTR0_FIFOPTR_FIFOREM_Pos       (16UL)                    /*!< IOMSTR0 FIFOPTR: FIFOREM (Bit 16)                     */
#define IOMSTR0_FIFOPTR_FIFOREM_Msk       (0xff0000UL)              /*!< IOMSTR0 FIFOPTR: FIFOREM (Bitfield-Mask: 0xff)        */
#define IOMSTR0_FIFOPTR_FIFOSIZ_Pos       (0UL)                     /*!< IOMSTR0 FIFOPTR: FIFOSIZ (Bit 0)                      */
#define IOMSTR0_FIFOPTR_FIFOSIZ_Msk       (0xffUL)                  /*!< IOMSTR0 FIFOPTR: FIFOSIZ (Bitfield-Mask: 0xff)        */
/* ========================================================  TLNGTH  ========================================================= */
#define IOMSTR0_TLNGTH_TLNGTH_Pos         (0UL)                     /*!< IOMSTR0 TLNGTH: TLNGTH (Bit 0)                        */
#define IOMSTR0_TLNGTH_TLNGTH_Msk         (0xfffUL)                 /*!< IOMSTR0 TLNGTH: TLNGTH (Bitfield-Mask: 0xfff)         */
/* ========================================================  FIFOTHR  ======================================================== */
#define IOMSTR0_FIFOTHR_FIFOWTHR_Pos      (8UL)                     /*!< IOMSTR0 FIFOTHR: FIFOWTHR (Bit 8)                     */
#define IOMSTR0_FIFOTHR_FIFOWTHR_Msk      (0x7f00UL)                /*!< IOMSTR0 FIFOTHR: FIFOWTHR (Bitfield-Mask: 0x7f)       */
#define IOMSTR0_FIFOTHR_FIFORTHR_Pos      (0UL)                     /*!< IOMSTR0 FIFOTHR: FIFORTHR (Bit 0)                     */
#define IOMSTR0_FIFOTHR_FIFORTHR_Msk      (0x7fUL)                  /*!< IOMSTR0 FIFOTHR: FIFORTHR (Bitfield-Mask: 0x7f)       */
/* ========================================================  CLKCFG  ========================================================= */
#define IOMSTR0_CLKCFG_TOTPER_Pos         (24UL)                    /*!< IOMSTR0 CLKCFG: TOTPER (Bit 24)                       */
#define IOMSTR0_CLKCFG_TOTPER_Msk         (0xff000000UL)            /*!< IOMSTR0 CLKCFG: TOTPER (Bitfield-Mask: 0xff)          */
#define IOMSTR0_CLKCFG_LOWPER_Pos         (16UL)                    /*!< IOMSTR0 CLKCFG: LOWPER (Bit 16)                       */
#define IOMSTR0_CLKCFG_LOWPER_Msk         (0xff0000UL)              /*!< IOMSTR0 CLKCFG: LOWPER (Bitfield-Mask: 0xff)          */
#define IOMSTR0_CLKCFG_DIVEN_Pos          (12UL)                    /*!< IOMSTR0 CLKCFG: DIVEN (Bit 12)                        */
#define IOMSTR0_CLKCFG_DIVEN_Msk          (0x1000UL)                /*!< IOMSTR0 CLKCFG: DIVEN (Bitfield-Mask: 0x01)           */
#define IOMSTR0_CLKCFG_DIV3_Pos           (11UL)                    /*!< IOMSTR0 CLKCFG: DIV3 (Bit 11)                         */
#define IOMSTR0_CLKCFG_DIV3_Msk           (0x800UL)                 /*!< IOMSTR0 CLKCFG: DIV3 (Bitfield-Mask: 0x01)            */
#define IOMSTR0_CLKCFG_FSEL_Pos           (8UL)                     /*!< IOMSTR0 CLKCFG: FSEL (Bit 8)                          */
#define IOMSTR0_CLKCFG_FSEL_Msk           (0x700UL)                 /*!< IOMSTR0 CLKCFG: FSEL (Bitfield-Mask: 0x07)            */
/* ==========================================================  CMD  ========================================================== */
#define IOMSTR0_CMD_CMD_Pos               (0UL)                     /*!< IOMSTR0 CMD: CMD (Bit 0)                              */
#define IOMSTR0_CMD_CMD_Msk               (0xffffffffUL)            /*!< IOMSTR0 CMD: CMD (Bitfield-Mask: 0xffffffff)          */
/* ========================================================  CMDRPT  ========================================================= */
#define IOMSTR0_CMDRPT_CMDRPT_Pos         (0UL)                     /*!< IOMSTR0 CMDRPT: CMDRPT (Bit 0)                        */
#define IOMSTR0_CMDRPT_CMDRPT_Msk         (0x1fUL)                  /*!< IOMSTR0 CMDRPT: CMDRPT (Bitfield-Mask: 0x1f)          */
/* ========================================================  STATUS  ========================================================= */
#define IOMSTR0_STATUS_IDLEST_Pos         (2UL)                     /*!< IOMSTR0 STATUS: IDLEST (Bit 2)                        */
#define IOMSTR0_STATUS_IDLEST_Msk         (0x4UL)                   /*!< IOMSTR0 STATUS: IDLEST (Bitfield-Mask: 0x01)          */
#define IOMSTR0_STATUS_CMDACT_Pos         (1UL)                     /*!< IOMSTR0 STATUS: CMDACT (Bit 1)                        */
#define IOMSTR0_STATUS_CMDACT_Msk         (0x2UL)                   /*!< IOMSTR0 STATUS: CMDACT (Bitfield-Mask: 0x01)          */
#define IOMSTR0_STATUS_ERR_Pos            (0UL)                     /*!< IOMSTR0 STATUS: ERR (Bit 0)                           */
#define IOMSTR0_STATUS_ERR_Msk            (0x1UL)                   /*!< IOMSTR0 STATUS: ERR (Bitfield-Mask: 0x01)             */
/* ==========================================================  CFG  ========================================================== */
#define IOMSTR0_CFG_IFCEN_Pos             (31UL)                    /*!< IOMSTR0 CFG: IFCEN (Bit 31)                           */
#define IOMSTR0_CFG_IFCEN_Msk             (0x80000000UL)            /*!< IOMSTR0 CFG: IFCEN (Bitfield-Mask: 0x01)              */
#define IOMSTR0_CFG_RDFCPOL_Pos           (14UL)                    /*!< IOMSTR0 CFG: RDFCPOL (Bit 14)                         */
#define IOMSTR0_CFG_RDFCPOL_Msk           (0x4000UL)                /*!< IOMSTR0 CFG: RDFCPOL (Bitfield-Mask: 0x01)            */
#define IOMSTR0_CFG_WTFCPOL_Pos           (13UL)                    /*!< IOMSTR0 CFG: WTFCPOL (Bit 13)                         */
#define IOMSTR0_CFG_WTFCPOL_Msk           (0x2000UL)                /*!< IOMSTR0 CFG: WTFCPOL (Bitfield-Mask: 0x01)            */
#define IOMSTR0_CFG_WTFCIRQ_Pos           (12UL)                    /*!< IOMSTR0 CFG: WTFCIRQ (Bit 12)                         */
#define IOMSTR0_CFG_WTFCIRQ_Msk           (0x1000UL)                /*!< IOMSTR0 CFG: WTFCIRQ (Bitfield-Mask: 0x01)            */
#define IOMSTR0_CFG_FCDEL_Pos             (11UL)                    /*!< IOMSTR0 CFG: FCDEL (Bit 11)                           */
#define IOMSTR0_CFG_FCDEL_Msk             (0x800UL)                 /*!< IOMSTR0 CFG: FCDEL (Bitfield-Mask: 0x01)              */
#define IOMSTR0_CFG_MOSIINV_Pos           (10UL)                    /*!< IOMSTR0 CFG: MOSIINV (Bit 10)                         */
#define IOMSTR0_CFG_MOSIINV_Msk           (0x400UL)                 /*!< IOMSTR0 CFG: MOSIINV (Bitfield-Mask: 0x01)            */
#define IOMSTR0_CFG_RDFC_Pos              (9UL)                     /*!< IOMSTR0 CFG: RDFC (Bit 9)                             */
#define IOMSTR0_CFG_RDFC_Msk              (0x200UL)                 /*!< IOMSTR0 CFG: RDFC (Bitfield-Mask: 0x01)               */
#define IOMSTR0_CFG_WTFC_Pos              (8UL)                     /*!< IOMSTR0 CFG: WTFC (Bit 8)                             */
#define IOMSTR0_CFG_WTFC_Msk              (0x100UL)                 /*!< IOMSTR0 CFG: WTFC (Bitfield-Mask: 0x01)               */
#define IOMSTR0_CFG_STARTRD_Pos           (4UL)                     /*!< IOMSTR0 CFG: STARTRD (Bit 4)                          */
#define IOMSTR0_CFG_STARTRD_Msk           (0x30UL)                  /*!< IOMSTR0 CFG: STARTRD (Bitfield-Mask: 0x03)            */
#define IOMSTR0_CFG_FULLDUP_Pos           (3UL)                     /*!< IOMSTR0 CFG: FULLDUP (Bit 3)                          */
#define IOMSTR0_CFG_FULLDUP_Msk           (0x8UL)                   /*!< IOMSTR0 CFG: FULLDUP (Bitfield-Mask: 0x01)            */
#define IOMSTR0_CFG_SPHA_Pos              (2UL)                     /*!< IOMSTR0 CFG: SPHA (Bit 2)                             */
#define IOMSTR0_CFG_SPHA_Msk              (0x4UL)                   /*!< IOMSTR0 CFG: SPHA (Bitfield-Mask: 0x01)               */
#define IOMSTR0_CFG_SPOL_Pos              (1UL)                     /*!< IOMSTR0 CFG: SPOL (Bit 1)                             */
#define IOMSTR0_CFG_SPOL_Msk              (0x2UL)                   /*!< IOMSTR0 CFG: SPOL (Bitfield-Mask: 0x01)               */
#define IOMSTR0_CFG_IFCSEL_Pos            (0UL)                     /*!< IOMSTR0 CFG: IFCSEL (Bit 0)                           */
#define IOMSTR0_CFG_IFCSEL_Msk            (0x1UL)                   /*!< IOMSTR0 CFG: IFCSEL (Bitfield-Mask: 0x01)             */
/* =========================================================  INTEN  ========================================================= */
#define IOMSTR0_INTEN_ARB_Pos             (10UL)                    /*!< IOMSTR0 INTEN: ARB (Bit 10)                           */
#define IOMSTR0_INTEN_ARB_Msk             (0x400UL)                 /*!< IOMSTR0 INTEN: ARB (Bitfield-Mask: 0x01)              */
#define IOMSTR0_INTEN_STOP_Pos            (9UL)                     /*!< IOMSTR0 INTEN: STOP (Bit 9)                           */
#define IOMSTR0_INTEN_STOP_Msk            (0x200UL)                 /*!< IOMSTR0 INTEN: STOP (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTEN_START_Pos           (8UL)                     /*!< IOMSTR0 INTEN: START (Bit 8)                          */
#define IOMSTR0_INTEN_START_Msk           (0x100UL)                 /*!< IOMSTR0 INTEN: START (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTEN_ICMD_Pos            (7UL)                     /*!< IOMSTR0 INTEN: ICMD (Bit 7)                           */
#define IOMSTR0_INTEN_ICMD_Msk            (0x80UL)                  /*!< IOMSTR0 INTEN: ICMD (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTEN_IACC_Pos            (6UL)                     /*!< IOMSTR0 INTEN: IACC (Bit 6)                           */
#define IOMSTR0_INTEN_IACC_Msk            (0x40UL)                  /*!< IOMSTR0 INTEN: IACC (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTEN_WTLEN_Pos           (5UL)                     /*!< IOMSTR0 INTEN: WTLEN (Bit 5)                          */
#define IOMSTR0_INTEN_WTLEN_Msk           (0x20UL)                  /*!< IOMSTR0 INTEN: WTLEN (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTEN_NAK_Pos             (4UL)                     /*!< IOMSTR0 INTEN: NAK (Bit 4)                            */
#define IOMSTR0_INTEN_NAK_Msk             (0x10UL)                  /*!< IOMSTR0 INTEN: NAK (Bitfield-Mask: 0x01)              */
#define IOMSTR0_INTEN_FOVFL_Pos           (3UL)                     /*!< IOMSTR0 INTEN: FOVFL (Bit 3)                          */
#define IOMSTR0_INTEN_FOVFL_Msk           (0x8UL)                   /*!< IOMSTR0 INTEN: FOVFL (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTEN_FUNDFL_Pos          (2UL)                     /*!< IOMSTR0 INTEN: FUNDFL (Bit 2)                         */
#define IOMSTR0_INTEN_FUNDFL_Msk          (0x4UL)                   /*!< IOMSTR0 INTEN: FUNDFL (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTEN_THR_Pos             (1UL)                     /*!< IOMSTR0 INTEN: THR (Bit 1)                            */
#define IOMSTR0_INTEN_THR_Msk             (0x2UL)                   /*!< IOMSTR0 INTEN: THR (Bitfield-Mask: 0x01)              */
#define IOMSTR0_INTEN_CMDCMP_Pos          (0UL)                     /*!< IOMSTR0 INTEN: CMDCMP (Bit 0)                         */
#define IOMSTR0_INTEN_CMDCMP_Msk          (0x1UL)                   /*!< IOMSTR0 INTEN: CMDCMP (Bitfield-Mask: 0x01)           */
/* ========================================================  INTSTAT  ======================================================== */
#define IOMSTR0_INTSTAT_ARB_Pos           (10UL)                    /*!< IOMSTR0 INTSTAT: ARB (Bit 10)                         */
#define IOMSTR0_INTSTAT_ARB_Msk           (0x400UL)                 /*!< IOMSTR0 INTSTAT: ARB (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTSTAT_STOP_Pos          (9UL)                     /*!< IOMSTR0 INTSTAT: STOP (Bit 9)                         */
#define IOMSTR0_INTSTAT_STOP_Msk          (0x200UL)                 /*!< IOMSTR0 INTSTAT: STOP (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTSTAT_START_Pos         (8UL)                     /*!< IOMSTR0 INTSTAT: START (Bit 8)                        */
#define IOMSTR0_INTSTAT_START_Msk         (0x100UL)                 /*!< IOMSTR0 INTSTAT: START (Bitfield-Mask: 0x01)          */
#define IOMSTR0_INTSTAT_ICMD_Pos          (7UL)                     /*!< IOMSTR0 INTSTAT: ICMD (Bit 7)                         */
#define IOMSTR0_INTSTAT_ICMD_Msk          (0x80UL)                  /*!< IOMSTR0 INTSTAT: ICMD (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTSTAT_IACC_Pos          (6UL)                     /*!< IOMSTR0 INTSTAT: IACC (Bit 6)                         */
#define IOMSTR0_INTSTAT_IACC_Msk          (0x40UL)                  /*!< IOMSTR0 INTSTAT: IACC (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTSTAT_WTLEN_Pos         (5UL)                     /*!< IOMSTR0 INTSTAT: WTLEN (Bit 5)                        */
#define IOMSTR0_INTSTAT_WTLEN_Msk         (0x20UL)                  /*!< IOMSTR0 INTSTAT: WTLEN (Bitfield-Mask: 0x01)          */
#define IOMSTR0_INTSTAT_NAK_Pos           (4UL)                     /*!< IOMSTR0 INTSTAT: NAK (Bit 4)                          */
#define IOMSTR0_INTSTAT_NAK_Msk           (0x10UL)                  /*!< IOMSTR0 INTSTAT: NAK (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTSTAT_FOVFL_Pos         (3UL)                     /*!< IOMSTR0 INTSTAT: FOVFL (Bit 3)                        */
#define IOMSTR0_INTSTAT_FOVFL_Msk         (0x8UL)                   /*!< IOMSTR0 INTSTAT: FOVFL (Bitfield-Mask: 0x01)          */
#define IOMSTR0_INTSTAT_FUNDFL_Pos        (2UL)                     /*!< IOMSTR0 INTSTAT: FUNDFL (Bit 2)                       */
#define IOMSTR0_INTSTAT_FUNDFL_Msk        (0x4UL)                   /*!< IOMSTR0 INTSTAT: FUNDFL (Bitfield-Mask: 0x01)         */
#define IOMSTR0_INTSTAT_THR_Pos           (1UL)                     /*!< IOMSTR0 INTSTAT: THR (Bit 1)                          */
#define IOMSTR0_INTSTAT_THR_Msk           (0x2UL)                   /*!< IOMSTR0 INTSTAT: THR (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTSTAT_CMDCMP_Pos        (0UL)                     /*!< IOMSTR0 INTSTAT: CMDCMP (Bit 0)                       */
#define IOMSTR0_INTSTAT_CMDCMP_Msk        (0x1UL)                   /*!< IOMSTR0 INTSTAT: CMDCMP (Bitfield-Mask: 0x01)         */
/* ========================================================  INTCLR  ========================================================= */
#define IOMSTR0_INTCLR_ARB_Pos            (10UL)                    /*!< IOMSTR0 INTCLR: ARB (Bit 10)                          */
#define IOMSTR0_INTCLR_ARB_Msk            (0x400UL)                 /*!< IOMSTR0 INTCLR: ARB (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTCLR_STOP_Pos           (9UL)                     /*!< IOMSTR0 INTCLR: STOP (Bit 9)                          */
#define IOMSTR0_INTCLR_STOP_Msk           (0x200UL)                 /*!< IOMSTR0 INTCLR: STOP (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTCLR_START_Pos          (8UL)                     /*!< IOMSTR0 INTCLR: START (Bit 8)                         */
#define IOMSTR0_INTCLR_START_Msk          (0x100UL)                 /*!< IOMSTR0 INTCLR: START (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTCLR_ICMD_Pos           (7UL)                     /*!< IOMSTR0 INTCLR: ICMD (Bit 7)                          */
#define IOMSTR0_INTCLR_ICMD_Msk           (0x80UL)                  /*!< IOMSTR0 INTCLR: ICMD (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTCLR_IACC_Pos           (6UL)                     /*!< IOMSTR0 INTCLR: IACC (Bit 6)                          */
#define IOMSTR0_INTCLR_IACC_Msk           (0x40UL)                  /*!< IOMSTR0 INTCLR: IACC (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTCLR_WTLEN_Pos          (5UL)                     /*!< IOMSTR0 INTCLR: WTLEN (Bit 5)                         */
#define IOMSTR0_INTCLR_WTLEN_Msk          (0x20UL)                  /*!< IOMSTR0 INTCLR: WTLEN (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTCLR_NAK_Pos            (4UL)                     /*!< IOMSTR0 INTCLR: NAK (Bit 4)                           */
#define IOMSTR0_INTCLR_NAK_Msk            (0x10UL)                  /*!< IOMSTR0 INTCLR: NAK (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTCLR_FOVFL_Pos          (3UL)                     /*!< IOMSTR0 INTCLR: FOVFL (Bit 3)                         */
#define IOMSTR0_INTCLR_FOVFL_Msk          (0x8UL)                   /*!< IOMSTR0 INTCLR: FOVFL (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTCLR_FUNDFL_Pos         (2UL)                     /*!< IOMSTR0 INTCLR: FUNDFL (Bit 2)                        */
#define IOMSTR0_INTCLR_FUNDFL_Msk         (0x4UL)                   /*!< IOMSTR0 INTCLR: FUNDFL (Bitfield-Mask: 0x01)          */
#define IOMSTR0_INTCLR_THR_Pos            (1UL)                     /*!< IOMSTR0 INTCLR: THR (Bit 1)                           */
#define IOMSTR0_INTCLR_THR_Msk            (0x2UL)                   /*!< IOMSTR0 INTCLR: THR (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTCLR_CMDCMP_Pos         (0UL)                     /*!< IOMSTR0 INTCLR: CMDCMP (Bit 0)                        */
#define IOMSTR0_INTCLR_CMDCMP_Msk         (0x1UL)                   /*!< IOMSTR0 INTCLR: CMDCMP (Bitfield-Mask: 0x01)          */
/* ========================================================  INTSET  ========================================================= */
#define IOMSTR0_INTSET_ARB_Pos            (10UL)                    /*!< IOMSTR0 INTSET: ARB (Bit 10)                          */
#define IOMSTR0_INTSET_ARB_Msk            (0x400UL)                 /*!< IOMSTR0 INTSET: ARB (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTSET_STOP_Pos           (9UL)                     /*!< IOMSTR0 INTSET: STOP (Bit 9)                          */
#define IOMSTR0_INTSET_STOP_Msk           (0x200UL)                 /*!< IOMSTR0 INTSET: STOP (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTSET_START_Pos          (8UL)                     /*!< IOMSTR0 INTSET: START (Bit 8)                         */
#define IOMSTR0_INTSET_START_Msk          (0x100UL)                 /*!< IOMSTR0 INTSET: START (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTSET_ICMD_Pos           (7UL)                     /*!< IOMSTR0 INTSET: ICMD (Bit 7)                          */
#define IOMSTR0_INTSET_ICMD_Msk           (0x80UL)                  /*!< IOMSTR0 INTSET: ICMD (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTSET_IACC_Pos           (6UL)                     /*!< IOMSTR0 INTSET: IACC (Bit 6)                          */
#define IOMSTR0_INTSET_IACC_Msk           (0x40UL)                  /*!< IOMSTR0 INTSET: IACC (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTSET_WTLEN_Pos          (5UL)                     /*!< IOMSTR0 INTSET: WTLEN (Bit 5)                         */
#define IOMSTR0_INTSET_WTLEN_Msk          (0x20UL)                  /*!< IOMSTR0 INTSET: WTLEN (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTSET_NAK_Pos            (4UL)                     /*!< IOMSTR0 INTSET: NAK (Bit 4)                           */
#define IOMSTR0_INTSET_NAK_Msk            (0x10UL)                  /*!< IOMSTR0 INTSET: NAK (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTSET_FOVFL_Pos          (3UL)                     /*!< IOMSTR0 INTSET: FOVFL (Bit 3)                         */
#define IOMSTR0_INTSET_FOVFL_Msk          (0x8UL)                   /*!< IOMSTR0 INTSET: FOVFL (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTSET_FUNDFL_Pos         (2UL)                     /*!< IOMSTR0 INTSET: FUNDFL (Bit 2)                        */
#define IOMSTR0_INTSET_FUNDFL_Msk         (0x4UL)                   /*!< IOMSTR0 INTSET: FUNDFL (Bitfield-Mask: 0x01)          */
#define IOMSTR0_INTSET_THR_Pos            (1UL)                     /*!< IOMSTR0 INTSET: THR (Bit 1)                           */
#define IOMSTR0_INTSET_THR_Msk            (0x2UL)                   /*!< IOMSTR0 INTSET: THR (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTSET_CMDCMP_Pos         (0UL)                     /*!< IOMSTR0 INTSET: CMDCMP (Bit 0)                        */
#define IOMSTR0_INTSET_CMDCMP_Msk         (0x1UL)                   /*!< IOMSTR0 INTSET: CMDCMP (Bitfield-Mask: 0x01)          */


/* =========================================================================================================================== */
/* ================                                          IOSLAVE                                          ================ */
/* =========================================================================================================================== */

/* ========================================================  FIFOPTR  ======================================================== */
#define IOSLAVE_FIFOPTR_FIFOSIZ_Pos       (8UL)                     /*!< IOSLAVE FIFOPTR: FIFOSIZ (Bit 8)                      */
#define IOSLAVE_FIFOPTR_FIFOSIZ_Msk       (0xff00UL)                /*!< IOSLAVE FIFOPTR: FIFOSIZ (Bitfield-Mask: 0xff)        */
#define IOSLAVE_FIFOPTR_FIFOPTR_Pos       (0UL)                     /*!< IOSLAVE FIFOPTR: FIFOPTR (Bit 0)                      */
#define IOSLAVE_FIFOPTR_FIFOPTR_Msk       (0xffUL)                  /*!< IOSLAVE FIFOPTR: FIFOPTR (Bitfield-Mask: 0xff)        */
/* ========================================================  FIFOCFG  ======================================================== */
#define IOSLAVE_FIFOCFG_ROBASE_Pos        (24UL)                    /*!< IOSLAVE FIFOCFG: ROBASE (Bit 24)                      */
#define IOSLAVE_FIFOCFG_ROBASE_Msk        (0x3f000000UL)            /*!< IOSLAVE FIFOCFG: ROBASE (Bitfield-Mask: 0x3f)         */
#define IOSLAVE_FIFOCFG_FIFOMAX_Pos       (8UL)                     /*!< IOSLAVE FIFOCFG: FIFOMAX (Bit 8)                      */
#define IOSLAVE_FIFOCFG_FIFOMAX_Msk       (0x3f00UL)                /*!< IOSLAVE FIFOCFG: FIFOMAX (Bitfield-Mask: 0x3f)        */
#define IOSLAVE_FIFOCFG_FIFOBASE_Pos      (0UL)                     /*!< IOSLAVE FIFOCFG: FIFOBASE (Bit 0)                     */
#define IOSLAVE_FIFOCFG_FIFOBASE_Msk      (0x1fUL)                  /*!< IOSLAVE FIFOCFG: FIFOBASE (Bitfield-Mask: 0x1f)       */
/* ========================================================  FIFOTHR  ======================================================== */
#define IOSLAVE_FIFOTHR_FIFOTHR_Pos       (0UL)                     /*!< IOSLAVE FIFOTHR: FIFOTHR (Bit 0)                      */
#define IOSLAVE_FIFOTHR_FIFOTHR_Msk       (0xffUL)                  /*!< IOSLAVE FIFOTHR: FIFOTHR (Bitfield-Mask: 0xff)        */
/* =========================================================  FUPD  ========================================================== */
#define IOSLAVE_FUPD_IOREAD_Pos           (1UL)                     /*!< IOSLAVE FUPD: IOREAD (Bit 1)                          */
#define IOSLAVE_FUPD_IOREAD_Msk           (0x2UL)                   /*!< IOSLAVE FUPD: IOREAD (Bitfield-Mask: 0x01)            */
#define IOSLAVE_FUPD_FIFOUPD_Pos          (0UL)                     /*!< IOSLAVE FUPD: FIFOUPD (Bit 0)                         */
#define IOSLAVE_FUPD_FIFOUPD_Msk          (0x1UL)                   /*!< IOSLAVE FUPD: FIFOUPD (Bitfield-Mask: 0x01)           */
/* ========================================================  FIFOCTR  ======================================================== */
#define IOSLAVE_FIFOCTR_FIFOCTR_Pos       (0UL)                     /*!< IOSLAVE FIFOCTR: FIFOCTR (Bit 0)                      */
#define IOSLAVE_FIFOCTR_FIFOCTR_Msk       (0x3ffUL)                 /*!< IOSLAVE FIFOCTR: FIFOCTR (Bitfield-Mask: 0x3ff)       */
/* ========================================================  FIFOINC  ======================================================== */
#define IOSLAVE_FIFOINC_FIFOINC_Pos       (0UL)                     /*!< IOSLAVE FIFOINC: FIFOINC (Bit 0)                      */
#define IOSLAVE_FIFOINC_FIFOINC_Msk       (0x3ffUL)                 /*!< IOSLAVE FIFOINC: FIFOINC (Bitfield-Mask: 0x3ff)       */
/* ==========================================================  CFG  ========================================================== */
#define IOSLAVE_CFG_IFCEN_Pos             (31UL)                    /*!< IOSLAVE CFG: IFCEN (Bit 31)                           */
#define IOSLAVE_CFG_IFCEN_Msk             (0x80000000UL)            /*!< IOSLAVE CFG: IFCEN (Bitfield-Mask: 0x01)              */
#define IOSLAVE_CFG_I2CADDR_Pos           (8UL)                     /*!< IOSLAVE CFG: I2CADDR (Bit 8)                          */
#define IOSLAVE_CFG_I2CADDR_Msk           (0xfff00UL)               /*!< IOSLAVE CFG: I2CADDR (Bitfield-Mask: 0xfff)           */
#define IOSLAVE_CFG_STARTRD_Pos           (4UL)                     /*!< IOSLAVE CFG: STARTRD (Bit 4)                          */
#define IOSLAVE_CFG_STARTRD_Msk           (0x10UL)                  /*!< IOSLAVE CFG: STARTRD (Bitfield-Mask: 0x01)            */
#define IOSLAVE_CFG_LSB_Pos               (2UL)                     /*!< IOSLAVE CFG: LSB (Bit 2)                              */
#define IOSLAVE_CFG_LSB_Msk               (0x4UL)                   /*!< IOSLAVE CFG: LSB (Bitfield-Mask: 0x01)                */
#define IOSLAVE_CFG_SPOL_Pos              (1UL)                     /*!< IOSLAVE CFG: SPOL (Bit 1)                             */
#define IOSLAVE_CFG_SPOL_Msk              (0x2UL)                   /*!< IOSLAVE CFG: SPOL (Bitfield-Mask: 0x01)               */
#define IOSLAVE_CFG_IFCSEL_Pos            (0UL)                     /*!< IOSLAVE CFG: IFCSEL (Bit 0)                           */
#define IOSLAVE_CFG_IFCSEL_Msk            (0x1UL)                   /*!< IOSLAVE CFG: IFCSEL (Bitfield-Mask: 0x01)             */
/* =========================================================  PRENC  ========================================================= */
#define IOSLAVE_PRENC_PRENC_Pos           (0UL)                     /*!< IOSLAVE PRENC: PRENC (Bit 0)                          */
#define IOSLAVE_PRENC_PRENC_Msk           (0x1fUL)                  /*!< IOSLAVE PRENC: PRENC (Bitfield-Mask: 0x1f)            */
/* =======================================================  IOINTCTL  ======================================================== */
#define IOSLAVE_IOINTCTL_IOINTSET_Pos     (24UL)                    /*!< IOSLAVE IOINTCTL: IOINTSET (Bit 24)                   */
#define IOSLAVE_IOINTCTL_IOINTSET_Msk     (0xff000000UL)            /*!< IOSLAVE IOINTCTL: IOINTSET (Bitfield-Mask: 0xff)      */
#define IOSLAVE_IOINTCTL_IOINTCLR_Pos     (16UL)                    /*!< IOSLAVE IOINTCTL: IOINTCLR (Bit 16)                   */
#define IOSLAVE_IOINTCTL_IOINTCLR_Msk     (0x10000UL)               /*!< IOSLAVE IOINTCTL: IOINTCLR (Bitfield-Mask: 0x01)      */
#define IOSLAVE_IOINTCTL_IOINT_Pos        (8UL)                     /*!< IOSLAVE IOINTCTL: IOINT (Bit 8)                       */
#define IOSLAVE_IOINTCTL_IOINT_Msk        (0xff00UL)                /*!< IOSLAVE IOINTCTL: IOINT (Bitfield-Mask: 0xff)         */
#define IOSLAVE_IOINTCTL_IOINTEN_Pos      (0UL)                     /*!< IOSLAVE IOINTCTL: IOINTEN (Bit 0)                     */
#define IOSLAVE_IOINTCTL_IOINTEN_Msk      (0xffUL)                  /*!< IOSLAVE IOINTCTL: IOINTEN (Bitfield-Mask: 0xff)       */
/* ========================================================  GENADD  ========================================================= */
#define IOSLAVE_GENADD_GADATA_Pos         (0UL)                     /*!< IOSLAVE GENADD: GADATA (Bit 0)                        */
#define IOSLAVE_GENADD_GADATA_Msk         (0xffUL)                  /*!< IOSLAVE GENADD: GADATA (Bitfield-Mask: 0xff)          */
/* =========================================================  INTEN  ========================================================= */
#define IOSLAVE_INTEN_XCMPWR_Pos          (9UL)                     /*!< IOSLAVE INTEN: XCMPWR (Bit 9)                         */
#define IOSLAVE_INTEN_XCMPWR_Msk          (0x200UL)                 /*!< IOSLAVE INTEN: XCMPWR (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTEN_XCMPWF_Pos          (8UL)                     /*!< IOSLAVE INTEN: XCMPWF (Bit 8)                         */
#define IOSLAVE_INTEN_XCMPWF_Msk          (0x100UL)                 /*!< IOSLAVE INTEN: XCMPWF (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTEN_XCMPRR_Pos          (7UL)                     /*!< IOSLAVE INTEN: XCMPRR (Bit 7)                         */
#define IOSLAVE_INTEN_XCMPRR_Msk          (0x80UL)                  /*!< IOSLAVE INTEN: XCMPRR (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTEN_XCMPRF_Pos          (6UL)                     /*!< IOSLAVE INTEN: XCMPRF (Bit 6)                         */
#define IOSLAVE_INTEN_XCMPRF_Msk          (0x40UL)                  /*!< IOSLAVE INTEN: XCMPRF (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTEN_IOINTW_Pos          (5UL)                     /*!< IOSLAVE INTEN: IOINTW (Bit 5)                         */
#define IOSLAVE_INTEN_IOINTW_Msk          (0x20UL)                  /*!< IOSLAVE INTEN: IOINTW (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTEN_GENAD_Pos           (4UL)                     /*!< IOSLAVE INTEN: GENAD (Bit 4)                          */
#define IOSLAVE_INTEN_GENAD_Msk           (0x10UL)                  /*!< IOSLAVE INTEN: GENAD (Bitfield-Mask: 0x01)            */
#define IOSLAVE_INTEN_FRDERR_Pos          (3UL)                     /*!< IOSLAVE INTEN: FRDERR (Bit 3)                         */
#define IOSLAVE_INTEN_FRDERR_Msk          (0x8UL)                   /*!< IOSLAVE INTEN: FRDERR (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTEN_FUNDFL_Pos          (2UL)                     /*!< IOSLAVE INTEN: FUNDFL (Bit 2)                         */
#define IOSLAVE_INTEN_FUNDFL_Msk          (0x4UL)                   /*!< IOSLAVE INTEN: FUNDFL (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTEN_FOVFL_Pos           (1UL)                     /*!< IOSLAVE INTEN: FOVFL (Bit 1)                          */
#define IOSLAVE_INTEN_FOVFL_Msk           (0x2UL)                   /*!< IOSLAVE INTEN: FOVFL (Bitfield-Mask: 0x01)            */
#define IOSLAVE_INTEN_FSIZE_Pos           (0UL)                     /*!< IOSLAVE INTEN: FSIZE (Bit 0)                          */
#define IOSLAVE_INTEN_FSIZE_Msk           (0x1UL)                   /*!< IOSLAVE INTEN: FSIZE (Bitfield-Mask: 0x01)            */
/* ========================================================  INTSTAT  ======================================================== */
#define IOSLAVE_INTSTAT_XCMPWR_Pos        (9UL)                     /*!< IOSLAVE INTSTAT: XCMPWR (Bit 9)                       */
#define IOSLAVE_INTSTAT_XCMPWR_Msk        (0x200UL)                 /*!< IOSLAVE INTSTAT: XCMPWR (Bitfield-Mask: 0x01)         */
#define IOSLAVE_INTSTAT_XCMPWF_Pos        (8UL)                     /*!< IOSLAVE INTSTAT: XCMPWF (Bit 8)                       */
#define IOSLAVE_INTSTAT_XCMPWF_Msk        (0x100UL)                 /*!< IOSLAVE INTSTAT: XCMPWF (Bitfield-Mask: 0x01)         */
#define IOSLAVE_INTSTAT_XCMPRR_Pos        (7UL)                     /*!< IOSLAVE INTSTAT: XCMPRR (Bit 7)                       */
#define IOSLAVE_INTSTAT_XCMPRR_Msk        (0x80UL)                  /*!< IOSLAVE INTSTAT: XCMPRR (Bitfield-Mask: 0x01)         */
#define IOSLAVE_INTSTAT_XCMPRF_Pos        (6UL)                     /*!< IOSLAVE INTSTAT: XCMPRF (Bit 6)                       */
#define IOSLAVE_INTSTAT_XCMPRF_Msk        (0x40UL)                  /*!< IOSLAVE INTSTAT: XCMPRF (Bitfield-Mask: 0x01)         */
#define IOSLAVE_INTSTAT_IOINTW_Pos        (5UL)                     /*!< IOSLAVE INTSTAT: IOINTW (Bit 5)                       */
#define IOSLAVE_INTSTAT_IOINTW_Msk        (0x20UL)                  /*!< IOSLAVE INTSTAT: IOINTW (Bitfield-Mask: 0x01)         */
#define IOSLAVE_INTSTAT_GENAD_Pos         (4UL)                     /*!< IOSLAVE INTSTAT: GENAD (Bit 4)                        */
#define IOSLAVE_INTSTAT_GENAD_Msk         (0x10UL)                  /*!< IOSLAVE INTSTAT: GENAD (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTSTAT_FRDERR_Pos        (3UL)                     /*!< IOSLAVE INTSTAT: FRDERR (Bit 3)                       */
#define IOSLAVE_INTSTAT_FRDERR_Msk        (0x8UL)                   /*!< IOSLAVE INTSTAT: FRDERR (Bitfield-Mask: 0x01)         */
#define IOSLAVE_INTSTAT_FUNDFL_Pos        (2UL)                     /*!< IOSLAVE INTSTAT: FUNDFL (Bit 2)                       */
#define IOSLAVE_INTSTAT_FUNDFL_Msk        (0x4UL)                   /*!< IOSLAVE INTSTAT: FUNDFL (Bitfield-Mask: 0x01)         */
#define IOSLAVE_INTSTAT_FOVFL_Pos         (1UL)                     /*!< IOSLAVE INTSTAT: FOVFL (Bit 1)                        */
#define IOSLAVE_INTSTAT_FOVFL_Msk         (0x2UL)                   /*!< IOSLAVE INTSTAT: FOVFL (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTSTAT_FSIZE_Pos         (0UL)                     /*!< IOSLAVE INTSTAT: FSIZE (Bit 0)                        */
#define IOSLAVE_INTSTAT_FSIZE_Msk         (0x1UL)                   /*!< IOSLAVE INTSTAT: FSIZE (Bitfield-Mask: 0x01)          */
/* ========================================================  INTCLR  ========================================================= */
#define IOSLAVE_INTCLR_XCMPWR_Pos         (9UL)                     /*!< IOSLAVE INTCLR: XCMPWR (Bit 9)                        */
#define IOSLAVE_INTCLR_XCMPWR_Msk         (0x200UL)                 /*!< IOSLAVE INTCLR: XCMPWR (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTCLR_XCMPWF_Pos         (8UL)                     /*!< IOSLAVE INTCLR: XCMPWF (Bit 8)                        */
#define IOSLAVE_INTCLR_XCMPWF_Msk         (0x100UL)                 /*!< IOSLAVE INTCLR: XCMPWF (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTCLR_XCMPRR_Pos         (7UL)                     /*!< IOSLAVE INTCLR: XCMPRR (Bit 7)                        */
#define IOSLAVE_INTCLR_XCMPRR_Msk         (0x80UL)                  /*!< IOSLAVE INTCLR: XCMPRR (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTCLR_XCMPRF_Pos         (6UL)                     /*!< IOSLAVE INTCLR: XCMPRF (Bit 6)                        */
#define IOSLAVE_INTCLR_XCMPRF_Msk         (0x40UL)                  /*!< IOSLAVE INTCLR: XCMPRF (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTCLR_IOINTW_Pos         (5UL)                     /*!< IOSLAVE INTCLR: IOINTW (Bit 5)                        */
#define IOSLAVE_INTCLR_IOINTW_Msk         (0x20UL)                  /*!< IOSLAVE INTCLR: IOINTW (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTCLR_GENAD_Pos          (4UL)                     /*!< IOSLAVE INTCLR: GENAD (Bit 4)                         */
#define IOSLAVE_INTCLR_GENAD_Msk          (0x10UL)                  /*!< IOSLAVE INTCLR: GENAD (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTCLR_FRDERR_Pos         (3UL)                     /*!< IOSLAVE INTCLR: FRDERR (Bit 3)                        */
#define IOSLAVE_INTCLR_FRDERR_Msk         (0x8UL)                   /*!< IOSLAVE INTCLR: FRDERR (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTCLR_FUNDFL_Pos         (2UL)                     /*!< IOSLAVE INTCLR: FUNDFL (Bit 2)                        */
#define IOSLAVE_INTCLR_FUNDFL_Msk         (0x4UL)                   /*!< IOSLAVE INTCLR: FUNDFL (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTCLR_FOVFL_Pos          (1UL)                     /*!< IOSLAVE INTCLR: FOVFL (Bit 1)                         */
#define IOSLAVE_INTCLR_FOVFL_Msk          (0x2UL)                   /*!< IOSLAVE INTCLR: FOVFL (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTCLR_FSIZE_Pos          (0UL)                     /*!< IOSLAVE INTCLR: FSIZE (Bit 0)                         */
#define IOSLAVE_INTCLR_FSIZE_Msk          (0x1UL)                   /*!< IOSLAVE INTCLR: FSIZE (Bitfield-Mask: 0x01)           */
/* ========================================================  INTSET  ========================================================= */
#define IOSLAVE_INTSET_XCMPWR_Pos         (9UL)                     /*!< IOSLAVE INTSET: XCMPWR (Bit 9)                        */
#define IOSLAVE_INTSET_XCMPWR_Msk         (0x200UL)                 /*!< IOSLAVE INTSET: XCMPWR (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTSET_XCMPWF_Pos         (8UL)                     /*!< IOSLAVE INTSET: XCMPWF (Bit 8)                        */
#define IOSLAVE_INTSET_XCMPWF_Msk         (0x100UL)                 /*!< IOSLAVE INTSET: XCMPWF (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTSET_XCMPRR_Pos         (7UL)                     /*!< IOSLAVE INTSET: XCMPRR (Bit 7)                        */
#define IOSLAVE_INTSET_XCMPRR_Msk         (0x80UL)                  /*!< IOSLAVE INTSET: XCMPRR (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTSET_XCMPRF_Pos         (6UL)                     /*!< IOSLAVE INTSET: XCMPRF (Bit 6)                        */
#define IOSLAVE_INTSET_XCMPRF_Msk         (0x40UL)                  /*!< IOSLAVE INTSET: XCMPRF (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTSET_IOINTW_Pos         (5UL)                     /*!< IOSLAVE INTSET: IOINTW (Bit 5)                        */
#define IOSLAVE_INTSET_IOINTW_Msk         (0x20UL)                  /*!< IOSLAVE INTSET: IOINTW (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTSET_GENAD_Pos          (4UL)                     /*!< IOSLAVE INTSET: GENAD (Bit 4)                         */
#define IOSLAVE_INTSET_GENAD_Msk          (0x10UL)                  /*!< IOSLAVE INTSET: GENAD (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTSET_FRDERR_Pos         (3UL)                     /*!< IOSLAVE INTSET: FRDERR (Bit 3)                        */
#define IOSLAVE_INTSET_FRDERR_Msk         (0x8UL)                   /*!< IOSLAVE INTSET: FRDERR (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTSET_FUNDFL_Pos         (2UL)                     /*!< IOSLAVE INTSET: FUNDFL (Bit 2)                        */
#define IOSLAVE_INTSET_FUNDFL_Msk         (0x4UL)                   /*!< IOSLAVE INTSET: FUNDFL (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTSET_FOVFL_Pos          (1UL)                     /*!< IOSLAVE INTSET: FOVFL (Bit 1)                         */
#define IOSLAVE_INTSET_FOVFL_Msk          (0x2UL)                   /*!< IOSLAVE INTSET: FOVFL (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTSET_FSIZE_Pos          (0UL)                     /*!< IOSLAVE INTSET: FSIZE (Bit 0)                         */
#define IOSLAVE_INTSET_FSIZE_Msk          (0x1UL)                   /*!< IOSLAVE INTSET: FSIZE (Bitfield-Mask: 0x01)           */
/* ======================================================  REGACCINTEN  ====================================================== */
#define IOSLAVE_REGACCINTEN_REGACC_Pos    (0UL)                     /*!< IOSLAVE REGACCINTEN: REGACC (Bit 0)                   */
#define IOSLAVE_REGACCINTEN_REGACC_Msk    (0xffffffffUL)            /*!< IOSLAVE REGACCINTEN: REGACC (Bitfield-Mask: 0xffffffff) */
/* =====================================================  REGACCINTSTAT  ===================================================== */
#define IOSLAVE_REGACCINTSTAT_REGACC_Pos  (0UL)                     /*!< IOSLAVE REGACCINTSTAT: REGACC (Bit 0)                 */
#define IOSLAVE_REGACCINTSTAT_REGACC_Msk  (0xffffffffUL)            /*!< IOSLAVE REGACCINTSTAT: REGACC (Bitfield-Mask: 0xffffffff) */
/* =====================================================  REGACCINTCLR  ====================================================== */
#define IOSLAVE_REGACCINTCLR_REGACC_Pos   (0UL)                     /*!< IOSLAVE REGACCINTCLR: REGACC (Bit 0)                  */
#define IOSLAVE_REGACCINTCLR_REGACC_Msk   (0xffffffffUL)            /*!< IOSLAVE REGACCINTCLR: REGACC (Bitfield-Mask: 0xffffffff) */
/* =====================================================  REGACCINTSET  ====================================================== */
#define IOSLAVE_REGACCINTSET_REGACC_Pos   (0UL)                     /*!< IOSLAVE REGACCINTSET: REGACC (Bit 0)                  */
#define IOSLAVE_REGACCINTSET_REGACC_Msk   (0xffffffffUL)            /*!< IOSLAVE REGACCINTSET: REGACC (Bitfield-Mask: 0xffffffff) */


/* =========================================================================================================================== */
/* ================                                          MCUCTRL                                          ================ */
/* =========================================================================================================================== */

/* =======================================================  CHIP_INFO  ======================================================= */
#define MCUCTRL_CHIP_INFO_PARTNUM_Pos     (0UL)                     /*!< MCUCTRL CHIP_INFO: PARTNUM (Bit 0)                    */
#define MCUCTRL_CHIP_INFO_PARTNUM_Msk     (0xffffffffUL)            /*!< MCUCTRL CHIP_INFO: PARTNUM (Bitfield-Mask: 0xffffffff) */
/* ========================================================  CHIPID0  ======================================================== */
#define MCUCTRL_CHIPID0_VALUE_Pos         (0UL)                     /*!< MCUCTRL CHIPID0: VALUE (Bit 0)                        */
#define MCUCTRL_CHIPID0_VALUE_Msk         (0xffffffffUL)            /*!< MCUCTRL CHIPID0: VALUE (Bitfield-Mask: 0xffffffff)    */
/* ========================================================  CHIPID1  ======================================================== */
#define MCUCTRL_CHIPID1_VALUE_Pos         (0UL)                     /*!< MCUCTRL CHIPID1: VALUE (Bit 0)                        */
#define MCUCTRL_CHIPID1_VALUE_Msk         (0xffffffffUL)            /*!< MCUCTRL CHIPID1: VALUE (Bitfield-Mask: 0xffffffff)    */
/* ========================================================  CHIPREV  ======================================================== */
#define MCUCTRL_CHIPREV_REVMAJ_Pos        (4UL)                     /*!< MCUCTRL CHIPREV: REVMAJ (Bit 4)                       */
#define MCUCTRL_CHIPREV_REVMAJ_Msk        (0xf0UL)                  /*!< MCUCTRL CHIPREV: REVMAJ (Bitfield-Mask: 0x0f)         */
#define MCUCTRL_CHIPREV_REVMIN_Pos        (0UL)                     /*!< MCUCTRL CHIPREV: REVMIN (Bit 0)                       */
#define MCUCTRL_CHIPREV_REVMIN_Msk        (0xfUL)                   /*!< MCUCTRL CHIPREV: REVMIN (Bitfield-Mask: 0x0f)         */
/* =======================================================  VENDORID  ======================================================== */
#define MCUCTRL_VENDORID_VALUE_Pos        (0UL)                     /*!< MCUCTRL VENDORID: VALUE (Bit 0)                       */
#define MCUCTRL_VENDORID_VALUE_Msk        (0xffffffffUL)            /*!< MCUCTRL VENDORID: VALUE (Bitfield-Mask: 0xffffffff)   */
/* =======================================================  DEBUGGER  ======================================================== */
#define MCUCTRL_DEBUGGER_LOCKOUT_Pos      (0UL)                     /*!< MCUCTRL DEBUGGER: LOCKOUT (Bit 0)                     */
#define MCUCTRL_DEBUGGER_LOCKOUT_Msk      (0x1UL)                   /*!< MCUCTRL DEBUGGER: LOCKOUT (Bitfield-Mask: 0x01)       */
/* =========================================================  BUCK  ========================================================== */
#define MCUCTRL_BUCK_MEMBUCKRST_Pos       (7UL)                     /*!< MCUCTRL BUCK: MEMBUCKRST (Bit 7)                      */
#define MCUCTRL_BUCK_MEMBUCKRST_Msk       (0x80UL)                  /*!< MCUCTRL BUCK: MEMBUCKRST (Bitfield-Mask: 0x01)        */
#define MCUCTRL_BUCK_COREBUCKRST_Pos      (6UL)                     /*!< MCUCTRL BUCK: COREBUCKRST (Bit 6)                     */
#define MCUCTRL_BUCK_COREBUCKRST_Msk      (0x40UL)                  /*!< MCUCTRL BUCK: COREBUCKRST (Bitfield-Mask: 0x01)       */
#define MCUCTRL_BUCK_BYPBUCKMEM_Pos       (5UL)                     /*!< MCUCTRL BUCK: BYPBUCKMEM (Bit 5)                      */
#define MCUCTRL_BUCK_BYPBUCKMEM_Msk       (0x20UL)                  /*!< MCUCTRL BUCK: BYPBUCKMEM (Bitfield-Mask: 0x01)        */
#define MCUCTRL_BUCK_MEMBUCKPWD_Pos       (4UL)                     /*!< MCUCTRL BUCK: MEMBUCKPWD (Bit 4)                      */
#define MCUCTRL_BUCK_MEMBUCKPWD_Msk       (0x10UL)                  /*!< MCUCTRL BUCK: MEMBUCKPWD (Bitfield-Mask: 0x01)        */
#define MCUCTRL_BUCK_SLEEPBUCKANA_Pos     (3UL)                     /*!< MCUCTRL BUCK: SLEEPBUCKANA (Bit 3)                    */
#define MCUCTRL_BUCK_SLEEPBUCKANA_Msk     (0x8UL)                   /*!< MCUCTRL BUCK: SLEEPBUCKANA (Bitfield-Mask: 0x01)      */
#define MCUCTRL_BUCK_COREBUCKPWD_Pos      (2UL)                     /*!< MCUCTRL BUCK: COREBUCKPWD (Bit 2)                     */
#define MCUCTRL_BUCK_COREBUCKPWD_Msk      (0x4UL)                   /*!< MCUCTRL BUCK: COREBUCKPWD (Bitfield-Mask: 0x01)       */
#define MCUCTRL_BUCK_BYPBUCKCORE_Pos      (1UL)                     /*!< MCUCTRL BUCK: BYPBUCKCORE (Bit 1)                     */
#define MCUCTRL_BUCK_BYPBUCKCORE_Msk      (0x2UL)                   /*!< MCUCTRL BUCK: BYPBUCKCORE (Bitfield-Mask: 0x01)       */
#define MCUCTRL_BUCK_BUCKSWE_Pos          (0UL)                     /*!< MCUCTRL BUCK: BUCKSWE (Bit 0)                         */
#define MCUCTRL_BUCK_BUCKSWE_Msk          (0x1UL)                   /*!< MCUCTRL BUCK: BUCKSWE (Bitfield-Mask: 0x01)           */
/* =========================================================  BUCK2  ========================================================= */
#define MCUCTRL_BUCK2_BUCKLFCLKSEL_Pos    (10UL)                    /*!< MCUCTRL BUCK2: BUCKLFCLKSEL (Bit 10)                  */
#define MCUCTRL_BUCK2_BUCKLFCLKSEL_Msk    (0xc00UL)                 /*!< MCUCTRL BUCK2: BUCKLFCLKSEL (Bitfield-Mask: 0x03)     */
#define MCUCTRL_BUCK2_HYSTBUCKCORE_Pos    (9UL)                     /*!< MCUCTRL BUCK2: HYSTBUCKCORE (Bit 9)                   */
#define MCUCTRL_BUCK2_HYSTBUCKCORE_Msk    (0x200UL)                 /*!< MCUCTRL BUCK2: HYSTBUCKCORE (Bitfield-Mask: 0x01)     */
#define MCUCTRL_BUCK2_HYSTBUCKMEM_Pos     (8UL)                     /*!< MCUCTRL BUCK2: HYSTBUCKMEM (Bit 8)                    */
#define MCUCTRL_BUCK2_HYSTBUCKMEM_Msk     (0x100UL)                 /*!< MCUCTRL BUCK2: HYSTBUCKMEM (Bitfield-Mask: 0x01)      */
#define MCUCTRL_BUCK2_BMEMTONSEL_Pos      (4UL)                     /*!< MCUCTRL BUCK2: BMEMTONSEL (Bit 4)                     */
#define MCUCTRL_BUCK2_BMEMTONSEL_Msk      (0xf0UL)                  /*!< MCUCTRL BUCK2: BMEMTONSEL (Bitfield-Mask: 0x0f)       */
#define MCUCTRL_BUCK2_BCORETONSEL_Pos     (0UL)                     /*!< MCUCTRL BUCK2: BCORETONSEL (Bit 0)                    */
#define MCUCTRL_BUCK2_BCORETONSEL_Msk     (0xfUL)                   /*!< MCUCTRL BUCK2: BCORETONSEL (Bitfield-Mask: 0x0f)      */
/* =========================================================  BUCK3  ========================================================= */
#define MCUCTRL_BUCK3_MEMBUCKLOTON_Pos    (18UL)                    /*!< MCUCTRL BUCK3: MEMBUCKLOTON (Bit 18)                  */
#define MCUCTRL_BUCK3_MEMBUCKLOTON_Msk    (0x3c0000UL)              /*!< MCUCTRL BUCK3: MEMBUCKLOTON (Bitfield-Mask: 0x0f)     */
#define MCUCTRL_BUCK3_MEMBUCKBURSTEN_Pos  (17UL)                    /*!< MCUCTRL BUCK3: MEMBUCKBURSTEN (Bit 17)                */
#define MCUCTRL_BUCK3_MEMBUCKBURSTEN_Msk  (0x20000UL)               /*!< MCUCTRL BUCK3: MEMBUCKBURSTEN (Bitfield-Mask: 0x01)   */
#define MCUCTRL_BUCK3_MEMBUCKZXTRIM_Pos   (13UL)                    /*!< MCUCTRL BUCK3: MEMBUCKZXTRIM (Bit 13)                 */
#define MCUCTRL_BUCK3_MEMBUCKZXTRIM_Msk   (0x1e000UL)               /*!< MCUCTRL BUCK3: MEMBUCKZXTRIM (Bitfield-Mask: 0x0f)    */
#define MCUCTRL_BUCK3_MEMBUCKHYSTTRIM_Pos (11UL)                    /*!< MCUCTRL BUCK3: MEMBUCKHYSTTRIM (Bit 11)               */
#define MCUCTRL_BUCK3_MEMBUCKHYSTTRIM_Msk (0x1800UL)                /*!< MCUCTRL BUCK3: MEMBUCKHYSTTRIM (Bitfield-Mask: 0x03)  */
#define MCUCTRL_BUCK3_COREBUCKLOTON_Pos   (7UL)                     /*!< MCUCTRL BUCK3: COREBUCKLOTON (Bit 7)                  */
#define MCUCTRL_BUCK3_COREBUCKLOTON_Msk   (0x780UL)                 /*!< MCUCTRL BUCK3: COREBUCKLOTON (Bitfield-Mask: 0x0f)    */
#define MCUCTRL_BUCK3_COREBUCKBURSTEN_Pos (6UL)                     /*!< MCUCTRL BUCK3: COREBUCKBURSTEN (Bit 6)                */
#define MCUCTRL_BUCK3_COREBUCKBURSTEN_Msk (0x40UL)                  /*!< MCUCTRL BUCK3: COREBUCKBURSTEN (Bitfield-Mask: 0x01)  */
#define MCUCTRL_BUCK3_COREBUCKZXTRIM_Pos  (2UL)                     /*!< MCUCTRL BUCK3: COREBUCKZXTRIM (Bit 2)                 */
#define MCUCTRL_BUCK3_COREBUCKZXTRIM_Msk  (0x3cUL)                  /*!< MCUCTRL BUCK3: COREBUCKZXTRIM (Bitfield-Mask: 0x0f)   */
#define MCUCTRL_BUCK3_COREBUCKHYSTTRIM_Pos (0UL)                    /*!< MCUCTRL BUCK3: COREBUCKHYSTTRIM (Bit 0)               */
#define MCUCTRL_BUCK3_COREBUCKHYSTTRIM_Msk (0x3UL)                  /*!< MCUCTRL BUCK3: COREBUCKHYSTTRIM (Bitfield-Mask: 0x03) */
/* ========================================================  LDOREG1  ======================================================== */
#define MCUCTRL_LDOREG1_CORELDOIBSTRM_Pos (20UL)                    /*!< MCUCTRL LDOREG1: CORELDOIBSTRM (Bit 20)               */
#define MCUCTRL_LDOREG1_CORELDOIBSTRM_Msk (0x100000UL)              /*!< MCUCTRL LDOREG1: CORELDOIBSTRM (Bitfield-Mask: 0x01)  */
#define MCUCTRL_LDOREG1_CORELDOLPTRIM_Pos (14UL)                    /*!< MCUCTRL LDOREG1: CORELDOLPTRIM (Bit 14)               */
#define MCUCTRL_LDOREG1_CORELDOLPTRIM_Msk (0xfc000UL)               /*!< MCUCTRL LDOREG1: CORELDOLPTRIM (Bitfield-Mask: 0x3f)  */
#define MCUCTRL_LDOREG1_TRIMCORELDOR3_Pos (10UL)                    /*!< MCUCTRL LDOREG1: TRIMCORELDOR3 (Bit 10)               */
#define MCUCTRL_LDOREG1_TRIMCORELDOR3_Msk (0x3c00UL)                /*!< MCUCTRL LDOREG1: TRIMCORELDOR3 (Bitfield-Mask: 0x0f)  */
#define MCUCTRL_LDOREG1_TRIMCORELDOR1_Pos (0UL)                     /*!< MCUCTRL LDOREG1: TRIMCORELDOR1 (Bit 0)                */
#define MCUCTRL_LDOREG1_TRIMCORELDOR1_Msk (0x3ffUL)                 /*!< MCUCTRL LDOREG1: TRIMCORELDOR1 (Bitfield-Mask: 0x3ff) */
/* ========================================================  LDOREG2  ======================================================== */
#define MCUCTRL_LDOREG2_CORELDOVDDLEN_Pos (22UL)                    /*!< MCUCTRL LDOREG2: CORELDOVDDLEN (Bit 22)               */
#define MCUCTRL_LDOREG2_CORELDOVDDLEN_Msk (0x400000UL)              /*!< MCUCTRL LDOREG2: CORELDOVDDLEN (Bitfield-Mask: 0x01)  */
#define MCUCTRL_LDOREG2_RAMLDOLPMODE_Pos  (21UL)                    /*!< MCUCTRL LDOREG2: RAMLDOLPMODE (Bit 21)                */
#define MCUCTRL_LDOREG2_RAMLDOLPMODE_Msk  (0x200000UL)              /*!< MCUCTRL LDOREG2: RAMLDOLPMODE (Bitfield-Mask: 0x01)   */
#define MCUCTRL_LDOREG2_PWDRAMLDO_Pos     (20UL)                    /*!< MCUCTRL LDOREG2: PWDRAMLDO (Bit 20)                   */
#define MCUCTRL_LDOREG2_PWDRAMLDO_Msk     (0x100000UL)              /*!< MCUCTRL LDOREG2: PWDRAMLDO (Bitfield-Mask: 0x01)      */
#define MCUCTRL_LDOREG2_PWDANALDO_Pos     (19UL)                    /*!< MCUCTRL LDOREG2: PWDANALDO (Bit 19)                   */
#define MCUCTRL_LDOREG2_PWDANALDO_Msk     (0x80000UL)               /*!< MCUCTRL LDOREG2: PWDANALDO (Bitfield-Mask: 0x01)      */
#define MCUCTRL_LDOREG2_PWDMEMLDO_Pos     (18UL)                    /*!< MCUCTRL LDOREG2: PWDMEMLDO (Bit 18)                   */
#define MCUCTRL_LDOREG2_PWDMEMLDO_Msk     (0x40000UL)               /*!< MCUCTRL LDOREG2: PWDMEMLDO (Bitfield-Mask: 0x01)      */
#define MCUCTRL_LDOREG2_PWDCORELDO_Pos    (17UL)                    /*!< MCUCTRL LDOREG2: PWDCORELDO (Bit 17)                  */
#define MCUCTRL_LDOREG2_PWDCORELDO_Msk    (0x20000UL)               /*!< MCUCTRL LDOREG2: PWDCORELDO (Bitfield-Mask: 0x01)     */
#define MCUCTRL_LDOREG2_SLEEPANALDO_Pos   (16UL)                    /*!< MCUCTRL LDOREG2: SLEEPANALDO (Bit 16)                 */
#define MCUCTRL_LDOREG2_SLEEPANALDO_Msk   (0x10000UL)               /*!< MCUCTRL LDOREG2: SLEEPANALDO (Bitfield-Mask: 0x01)    */
#define MCUCTRL_LDOREG2_SLEEPMEMLDO_Pos   (15UL)                    /*!< MCUCTRL LDOREG2: SLEEPMEMLDO (Bit 15)                 */
#define MCUCTRL_LDOREG2_SLEEPMEMLDO_Msk   (0x8000UL)                /*!< MCUCTRL LDOREG2: SLEEPMEMLDO (Bitfield-Mask: 0x01)    */
#define MCUCTRL_LDOREG2_SLEEPCORELDO_Pos  (14UL)                    /*!< MCUCTRL LDOREG2: SLEEPCORELDO (Bit 14)                */
#define MCUCTRL_LDOREG2_SLEEPCORELDO_Msk  (0x4000UL)                /*!< MCUCTRL LDOREG2: SLEEPCORELDO (Bitfield-Mask: 0x01)   */
#define MCUCTRL_LDOREG2_VREFSELANALDO_Pos (13UL)                    /*!< MCUCTRL LDOREG2: VREFSELANALDO (Bit 13)               */
#define MCUCTRL_LDOREG2_VREFSELANALDO_Msk (0x2000UL)                /*!< MCUCTRL LDOREG2: VREFSELANALDO (Bitfield-Mask: 0x01)  */
#define MCUCTRL_LDOREG2_VREFSELSRAMLDO_Pos (12UL)                   /*!< MCUCTRL LDOREG2: VREFSELSRAMLDO (Bit 12)              */
#define MCUCTRL_LDOREG2_VREFSELSRAMLDO_Msk (0x1000UL)               /*!< MCUCTRL LDOREG2: VREFSELSRAMLDO (Bitfield-Mask: 0x01) */
#define MCUCTRL_LDOREG2_VREFSELFLASHLDO_Pos (11UL)                  /*!< MCUCTRL LDOREG2: VREFSELFLASHLDO (Bit 11)             */
#define MCUCTRL_LDOREG2_VREFSELFLASHLDO_Msk (0x800UL)               /*!< MCUCTRL LDOREG2: VREFSELFLASHLDO (Bitfield-Mask: 0x01) */
#define MCUCTRL_LDOREG2_VREFSELCORELDO_Pos (10UL)                   /*!< MCUCTRL LDOREG2: VREFSELCORELDO (Bit 10)              */
#define MCUCTRL_LDOREG2_VREFSELCORELDO_Msk (0x400UL)                /*!< MCUCTRL LDOREG2: VREFSELCORELDO (Bitfield-Mask: 0x01) */
#define MCUCTRL_LDOREG2_TRIMANALDO_Pos    (6UL)                     /*!< MCUCTRL LDOREG2: TRIMANALDO (Bit 6)                   */
#define MCUCTRL_LDOREG2_TRIMANALDO_Msk    (0x3c0UL)                 /*!< MCUCTRL LDOREG2: TRIMANALDO (Bitfield-Mask: 0x0f)     */
#define MCUCTRL_LDOREG2_RAMLDOTRIM_Pos    (1UL)                     /*!< MCUCTRL LDOREG2: RAMLDOTRIM (Bit 1)                   */
#define MCUCTRL_LDOREG2_RAMLDOTRIM_Msk    (0x3eUL)                  /*!< MCUCTRL LDOREG2: RAMLDOTRIM (Bitfield-Mask: 0x1f)     */
#define MCUCTRL_LDOREG2_LDO2SWE_Pos       (0UL)                     /*!< MCUCTRL LDOREG2: LDO2SWE (Bit 0)                      */
#define MCUCTRL_LDOREG2_LDO2SWE_Msk       (0x1UL)                   /*!< MCUCTRL LDOREG2: LDO2SWE (Bitfield-Mask: 0x01)        */
/* ========================================================  LDOREG3  ======================================================== */
#define MCUCTRL_LDOREG3_TRIMMEMLDOR1_Pos  (12UL)                    /*!< MCUCTRL LDOREG3: TRIMMEMLDOR1 (Bit 12)                */
#define MCUCTRL_LDOREG3_TRIMMEMLDOR1_Msk  (0x3f000UL)               /*!< MCUCTRL LDOREG3: TRIMMEMLDOR1 (Bitfield-Mask: 0x3f)   */
#define MCUCTRL_LDOREG3_MEMLDOLPALTTRIM_Pos (6UL)                   /*!< MCUCTRL LDOREG3: MEMLDOLPALTTRIM (Bit 6)              */
#define MCUCTRL_LDOREG3_MEMLDOLPALTTRIM_Msk (0xfc0UL)               /*!< MCUCTRL LDOREG3: MEMLDOLPALTTRIM (Bitfield-Mask: 0x3f) */
#define MCUCTRL_LDOREG3_MEMLDOLPTRIM_Pos  (0UL)                     /*!< MCUCTRL LDOREG3: MEMLDOLPTRIM (Bit 0)                 */
#define MCUCTRL_LDOREG3_MEMLDOLPTRIM_Msk  (0x3fUL)                  /*!< MCUCTRL LDOREG3: MEMLDOLPTRIM (Bitfield-Mask: 0x3f)   */
/* ======================================================  BODPORCTRL  ======================================================= */
#define MCUCTRL_BODPORCTRL_BODEXTREFSEL_Pos (3UL)                   /*!< MCUCTRL BODPORCTRL: BODEXTREFSEL (Bit 3)              */
#define MCUCTRL_BODPORCTRL_BODEXTREFSEL_Msk (0x8UL)                 /*!< MCUCTRL BODPORCTRL: BODEXTREFSEL (Bitfield-Mask: 0x01) */
#define MCUCTRL_BODPORCTRL_PDREXTREFSEL_Pos (2UL)                   /*!< MCUCTRL BODPORCTRL: PDREXTREFSEL (Bit 2)              */
#define MCUCTRL_BODPORCTRL_PDREXTREFSEL_Msk (0x4UL)                 /*!< MCUCTRL BODPORCTRL: PDREXTREFSEL (Bitfield-Mask: 0x01) */
#define MCUCTRL_BODPORCTRL_PWDBOD_Pos     (1UL)                     /*!< MCUCTRL BODPORCTRL: PWDBOD (Bit 1)                    */
#define MCUCTRL_BODPORCTRL_PWDBOD_Msk     (0x2UL)                   /*!< MCUCTRL BODPORCTRL: PWDBOD (Bitfield-Mask: 0x01)      */
#define MCUCTRL_BODPORCTRL_PWDPDR_Pos     (0UL)                     /*!< MCUCTRL BODPORCTRL: PWDPDR (Bit 0)                    */
#define MCUCTRL_BODPORCTRL_PWDPDR_Msk     (0x1UL)                   /*!< MCUCTRL BODPORCTRL: PWDPDR (Bitfield-Mask: 0x01)      */
/* =======================================================  ADCPWRDLY  ======================================================= */
#define MCUCTRL_ADCPWRDLY_ADCPWR1_Pos     (8UL)                     /*!< MCUCTRL ADCPWRDLY: ADCPWR1 (Bit 8)                    */
#define MCUCTRL_ADCPWRDLY_ADCPWR1_Msk     (0xff00UL)                /*!< MCUCTRL ADCPWRDLY: ADCPWR1 (Bitfield-Mask: 0xff)      */
#define MCUCTRL_ADCPWRDLY_ADCPWR0_Pos     (0UL)                     /*!< MCUCTRL ADCPWRDLY: ADCPWR0 (Bit 0)                    */
#define MCUCTRL_ADCPWRDLY_ADCPWR0_Msk     (0xffUL)                  /*!< MCUCTRL ADCPWRDLY: ADCPWR0 (Bitfield-Mask: 0xff)      */
/* ========================================================  ADCCAL  ========================================================= */
#define MCUCTRL_ADCCAL_ADCCALIBRATED_Pos  (1UL)                     /*!< MCUCTRL ADCCAL: ADCCALIBRATED (Bit 1)                 */
#define MCUCTRL_ADCCAL_ADCCALIBRATED_Msk  (0x2UL)                   /*!< MCUCTRL ADCCAL: ADCCALIBRATED (Bitfield-Mask: 0x01)   */
#define MCUCTRL_ADCCAL_CALONPWRUP_Pos     (0UL)                     /*!< MCUCTRL ADCCAL: CALONPWRUP (Bit 0)                    */
#define MCUCTRL_ADCCAL_CALONPWRUP_Msk     (0x1UL)                   /*!< MCUCTRL ADCCAL: CALONPWRUP (Bitfield-Mask: 0x01)      */
/* ======================================================  ADCBATTLOAD  ====================================================== */
#define MCUCTRL_ADCBATTLOAD_BATTLOAD_Pos  (0UL)                     /*!< MCUCTRL ADCBATTLOAD: BATTLOAD (Bit 0)                 */
#define MCUCTRL_ADCBATTLOAD_BATTLOAD_Msk  (0x1UL)                   /*!< MCUCTRL ADCBATTLOAD: BATTLOAD (Bitfield-Mask: 0x01)   */
/* =======================================================  BUCKTRIM  ======================================================== */
#define MCUCTRL_BUCKTRIM_RSVD2_Pos        (24UL)                    /*!< MCUCTRL BUCKTRIM: RSVD2 (Bit 24)                      */
#define MCUCTRL_BUCKTRIM_RSVD2_Msk        (0x3f000000UL)            /*!< MCUCTRL BUCKTRIM: RSVD2 (Bitfield-Mask: 0x3f)         */
#define MCUCTRL_BUCKTRIM_COREBUCKR1_HI_Pos (16UL)                   /*!< MCUCTRL BUCKTRIM: COREBUCKR1_HI (Bit 16)              */
#define MCUCTRL_BUCKTRIM_COREBUCKR1_HI_Msk (0xf0000UL)              /*!< MCUCTRL BUCKTRIM: COREBUCKR1_HI (Bitfield-Mask: 0x0f) */
#define MCUCTRL_BUCKTRIM_COREBUCKR1_LO_Pos (8UL)                    /*!< MCUCTRL BUCKTRIM: COREBUCKR1_LO (Bit 8)               */
#define MCUCTRL_BUCKTRIM_COREBUCKR1_LO_Msk (0x3f00UL)               /*!< MCUCTRL BUCKTRIM: COREBUCKR1_LO (Bitfield-Mask: 0x3f) */
#define MCUCTRL_BUCKTRIM_MEMBUCKR1_Pos    (0UL)                     /*!< MCUCTRL BUCKTRIM: MEMBUCKR1 (Bit 0)                   */
#define MCUCTRL_BUCKTRIM_MEMBUCKR1_Msk    (0x3fUL)                  /*!< MCUCTRL BUCKTRIM: MEMBUCKR1 (Bitfield-Mask: 0x3f)     */
/* ========================================================  ADCTRIM  ======================================================== */
#define MCUCTRL_ADCTRIM_ADCRFBUFIBTRIM_Pos (11UL)                   /*!< MCUCTRL ADCTRIM: ADCRFBUFIBTRIM (Bit 11)              */
#define MCUCTRL_ADCTRIM_ADCRFBUFIBTRIM_Msk (0x1800UL)               /*!< MCUCTRL ADCTRIM: ADCRFBUFIBTRIM (Bitfield-Mask: 0x03) */
#define MCUCTRL_ADCTRIM_ADCREFBUFTRIM_Pos (6UL)                     /*!< MCUCTRL ADCTRIM: ADCREFBUFTRIM (Bit 6)                */
#define MCUCTRL_ADCTRIM_ADCREFBUFTRIM_Msk (0x7c0UL)                 /*!< MCUCTRL ADCTRIM: ADCREFBUFTRIM (Bitfield-Mask: 0x1f)  */
#define MCUCTRL_ADCTRIM_ADCREFKEEPIBTRIM_Pos (0UL)                  /*!< MCUCTRL ADCTRIM: ADCREFKEEPIBTRIM (Bit 0)             */
#define MCUCTRL_ADCTRIM_ADCREFKEEPIBTRIM_Msk (0x3UL)                /*!< MCUCTRL ADCTRIM: ADCREFKEEPIBTRIM (Bitfield-Mask: 0x03) */
/* ======================================================  ADCREFCOMP  ======================================================= */
#define MCUCTRL_ADCREFCOMP_ADCRFCMPEN_Pos (16UL)                    /*!< MCUCTRL ADCREFCOMP: ADCRFCMPEN (Bit 16)               */
#define MCUCTRL_ADCREFCOMP_ADCRFCMPEN_Msk (0x10000UL)               /*!< MCUCTRL ADCREFCOMP: ADCRFCMPEN (Bitfield-Mask: 0x01)  */
#define MCUCTRL_ADCREFCOMP_ADCREFKEEPTRIM_Pos (8UL)                 /*!< MCUCTRL ADCREFCOMP: ADCREFKEEPTRIM (Bit 8)            */
#define MCUCTRL_ADCREFCOMP_ADCREFKEEPTRIM_Msk (0x1f00UL)            /*!< MCUCTRL ADCREFCOMP: ADCREFKEEPTRIM (Bitfield-Mask: 0x1f) */
#define MCUCTRL_ADCREFCOMP_ADC_REFCOMP_OUT_Pos (0UL)                /*!< MCUCTRL ADCREFCOMP: ADC_REFCOMP_OUT (Bit 0)           */
#define MCUCTRL_ADCREFCOMP_ADC_REFCOMP_OUT_Msk (0x1UL)              /*!< MCUCTRL ADCREFCOMP: ADC_REFCOMP_OUT (Bitfield-Mask: 0x01) */
/* ======================================================  XTALGENCTRL  ====================================================== */
#define MCUCTRL_XTALGENCTRL_XTALKSBIASTRIM_Pos (8UL)                /*!< MCUCTRL XTALGENCTRL: XTALKSBIASTRIM (Bit 8)           */
#define MCUCTRL_XTALGENCTRL_XTALKSBIASTRIM_Msk (0x3f00UL)           /*!< MCUCTRL XTALGENCTRL: XTALKSBIASTRIM (Bitfield-Mask: 0x3f) */
#define MCUCTRL_XTALGENCTRL_XTALBIASTRIM_Pos (2UL)                  /*!< MCUCTRL XTALGENCTRL: XTALBIASTRIM (Bit 2)             */
#define MCUCTRL_XTALGENCTRL_XTALBIASTRIM_Msk (0xfcUL)               /*!< MCUCTRL XTALGENCTRL: XTALBIASTRIM (Bitfield-Mask: 0x3f) */
#define MCUCTRL_XTALGENCTRL_ACWARMUP_Pos  (0UL)                     /*!< MCUCTRL XTALGENCTRL: ACWARMUP (Bit 0)                 */
#define MCUCTRL_XTALGENCTRL_ACWARMUP_Msk  (0x3UL)                   /*!< MCUCTRL XTALGENCTRL: ACWARMUP (Bitfield-Mask: 0x03)   */
/* =======================================================  EXTCLKSEL  ======================================================= */
#define MCUCTRL_EXTCLKSEL_EXT_HF_Pos      (2UL)                     /*!< MCUCTRL EXTCLKSEL: EXT_HF (Bit 2)                     */
#define MCUCTRL_EXTCLKSEL_EXT_HF_Msk      (0x4UL)                   /*!< MCUCTRL EXTCLKSEL: EXT_HF (Bitfield-Mask: 0x01)       */
#define MCUCTRL_EXTCLKSEL_EXT_LF_Pos      (1UL)                     /*!< MCUCTRL EXTCLKSEL: EXT_LF (Bit 1)                     */
#define MCUCTRL_EXTCLKSEL_EXT_LF_Msk      (0x2UL)                   /*!< MCUCTRL EXTCLKSEL: EXT_LF (Bitfield-Mask: 0x01)       */
#define MCUCTRL_EXTCLKSEL_EXT_XT_Pos      (0UL)                     /*!< MCUCTRL EXTCLKSEL: EXT_XT (Bit 0)                     */
#define MCUCTRL_EXTCLKSEL_EXT_XT_Msk      (0x1UL)                   /*!< MCUCTRL EXTCLKSEL: EXT_XT (Bitfield-Mask: 0x01)       */
/* =====================================================  BOOTLOADERLOW  ===================================================== */
#define MCUCTRL_BOOTLOADERLOW_VALUE_Pos   (0UL)                     /*!< MCUCTRL BOOTLOADERLOW: VALUE (Bit 0)                  */
#define MCUCTRL_BOOTLOADERLOW_VALUE_Msk   (0x1UL)                   /*!< MCUCTRL BOOTLOADERLOW: VALUE (Bitfield-Mask: 0x01)    */
/* ======================================================  SHADOWVALID  ====================================================== */
#define MCUCTRL_SHADOWVALID_BL_DSLEEP_Pos (1UL)                     /*!< MCUCTRL SHADOWVALID: BL_DSLEEP (Bit 1)                */
#define MCUCTRL_SHADOWVALID_BL_DSLEEP_Msk (0x2UL)                   /*!< MCUCTRL SHADOWVALID: BL_DSLEEP (Bitfield-Mask: 0x01)  */
#define MCUCTRL_SHADOWVALID_VALID_Pos     (0UL)                     /*!< MCUCTRL SHADOWVALID: VALID (Bit 0)                    */
#define MCUCTRL_SHADOWVALID_VALID_Msk     (0x1UL)                   /*!< MCUCTRL SHADOWVALID: VALID (Bitfield-Mask: 0x01)      */
/* ====================================================  ICODEFAULTADDR  ===================================================== */
#define MCUCTRL_ICODEFAULTADDR_ADDR_Pos   (0UL)                     /*!< MCUCTRL ICODEFAULTADDR: ADDR (Bit 0)                  */
#define MCUCTRL_ICODEFAULTADDR_ADDR_Msk   (0xffffffffUL)            /*!< MCUCTRL ICODEFAULTADDR: ADDR (Bitfield-Mask: 0xffffffff) */
/* ====================================================  DCODEFAULTADDR  ===================================================== */
#define MCUCTRL_DCODEFAULTADDR_ADDR_Pos   (0UL)                     /*!< MCUCTRL DCODEFAULTADDR: ADDR (Bit 0)                  */
#define MCUCTRL_DCODEFAULTADDR_ADDR_Msk   (0xffffffffUL)            /*!< MCUCTRL DCODEFAULTADDR: ADDR (Bitfield-Mask: 0xffffffff) */
/* =====================================================  SYSFAULTADDR  ====================================================== */
#define MCUCTRL_SYSFAULTADDR_ADDR_Pos     (0UL)                     /*!< MCUCTRL SYSFAULTADDR: ADDR (Bit 0)                    */
#define MCUCTRL_SYSFAULTADDR_ADDR_Msk     (0xffffffffUL)            /*!< MCUCTRL SYSFAULTADDR: ADDR (Bitfield-Mask: 0xffffffff) */
/* ======================================================  FAULTSTATUS  ====================================================== */
#define MCUCTRL_FAULTSTATUS_SYS_Pos       (2UL)                     /*!< MCUCTRL FAULTSTATUS: SYS (Bit 2)                      */
#define MCUCTRL_FAULTSTATUS_SYS_Msk       (0x4UL)                   /*!< MCUCTRL FAULTSTATUS: SYS (Bitfield-Mask: 0x01)        */
#define MCUCTRL_FAULTSTATUS_DCODE_Pos     (1UL)                     /*!< MCUCTRL FAULTSTATUS: DCODE (Bit 1)                    */
#define MCUCTRL_FAULTSTATUS_DCODE_Msk     (0x2UL)                   /*!< MCUCTRL FAULTSTATUS: DCODE (Bitfield-Mask: 0x01)      */
#define MCUCTRL_FAULTSTATUS_ICODE_Pos     (0UL)                     /*!< MCUCTRL FAULTSTATUS: ICODE (Bit 0)                    */
#define MCUCTRL_FAULTSTATUS_ICODE_Msk     (0x1UL)                   /*!< MCUCTRL FAULTSTATUS: ICODE (Bitfield-Mask: 0x01)      */
/* ====================================================  FAULTCAPTUREEN  ===================================================== */
#define MCUCTRL_FAULTCAPTUREEN_ENABLE_Pos (0UL)                     /*!< MCUCTRL FAULTCAPTUREEN: ENABLE (Bit 0)                */
#define MCUCTRL_FAULTCAPTUREEN_ENABLE_Msk (0x1UL)                   /*!< MCUCTRL FAULTCAPTUREEN: ENABLE (Bitfield-Mask: 0x01)  */
/* =========================================================  DBGR1  ========================================================= */
#define MCUCTRL_DBGR1_ONETO8_Pos          (0UL)                     /*!< MCUCTRL DBGR1: ONETO8 (Bit 0)                         */
#define MCUCTRL_DBGR1_ONETO8_Msk          (0xffffffffUL)            /*!< MCUCTRL DBGR1: ONETO8 (Bitfield-Mask: 0xffffffff)     */
/* =========================================================  DBGR2  ========================================================= */
#define MCUCTRL_DBGR2_COOLCODE_Pos        (0UL)                     /*!< MCUCTRL DBGR2: COOLCODE (Bit 0)                       */
#define MCUCTRL_DBGR2_COOLCODE_Msk        (0xffffffffUL)            /*!< MCUCTRL DBGR2: COOLCODE (Bitfield-Mask: 0xffffffff)   */
/* =======================================================  PMUENABLE  ======================================================= */
#define MCUCTRL_PMUENABLE_ENABLE_Pos      (0UL)                     /*!< MCUCTRL PMUENABLE: ENABLE (Bit 0)                     */
#define MCUCTRL_PMUENABLE_ENABLE_Msk      (0x1UL)                   /*!< MCUCTRL PMUENABLE: ENABLE (Bitfield-Mask: 0x01)       */
/* =======================================================  TPIUCTRL  ======================================================== */
#define MCUCTRL_TPIUCTRL_CLKSEL_Pos       (8UL)                     /*!< MCUCTRL TPIUCTRL: CLKSEL (Bit 8)                      */
#define MCUCTRL_TPIUCTRL_CLKSEL_Msk       (0x700UL)                 /*!< MCUCTRL TPIUCTRL: CLKSEL (Bitfield-Mask: 0x07)        */
#define MCUCTRL_TPIUCTRL_ENABLE_Pos       (0UL)                     /*!< MCUCTRL TPIUCTRL: ENABLE (Bit 0)                      */
#define MCUCTRL_TPIUCTRL_ENABLE_Msk       (0x1UL)                   /*!< MCUCTRL TPIUCTRL: ENABLE (Bitfield-Mask: 0x01)        */
/* ======================================================  KEXTCLKSEL  ======================================================= */
#define MCUCTRL_KEXTCLKSEL_KEXTCLKSEL_Pos (0UL)                     /*!< MCUCTRL KEXTCLKSEL: KEXTCLKSEL (Bit 0)                */
#define MCUCTRL_KEXTCLKSEL_KEXTCLKSEL_Msk (0xffffffffUL)            /*!< MCUCTRL KEXTCLKSEL: KEXTCLKSEL (Bitfield-Mask: 0xffffffff) */


/* =========================================================================================================================== */
/* ================                                            PDM                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  PCFG  ========================================================== */
#define PDM_PCFG_LRSWAP_Pos               (31UL)                    /*!< PDM PCFG: LRSWAP (Bit 31)                             */
#define PDM_PCFG_LRSWAP_Msk               (0x80000000UL)            /*!< PDM PCFG: LRSWAP (Bitfield-Mask: 0x01)                */
#define PDM_PCFG_PGARIGHT_Pos             (27UL)                    /*!< PDM PCFG: PGARIGHT (Bit 27)                           */
#define PDM_PCFG_PGARIGHT_Msk             (0x78000000UL)            /*!< PDM PCFG: PGARIGHT (Bitfield-Mask: 0x0f)              */
#define PDM_PCFG_PGALEFT_Pos              (23UL)                    /*!< PDM PCFG: PGALEFT (Bit 23)                            */
#define PDM_PCFG_PGALEFT_Msk              (0x7800000UL)             /*!< PDM PCFG: PGALEFT (Bitfield-Mask: 0x0f)               */
#define PDM_PCFG_MCLKDIV_Pos              (17UL)                    /*!< PDM PCFG: MCLKDIV (Bit 17)                            */
#define PDM_PCFG_MCLKDIV_Msk              (0x60000UL)               /*!< PDM PCFG: MCLKDIV (Bitfield-Mask: 0x03)               */
#define PDM_PCFG_SINCRATE_Pos             (10UL)                    /*!< PDM PCFG: SINCRATE (Bit 10)                           */
#define PDM_PCFG_SINCRATE_Msk             (0x1fc00UL)               /*!< PDM PCFG: SINCRATE (Bitfield-Mask: 0x7f)              */
#define PDM_PCFG_ADCHPD_Pos               (9UL)                     /*!< PDM PCFG: ADCHPD (Bit 9)                              */
#define PDM_PCFG_ADCHPD_Msk               (0x200UL)                 /*!< PDM PCFG: ADCHPD (Bitfield-Mask: 0x01)                */
#define PDM_PCFG_HPCUTOFF_Pos             (5UL)                     /*!< PDM PCFG: HPCUTOFF (Bit 5)                            */
#define PDM_PCFG_HPCUTOFF_Msk             (0x1e0UL)                 /*!< PDM PCFG: HPCUTOFF (Bitfield-Mask: 0x0f)              */
#define PDM_PCFG_CYCLES_Pos               (2UL)                     /*!< PDM PCFG: CYCLES (Bit 2)                              */
#define PDM_PCFG_CYCLES_Msk               (0x1cUL)                  /*!< PDM PCFG: CYCLES (Bitfield-Mask: 0x07)                */
#define PDM_PCFG_SOFTMUTE_Pos             (1UL)                     /*!< PDM PCFG: SOFTMUTE (Bit 1)                            */
#define PDM_PCFG_SOFTMUTE_Msk             (0x2UL)                   /*!< PDM PCFG: SOFTMUTE (Bitfield-Mask: 0x01)              */
#define PDM_PCFG_PDMCORE_Pos              (0UL)                     /*!< PDM PCFG: PDMCORE (Bit 0)                             */
#define PDM_PCFG_PDMCORE_Msk              (0x1UL)                   /*!< PDM PCFG: PDMCORE (Bitfield-Mask: 0x01)               */
/* =========================================================  VCFG  ========================================================== */
#define PDM_VCFG_IOCLKEN_Pos              (31UL)                    /*!< PDM VCFG: IOCLKEN (Bit 31)                            */
#define PDM_VCFG_IOCLKEN_Msk              (0x80000000UL)            /*!< PDM VCFG: IOCLKEN (Bitfield-Mask: 0x01)               */
#define PDM_VCFG_RSTB_Pos                 (30UL)                    /*!< PDM VCFG: RSTB (Bit 30)                               */
#define PDM_VCFG_RSTB_Msk                 (0x40000000UL)            /*!< PDM VCFG: RSTB (Bitfield-Mask: 0x01)                  */
#define PDM_VCFG_PDMCLKSEL_Pos            (27UL)                    /*!< PDM VCFG: PDMCLKSEL (Bit 27)                          */
#define PDM_VCFG_PDMCLKSEL_Msk            (0x38000000UL)            /*!< PDM VCFG: PDMCLKSEL (Bitfield-Mask: 0x07)             */
#define PDM_VCFG_PDMCLK_Pos               (26UL)                    /*!< PDM VCFG: PDMCLK (Bit 26)                             */
#define PDM_VCFG_PDMCLK_Msk               (0x4000000UL)             /*!< PDM VCFG: PDMCLK (Bitfield-Mask: 0x01)                */
#define PDM_VCFG_I2SMODE_Pos              (20UL)                    /*!< PDM VCFG: I2SMODE (Bit 20)                            */
#define PDM_VCFG_I2SMODE_Msk              (0x100000UL)              /*!< PDM VCFG: I2SMODE (Bitfield-Mask: 0x01)               */
#define PDM_VCFG_BCLKINV_Pos              (19UL)                    /*!< PDM VCFG: BCLKINV (Bit 19)                            */
#define PDM_VCFG_BCLKINV_Msk              (0x80000UL)               /*!< PDM VCFG: BCLKINV (Bitfield-Mask: 0x01)               */
#define PDM_VCFG_DMICKDEL_Pos             (17UL)                    /*!< PDM VCFG: DMICKDEL (Bit 17)                           */
#define PDM_VCFG_DMICKDEL_Msk             (0x20000UL)               /*!< PDM VCFG: DMICKDEL (Bitfield-Mask: 0x01)              */
#define PDM_VCFG_SELAP_Pos                (16UL)                    /*!< PDM VCFG: SELAP (Bit 16)                              */
#define PDM_VCFG_SELAP_Msk                (0x10000UL)               /*!< PDM VCFG: SELAP (Bitfield-Mask: 0x01)                 */
#define PDM_VCFG_PCMPACK_Pos              (8UL)                     /*!< PDM VCFG: PCMPACK (Bit 8)                             */
#define PDM_VCFG_PCMPACK_Msk              (0x100UL)                 /*!< PDM VCFG: PCMPACK (Bitfield-Mask: 0x01)               */
#define PDM_VCFG_CHSET_Pos                (3UL)                     /*!< PDM VCFG: CHSET (Bit 3)                               */
#define PDM_VCFG_CHSET_Msk                (0x18UL)                  /*!< PDM VCFG: CHSET (Bitfield-Mask: 0x03)                 */
/* ==========================================================  FR  =========================================================== */
#define PDM_FR_FIFOCNT_Pos                (0UL)                     /*!< PDM FR: FIFOCNT (Bit 0)                               */
#define PDM_FR_FIFOCNT_Msk                (0x1ffUL)                 /*!< PDM FR: FIFOCNT (Bitfield-Mask: 0x1ff)                */
/* ==========================================================  FRD  ========================================================== */
#define PDM_FRD_FIFOREAD_Pos              (0UL)                     /*!< PDM FRD: FIFOREAD (Bit 0)                             */
#define PDM_FRD_FIFOREAD_Msk              (0xffffffffUL)            /*!< PDM FRD: FIFOREAD (Bitfield-Mask: 0xffffffff)         */
/* =========================================================  FLUSH  ========================================================= */
#define PDM_FLUSH_FIFOFLUSH_Pos           (0UL)                     /*!< PDM FLUSH: FIFOFLUSH (Bit 0)                          */
#define PDM_FLUSH_FIFOFLUSH_Msk           (0x1UL)                   /*!< PDM FLUSH: FIFOFLUSH (Bitfield-Mask: 0x01)            */
/* =========================================================  FTHR  ========================================================== */
#define PDM_FTHR_FIFOTHR_Pos              (0UL)                     /*!< PDM FTHR: FIFOTHR (Bit 0)                             */
#define PDM_FTHR_FIFOTHR_Msk              (0xffUL)                  /*!< PDM FTHR: FIFOTHR (Bitfield-Mask: 0xff)               */
/* =========================================================  INTEN  ========================================================= */
#define PDM_INTEN_UNDFL_Pos               (2UL)                     /*!< PDM INTEN: UNDFL (Bit 2)                              */
#define PDM_INTEN_UNDFL_Msk               (0x4UL)                   /*!< PDM INTEN: UNDFL (Bitfield-Mask: 0x01)                */
#define PDM_INTEN_OVF_Pos                 (1UL)                     /*!< PDM INTEN: OVF (Bit 1)                                */
#define PDM_INTEN_OVF_Msk                 (0x2UL)                   /*!< PDM INTEN: OVF (Bitfield-Mask: 0x01)                  */
#define PDM_INTEN_THR_Pos                 (0UL)                     /*!< PDM INTEN: THR (Bit 0)                                */
#define PDM_INTEN_THR_Msk                 (0x1UL)                   /*!< PDM INTEN: THR (Bitfield-Mask: 0x01)                  */
/* ========================================================  INTSTAT  ======================================================== */
#define PDM_INTSTAT_UNDFL_Pos             (2UL)                     /*!< PDM INTSTAT: UNDFL (Bit 2)                            */
#define PDM_INTSTAT_UNDFL_Msk             (0x4UL)                   /*!< PDM INTSTAT: UNDFL (Bitfield-Mask: 0x01)              */
#define PDM_INTSTAT_OVF_Pos               (1UL)                     /*!< PDM INTSTAT: OVF (Bit 1)                              */
#define PDM_INTSTAT_OVF_Msk               (0x2UL)                   /*!< PDM INTSTAT: OVF (Bitfield-Mask: 0x01)                */
#define PDM_INTSTAT_THR_Pos               (0UL)                     /*!< PDM INTSTAT: THR (Bit 0)                              */
#define PDM_INTSTAT_THR_Msk               (0x1UL)                   /*!< PDM INTSTAT: THR (Bitfield-Mask: 0x01)                */
/* ========================================================  INTCLR  ========================================================= */
#define PDM_INTCLR_UNDFL_Pos              (2UL)                     /*!< PDM INTCLR: UNDFL (Bit 2)                             */
#define PDM_INTCLR_UNDFL_Msk              (0x4UL)                   /*!< PDM INTCLR: UNDFL (Bitfield-Mask: 0x01)               */
#define PDM_INTCLR_OVF_Pos                (1UL)                     /*!< PDM INTCLR: OVF (Bit 1)                               */
#define PDM_INTCLR_OVF_Msk                (0x2UL)                   /*!< PDM INTCLR: OVF (Bitfield-Mask: 0x01)                 */
#define PDM_INTCLR_THR_Pos                (0UL)                     /*!< PDM INTCLR: THR (Bit 0)                               */
#define PDM_INTCLR_THR_Msk                (0x1UL)                   /*!< PDM INTCLR: THR (Bitfield-Mask: 0x01)                 */
/* ========================================================  INTSET  ========================================================= */
#define PDM_INTSET_UNDFL_Pos              (2UL)                     /*!< PDM INTSET: UNDFL (Bit 2)                             */
#define PDM_INTSET_UNDFL_Msk              (0x4UL)                   /*!< PDM INTSET: UNDFL (Bitfield-Mask: 0x01)               */
#define PDM_INTSET_OVF_Pos                (1UL)                     /*!< PDM INTSET: OVF (Bit 1)                               */
#define PDM_INTSET_OVF_Msk                (0x2UL)                   /*!< PDM INTSET: OVF (Bitfield-Mask: 0x01)                 */
#define PDM_INTSET_THR_Pos                (0UL)                     /*!< PDM INTSET: THR (Bit 0)                               */
#define PDM_INTSET_THR_Msk                (0x1UL)                   /*!< PDM INTSET: THR (Bitfield-Mask: 0x01)                 */


/* =========================================================================================================================== */
/* ================                                          PWRCTRL                                          ================ */
/* =========================================================================================================================== */

/* =======================================================  SUPPLYSRC  ======================================================= */
#define PWRCTRL_SUPPLYSRC_SWITCH_LDO_IN_SLEEP_Pos (2UL)             /*!< PWRCTRL SUPPLYSRC: SWITCH_LDO_IN_SLEEP (Bit 2)        */
#define PWRCTRL_SUPPLYSRC_SWITCH_LDO_IN_SLEEP_Msk (0x4UL)           /*!< PWRCTRL SUPPLYSRC: SWITCH_LDO_IN_SLEEP (Bitfield-Mask: 0x01) */
#define PWRCTRL_SUPPLYSRC_COREBUCKEN_Pos  (1UL)                     /*!< PWRCTRL SUPPLYSRC: COREBUCKEN (Bit 1)                 */
#define PWRCTRL_SUPPLYSRC_COREBUCKEN_Msk  (0x2UL)                   /*!< PWRCTRL SUPPLYSRC: COREBUCKEN (Bitfield-Mask: 0x01)   */
#define PWRCTRL_SUPPLYSRC_MEMBUCKEN_Pos   (0UL)                     /*!< PWRCTRL SUPPLYSRC: MEMBUCKEN (Bit 0)                  */
#define PWRCTRL_SUPPLYSRC_MEMBUCKEN_Msk   (0x1UL)                   /*!< PWRCTRL SUPPLYSRC: MEMBUCKEN (Bitfield-Mask: 0x01)    */
/* ======================================================  POWERSTATUS  ====================================================== */
#define PWRCTRL_POWERSTATUS_COREBUCKON_Pos (1UL)                    /*!< PWRCTRL POWERSTATUS: COREBUCKON (Bit 1)               */
#define PWRCTRL_POWERSTATUS_COREBUCKON_Msk (0x2UL)                  /*!< PWRCTRL POWERSTATUS: COREBUCKON (Bitfield-Mask: 0x01) */
#define PWRCTRL_POWERSTATUS_MEMBUCKON_Pos (0UL)                     /*!< PWRCTRL POWERSTATUS: MEMBUCKON (Bit 0)                */
#define PWRCTRL_POWERSTATUS_MEMBUCKON_Msk (0x1UL)                   /*!< PWRCTRL POWERSTATUS: MEMBUCKON (Bitfield-Mask: 0x01)  */
/* =======================================================  DEVICEEN  ======================================================== */
#define PWRCTRL_DEVICEEN_PDM_Pos          (10UL)                    /*!< PWRCTRL DEVICEEN: PDM (Bit 10)                        */
#define PWRCTRL_DEVICEEN_PDM_Msk          (0x400UL)                 /*!< PWRCTRL DEVICEEN: PDM (Bitfield-Mask: 0x01)           */
#define PWRCTRL_DEVICEEN_ADC_Pos          (9UL)                     /*!< PWRCTRL DEVICEEN: ADC (Bit 9)                         */
#define PWRCTRL_DEVICEEN_ADC_Msk          (0x200UL)                 /*!< PWRCTRL DEVICEEN: ADC (Bitfield-Mask: 0x01)           */
#define PWRCTRL_DEVICEEN_UART1_Pos        (8UL)                     /*!< PWRCTRL DEVICEEN: UART1 (Bit 8)                       */
#define PWRCTRL_DEVICEEN_UART1_Msk        (0x100UL)                 /*!< PWRCTRL DEVICEEN: UART1 (Bitfield-Mask: 0x01)         */
#define PWRCTRL_DEVICEEN_UART0_Pos        (7UL)                     /*!< PWRCTRL DEVICEEN: UART0 (Bit 7)                       */
#define PWRCTRL_DEVICEEN_UART0_Msk        (0x80UL)                  /*!< PWRCTRL DEVICEEN: UART0 (Bitfield-Mask: 0x01)         */
#define PWRCTRL_DEVICEEN_IO_MASTER5_Pos   (6UL)                     /*!< PWRCTRL DEVICEEN: IO_MASTER5 (Bit 6)                  */
#define PWRCTRL_DEVICEEN_IO_MASTER5_Msk   (0x40UL)                  /*!< PWRCTRL DEVICEEN: IO_MASTER5 (Bitfield-Mask: 0x01)    */
#define PWRCTRL_DEVICEEN_IO_MASTER4_Pos   (5UL)                     /*!< PWRCTRL DEVICEEN: IO_MASTER4 (Bit 5)                  */
#define PWRCTRL_DEVICEEN_IO_MASTER4_Msk   (0x20UL)                  /*!< PWRCTRL DEVICEEN: IO_MASTER4 (Bitfield-Mask: 0x01)    */
#define PWRCTRL_DEVICEEN_IO_MASTER3_Pos   (4UL)                     /*!< PWRCTRL DEVICEEN: IO_MASTER3 (Bit 4)                  */
#define PWRCTRL_DEVICEEN_IO_MASTER3_Msk   (0x10UL)                  /*!< PWRCTRL DEVICEEN: IO_MASTER3 (Bitfield-Mask: 0x01)    */
#define PWRCTRL_DEVICEEN_IO_MASTER2_Pos   (3UL)                     /*!< PWRCTRL DEVICEEN: IO_MASTER2 (Bit 3)                  */
#define PWRCTRL_DEVICEEN_IO_MASTER2_Msk   (0x8UL)                   /*!< PWRCTRL DEVICEEN: IO_MASTER2 (Bitfield-Mask: 0x01)    */
#define PWRCTRL_DEVICEEN_IO_MASTER1_Pos   (2UL)                     /*!< PWRCTRL DEVICEEN: IO_MASTER1 (Bit 2)                  */
#define PWRCTRL_DEVICEEN_IO_MASTER1_Msk   (0x4UL)                   /*!< PWRCTRL DEVICEEN: IO_MASTER1 (Bitfield-Mask: 0x01)    */
#define PWRCTRL_DEVICEEN_IO_MASTER0_Pos   (1UL)                     /*!< PWRCTRL DEVICEEN: IO_MASTER0 (Bit 1)                  */
#define PWRCTRL_DEVICEEN_IO_MASTER0_Msk   (0x2UL)                   /*!< PWRCTRL DEVICEEN: IO_MASTER0 (Bitfield-Mask: 0x01)    */
#define PWRCTRL_DEVICEEN_IO_SLAVE_Pos     (0UL)                     /*!< PWRCTRL DEVICEEN: IO_SLAVE (Bit 0)                    */
#define PWRCTRL_DEVICEEN_IO_SLAVE_Msk     (0x1UL)                   /*!< PWRCTRL DEVICEEN: IO_SLAVE (Bitfield-Mask: 0x01)      */
/* ====================================================  SRAMPWDINSLEEP  ===================================================== */
#define PWRCTRL_SRAMPWDINSLEEP_CACHE_PWD_SLP_Pos (31UL)             /*!< PWRCTRL SRAMPWDINSLEEP: CACHE_PWD_SLP (Bit 31)        */
#define PWRCTRL_SRAMPWDINSLEEP_CACHE_PWD_SLP_Msk (0x80000000UL)     /*!< PWRCTRL SRAMPWDINSLEEP: CACHE_PWD_SLP (Bitfield-Mask: 0x01) */
#define PWRCTRL_SRAMPWDINSLEEP_SRAMSLEEPPOWERDOWN_Pos (0UL)         /*!< PWRCTRL SRAMPWDINSLEEP: SRAMSLEEPPOWERDOWN (Bit 0)    */
#define PWRCTRL_SRAMPWDINSLEEP_SRAMSLEEPPOWERDOWN_Msk (0x7ffUL)     /*!< PWRCTRL SRAMPWDINSLEEP: SRAMSLEEPPOWERDOWN (Bitfield-Mask: 0x7ff) */
/* =========================================================  MEMEN  ========================================================= */
#define PWRCTRL_MEMEN_CACHEB2_Pos         (31UL)                    /*!< PWRCTRL MEMEN: CACHEB2 (Bit 31)                       */
#define PWRCTRL_MEMEN_CACHEB2_Msk         (0x80000000UL)            /*!< PWRCTRL MEMEN: CACHEB2 (Bitfield-Mask: 0x01)          */
#define PWRCTRL_MEMEN_CACHEB0_Pos         (29UL)                    /*!< PWRCTRL MEMEN: CACHEB0 (Bit 29)                       */
#define PWRCTRL_MEMEN_CACHEB0_Msk         (0x20000000UL)            /*!< PWRCTRL MEMEN: CACHEB0 (Bitfield-Mask: 0x01)          */
#define PWRCTRL_MEMEN_FLASH1_Pos          (12UL)                    /*!< PWRCTRL MEMEN: FLASH1 (Bit 12)                        */
#define PWRCTRL_MEMEN_FLASH1_Msk          (0x1000UL)                /*!< PWRCTRL MEMEN: FLASH1 (Bitfield-Mask: 0x01)           */
#define PWRCTRL_MEMEN_FLASH0_Pos          (11UL)                    /*!< PWRCTRL MEMEN: FLASH0 (Bit 11)                        */
#define PWRCTRL_MEMEN_FLASH0_Msk          (0x800UL)                 /*!< PWRCTRL MEMEN: FLASH0 (Bitfield-Mask: 0x01)           */
#define PWRCTRL_MEMEN_SRAMEN_Pos          (0UL)                     /*!< PWRCTRL MEMEN: SRAMEN (Bit 0)                         */
#define PWRCTRL_MEMEN_SRAMEN_Msk          (0x7ffUL)                 /*!< PWRCTRL MEMEN: SRAMEN (Bitfield-Mask: 0x7ff)          */
/* ======================================================  PWRONSTATUS  ====================================================== */
#define PWRCTRL_PWRONSTATUS_PD_CACHEB2_Pos (21UL)                   /*!< PWRCTRL PWRONSTATUS: PD_CACHEB2 (Bit 21)              */
#define PWRCTRL_PWRONSTATUS_PD_CACHEB2_Msk (0x200000UL)             /*!< PWRCTRL PWRONSTATUS: PD_CACHEB2 (Bitfield-Mask: 0x01) */
#define PWRCTRL_PWRONSTATUS_PD_CACHEB0_Pos (19UL)                   /*!< PWRCTRL PWRONSTATUS: PD_CACHEB0 (Bit 19)              */
#define PWRCTRL_PWRONSTATUS_PD_CACHEB0_Msk (0x80000UL)              /*!< PWRCTRL PWRONSTATUS: PD_CACHEB0 (Bitfield-Mask: 0x01) */
#define PWRCTRL_PWRONSTATUS_PD_GRP7_SRAM_Pos (18UL)                 /*!< PWRCTRL PWRONSTATUS: PD_GRP7_SRAM (Bit 18)            */
#define PWRCTRL_PWRONSTATUS_PD_GRP7_SRAM_Msk (0x40000UL)            /*!< PWRCTRL PWRONSTATUS: PD_GRP7_SRAM (Bitfield-Mask: 0x01) */
#define PWRCTRL_PWRONSTATUS_PD_GRP6_SRAM_Pos (17UL)                 /*!< PWRCTRL PWRONSTATUS: PD_GRP6_SRAM (Bit 17)            */
#define PWRCTRL_PWRONSTATUS_PD_GRP6_SRAM_Msk (0x20000UL)            /*!< PWRCTRL PWRONSTATUS: PD_GRP6_SRAM (Bitfield-Mask: 0x01) */
#define PWRCTRL_PWRONSTATUS_PD_GRP5_SRAM_Pos (16UL)                 /*!< PWRCTRL PWRONSTATUS: PD_GRP5_SRAM (Bit 16)            */
#define PWRCTRL_PWRONSTATUS_PD_GRP5_SRAM_Msk (0x10000UL)            /*!< PWRCTRL PWRONSTATUS: PD_GRP5_SRAM (Bitfield-Mask: 0x01) */
#define PWRCTRL_PWRONSTATUS_PD_GRP4_SRAM_Pos (15UL)                 /*!< PWRCTRL PWRONSTATUS: PD_GRP4_SRAM (Bit 15)            */
#define PWRCTRL_PWRONSTATUS_PD_GRP4_SRAM_Msk (0x8000UL)             /*!< PWRCTRL PWRONSTATUS: PD_GRP4_SRAM (Bitfield-Mask: 0x01) */
#define PWRCTRL_PWRONSTATUS_PD_GRP3_SRAM_Pos (14UL)                 /*!< PWRCTRL PWRONSTATUS: PD_GRP3_SRAM (Bit 14)            */
#define PWRCTRL_PWRONSTATUS_PD_GRP3_SRAM_Msk (0x4000UL)             /*!< PWRCTRL PWRONSTATUS: PD_GRP3_SRAM (Bitfield-Mask: 0x01) */
#define PWRCTRL_PWRONSTATUS_PD_GRP2_SRAM_Pos (13UL)                 /*!< PWRCTRL PWRONSTATUS: PD_GRP2_SRAM (Bit 13)            */
#define PWRCTRL_PWRONSTATUS_PD_GRP2_SRAM_Msk (0x2000UL)             /*!< PWRCTRL PWRONSTATUS: PD_GRP2_SRAM (Bitfield-Mask: 0x01) */
#define PWRCTRL_PWRONSTATUS_PD_GRP1_SRAM_Pos (12UL)                 /*!< PWRCTRL PWRONSTATUS: PD_GRP1_SRAM (Bit 12)            */
#define PWRCTRL_PWRONSTATUS_PD_GRP1_SRAM_Msk (0x1000UL)             /*!< PWRCTRL PWRONSTATUS: PD_GRP1_SRAM (Bitfield-Mask: 0x01) */
#define PWRCTRL_PWRONSTATUS_PD_GRP0_SRAM3_Pos (11UL)                /*!< PWRCTRL PWRONSTATUS: PD_GRP0_SRAM3 (Bit 11)           */
#define PWRCTRL_PWRONSTATUS_PD_GRP0_SRAM3_Msk (0x800UL)             /*!< PWRCTRL PWRONSTATUS: PD_GRP0_SRAM3 (Bitfield-Mask: 0x01) */
#define PWRCTRL_PWRONSTATUS_PD_GRP0_SRAM2_Pos (10UL)                /*!< PWRCTRL PWRONSTATUS: PD_GRP0_SRAM2 (Bit 10)           */
#define PWRCTRL_PWRONSTATUS_PD_GRP0_SRAM2_Msk (0x400UL)             /*!< PWRCTRL PWRONSTATUS: PD_GRP0_SRAM2 (Bitfield-Mask: 0x01) */
#define PWRCTRL_PWRONSTATUS_PD_GRP0_SRAM1_Pos (9UL)                 /*!< PWRCTRL PWRONSTATUS: PD_GRP0_SRAM1 (Bit 9)            */
#define PWRCTRL_PWRONSTATUS_PD_GRP0_SRAM1_Msk (0x200UL)             /*!< PWRCTRL PWRONSTATUS: PD_GRP0_SRAM1 (Bitfield-Mask: 0x01) */
#define PWRCTRL_PWRONSTATUS_PD_GRP0_SRAM0_Pos (8UL)                 /*!< PWRCTRL PWRONSTATUS: PD_GRP0_SRAM0 (Bit 8)            */
#define PWRCTRL_PWRONSTATUS_PD_GRP0_SRAM0_Msk (0x100UL)             /*!< PWRCTRL PWRONSTATUS: PD_GRP0_SRAM0 (Bitfield-Mask: 0x01) */
#define PWRCTRL_PWRONSTATUS_PDADC_Pos     (7UL)                     /*!< PWRCTRL PWRONSTATUS: PDADC (Bit 7)                    */
#define PWRCTRL_PWRONSTATUS_PDADC_Msk     (0x80UL)                  /*!< PWRCTRL PWRONSTATUS: PDADC (Bitfield-Mask: 0x01)      */
#define PWRCTRL_PWRONSTATUS_PD_FLAM1_Pos  (6UL)                     /*!< PWRCTRL PWRONSTATUS: PD_FLAM1 (Bit 6)                 */
#define PWRCTRL_PWRONSTATUS_PD_FLAM1_Msk  (0x40UL)                  /*!< PWRCTRL PWRONSTATUS: PD_FLAM1 (Bitfield-Mask: 0x01)   */
#define PWRCTRL_PWRONSTATUS_PD_FLAM0_Pos  (5UL)                     /*!< PWRCTRL PWRONSTATUS: PD_FLAM0 (Bit 5)                 */
#define PWRCTRL_PWRONSTATUS_PD_FLAM0_Msk  (0x20UL)                  /*!< PWRCTRL PWRONSTATUS: PD_FLAM0 (Bitfield-Mask: 0x01)   */
#define PWRCTRL_PWRONSTATUS_PD_PDM_Pos    (4UL)                     /*!< PWRCTRL PWRONSTATUS: PD_PDM (Bit 4)                   */
#define PWRCTRL_PWRONSTATUS_PD_PDM_Msk    (0x10UL)                  /*!< PWRCTRL PWRONSTATUS: PD_PDM (Bitfield-Mask: 0x01)     */
#define PWRCTRL_PWRONSTATUS_PDC_Pos       (3UL)                     /*!< PWRCTRL PWRONSTATUS: PDC (Bit 3)                      */
#define PWRCTRL_PWRONSTATUS_PDC_Msk       (0x8UL)                   /*!< PWRCTRL PWRONSTATUS: PDC (Bitfield-Mask: 0x01)        */
#define PWRCTRL_PWRONSTATUS_PDB_Pos       (2UL)                     /*!< PWRCTRL PWRONSTATUS: PDB (Bit 2)                      */
#define PWRCTRL_PWRONSTATUS_PDB_Msk       (0x4UL)                   /*!< PWRCTRL PWRONSTATUS: PDB (Bitfield-Mask: 0x01)        */
#define PWRCTRL_PWRONSTATUS_PDA_Pos       (1UL)                     /*!< PWRCTRL PWRONSTATUS: PDA (Bit 1)                      */
#define PWRCTRL_PWRONSTATUS_PDA_Msk       (0x2UL)                   /*!< PWRCTRL PWRONSTATUS: PDA (Bitfield-Mask: 0x01)        */
/* =======================================================  SRAMCTRL  ======================================================== */
#define PWRCTRL_SRAMCTRL_SRAM_MASTER_CLKGATE_Pos (2UL)              /*!< PWRCTRL SRAMCTRL: SRAM_MASTER_CLKGATE (Bit 2)         */
#define PWRCTRL_SRAMCTRL_SRAM_MASTER_CLKGATE_Msk (0x4UL)            /*!< PWRCTRL SRAMCTRL: SRAM_MASTER_CLKGATE (Bitfield-Mask: 0x01) */
#define PWRCTRL_SRAMCTRL_SRAM_CLKGATE_Pos (1UL)                     /*!< PWRCTRL SRAMCTRL: SRAM_CLKGATE (Bit 1)                */
#define PWRCTRL_SRAMCTRL_SRAM_CLKGATE_Msk (0x2UL)                   /*!< PWRCTRL SRAMCTRL: SRAM_CLKGATE (Bitfield-Mask: 0x01)  */
#define PWRCTRL_SRAMCTRL_SRAM_LIGHT_SLEEP_Pos (0UL)                 /*!< PWRCTRL SRAMCTRL: SRAM_LIGHT_SLEEP (Bit 0)            */
#define PWRCTRL_SRAMCTRL_SRAM_LIGHT_SLEEP_Msk (0x1UL)               /*!< PWRCTRL SRAMCTRL: SRAM_LIGHT_SLEEP (Bitfield-Mask: 0x01) */
/* =======================================================  ADCSTATUS  ======================================================= */
#define PWRCTRL_ADCSTATUS_ADC_REFBUF_PWD_Pos (5UL)                  /*!< PWRCTRL ADCSTATUS: ADC_REFBUF_PWD (Bit 5)             */
#define PWRCTRL_ADCSTATUS_ADC_REFBUF_PWD_Msk (0x20UL)               /*!< PWRCTRL ADCSTATUS: ADC_REFBUF_PWD (Bitfield-Mask: 0x01) */
#define PWRCTRL_ADCSTATUS_ADC_REFKEEP_PWD_Pos (4UL)                 /*!< PWRCTRL ADCSTATUS: ADC_REFKEEP_PWD (Bit 4)            */
#define PWRCTRL_ADCSTATUS_ADC_REFKEEP_PWD_Msk (0x10UL)              /*!< PWRCTRL ADCSTATUS: ADC_REFKEEP_PWD (Bitfield-Mask: 0x01) */
#define PWRCTRL_ADCSTATUS_ADC_VBAT_PWD_Pos (3UL)                    /*!< PWRCTRL ADCSTATUS: ADC_VBAT_PWD (Bit 3)               */
#define PWRCTRL_ADCSTATUS_ADC_VBAT_PWD_Msk (0x8UL)                  /*!< PWRCTRL ADCSTATUS: ADC_VBAT_PWD (Bitfield-Mask: 0x01) */
#define PWRCTRL_ADCSTATUS_ADC_VPTAT_PWD_Pos (2UL)                   /*!< PWRCTRL ADCSTATUS: ADC_VPTAT_PWD (Bit 2)              */
#define PWRCTRL_ADCSTATUS_ADC_VPTAT_PWD_Msk (0x4UL)                 /*!< PWRCTRL ADCSTATUS: ADC_VPTAT_PWD (Bitfield-Mask: 0x01) */
#define PWRCTRL_ADCSTATUS_ADC_BGT_PWD_Pos (1UL)                     /*!< PWRCTRL ADCSTATUS: ADC_BGT_PWD (Bit 1)                */
#define PWRCTRL_ADCSTATUS_ADC_BGT_PWD_Msk (0x2UL)                   /*!< PWRCTRL ADCSTATUS: ADC_BGT_PWD (Bitfield-Mask: 0x01)  */
#define PWRCTRL_ADCSTATUS_ADC_PWD_Pos     (0UL)                     /*!< PWRCTRL ADCSTATUS: ADC_PWD (Bit 0)                    */
#define PWRCTRL_ADCSTATUS_ADC_PWD_Msk     (0x1UL)                   /*!< PWRCTRL ADCSTATUS: ADC_PWD (Bitfield-Mask: 0x01)      */
/* ========================================================  MISCOPT  ======================================================== */
#define PWRCTRL_MISCOPT_DIS_LDOLPMODE_TIMERS_Pos (2UL)              /*!< PWRCTRL MISCOPT: DIS_LDOLPMODE_TIMERS (Bit 2)         */
#define PWRCTRL_MISCOPT_DIS_LDOLPMODE_TIMERS_Msk (0x4UL)            /*!< PWRCTRL MISCOPT: DIS_LDOLPMODE_TIMERS (Bitfield-Mask: 0x01) */
#define PWRCTRL_MISCOPT_DIS_LDOLPMODE_HFRC_Pos (1UL)                /*!< PWRCTRL MISCOPT: DIS_LDOLPMODE_HFRC (Bit 1)           */
#define PWRCTRL_MISCOPT_DIS_LDOLPMODE_HFRC_Msk (0x2UL)              /*!< PWRCTRL MISCOPT: DIS_LDOLPMODE_HFRC (Bitfield-Mask: 0x01) */
#define PWRCTRL_MISCOPT_ADC_EN_MASK_Pos   (0UL)                     /*!< PWRCTRL MISCOPT: ADC_EN_MASK (Bit 0)                  */
#define PWRCTRL_MISCOPT_ADC_EN_MASK_Msk   (0x1UL)                   /*!< PWRCTRL MISCOPT: ADC_EN_MASK (Bitfield-Mask: 0x01)    */


/* =========================================================================================================================== */
/* ================                                          RSTGEN                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
#define RSTGEN_CFG_WDREN_Pos              (1UL)                     /*!< RSTGEN CFG: WDREN (Bit 1)                             */
#define RSTGEN_CFG_WDREN_Msk              (0x2UL)                   /*!< RSTGEN CFG: WDREN (Bitfield-Mask: 0x01)               */
#define RSTGEN_CFG_BODHREN_Pos            (0UL)                     /*!< RSTGEN CFG: BODHREN (Bit 0)                           */
#define RSTGEN_CFG_BODHREN_Msk            (0x1UL)                   /*!< RSTGEN CFG: BODHREN (Bitfield-Mask: 0x01)             */
/* =========================================================  SWPOI  ========================================================= */
#define RSTGEN_SWPOI_SWPOIKEY_Pos         (0UL)                     /*!< RSTGEN SWPOI: SWPOIKEY (Bit 0)                        */
#define RSTGEN_SWPOI_SWPOIKEY_Msk         (0xffUL)                  /*!< RSTGEN SWPOI: SWPOIKEY (Bitfield-Mask: 0xff)          */
/* =========================================================  SWPOR  ========================================================= */
#define RSTGEN_SWPOR_SWPORKEY_Pos         (0UL)                     /*!< RSTGEN SWPOR: SWPORKEY (Bit 0)                        */
#define RSTGEN_SWPOR_SWPORKEY_Msk         (0xffUL)                  /*!< RSTGEN SWPOR: SWPORKEY (Bitfield-Mask: 0xff)          */
/* =========================================================  STAT  ========================================================== */
#define RSTGEN_STAT_WDRSTAT_Pos           (6UL)                     /*!< RSTGEN STAT: WDRSTAT (Bit 6)                          */
#define RSTGEN_STAT_WDRSTAT_Msk           (0x40UL)                  /*!< RSTGEN STAT: WDRSTAT (Bitfield-Mask: 0x01)            */
#define RSTGEN_STAT_DBGRSTAT_Pos          (5UL)                     /*!< RSTGEN STAT: DBGRSTAT (Bit 5)                         */
#define RSTGEN_STAT_DBGRSTAT_Msk          (0x20UL)                  /*!< RSTGEN STAT: DBGRSTAT (Bitfield-Mask: 0x01)           */
#define RSTGEN_STAT_POIRSTAT_Pos          (4UL)                     /*!< RSTGEN STAT: POIRSTAT (Bit 4)                         */
#define RSTGEN_STAT_POIRSTAT_Msk          (0x10UL)                  /*!< RSTGEN STAT: POIRSTAT (Bitfield-Mask: 0x01)           */
#define RSTGEN_STAT_SWRSTAT_Pos           (3UL)                     /*!< RSTGEN STAT: SWRSTAT (Bit 3)                          */
#define RSTGEN_STAT_SWRSTAT_Msk           (0x8UL)                   /*!< RSTGEN STAT: SWRSTAT (Bitfield-Mask: 0x01)            */
#define RSTGEN_STAT_BORSTAT_Pos           (2UL)                     /*!< RSTGEN STAT: BORSTAT (Bit 2)                          */
#define RSTGEN_STAT_BORSTAT_Msk           (0x4UL)                   /*!< RSTGEN STAT: BORSTAT (Bitfield-Mask: 0x01)            */
#define RSTGEN_STAT_PORSTAT_Pos           (1UL)                     /*!< RSTGEN STAT: PORSTAT (Bit 1)                          */
#define RSTGEN_STAT_PORSTAT_Msk           (0x2UL)                   /*!< RSTGEN STAT: PORSTAT (Bitfield-Mask: 0x01)            */
#define RSTGEN_STAT_EXRSTAT_Pos           (0UL)                     /*!< RSTGEN STAT: EXRSTAT (Bit 0)                          */
#define RSTGEN_STAT_EXRSTAT_Msk           (0x1UL)                   /*!< RSTGEN STAT: EXRSTAT (Bitfield-Mask: 0x01)            */
/* ========================================================  CLRSTAT  ======================================================== */
#define RSTGEN_CLRSTAT_CLRSTAT_Pos        (0UL)                     /*!< RSTGEN CLRSTAT: CLRSTAT (Bit 0)                       */
#define RSTGEN_CLRSTAT_CLRSTAT_Msk        (0x1UL)                   /*!< RSTGEN CLRSTAT: CLRSTAT (Bitfield-Mask: 0x01)         */
/* =======================================================  TPIU_RST  ======================================================== */
#define RSTGEN_TPIU_RST_TPIURST_Pos       (0UL)                     /*!< RSTGEN TPIU_RST: TPIURST (Bit 0)                      */
#define RSTGEN_TPIU_RST_TPIURST_Msk       (0x1UL)                   /*!< RSTGEN TPIU_RST: TPIURST (Bitfield-Mask: 0x01)        */
/* =========================================================  INTEN  ========================================================= */
#define RSTGEN_INTEN_BODH_Pos             (0UL)                     /*!< RSTGEN INTEN: BODH (Bit 0)                            */
#define RSTGEN_INTEN_BODH_Msk             (0x1UL)                   /*!< RSTGEN INTEN: BODH (Bitfield-Mask: 0x01)              */
/* ========================================================  INTSTAT  ======================================================== */
#define RSTGEN_INTSTAT_BODH_Pos           (0UL)                     /*!< RSTGEN INTSTAT: BODH (Bit 0)                          */
#define RSTGEN_INTSTAT_BODH_Msk           (0x1UL)                   /*!< RSTGEN INTSTAT: BODH (Bitfield-Mask: 0x01)            */
/* ========================================================  INTCLR  ========================================================= */
#define RSTGEN_INTCLR_BODH_Pos            (0UL)                     /*!< RSTGEN INTCLR: BODH (Bit 0)                           */
#define RSTGEN_INTCLR_BODH_Msk            (0x1UL)                   /*!< RSTGEN INTCLR: BODH (Bitfield-Mask: 0x01)             */
/* ========================================================  INTSET  ========================================================= */
#define RSTGEN_INTSET_BODH_Pos            (0UL)                     /*!< RSTGEN INTSET: BODH (Bit 0)                           */
#define RSTGEN_INTSET_BODH_Msk            (0x1UL)                   /*!< RSTGEN INTSET: BODH (Bitfield-Mask: 0x01)             */


/* =========================================================================================================================== */
/* ================                                           UART0                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  DR  =========================================================== */
#define UART0_DR_OEDATA_Pos               (11UL)                    /*!< UART0 DR: OEDATA (Bit 11)                             */
#define UART0_DR_OEDATA_Msk               (0x800UL)                 /*!< UART0 DR: OEDATA (Bitfield-Mask: 0x01)                */
#define UART0_DR_BEDATA_Pos               (10UL)                    /*!< UART0 DR: BEDATA (Bit 10)                             */
#define UART0_DR_BEDATA_Msk               (0x400UL)                 /*!< UART0 DR: BEDATA (Bitfield-Mask: 0x01)                */
#define UART0_DR_PEDATA_Pos               (9UL)                     /*!< UART0 DR: PEDATA (Bit 9)                              */
#define UART0_DR_PEDATA_Msk               (0x200UL)                 /*!< UART0 DR: PEDATA (Bitfield-Mask: 0x01)                */
#define UART0_DR_FEDATA_Pos               (8UL)                     /*!< UART0 DR: FEDATA (Bit 8)                              */
#define UART0_DR_FEDATA_Msk               (0x100UL)                 /*!< UART0 DR: FEDATA (Bitfield-Mask: 0x01)                */
#define UART0_DR_DATA_Pos                 (0UL)                     /*!< UART0 DR: DATA (Bit 0)                                */
#define UART0_DR_DATA_Msk                 (0xffUL)                  /*!< UART0 DR: DATA (Bitfield-Mask: 0xff)                  */
/* ==========================================================  RSR  ========================================================== */
#define UART0_RSR_OESTAT_Pos              (3UL)                     /*!< UART0 RSR: OESTAT (Bit 3)                             */
#define UART0_RSR_OESTAT_Msk              (0x8UL)                   /*!< UART0 RSR: OESTAT (Bitfield-Mask: 0x01)               */
#define UART0_RSR_BESTAT_Pos              (2UL)                     /*!< UART0 RSR: BESTAT (Bit 2)                             */
#define UART0_RSR_BESTAT_Msk              (0x4UL)                   /*!< UART0 RSR: BESTAT (Bitfield-Mask: 0x01)               */
#define UART0_RSR_PESTAT_Pos              (1UL)                     /*!< UART0 RSR: PESTAT (Bit 1)                             */
#define UART0_RSR_PESTAT_Msk              (0x2UL)                   /*!< UART0 RSR: PESTAT (Bitfield-Mask: 0x01)               */
#define UART0_RSR_FESTAT_Pos              (0UL)                     /*!< UART0 RSR: FESTAT (Bit 0)                             */
#define UART0_RSR_FESTAT_Msk              (0x1UL)                   /*!< UART0 RSR: FESTAT (Bitfield-Mask: 0x01)               */
/* ==========================================================  FR  =========================================================== */
#define UART0_FR_TXBUSY_Pos               (8UL)                     /*!< UART0 FR: TXBUSY (Bit 8)                              */
#define UART0_FR_TXBUSY_Msk               (0x100UL)                 /*!< UART0 FR: TXBUSY (Bitfield-Mask: 0x01)                */
#define UART0_FR_TXFE_Pos                 (7UL)                     /*!< UART0 FR: TXFE (Bit 7)                                */
#define UART0_FR_TXFE_Msk                 (0x80UL)                  /*!< UART0 FR: TXFE (Bitfield-Mask: 0x01)                  */
#define UART0_FR_RXFF_Pos                 (6UL)                     /*!< UART0 FR: RXFF (Bit 6)                                */
#define UART0_FR_RXFF_Msk                 (0x40UL)                  /*!< UART0 FR: RXFF (Bitfield-Mask: 0x01)                  */
#define UART0_FR_TXFF_Pos                 (5UL)                     /*!< UART0 FR: TXFF (Bit 5)                                */
#define UART0_FR_TXFF_Msk                 (0x20UL)                  /*!< UART0 FR: TXFF (Bitfield-Mask: 0x01)                  */
#define UART0_FR_RXFE_Pos                 (4UL)                     /*!< UART0 FR: RXFE (Bit 4)                                */
#define UART0_FR_RXFE_Msk                 (0x10UL)                  /*!< UART0 FR: RXFE (Bitfield-Mask: 0x01)                  */
#define UART0_FR_BUSY_Pos                 (3UL)                     /*!< UART0 FR: BUSY (Bit 3)                                */
#define UART0_FR_BUSY_Msk                 (0x8UL)                   /*!< UART0 FR: BUSY (Bitfield-Mask: 0x01)                  */
#define UART0_FR_DCD_Pos                  (2UL)                     /*!< UART0 FR: DCD (Bit 2)                                 */
#define UART0_FR_DCD_Msk                  (0x4UL)                   /*!< UART0 FR: DCD (Bitfield-Mask: 0x01)                   */
#define UART0_FR_DSR_Pos                  (1UL)                     /*!< UART0 FR: DSR (Bit 1)                                 */
#define UART0_FR_DSR_Msk                  (0x2UL)                   /*!< UART0 FR: DSR (Bitfield-Mask: 0x01)                   */
#define UART0_FR_CTS_Pos                  (0UL)                     /*!< UART0 FR: CTS (Bit 0)                                 */
#define UART0_FR_CTS_Msk                  (0x1UL)                   /*!< UART0 FR: CTS (Bitfield-Mask: 0x01)                   */
/* =========================================================  ILPR  ========================================================== */
#define UART0_ILPR_ILPDVSR_Pos            (0UL)                     /*!< UART0 ILPR: ILPDVSR (Bit 0)                           */
#define UART0_ILPR_ILPDVSR_Msk            (0xffUL)                  /*!< UART0 ILPR: ILPDVSR (Bitfield-Mask: 0xff)             */
/* =========================================================  IBRD  ========================================================== */
#define UART0_IBRD_DIVINT_Pos             (0UL)                     /*!< UART0 IBRD: DIVINT (Bit 0)                            */
#define UART0_IBRD_DIVINT_Msk             (0xffffUL)                /*!< UART0 IBRD: DIVINT (Bitfield-Mask: 0xffff)            */
/* =========================================================  FBRD  ========================================================== */
#define UART0_FBRD_DIVFRAC_Pos            (0UL)                     /*!< UART0 FBRD: DIVFRAC (Bit 0)                           */
#define UART0_FBRD_DIVFRAC_Msk            (0x3fUL)                  /*!< UART0 FBRD: DIVFRAC (Bitfield-Mask: 0x3f)             */
/* =========================================================  LCRH  ========================================================== */
#define UART0_LCRH_SPS_Pos                (7UL)                     /*!< UART0 LCRH: SPS (Bit 7)                               */
#define UART0_LCRH_SPS_Msk                (0x80UL)                  /*!< UART0 LCRH: SPS (Bitfield-Mask: 0x01)                 */
#define UART0_LCRH_WLEN_Pos               (5UL)                     /*!< UART0 LCRH: WLEN (Bit 5)                              */
#define UART0_LCRH_WLEN_Msk               (0x60UL)                  /*!< UART0 LCRH: WLEN (Bitfield-Mask: 0x03)                */
#define UART0_LCRH_FEN_Pos                (4UL)                     /*!< UART0 LCRH: FEN (Bit 4)                               */
#define UART0_LCRH_FEN_Msk                (0x10UL)                  /*!< UART0 LCRH: FEN (Bitfield-Mask: 0x01)                 */
#define UART0_LCRH_STP2_Pos               (3UL)                     /*!< UART0 LCRH: STP2 (Bit 3)                              */
#define UART0_LCRH_STP2_Msk               (0x8UL)                   /*!< UART0 LCRH: STP2 (Bitfield-Mask: 0x01)                */
#define UART0_LCRH_EPS_Pos                (2UL)                     /*!< UART0 LCRH: EPS (Bit 2)                               */
#define UART0_LCRH_EPS_Msk                (0x4UL)                   /*!< UART0 LCRH: EPS (Bitfield-Mask: 0x01)                 */
#define UART0_LCRH_PEN_Pos                (1UL)                     /*!< UART0 LCRH: PEN (Bit 1)                               */
#define UART0_LCRH_PEN_Msk                (0x2UL)                   /*!< UART0 LCRH: PEN (Bitfield-Mask: 0x01)                 */
#define UART0_LCRH_BRK_Pos                (0UL)                     /*!< UART0 LCRH: BRK (Bit 0)                               */
#define UART0_LCRH_BRK_Msk                (0x1UL)                   /*!< UART0 LCRH: BRK (Bitfield-Mask: 0x01)                 */
/* ==========================================================  CR  =========================================================== */
#define UART0_CR_CTSEN_Pos                (15UL)                    /*!< UART0 CR: CTSEN (Bit 15)                              */
#define UART0_CR_CTSEN_Msk                (0x8000UL)                /*!< UART0 CR: CTSEN (Bitfield-Mask: 0x01)                 */
#define UART0_CR_RTSEN_Pos                (14UL)                    /*!< UART0 CR: RTSEN (Bit 14)                              */
#define UART0_CR_RTSEN_Msk                (0x4000UL)                /*!< UART0 CR: RTSEN (Bitfield-Mask: 0x01)                 */
#define UART0_CR_OUT2_Pos                 (13UL)                    /*!< UART0 CR: OUT2 (Bit 13)                               */
#define UART0_CR_OUT2_Msk                 (0x2000UL)                /*!< UART0 CR: OUT2 (Bitfield-Mask: 0x01)                  */
#define UART0_CR_OUT1_Pos                 (12UL)                    /*!< UART0 CR: OUT1 (Bit 12)                               */
#define UART0_CR_OUT1_Msk                 (0x1000UL)                /*!< UART0 CR: OUT1 (Bitfield-Mask: 0x01)                  */
#define UART0_CR_RTS_Pos                  (11UL)                    /*!< UART0 CR: RTS (Bit 11)                                */
#define UART0_CR_RTS_Msk                  (0x800UL)                 /*!< UART0 CR: RTS (Bitfield-Mask: 0x01)                   */
#define UART0_CR_DTR_Pos                  (10UL)                    /*!< UART0 CR: DTR (Bit 10)                                */
#define UART0_CR_DTR_Msk                  (0x400UL)                 /*!< UART0 CR: DTR (Bitfield-Mask: 0x01)                   */
#define UART0_CR_RXE_Pos                  (9UL)                     /*!< UART0 CR: RXE (Bit 9)                                 */
#define UART0_CR_RXE_Msk                  (0x200UL)                 /*!< UART0 CR: RXE (Bitfield-Mask: 0x01)                   */
#define UART0_CR_TXE_Pos                  (8UL)                     /*!< UART0 CR: TXE (Bit 8)                                 */
#define UART0_CR_TXE_Msk                  (0x100UL)                 /*!< UART0 CR: TXE (Bitfield-Mask: 0x01)                   */
#define UART0_CR_LBE_Pos                  (7UL)                     /*!< UART0 CR: LBE (Bit 7)                                 */
#define UART0_CR_LBE_Msk                  (0x80UL)                  /*!< UART0 CR: LBE (Bitfield-Mask: 0x01)                   */
#define UART0_CR_CLKSEL_Pos               (4UL)                     /*!< UART0 CR: CLKSEL (Bit 4)                              */
#define UART0_CR_CLKSEL_Msk               (0x70UL)                  /*!< UART0 CR: CLKSEL (Bitfield-Mask: 0x07)                */
#define UART0_CR_CLKEN_Pos                (3UL)                     /*!< UART0 CR: CLKEN (Bit 3)                               */
#define UART0_CR_CLKEN_Msk                (0x8UL)                   /*!< UART0 CR: CLKEN (Bitfield-Mask: 0x01)                 */
#define UART0_CR_SIRLP_Pos                (2UL)                     /*!< UART0 CR: SIRLP (Bit 2)                               */
#define UART0_CR_SIRLP_Msk                (0x4UL)                   /*!< UART0 CR: SIRLP (Bitfield-Mask: 0x01)                 */
#define UART0_CR_SIREN_Pos                (1UL)                     /*!< UART0 CR: SIREN (Bit 1)                               */
#define UART0_CR_SIREN_Msk                (0x2UL)                   /*!< UART0 CR: SIREN (Bitfield-Mask: 0x01)                 */
#define UART0_CR_UARTEN_Pos               (0UL)                     /*!< UART0 CR: UARTEN (Bit 0)                              */
#define UART0_CR_UARTEN_Msk               (0x1UL)                   /*!< UART0 CR: UARTEN (Bitfield-Mask: 0x01)                */
/* =========================================================  IFLS  ========================================================== */
#define UART0_IFLS_RXIFLSEL_Pos           (3UL)                     /*!< UART0 IFLS: RXIFLSEL (Bit 3)                          */
#define UART0_IFLS_RXIFLSEL_Msk           (0x38UL)                  /*!< UART0 IFLS: RXIFLSEL (Bitfield-Mask: 0x07)            */
#define UART0_IFLS_TXIFLSEL_Pos           (0UL)                     /*!< UART0 IFLS: TXIFLSEL (Bit 0)                          */
#define UART0_IFLS_TXIFLSEL_Msk           (0x7UL)                   /*!< UART0 IFLS: TXIFLSEL (Bitfield-Mask: 0x07)            */
/* ==========================================================  IER  ========================================================== */
#define UART0_IER_OEIM_Pos                (10UL)                    /*!< UART0 IER: OEIM (Bit 10)                              */
#define UART0_IER_OEIM_Msk                (0x400UL)                 /*!< UART0 IER: OEIM (Bitfield-Mask: 0x01)                 */
#define UART0_IER_BEIM_Pos                (9UL)                     /*!< UART0 IER: BEIM (Bit 9)                               */
#define UART0_IER_BEIM_Msk                (0x200UL)                 /*!< UART0 IER: BEIM (Bitfield-Mask: 0x01)                 */
#define UART0_IER_PEIM_Pos                (8UL)                     /*!< UART0 IER: PEIM (Bit 8)                               */
#define UART0_IER_PEIM_Msk                (0x100UL)                 /*!< UART0 IER: PEIM (Bitfield-Mask: 0x01)                 */
#define UART0_IER_FEIM_Pos                (7UL)                     /*!< UART0 IER: FEIM (Bit 7)                               */
#define UART0_IER_FEIM_Msk                (0x80UL)                  /*!< UART0 IER: FEIM (Bitfield-Mask: 0x01)                 */
#define UART0_IER_RTIM_Pos                (6UL)                     /*!< UART0 IER: RTIM (Bit 6)                               */
#define UART0_IER_RTIM_Msk                (0x40UL)                  /*!< UART0 IER: RTIM (Bitfield-Mask: 0x01)                 */
#define UART0_IER_TXIM_Pos                (5UL)                     /*!< UART0 IER: TXIM (Bit 5)                               */
#define UART0_IER_TXIM_Msk                (0x20UL)                  /*!< UART0 IER: TXIM (Bitfield-Mask: 0x01)                 */
#define UART0_IER_RXIM_Pos                (4UL)                     /*!< UART0 IER: RXIM (Bit 4)                               */
#define UART0_IER_RXIM_Msk                (0x10UL)                  /*!< UART0 IER: RXIM (Bitfield-Mask: 0x01)                 */
#define UART0_IER_DSRMIM_Pos              (3UL)                     /*!< UART0 IER: DSRMIM (Bit 3)                             */
#define UART0_IER_DSRMIM_Msk              (0x8UL)                   /*!< UART0 IER: DSRMIM (Bitfield-Mask: 0x01)               */
#define UART0_IER_DCDMIM_Pos              (2UL)                     /*!< UART0 IER: DCDMIM (Bit 2)                             */
#define UART0_IER_DCDMIM_Msk              (0x4UL)                   /*!< UART0 IER: DCDMIM (Bitfield-Mask: 0x01)               */
#define UART0_IER_CTSMIM_Pos              (1UL)                     /*!< UART0 IER: CTSMIM (Bit 1)                             */
#define UART0_IER_CTSMIM_Msk              (0x2UL)                   /*!< UART0 IER: CTSMIM (Bitfield-Mask: 0x01)               */
#define UART0_IER_TXCMPMIM_Pos            (0UL)                     /*!< UART0 IER: TXCMPMIM (Bit 0)                           */
#define UART0_IER_TXCMPMIM_Msk            (0x1UL)                   /*!< UART0 IER: TXCMPMIM (Bitfield-Mask: 0x01)             */
/* ==========================================================  IES  ========================================================== */
#define UART0_IES_OERIS_Pos               (10UL)                    /*!< UART0 IES: OERIS (Bit 10)                             */
#define UART0_IES_OERIS_Msk               (0x400UL)                 /*!< UART0 IES: OERIS (Bitfield-Mask: 0x01)                */
#define UART0_IES_BERIS_Pos               (9UL)                     /*!< UART0 IES: BERIS (Bit 9)                              */
#define UART0_IES_BERIS_Msk               (0x200UL)                 /*!< UART0 IES: BERIS (Bitfield-Mask: 0x01)                */
#define UART0_IES_PERIS_Pos               (8UL)                     /*!< UART0 IES: PERIS (Bit 8)                              */
#define UART0_IES_PERIS_Msk               (0x100UL)                 /*!< UART0 IES: PERIS (Bitfield-Mask: 0x01)                */
#define UART0_IES_FERIS_Pos               (7UL)                     /*!< UART0 IES: FERIS (Bit 7)                              */
#define UART0_IES_FERIS_Msk               (0x80UL)                  /*!< UART0 IES: FERIS (Bitfield-Mask: 0x01)                */
#define UART0_IES_RTRIS_Pos               (6UL)                     /*!< UART0 IES: RTRIS (Bit 6)                              */
#define UART0_IES_RTRIS_Msk               (0x40UL)                  /*!< UART0 IES: RTRIS (Bitfield-Mask: 0x01)                */
#define UART0_IES_TXRIS_Pos               (5UL)                     /*!< UART0 IES: TXRIS (Bit 5)                              */
#define UART0_IES_TXRIS_Msk               (0x20UL)                  /*!< UART0 IES: TXRIS (Bitfield-Mask: 0x01)                */
#define UART0_IES_RXRIS_Pos               (4UL)                     /*!< UART0 IES: RXRIS (Bit 4)                              */
#define UART0_IES_RXRIS_Msk               (0x10UL)                  /*!< UART0 IES: RXRIS (Bitfield-Mask: 0x01)                */
#define UART0_IES_DSRMRIS_Pos             (3UL)                     /*!< UART0 IES: DSRMRIS (Bit 3)                            */
#define UART0_IES_DSRMRIS_Msk             (0x8UL)                   /*!< UART0 IES: DSRMRIS (Bitfield-Mask: 0x01)              */
#define UART0_IES_DCDMRIS_Pos             (2UL)                     /*!< UART0 IES: DCDMRIS (Bit 2)                            */
#define UART0_IES_DCDMRIS_Msk             (0x4UL)                   /*!< UART0 IES: DCDMRIS (Bitfield-Mask: 0x01)              */
#define UART0_IES_CTSMRIS_Pos             (1UL)                     /*!< UART0 IES: CTSMRIS (Bit 1)                            */
#define UART0_IES_CTSMRIS_Msk             (0x2UL)                   /*!< UART0 IES: CTSMRIS (Bitfield-Mask: 0x01)              */
#define UART0_IES_TXCMPMRIS_Pos           (0UL)                     /*!< UART0 IES: TXCMPMRIS (Bit 0)                          */
#define UART0_IES_TXCMPMRIS_Msk           (0x1UL)                   /*!< UART0 IES: TXCMPMRIS (Bitfield-Mask: 0x01)            */
/* ==========================================================  MIS  ========================================================== */
#define UART0_MIS_OEMIS_Pos               (10UL)                    /*!< UART0 MIS: OEMIS (Bit 10)                             */
#define UART0_MIS_OEMIS_Msk               (0x400UL)                 /*!< UART0 MIS: OEMIS (Bitfield-Mask: 0x01)                */
#define UART0_MIS_BEMIS_Pos               (9UL)                     /*!< UART0 MIS: BEMIS (Bit 9)                              */
#define UART0_MIS_BEMIS_Msk               (0x200UL)                 /*!< UART0 MIS: BEMIS (Bitfield-Mask: 0x01)                */
#define UART0_MIS_PEMIS_Pos               (8UL)                     /*!< UART0 MIS: PEMIS (Bit 8)                              */
#define UART0_MIS_PEMIS_Msk               (0x100UL)                 /*!< UART0 MIS: PEMIS (Bitfield-Mask: 0x01)                */
#define UART0_MIS_FEMIS_Pos               (7UL)                     /*!< UART0 MIS: FEMIS (Bit 7)                              */
#define UART0_MIS_FEMIS_Msk               (0x80UL)                  /*!< UART0 MIS: FEMIS (Bitfield-Mask: 0x01)                */
#define UART0_MIS_RTMIS_Pos               (6UL)                     /*!< UART0 MIS: RTMIS (Bit 6)                              */
#define UART0_MIS_RTMIS_Msk               (0x40UL)                  /*!< UART0 MIS: RTMIS (Bitfield-Mask: 0x01)                */
#define UART0_MIS_TXMIS_Pos               (5UL)                     /*!< UART0 MIS: TXMIS (Bit 5)                              */
#define UART0_MIS_TXMIS_Msk               (0x20UL)                  /*!< UART0 MIS: TXMIS (Bitfield-Mask: 0x01)                */
#define UART0_MIS_RXMIS_Pos               (4UL)                     /*!< UART0 MIS: RXMIS (Bit 4)                              */
#define UART0_MIS_RXMIS_Msk               (0x10UL)                  /*!< UART0 MIS: RXMIS (Bitfield-Mask: 0x01)                */
#define UART0_MIS_DSRMMIS_Pos             (3UL)                     /*!< UART0 MIS: DSRMMIS (Bit 3)                            */
#define UART0_MIS_DSRMMIS_Msk             (0x8UL)                   /*!< UART0 MIS: DSRMMIS (Bitfield-Mask: 0x01)              */
#define UART0_MIS_DCDMMIS_Pos             (2UL)                     /*!< UART0 MIS: DCDMMIS (Bit 2)                            */
#define UART0_MIS_DCDMMIS_Msk             (0x4UL)                   /*!< UART0 MIS: DCDMMIS (Bitfield-Mask: 0x01)              */
#define UART0_MIS_CTSMMIS_Pos             (1UL)                     /*!< UART0 MIS: CTSMMIS (Bit 1)                            */
#define UART0_MIS_CTSMMIS_Msk             (0x2UL)                   /*!< UART0 MIS: CTSMMIS (Bitfield-Mask: 0x01)              */
#define UART0_MIS_TXCMPMMIS_Pos           (0UL)                     /*!< UART0 MIS: TXCMPMMIS (Bit 0)                          */
#define UART0_MIS_TXCMPMMIS_Msk           (0x1UL)                   /*!< UART0 MIS: TXCMPMMIS (Bitfield-Mask: 0x01)            */
/* ==========================================================  IEC  ========================================================== */
#define UART0_IEC_OEIC_Pos                (10UL)                    /*!< UART0 IEC: OEIC (Bit 10)                              */
#define UART0_IEC_OEIC_Msk                (0x400UL)                 /*!< UART0 IEC: OEIC (Bitfield-Mask: 0x01)                 */
#define UART0_IEC_BEIC_Pos                (9UL)                     /*!< UART0 IEC: BEIC (Bit 9)                               */
#define UART0_IEC_BEIC_Msk                (0x200UL)                 /*!< UART0 IEC: BEIC (Bitfield-Mask: 0x01)                 */
#define UART0_IEC_PEIC_Pos                (8UL)                     /*!< UART0 IEC: PEIC (Bit 8)                               */
#define UART0_IEC_PEIC_Msk                (0x100UL)                 /*!< UART0 IEC: PEIC (Bitfield-Mask: 0x01)                 */
#define UART0_IEC_FEIC_Pos                (7UL)                     /*!< UART0 IEC: FEIC (Bit 7)                               */
#define UART0_IEC_FEIC_Msk                (0x80UL)                  /*!< UART0 IEC: FEIC (Bitfield-Mask: 0x01)                 */
#define UART0_IEC_RTIC_Pos                (6UL)                     /*!< UART0 IEC: RTIC (Bit 6)                               */
#define UART0_IEC_RTIC_Msk                (0x40UL)                  /*!< UART0 IEC: RTIC (Bitfield-Mask: 0x01)                 */
#define UART0_IEC_TXIC_Pos                (5UL)                     /*!< UART0 IEC: TXIC (Bit 5)                               */
#define UART0_IEC_TXIC_Msk                (0x20UL)                  /*!< UART0 IEC: TXIC (Bitfield-Mask: 0x01)                 */
#define UART0_IEC_RXIC_Pos                (4UL)                     /*!< UART0 IEC: RXIC (Bit 4)                               */
#define UART0_IEC_RXIC_Msk                (0x10UL)                  /*!< UART0 IEC: RXIC (Bitfield-Mask: 0x01)                 */
#define UART0_IEC_DSRMIC_Pos              (3UL)                     /*!< UART0 IEC: DSRMIC (Bit 3)                             */
#define UART0_IEC_DSRMIC_Msk              (0x8UL)                   /*!< UART0 IEC: DSRMIC (Bitfield-Mask: 0x01)               */
#define UART0_IEC_DCDMIC_Pos              (2UL)                     /*!< UART0 IEC: DCDMIC (Bit 2)                             */
#define UART0_IEC_DCDMIC_Msk              (0x4UL)                   /*!< UART0 IEC: DCDMIC (Bitfield-Mask: 0x01)               */
#define UART0_IEC_CTSMIC_Pos              (1UL)                     /*!< UART0 IEC: CTSMIC (Bit 1)                             */
#define UART0_IEC_CTSMIC_Msk              (0x2UL)                   /*!< UART0 IEC: CTSMIC (Bitfield-Mask: 0x01)               */
#define UART0_IEC_TXCMPMIC_Pos            (0UL)                     /*!< UART0 IEC: TXCMPMIC (Bit 0)                           */
#define UART0_IEC_TXCMPMIC_Msk            (0x1UL)                   /*!< UART0 IEC: TXCMPMIC (Bitfield-Mask: 0x01)             */


/* =========================================================================================================================== */
/* ================                                           VCOMP                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
#define VCOMP_CFG_LVLSEL_Pos              (16UL)                    /*!< VCOMP CFG: LVLSEL (Bit 16)                            */
#define VCOMP_CFG_LVLSEL_Msk              (0xf0000UL)               /*!< VCOMP CFG: LVLSEL (Bitfield-Mask: 0x0f)               */
#define VCOMP_CFG_NSEL_Pos                (8UL)                     /*!< VCOMP CFG: NSEL (Bit 8)                               */
#define VCOMP_CFG_NSEL_Msk                (0x300UL)                 /*!< VCOMP CFG: NSEL (Bitfield-Mask: 0x03)                 */
#define VCOMP_CFG_PSEL_Pos                (0UL)                     /*!< VCOMP CFG: PSEL (Bit 0)                               */
#define VCOMP_CFG_PSEL_Msk                (0x3UL)                   /*!< VCOMP CFG: PSEL (Bitfield-Mask: 0x03)                 */
/* =========================================================  STAT  ========================================================== */
#define VCOMP_STAT_PWDSTAT_Pos            (1UL)                     /*!< VCOMP STAT: PWDSTAT (Bit 1)                           */
#define VCOMP_STAT_PWDSTAT_Msk            (0x2UL)                   /*!< VCOMP STAT: PWDSTAT (Bitfield-Mask: 0x01)             */
#define VCOMP_STAT_CMPOUT_Pos             (0UL)                     /*!< VCOMP STAT: CMPOUT (Bit 0)                            */
#define VCOMP_STAT_CMPOUT_Msk             (0x1UL)                   /*!< VCOMP STAT: CMPOUT (Bitfield-Mask: 0x01)              */
/* ========================================================  PWDKEY  ========================================================= */
#define VCOMP_PWDKEY_PWDKEY_Pos           (0UL)                     /*!< VCOMP PWDKEY: PWDKEY (Bit 0)                          */
#define VCOMP_PWDKEY_PWDKEY_Msk           (0xffffffffUL)            /*!< VCOMP PWDKEY: PWDKEY (Bitfield-Mask: 0xffffffff)      */
/* =========================================================  INTEN  ========================================================= */
#define VCOMP_INTEN_OUTHI_Pos             (1UL)                     /*!< VCOMP INTEN: OUTHI (Bit 1)                            */
#define VCOMP_INTEN_OUTHI_Msk             (0x2UL)                   /*!< VCOMP INTEN: OUTHI (Bitfield-Mask: 0x01)              */
#define VCOMP_INTEN_OUTLOW_Pos            (0UL)                     /*!< VCOMP INTEN: OUTLOW (Bit 0)                           */
#define VCOMP_INTEN_OUTLOW_Msk            (0x1UL)                   /*!< VCOMP INTEN: OUTLOW (Bitfield-Mask: 0x01)             */
/* ========================================================  INTSTAT  ======================================================== */
#define VCOMP_INTSTAT_OUTHI_Pos           (1UL)                     /*!< VCOMP INTSTAT: OUTHI (Bit 1)                          */
#define VCOMP_INTSTAT_OUTHI_Msk           (0x2UL)                   /*!< VCOMP INTSTAT: OUTHI (Bitfield-Mask: 0x01)            */
#define VCOMP_INTSTAT_OUTLOW_Pos          (0UL)                     /*!< VCOMP INTSTAT: OUTLOW (Bit 0)                         */
#define VCOMP_INTSTAT_OUTLOW_Msk          (0x1UL)                   /*!< VCOMP INTSTAT: OUTLOW (Bitfield-Mask: 0x01)           */
/* ========================================================  INTCLR  ========================================================= */
#define VCOMP_INTCLR_OUTHI_Pos            (1UL)                     /*!< VCOMP INTCLR: OUTHI (Bit 1)                           */
#define VCOMP_INTCLR_OUTHI_Msk            (0x2UL)                   /*!< VCOMP INTCLR: OUTHI (Bitfield-Mask: 0x01)             */
#define VCOMP_INTCLR_OUTLOW_Pos           (0UL)                     /*!< VCOMP INTCLR: OUTLOW (Bit 0)                          */
#define VCOMP_INTCLR_OUTLOW_Msk           (0x1UL)                   /*!< VCOMP INTCLR: OUTLOW (Bitfield-Mask: 0x01)            */
/* ========================================================  INTSET  ========================================================= */
#define VCOMP_INTSET_OUTHI_Pos            (1UL)                     /*!< VCOMP INTSET: OUTHI (Bit 1)                           */
#define VCOMP_INTSET_OUTHI_Msk            (0x2UL)                   /*!< VCOMP INTSET: OUTHI (Bitfield-Mask: 0x01)             */
#define VCOMP_INTSET_OUTLOW_Pos           (0UL)                     /*!< VCOMP INTSET: OUTLOW (Bit 0)                          */
#define VCOMP_INTSET_OUTLOW_Msk           (0x1UL)                   /*!< VCOMP INTSET: OUTLOW (Bitfield-Mask: 0x01)            */


/* =========================================================================================================================== */
/* ================                                            WDT                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
#define WDT_CFG_CLKSEL_Pos                (24UL)                    /*!< WDT CFG: CLKSEL (Bit 24)                              */
#define WDT_CFG_CLKSEL_Msk                (0x7000000UL)             /*!< WDT CFG: CLKSEL (Bitfield-Mask: 0x07)                 */
#define WDT_CFG_INTVAL_Pos                (16UL)                    /*!< WDT CFG: INTVAL (Bit 16)                              */
#define WDT_CFG_INTVAL_Msk                (0xff0000UL)              /*!< WDT CFG: INTVAL (Bitfield-Mask: 0xff)                 */
#define WDT_CFG_RESVAL_Pos                (8UL)                     /*!< WDT CFG: RESVAL (Bit 8)                               */
#define WDT_CFG_RESVAL_Msk                (0xff00UL)                /*!< WDT CFG: RESVAL (Bitfield-Mask: 0xff)                 */
#define WDT_CFG_RESEN_Pos                 (2UL)                     /*!< WDT CFG: RESEN (Bit 2)                                */
#define WDT_CFG_RESEN_Msk                 (0x4UL)                   /*!< WDT CFG: RESEN (Bitfield-Mask: 0x01)                  */
#define WDT_CFG_INTEN_Pos                 (1UL)                     /*!< WDT CFG: INTEN (Bit 1)                                */
#define WDT_CFG_INTEN_Msk                 (0x2UL)                   /*!< WDT CFG: INTEN (Bitfield-Mask: 0x01)                  */
#define WDT_CFG_WDTEN_Pos                 (0UL)                     /*!< WDT CFG: WDTEN (Bit 0)                                */
#define WDT_CFG_WDTEN_Msk                 (0x1UL)                   /*!< WDT CFG: WDTEN (Bitfield-Mask: 0x01)                  */
/* =========================================================  RSTRT  ========================================================= */
#define WDT_RSTRT_RSTRT_Pos               (0UL)                     /*!< WDT RSTRT: RSTRT (Bit 0)                              */
#define WDT_RSTRT_RSTRT_Msk               (0xffUL)                  /*!< WDT RSTRT: RSTRT (Bitfield-Mask: 0xff)                */
/* =========================================================  LOCK  ========================================================== */
#define WDT_LOCK_LOCK_Pos                 (0UL)                     /*!< WDT LOCK: LOCK (Bit 0)                                */
#define WDT_LOCK_LOCK_Msk                 (0xffUL)                  /*!< WDT LOCK: LOCK (Bitfield-Mask: 0xff)                  */
/* =========================================================  COUNT  ========================================================= */
#define WDT_COUNT_COUNT_Pos               (0UL)                     /*!< WDT COUNT: COUNT (Bit 0)                              */
#define WDT_COUNT_COUNT_Msk               (0xffUL)                  /*!< WDT COUNT: COUNT (Bitfield-Mask: 0xff)                */
/* =========================================================  INTEN  ========================================================= */
#define WDT_INTEN_WDT_Pos                 (0UL)                     /*!< WDT INTEN: WDT (Bit 0)                                */
#define WDT_INTEN_WDT_Msk                 (0x1UL)                   /*!< WDT INTEN: WDT (Bitfield-Mask: 0x01)                  */
/* ========================================================  INTSTAT  ======================================================== */
#define WDT_INTSTAT_WDT_Pos               (0UL)                     /*!< WDT INTSTAT: WDT (Bit 0)                              */
#define WDT_INTSTAT_WDT_Msk               (0x1UL)                   /*!< WDT INTSTAT: WDT (Bitfield-Mask: 0x01)                */
/* ========================================================  INTCLR  ========================================================= */
#define WDT_INTCLR_WDT_Pos                (0UL)                     /*!< WDT INTCLR: WDT (Bit 0)                               */
#define WDT_INTCLR_WDT_Msk                (0x1UL)                   /*!< WDT INTCLR: WDT (Bitfield-Mask: 0x01)                 */
/* ========================================================  INTSET  ========================================================= */
#define WDT_INTSET_WDT_Pos                (0UL)                     /*!< WDT INTSET: WDT (Bit 0)                               */
#define WDT_INTSET_WDT_Msk                (0x1UL)                   /*!< WDT INTSET: WDT (Bitfield-Mask: 0x01)                 */


/* =========================================================================================================================== */
/* ================                                          CLKGEN                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  CALXT  ========================================================= */
#define CLKGEN_CALXT_CALXT_Pos            (0UL)                     /*!< CLKGEN CALXT: CALXT (Bit 0)                           */
#define CLKGEN_CALXT_CALXT_Msk            (0x7ffUL)                 /*!< CLKGEN CALXT: CALXT (Bitfield-Mask: 0x7ff)            */
/* =========================================================  CALRC  ========================================================= */
#define CLKGEN_CALRC_CALRC_Pos            (0UL)                     /*!< CLKGEN CALRC: CALRC (Bit 0)                           */
#define CLKGEN_CALRC_CALRC_Msk            (0x3ffffUL)               /*!< CLKGEN CALRC: CALRC (Bitfield-Mask: 0x3ffff)          */
/* ========================================================  ACALCTR  ======================================================== */
#define CLKGEN_ACALCTR_ACALCTR_Pos        (0UL)                     /*!< CLKGEN ACALCTR: ACALCTR (Bit 0)                       */
#define CLKGEN_ACALCTR_ACALCTR_Msk        (0xffffffUL)              /*!< CLKGEN ACALCTR: ACALCTR (Bitfield-Mask: 0xffffff)     */
/* =========================================================  OCTRL  ========================================================= */
#define CLKGEN_OCTRL_ACAL_Pos             (8UL)                     /*!< CLKGEN OCTRL: ACAL (Bit 8)                            */
#define CLKGEN_OCTRL_ACAL_Msk             (0x700UL)                 /*!< CLKGEN OCTRL: ACAL (Bitfield-Mask: 0x07)              */
#define CLKGEN_OCTRL_OSEL_Pos             (7UL)                     /*!< CLKGEN OCTRL: OSEL (Bit 7)                            */
#define CLKGEN_OCTRL_OSEL_Msk             (0x80UL)                  /*!< CLKGEN OCTRL: OSEL (Bitfield-Mask: 0x01)              */
#define CLKGEN_OCTRL_FOS_Pos              (6UL)                     /*!< CLKGEN OCTRL: FOS (Bit 6)                             */
#define CLKGEN_OCTRL_FOS_Msk              (0x40UL)                  /*!< CLKGEN OCTRL: FOS (Bitfield-Mask: 0x01)               */
#define CLKGEN_OCTRL_STOPRC_Pos           (1UL)                     /*!< CLKGEN OCTRL: STOPRC (Bit 1)                          */
#define CLKGEN_OCTRL_STOPRC_Msk           (0x2UL)                   /*!< CLKGEN OCTRL: STOPRC (Bitfield-Mask: 0x01)            */
#define CLKGEN_OCTRL_STOPXT_Pos           (0UL)                     /*!< CLKGEN OCTRL: STOPXT (Bit 0)                          */
#define CLKGEN_OCTRL_STOPXT_Msk           (0x1UL)                   /*!< CLKGEN OCTRL: STOPXT (Bitfield-Mask: 0x01)            */
/* ========================================================  CLKOUT  ========================================================= */
#define CLKGEN_CLKOUT_CKEN_Pos            (7UL)                     /*!< CLKGEN CLKOUT: CKEN (Bit 7)                           */
#define CLKGEN_CLKOUT_CKEN_Msk            (0x80UL)                  /*!< CLKGEN CLKOUT: CKEN (Bitfield-Mask: 0x01)             */
#define CLKGEN_CLKOUT_CKSEL_Pos           (0UL)                     /*!< CLKGEN CLKOUT: CKSEL (Bit 0)                          */
#define CLKGEN_CLKOUT_CKSEL_Msk           (0x3fUL)                  /*!< CLKGEN CLKOUT: CKSEL (Bitfield-Mask: 0x3f)            */
/* ========================================================  CLKKEY  ========================================================= */
#define CLKGEN_CLKKEY_CLKKEY_Pos          (0UL)                     /*!< CLKGEN CLKKEY: CLKKEY (Bit 0)                         */
#define CLKGEN_CLKKEY_CLKKEY_Msk          (0xffffffffUL)            /*!< CLKGEN CLKKEY: CLKKEY (Bitfield-Mask: 0xffffffff)     */
/* =========================================================  CCTRL  ========================================================= */
#define CLKGEN_CCTRL_CORESEL_Pos          (0UL)                     /*!< CLKGEN CCTRL: CORESEL (Bit 0)                         */
#define CLKGEN_CCTRL_CORESEL_Msk          (0x1UL)                   /*!< CLKGEN CCTRL: CORESEL (Bitfield-Mask: 0x01)           */
/* ========================================================  STATUS  ========================================================= */
#define CLKGEN_STATUS_OSCF_Pos            (1UL)                     /*!< CLKGEN STATUS: OSCF (Bit 1)                           */
#define CLKGEN_STATUS_OSCF_Msk            (0x2UL)                   /*!< CLKGEN STATUS: OSCF (Bitfield-Mask: 0x01)             */
#define CLKGEN_STATUS_OMODE_Pos           (0UL)                     /*!< CLKGEN STATUS: OMODE (Bit 0)                          */
#define CLKGEN_STATUS_OMODE_Msk           (0x1UL)                   /*!< CLKGEN STATUS: OMODE (Bitfield-Mask: 0x01)            */
/* =========================================================  HFADJ  ========================================================= */
#define CLKGEN_HFADJ_HFADJ_GAIN_Pos       (21UL)                    /*!< CLKGEN HFADJ: HFADJ_GAIN (Bit 21)                     */
#define CLKGEN_HFADJ_HFADJ_GAIN_Msk       (0xe00000UL)              /*!< CLKGEN HFADJ: HFADJ_GAIN (Bitfield-Mask: 0x07)        */
#define CLKGEN_HFADJ_HFWARMUP_Pos         (20UL)                    /*!< CLKGEN HFADJ: HFWARMUP (Bit 20)                       */
#define CLKGEN_HFADJ_HFWARMUP_Msk         (0x100000UL)              /*!< CLKGEN HFADJ: HFWARMUP (Bitfield-Mask: 0x01)          */
#define CLKGEN_HFADJ_HFXTADJ_Pos          (8UL)                     /*!< CLKGEN HFADJ: HFXTADJ (Bit 8)                         */
#define CLKGEN_HFADJ_HFXTADJ_Msk          (0xfff00UL)               /*!< CLKGEN HFADJ: HFXTADJ (Bitfield-Mask: 0xfff)          */
#define CLKGEN_HFADJ_HFADJCK_Pos          (1UL)                     /*!< CLKGEN HFADJ: HFADJCK (Bit 1)                         */
#define CLKGEN_HFADJ_HFADJCK_Msk          (0xeUL)                   /*!< CLKGEN HFADJ: HFADJCK (Bitfield-Mask: 0x07)           */
#define CLKGEN_HFADJ_HFADJEN_Pos          (0UL)                     /*!< CLKGEN HFADJ: HFADJEN (Bit 0)                         */
#define CLKGEN_HFADJ_HFADJEN_Msk          (0x1UL)                   /*!< CLKGEN HFADJ: HFADJEN (Bitfield-Mask: 0x01)           */
/* =========================================================  HFVAL  ========================================================= */
#define CLKGEN_HFVAL_HFTUNERB_Pos         (0UL)                     /*!< CLKGEN HFVAL: HFTUNERB (Bit 0)                        */
#define CLKGEN_HFVAL_HFTUNERB_Msk         (0x7ffUL)                 /*!< CLKGEN HFVAL: HFTUNERB (Bitfield-Mask: 0x7ff)         */
/* ========================================================  CLOCKEN  ======================================================== */
#define CLKGEN_CLOCKEN_CLOCKEN_Pos        (0UL)                     /*!< CLKGEN CLOCKEN: CLOCKEN (Bit 0)                       */
#define CLKGEN_CLOCKEN_CLOCKEN_Msk        (0xffffffffUL)            /*!< CLKGEN CLOCKEN: CLOCKEN (Bitfield-Mask: 0xffffffff)   */
/* =======================================================  CLOCKEN2  ======================================================== */
#define CLKGEN_CLOCKEN2_CLOCKEN2_Pos      (0UL)                     /*!< CLKGEN CLOCKEN2: CLOCKEN2 (Bit 0)                     */
#define CLKGEN_CLOCKEN2_CLOCKEN2_Msk      (0xffffffffUL)            /*!< CLKGEN CLOCKEN2: CLOCKEN2 (Bitfield-Mask: 0xffffffff) */
/* =======================================================  CLOCKEN3  ======================================================== */
#define CLKGEN_CLOCKEN3_CLOCKEN3_Pos      (0UL)                     /*!< CLKGEN CLOCKEN3: CLOCKEN3 (Bit 0)                     */
#define CLKGEN_CLOCKEN3_CLOCKEN3_Msk      (0xffffffffUL)            /*!< CLKGEN CLOCKEN3: CLOCKEN3 (Bitfield-Mask: 0xffffffff) */
/* ========================================================  UARTEN  ========================================================= */
#define CLKGEN_UARTEN_UART1EN_Pos         (8UL)                     /*!< CLKGEN UARTEN: UART1EN (Bit 8)                        */
#define CLKGEN_UARTEN_UART1EN_Msk         (0x300UL)                 /*!< CLKGEN UARTEN: UART1EN (Bitfield-Mask: 0x03)          */
#define CLKGEN_UARTEN_UART0EN_Pos         (0UL)                     /*!< CLKGEN UARTEN: UART0EN (Bit 0)                        */
#define CLKGEN_UARTEN_UART0EN_Msk         (0x3UL)                   /*!< CLKGEN UARTEN: UART0EN (Bitfield-Mask: 0x03)          */
/* ========================================================  CTRLOW  ========================================================= */
#define CLKGEN_CTRLOW_CTRHR_Pos           (24UL)                    /*!< CLKGEN CTRLOW: CTRHR (Bit 24)                         */
#define CLKGEN_CTRLOW_CTRHR_Msk           (0x3f000000UL)            /*!< CLKGEN CTRLOW: CTRHR (Bitfield-Mask: 0x3f)            */
#define CLKGEN_CTRLOW_CTRMIN_Pos          (16UL)                    /*!< CLKGEN CTRLOW: CTRMIN (Bit 16)                        */
#define CLKGEN_CTRLOW_CTRMIN_Msk          (0x7f0000UL)              /*!< CLKGEN CTRLOW: CTRMIN (Bitfield-Mask: 0x7f)           */
#define CLKGEN_CTRLOW_CTRSEC_Pos          (8UL)                     /*!< CLKGEN CTRLOW: CTRSEC (Bit 8)                         */
#define CLKGEN_CTRLOW_CTRSEC_Msk          (0x7f00UL)                /*!< CLKGEN CTRLOW: CTRSEC (Bitfield-Mask: 0x7f)           */
#define CLKGEN_CTRLOW_CTR100_Pos          (0UL)                     /*!< CLKGEN CTRLOW: CTR100 (Bit 0)                         */
#define CLKGEN_CTRLOW_CTR100_Msk          (0xffUL)                  /*!< CLKGEN CTRLOW: CTR100 (Bitfield-Mask: 0xff)           */
/* =========================================================  CTRUP  ========================================================= */
#define CLKGEN_CTRUP_CTERR_Pos            (31UL)                    /*!< CLKGEN CTRUP: CTERR (Bit 31)                          */
#define CLKGEN_CTRUP_CTERR_Msk            (0x80000000UL)            /*!< CLKGEN CTRUP: CTERR (Bitfield-Mask: 0x01)             */
#define CLKGEN_CTRUP_CEB_Pos              (28UL)                    /*!< CLKGEN CTRUP: CEB (Bit 28)                            */
#define CLKGEN_CTRUP_CEB_Msk              (0x10000000UL)            /*!< CLKGEN CTRUP: CEB (Bitfield-Mask: 0x01)               */
#define CLKGEN_CTRUP_CB_Pos               (27UL)                    /*!< CLKGEN CTRUP: CB (Bit 27)                             */
#define CLKGEN_CTRUP_CB_Msk               (0x8000000UL)             /*!< CLKGEN CTRUP: CB (Bitfield-Mask: 0x01)                */
#define CLKGEN_CTRUP_CTRWKDY_Pos          (24UL)                    /*!< CLKGEN CTRUP: CTRWKDY (Bit 24)                        */
#define CLKGEN_CTRUP_CTRWKDY_Msk          (0x7000000UL)             /*!< CLKGEN CTRUP: CTRWKDY (Bitfield-Mask: 0x07)           */
#define CLKGEN_CTRUP_CTRYR_Pos            (16UL)                    /*!< CLKGEN CTRUP: CTRYR (Bit 16)                          */
#define CLKGEN_CTRUP_CTRYR_Msk            (0xff0000UL)              /*!< CLKGEN CTRUP: CTRYR (Bitfield-Mask: 0xff)             */
#define CLKGEN_CTRUP_CTRMO_Pos            (8UL)                     /*!< CLKGEN CTRUP: CTRMO (Bit 8)                           */
#define CLKGEN_CTRUP_CTRMO_Msk            (0x1f00UL)                /*!< CLKGEN CTRUP: CTRMO (Bitfield-Mask: 0x1f)             */
#define CLKGEN_CTRUP_CTRDATE_Pos          (0UL)                     /*!< CLKGEN CTRUP: CTRDATE (Bit 0)                         */
#define CLKGEN_CTRUP_CTRDATE_Msk          (0x3fUL)                  /*!< CLKGEN CTRUP: CTRDATE (Bitfield-Mask: 0x3f)           */
/* ========================================================  ALMLOW  ========================================================= */
#define CLKGEN_ALMLOW_ALMHR_Pos           (24UL)                    /*!< CLKGEN ALMLOW: ALMHR (Bit 24)                         */
#define CLKGEN_ALMLOW_ALMHR_Msk           (0x3f000000UL)            /*!< CLKGEN ALMLOW: ALMHR (Bitfield-Mask: 0x3f)            */
#define CLKGEN_ALMLOW_ALMMIN_Pos          (16UL)                    /*!< CLKGEN ALMLOW: ALMMIN (Bit 16)                        */
#define CLKGEN_ALMLOW_ALMMIN_Msk          (0x7f0000UL)              /*!< CLKGEN ALMLOW: ALMMIN (Bitfield-Mask: 0x7f)           */
#define CLKGEN_ALMLOW_ALMSEC_Pos          (8UL)                     /*!< CLKGEN ALMLOW: ALMSEC (Bit 8)                         */
#define CLKGEN_ALMLOW_ALMSEC_Msk          (0x7f00UL)                /*!< CLKGEN ALMLOW: ALMSEC (Bitfield-Mask: 0x7f)           */
#define CLKGEN_ALMLOW_ALM100_Pos          (0UL)                     /*!< CLKGEN ALMLOW: ALM100 (Bit 0)                         */
#define CLKGEN_ALMLOW_ALM100_Msk          (0xffUL)                  /*!< CLKGEN ALMLOW: ALM100 (Bitfield-Mask: 0xff)           */
/* =========================================================  ALMUP  ========================================================= */
#define CLKGEN_ALMUP_ALMWKDY_Pos          (16UL)                    /*!< CLKGEN ALMUP: ALMWKDY (Bit 16)                        */
#define CLKGEN_ALMUP_ALMWKDY_Msk          (0x70000UL)               /*!< CLKGEN ALMUP: ALMWKDY (Bitfield-Mask: 0x07)           */
#define CLKGEN_ALMUP_ALMMO_Pos            (8UL)                     /*!< CLKGEN ALMUP: ALMMO (Bit 8)                           */
#define CLKGEN_ALMUP_ALMMO_Msk            (0x1f00UL)                /*!< CLKGEN ALMUP: ALMMO (Bitfield-Mask: 0x1f)             */
#define CLKGEN_ALMUP_ALMDATE_Pos          (0UL)                     /*!< CLKGEN ALMUP: ALMDATE (Bit 0)                         */
#define CLKGEN_ALMUP_ALMDATE_Msk          (0x3fUL)                  /*!< CLKGEN ALMUP: ALMDATE (Bitfield-Mask: 0x3f)           */
/* ========================================================  RTCCTL  ========================================================= */
#define CLKGEN_RTCCTL_HR1224_Pos          (5UL)                     /*!< CLKGEN RTCCTL: HR1224 (Bit 5)                         */
#define CLKGEN_RTCCTL_HR1224_Msk          (0x20UL)                  /*!< CLKGEN RTCCTL: HR1224 (Bitfield-Mask: 0x01)           */
#define CLKGEN_RTCCTL_RSTOP_Pos           (4UL)                     /*!< CLKGEN RTCCTL: RSTOP (Bit 4)                          */
#define CLKGEN_RTCCTL_RSTOP_Msk           (0x10UL)                  /*!< CLKGEN RTCCTL: RSTOP (Bitfield-Mask: 0x01)            */
#define CLKGEN_RTCCTL_RPT_Pos             (1UL)                     /*!< CLKGEN RTCCTL: RPT (Bit 1)                            */
#define CLKGEN_RTCCTL_RPT_Msk             (0xeUL)                   /*!< CLKGEN RTCCTL: RPT (Bitfield-Mask: 0x07)              */
#define CLKGEN_RTCCTL_WRTC_Pos            (0UL)                     /*!< CLKGEN RTCCTL: WRTC (Bit 0)                           */
#define CLKGEN_RTCCTL_WRTC_Msk            (0x1UL)                   /*!< CLKGEN RTCCTL: WRTC (Bitfield-Mask: 0x01)             */
/* =========================================================  INTEN  ========================================================= */
#define CLKGEN_INTEN_ALM_Pos              (3UL)                     /*!< CLKGEN INTEN: ALM (Bit 3)                             */
#define CLKGEN_INTEN_ALM_Msk              (0x8UL)                   /*!< CLKGEN INTEN: ALM (Bitfield-Mask: 0x01)               */
#define CLKGEN_INTEN_OF_Pos               (2UL)                     /*!< CLKGEN INTEN: OF (Bit 2)                              */
#define CLKGEN_INTEN_OF_Msk               (0x4UL)                   /*!< CLKGEN INTEN: OF (Bitfield-Mask: 0x01)                */
#define CLKGEN_INTEN_ACC_Pos              (1UL)                     /*!< CLKGEN INTEN: ACC (Bit 1)                             */
#define CLKGEN_INTEN_ACC_Msk              (0x2UL)                   /*!< CLKGEN INTEN: ACC (Bitfield-Mask: 0x01)               */
#define CLKGEN_INTEN_ACF_Pos              (0UL)                     /*!< CLKGEN INTEN: ACF (Bit 0)                             */
#define CLKGEN_INTEN_ACF_Msk              (0x1UL)                   /*!< CLKGEN INTEN: ACF (Bitfield-Mask: 0x01)               */
/* ========================================================  INTSTAT  ======================================================== */
#define CLKGEN_INTSTAT_ALM_Pos            (3UL)                     /*!< CLKGEN INTSTAT: ALM (Bit 3)                           */
#define CLKGEN_INTSTAT_ALM_Msk            (0x8UL)                   /*!< CLKGEN INTSTAT: ALM (Bitfield-Mask: 0x01)             */
#define CLKGEN_INTSTAT_OF_Pos             (2UL)                     /*!< CLKGEN INTSTAT: OF (Bit 2)                            */
#define CLKGEN_INTSTAT_OF_Msk             (0x4UL)                   /*!< CLKGEN INTSTAT: OF (Bitfield-Mask: 0x01)              */
#define CLKGEN_INTSTAT_ACC_Pos            (1UL)                     /*!< CLKGEN INTSTAT: ACC (Bit 1)                           */
#define CLKGEN_INTSTAT_ACC_Msk            (0x2UL)                   /*!< CLKGEN INTSTAT: ACC (Bitfield-Mask: 0x01)             */
#define CLKGEN_INTSTAT_ACF_Pos            (0UL)                     /*!< CLKGEN INTSTAT: ACF (Bit 0)                           */
#define CLKGEN_INTSTAT_ACF_Msk            (0x1UL)                   /*!< CLKGEN INTSTAT: ACF (Bitfield-Mask: 0x01)             */
/* ========================================================  INTCLR  ========================================================= */
#define CLKGEN_INTCLR_ALM_Pos             (3UL)                     /*!< CLKGEN INTCLR: ALM (Bit 3)                            */
#define CLKGEN_INTCLR_ALM_Msk             (0x8UL)                   /*!< CLKGEN INTCLR: ALM (Bitfield-Mask: 0x01)              */
#define CLKGEN_INTCLR_OF_Pos              (2UL)                     /*!< CLKGEN INTCLR: OF (Bit 2)                             */
#define CLKGEN_INTCLR_OF_Msk              (0x4UL)                   /*!< CLKGEN INTCLR: OF (Bitfield-Mask: 0x01)               */
#define CLKGEN_INTCLR_ACC_Pos             (1UL)                     /*!< CLKGEN INTCLR: ACC (Bit 1)                            */
#define CLKGEN_INTCLR_ACC_Msk             (0x2UL)                   /*!< CLKGEN INTCLR: ACC (Bitfield-Mask: 0x01)              */
#define CLKGEN_INTCLR_ACF_Pos             (0UL)                     /*!< CLKGEN INTCLR: ACF (Bit 0)                            */
#define CLKGEN_INTCLR_ACF_Msk             (0x1UL)                   /*!< CLKGEN INTCLR: ACF (Bitfield-Mask: 0x01)              */
/* ========================================================  INTSET  ========================================================= */
#define CLKGEN_INTSET_ALM_Pos             (3UL)                     /*!< CLKGEN INTSET: ALM (Bit 3)                            */
#define CLKGEN_INTSET_ALM_Msk             (0x8UL)                   /*!< CLKGEN INTSET: ALM (Bitfield-Mask: 0x01)              */
#define CLKGEN_INTSET_OF_Pos              (2UL)                     /*!< CLKGEN INTSET: OF (Bit 2)                             */
#define CLKGEN_INTSET_OF_Msk              (0x4UL)                   /*!< CLKGEN INTSET: OF (Bitfield-Mask: 0x01)               */
#define CLKGEN_INTSET_ACC_Pos             (1UL)                     /*!< CLKGEN INTSET: ACC (Bit 1)                            */
#define CLKGEN_INTSET_ACC_Msk             (0x2UL)                   /*!< CLKGEN INTSET: ACC (Bitfield-Mask: 0x01)              */
#define CLKGEN_INTSET_ACF_Pos             (0UL)                     /*!< CLKGEN INTSET: ACF (Bit 0)                            */
#define CLKGEN_INTSET_ACF_Msk             (0x1UL)                   /*!< CLKGEN INTSET: ACF (Bitfield-Mask: 0x01)              */

/** @} */ /* End of group PosMask_peripherals */


#ifdef __cplusplus
}
#endif

#endif /* APOLLO2_H */


/** @} */ /* End of group apollo2 */

/** @} */ /* End of group Ambiq Micro */
