/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.dependency.utils;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;

public class DependencyStatusSets {
    TreeSet resolvedDependencies = null;
    TreeSet unResolvedDependencies = null;
    TreeSet skippedDependencies = null;

    public DependencyStatusSets() {
    }

    public DependencyStatusSets(Set resolved, Set unResolved, Set skipped) {
        if (resolved != null) {
            this.resolvedDependencies = new TreeSet(resolved);
        }
        if (unResolved != null) {
            this.unResolvedDependencies = new TreeSet(unResolved);
        }
        if (skipped != null) {
            this.skippedDependencies = new TreeSet(skipped);
        }
    }

    public Set getResolvedDependencies() {
        return this.resolvedDependencies;
    }

    public void setResolvedDependencies(Set resolvedDependencies) {
        this.resolvedDependencies = resolvedDependencies != null ? new TreeSet(resolvedDependencies) : null;
    }

    public Set getSkippedDependencies() {
        return this.skippedDependencies;
    }

    public void setSkippedDependencies(Set skippedDependencies) {
        this.skippedDependencies = skippedDependencies != null ? new TreeSet(skippedDependencies) : null;
    }

    public Set getUnResolvedDependencies() {
        return this.unResolvedDependencies;
    }

    public void setUnResolvedDependencies(Set unResolvedDependencies) {
        this.unResolvedDependencies = unResolvedDependencies != null ? new TreeSet(unResolvedDependencies) : null;
    }

    public String getOutput(boolean outputAbsoluteArtifactFilename) {
        return this.getOutput(outputAbsoluteArtifactFilename, true);
    }

    public String getOutput(boolean outputAbsoluteArtifactFilename, boolean outputScope) {
        Iterator i;
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append("The following files have been resolved:\n");
        if (this.resolvedDependencies == null || this.resolvedDependencies.isEmpty()) {
            sb.append("   none\n");
        } else {
            Iterator i2 = this.resolvedDependencies.iterator();
            while (i2.hasNext()) {
                Artifact artifact = (Artifact)i2.next();
                String artifactFilename = null;
                if (outputAbsoluteArtifactFilename) {
                    try {
                        artifactFilename = artifact.getFile().getAbsoluteFile().getPath();
                    }
                    catch (NullPointerException e) {
                        artifactFilename = null;
                    }
                }
                String id = outputScope ? artifact.toString() : artifact.getId();
                sb.append("   " + id + (outputAbsoluteArtifactFilename ? ":" + artifactFilename : "") + "\n");
            }
        }
        if (this.skippedDependencies != null && !this.skippedDependencies.isEmpty()) {
            sb.append("\n");
            sb.append("The following files where skipped:\n");
            TreeSet sortedSkippedDependencies = new TreeSet();
            sortedSkippedDependencies.addAll(this.skippedDependencies);
            i = sortedSkippedDependencies.iterator();
            while (i.hasNext()) {
                sb.append("   " + ((Artifact)i.next()).getId() + "\n");
            }
        }
        if (this.unResolvedDependencies != null && !this.unResolvedDependencies.isEmpty()) {
            sb.append("\n");
            sb.append("The following files have NOT been resolved:\n");
            TreeSet sortedUnResolvedDependencies = new TreeSet();
            sortedUnResolvedDependencies.addAll(this.unResolvedDependencies);
            i = sortedUnResolvedDependencies.iterator();
            while (i.hasNext()) {
                sb.append("   " + ((Artifact)i.next()).getId() + "\n");
            }
        }
        sb.append("\n");
        return sb.toString();
    }
}

