/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.math.BigInteger;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Rendition;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.bindings.spi.LinkAccess;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RenditionDataImpl;

public class RenditionImpl
extends RenditionDataImpl
implements Rendition {
    private static final long serialVersionUID = 1L;
    private final Session session;
    private final String objectId;

    public RenditionImpl(Session session, String objectId, String streamId, String renditionDocumentId, String kind, long length, String mimeType, String title, int height, int width) {
        super(streamId, mimeType, BigInteger.valueOf(length), kind, title, BigInteger.valueOf(width), BigInteger.valueOf(height), renditionDocumentId);
        this.session = session;
        this.objectId = objectId;
    }

    public long getLength() {
        return this.getBigLength() == null ? -1L : this.getBigLength().longValue();
    }

    public long getHeight() {
        return this.getBigHeight() == null ? -1L : this.getBigHeight().longValue();
    }

    public long getWidth() {
        return this.getBigWidth() == null ? -1L : this.getBigWidth().longValue();
    }

    public Document getRenditionDocument() {
        return this.getRenditionDocument(this.session.getDefaultContext());
    }

    public Document getRenditionDocument(OperationContext context) {
        if (this.getRenditionDocumentId() == null) {
            return null;
        }
        CmisObject rendDoc = this.session.getObject(this.getRenditionDocumentId(), context);
        if (!(rendDoc instanceof Document)) {
            return null;
        }
        return (Document)rendDoc;
    }

    public ContentStream getContentStream() {
        BigInteger bigLength;
        ContentStream contentStream;
        if (this.objectId == null || this.getStreamId() == null) {
            return null;
        }
        try {
            contentStream = this.session.getBinding().getObjectService().getContentStream(this.session.getRepositoryInfo().getId(), this.objectId, this.getStreamId(), null, null, null);
        }
        catch (CmisConstraintException e) {
            return null;
        }
        if (contentStream == null) {
            return null;
        }
        String filename = contentStream.getFileName();
        if (filename == null) {
            filename = this.getTitle();
        }
        if ((bigLength = contentStream.getBigLength()) == null) {
            bigLength = this.getBigLength();
        }
        long length = bigLength == null ? -1L : bigLength.longValue();
        return this.session.getObjectFactory().createContentStream(filename, length, contentStream.getMimeType(), contentStream.getStream());
    }

    public String getContentUrl() {
        if (this.session.getBinding().getObjectService() instanceof LinkAccess) {
            LinkAccess linkAccess = (LinkAccess)this.session.getBinding().getObjectService();
            return linkAccess.loadRenditionContentLink(this.session.getRepositoryInfo().getId(), this.objectId, this.getStreamId());
        }
        return null;
    }
}

