/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.InterpolableName;
import com.github.sommeri.less4j.core.ast.Selector;
import com.github.sommeri.less4j.core.ast.SelectorCombinator;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.core.problems.BugHappened;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class SelectorPart
extends ASTCssNode {
    private SelectorCombinator leadingCombinator;

    public SelectorPart(HiddenTokenAwareTree underlyingStructure, SelectorCombinator leadingCombinator) {
        super(underlyingStructure);
        this.leadingCombinator = leadingCombinator;
    }

    public SelectorCombinator getLeadingCombinator() {
        return this.leadingCombinator;
    }

    public void setLeadingCombinator(SelectorCombinator leadingCombinator) {
        this.leadingCombinator = leadingCombinator;
    }

    public boolean hasLeadingCombinator() {
        return this.leadingCombinator != null;
    }

    public boolean isClassesAndIdsOnlySelector() {
        return false;
    }

    public boolean isAppender() {
        return false;
    }

    public boolean isEmpty() {
        return false;
    }

    @NotAstProperty
    public List<ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.leadingCombinator);
    }

    @Override
    public SelectorPart clone() {
        SelectorPart clone = (SelectorPart)super.clone();
        clone.setLeadingCombinator(this.getLeadingCombinator() == null ? null : this.getLeadingCombinator().clone());
        return clone;
    }

    public List<ElementSubsequent> getSubsequent() {
        return new ArrayList<ElementSubsequent>();
    }

    public boolean hasElement() {
        return false;
    }

    public InterpolableName getElementName() {
        return null;
    }

    public ElementSubsequent getLastSubsequent() {
        List<ElementSubsequent> subsequent = this.getSubsequent();
        if (subsequent.isEmpty()) {
            return null;
        }
        return subsequent.get(subsequent.size() - 1);
    }

    public boolean hasSubsequent() {
        return !this.getSubsequent().isEmpty();
    }

    public void addSubsequent(List<ElementSubsequent> subsequent) {
        throw new BugHappened("Attempt to add subsequent element to unexpected selector part.", (ASTCssNode)this);
    }

    public void removeSubsequent(ElementSubsequent subsequent) {
        throw new BugHappened("Attempt to remove subsequent element from unexpected selector part.", (ASTCssNode)this);
    }

    public void extendName(String secondName) {
        this.extendName(secondName, this.getUnderlyingStructure());
    }

    public void extendName(String extension, HiddenTokenAwareTree underlyingStructureOfExtension) {
        throw new BugHappened("Attempt to extend a name of unexpected selector part.", (ASTCssNode)this);
    }

    public Selector getParentAsSelector() {
        return (Selector)this.getParent();
    }
}

