/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.misc;

import java.io.IOException;
import java.nio.ByteBuffer;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.misc.AbstractLightningIOSP;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class Nldn
extends AbstractLightningIOSP {
    private static final String MAGIC = "NLDN";
    private Structure seq;
    private StructureMembers sm;
    private static final String TSEC = "tsec";
    private static final String NSEC = "nsec";
    private static final String CHISQR = "chisqr";
    private static final String FILL = "fill";
    private static final int recHeader = 84;
    private static final int recSize = 28;
    private int nelems = -1;

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        String test = raf.readString(MAGIC.length());
        return test.equals(MAGIC);
    }

    @Override
    public String getFileTypeId() {
        return MAGIC;
    }

    @Override
    public String getFileTypeDescription() {
        return "National Lightning Detection Network";
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        this.seq = new Sequence(ncfile, null, null, "record");
        ncfile.addVariable(null, this.seq);
        Variable v = this.makeLightningVariable(ncfile, null, this.seq, TSEC, DataType.INT, "", "time of stroke", null, "seconds since 1970-01-01 00:00:00", AxisType.Time);
        this.seq.addMemberVariable(v);
        v = this.makeLightningVariable(ncfile, null, this.seq, NSEC, DataType.INT, "", "nanoseconds since tsec", null, "1.0e-9 s", null);
        this.seq.addMemberVariable(v);
        v = this.makeLightningVariable(ncfile, null, this.seq, "lat", DataType.INT, "", "latitude", "latitude", "degrees_north", AxisType.Lat);
        v.addAttribute(new Attribute("scale_factor", new Float(0.001)));
        this.seq.addMemberVariable(v);
        v = this.makeLightningVariable(ncfile, null, this.seq, "lon", DataType.INT, "", "longitude", "longitude", "degrees_east", AxisType.Lon);
        v.addAttribute(new Attribute("scale_factor", new Float(0.001)));
        this.seq.addMemberVariable(v);
        v = this.makeLightningVariable(ncfile, null, this.seq, "sgnl", DataType.SHORT, "", "signal strength/polarity [150 NLDN measures ~= 30 kAmps]", null, "", null);
        v.addAttribute(new Attribute("scale_factor", new Float(0.1)));
        this.seq.addMemberVariable(v);
        v = this.makeLightningVariable(ncfile, null, this.seq, "mult", DataType.BYTE, "", "multiplicity [#strokes per flash]", null, "", null);
        this.seq.addMemberVariable(v);
        v = new Variable(ncfile, null, this.seq, FILL);
        v.setDataType(DataType.BYTE);
        v.setDimensions("");
        this.seq.addMemberVariable(v);
        v = this.makeLightningVariable(ncfile, null, this.seq, "majorAxis", DataType.BYTE, "", "error ellipse semi-major axis", null, "", null);
        this.seq.addMemberVariable(v);
        v = this.makeLightningVariable(ncfile, null, this.seq, "eccent", DataType.BYTE, "", "error ellipse eccentricity ", null, "", null);
        this.seq.addMemberVariable(v);
        v = this.makeLightningVariable(ncfile, null, this.seq, "ellipseAngle", DataType.BYTE, "", "error ellipse axis angle of orientation ", null, "degrees", null);
        this.seq.addMemberVariable(v);
        v = this.makeLightningVariable(ncfile, null, this.seq, CHISQR, DataType.BYTE, "", "chi-squared", null, "", null);
        this.seq.addMemberVariable(v);
        this.addLightningGlobalAttributes(ncfile);
        ncfile.finish();
        this.sm = this.seq.makeStructureMembers();
        this.sm.findMember(TSEC).setDataParam(0);
        this.sm.findMember(NSEC).setDataParam(4);
        this.sm.findMember("lat").setDataParam(8);
        this.sm.findMember("lon").setDataParam(12);
        this.sm.findMember("sgnl").setDataParam(18);
        this.sm.findMember("mult").setDataParam(22);
        this.sm.findMember(FILL).setDataParam(23);
        this.sm.findMember("majorAxis").setDataParam(24);
        this.sm.findMember("eccent").setDataParam(25);
        this.sm.findMember("ellipseAngle").setDataParam(26);
        this.sm.findMember(CHISQR).setDataParam(27);
        this.sm.setStructureSize(28);
    }

    @Override
    protected void addLightningGlobalAttributes(NetcdfFile ncfile) {
        super.addLightningGlobalAttributes(ncfile);
        ncfile.addAttribute(null, new Attribute("title", "NLDN Lightning Data"));
        ncfile.addAttribute(null, new Attribute("Conventions", "NLDN-CDM"));
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        return new ArraySequence(this.sm, new SeqIter(), this.nelems);
    }

    @Override
    public StructureDataIterator getStructureIterator(Structure s, int bufferSize) throws IOException {
        return new SeqIter();
    }

    private class SeqIter
    implements StructureDataIterator {
        private int done = 0;
        private int alreadyRead = 0;
        private int nextIndex = 0;
        private ArrayStructureBB asbb = null;
        private long totalBytes;
        private long bytesRead;

        SeqIter() throws IOException {
            this.totalBytes = (int)Nldn.this.raf.length();
            Nldn.this.raf.seek(0L);
        }

        @Override
        public StructureDataIterator reset() {
            this.done = 0;
            this.alreadyRead = 0;
            this.bytesRead = 0L;
            this.nextIndex = 0;
            try {
                Nldn.this.raf.seek(0L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.done < this.alreadyRead) {
                return true;
            }
            return this.readHeader();
        }

        @Override
        public StructureData next() throws IOException {
            ++this.done;
            return this.asbb.getStructureData(this.nextIndex++);
        }

        private boolean readHeader() throws IOException {
            if (this.bytesRead + 84L > this.totalBytes) {
                Nldn.this.nelems = this.done;
                return false;
            }
            byte[] b = new byte[84];
            Nldn.this.raf.readFully(b);
            this.bytesRead += 84L;
            ByteBuffer bb = ByteBuffer.wrap(b);
            int count = bb.getInt(8);
            if (count == 0) {
                return this.readHeader();
            }
            if (this.bytesRead + (long)(count * 28) > this.totalBytes) {
                return false;
            }
            byte[] data = new byte[count * 28];
            Nldn.this.raf.readFully(data);
            this.bytesRead += (long)(count * 28);
            this.alreadyRead += count;
            this.nextIndex = 0;
            ByteBuffer bbdata = ByteBuffer.wrap(data);
            this.asbb = new ArrayStructureBB(Nldn.this.sm, new int[]{count}, bbdata, 0);
            return true;
        }

        @Override
        public void setBufferSize(int bytes) {
        }

        @Override
        public int getCurrentRecno() {
            return this.done - 1;
        }

        @Override
        public void finish() {
        }
    }
}

