/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.googledrive;

import com.google.api.services.drive.model.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.connectorcommon.common.XThreadInputStream;
import org.apache.manifoldcf.connectorcommon.common.XThreadStringBuffer;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.crawler.connectors.BaseRepositoryConnector;
import org.apache.manifoldcf.crawler.connectors.googledrive.GoogleDriveSession;
import org.apache.manifoldcf.crawler.connectors.googledrive.Messages;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.Logging;

public class GoogleDriveRepositoryConnector
extends BaseRepositoryConnector {
    protected static final String ACTIVITY_READ = "read document";
    public static final String ACTIVITY_FETCH = "fetch";
    protected static final String RELATIONSHIP_CHILD = "child";
    private static final String defaultAuthorityDenyToken = "DEAD_AUTHORITY";
    private static final String JOB_STARTPOINT_NODE_TYPE = "startpoint";
    private static final String JOB_QUERY_ATTRIBUTE = "query";
    private static final String JOB_ACCESS_NODE_TYPE = "access";
    private static final String JOB_TOKEN_ATTRIBUTE = "token";
    private static final String GOOGLEDRIVE_SERVER_TAB_PROPERTY = "GoogleDriveRepositoryConnector.Server";
    private static final String GOOGLEDRIVE_QUERY_TAB_PROPERTY = "GoogleDriveRepositoryConnector.GoogleDriveQuery";
    private static final String GOOGLEDRIVE_SECURITY_TAB_PROPERTY = "GoogleDriveRepositoryConnector.Security";
    private static final String EDIT_CONFIG_HEADER_FORWARD = "editConfiguration_google_server.js";
    private static final String EDIT_CONFIG_FORWARD_SERVER = "editConfiguration_google_server.html";
    private static final String VIEW_CONFIG_FORWARD = "viewConfiguration_googledrive.html";
    private static final String EDIT_SPEC_HEADER_FORWARD = "editSpecification_googledrive.js";
    private static final String EDIT_SPEC_FORWARD_GOOGLEDRIVEQUERY = "editSpecification_googledriveQuery.html";
    private static final String EDIT_SPEC_FORWARD_SECURITY = "editSpecification_googledriveSecurity.html";
    private static final String VIEW_SPEC_FORWARD = "viewSpecification_googledrive.html";
    private static final String CONTENT_PATH_PARAM = "contentPath";
    private String SLASH = "/";
    protected String server = "googledrive";
    protected GoogleDriveSession session = null;
    protected long lastSessionFetch = -1L;
    protected static final long timeToRelease = 300000L;
    protected String clientid = null;
    protected String clientsecret = null;
    protected String refreshtoken = null;

    public String[] getActivitiesList() {
        return new String[]{ACTIVITY_FETCH, ACTIVITY_READ};
    }

    public String[] getBinNames(String documentIdentifier) {
        return new String[]{this.server};
    }

    public void disconnect() throws ManifoldCFException {
        if (this.session != null) {
            this.session.close();
            this.session = null;
            this.lastSessionFetch = -1L;
        }
        this.clientid = null;
        this.clientsecret = null;
        this.refreshtoken = null;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.clientid = this.params.getParameter("clientid");
        this.clientsecret = this.params.getObfuscatedParameter("clientsecret");
        this.refreshtoken = this.params.getParameter("refreshtoken");
    }

    public String check() throws ManifoldCFException {
        try {
            this.checkConnection();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Connection temporarily failed: " + e.getMessage();
        }
        catch (ManifoldCFException e) {
            return "Connection failed: " + e.getMessage();
        }
    }

    protected void checkConnection() throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        CheckConnectionThread t = new CheckConnectionThread();
        try {
            t.start();
            t.join();
            Throwable thr = t.getException();
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
            return;
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (SocketTimeoutException e) {
            Logging.connectors.warn((Object)("GOOGLEDRIVE: Socket timeout: " + e.getMessage()), (Throwable)e);
            GoogleDriveRepositoryConnector.handleIOException(e);
        }
        catch (InterruptedIOException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            Logging.connectors.warn((Object)("GOOGLEDRIVE: Error checking repository: " + e.getMessage()), (Throwable)e);
            GoogleDriveRepositoryConnector.handleIOException(e);
        }
    }

    protected void getSession() throws ManifoldCFException, ServiceInterruption {
        if (this.session == null) {
            if (StringUtils.isEmpty((String)this.clientid)) {
                throw new ManifoldCFException("Parameter clientid required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("GOOGLEDRIVE: Clientid = '" + this.clientid + "'"));
            }
            if (StringUtils.isEmpty((String)this.clientsecret)) {
                throw new ManifoldCFException("Parameter clientsecret required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("GOOGLEDRIVE: Clientsecret = '" + this.clientsecret + "'"));
            }
            if (StringUtils.isEmpty((String)this.refreshtoken)) {
                throw new ManifoldCFException("Parameter refreshtoken required but not set");
            }
            if (Logging.connectors.isDebugEnabled()) {
                Logging.connectors.debug((Object)("GOOGLEDRIVE: refreshtoken = '" + this.refreshtoken + "'"));
            }
            GetSessionThread t = new GetSessionThread();
            try {
                t.start();
                t.join();
                Throwable thr = t.getException();
                if (thr != null) {
                    if (thr instanceof IOException) {
                        throw (IOException)thr;
                    }
                    if (thr instanceof GeneralSecurityException) {
                        throw (GeneralSecurityException)thr;
                    }
                    throw (Error)thr;
                }
            }
            catch (InterruptedException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (SocketTimeoutException e) {
                Logging.connectors.warn((Object)("GOOGLEDRIVE: Socket timeout: " + e.getMessage()), (Throwable)e);
                GoogleDriveRepositoryConnector.handleIOException(e);
            }
            catch (InterruptedIOException e) {
                t.interrupt();
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
            }
            catch (GeneralSecurityException e) {
                Logging.connectors.error((Object)("GOOGLEDRIVE: General security error initializing transport: " + e.getMessage()), (Throwable)e);
                GoogleDriveRepositoryConnector.handleGeneralSecurityException(e);
            }
            catch (IOException e) {
                Logging.connectors.warn((Object)("GOOGLEDRIVE: IO error: " + e.getMessage()), (Throwable)e);
                GoogleDriveRepositoryConnector.handleIOException(e);
            }
        }
        this.lastSessionFetch = System.currentTimeMillis();
    }

    public void poll() throws ManifoldCFException {
        if (this.lastSessionFetch == -1L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.lastSessionFetch + 300000L) {
            this.session.close();
            this.session = null;
            this.lastSessionFetch = -1L;
        }
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public int getMaxDocumentRequest() {
        return 1;
    }

    public String[] getRelationshipTypes() {
        return new String[]{RELATIONSHIP_CHILD};
    }

    private static void fillInServerConfigurationMap(Map<String, Object> newMap, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String clientid = parameters.getParameter("clientid");
        String clientsecret = parameters.getObfuscatedParameter("clientsecret");
        String refreshtoken = parameters.getParameter("refreshtoken");
        if (clientid == null) {
            clientid = "";
        }
        clientsecret = clientsecret == null ? "" : mapper.mapPasswordToKey(clientsecret);
        if (refreshtoken == null) {
            refreshtoken = "";
        }
        newMap.put("CLIENTID", clientid);
        newMap.put("CLIENTSECRET", clientsecret);
        newMap.put("REFRESHTOKEN", refreshtoken);
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        GoogleDriveRepositoryConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, VIEW_CONFIG_FORWARD, paramMap);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, GOOGLEDRIVE_SERVER_TAB_PROPERTY));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        GoogleDriveRepositoryConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_HEADER_FORWARD, paramMap);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        GoogleDriveRepositoryConnector.fillInServerConfigurationMap(paramMap, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, EDIT_CONFIG_FORWARD_SERVER, paramMap);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String refreshtoken;
        String clientsecret;
        String clientid = variableContext.getParameter("clientid");
        if (clientid != null) {
            parameters.setParameter("clientid", clientid);
        }
        if ((clientsecret = variableContext.getParameter("clientsecret")) != null) {
            parameters.setObfuscatedParameter("clientsecret", variableContext.mapKeyToPassword(clientsecret));
        }
        if ((refreshtoken = variableContext.getParameter("refreshtoken")) != null) {
            parameters.setParameter("refreshtoken", refreshtoken);
        }
        return null;
    }

    private static void fillInGOOGLEDRIVEQuerySpecificationMap(Map<String, Object> newMap, Specification ds) {
        String GoogleDriveQuery = "mimeType='application/vnd.google-apps.folder' and trashed=false";
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (!sn.getType().equals(JOB_STARTPOINT_NODE_TYPE)) continue;
            GoogleDriveQuery = sn.getAttributeValue(JOB_QUERY_ATTRIBUTE);
        }
        newMap.put("GOOGLEDRIVEQUERY", GoogleDriveQuery);
    }

    private static void fillInGOOGLEDRIVESecuritySpecificationMap(Map<String, Object> newMap, Specification ds) {
        ArrayList accessTokenList = new ArrayList();
        for (int i = 0; i < ds.getChildCount(); ++i) {
            SpecificationNode sn = ds.getChild(i);
            if (!sn.getType().equals(JOB_ACCESS_NODE_TYPE)) continue;
            String token = sn.getAttributeValue(JOB_TOKEN_ATTRIBUTE);
            HashMap<String, String> accessMap = new HashMap<String, String>();
            accessMap.put("TOKEN", token);
            accessTokenList.add(accessMap);
        }
        newMap.put("ACCESSTOKENS", accessTokenList);
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        GoogleDriveRepositoryConnector.fillInGOOGLEDRIVEQuerySpecificationMap(paramMap, ds);
        GoogleDriveRepositoryConnector.fillInGOOGLEDRIVESecuritySpecificationMap(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, VIEW_SPEC_FORWARD, paramMap);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        String xc;
        String seqPrefix = "s" + connectionSequenceNumber + "_";
        String googleDriveQuery = variableContext.getParameter(seqPrefix + "googledrivequery");
        if (googleDriveQuery != null) {
            for (int i = 0; i < ds.getChildCount(); ++i) {
                SpecificationNode oldNode = ds.getChild(i);
                if (!oldNode.getType().equals(JOB_STARTPOINT_NODE_TYPE)) continue;
                ds.removeChild(i);
                break;
            }
            SpecificationNode node = new SpecificationNode(JOB_STARTPOINT_NODE_TYPE);
            node.setAttribute(JOB_QUERY_ATTRIBUTE, googleDriveQuery);
            ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
        }
        if ((xc = variableContext.getParameter(seqPrefix + "tokencount")) != null) {
            int i = 0;
            while (i < ds.getChildCount()) {
                SpecificationNode sn = ds.getChild(i);
                if (sn.getType().equals(JOB_ACCESS_NODE_TYPE)) {
                    ds.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = seqPrefix + "accessop" + accessDescription;
                xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter(seqPrefix + "spectoken" + accessDescription);
                SpecificationNode node = new SpecificationNode(JOB_ACCESS_NODE_TYPE);
                node.setAttribute(JOB_TOKEN_ATTRIBUTE, accessSpec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            String op = variableContext.getParameter(seqPrefix + "accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter(seqPrefix + "spectoken");
                SpecificationNode node = new SpecificationNode(JOB_ACCESS_NODE_TYPE);
                node.setAttribute(JOB_TOKEN_ATTRIBUTE, accessspec);
                ds.addChild(ds.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("TabName", tabName);
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        paramMap.put("SelectedNum", Integer.toString(actualSequenceNumber));
        GoogleDriveRepositoryConnector.fillInGOOGLEDRIVEQuerySpecificationMap(paramMap, ds);
        GoogleDriveRepositoryConnector.fillInGOOGLEDRIVESecuritySpecificationMap(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_FORWARD_GOOGLEDRIVEQUERY, paramMap);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_FORWARD_SECURITY, paramMap);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, GOOGLEDRIVE_QUERY_TAB_PROPERTY));
        tabsArray.add(Messages.getString(locale, GOOGLEDRIVE_SECURITY_TAB_PROPERTY));
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("SeqNum", Integer.toString(connectionSequenceNumber));
        GoogleDriveRepositoryConnector.fillInGOOGLEDRIVEQuerySpecificationMap(paramMap, ds);
        GoogleDriveRepositoryConnector.fillInGOOGLEDRIVESecuritySpecificationMap(paramMap, ds);
        Messages.outputResourceWithVelocity(out, locale, EDIT_SPEC_HEADER_FORWARD, paramMap);
    }

    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        String googleDriveQuery = "mimeType='application/vnd.google-apps.folder' and trashed=false";
        for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (!sn.getType().equals(JOB_STARTPOINT_NODE_TYPE)) continue;
            googleDriveQuery = sn.getAttributeValue(JOB_QUERY_ATTRIBUTE);
            break;
        }
        this.getSession();
        GetSeedsThread t = new GetSeedsThread(googleDriveQuery);
        try {
            t.start();
            boolean wasInterrupted = false;
            try {
                String docPath;
                XThreadStringBuffer seedBuffer = t.getBuffer();
                while ((docPath = seedBuffer.fetch()) != null) {
                    activities.addSeedDocument(docPath);
                }
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
                throw e;
            }
            catch (ManifoldCFException e) {
                if (e.getErrorCode() == 2) {
                    wasInterrupted = true;
                }
                throw e;
            }
            finally {
                if (!wasInterrupted) {
                    t.finishUp();
                }
            }
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (SocketTimeoutException e) {
            Logging.connectors.warn((Object)("GOOGLEDRIVE: Socket timeout adding seed documents: " + e.getMessage()), (Throwable)e);
            GoogleDriveRepositoryConnector.handleIOException(e);
        }
        catch (InterruptedIOException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            Logging.connectors.warn((Object)("GOOGLEDRIVE: Error adding seed documents: " + e.getMessage()), (Throwable)e);
            GoogleDriveRepositoryConnector.handleIOException(e);
        }
        return "";
    }

    protected File getObject(String nodeId) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        GetObjectThread t = new GetObjectThread(nodeId);
        try {
            t.start();
            t.join();
            Throwable thr = t.getException();
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                throw (Error)thr;
            }
        }
        catch (InterruptedException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (SocketTimeoutException e) {
            Logging.connectors.warn((Object)("GOOGLEDRIVE: Socket timeout getting object: " + e.getMessage()), (Throwable)e);
            GoogleDriveRepositoryConnector.handleIOException(e);
        }
        catch (InterruptedIOException e) {
            t.interrupt();
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        catch (IOException e) {
            Logging.connectors.warn((Object)("GOOGLEDRIVE: Error getting object: " + e.getMessage()), (Throwable)e);
            GoogleDriveRepositoryConnector.handleIOException(e);
        }
        return t.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        acls = GoogleDriveRepositoryConnector.getAcls(spec);
        Arrays.sort(acls);
        for (String documentIdentifier : documentIdentifiers) {
            block75: {
                block80: {
                    block79: {
                        block78: {
                            block77: {
                                block76: {
                                    googleFile = this.getObject(documentIdentifier);
                                    if (Logging.connectors.isDebugEnabled()) {
                                        Logging.connectors.debug((Object)("GOOGLEDRIVE: Processing document identifier '" + documentIdentifier + "'"));
                                        Logging.connectors.debug((Object)("GOOGLEDRIVE: have this file:\t" + googleFile.getName()));
                                    }
                                    if (googleFile == null || googleFile.containsKey((Object)"explicitlyTrashed") && googleFile.getExplicitlyTrashed().booleanValue() || googleFile.getMimeType().equals("application/vnd.google-apps.shortcut")) {
                                        activities.deleteDocument(documentIdentifier);
                                        continue;
                                    }
                                    if (this.isDir(googleFile)) ** GOTO lbl29
                                    rev = googleFile.getModifiedTime().toStringRfc3339();
                                    if (StringUtils.isNotEmpty((String)rev)) {
                                        sb = new StringBuilder();
                                        GoogleDriveRepositoryConnector.packList((StringBuilder)sb, (String[])acls, (char)'+');
                                        if (acls.length > 0) {
                                            sb.append('+');
                                            GoogleDriveRepositoryConnector.pack((StringBuilder)sb, (String)"DEAD_AUTHORITY", (char)'+');
                                        } else {
                                            sb.append('-');
                                        }
                                        sb.append(rev);
                                        versionString = sb.toString();
                                    } else {
                                        activities.deleteDocument(documentIdentifier);
                                        continue;
lbl29:
                                        // 1 sources

                                        versionString = "";
                                    }
                                    if (versionString.length() != 0 && !activities.checkDocumentNeedsReindexing(documentIdentifier, versionString)) continue;
                                    startTime = System.currentTimeMillis();
                                    errorCode = null;
                                    errorDesc = "";
                                    fileSize = null;
                                    doLog = false;
                                    nodeId = documentIdentifier;
                                    version = versionString;
                                    if (Logging.connectors.isDebugEnabled()) {
                                        Logging.connectors.debug((Object)("GOOGLEDRIVE: Processing document identifier '" + nodeId + "'"));
                                        Logging.connectors.debug((Object)("GOOGLEDRIVE: have this file:\t" + googleFile.getName()));
                                    }
                                    if ("application/vnd.google-apps.folder".equals(googleFile.getMimeType())) {
                                        if (Logging.connectors.isDebugEnabled()) {
                                            Logging.connectors.debug((Object)"GOOGLEDRIVE: its a directory");
                                        }
                                        this.getSession();
                                        t = new GetChildrenThread(nodeId);
                                        try {
                                            t.start();
                                            wasInterrupted = false;
                                            try {
                                                childBuffer = t.getBuffer();
                                                while (true) {
                                                    if ((child = childBuffer.fetch()) == null) {
                                                        break block75;
                                                    }
                                                    activities.addDocumentReference(child, nodeId, "child");
                                                }
                                            }
                                            catch (InterruptedException e) {
                                                wasInterrupted = true;
                                                throw e;
                                            }
                                            catch (ManifoldCFException e) {
                                                if (e.getErrorCode() == 2) {
                                                    wasInterrupted = true;
                                                }
                                                throw e;
                                            }
                                            finally {
                                                if (!wasInterrupted) {
                                                    t.finishUp();
                                                }
                                            }
                                        }
                                        catch (InterruptedException e) {
                                            t.interrupt();
                                            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                                        }
                                        catch (SocketTimeoutException e) {
                                            Logging.connectors.warn((Object)("GOOGLEDRIVE: Socket timeout adding child documents: " + e.getMessage()), (Throwable)e);
                                            GoogleDriveRepositoryConnector.handleIOException(e);
                                            break block75;
                                        }
                                        catch (InterruptedIOException e) {
                                            t.interrupt();
                                            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                                        }
                                        catch (IOException e) {
                                            Logging.connectors.warn((Object)("GOOGLEDRIVE: Error adding child documents: " + e.getMessage()), (Throwable)e);
                                            GoogleDriveRepositoryConnector.handleIOException(e);
                                            break block75;
                                        }
                                    }
                                    doLog = true;
                                    if (Logging.connectors.isDebugEnabled()) {
                                        Logging.connectors.debug((Object)"GOOGLEDRIVE: its a file");
                                    }
                                    if ((fileLengthLong = Long.valueOf(googleFile.getSize() != null ? googleFile.getSize() : 0L)) == null) ** GOTO lbl254
                                    fileLength = fileLengthLong;
                                    mimeType = googleFile.getMimeType();
                                    createdDateObject = googleFile.getCreatedTime();
                                    modifiedDateObject = googleFile.getModifiedTime();
                                    extension = googleFile.getFileExtension();
                                    title = this.cleanupFileFolderName(googleFile.getName());
                                    createdDate = createdDateObject == null ? null : new Date(createdDateObject.getValue());
                                    modifiedDate = modifiedDateObject == null ? null : new Date(modifiedDateObject.getValue());
                                    documentURI = null;
                                    var33_42 = mimeType;
                                    var34_43 = -1;
                                    switch (var33_42.hashCode()) {
                                        case -2035614749: {
                                            if (!var33_42.equals("application/vnd.google-apps.spreadsheet")) break;
                                            var34_43 = 0;
                                            break;
                                        }
                                        case 717553764: {
                                            if (!var33_42.equals("application/vnd.google-apps.document")) break;
                                            var34_43 = 1;
                                            break;
                                        }
                                        case -951557661: {
                                            if (!var33_42.equals("application/vnd.google-apps.presentation")) break;
                                            var34_43 = 2;
                                        }
                                    }
                                    switch (var34_43) {
                                        case 0: {
                                            documentURI = GoogleDriveRepositoryConnector.getUrl(googleFile, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
                                            break;
                                        }
                                        case 1: {
                                            documentURI = GoogleDriveRepositoryConnector.getUrl(googleFile, "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
                                            break;
                                        }
                                        case 2: {
                                            documentURI = GoogleDriveRepositoryConnector.getUrl(googleFile, "application/vnd.openxmlformats-officedocument.presentationml.presentation");
                                            break;
                                        }
                                        default: {
                                            documentURI = GoogleDriveRepositoryConnector.getUrl(googleFile, "application/pdf");
                                        }
                                    }
                                    if (documentURI != null) break block76;
                                    errorCode = "NOLENGTH";
                                    errorDesc = "Document " + nodeId + " had no length; skipping";
                                    if (!doLog || errorCode == null) continue;
                                    activities.recordActivity(new Long(startTime), "read document", fileSize, nodeId, errorCode, (String)errorDesc, null);
                                    continue;
                                }
                                fullContentPath = this.getDocumentContentPath(googleFile, (String)documentURI);
                                documentURI = StringUtils.contains((String)documentURI, (char)'?') != false ? (String)documentURI + "&contentPath=" + fullContentPath : (String)documentURI + "?contentPath=" + fullContentPath;
                                if (activities.checkLengthIndexable(fileLength)) break block77;
                                errorCode = "EXCLUDEDLENGTH";
                                errorDesc = "Excluding document because of file length ('" + fileLength + "')";
                                activities.noDocument(nodeId, version);
                                if (!doLog || errorCode == null) continue;
                                activities.recordActivity(new Long(startTime), "read document", fileSize, nodeId, errorCode, (String)errorDesc, null);
                                continue;
                            }
                            if (activities.checkURLIndexable((String)documentURI)) break block78;
                            errorCode = "EXCLUDEDURL";
                            errorDesc = "Excluding document because of URL ('" + (String)documentURI + "')";
                            activities.noDocument(nodeId, version);
                            if (!doLog || errorCode == null) continue;
                            activities.recordActivity(new Long(startTime), "read document", fileSize, nodeId, errorCode, (String)errorDesc, null);
                            continue;
                        }
                        if (activities.checkMimeTypeIndexable(mimeType)) break block79;
                        errorCode = "EXCLUDEDMIMETYPE";
                        errorDesc = "Excluding document because of mime type (" + mimeType + ")";
                        activities.noDocument(nodeId, version);
                        if (!doLog || errorCode == null) continue;
                        activities.recordActivity(new Long(startTime), "read document", fileSize, nodeId, errorCode, (String)errorDesc, null);
                        continue;
                    }
                    if (activities.checkDateIndexable(modifiedDate)) break block80;
                    errorCode = "EXCLUDEDDATE";
                    errorDesc = "Excluding document because of date (" + modifiedDate + ")";
                    activities.noDocument(nodeId, version);
                    if (!doLog || errorCode == null) continue;
                    activities.recordActivity(new Long(startTime), "read document", fileSize, nodeId, errorCode, (String)errorDesc, null);
                    continue;
                }
                try {
                    rd = new RepositoryDocument();
                    if (acls != null) {
                        rd.setSecurityACL("document", (String[])acls);
                        if (acls.length > 0) {
                            denyAclArray = new String[]{"DEAD_AUTHORITY"};
                            rd.setSecurityDenyACL("document", denyAclArray);
                        }
                    }
                    if (mimeType != null) {
                        rd.setMimeType(this.getFixedMimeType(mimeType));
                    }
                    if (createdDate != null) {
                        rd.setCreatedDate(createdDate);
                    }
                    if (modifiedDate != null) {
                        rd.setModifiedDate(modifiedDate);
                    }
                    if (extension != null) {
                        if (title == null) {
                            title = "";
                        }
                        if (StringUtils.endsWithIgnoreCase((String)title, (String)("." + extension))) {
                            rd.setFileName(title);
                        } else {
                            name = title + "." + extension;
                            if (StringUtils.endsWithIgnoreCase((String)name, (String)".")) {
                                name = StringUtils.chomp((String)name, (String)".");
                            }
                            rd.setFileName((String)name);
                        }
                    } else {
                        if (title == null) {
                            title = "";
                        }
                        if (StringUtils.endsWithIgnoreCase((String)(name = title + "." + this.getExtensionByMimeType(mimeType)), (String)".")) {
                            name = StringUtils.chomp((String)name, (String)".");
                        }
                        rd.setFileName((String)name);
                    }
                    name = googleFile.entrySet().iterator();
                    while (name.hasNext()) {
                        entry = (Map.Entry)name.next();
                        rd.addField((String)entry.getKey(), entry.getValue().toString());
                    }
                    t = new DocumentReadingThread((String)documentURI);
                    try {
                        t.start();
                        wasInterrupted = false;
                        try {
                            is = t.getSafeInputStream();
                            try {
                                sourcePath = new ArrayList<String>();
                                sourcePath.add(fullContentPath);
                                rd.setSourcePath(sourcePath);
                                rd.setBinary(is, fileLength);
                                activities.ingestDocumentWithException(nodeId, version, (String)documentURI, rd);
                            }
                            finally {
                                is.close();
                            }
                        }
                        catch (ManifoldCFException e) {
                            if (e.getErrorCode() == 2) {
                                wasInterrupted = true;
                            }
                            throw e;
                        }
                        catch (SocketTimeoutException e) {
                            throw e;
                        }
                        catch (InterruptedIOException e) {
                            wasInterrupted = true;
                            throw e;
                        }
                        finally {
                            if (!wasInterrupted) {
                                t.finishUp();
                            }
                        }
                        fileSize = new Long(fileLength);
                        errorCode = "OK";
                        break block75;
                    }
                    catch (InterruptedException e) {
                        t.interrupt();
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (SocketTimeoutException e) {
                        Logging.connectors.warn((Object)("GOOGLEDRIVE: Socket timeout reading document: " + e.getMessage()), (Throwable)e);
                        GoogleDriveRepositoryConnector.handleIOException(e);
                        break block75;
                    }
                    catch (InterruptedIOException e) {
                        t.interrupt();
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
                    }
                    catch (IOException e) {
                        errorCode = "IOEXCEPTION";
                        errorDesc = e.getMessage();
                        Logging.connectors.warn((Object)("GOOGLEDRIVE: Error reading document: " + e.getMessage()), (Throwable)e);
                        GoogleDriveRepositoryConnector.handleIOException(e);
                        break block75;
                    }
lbl254:
                    // 1 sources

                    errorCode = "NOLENGTH";
                    errorDesc = "Document " + nodeId + " had no length; skipping";
                }
                catch (Throwable var41_59) {
                    if (doLog && errorCode != null) {
                        activities.recordActivity(new Long(startTime), "read document", fileSize, nodeId, errorCode, (String)errorDesc, null);
                    }
                    throw var41_59;
                }
            }
            if (!doLog || errorCode == null) continue;
            activities.recordActivity(new Long(startTime), "read document", fileSize, nodeId, errorCode, (String)errorDesc, null);
        }
    }

    private String getFixedMimeType(String mimeType) {
        switch (mimeType) {
            case "application/vnd.google-apps.spreadsheet": {
                return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            }
            case "application/vnd.google-apps.document": {
                return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            }
            case "application/vnd.google-apps.presentation": {
                return "application/vnd.openxmlformats-officedocument.presentationml.presentation";
            }
        }
        return mimeType;
    }

    private String getExtensionByMimeType(String mimeType) {
        switch (mimeType) {
            case "application/vnd.google-apps.spreadsheet": {
                return "xlsx";
            }
            case "application/vnd.google-apps.document": {
                return "docx";
            }
            case "application/vnd.google-apps.presentation": {
                return "pptx";
            }
        }
        return null;
    }

    private String getDocumentContentPath(File googleFile, String documentURI) {
        String fullContentPath = null;
        try {
            if (!this.isDir(googleFile)) {
                if (googleFile.getParents() != null && !googleFile.getParents().isEmpty()) {
                    Object name;
                    String parentRef = (String)googleFile.getParents().get(0);
                    File parent = this.getObject(parentRef);
                    String path = this.getFilePath(parent);
                    String title = this.cleanupFileFolderName(googleFile.getName());
                    String extension = googleFile.getFileExtension();
                    if (extension != null) {
                        if (title == null) {
                            title = "";
                        }
                        name = StringUtils.endsWithIgnoreCase((String)title, (String)("." + extension)) ? title : title + "." + extension;
                    } else {
                        if (title == null) {
                            title = "";
                        }
                        name = title + "." + this.getExtensionByMimeType(googleFile.getMimeType());
                    }
                    if (StringUtils.endsWithIgnoreCase((String)name, (String)".")) {
                        name = StringUtils.chomp((String)name, (String)".");
                    }
                    fullContentPath = path + this.SLASH + StringUtils.trim((String)name);
                }
            } else {
                String path = this.getFilePath(googleFile);
                String name = this.cleanupFileFolderName(googleFile.getName());
                fullContentPath = path + this.SLASH + name;
            }
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
        }
        catch (ServiceInterruption e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fullContentPath;
    }

    private String getFilePath(File file) throws IOException, ManifoldCFException, ServiceInterruption {
        Object folderPath = "";
        String fullFilePath = null;
        List parentReferencesList = file.getParents();
        ArrayList<String> folderList = new ArrayList<String>();
        List<String> finalFolderList = this.getfoldersList(parentReferencesList, folderList);
        Collections.reverse(finalFolderList);
        for (String folder : finalFolderList) {
            folderPath = (String)folderPath + "/" + folder;
        }
        fullFilePath = (String)folderPath + "/" + this.cleanupFileFolderName(file.getName());
        return fullFilePath;
    }

    private List<String> getfoldersList(List<String> parentReferencesList, List<String> folderList) throws IOException, ManifoldCFException, ServiceInterruption {
        for (int i = 0; parentReferencesList != null && i < parentReferencesList.size(); ++i) {
            String id = parentReferencesList.get(i);
            File file = this.getObject(id);
            folderList.add(this.cleanupFileFolderName(file.getName()));
            if (file.getParents() == null || file.getParents().isEmpty()) continue;
            List parentReferenceslist2 = file.getParents();
            this.getfoldersList(parentReferenceslist2, folderList);
        }
        return folderList;
    }

    protected static String getUrl(File googleFile, String exportType) {
        if (googleFile.containsKey((Object)"fileSize")) {
            return googleFile.getWebContentLink();
        }
        return googleFile.getExportLinks() != null ? (String)googleFile.getExportLinks().get(exportType) : null;
    }

    protected static String[] getAcls(Specification spec) {
        HashSet<String> map = new HashSet<String>();
        for (int i = 0; i < spec.getChildCount(); ++i) {
            SpecificationNode sn = spec.getChild(i);
            if (!sn.getType().equals(JOB_ACCESS_NODE_TYPE)) continue;
            String token = sn.getAttributeValue(JOB_TOKEN_ATTRIBUTE);
            map.add(token);
        }
        String[] rval = new String[map.size()];
        Iterator iter = map.iterator();
        int i = 0;
        while (iter.hasNext()) {
            rval[i++] = (String)iter.next();
        }
        return rval;
    }

    private boolean isDir(File f) {
        return f.getMimeType().compareToIgnoreCase("application/vnd.google-apps.folder") == 0;
    }

    private static void handleIOException(IOException e) throws ManifoldCFException, ServiceInterruption {
        if (!(e instanceof SocketTimeoutException) && e instanceof InterruptedIOException) {
            throw new ManifoldCFException("Interrupted: " + e.getMessage(), (Throwable)e, 2);
        }
        long currentTime = System.currentTimeMillis();
        throw new ServiceInterruption("IO exception: " + e.getMessage(), (Throwable)e, currentTime + 300000L, currentTime + 10800000L, -1, false);
    }

    private static void handleGeneralSecurityException(GeneralSecurityException e) throws ManifoldCFException, ServiceInterruption {
        throw new ManifoldCFException("GoogleDrive exception: " + e.getMessage(), (Throwable)e);
    }

    private String cleanupFileFolderName(String name) {
        name = name.trim();
        if (StringUtils.endsWithIgnoreCase((String)(name = name.replaceAll("[\\\\/:*?\"<>%|]", "_")), (String)".")) {
            name = StringUtils.chomp((String)name, (String)".");
        }
        return name;
    }

    protected class GetChildrenThread
    extends Thread {
        protected Throwable exception = null;
        protected final String nodeId;
        protected final XThreadStringBuffer childBuffer;

        public GetChildrenThread(String nodeId) {
            this.nodeId = nodeId;
            this.childBuffer = new XThreadStringBuffer();
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                GoogleDriveRepositoryConnector.this.session.getChildren(this.childBuffer, this.nodeId);
            }
            catch (Throwable e) {
                this.exception = e;
            }
            finally {
                this.childBuffer.signalDone();
            }
        }

        public XThreadStringBuffer getBuffer() {
            return this.childBuffer;
        }

        public void finishUp() throws InterruptedException, IOException {
            this.childBuffer.abandon();
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unhandled exception of type: " + thr.getClass().getName(), thr);
            }
        }
    }

    protected class DocumentReadingThread
    extends Thread {
        protected Throwable exception = null;
        protected final String fileURL;
        protected final XThreadInputStream stream;

        public DocumentReadingThread(String fileURL) {
            this.fileURL = fileURL;
            this.stream = new XThreadInputStream();
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                GoogleDriveRepositoryConnector.this.session.getGoogleDriveOutputStream(this.stream, this.fileURL);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public InputStream getSafeInputStream() {
            return this.stream;
        }

        public void finishUp() throws InterruptedException, IOException {
            this.stream.abort();
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unhandled exception of type: " + thr.getClass().getName(), thr);
            }
        }
    }

    protected class GetObjectThread
    extends Thread {
        protected final String nodeId;
        protected Throwable exception = null;
        protected File response = null;

        public GetObjectThread(String nodeId) {
            this.setDaemon(true);
            this.nodeId = nodeId;
        }

        @Override
        public void run() {
            try {
                this.response = GoogleDriveRepositoryConnector.this.session.getObject(this.nodeId);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public File getResponse() {
            return this.response;
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected class GetSeedsThread
    extends Thread {
        protected Throwable exception = null;
        protected final String googleDriveQuery;
        protected final XThreadStringBuffer seedBuffer;

        public GetSeedsThread(String googleDriveQuery) {
            this.googleDriveQuery = googleDriveQuery;
            this.seedBuffer = new XThreadStringBuffer();
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                GoogleDriveRepositoryConnector.this.session.getSeeds(this.seedBuffer, this.googleDriveQuery);
            }
            catch (Throwable e) {
                this.exception = e;
            }
            finally {
                this.seedBuffer.signalDone();
            }
        }

        public XThreadStringBuffer getBuffer() {
            return this.seedBuffer;
        }

        public void finishUp() throws InterruptedException, IOException {
            this.seedBuffer.abandon();
            this.join();
            Throwable thr = this.exception;
            if (thr != null) {
                if (thr instanceof IOException) {
                    throw (IOException)thr;
                }
                if (thr instanceof RuntimeException) {
                    throw (RuntimeException)thr;
                }
                if (thr instanceof Error) {
                    throw (Error)thr;
                }
                throw new RuntimeException("Unhandled exception of type: " + thr.getClass().getName(), thr);
            }
        }
    }

    protected class GetSessionThread
    extends Thread {
        protected Throwable exception = null;

        public GetSessionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                GoogleDriveRepositoryConnector.this.session = new GoogleDriveSession(GoogleDriveRepositoryConnector.this.clientid, GoogleDriveRepositoryConnector.this.clientsecret, GoogleDriveRepositoryConnector.this.refreshtoken);
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected class CheckConnectionThread
    extends Thread {
        protected Throwable exception = null;

        public CheckConnectionThread() {
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                GoogleDriveRepositoryConnector.this.session.getRepositoryInfo();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }
}

